# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhci.aio import AzureStackHCIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIDeploymentSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_clusters(self, resource_group):
        response = self.client.deployment_settings.list_by_clusters(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.deployment_settings.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            deployment_settings_name="default",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.deployment_settings.begin_create_or_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                resource={
                    "arcNodeResourceIds": ["str"],
                    "deploymentConfiguration": {
                        "scaleUnits": [
                            {
                                "deploymentData": {
                                    "adouPath": "str",
                                    "cluster": {
                                        "azureServiceEndpoint": "str",
                                        "cloudAccountName": "str",
                                        "name": "str",
                                        "witnessPath": "str",
                                        "witnessType": "str",
                                    },
                                    "domainFqdn": "str",
                                    "hostNetwork": {
                                        "enableStorageAutoIp": False,
                                        "intents": [
                                            {
                                                "adapter": ["str"],
                                                "adapterPropertyOverrides": {
                                                    "jumboPacket": "str",
                                                    "networkDirect": "str",
                                                    "networkDirectTechnology": "str",
                                                },
                                                "name": "str",
                                                "overrideAdapterProperty": False,
                                                "overrideQosPolicy": False,
                                                "overrideVirtualSwitchConfiguration": False,
                                                "qosPolicyOverrides": {
                                                    "bandwidthPercentage_SMB": "str",
                                                    "priorityValue8021Action_Cluster": "str",
                                                    "priorityValue8021Action_SMB": "str",
                                                },
                                                "trafficType": ["str"],
                                                "virtualSwitchConfigurationOverrides": {
                                                    "enableIov": "str",
                                                    "loadBalancingAlgorithm": "str",
                                                },
                                            }
                                        ],
                                        "storageConnectivitySwitchless": False,
                                        "storageNetworks": [
                                            {
                                                "name": "str",
                                                "networkAdapterName": "str",
                                                "storageAdapterIPInfo": [
                                                    {"ipv4Address": "str", "physicalNode": "str", "subnetMask": "str"}
                                                ],
                                                "vlanId": "str",
                                            }
                                        ],
                                    },
                                    "infrastructureNetwork": [
                                        {
                                            "dnsServers": ["str"],
                                            "gateway": "str",
                                            "ipPools": [{"endingAddress": "str", "startingAddress": "str"}],
                                            "subnetMask": "str",
                                            "useDhcp": bool,
                                        }
                                    ],
                                    "namingPrefix": "str",
                                    "observability": {
                                        "episodicDataUpload": True,
                                        "euLocation": False,
                                        "streamingDataClient": True,
                                    },
                                    "optionalServices": {"customLocation": "str"},
                                    "physicalNodes": [{"ipv4Address": "str", "name": "str"}],
                                    "sdnIntegration": {
                                        "networkController": {
                                            "macAddressPoolStart": "str",
                                            "macAddressPoolStop": "str",
                                            "networkVirtualizationEnabled": bool,
                                        }
                                    },
                                    "secrets": [{"eceSecretName": "str", "secretLocation": "str", "secretName": "str"}],
                                    "secretsLocation": "str",
                                    "securitySettings": {
                                        "bitlockerBootVolume": True,
                                        "bitlockerDataVolumes": True,
                                        "credentialGuardEnforced": False,
                                        "driftControlEnforced": True,
                                        "drtmProtection": True,
                                        "hvciProtection": True,
                                        "sideChannelMitigationEnforced": True,
                                        "smbClusterEncryption": False,
                                        "smbSigningEnforced": True,
                                        "wdacEnforced": True,
                                    },
                                    "storage": {"configurationMode": "Express"},
                                },
                                "sbePartnerInfo": {
                                    "credentialList": [
                                        {"eceSecretName": "str", "secretLocation": "str", "secretName": "str"}
                                    ],
                                    "partnerProperties": [{"name": "str", "value": "str"}],
                                    "sbeDeploymentInfo": {
                                        "family": "str",
                                        "publisher": "str",
                                        "sbeManifestCreationDate": "2020-02-20 00:00:00",
                                        "sbeManifestSource": "str",
                                        "version": "str",
                                    },
                                },
                            }
                        ],
                        "version": "str",
                    },
                    "deploymentMode": "Deploy",
                    "id": "str",
                    "name": "str",
                    "operationType": "ClusterProvisioning",
                    "provisioningState": "str",
                    "reportedProperties": {
                        "deploymentStatus": {
                            "status": "str",
                            "steps": [
                                {
                                    "description": "str",
                                    "endTimeUtc": "str",
                                    "exception": ["str"],
                                    "fullStepIndex": "str",
                                    "name": "str",
                                    "startTimeUtc": "str",
                                    "status": "str",
                                    "steps": [...],
                                }
                            ],
                        },
                        "validationStatus": {
                            "status": "str",
                            "steps": [
                                {
                                    "description": "str",
                                    "endTimeUtc": "str",
                                    "exception": ["str"],
                                    "fullStepIndex": "str",
                                    "name": "str",
                                    "startTimeUtc": "str",
                                    "status": "str",
                                    "steps": [...],
                                }
                            ],
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                deployment_settings_name="default",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.deployment_settings.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                deployment_settings_name="default",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
