# pylint: disable=too-many-lines, R0914
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import sys
from typing import Any, AsyncIterator, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, cast, overload
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ...operations._operations import (
    build_route_get_route_directions_batch_request,
    build_route_get_route_directions_request,
    build_route_get_route_directions_with_additional_parameters_request,
    build_route_get_route_matrix_request,
    build_route_get_route_range_request,
    build_route_request_route_directions_batch_request,
    build_route_request_route_directions_batch_sync_request,
    build_route_request_route_matrix_request,
    build_route_request_route_matrix_sync_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class RouteOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.maps.route.aio.MapsRouteClient`'s
        :attr:`route` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _request_route_matrix_initial(
        self,
        route_matrix_query: Union[_models.RouteMatrixQuery, IO[bytes]],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_matrix_query, (IOBase, bytes)):
            _content = route_matrix_query
        else:
            _json = self._serialize.body(route_matrix_query, "RouteMatrixQuery")

        _request = build_route_request_route_matrix_request(
            format=format,
            wait_for_results=wait_for_results,
            compute_travel_time=compute_travel_time,
            filter_section_type=filter_section_type,
            arrive_at=arrive_at,
            depart_at=depart_at,
            vehicle_axle_weight=vehicle_axle_weight,
            vehicle_length=vehicle_length,
            vehicle_height=vehicle_height,
            vehicle_width=vehicle_width,
            vehicle_max_speed=vehicle_max_speed,
            vehicle_weight=vehicle_weight,
            windingness=windingness,
            incline_level=incline_level,
            travel_mode=travel_mode,
            avoid=avoid,
            use_traffic_data=use_traffic_data,
            route_type=route_type,
            vehicle_load_type=vehicle_load_type,
            client_id=self._config.client_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_request_route_matrix(
        self,
        route_matrix_query: _models.RouteMatrixQuery,
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteMatrixResult]:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Matrix Routing service allows calculation of a matrix of route summaries for a set of
        routes defined by origin and destination locations by using an asynchronous (async) or
        synchronous (sync) POST request. For every given origin, the service calculates the cost of
        routing from that origin to every given destination. The set of origins and the set of
        destinations can be thought of as the column and row headers of a table and each cell in the
        table contains the costs of routing from the origin to the destination for that cell. As an
        example, let's say a food delivery company has 20 drivers and they need to find the closest
        driver to pick up the delivery from the restaurant. To solve this use case, they can call
        Matrix Route API.

        For each route, the travel times and distances are returned. You can use the computed costs to
        determine which detailed routes to calculate using the Route Directions API.

        The maximum size of a matrix for async request is **700** and for sync request it's **100**
        (the number of origins multiplied by the number of destinations).

        Submit Synchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        If your scenario requires synchronous requests and the maximum size of the matrix is less than
        or equal to 100, you might want to make synchronous request. The maximum size of a matrix for
        this API is **100** (the number of origins multiplied by the number of destinations). With that
        constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not
        need to be square).

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex routing
        requests. When you make a request by using async request, by default the service returns a 202
        response code along a redirect URL in the Location field of the response header. This URL
        should be checked periodically until the response data or error information is available. If
        ``waitForResults`` parameter in the request is set to true, user will get a 200 response if the
        request is finished under 120 seconds.

        The maximum size of a matrix for this API is **700** (the number of origins multiplied by the
        number of destinations). With that constraint in mind, examples of possible matrix dimensions
        are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).

        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&subscription-key={subscription-key}

        Here's a typical sequence of asynchronous operations:


        #.
           Client sends a Route Matrix POST request to Azure Maps

        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` -  Route Matrix request has been accepted.

              HTTP ``Error`` - There was an error processing your Route Matrix request. This could
        either be a 400 Bad Request or any other Error status code.



        #.
           If the Matrix Route request was accepted successfully, the Location header in the response
        contains the URL to download the results of the request. This status URI looks like the
        following:

           .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
        again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
        the results.

        :param route_matrix_query: The matrix of origin and destination coordinates to compute the
         route distance, travel time and other summary for each cell of the matrix based on the input
         parameters. The minimum and the maximum cell count supported are 1 and **700** for async and
         **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25
         origins and 25 destinations for async API. Required.
        :type route_matrix_query: ~azure.maps.route.models.RouteMatrixQuery
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword wait_for_results: Boolean to indicate whether to execute the request synchronously. If
         set to true, user will get a 200 response if the request is finished under 120 seconds.
         Otherwise, user will get a 202 response right away. Please refer to the API description for
         more details on 202 response. **Supported only for async request**. Default value is None.
        :paramtype wait_for_results: bool
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms. Default value is 0.
        :paramtype vehicle_weight: int
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RouteMatrixResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteMatrixResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_request_route_matrix(
        self,
        route_matrix_query: IO[bytes],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteMatrixResult]:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Matrix Routing service allows calculation of a matrix of route summaries for a set of
        routes defined by origin and destination locations by using an asynchronous (async) or
        synchronous (sync) POST request. For every given origin, the service calculates the cost of
        routing from that origin to every given destination. The set of origins and the set of
        destinations can be thought of as the column and row headers of a table and each cell in the
        table contains the costs of routing from the origin to the destination for that cell. As an
        example, let's say a food delivery company has 20 drivers and they need to find the closest
        driver to pick up the delivery from the restaurant. To solve this use case, they can call
        Matrix Route API.

        For each route, the travel times and distances are returned. You can use the computed costs to
        determine which detailed routes to calculate using the Route Directions API.

        The maximum size of a matrix for async request is **700** and for sync request it's **100**
        (the number of origins multiplied by the number of destinations).

        Submit Synchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        If your scenario requires synchronous requests and the maximum size of the matrix is less than
        or equal to 100, you might want to make synchronous request. The maximum size of a matrix for
        this API is **100** (the number of origins multiplied by the number of destinations). With that
        constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not
        need to be square).

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex routing
        requests. When you make a request by using async request, by default the service returns a 202
        response code along a redirect URL in the Location field of the response header. This URL
        should be checked periodically until the response data or error information is available. If
        ``waitForResults`` parameter in the request is set to true, user will get a 200 response if the
        request is finished under 120 seconds.

        The maximum size of a matrix for this API is **700** (the number of origins multiplied by the
        number of destinations). With that constraint in mind, examples of possible matrix dimensions
        are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).

        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&subscription-key={subscription-key}

        Here's a typical sequence of asynchronous operations:


        #.
           Client sends a Route Matrix POST request to Azure Maps

        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` -  Route Matrix request has been accepted.

              HTTP ``Error`` - There was an error processing your Route Matrix request. This could
        either be a 400 Bad Request or any other Error status code.



        #.
           If the Matrix Route request was accepted successfully, the Location header in the response
        contains the URL to download the results of the request. This status URI looks like the
        following:

           .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
        again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
        the results.

        :param route_matrix_query: The matrix of origin and destination coordinates to compute the
         route distance, travel time and other summary for each cell of the matrix based on the input
         parameters. The minimum and the maximum cell count supported are 1 and **700** for async and
         **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25
         origins and 25 destinations for async API. Required.
        :type route_matrix_query: IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword wait_for_results: Boolean to indicate whether to execute the request synchronously. If
         set to true, user will get a 200 response if the request is finished under 120 seconds.
         Otherwise, user will get a 202 response right away. Please refer to the API description for
         more details on 202 response. **Supported only for async request**. Default value is None.
        :paramtype wait_for_results: bool
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms. Default value is 0.
        :paramtype vehicle_weight: int
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RouteMatrixResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteMatrixResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_request_route_matrix(
        self,
        route_matrix_query: Union[_models.RouteMatrixQuery, IO[bytes]],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteMatrixResult]:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Matrix Routing service allows calculation of a matrix of route summaries for a set of
        routes defined by origin and destination locations by using an asynchronous (async) or
        synchronous (sync) POST request. For every given origin, the service calculates the cost of
        routing from that origin to every given destination. The set of origins and the set of
        destinations can be thought of as the column and row headers of a table and each cell in the
        table contains the costs of routing from the origin to the destination for that cell. As an
        example, let's say a food delivery company has 20 drivers and they need to find the closest
        driver to pick up the delivery from the restaurant. To solve this use case, they can call
        Matrix Route API.

        For each route, the travel times and distances are returned. You can use the computed costs to
        determine which detailed routes to calculate using the Route Directions API.

        The maximum size of a matrix for async request is **700** and for sync request it's **100**
        (the number of origins multiplied by the number of destinations).

        Submit Synchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        If your scenario requires synchronous requests and the maximum size of the matrix is less than
        or equal to 100, you might want to make synchronous request. The maximum size of a matrix for
        this API is **100** (the number of origins multiplied by the number of destinations). With that
        constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not
        need to be square).

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex routing
        requests. When you make a request by using async request, by default the service returns a 202
        response code along a redirect URL in the Location field of the response header. This URL
        should be checked periodically until the response data or error information is available. If
        ``waitForResults`` parameter in the request is set to true, user will get a 200 response if the
        request is finished under 120 seconds.

        The maximum size of a matrix for this API is **700** (the number of origins multiplied by the
        number of destinations). With that constraint in mind, examples of possible matrix dimensions
        are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).

        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&subscription-key={subscription-key}

        Here's a typical sequence of asynchronous operations:


        #. Client sends a Route Matrix POST request to Azure Maps

        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` -  Route Matrix request has been accepted.

              HTTP ``Error`` - There was an error processing your Route Matrix request. This could
              either be a 400 Bad Request or any other Error status code.



        #. If the Matrix Route request was accepted successfully, the Location header in the response
           contains the URL to download the results of the request. This status URI looks like the
           following:

           .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
           again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
           the results.

        :param route_matrix_query: The matrix of origin and destination coordinates to compute the
         route distance, travel time and other summary for each cell of the matrix based on the input
         parameters. The minimum and the maximum cell count supported are 1 and **700** for async and
         **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25
         origins and 25 destinations for async API. Is either a RouteMatrixQuery type or a IO[bytes]
         type. Required.
        :type route_matrix_query: ~azure.maps.route.models.RouteMatrixQuery or IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword wait_for_results: Boolean to indicate whether to execute the request synchronously. If
         set to true, user will get a 200 response if the request is finished under 120 seconds.
         Otherwise, user will get a 202 response right away. Please refer to the API description for
         more details on 202 response. **Supported only for async request**. Default value is None.
        :paramtype wait_for_results: bool
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms. Default value is 0.
        :paramtype vehicle_weight: int
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :return: An instance of AsyncLROPoller that returns RouteMatrixResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteMatrixResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteMatrixResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._request_route_matrix_initial(
                route_matrix_query=route_matrix_query,
                format=format,
                wait_for_results=wait_for_results,
                compute_travel_time=compute_travel_time,
                filter_section_type=filter_section_type,
                arrive_at=arrive_at,
                depart_at=depart_at,
                vehicle_axle_weight=vehicle_axle_weight,
                vehicle_length=vehicle_length,
                vehicle_height=vehicle_height,
                vehicle_width=vehicle_width,
                vehicle_max_speed=vehicle_max_speed,
                vehicle_weight=vehicle_weight,
                windingness=windingness,
                incline_level=incline_level,
                travel_mode=travel_mode,
                avoid=avoid,
                use_traffic_data=use_traffic_data,
                route_type=route_type,
                vehicle_load_type=vehicle_load_type,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteMatrixResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteMatrixResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteMatrixResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_route_matrix_initial(self, matrix_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_route_get_route_matrix_request(
            matrix_id=matrix_id,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_route_matrix(self, matrix_id: str, **kwargs: Any) -> AsyncLROPoller[_models.RouteMatrixResult]:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        If the Matrix Route request was accepted successfully, the Location header in the response
        contains the URL to download the results of the request. This status URI looks like the
        following:

        .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
           again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
           the results.

        :param matrix_id: Matrix id received after the Matrix Route request was accepted successfully.
         Required.
        :type matrix_id: str
        :return: An instance of AsyncLROPoller that returns RouteMatrixResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteMatrixResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouteMatrixResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_route_matrix_initial(
                matrix_id=matrix_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteMatrixResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "original-uri"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteMatrixResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteMatrixResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def request_route_matrix_sync(
        self,
        route_matrix_query: _models.RouteMatrixQuery,
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RouteMatrixResult:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Matrix Routing service allows calculation of a matrix of route summaries for a set of
        routes defined by origin and destination locations by using an asynchronous (async) or
        synchronous (sync) POST request. For every given origin, the service calculates the cost of
        routing from that origin to every given destination. The set of origins and the set of
        destinations can be thought of as the column and row headers of a table and each cell in the
        table contains the costs of routing from the origin to the destination for that cell. As an
        example, let's say a food delivery company has 20 drivers and they need to find the closest
        driver to pick up the delivery from the restaurant. To solve this use case, they can call
        Matrix Route API.

        For each route, the travel times and distances are returned. You can use the computed costs to
        determine which detailed routes to calculate using the Route Directions API.

        The maximum size of a matrix for async request is **700** and for sync request it's **100**
        (the number of origins multiplied by the number of destinations).

        Submit Synchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        If your scenario requires synchronous requests and the maximum size of the matrix is less than
        or equal to 100, you might want to make synchronous request. The maximum size of a matrix for
        this API is **100** (the number of origins multiplied by the number of destinations). With that
        constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not
        need to be square).

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex routing
        requests. When you make a request by using async request, by default the service returns a 202
        response code along a redirect URL in the Location field of the response header. This URL
        should be checked periodically until the response data or error information is available. If
        ``waitForResults`` parameter in the request is set to true, user will get a 200 response if the
        request is finished under 120 seconds.

        The maximum size of a matrix for this API is **700** (the number of origins multiplied by the
        number of destinations). With that constraint in mind, examples of possible matrix dimensions
        are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).

        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&subscription-key={subscription-key}

        Here's a typical sequence of asynchronous operations:


        #. Client sends a Route Matrix POST request to Azure Maps

        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` -  Route Matrix request has been accepted.

              HTTP ``Error`` - There was an error processing your Route Matrix request. This could
              either be a 400 Bad Request or any other Error status code.



        #. If the Matrix Route request was accepted successfully, the Location header in the response
           contains the URL to download the results of the request. This status URI looks like the
           following:

           .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
           again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
           the results.

        :param route_matrix_query: The matrix of origin and destination coordinates to compute the
         route distance, travel time and other summary for each cell of the matrix based on the input
         parameters. The minimum and the maximum cell count supported are 1 and **700** for async and
         **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25
         origins and 25 destinations for async API. Required.
        :type route_matrix_query: ~azure.maps.route.models.RouteMatrixQuery
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword wait_for_results: Boolean to indicate whether to execute the request synchronously. If
         set to true, user will get a 200 response if the request is finished under 120 seconds.
         Otherwise, user will get a 202 response right away. Please refer to the API description for
         more details on 202 response. **Supported only for async request**. Default value is None.
        :paramtype wait_for_results: bool
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms. Default value is 0.
        :paramtype vehicle_weight: int
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RouteMatrixResult
        :rtype: ~azure.maps.route.models.RouteMatrixResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def request_route_matrix_sync(
        self,
        route_matrix_query: IO[bytes],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RouteMatrixResult:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Matrix Routing service allows calculation of a matrix of route summaries for a set of
        routes defined by origin and destination locations by using an asynchronous (async) or
        synchronous (sync) POST request. For every given origin, the service calculates the cost of
        routing from that origin to every given destination. The set of origins and the set of
        destinations can be thought of as the column and row headers of a table and each cell in the
        table contains the costs of routing from the origin to the destination for that cell. As an
        example, let's say a food delivery company has 20 drivers and they need to find the closest
        driver to pick up the delivery from the restaurant. To solve this use case, they can call
        Matrix Route API.

        For each route, the travel times and distances are returned. You can use the computed costs to
        determine which detailed routes to calculate using the Route Directions API.

        The maximum size of a matrix for async request is **700** and for sync request it's **100**
        (the number of origins multiplied by the number of destinations).

        Submit Synchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        If your scenario requires synchronous requests and the maximum size of the matrix is less than
        or equal to 100, you might want to make synchronous request. The maximum size of a matrix for
        this API is **100** (the number of origins multiplied by the number of destinations). With that
        constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not
        need to be square).

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex routing
        requests. When you make a request by using async request, by default the service returns a 202
        response code along a redirect URL in the Location field of the response header. This URL
        should be checked periodically until the response data or error information is available. If
        ``waitForResults`` parameter in the request is set to true, user will get a 200 response if the
        request is finished under 120 seconds.

        The maximum size of a matrix for this API is **700** (the number of origins multiplied by the
        number of destinations). With that constraint in mind, examples of possible matrix dimensions
        are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).

        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&subscription-key={subscription-key}

        Here's a typical sequence of asynchronous operations:


        #. Client sends a Route Matrix POST request to Azure Maps

        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` -  Route Matrix request has been accepted.

              HTTP ``Error`` - There was an error processing your Route Matrix request. This could
              either be a 400 Bad Request or any other Error status code.



        #. If the Matrix Route request was accepted successfully, the Location header in the response
           contains the URL to download the results of the request. This status URI looks like the
           following:

           .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
           again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
           the results.

        :param route_matrix_query: The matrix of origin and destination coordinates to compute the
         route distance, travel time and other summary for each cell of the matrix based on the input
         parameters. The minimum and the maximum cell count supported are 1 and **700** for async and
         **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25
         origins and 25 destinations for async API. Required.
        :type route_matrix_query: IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword wait_for_results: Boolean to indicate whether to execute the request synchronously. If
         set to true, user will get a 200 response if the request is finished under 120 seconds.
         Otherwise, user will get a 202 response right away. Please refer to the API description for
         more details on 202 response. **Supported only for async request**. Default value is None.
        :paramtype wait_for_results: bool
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms. Default value is 0.
        :paramtype vehicle_weight: int
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RouteMatrixResult
        :rtype: ~azure.maps.route.models.RouteMatrixResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def request_route_matrix_sync(
        self,
        route_matrix_query: Union[_models.RouteMatrixQuery, IO[bytes]],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        wait_for_results: Optional[bool] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        **kwargs: Any
    ) -> _models.RouteMatrixResult:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Matrix Routing service allows calculation of a matrix of route summaries for a set of
        routes defined by origin and destination locations by using an asynchronous (async) or
        synchronous (sync) POST request. For every given origin, the service calculates the cost of
        routing from that origin to every given destination. The set of origins and the set of
        destinations can be thought of as the column and row headers of a table and each cell in the
        table contains the costs of routing from the origin to the destination for that cell. As an
        example, let's say a food delivery company has 20 drivers and they need to find the closest
        driver to pick up the delivery from the restaurant. To solve this use case, they can call
        Matrix Route API.

        For each route, the travel times and distances are returned. You can use the computed costs to
        determine which detailed routes to calculate using the Route Directions API.

        The maximum size of a matrix for async request is **700** and for sync request it's **100**
        (the number of origins multiplied by the number of destinations).

        Submit Synchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        If your scenario requires synchronous requests and the maximum size of the matrix is less than
        or equal to 100, you might want to make synchronous request. The maximum size of a matrix for
        this API is **100** (the number of origins multiplied by the number of destinations). With that
        constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not
        need to be square).

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Route Matrix Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex routing
        requests. When you make a request by using async request, by default the service returns a 202
        response code along a redirect URL in the Location field of the response header. This URL
        should be checked periodically until the response data or error information is available. If
        ``waitForResults`` parameter in the request is set to true, user will get a 200 response if the
        request is finished under 120 seconds.

        The maximum size of a matrix for this API is **700** (the number of origins multiplied by the
        number of destinations). With that constraint in mind, examples of possible matrix dimensions
        are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).

        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        .. code-block::

           POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&subscription-key={subscription-key}

        Here's a typical sequence of asynchronous operations:


        #. Client sends a Route Matrix POST request to Azure Maps

        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` -  Route Matrix request has been accepted.

              HTTP ``Error`` - There was an error processing your Route Matrix request. This could
              either be a 400 Bad Request or any other Error status code.



        #. If the Matrix Route request was accepted successfully, the Location header in the response
           contains the URL to download the results of the request. This status URI looks like the
           following:

           .. code-block::

               GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}


        #. Client issues a GET request on the download URL obtained in Step 3 to download the results

        Download Sync Results
        ^^^^^^^^^^^^^^^^^^^^^

        When you make a POST request for Route Matrix Sync API, the service returns 200 response code
        for successful request and a response array. The response body will contain the data and there
        will be no possibility to retrieve the results later.

        Download Async Results
        ^^^^^^^^^^^^^^^^^^^^^^

        When a request issues a ``202 Accepted`` response, the request is being processed using our
        async pipeline. You will be given a URL to check the progress of your  async request in the
        location header of the response. This status URI looks like the following:

        .. code-block::

             GET
               https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}

        The URL provided by the location header will return the following responses when a ``GET``
        request is issued.

        ..

           HTTP ``202 Accepted`` - Matrix request was accepted but is still being processed. Please try
           again in some time.

           HTTP ``200 OK`` - Matrix request successfully processed. The response body contains all of
           the results.

        :param route_matrix_query: The matrix of origin and destination coordinates to compute the
         route distance, travel time and other summary for each cell of the matrix based on the input
         parameters. The minimum and the maximum cell count supported are 1 and **700** for async and
         **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25
         origins and 25 destinations for async API. Is either a RouteMatrixQuery type or a IO[bytes]
         type. Required.
        :type route_matrix_query: ~azure.maps.route.models.RouteMatrixQuery or IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword wait_for_results: Boolean to indicate whether to execute the request synchronously. If
         set to true, user will get a 200 response if the request is finished under 120 seconds.
         Otherwise, user will get a 202 response right away. Please refer to the API description for
         more details on 202 response. **Supported only for async request**. Default value is None.
        :paramtype wait_for_results: bool
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms. Default value is 0.
        :paramtype vehicle_weight: int
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :return: RouteMatrixResult
        :rtype: ~azure.maps.route.models.RouteMatrixResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            408: cast(
                Type[HttpResponseError],
                lambda response: HttpResponseError(
                    response=response, model=self._deserialize(_models.ErrorResponse, response)
                ),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteMatrixResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_matrix_query, (IOBase, bytes)):
            _content = route_matrix_query
        else:
            _json = self._serialize.body(route_matrix_query, "RouteMatrixQuery")

        _request = build_route_request_route_matrix_sync_request(
            format=format,
            wait_for_results=wait_for_results,
            compute_travel_time=compute_travel_time,
            filter_section_type=filter_section_type,
            arrive_at=arrive_at,
            depart_at=depart_at,
            vehicle_axle_weight=vehicle_axle_weight,
            vehicle_length=vehicle_length,
            vehicle_height=vehicle_height,
            vehicle_width=vehicle_width,
            vehicle_max_speed=vehicle_max_speed,
            vehicle_weight=vehicle_weight,
            windingness=windingness,
            incline_level=incline_level,
            travel_mode=travel_mode,
            avoid=avoid,
            use_traffic_data=use_traffic_data,
            route_type=route_type,
            vehicle_load_type=vehicle_load_type,
            client_id=self._config.client_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouteMatrixResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_route_directions(
        self,
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        route_points: str,
        max_alternatives: Optional[int] = None,
        alternative_type: Optional[Union[str, _models.AlternativeRouteType]] = None,
        min_deviation_distance: Optional[int] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        min_deviation_time: Optional[int] = None,
        instructions_type: Optional[Union[str, _models.RouteInstructionsType]] = None,
        language: Optional[str] = None,
        compute_best_waypoint_order: Optional[bool] = None,
        route_representation_for_best_order: Optional[Union[str, _models.RouteRepresentationForBestOrder]] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        vehicle_heading: Optional[int] = None,
        report: Optional[Union[str, _models.Report]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        vehicle_axle_weight: int = 0,
        vehicle_width: float = 0,
        vehicle_height: float = 0,
        vehicle_length: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        is_commercial_vehicle: bool = False,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        vehicle_engine_type: Optional[Union[str, _models.VehicleEngineType]] = None,
        constant_speed_consumption_in_liters_per_hundred_km: Optional[str] = None,
        current_fuel_in_liters: Optional[float] = None,
        auxiliary_power_in_liters_per_hour: Optional[float] = None,
        fuel_energy_density_in_megajoules_per_liter: Optional[float] = None,
        acceleration_efficiency: Optional[float] = None,
        deceleration_efficiency: Optional[float] = None,
        uphill_efficiency: Optional[float] = None,
        downhill_efficiency: Optional[float] = None,
        constant_speed_consumption_in_kw_h_per_hundred_km: Optional[str] = None,
        current_charge_in_kw_h: Optional[float] = None,
        max_charge_in_kw_h: Optional[float] = None,
        auxiliary_power_in_kw: Optional[float] = None,
        **kwargs: Any
    ) -> _models.RouteDirections:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Returns  a route between an origin and a destination, passing through waypoints if they are
        specified. The route will take into account factors such as current traffic and the typical
        road speeds on the requested day of the week and time of day.

        Information returned includes the distance, estimated travel time, and a representation of the
        route geometry. Additional routing information such as optimized waypoint order or turn by turn
        instructions is also available, depending on the options selected.

        Routing service provides a set of parameters for a detailed description of vehicle-specific
        Consumption Model. Please check `Consumption Model
        <https://learn.microsoft.com/azure/azure-maps/consumption-model>`_ for detailed explanation of
        the concepts and parameters involved.

        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.route.models.ResponseFormat
        :keyword route_points: The Coordinates through which the route is calculated, delimited by a
         colon.  A minimum of two coordinates is required.  The first one is the origin and the last is
         the destination of the route. Optional coordinates in-between act as WayPoints in the route.
         You can pass up to 150 WayPoints. Required.
        :paramtype route_points: str
        :keyword max_alternatives: Number of desired alternative routes to be calculated. Default: 0,
         minimum: 0 and maximum: 5. Default value is None.
        :paramtype max_alternatives: int
        :keyword alternative_type: Controls the optimality, with respect to the given planning
         criteria, of the calculated alternatives compared to the reference route. Known values are:
         "anyRoute" and "betterRoute". Default value is None.
        :paramtype alternative_type: str or ~azure.maps.route.models.AlternativeRouteType
        :keyword min_deviation_distance: All alternative routes returned will follow the reference
         route (see section POST Requests) from the origin point of the calculateRoute request for at
         least this number of meters. Can only be used when reconstructing a route. The
         minDeviationDistance parameter cannot be used in conjunction with arriveAt. Default value is
         None.
        :paramtype min_deviation_distance: int
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword min_deviation_time: All alternative routes returned will follow the reference route
         (see section POST Requests) from the origin point of the calculateRoute request for at least
         this number of seconds. Can only be used when reconstructing a route. The minDeviationTime
         parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting
         )minDeviationTime_ to a value greater than zero has the following consequences:


         * The origin point of the *calculateRoute* Request must be on
           (or very near) the input reference route.

           * If this is not the case, an error is returned.
           * However, the origin point does not need to be at the beginning
             of the input reference route (it can be thought of as the current
             vehicle position on the reference route).

         * The reference route, returned as the first route in the *calculateRoute*
           Response, will start at the origin point specified in the *calculateRoute*
           Request. The initial part of the input reference route up until the origin
           point will be excluded from the Response.
         * The values of *minDeviationDistance* and *minDeviationTime* determine
           how far alternative routes will be guaranteed to follow the reference
           route from the origin point onwards.
         * The route must use *departAt*.
         * The *vehicleHeading* is ignored. Default value is None.
        :paramtype min_deviation_time: int
        :keyword instructions_type: If specified, guidance instructions will be returned. Note that the
         instructionsType parameter cannot be used in conjunction with routeRepresentation=none. Known
         values are: "coded", "text", and "tagged". Default value is None.
        :paramtype instructions_type: str or ~azure.maps.route.models.RouteInstructionsType
        :keyword language: The language parameter determines the language of the guidance messages.
         Proper nouns (the names of streets, plazas, etc.) are returned in the specified  language, or
         if that is not available, they are returned in an available language  that is close to it.
         Allowed values are (a subset of) the IETF language tags. The currently supported  languages are
         listed in the `Supported languages  section
         <https://learn.microsoft.com/azure/azure-maps/supported-languages>`_.

         Default value: en-GB. Default value is None.
        :paramtype language: str
        :keyword compute_best_waypoint_order: Re-order the route waypoints using a fast heuristic
         algorithm to reduce the route length. Yields best results when used in conjunction with
         routeType *shortest*. Notice that origin and destination are excluded from the optimized
         waypoint indices. To include origin and destination in the response, please increase all the
         indices by 1 to account for the origin, and then add the destination as the final index.
         Possible values are true or false. True computes a better order if possible, but is not allowed
         to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with
         circle waypoints. False will use the locations in the given order and not allowed to be used in
         conjunction with routeRepresentation *none*. Default value is None.
        :paramtype compute_best_waypoint_order: bool
        :keyword route_representation_for_best_order: Specifies the representation of the set of routes
         provided as response. This parameter value can only be used in conjunction with
         computeBestOrder=true. Known values are: "polyline", "summaryOnly", and "none". Default value
         is None.
        :paramtype route_representation_for_best_order: str or
         ~azure.maps.route.models.RouteRepresentationForBestOrder
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword vehicle_heading: The directional heading of the vehicle in degrees starting at true
         North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is
         180 degrees, west is 270 degrees. Possible values 0-359. Default value is None.
        :paramtype vehicle_heading: int
        :keyword report: Specifies which data should be reported for diagnosis purposes. The only
         possible value is *effectiveSettings*. Reports the effective parameters or data used when
         calling the API. In the case of defaulted parameters the default will be reflected where the
         parameter was not specified by the caller. "effectiveSettings" Default value is None.
        :paramtype report: str or ~azure.maps.route.models.Report
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms.


         * It is mandatory if any of the *Efficiency parameters are set.

         * It must be strictly positive when used in the context of the Consumption Model. Weight
           restrictions are considered.

         * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is
           non-zero, then weight restrictions are considered.

         * In all other cases, this parameter is ignored.

         Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900. Default
         value is 0.
        :paramtype vehicle_weight: int
        :keyword is_commercial_vehicle: Whether the vehicle is used for commercial purposes. Commercial
         vehicles may not be allowed to drive on some roads. Default value is False.
        :paramtype is_commercial_vehicle: bool
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword vehicle_engine_type: Engine type of the vehicle. When a detailed Consumption Model is
         specified, it must be consistent with the value of **vehicleEngineType**. Known values are:
         "combustion" and "electric". Default value is None.
        :paramtype vehicle_engine_type: str or ~azure.maps.route.models.VehicleEngineType
        :keyword constant_speed_consumption_in_liters_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of colon-delimited speed & consumption-rate pairs. The list
         defines points on a consumption curve. Consumption rates for speeds not in the list are found
         as follows:


         * by linear interpolation, if the given speed lies in between two speeds in the list

         * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
           the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller speed.

         The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.

         Sensible Values : 50,6.3:130,11.5

         **Note** : This parameter is required for **The Combustion Consumption Model**. Default value
         is None.
        :paramtype constant_speed_consumption_in_liters_per_hundred_km: str
        :keyword current_fuel_in_liters: Specifies the current supply of fuel in liters.

         Sensible Values : 55. Default value is None.
        :paramtype current_fuel_in_liters: float
        :keyword auxiliary_power_in_liters_per_hour: Specifies the amount of fuel consumed for
         sustaining auxiliary systems of the vehicle, in liters per hour.

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 0.2. Default value is None.
        :paramtype auxiliary_power_in_liters_per_hour: float
        :keyword fuel_energy_density_in_megajoules_per_liter: Specifies the amount of chemical energy
         stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the
         ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For
         example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.

         This parameter is required if any ***Efficiency** parameter is set.

         Sensible Values : 34.2. Default value is None.
        :paramtype fuel_energy_density_in_megajoules_per_liter: float
        :keyword acceleration_efficiency: Specifies the efficiency of converting chemical energy stored
         in fuel to kinetic energy when the vehicle accelerates *(i.e.
         KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by converting
         consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **decelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **decelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66. Default
         value is None.
        :paramtype acceleration_efficiency: float
        :keyword deceleration_efficiency: Specifies the efficiency of converting kinetic energy to
         saved (not consumed) fuel when the vehicle decelerates *(i.e.
         ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **accelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **accelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91. Default
         value is None.
        :paramtype deceleration_efficiency: float
        :keyword uphill_efficiency: Specifies the efficiency of converting chemical energy stored in
         fuel to potential energy when the vehicle gains elevation *(i.e.
         PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by
         converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **downhillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **downhillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74. Default
         value is None.
        :paramtype uphill_efficiency: float
        :keyword downhill_efficiency: Specifies the efficiency of converting potential energy to saved
         (not consumed) fuel when the vehicle loses elevation *(i.e.
         ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **uphillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **uphillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73. Default
         value is None.
        :paramtype downhill_efficiency: float
        :keyword constant_speed_consumption_in_kw_h_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a
         consumption curve. Consumption rates for speeds not in the list are found as follows:


         * by linear interpolation, if the given speed lies in between two speeds in the list

         * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
           the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller  speed.

         The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and
         100000.0.

         Sensible Values : 50,8.2:130,21.3

         This parameter is required for **Electric consumption model**. Default value is None.
        :paramtype constant_speed_consumption_in_kw_h_per_hundred_km: str
        :keyword current_charge_in_kw_h: Specifies the current electric energy supply in kilowatt hours
         (kWh).

         This parameter co-exists with **maxChargeInkWh** parameter.

         The range of values allowed are 0.0 to **maxChargeInkWh**.

         Sensible Values : 43. Default value is None.
        :paramtype current_charge_in_kw_h: float
        :keyword max_charge_in_kw_h: Specifies the maximum electric energy supply in kilowatt hours
         (kWh) that may be stored in the vehicle's battery.

         This parameter co-exists with **currentChargeInkWh** parameter.

         Minimum value has to be greater than or equal to **currentChargeInkWh**.

         Sensible Values : 85. Default value is None.
        :paramtype max_charge_in_kw_h: float
        :keyword auxiliary_power_in_kw: Specifies the amount of power consumed for sustaining auxiliary
         systems, in kilowatts (kW).

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 1.7. Default value is None.
        :paramtype auxiliary_power_in_kw: float
        :return: RouteDirections
        :rtype: ~azure.maps.route.models.RouteDirections
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouteDirections] = kwargs.pop("cls", None)

        _request = build_route_get_route_directions_request(
            format=format,
            route_points=route_points,
            max_alternatives=max_alternatives,
            alternative_type=alternative_type,
            min_deviation_distance=min_deviation_distance,
            arrive_at=arrive_at,
            depart_at=depart_at,
            min_deviation_time=min_deviation_time,
            instructions_type=instructions_type,
            language=language,
            compute_best_waypoint_order=compute_best_waypoint_order,
            route_representation_for_best_order=route_representation_for_best_order,
            compute_travel_time=compute_travel_time,
            vehicle_heading=vehicle_heading,
            report=report,
            filter_section_type=filter_section_type,
            vehicle_axle_weight=vehicle_axle_weight,
            vehicle_width=vehicle_width,
            vehicle_height=vehicle_height,
            vehicle_length=vehicle_length,
            vehicle_max_speed=vehicle_max_speed,
            vehicle_weight=vehicle_weight,
            is_commercial_vehicle=is_commercial_vehicle,
            windingness=windingness,
            incline_level=incline_level,
            travel_mode=travel_mode,
            avoid=avoid,
            use_traffic_data=use_traffic_data,
            route_type=route_type,
            vehicle_load_type=vehicle_load_type,
            vehicle_engine_type=vehicle_engine_type,
            constant_speed_consumption_in_liters_per_hundred_km=constant_speed_consumption_in_liters_per_hundred_km,
            current_fuel_in_liters=current_fuel_in_liters,
            auxiliary_power_in_liters_per_hour=auxiliary_power_in_liters_per_hour,
            fuel_energy_density_in_megajoules_per_liter=fuel_energy_density_in_megajoules_per_liter,
            acceleration_efficiency=acceleration_efficiency,
            deceleration_efficiency=deceleration_efficiency,
            uphill_efficiency=uphill_efficiency,
            downhill_efficiency=downhill_efficiency,
            constant_speed_consumption_in_kw_h_per_hundred_km=constant_speed_consumption_in_kw_h_per_hundred_km,
            current_charge_in_kw_h=current_charge_in_kw_h,
            max_charge_in_kw_h=max_charge_in_kw_h,
            auxiliary_power_in_kw=auxiliary_power_in_kw,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouteDirections", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def get_route_directions_with_additional_parameters(  # pylint: disable=name-too-long
        self,
        route_direction_parameters: _models.RouteDirectionParameters,
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        route_points: str,
        max_alternatives: Optional[int] = None,
        alternative_type: Optional[Union[str, _models.AlternativeRouteType]] = None,
        min_deviation_distance: Optional[int] = None,
        min_deviation_time: Optional[int] = None,
        instructions_type: Optional[Union[str, _models.RouteInstructionsType]] = None,
        language: Optional[str] = None,
        compute_best_waypoint_order: Optional[bool] = None,
        route_representation_for_best_order: Optional[Union[str, _models.RouteRepresentationForBestOrder]] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        vehicle_heading: Optional[int] = None,
        report: Optional[Union[str, _models.Report]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        is_commercial_vehicle: bool = False,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        vehicle_engine_type: Optional[Union[str, _models.VehicleEngineType]] = None,
        constant_speed_consumption_in_liters_per_hundred_km: Optional[str] = None,
        current_fuel_in_liters: Optional[float] = None,
        auxiliary_power_in_liters_per_hour: Optional[float] = None,
        fuel_energy_density_in_megajoules_per_liter: Optional[float] = None,
        acceleration_efficiency: Optional[float] = None,
        deceleration_efficiency: Optional[float] = None,
        uphill_efficiency: Optional[float] = None,
        downhill_efficiency: Optional[float] = None,
        constant_speed_consumption_in_kw_h_per_hundred_km: Optional[str] = None,
        current_charge_in_kw_h: Optional[float] = None,
        max_charge_in_kw_h: Optional[float] = None,
        auxiliary_power_in_kw: Optional[float] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RouteDirections:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Returns  a route between an origin and a destination, passing through waypoints if they are
        specified. The route will take into account factors such as current traffic and the typical
        road speeds on the requested day of the week and time of day.

        Information returned includes the distance, estimated travel time, and a representation of the
        route geometry. Additional routing information such as optimized waypoint order or turn by turn
        instructions is also available, depending on the options selected.

        Routing service provides a set of parameters for a detailed description of a vehicle-specific
        Consumption Model. Please check `Consumption Model
        <https://learn.microsoft.com/azure/azure-maps/consumption-model>`_ for detailed explanation of
        the concepts and parameters involved.

        :param route_direction_parameters: Used for reconstructing a route and for calculating zero or
         more alternative routes to this reference route.  The provided sequence of coordinates is used
         as input for route reconstruction. The alternative routes  are calculated between the origin
         and destination points specified in the base path parameter locations.  If both
         minDeviationDistance and minDeviationTime are set to zero, then these origin and destination
         points  are expected to be at (or very near) the beginning and end of the reference route,
         respectively. Intermediate  locations (waypoints) are not supported when using
         supportingPoints.

         Setting at least one of minDeviationDistance or minDeviationTime to a value greater than zero
         has the  following consequences:


         * The origin point of the calculateRoute request must be on (or very near) the input reference
           route. If  this is not the case, an error is returned. However, the origin point does not need
           to be at the beginning of  the input reference route (it can be thought of as the current
           vehicle position on the reference route).
         * The reference route, returned as the first route in the calculateRoute response, will start
           at the origin  point specified in the calculateRoute request. The initial part of the input
           reference route up until the  origin point will be excluded from the response.
         * The values of minDeviationDistance and minDeviationTime determine how far alternative routes
           will be  guaranteed to follow the reference route from the origin point onwards.
         * The route must use departAt.
         * The vehicleHeading is ignored. Required.
        :type route_direction_parameters: ~azure.maps.route.models.RouteDirectionParameters
        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.route.models.ResponseFormat
        :keyword route_points: The Coordinates through which the route is calculated, delimited by a
         colon.  A minimum of two coordinates is required.  The first one is the origin and the last is
         the destination of the route. Optional coordinates in-between act as WayPoints in the route.
         You can pass up to 150 WayPoints. Required.
        :paramtype route_points: str
        :keyword max_alternatives: Number of desired alternative routes to be calculated. Default: 0,
         minimum: 0 and maximum: 5. Default value is None.
        :paramtype max_alternatives: int
        :keyword alternative_type: Controls the optimality, with respect to the given planning
         criteria, of the calculated alternatives compared to the reference route. Known values are:
         "anyRoute" and "betterRoute". Default value is None.
        :paramtype alternative_type: str or ~azure.maps.route.models.AlternativeRouteType
        :keyword min_deviation_distance: All alternative routes returned will follow the reference
         route (see section POST Requests) from the origin point of the calculateRoute request for at
         least this number of meters. Can only be used when reconstructing a route. The
         minDeviationDistance parameter cannot be used in conjunction with arriveAt. Default value is
         None.
        :paramtype min_deviation_distance: int
        :keyword min_deviation_time: All alternative routes returned will follow the reference route
         (see section POST Requests) from the origin point of the calculateRoute request for at least
         this number of seconds. Can only be used when reconstructing a route. The minDeviationTime
         parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting
         )minDeviationTime_ to a value greater than zero has the following consequences:


         * The origin point of the *calculateRoute* Request must be on
           (or very near) the input reference route.

           * If this is not the case, an error is returned.
           * However, the origin point does not need to be at the beginning
             of the input reference route (it can be thought of as the current
             vehicle position on the reference route).

         * The reference route, returned as the first route in the *calculateRoute*
           Response, will start at the origin point specified in the *calculateRoute*
           Request. The initial part of the input reference route up until the origin
           point will be excluded from the Response.
         * The values of *minDeviationDistance* and *minDeviationTime* determine
           how far alternative routes will be guaranteed to follow the reference
           route from the origin point onwards.
         * The route must use *departAt*.
         * The *vehicleHeading* is ignored. Default value is None.
        :paramtype min_deviation_time: int
        :keyword instructions_type: If specified, guidance instructions will be returned. Note that the
         instructionsType parameter cannot be used in conjunction with routeRepresentation=none. Known
         values are: "coded", "text", and "tagged". Default value is None.
        :paramtype instructions_type: str or ~azure.maps.route.models.RouteInstructionsType
        :keyword language: The language parameter determines the language of the guidance messages. It
         does not affect proper nouns (the names of streets, plazas, etc.) It has no effect when
         instructionsType=coded. Allowed values are (a subset of) the IETF language tags described.
         Default value is None.
        :paramtype language: str
        :keyword compute_best_waypoint_order: Re-order the route waypoints using a fast heuristic
         algorithm to reduce the route length. Yields best results when used in conjunction with
         routeType *shortest*. Notice that origin and destination are excluded from the optimized
         waypoint indices. To include origin and destination in the response, please increase all the
         indices by 1 to account for the origin, and then add the destination as the final index.
         Possible values are true or false. True computes a better order if possible, but is not allowed
         to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with
         circle waypoints. False will use the locations in the given order and not allowed to be used in
         conjunction with routeRepresentation *none*. Default value is None.
        :paramtype compute_best_waypoint_order: bool
        :keyword route_representation_for_best_order: Specifies the representation of the set of routes
         provided as response. This parameter value can only be used in conjunction with
         computeBestOrder=true. Known values are: "polyline", "summaryOnly", and "none". Default value
         is None.
        :paramtype route_representation_for_best_order: str or
         ~azure.maps.route.models.RouteRepresentationForBestOrder
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword vehicle_heading: The directional heading of the vehicle in degrees starting at true
         North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is
         180 degrees, west is 270 degrees. Possible values 0-359. Default value is None.
        :paramtype vehicle_heading: int
        :keyword report: Specifies which data should be reported for diagnosis purposes. The only
         possible value is *effectiveSettings*. Reports the effective parameters or data used when
         calling the API. In the case of defaulted parameters the default will be reflected where the
         parameter was not specified by the caller. "effectiveSettings" Default value is None.
        :paramtype report: str or ~azure.maps.route.models.Report
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms.


         * It is mandatory if any of the *Efficiency parameters are set.

         * It must be strictly positive when used in the context of the Consumption Model. Weight
           restrictions are considered.

         * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is
           non-zero, then weight restrictions are considered.

         * In all other cases, this parameter is ignored.

         Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900. Default
         value is 0.
        :paramtype vehicle_weight: int
        :keyword is_commercial_vehicle: Whether the vehicle is used for commercial purposes. Commercial
         vehicles may not be allowed to drive on some roads. Default value is False.
        :paramtype is_commercial_vehicle: bool
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword vehicle_engine_type: Engine type of the vehicle. When a detailed Consumption Model is
         specified, it must be consistent with the value of **vehicleEngineType**. Known values are:
         "combustion" and "electric". Default value is None.
        :paramtype vehicle_engine_type: str or ~azure.maps.route.models.VehicleEngineType
        :keyword constant_speed_consumption_in_liters_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of colon-delimited speed & consumption-rate pairs. The list
         defines points on a consumption curve. Consumption rates for speeds not in the list are found
         as follows:


         *
           by linear interpolation, if the given speed lies in between two speeds in the list

         *
           by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
         the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller speed.

         The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.

         Sensible Values : 50,6.3:130,11.5

         **Note** : This parameter is required for **The Combustion Consumption Model**. Default value
         is None.
        :paramtype constant_speed_consumption_in_liters_per_hundred_km: str
        :keyword current_fuel_in_liters: Specifies the current supply of fuel in liters.

         Sensible Values : 55. Default value is None.
        :paramtype current_fuel_in_liters: float
        :keyword auxiliary_power_in_liters_per_hour: Specifies the amount of fuel consumed for
         sustaining auxiliary systems of the vehicle, in liters per hour.

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 0.2. Default value is None.
        :paramtype auxiliary_power_in_liters_per_hour: float
        :keyword fuel_energy_density_in_megajoules_per_liter: Specifies the amount of chemical energy
         stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the
         ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For
         example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.

         This parameter is required if any ***Efficiency** parameter is set.

         Sensible Values : 34.2. Default value is None.
        :paramtype fuel_energy_density_in_megajoules_per_liter: float
        :keyword acceleration_efficiency: Specifies the efficiency of converting chemical energy stored
         in fuel to kinetic energy when the vehicle accelerates *(i.e.
         KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by converting
         consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **decelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **decelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66. Default
         value is None.
        :paramtype acceleration_efficiency: float
        :keyword deceleration_efficiency: Specifies the efficiency of converting kinetic energy to
         saved (not consumed) fuel when the vehicle decelerates *(i.e.
         ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **accelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **accelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91. Default
         value is None.
        :paramtype deceleration_efficiency: float
        :keyword uphill_efficiency: Specifies the efficiency of converting chemical energy stored in
         fuel to potential energy when the vehicle gains elevation *(i.e.
         PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by
         converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **downhillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **downhillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74. Default
         value is None.
        :paramtype uphill_efficiency: float
        :keyword downhill_efficiency: Specifies the efficiency of converting potential energy to saved
         (not consumed) fuel when the vehicle loses elevation *(i.e.
         ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **uphillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **uphillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73. Default
         value is None.
        :paramtype downhill_efficiency: float
        :keyword constant_speed_consumption_in_kw_h_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a
         consumption curve. Consumption rates for speeds not in the list are found as follows:


         *
           by linear interpolation, if the given speed lies in between two speeds in the list

         *
           by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
         the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller  speed.

         The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and
         100000.0.

         Sensible Values : 50,8.2:130,21.3

         This parameter is required for **Electric consumption model**. Default value is None.
        :paramtype constant_speed_consumption_in_kw_h_per_hundred_km: str
        :keyword current_charge_in_kw_h: Specifies the current electric energy supply in kilowatt hours
         (kWh).

         This parameter co-exists with **maxChargeInkWh** parameter.

         The range of values allowed are 0.0 to **maxChargeInkWh**.

         Sensible Values : 43. Default value is None.
        :paramtype current_charge_in_kw_h: float
        :keyword max_charge_in_kw_h: Specifies the maximum electric energy supply in kilowatt hours
         (kWh) that may be stored in the vehicle's battery.

         This parameter co-exists with **currentChargeInkWh** parameter.

         Minimum value has to be greater than or equal to **currentChargeInkWh**.

         Sensible Values : 85. Default value is None.
        :paramtype max_charge_in_kw_h: float
        :keyword auxiliary_power_in_kw: Specifies the amount of power consumed for sustaining auxiliary
         systems, in kilowatts (kW).

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 1.7. Default value is None.
        :paramtype auxiliary_power_in_kw: float
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RouteDirections
        :rtype: ~azure.maps.route.models.RouteDirections
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_route_directions_with_additional_parameters(  # pylint: disable=name-too-long
        self,
        route_direction_parameters: IO[bytes],
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        route_points: str,
        max_alternatives: Optional[int] = None,
        alternative_type: Optional[Union[str, _models.AlternativeRouteType]] = None,
        min_deviation_distance: Optional[int] = None,
        min_deviation_time: Optional[int] = None,
        instructions_type: Optional[Union[str, _models.RouteInstructionsType]] = None,
        language: Optional[str] = None,
        compute_best_waypoint_order: Optional[bool] = None,
        route_representation_for_best_order: Optional[Union[str, _models.RouteRepresentationForBestOrder]] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        vehicle_heading: Optional[int] = None,
        report: Optional[Union[str, _models.Report]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        is_commercial_vehicle: bool = False,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        vehicle_engine_type: Optional[Union[str, _models.VehicleEngineType]] = None,
        constant_speed_consumption_in_liters_per_hundred_km: Optional[str] = None,
        current_fuel_in_liters: Optional[float] = None,
        auxiliary_power_in_liters_per_hour: Optional[float] = None,
        fuel_energy_density_in_megajoules_per_liter: Optional[float] = None,
        acceleration_efficiency: Optional[float] = None,
        deceleration_efficiency: Optional[float] = None,
        uphill_efficiency: Optional[float] = None,
        downhill_efficiency: Optional[float] = None,
        constant_speed_consumption_in_kw_h_per_hundred_km: Optional[str] = None,
        current_charge_in_kw_h: Optional[float] = None,
        max_charge_in_kw_h: Optional[float] = None,
        auxiliary_power_in_kw: Optional[float] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RouteDirections:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Returns  a route between an origin and a destination, passing through waypoints if they are
        specified. The route will take into account factors such as current traffic and the typical
        road speeds on the requested day of the week and time of day.

        Information returned includes the distance, estimated travel time, and a representation of the
        route geometry. Additional routing information such as optimized waypoint order or turn by turn
        instructions is also available, depending on the options selected.

        Routing service provides a set of parameters for a detailed description of a vehicle-specific
        Consumption Model. Please check `Consumption Model
        <https://learn.microsoft.com/azure/azure-maps/consumption-model>`_ for detailed explanation of
        the concepts and parameters involved.

        :param route_direction_parameters: Used for reconstructing a route and for calculating zero or
         more alternative routes to this reference route.  The provided sequence of coordinates is used
         as input for route reconstruction. The alternative routes  are calculated between the origin
         and destination points specified in the base path parameter locations.  If both
         minDeviationDistance and minDeviationTime are set to zero, then these origin and destination
         points  are expected to be at (or very near) the beginning and end of the reference route,
         respectively. Intermediate  locations (waypoints) are not supported when using
         supportingPoints.

         Setting at least one of minDeviationDistance or minDeviationTime to a value greater than zero
         has the  following consequences:


         * The origin point of the calculateRoute request must be on (or very near) the input reference
           route. If  this is not the case, an error is returned. However, the origin point does not need
           to be at the beginning of  the input reference route (it can be thought of as the current
           vehicle position on the reference route).
         * The reference route, returned as the first route in the calculateRoute response, will start
           at the origin  point specified in the calculateRoute request. The initial part of the input
           reference route up until the  origin point will be excluded from the response.
         * The values of minDeviationDistance and minDeviationTime determine how far alternative routes
           will be  guaranteed to follow the reference route from the origin point onwards.
         * The route must use departAt.
         * The vehicleHeading is ignored. Required.
        :type route_direction_parameters: IO[bytes]
        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.route.models.ResponseFormat
        :keyword route_points: The Coordinates through which the route is calculated, delimited by a
         colon.  A minimum of two coordinates is required.  The first one is the origin and the last is
         the destination of the route. Optional coordinates in-between act as WayPoints in the route.
         You can pass up to 150 WayPoints. Required.
        :paramtype route_points: str
        :keyword max_alternatives: Number of desired alternative routes to be calculated. Default: 0,
         minimum: 0 and maximum: 5. Default value is None.
        :paramtype max_alternatives: int
        :keyword alternative_type: Controls the optimality, with respect to the given planning
         criteria, of the calculated alternatives compared to the reference route. Known values are:
         "anyRoute" and "betterRoute". Default value is None.
        :paramtype alternative_type: str or ~azure.maps.route.models.AlternativeRouteType
        :keyword min_deviation_distance: All alternative routes returned will follow the reference
         route (see section POST Requests) from the origin point of the calculateRoute request for at
         least this number of meters. Can only be used when reconstructing a route. The
         minDeviationDistance parameter cannot be used in conjunction with arriveAt. Default value is
         None.
        :paramtype min_deviation_distance: int
        :keyword min_deviation_time: All alternative routes returned will follow the reference route
         (see section POST Requests) from the origin point of the calculateRoute request for at least
         this number of seconds. Can only be used when reconstructing a route. The minDeviationTime
         parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting
         )minDeviationTime_ to a value greater than zero has the following consequences:


         * The origin point of the *calculateRoute* Request must be on
           (or very near) the input reference route.

           * If this is not the case, an error is returned.
           * However, the origin point does not need to be at the beginning
             of the input reference route (it can be thought of as the current
             vehicle position on the reference route).

         * The reference route, returned as the first route in the *calculateRoute*
           Response, will start at the origin point specified in the *calculateRoute*
           Request. The initial part of the input reference route up until the origin
           point will be excluded from the Response.
         * The values of *minDeviationDistance* and *minDeviationTime* determine
           how far alternative routes will be guaranteed to follow the reference
           route from the origin point onwards.
         * The route must use *departAt*.
         * The *vehicleHeading* is ignored. Default value is None.
        :paramtype min_deviation_time: int
        :keyword instructions_type: If specified, guidance instructions will be returned. Note that the
         instructionsType parameter cannot be used in conjunction with routeRepresentation=none. Known
         values are: "coded", "text", and "tagged". Default value is None.
        :paramtype instructions_type: str or ~azure.maps.route.models.RouteInstructionsType
        :keyword language: The language parameter determines the language of the guidance messages. It
         does not affect proper nouns (the names of streets, plazas, etc.) It has no effect when
         instructionsType=coded. Allowed values are (a subset of) the IETF language tags described.
         Default value is None.
        :paramtype language: str
        :keyword compute_best_waypoint_order: Re-order the route waypoints using a fast heuristic
         algorithm to reduce the route length. Yields best results when used in conjunction with
         routeType *shortest*. Notice that origin and destination are excluded from the optimized
         waypoint indices. To include origin and destination in the response, please increase all the
         indices by 1 to account for the origin, and then add the destination as the final index.
         Possible values are true or false. True computes a better order if possible, but is not allowed
         to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with
         circle waypoints. False will use the locations in the given order and not allowed to be used in
         conjunction with routeRepresentation *none*. Default value is None.
        :paramtype compute_best_waypoint_order: bool
        :keyword route_representation_for_best_order: Specifies the representation of the set of routes
         provided as response. This parameter value can only be used in conjunction with
         computeBestOrder=true. Known values are: "polyline", "summaryOnly", and "none". Default value
         is None.
        :paramtype route_representation_for_best_order: str or
         ~azure.maps.route.models.RouteRepresentationForBestOrder
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword vehicle_heading: The directional heading of the vehicle in degrees starting at true
         North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is
         180 degrees, west is 270 degrees. Possible values 0-359. Default value is None.
        :paramtype vehicle_heading: int
        :keyword report: Specifies which data should be reported for diagnosis purposes. The only
         possible value is *effectiveSettings*. Reports the effective parameters or data used when
         calling the API. In the case of defaulted parameters the default will be reflected where the
         parameter was not specified by the caller. "effectiveSettings" Default value is None.
        :paramtype report: str or ~azure.maps.route.models.Report
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms.


         * It is mandatory if any of the *Efficiency parameters are set.

         * It must be strictly positive when used in the context of the Consumption Model. Weight
           restrictions are considered.

         * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is
           non-zero, then weight restrictions are considered.

         * In all other cases, this parameter is ignored.

         Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900. Default
         value is 0.
        :paramtype vehicle_weight: int
        :keyword is_commercial_vehicle: Whether the vehicle is used for commercial purposes. Commercial
         vehicles may not be allowed to drive on some roads. Default value is False.
        :paramtype is_commercial_vehicle: bool
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword vehicle_engine_type: Engine type of the vehicle. When a detailed Consumption Model is
         specified, it must be consistent with the value of **vehicleEngineType**. Known values are:
         "combustion" and "electric". Default value is None.
        :paramtype vehicle_engine_type: str or ~azure.maps.route.models.VehicleEngineType
        :keyword constant_speed_consumption_in_liters_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of colon-delimited speed & consumption-rate pairs. The list
         defines points on a consumption curve. Consumption rates for speeds not in the list are found
         as follows:


         *
           by linear interpolation, if the given speed lies in between two speeds in the list

         *
           by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
         the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller speed.

         The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.

         Sensible Values : 50,6.3:130,11.5

         **Note** : This parameter is required for **The Combustion Consumption Model**. Default value
         is None.
        :paramtype constant_speed_consumption_in_liters_per_hundred_km: str
        :keyword current_fuel_in_liters: Specifies the current supply of fuel in liters.

         Sensible Values : 55. Default value is None.
        :paramtype current_fuel_in_liters: float
        :keyword auxiliary_power_in_liters_per_hour: Specifies the amount of fuel consumed for
         sustaining auxiliary systems of the vehicle, in liters per hour.

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 0.2. Default value is None.
        :paramtype auxiliary_power_in_liters_per_hour: float
        :keyword fuel_energy_density_in_megajoules_per_liter: Specifies the amount of chemical energy
         stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the
         ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For
         example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.

         This parameter is required if any ***Efficiency** parameter is set.

         Sensible Values : 34.2. Default value is None.
        :paramtype fuel_energy_density_in_megajoules_per_liter: float
        :keyword acceleration_efficiency: Specifies the efficiency of converting chemical energy stored
         in fuel to kinetic energy when the vehicle accelerates *(i.e.
         KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by converting
         consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **decelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **decelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66. Default
         value is None.
        :paramtype acceleration_efficiency: float
        :keyword deceleration_efficiency: Specifies the efficiency of converting kinetic energy to
         saved (not consumed) fuel when the vehicle decelerates *(i.e.
         ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **accelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **accelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91. Default
         value is None.
        :paramtype deceleration_efficiency: float
        :keyword uphill_efficiency: Specifies the efficiency of converting chemical energy stored in
         fuel to potential energy when the vehicle gains elevation *(i.e.
         PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by
         converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **downhillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **downhillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74. Default
         value is None.
        :paramtype uphill_efficiency: float
        :keyword downhill_efficiency: Specifies the efficiency of converting potential energy to saved
         (not consumed) fuel when the vehicle loses elevation *(i.e.
         ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **uphillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **uphillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73. Default
         value is None.
        :paramtype downhill_efficiency: float
        :keyword constant_speed_consumption_in_kw_h_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a
         consumption curve. Consumption rates for speeds not in the list are found as follows:


         *
           by linear interpolation, if the given speed lies in between two speeds in the list

         *
           by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
         the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller  speed.

         The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and
         100000.0.

         Sensible Values : 50,8.2:130,21.3

         This parameter is required for **Electric consumption model**. Default value is None.
        :paramtype constant_speed_consumption_in_kw_h_per_hundred_km: str
        :keyword current_charge_in_kw_h: Specifies the current electric energy supply in kilowatt hours
         (kWh).

         This parameter co-exists with **maxChargeInkWh** parameter.

         The range of values allowed are 0.0 to **maxChargeInkWh**.

         Sensible Values : 43. Default value is None.
        :paramtype current_charge_in_kw_h: float
        :keyword max_charge_in_kw_h: Specifies the maximum electric energy supply in kilowatt hours
         (kWh) that may be stored in the vehicle's battery.

         This parameter co-exists with **currentChargeInkWh** parameter.

         Minimum value has to be greater than or equal to **currentChargeInkWh**.

         Sensible Values : 85. Default value is None.
        :paramtype max_charge_in_kw_h: float
        :keyword auxiliary_power_in_kw: Specifies the amount of power consumed for sustaining auxiliary
         systems, in kilowatts (kW).

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 1.7. Default value is None.
        :paramtype auxiliary_power_in_kw: float
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RouteDirections
        :rtype: ~azure.maps.route.models.RouteDirections
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_route_directions_with_additional_parameters(  # pylint: disable=name-too-long
        self,
        route_direction_parameters: Union[_models.RouteDirectionParameters, IO[bytes]],
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        route_points: str,
        max_alternatives: Optional[int] = None,
        alternative_type: Optional[Union[str, _models.AlternativeRouteType]] = None,
        min_deviation_distance: Optional[int] = None,
        min_deviation_time: Optional[int] = None,
        instructions_type: Optional[Union[str, _models.RouteInstructionsType]] = None,
        language: Optional[str] = None,
        compute_best_waypoint_order: Optional[bool] = None,
        route_representation_for_best_order: Optional[Union[str, _models.RouteRepresentationForBestOrder]] = None,
        compute_travel_time: Optional[Union[str, _models.ComputeTravelTime]] = None,
        vehicle_heading: Optional[int] = None,
        report: Optional[Union[str, _models.Report]] = None,
        filter_section_type: Optional[Union[str, _models.SectionType]] = None,
        arrive_at: Optional[datetime.datetime] = None,
        depart_at: Optional[datetime.datetime] = None,
        vehicle_axle_weight: int = 0,
        vehicle_length: float = 0,
        vehicle_height: float = 0,
        vehicle_width: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        is_commercial_vehicle: bool = False,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        use_traffic_data: Optional[bool] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        vehicle_engine_type: Optional[Union[str, _models.VehicleEngineType]] = None,
        constant_speed_consumption_in_liters_per_hundred_km: Optional[str] = None,
        current_fuel_in_liters: Optional[float] = None,
        auxiliary_power_in_liters_per_hour: Optional[float] = None,
        fuel_energy_density_in_megajoules_per_liter: Optional[float] = None,
        acceleration_efficiency: Optional[float] = None,
        deceleration_efficiency: Optional[float] = None,
        uphill_efficiency: Optional[float] = None,
        downhill_efficiency: Optional[float] = None,
        constant_speed_consumption_in_kw_h_per_hundred_km: Optional[str] = None,
        current_charge_in_kw_h: Optional[float] = None,
        max_charge_in_kw_h: Optional[float] = None,
        auxiliary_power_in_kw: Optional[float] = None,
        **kwargs: Any
    ) -> _models.RouteDirections:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Returns  a route between an origin and a destination, passing through waypoints if they are
        specified. The route will take into account factors such as current traffic and the typical
        road speeds on the requested day of the week and time of day.

        Information returned includes the distance, estimated travel time, and a representation of the
        route geometry. Additional routing information such as optimized waypoint order or turn by turn
        instructions is also available, depending on the options selected.

        Routing service provides a set of parameters for a detailed description of a vehicle-specific
        Consumption Model. Please check `Consumption Model
        <https://learn.microsoft.com/azure/azure-maps/consumption-model>`_ for detailed explanation of
        the concepts and parameters involved.

        :param route_direction_parameters: Used for reconstructing a route and for calculating zero or
         more alternative routes to this reference route.  The provided sequence of coordinates is used
         as input for route reconstruction. The alternative routes  are calculated between the origin
         and destination points specified in the base path parameter locations.  If both
         minDeviationDistance and minDeviationTime are set to zero, then these origin and destination
         points  are expected to be at (or very near) the beginning and end of the reference route,
         respectively. Intermediate  locations (waypoints) are not supported when using
         supportingPoints.

         Setting at least one of minDeviationDistance or minDeviationTime to a value greater than zero
         has the  following consequences:


         * The origin point of the calculateRoute request must be on (or very near) the input reference
           route. If  this is not the case, an error is returned. However, the origin point does not need
           to be at the beginning of  the input reference route (it can be thought of as the current
           vehicle position on the reference route).
         * The reference route, returned as the first route in the calculateRoute response, will start
           at the origin  point specified in the calculateRoute request. The initial part of the input
           reference route up until the  origin point will be excluded from the response.
         * The values of minDeviationDistance and minDeviationTime determine how far alternative routes
           will be  guaranteed to follow the reference route from the origin point onwards.
         * The route must use departAt.
         * The vehicleHeading is ignored. Is either a RouteDirectionParameters type or a IO[bytes]
           type. Required.
        :type route_direction_parameters: ~azure.maps.route.models.RouteDirectionParameters or
         IO[bytes]
        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.route.models.ResponseFormat
        :keyword route_points: The Coordinates through which the route is calculated, delimited by a
         colon.  A minimum of two coordinates is required.  The first one is the origin and the last is
         the destination of the route. Optional coordinates in-between act as WayPoints in the route.
         You can pass up to 150 WayPoints. Required.
        :paramtype route_points: str
        :keyword max_alternatives: Number of desired alternative routes to be calculated. Default: 0,
         minimum: 0 and maximum: 5. Default value is None.
        :paramtype max_alternatives: int
        :keyword alternative_type: Controls the optimality, with respect to the given planning
         criteria, of the calculated alternatives compared to the reference route. Known values are:
         "anyRoute" and "betterRoute". Default value is None.
        :paramtype alternative_type: str or ~azure.maps.route.models.AlternativeRouteType
        :keyword min_deviation_distance: All alternative routes returned will follow the reference
         route (see section POST Requests) from the origin point of the calculateRoute request for at
         least this number of meters. Can only be used when reconstructing a route. The
         minDeviationDistance parameter cannot be used in conjunction with arriveAt. Default value is
         None.
        :paramtype min_deviation_distance: int
        :keyword min_deviation_time: All alternative routes returned will follow the reference route
         (see section POST Requests) from the origin point of the calculateRoute request for at least
         this number of seconds. Can only be used when reconstructing a route. The minDeviationTime
         parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting
         )minDeviationTime_ to a value greater than zero has the following consequences:


         * The origin point of the *calculateRoute* Request must be on
           (or very near) the input reference route.

           * If this is not the case, an error is returned.
           * However, the origin point does not need to be at the beginning
             of the input reference route (it can be thought of as the current
             vehicle position on the reference route).

         * The reference route, returned as the first route in the *calculateRoute*
           Response, will start at the origin point specified in the *calculateRoute*
           Request. The initial part of the input reference route up until the origin
           point will be excluded from the Response.
         * The values of *minDeviationDistance* and *minDeviationTime* determine
           how far alternative routes will be guaranteed to follow the reference
           route from the origin point onwards.
         * The route must use *departAt*.
         * The *vehicleHeading* is ignored. Default value is None.
        :paramtype min_deviation_time: int
        :keyword instructions_type: If specified, guidance instructions will be returned. Note that the
         instructionsType parameter cannot be used in conjunction with routeRepresentation=none. Known
         values are: "coded", "text", and "tagged". Default value is None.
        :paramtype instructions_type: str or ~azure.maps.route.models.RouteInstructionsType
        :keyword language: The language parameter determines the language of the guidance messages. It
         does not affect proper nouns (the names of streets, plazas, etc.) It has no effect when
         instructionsType=coded. Allowed values are (a subset of) the IETF language tags described.
         Default value is None.
        :paramtype language: str
        :keyword compute_best_waypoint_order: Re-order the route waypoints using a fast heuristic
         algorithm to reduce the route length. Yields best results when used in conjunction with
         routeType *shortest*. Notice that origin and destination are excluded from the optimized
         waypoint indices. To include origin and destination in the response, please increase all the
         indices by 1 to account for the origin, and then add the destination as the final index.
         Possible values are true or false. True computes a better order if possible, but is not allowed
         to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with
         circle waypoints. False will use the locations in the given order and not allowed to be used in
         conjunction with routeRepresentation *none*. Default value is None.
        :paramtype compute_best_waypoint_order: bool
        :keyword route_representation_for_best_order: Specifies the representation of the set of routes
         provided as response. This parameter value can only be used in conjunction with
         computeBestOrder=true. Known values are: "polyline", "summaryOnly", and "none". Default value
         is None.
        :paramtype route_representation_for_best_order: str or
         ~azure.maps.route.models.RouteRepresentationForBestOrder
        :keyword compute_travel_time: Specifies whether to return additional travel times using
         different types of traffic information (none, historic, live) as well as the default
         best-estimate travel time. Known values are: "none" and "all". Default value is None.
        :paramtype compute_travel_time: str or ~azure.maps.route.models.ComputeTravelTime
        :keyword vehicle_heading: The directional heading of the vehicle in degrees starting at true
         North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is
         180 degrees, west is 270 degrees. Possible values 0-359. Default value is None.
        :paramtype vehicle_heading: int
        :keyword report: Specifies which data should be reported for diagnosis purposes. The only
         possible value is *effectiveSettings*. Reports the effective parameters or data used when
         calling the API. In the case of defaulted parameters the default will be reflected where the
         parameter was not specified by the caller. "effectiveSettings" Default value is None.
        :paramtype report: str or ~azure.maps.route.models.Report
        :keyword filter_section_type: Specifies which of the section types is reported in the route
         response. For example if sectionType = pedestrian the sections which
         are suited for pedestrians only are returned. Multiple types can be used. The default
         sectionType refers to the travelMode input. By default travelMode is set to car. Known values
         are: "carTrain", "country", "ferry", "motorway", "pedestrian", "tollRoad", "tollVignette",
         "traffic", "travelMode", "tunnel", "carpool", and "urban". Default value is None.
        :paramtype filter_section_type: str or ~azure.maps.route.models.SectionType
        :keyword arrive_at: The date and time of arrival at the destination point. It must be specified
         as a dateTime. When a time zone offset is not specified it will be assumed to be that of the
         destination point. The arriveAt value must be in the future. The arriveAt parameter cannot be
         used in conjunction with departAt, minDeviationDistance or minDeviationTime. Default value is
         None.
        :paramtype arrive_at: ~datetime.datetime
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms.


         * It is mandatory if any of the Efficiency parameters are set.

         * It must be strictly positive when used in the context of the Consumption Model. Weight
           restrictions are considered.

         * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is
           non-zero, then weight restrictions are considered.

         * In all other cases, this parameter is ignored.

         Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900. Default
         value is 0.
        :paramtype vehicle_weight: int
        :keyword is_commercial_vehicle: Whether the vehicle is used for commercial purposes. Commercial
         vehicles may not be allowed to drive on some roads. Default value is False.
        :paramtype is_commercial_vehicle: bool
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.
        :paramtype use_traffic_data: bool
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword vehicle_engine_type: Engine type of the vehicle. When a detailed Consumption Model is
         specified, it must be consistent with the value of **vehicleEngineType**. Known values are:
         "combustion" and "electric". Default value is None.
        :paramtype vehicle_engine_type: str or ~azure.maps.route.models.VehicleEngineType
        :keyword constant_speed_consumption_in_liters_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of colon-delimited speed & consumption-rate pairs. The list
         defines points on a consumption curve. Consumption rates for speeds not in the list are found
         as follows:


         * by linear interpolation, if the given speed lies in between two speeds in the list

         * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
           the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller speed.

         The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.

         Sensible Values : 50,6.3:130,11.5

         **Note** : This parameter is required for **The Combustion Consumption Model**. Default value
         is None.
        :paramtype constant_speed_consumption_in_liters_per_hundred_km: str
        :keyword current_fuel_in_liters: Specifies the current supply of fuel in liters.

         Sensible Values : 55. Default value is None.
        :paramtype current_fuel_in_liters: float
        :keyword auxiliary_power_in_liters_per_hour: Specifies the amount of fuel consumed for
         sustaining auxiliary systems of the vehicle, in liters per hour.

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 0.2. Default value is None.
        :paramtype auxiliary_power_in_liters_per_hour: float
        :keyword fuel_energy_density_in_megajoules_per_liter: Specifies the amount of chemical energy
         stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the
         ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For
         example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.

         This parameter is required if any ***Efficiency** parameter is set.

         Sensible Values : 34.2. Default value is None.
        :paramtype fuel_energy_density_in_megajoules_per_liter: float
        :keyword acceleration_efficiency: Specifies the efficiency of converting chemical energy stored
         in fuel to kinetic energy when the vehicle accelerates *(i.e.
         KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by converting
         consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **decelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **decelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66. Default
         value is None.
        :paramtype acceleration_efficiency: float
        :keyword deceleration_efficiency: Specifies the efficiency of converting kinetic energy to
         saved (not consumed) fuel when the vehicle decelerates *(i.e.
         ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **accelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **accelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91. Default
         value is None.
        :paramtype deceleration_efficiency: float
        :keyword uphill_efficiency: Specifies the efficiency of converting chemical energy stored in
         fuel to potential energy when the vehicle gains elevation *(i.e.
         PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by
         converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **downhillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **downhillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74. Default
         value is None.
        :paramtype uphill_efficiency: float
        :keyword downhill_efficiency: Specifies the efficiency of converting potential energy to saved
         (not consumed) fuel when the vehicle loses elevation *(i.e.
         ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **uphillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **uphillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73. Default
         value is None.
        :paramtype downhill_efficiency: float
        :keyword constant_speed_consumption_in_kw_h_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a
         consumption curve. Consumption rates for speeds not in the list are found as follows:


         * by linear interpolation, if the given speed lies in between two speeds in the list

         * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
           the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller  speed.

         The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and
         100000.0.

         Sensible Values : 50,8.2:130,21.3

         This parameter is required for **Electric consumption model**. Default value is None.
        :paramtype constant_speed_consumption_in_kw_h_per_hundred_km: str
        :keyword current_charge_in_kw_h: Specifies the current electric energy supply in kilowatt hours
         (kWh).

         This parameter co-exists with **maxChargeInkWh** parameter.

         The range of values allowed are 0.0 to **maxChargeInkWh**.

         Sensible Values : 43. Default value is None.
        :paramtype current_charge_in_kw_h: float
        :keyword max_charge_in_kw_h: Specifies the maximum electric energy supply in kilowatt hours
         (kWh) that may be stored in the vehicle's battery.

         This parameter co-exists with **currentChargeInkWh** parameter.

         Minimum value has to be greater than or equal to **currentChargeInkWh**.

         Sensible Values : 85. Default value is None.
        :paramtype max_charge_in_kw_h: float
        :keyword auxiliary_power_in_kw: Specifies the amount of power consumed for sustaining auxiliary
         systems, in kilowatts (kW).

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 1.7. Default value is None.
        :paramtype auxiliary_power_in_kw: float
        :return: RouteDirections
        :rtype: ~azure.maps.route.models.RouteDirections
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteDirections] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_direction_parameters, (IOBase, bytes)):
            _content = route_direction_parameters
        else:
            _json = self._serialize.body(route_direction_parameters, "RouteDirectionParameters")

        _request = build_route_get_route_directions_with_additional_parameters_request(
            format=format,
            route_points=route_points,
            max_alternatives=max_alternatives,
            alternative_type=alternative_type,
            min_deviation_distance=min_deviation_distance,
            min_deviation_time=min_deviation_time,
            instructions_type=instructions_type,
            language=language,
            compute_best_waypoint_order=compute_best_waypoint_order,
            route_representation_for_best_order=route_representation_for_best_order,
            compute_travel_time=compute_travel_time,
            vehicle_heading=vehicle_heading,
            report=report,
            filter_section_type=filter_section_type,
            arrive_at=arrive_at,
            depart_at=depart_at,
            vehicle_axle_weight=vehicle_axle_weight,
            vehicle_length=vehicle_length,
            vehicle_height=vehicle_height,
            vehicle_width=vehicle_width,
            vehicle_max_speed=vehicle_max_speed,
            vehicle_weight=vehicle_weight,
            is_commercial_vehicle=is_commercial_vehicle,
            windingness=windingness,
            incline_level=incline_level,
            travel_mode=travel_mode,
            avoid=avoid,
            use_traffic_data=use_traffic_data,
            route_type=route_type,
            vehicle_load_type=vehicle_load_type,
            vehicle_engine_type=vehicle_engine_type,
            constant_speed_consumption_in_liters_per_hundred_km=constant_speed_consumption_in_liters_per_hundred_km,
            current_fuel_in_liters=current_fuel_in_liters,
            auxiliary_power_in_liters_per_hour=auxiliary_power_in_liters_per_hour,
            fuel_energy_density_in_megajoules_per_liter=fuel_energy_density_in_megajoules_per_liter,
            acceleration_efficiency=acceleration_efficiency,
            deceleration_efficiency=deceleration_efficiency,
            uphill_efficiency=uphill_efficiency,
            downhill_efficiency=downhill_efficiency,
            constant_speed_consumption_in_kw_h_per_hundred_km=constant_speed_consumption_in_kw_h_per_hundred_km,
            current_charge_in_kw_h=current_charge_in_kw_h,
            max_charge_in_kw_h=max_charge_in_kw_h,
            auxiliary_power_in_kw=auxiliary_power_in_kw,
            client_id=self._config.client_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouteDirections", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_route_range(
        self,
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        query: List[float],
        fuel_budget_in_liters: Optional[float] = None,
        energy_budget_in_kw_h: Optional[float] = None,
        time_budget_in_sec: Optional[float] = None,
        distance_budget_in_meters: Optional[float] = None,
        depart_at: Optional[datetime.datetime] = None,
        route_type: Optional[Union[str, _models.RouteType]] = None,
        use_traffic_data: Optional[bool] = None,
        avoid: Optional[List[Union[str, _models.RouteAvoidType]]] = None,
        travel_mode: Optional[Union[str, _models.TravelMode]] = None,
        incline_level: Optional[Union[str, _models.InclineLevel]] = None,
        windingness: Optional[Union[str, _models.WindingnessLevel]] = None,
        vehicle_axle_weight: int = 0,
        vehicle_width: float = 0,
        vehicle_height: float = 0,
        vehicle_length: float = 0,
        vehicle_max_speed: int = 0,
        vehicle_weight: int = 0,
        is_commercial_vehicle: bool = False,
        vehicle_load_type: Optional[Union[str, _models.VehicleLoadType]] = None,
        vehicle_engine_type: Optional[Union[str, _models.VehicleEngineType]] = None,
        constant_speed_consumption_in_liters_per_hundred_km: Optional[str] = None,
        current_fuel_in_liters: Optional[float] = None,
        auxiliary_power_in_liters_per_hour: Optional[float] = None,
        fuel_energy_density_in_megajoules_per_liter: Optional[float] = None,
        acceleration_efficiency: Optional[float] = None,
        deceleration_efficiency: Optional[float] = None,
        uphill_efficiency: Optional[float] = None,
        downhill_efficiency: Optional[float] = None,
        constant_speed_consumption_in_kw_h_per_hundred_km: Optional[str] = None,
        current_charge_in_kw_h: Optional[float] = None,
        max_charge_in_kw_h: Optional[float] = None,
        auxiliary_power_in_kw: Optional[float] = None,
        **kwargs: Any
    ) -> _models.RouteRangeResult:
        """**Route Range (Isochrone) API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        This service will calculate a set of locations that can be reached from the origin point based
        on fuel, energy,  time or distance budget that is specified. A polygon boundary (or Isochrone)
        is returned in a counterclockwise  orientation as well as the precise polygon center which was
        the result of the origin point.

        The returned polygon can be used for further processing such as  `Search Inside Geometry
        <https://learn.microsoft.com/rest/api/maps/search/postsearchinsidegeometry>`_ to  search for
        POIs within the provided Isochrone.

        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.route.models.ResponseFormat
        :keyword query: The Coordinate from which the range calculation should start. Required.
        :paramtype query: list[float]
        :keyword fuel_budget_in_liters: Fuel budget in liters that determines maximal range which can
         be travelled using the specified Combustion Consumption Model. When
         fuelBudgetInLiters is used, it is mandatory to specify a detailed  Combustion Consumption
         Model. Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec,
         or distanceBudgetInMeters) must be used. Default value is None.
        :paramtype fuel_budget_in_liters: float
        :keyword energy_budget_in_kw_h: Electric energy budget in kilowatt hours (kWh) that determines
         maximal range which can be travelled using the specified Electric Consumption
         Model. When energyBudgetInkWh is used, it is mandatory to specify a detailed
         Electric Consumption Model. Exactly one budget (fuelBudgetInLiters,
         energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. Default value is
         None.
        :paramtype energy_budget_in_kw_h: float
        :keyword time_budget_in_sec: Time budget in seconds that determines maximal range which can be
         travelled using driving time. The Consumption Model will only affect the range when routeType
         is eco. Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec,
         or distanceBudgetInMeters) must be used. Default value is None.
        :paramtype time_budget_in_sec: float
        :keyword distance_budget_in_meters: Distance budget in meters that determines maximal range
         which can be travelled using driving distance.  The Consumption Model will only affect the
         range when routeType is eco. Exactly one budget (fuelBudgetInLiters,
         energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. Default value is
         None.
        :paramtype distance_budget_in_meters: float
        :keyword depart_at: The date and time of departure from the origin point. Departure times apart
         from now must be specified as a dateTime. When a time zone offset is not specified, it will be
         assumed to be that of the origin point. The departAt value must be in the future in the
         date-time format (1996-12-19T16:39:57-08:00). Default value is None.
        :paramtype depart_at: ~datetime.datetime
        :keyword route_type: The type of route requested. Known values are: "fastest", "shortest",
         "eco", and "thrilling". Default value is None.
        :paramtype route_type: str or ~azure.maps.route.models.RouteType
        :keyword use_traffic_data: Possible values:


         * true - Do consider all available traffic information during routing
         * false - Ignore current traffic data during routing. Note that although the current traffic
           data is ignored during routing, the effect of historic traffic on effective road speeds is still
           incorporated. Default value is None.        :paramtype use_traffic_data: bool
        :keyword avoid: Specifies something that the route calculation should try to avoid when
         determining the route. Can be specified multiple times in one request, for example,
         '&avoid=motorways&avoid=tollRoads&avoid=ferries'. In calculateReachableRange requests, the
         value alreadyUsedRoads must not be used. Default value is None.
        :paramtype avoid: list[str or ~azure.maps.route.models.RouteAvoidType]
        :keyword travel_mode: The mode of travel for the requested route. If not defined, default is
         'car'. Note that the requested travelMode may not be available for the entire route. Where the
         requested travelMode is not available for a particular section, the travelMode element of the
         response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van
         are BETA functionality. Full restriction data is not available in all areas. In
         **calculateReachableRange** requests, the values bicycle and pedestrian must not be used. Known
         values are: "car", "truck", "taxi", "bus", "van", "motorcycle", "bicycle", and "pedestrian".
         Default value is None.
        :paramtype travel_mode: str or ~azure.maps.route.models.TravelMode
        :keyword incline_level: Degree of hilliness for thrilling route. This parameter can only be
         used in conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and
         "high". Default value is None.
        :paramtype incline_level: str or ~azure.maps.route.models.InclineLevel
        :keyword windingness: Level of turns for thrilling route. This parameter can only be used in
         conjunction with ``routeType``\\ =thrilling. Known values are: "low", "normal", and "high".
         Default value is None.
        :paramtype windingness: str or ~azure.maps.route.models.WindingnessLevel
        :keyword vehicle_axle_weight: Weight per axle of the vehicle in kg. A value of 0 means that
         weight restrictions per axle are not considered. Default value is 0.
        :paramtype vehicle_axle_weight: int
        :keyword vehicle_width: Width of the vehicle in meters. A value of 0 means that width
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_width: float
        :keyword vehicle_height: Height of the vehicle in meters. A value of 0 means that height
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_height: float
        :keyword vehicle_length: Length of the vehicle in meters. A value of 0 means that length
         restrictions are not considered. Default value is 0.
        :paramtype vehicle_length: float
        :keyword vehicle_max_speed: Maximum speed of the vehicle in km/hour. The max speed in the
         vehicle profile is used to check whether a vehicle is allowed on motorways.


         * A value of 0 means that an appropriate value for the vehicle will be determined and applied
           during route planning.

         * A non-zero value may be overridden during route planning. For example, the current traffic
           flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will
           consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is
           provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will
           again use 60 km/hour. Default value is 0.
        :paramtype vehicle_max_speed: int
        :keyword vehicle_weight: Weight of the vehicle in kilograms.


         * It is mandatory if any of the *Efficiency parameters are set.

         * It must be strictly positive when used in the context of the Consumption Model. Weight
           restrictions are considered.

         * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is
           non-zero, then weight restrictions are considered.

         * In all other cases, this parameter is ignored.

         Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900. Default
         value is 0.
        :paramtype vehicle_weight: int
        :keyword is_commercial_vehicle: Whether the vehicle is used for commercial purposes. Commercial
         vehicles may not be allowed to drive on some roads. Default value is False.
        :paramtype is_commercial_vehicle: bool
        :keyword vehicle_load_type: Types of cargo that may be classified as hazardous materials and
         restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9,
         plus generic classifications for use in other countries. Values beginning with USHazmat are for
         US routing while otherHazmat should be used for all other countries. vehicleLoadType can be
         specified multiple times. This parameter is currently only considered for travelMode=truck.
         Known values are: "USHazmatClass1", "USHazmatClass2", "USHazmatClass3", "USHazmatClass4",
         "USHazmatClass5", "USHazmatClass6", "USHazmatClass7", "USHazmatClass8", "USHazmatClass9",
         "otherHazmatExplosive", "otherHazmatGeneral", and "otherHazmatHarmfulToWater". Default value is
         None.
        :paramtype vehicle_load_type: str or ~azure.maps.route.models.VehicleLoadType
        :keyword vehicle_engine_type: Engine type of the vehicle. When a detailed Consumption Model is
         specified, it must be consistent with the value of **vehicleEngineType**. Known values are:
         "combustion" and "electric". Default value is None.
        :paramtype vehicle_engine_type: str or ~azure.maps.route.models.VehicleEngineType
        :keyword constant_speed_consumption_in_liters_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of colon-delimited speed & consumption-rate pairs. The list
         defines points on a consumption curve. Consumption rates for speeds not in the list are found
         as follows:


         * by linear interpolation, if the given speed lies in between two speeds in the list

         * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
           the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller speed.

         The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.

         Sensible Values : 50,6.3:130,11.5

         **Note** : This parameter is required for **The Combustion Consumption Model**. Default value
         is None.
        :paramtype constant_speed_consumption_in_liters_per_hundred_km: str
        :keyword current_fuel_in_liters: Specifies the current supply of fuel in liters.

         Sensible Values : 55. Default value is None.
        :paramtype current_fuel_in_liters: float
        :keyword auxiliary_power_in_liters_per_hour: Specifies the amount of fuel consumed for
         sustaining auxiliary systems of the vehicle, in liters per hour.

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 0.2. Default value is None.
        :paramtype auxiliary_power_in_liters_per_hour: float
        :keyword fuel_energy_density_in_megajoules_per_liter: Specifies the amount of chemical energy
         stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the
         ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For
         example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.

         This parameter is required if any ***Efficiency** parameter is set.

         Sensible Values : 34.2. Default value is None.
        :paramtype fuel_energy_density_in_megajoules_per_liter: float
        :keyword acceleration_efficiency: Specifies the efficiency of converting chemical energy stored
         in fuel to kinetic energy when the vehicle accelerates *(i.e.
         KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by converting
         consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **decelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **decelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66. Default
         value is None.
        :paramtype acceleration_efficiency: float
        :keyword deceleration_efficiency: Specifies the efficiency of converting kinetic energy to
         saved (not consumed) fuel when the vehicle decelerates *(i.e.
         ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **accelerationEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **accelerationEfficiency**.

         Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91. Default
         value is None.
        :paramtype deceleration_efficiency: float
        :keyword uphill_efficiency: Specifies the efficiency of converting chemical energy stored in
         fuel to potential energy when the vehicle gains elevation *(i.e.
         PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed* is obtained by
         converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **downhillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **downhillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74. Default
         value is None.
        :paramtype uphill_efficiency: float
        :keyword downhill_efficiency: Specifies the efficiency of converting potential energy to saved
         (not consumed) fuel when the vehicle loses elevation *(i.e.
         ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved* is obtained by converting saved
         (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.

         Must be paired with **uphillEfficiency**.

         The range of values allowed are 0.0 to 1/\\ **uphillEfficiency**.

         Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73. Default
         value is None.
        :paramtype downhill_efficiency: float
        :keyword constant_speed_consumption_in_kw_h_per_hundred_km: Specifies the speed-dependent
         component of consumption.

         Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a
         consumption curve. Consumption rates for speeds not in the list are found as follows:


         * by linear interpolation, if the given speed lies in between two speeds in the list

         * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by
           the nearest two points in the list

         The list must contain between 1 and 25 points (inclusive), and may not contain duplicate
         points for the same speed. If it only contains a single point, then the consumption rate of
         that point is used without further processing.

         Consumption specified for the largest speed must be greater than or equal to that of the
         penultimate largest speed. This ensures that extrapolation does not lead to negative
         consumption rates.

         Similarly, consumption values specified for the two smallest speeds in the list cannot lead to
         a negative consumption rate for any smaller  speed.

         The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and
         100000.0.

         Sensible Values : 50,8.2:130,21.3

         This parameter is required for **Electric consumption model**. Default value is None.
        :paramtype constant_speed_consumption_in_kw_h_per_hundred_km: str
        :keyword current_charge_in_kw_h: Specifies the current electric energy supply in kilowatt hours
         (kWh).

         This parameter co-exists with **maxChargeInkWh** parameter.

         The range of values allowed are 0.0 to **maxChargeInkWh**.

         Sensible Values : 43. Default value is None.
        :paramtype current_charge_in_kw_h: float
        :keyword max_charge_in_kw_h: Specifies the maximum electric energy supply in kilowatt hours
         (kWh) that may be stored in the vehicle's battery.

         This parameter co-exists with **currentChargeInkWh** parameter.

         Minimum value has to be greater than or equal to **currentChargeInkWh**.

         Sensible Values : 85. Default value is None.
        :paramtype max_charge_in_kw_h: float
        :keyword auxiliary_power_in_kw: Specifies the amount of power consumed for sustaining auxiliary
         systems, in kilowatts (kW).

         It can be used to specify consumption due to devices and systems such as AC systems, radio,
         heating, etc.

         Sensible Values : 1.7. Default value is None.
        :paramtype auxiliary_power_in_kw: float
        :return: RouteRangeResult
        :rtype: ~azure.maps.route.models.RouteRangeResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouteRangeResult] = kwargs.pop("cls", None)

        _request = build_route_get_route_range_request(
            format=format,
            query=query,
            fuel_budget_in_liters=fuel_budget_in_liters,
            energy_budget_in_kw_h=energy_budget_in_kw_h,
            time_budget_in_sec=time_budget_in_sec,
            distance_budget_in_meters=distance_budget_in_meters,
            depart_at=depart_at,
            route_type=route_type,
            use_traffic_data=use_traffic_data,
            avoid=avoid,
            travel_mode=travel_mode,
            incline_level=incline_level,
            windingness=windingness,
            vehicle_axle_weight=vehicle_axle_weight,
            vehicle_width=vehicle_width,
            vehicle_height=vehicle_height,
            vehicle_length=vehicle_length,
            vehicle_max_speed=vehicle_max_speed,
            vehicle_weight=vehicle_weight,
            is_commercial_vehicle=is_commercial_vehicle,
            vehicle_load_type=vehicle_load_type,
            vehicle_engine_type=vehicle_engine_type,
            constant_speed_consumption_in_liters_per_hundred_km=constant_speed_consumption_in_liters_per_hundred_km,
            current_fuel_in_liters=current_fuel_in_liters,
            auxiliary_power_in_liters_per_hour=auxiliary_power_in_liters_per_hour,
            fuel_energy_density_in_megajoules_per_liter=fuel_energy_density_in_megajoules_per_liter,
            acceleration_efficiency=acceleration_efficiency,
            deceleration_efficiency=deceleration_efficiency,
            uphill_efficiency=uphill_efficiency,
            downhill_efficiency=downhill_efficiency,
            constant_speed_consumption_in_kw_h_per_hundred_km=constant_speed_consumption_in_kw_h_per_hundred_km,
            current_charge_in_kw_h=current_charge_in_kw_h,
            max_charge_in_kw_h=max_charge_in_kw_h,
            auxiliary_power_in_kw=auxiliary_power_in_kw,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouteRangeResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _request_route_directions_batch_initial(
        self,
        route_directions_batch_queries: Union[_models.BatchRequest, IO[bytes]],
        format: Union[str, _models.JsonFormat] = "json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_directions_batch_queries, (IOBase, bytes)):
            _content = route_directions_batch_queries
        else:
            _json = self._serialize.body(route_directions_batch_queries, "BatchRequest")

        _request = build_route_request_route_directions_batch_request(
            format=format,
            client_id=self._config.client_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_request_route_directions_batch(
        self,
        route_directions_batch_queries: _models.BatchRequest,
        format: Union[str, _models.JsonFormat] = "json",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteDirectionsBatchResult]:
        """**Route Directions Batch API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Route Directions Batch API sends batches of queries to `Route Directions API
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections>`_ using just a single API
        call. You can call Route Directions Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **700** queries and sync API
        up to **100** queries.

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex route
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **700** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Route Directions Batch ``POST`` request to Azure Maps
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
              ``400 Bad Request`` or any other ``Error`` status code.


        #. If the batch request was accepted successfully, the ``Location`` header in the response
           contains the URL to download the results of the batch request.
           This status URI looks like following:

           ``GET https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0``
           Note:- Please remember to add AUTH information (subscription-key/azure_auth - See `Security
           <#security>`_\\ ) to the *status URI* before running it. 


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *route directions* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 3 *route directions*
        queries:

        .. code-block:: json

           {
               "batchItems": [
                   { "query":
           "?query=47.620659,-122.348934:47.610101,-122.342015&travelMode=bicycle&routeType=eco&traffic=false"
           },
                   { "query":
           "?query=40.759856,-73.985108:40.771136,-73.973506&travelMode=pedestrian&routeType=shortest" },
                   { "query": "?query=48.923159,-122.557362:32.621279,-116.840362" }
               ]
           }

        A *route directions* query in a batch is just a partial URL *without* the protocol, base URL,
        path, api-version and subscription-key. It can accept any of the supported *route directions*
        `URI parameters
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#uri-parameters>`_. The
        string values in the *route directions* query must be properly escaped (e.g. " character should
        be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **700** queries and sync API up to **100** queries,
        and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

        https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
              try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
              the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message":
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param route_directions_batch_queries: The list of route directions queries/requests to
         process. The list can contain a max of 700 queries for async and 100 queries for sync version
         and must contain at least 1 query. Required.
        :type route_directions_batch_queries: ~azure.maps.route.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RouteDirectionsBatchResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteDirectionsBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_request_route_directions_batch(
        self,
        route_directions_batch_queries: IO[bytes],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteDirectionsBatchResult]:
        """**Route Directions Batch API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Route Directions Batch API sends batches of queries to `Route Directions API
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections>`_ using just a single API
        call. You can call Route Directions Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **700** queries and sync API
        up to **100** queries.

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex route
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **700** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Route Directions Batch ``POST`` request to Azure Maps
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
              ``400 Bad Request`` or any other ``Error`` status code.


        #. If the batch request was accepted successfully, the ``Location`` header in the response
           contains the URL to download the results of the batch request.
           This status URI looks like following:

           ``GET https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0``
           Note:- Please remember to add AUTH information (subscription-key/azure_auth - See `Security
           <#security>`_\\ ) to the *status URI* before running it. 


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *route directions* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 3 *route directions*
        queries:

        .. code-block:: json

           {
               "batchItems": [
                   { "query":
           "?query=47.620659,-122.348934:47.610101,-122.342015&travelMode=bicycle&routeType=eco&traffic=false"
           },
                   { "query":
           "?query=40.759856,-73.985108:40.771136,-73.973506&travelMode=pedestrian&routeType=shortest" },
                   { "query": "?query=48.923159,-122.557362:32.621279,-116.840362" }
               ]
           }

        A *route directions* query in a batch is just a partial URL *without* the protocol, base URL,
        path, api-version and subscription-key. It can accept any of the supported *route directions*
        `URI parameters
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#uri-parameters>`_. The
        string values in the *route directions* query must be properly escaped (e.g. " character should
        be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **700** queries and sync API up to **100** queries,
        and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

        https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
              try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
              the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message":
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param route_directions_batch_queries: The list of route directions queries/requests to
         process. The list can contain a max of 700 queries for async and 100 queries for sync version
         and must contain at least 1 query. Required.
        :type route_directions_batch_queries: IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RouteDirectionsBatchResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteDirectionsBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_request_route_directions_batch(
        self,
        route_directions_batch_queries: Union[_models.BatchRequest, IO[bytes]],
        format: Union[str, _models.JsonFormat] = "json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteDirectionsBatchResult]:
        """**Route Directions Batch API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Route Directions Batch API sends batches of queries to `Route Directions API
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections>`_ using just a single API
        call. You can call Route Directions Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **700** queries and sync API
        up to **100** queries.

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex route
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **700** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Route Directions Batch ``POST`` request to Azure Maps
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
              ``400 Bad Request`` or any other ``Error`` status code.


        #. If the batch request was accepted successfully, the ``Location`` header in the response
           contains the URL to download the results of the batch request.
           This status URI looks like following:

           ``GET https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0``
           Note:- Please remember to add AUTH information (subscription-key/azure_auth - See `Security
           <#security>`_\\ ) to the *status URI* before running it. 


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *route directions* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 3 *route directions*
        queries:

        .. code-block:: json

           {
               "batchItems": [
                   { "query":
           "?query=47.620659,-122.348934:47.610101,-122.342015&travelMode=bicycle&routeType=eco&traffic=false"
           },
                   { "query":
           "?query=40.759856,-73.985108:40.771136,-73.973506&travelMode=pedestrian&routeType=shortest" },
                   { "query": "?query=48.923159,-122.557362:32.621279,-116.840362" }
               ]
           }

        A *route directions* query in a batch is just a partial URL *without* the protocol, base URL,
        path, api-version and subscription-key. It can accept any of the supported *route directions*
        `URI parameters
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#uri-parameters>`_. The
        string values in the *route directions* query must be properly escaped (e.g. " character should
        be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **700** queries and sync API up to **100** queries,
        and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

        https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
              try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
              the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message":
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param route_directions_batch_queries: The list of route directions queries/requests to
         process. The list can contain a max of 700 queries for async and 100 queries for sync version
         and must contain at least 1 query. Is either a BatchRequest type or a IO[bytes] type. Required.
        :type route_directions_batch_queries: ~azure.maps.route.models.BatchRequest or IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :return: An instance of AsyncLROPoller that returns RouteDirectionsBatchResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteDirectionsBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteDirectionsBatchResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._request_route_directions_batch_initial(
                route_directions_batch_queries=route_directions_batch_queries,
                format=format,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteDirectionsBatchResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteDirectionsBatchResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteDirectionsBatchResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_route_directions_batch_initial(self, batch_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_route_get_route_directions_batch_request(
            batch_id=batch_id,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_route_directions_batch(
        self, batch_id: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteDirectionsBatchResult]:
        """**Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

        https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #. The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
              try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
              the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": 
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param batch_id: Batch id for querying the operation. Required.
        :type batch_id: str
        :return: An instance of AsyncLROPoller that returns RouteDirectionsBatchResult
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.route.models.RouteDirectionsBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouteDirectionsBatchResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_route_directions_batch_initial(
                batch_id=batch_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteDirectionsBatchResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "original-uri"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteDirectionsBatchResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteDirectionsBatchResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def request_route_directions_batch_sync(
        self,
        route_directions_batch_queries: _models.BatchRequest,
        format: Union[str, _models.JsonFormat] = "json",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RouteDirectionsBatchResult:
        """**Route Directions Batch API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Route Directions Batch API sends batches of queries to `Route Directions API
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections>`_ using just a single API
        call. You can call Route Directions Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **700** queries and sync API
        up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST
           https://atlas.microsoft.com/route/directions/batch/sync/json?api-version=1.0&subscription-key={subscription-key}

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message":
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param route_directions_batch_queries: The list of route directions queries/requests to
         process. The list can contain  a max of 700 queries for async and 100 queries for sync version
         and must contain at least 1 query. Required.
        :type route_directions_batch_queries: ~azure.maps.route.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RouteDirectionsBatchResult
        :rtype: ~azure.maps.route.models.RouteDirectionsBatchResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def request_route_directions_batch_sync(
        self,
        route_directions_batch_queries: IO[bytes],
        format: Union[str, _models.JsonFormat] = "json",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RouteDirectionsBatchResult:
        """**Route Directions Batch API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Route Directions Batch API sends batches of queries to `Route Directions API
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections>`_ using just a single API
        call. You can call Route Directions Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **700** queries and sync API
        up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST
           https://atlas.microsoft.com/route/directions/batch/sync/json?api-version=1.0&subscription-key={subscription-key}

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message":
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param route_directions_batch_queries: The list of route directions queries/requests to
         process. The list can contain  a max of 700 queries for async and 100 queries for sync version
         and must contain at least 1 query. Required.
        :type route_directions_batch_queries: IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RouteDirectionsBatchResult
        :rtype: ~azure.maps.route.models.RouteDirectionsBatchResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def request_route_directions_batch_sync(
        self,
        route_directions_batch_queries: Union[_models.BatchRequest, IO[bytes]],
        format: Union[str, _models.JsonFormat] = "json",
        **kwargs: Any
    ) -> _models.RouteDirectionsBatchResult:
        """**Route Directions Batch API**

        **Applies to**\\ : see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Route Directions Batch API sends batches of queries to `Route Directions API
        <https://learn.microsoft.com/rest/api/maps/route/getroutedirections>`_ using just a single API
        call. You can call Route Directions Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **700** queries and sync API
        up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST
           https://atlas.microsoft.com/route/directions/batch/sync/json?api-version=1.0&subscription-key={subscription-key}

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\\
        i.e. queries which were executed successfully. The batch response also includes a
        ``batchItems`` array which contains a response for each and every query in the batch request.
        The ``batchItems`` will contain the results in the exact same order the original queries were
        sent in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        * `\\ ``RouteDirections``
          <https://learn.microsoft.com/rest/api/maps/route/getroutedirections#routedirections>`_ - If the
          query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
          this case.

        Here's a sample Batch Response with 1 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 1,
                   "totalRequests": 2
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response": {
                           "routes": [
                               {
                                   "summary": {
                                       "lengthInMeters": 1758,
                                       "travelTimeInSeconds": 387,
                                       "trafficDelayInSeconds": 0,
                                       "departureTime": "2018-07-17T00:49:56+00:00",
                                       "arrivalTime": "2018-07-17T00:56:22+00:00"
                                   },
                                   "legs": [
                                       {
                                           "summary": {
                                               "lengthInMeters": 1758,
                                               "travelTimeInSeconds": 387,
                                               "trafficDelayInSeconds": 0,
                                               "departureTime": "2018-07-17T00:49:56+00:00",
                                               "arrivalTime": "2018-07-17T00:56:22+00:00"
                                           },
                                           "points": [
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.34892
                                               },
                                               {
                                                   "latitude": 47.62094,
                                                   "longitude": -122.3485
                                               },
                                               {
                                                   "latitude": 47.62095,
                                                   "longitude": -122.3476
                                               }
                                           ]
                                       }
                                   ],
                                   "sections": [
                                       {
                                           "startPointIndex": 0,
                                           "endPointIndex": 40,
                                           "sectionType": "TRAVEL_MODE",
                                           "travelMode": "bicycle"
                                       }
                                   ]
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message":
                            "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }

        :param route_directions_batch_queries: The list of route directions queries/requests to
         process. The list can contain  a max of 700 queries for async and 100 queries for sync version
         and must contain at least 1 query. Is either a BatchRequest type or a IO[bytes] type. Required.
        :type route_directions_batch_queries: ~azure.maps.route.models.BatchRequest or IO[bytes]
        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str or ~azure.maps.route.models.JsonFormat
        :return: RouteDirectionsBatchResult
        :rtype: ~azure.maps.route.models.RouteDirectionsBatchResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            408: cast(
                Type[HttpResponseError],
                lambda response: HttpResponseError(
                    response=response, model=self._deserialize(_models.ErrorResponse, response)
                ),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteDirectionsBatchResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_directions_batch_queries, (IOBase, bytes)):
            _content = route_directions_batch_queries
        else:
            _json = self._serialize.body(route_directions_batch_queries, "BatchRequest")

        _request = build_route_request_route_directions_batch_sync_request(
            format=format,
            client_id=self._config.client_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouteDirectionsBatchResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
