# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementVirtualClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_clusters_list(self, resource_group):
        response = self.client.virtual_clusters.list(
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_clusters_list_by_resource_group(self, resource_group):
        response = self.client.virtual_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_clusters_get(self, resource_group):
        response = await self.client.virtual_clusters.get(
            resource_group_name=resource_group.name,
            virtual_cluster_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_clusters_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_clusters.begin_delete(
                resource_group_name=resource_group.name,
                virtual_cluster_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_clusters_begin_update(self, resource_group):
        response = await (
            await self.client.virtual_clusters.begin_update(
                resource_group_name=resource_group.name,
                virtual_cluster_name="str",
                parameters={"childResources": ["str"], "subnetId": "str", "tags": {"str": "str"}, "version": "str"},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_clusters_begin_update_dns_servers(self, resource_group):
        response = await (
            await self.client.virtual_clusters.begin_update_dns_servers(
                resource_group_name=resource_group.name,
                virtual_cluster_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
