# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing.aio import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingSubscriptionsAliasesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.billing_subscriptions_aliases.get(
            billing_account_name="str",
            alias_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.billing_subscriptions_aliases.begin_create_or_update(
                billing_account_name="str",
                alias_name="str",
                parameters={
                    "autoRenew": "str",
                    "beneficiary": {"objectId": "str", "tenantId": "str"},
                    "beneficiaryTenantId": "str",
                    "billingFrequency": "str",
                    "billingPolicies": {"str": "str"},
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingProfileName": "str",
                    "billingSubscriptionId": "str",
                    "consumptionCostCenter": "str",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "customerName": "str",
                    "displayName": "str",
                    "enrollmentAccountDisplayName": "str",
                    "enrollmentAccountId": "str",
                    "enrollmentAccountStartDate": "2020-02-20 00:00:00",
                    "id": "str",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "invoiceSectionName": "str",
                    "lastMonthCharges": {"currency": "str", "value": 0.0},
                    "monthToDateCharges": {"currency": "str", "value": 0.0},
                    "name": "str",
                    "nextBillingCycleDetails": {"billingFrequency": "str"},
                    "offerId": "str",
                    "operationStatus": "str",
                    "productCategory": "str",
                    "productType": "str",
                    "productTypeId": "str",
                    "provisioningState": "str",
                    "provisioningTenantId": "str",
                    "purchaseDate": "2020-02-20 00:00:00",
                    "quantity": 0,
                    "renewalTermDetails": {
                        "billingFrequency": "str",
                        "productId": "str",
                        "productTypeId": "str",
                        "quantity": 0,
                        "skuId": "str",
                        "termDuration": "str",
                        "termEndDate": "2020-02-20 00:00:00",
                    },
                    "reseller": {"description": "str", "resellerId": "str"},
                    "resourceUri": "str",
                    "skuDescription": "str",
                    "skuId": "str",
                    "status": "str",
                    "subscriptionEnrollmentAccountStatus": "str",
                    "subscriptionId": "str",
                    "suspensionReasonDetails": [{"effectiveDate": "2020-02-20 00:00:00", "reason": "str"}],
                    "suspensionReasons": ["str"],
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "systemOverrides": {"cancellation": "str", "cancellationAllowedEndDate": "2020-02-20 00:00:00"},
                    "tags": {"str": "str"},
                    "termDuration": "str",
                    "termEndDate": "2020-02-20 00:00:00",
                    "termStartDate": "2020-02-20 00:00:00",
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_billing_account(self, resource_group):
        response = self.client.billing_subscriptions_aliases.list_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
