# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Acl(_serialization.Model):
    """Access Control List (ACL) for an iSCSI Target; defines LUN masking policy.

    All required parameters must be populated in order to send to Azure.

    :ivar initiator_iqn: iSCSI initiator IQN (iSCSI Qualified Name); example:
     "iqn.2005-03.org.iscsi:client". Required.
    :vartype initiator_iqn: str
    :ivar mapped_luns: List of LUN names mapped to the ACL. Required.
    :vartype mapped_luns: list[str]
    """

    _validation = {
        "initiator_iqn": {"required": True},
        "mapped_luns": {"required": True},
    }

    _attribute_map = {
        "initiator_iqn": {"key": "initiatorIqn", "type": "str"},
        "mapped_luns": {"key": "mappedLuns", "type": "[str]"},
    }

    def __init__(self, *, initiator_iqn: str, mapped_luns: List[str], **kwargs):
        """
        :keyword initiator_iqn: iSCSI initiator IQN (iSCSI Qualified Name); example:
         "iqn.2005-03.org.iscsi:client". Required.
        :paramtype initiator_iqn: str
        :keyword mapped_luns: List of LUN names mapped to the ACL. Required.
        :paramtype mapped_luns: list[str]
        """
        super().__init__(**kwargs)
        self.initiator_iqn = initiator_iqn
        self.mapped_luns = mapped_luns


class Disk(_serialization.Model):
    """Azure Managed Disk to attach to the Disk Pool.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique Azure Resource ID of the Managed Disk. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Unique Azure Resource ID of the Managed Disk. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Resource(_serialization.Model):
    """ARM resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class DiskPool(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Response for Disk Pool request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar managed_by_extended: List of Azure resource ids that manage this resource.
    :vartype managed_by_extended: list[str]
    :ivar system_data: Resource metadata required by ARM RPC.
    :vartype system_data: ~azure.mgmt.storagepool.models.SystemMetadata
    :ivar provisioning_state: State of the operation on the resource. Required. Known values are:
     "Invalid", "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagepool.models.ProvisioningStates
    :ivar availability_zones: Logical zone for Disk Pool resource; example: ["1"]. Required.
    :vartype availability_zones: list[str]
    :ivar status: Operational status of the Disk Pool. Required. Known values are: "Invalid",
     "Unknown", "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped
     (deallocated)".
    :vartype status: str or ~azure.mgmt.storagepool.models.OperationalStatus
    :ivar disks: List of Azure Managed Disks to attach to a Disk Pool.
    :vartype disks: list[~azure.mgmt.storagepool.models.Disk]
    :ivar subnet_id: Azure Resource ID of a Subnet for the Disk Pool. Required.
    :vartype subnet_id: str
    :ivar additional_capabilities: List of additional capabilities for Disk Pool.
    :vartype additional_capabilities: list[str]
    :ivar name_sku_name: Sku name.
    :vartype name_sku_name: str
    :ivar tier: Sku tier.
    :vartype tier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "managed_by": {"readonly": True},
        "managed_by_extended": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"required": True, "readonly": True},
        "availability_zones": {"required": True},
        "status": {"required": True},
        "subnet_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "system_data": {"key": "systemData", "type": "SystemMetadata"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "status": {"key": "properties.status", "type": "str"},
        "disks": {"key": "properties.disks", "type": "[Disk]"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "[str]"},
        "name_sku_name": {"key": "sku.name", "type": "str"},
        "tier": {"key": "sku.tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        availability_zones: List[str],
        status: Union[str, "_models.OperationalStatus"],
        subnet_id: str,
        tags: Optional[Dict[str, str]] = None,
        disks: Optional[List["_models.Disk"]] = None,
        additional_capabilities: Optional[List[str]] = None,
        name_sku_name: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword availability_zones: Logical zone for Disk Pool resource; example: ["1"]. Required.
        :paramtype availability_zones: list[str]
        :keyword status: Operational status of the Disk Pool. Required. Known values are: "Invalid",
         "Unknown", "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped
         (deallocated)".
        :paramtype status: str or ~azure.mgmt.storagepool.models.OperationalStatus
        :keyword disks: List of Azure Managed Disks to attach to a Disk Pool.
        :paramtype disks: list[~azure.mgmt.storagepool.models.Disk]
        :keyword subnet_id: Azure Resource ID of a Subnet for the Disk Pool. Required.
        :paramtype subnet_id: str
        :keyword additional_capabilities: List of additional capabilities for Disk Pool.
        :paramtype additional_capabilities: list[str]
        :keyword name_sku_name: Sku name.
        :paramtype name_sku_name: str
        :keyword tier: Sku tier.
        :paramtype tier: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.managed_by = None
        self.managed_by_extended = None
        self.system_data = None
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.status = status
        self.disks = disks
        self.subnet_id = subnet_id
        self.additional_capabilities = additional_capabilities
        self.name_sku_name = name_sku_name
        self.tier = tier


class DiskPoolCreate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Request payload for create or update Disk Pool request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar sku: Determines the SKU of the Disk Pool. Required.
    :vartype sku: ~azure.mgmt.storagepool.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar managed_by_extended: List of Azure resource ids that manage this resource.
    :vartype managed_by_extended: list[str]
    :ivar availability_zones: Logical zone for Disk Pool resource; example: ["1"].
    :vartype availability_zones: list[str]
    :ivar disks: List of Azure Managed Disks to attach to a Disk Pool.
    :vartype disks: list[~azure.mgmt.storagepool.models.Disk]
    :ivar subnet_id: Azure Resource ID of a Subnet for the Disk Pool. Required.
    :vartype subnet_id: str
    :ivar additional_capabilities: List of additional capabilities for a Disk Pool.
    :vartype additional_capabilities: list[str]
    """

    _validation = {
        "sku": {"required": True},
        "location": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "subnet_id": {"required": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "disks": {"key": "properties.disks", "type": "[Disk]"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        location: str,
        subnet_id: str,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        managed_by_extended: Optional[List[str]] = None,
        availability_zones: Optional[List[str]] = None,
        disks: Optional[List["_models.Disk"]] = None,
        additional_capabilities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword sku: Determines the SKU of the Disk Pool. Required.
        :paramtype sku: ~azure.mgmt.storagepool.models.Sku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword managed_by: Azure resource id. Indicates if this resource is managed by another Azure
         resource.
        :paramtype managed_by: str
        :keyword managed_by_extended: List of Azure resource ids that manage this resource.
        :paramtype managed_by_extended: list[str]
        :keyword availability_zones: Logical zone for Disk Pool resource; example: ["1"].
        :paramtype availability_zones: list[str]
        :keyword disks: List of Azure Managed Disks to attach to a Disk Pool.
        :paramtype disks: list[~azure.mgmt.storagepool.models.Disk]
        :keyword subnet_id: Azure Resource ID of a Subnet for the Disk Pool. Required.
        :paramtype subnet_id: str
        :keyword additional_capabilities: List of additional capabilities for a Disk Pool.
        :paramtype additional_capabilities: list[str]
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.managed_by = managed_by
        self.managed_by_extended = managed_by_extended
        self.availability_zones = availability_zones
        self.disks = disks
        self.subnet_id = subnet_id
        self.additional_capabilities = additional_capabilities


class DiskPoolListResult(_serialization.Model):
    """List of Disk Pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of Disk pool objects. Required.
    :vartype value: list[~azure.mgmt.storagepool.models.DiskPool]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DiskPool"], **kwargs):
        """
        :keyword value: An array of Disk pool objects. Required.
        :paramtype value: list[~azure.mgmt.storagepool.models.DiskPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiskPoolUpdate(_serialization.Model):
    """Request payload for Update Disk Pool request.

    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar managed_by_extended: List of Azure resource ids that manage this resource.
    :vartype managed_by_extended: list[str]
    :ivar sku: Determines the SKU of the Disk Pool.
    :vartype sku: ~azure.mgmt.storagepool.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar disks: List of Azure Managed Disks to attach to a Disk Pool.
    :vartype disks: list[~azure.mgmt.storagepool.models.Disk]
    """

    _attribute_map = {
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "disks": {"key": "properties.disks", "type": "[Disk]"},
    }

    def __init__(
        self,
        *,
        managed_by: Optional[str] = None,
        managed_by_extended: Optional[List[str]] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        disks: Optional[List["_models.Disk"]] = None,
        **kwargs
    ):
        """
        :keyword managed_by: Azure resource id. Indicates if this resource is managed by another Azure
         resource.
        :paramtype managed_by: str
        :keyword managed_by_extended: List of Azure resource ids that manage this resource.
        :paramtype managed_by_extended: list[str]
        :keyword sku: Determines the SKU of the Disk Pool.
        :paramtype sku: ~azure.mgmt.storagepool.models.Sku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword disks: List of Azure Managed Disks to attach to a Disk Pool.
        :paramtype disks: list[~azure.mgmt.storagepool.models.Disk]
        """
        super().__init__(**kwargs)
        self.managed_by = managed_by
        self.managed_by_extended = managed_by_extended
        self.sku = sku
        self.tags = tags
        self.disks = disks


class DiskPoolZoneInfo(_serialization.Model):
    """Disk Pool SKU Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar availability_zones: Logical zone for Disk Pool resource; example: ["1"].
    :vartype availability_zones: list[str]
    :ivar additional_capabilities: List of additional capabilities for Disk Pool.
    :vartype additional_capabilities: list[str]
    :ivar sku: Determines the SKU of VM deployed for Disk Pool.
    :vartype sku: ~azure.mgmt.storagepool.models.Sku
    """

    _validation = {
        "availability_zones": {"readonly": True},
        "additional_capabilities": {"readonly": True},
        "sku": {"readonly": True},
    }

    _attribute_map = {
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "additional_capabilities": {"key": "additionalCapabilities", "type": "[str]"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.availability_zones = None
        self.additional_capabilities = None
        self.sku = None


class DiskPoolZoneListResult(_serialization.Model):
    """List Disk Pool skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Disk Pool Skus.
    :vartype value: list[~azure.mgmt.storagepool.models.DiskPoolZoneInfo]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskPoolZoneInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class EndpointDependency(_serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :vartype endpoint_details: list[~azure.mgmt.storagepool.models.EndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
        :paramtype endpoint_details: list[~azure.mgmt.storagepool.models.EndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(_serialization.Model):
    """Current TCP connectivity information from the App Service Environment to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar latency: The time in milliseconds it takes for a TCP connection to be created from the
     App Service Environment to this IpAddress at this Port.
    :vartype latency: float
    :ivar is_accessible: Whether it is possible to create a TCP connection from the App Service
     Environment to this IpAddress at this Port.
    :vartype is_accessible: bool
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "latency": {"key": "latency", "type": "float"},
        "is_accessible": {"key": "isAccessible", "type": "bool"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        latency: Optional[float] = None,
        is_accessible: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword latency: The time in milliseconds it takes for a TCP connection to be created from the
         App Service Environment to this IpAddress at this Port.
        :paramtype latency: float
        :keyword is_accessible: Whether it is possible to create a TCP connection from the App Service
         Environment to this IpAddress at this Port.
        :paramtype is_accessible: bool
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessible = is_accessible


class Error(_serialization.Model):
    """The resource management error response.

    :ivar error: RP error response.
    :vartype error: ~azure.mgmt.storagepool.models.ErrorResponse
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs):
        """
        :keyword error: RP error response.
        :paramtype error: ~azure.mgmt.storagepool.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.storagepool.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.storagepool.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class IscsiLun(_serialization.Model):
    """LUN to expose the Azure Managed Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: User defined name for iSCSI LUN; example: "lun0". Required.
    :vartype name: str
    :ivar managed_disk_azure_resource_id: Azure Resource ID of the Managed Disk. Required.
    :vartype managed_disk_azure_resource_id: str
    :ivar lun: Specifies the Logical Unit Number of the iSCSI LUN.
    :vartype lun: int
    """

    _validation = {
        "name": {"required": True},
        "managed_disk_azure_resource_id": {"required": True},
        "lun": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "managed_disk_azure_resource_id": {"key": "managedDiskAzureResourceId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, *, name: str, managed_disk_azure_resource_id: str, **kwargs):
        """
        :keyword name: User defined name for iSCSI LUN; example: "lun0". Required.
        :paramtype name: str
        :keyword managed_disk_azure_resource_id: Azure Resource ID of the Managed Disk. Required.
        :paramtype managed_disk_azure_resource_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.managed_disk_azure_resource_id = managed_disk_azure_resource_id
        self.lun = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class IscsiTarget(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Response for iSCSI Target requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar system_data: Resource metadata required by ARM RPC.
    :vartype system_data: ~azure.mgmt.storagepool.models.SystemMetadata
    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar managed_by_extended: List of Azure resource ids that manage this resource.
    :vartype managed_by_extended: list[str]
    :ivar acl_mode: Mode for Target connectivity. Required. Known values are: "Dynamic" and
     "Static".
    :vartype acl_mode: str or ~azure.mgmt.storagepool.models.IscsiTargetAclMode
    :ivar static_acls: Access Control List (ACL) for an iSCSI Target; defines LUN masking policy.
    :vartype static_acls: list[~azure.mgmt.storagepool.models.Acl]
    :ivar luns: List of LUNs to be exposed through iSCSI Target.
    :vartype luns: list[~azure.mgmt.storagepool.models.IscsiLun]
    :ivar target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
     "iqn.2005-03.org.iscsi:server". Required.
    :vartype target_iqn: str
    :ivar provisioning_state: State of the operation on the resource. Required. Known values are:
     "Invalid", "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagepool.models.ProvisioningStates
    :ivar status: Operational status of the iSCSI Target. Required. Known values are: "Invalid",
     "Unknown", "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped
     (deallocated)".
    :vartype status: str or ~azure.mgmt.storagepool.models.OperationalStatus
    :ivar endpoints: List of private IPv4 addresses to connect to the iSCSI Target.
    :vartype endpoints: list[str]
    :ivar port: The port used by iSCSI Target portal group.
    :vartype port: int
    :ivar sessions: List of identifiers for active sessions on the iSCSI target.
    :vartype sessions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "managed_by": {"readonly": True},
        "managed_by_extended": {"readonly": True},
        "acl_mode": {"required": True},
        "target_iqn": {"required": True},
        "provisioning_state": {"required": True, "readonly": True},
        "status": {"required": True},
        "sessions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemMetadata"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "acl_mode": {"key": "properties.aclMode", "type": "str"},
        "static_acls": {"key": "properties.staticAcls", "type": "[Acl]"},
        "luns": {"key": "properties.luns", "type": "[IscsiLun]"},
        "target_iqn": {"key": "properties.targetIqn", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "endpoints": {"key": "properties.endpoints", "type": "[str]"},
        "port": {"key": "properties.port", "type": "int"},
        "sessions": {"key": "properties.sessions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        acl_mode: Union[str, "_models.IscsiTargetAclMode"],
        target_iqn: str,
        status: Union[str, "_models.OperationalStatus"],
        static_acls: Optional[List["_models.Acl"]] = None,
        luns: Optional[List["_models.IscsiLun"]] = None,
        endpoints: Optional[List[str]] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword acl_mode: Mode for Target connectivity. Required. Known values are: "Dynamic" and
         "Static".
        :paramtype acl_mode: str or ~azure.mgmt.storagepool.models.IscsiTargetAclMode
        :keyword static_acls: Access Control List (ACL) for an iSCSI Target; defines LUN masking
         policy.
        :paramtype static_acls: list[~azure.mgmt.storagepool.models.Acl]
        :keyword luns: List of LUNs to be exposed through iSCSI Target.
        :paramtype luns: list[~azure.mgmt.storagepool.models.IscsiLun]
        :keyword target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
         "iqn.2005-03.org.iscsi:server". Required.
        :paramtype target_iqn: str
        :keyword status: Operational status of the iSCSI Target. Required. Known values are: "Invalid",
         "Unknown", "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped
         (deallocated)".
        :paramtype status: str or ~azure.mgmt.storagepool.models.OperationalStatus
        :keyword endpoints: List of private IPv4 addresses to connect to the iSCSI Target.
        :paramtype endpoints: list[str]
        :keyword port: The port used by iSCSI Target portal group.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.managed_by = None
        self.managed_by_extended = None
        self.acl_mode = acl_mode
        self.static_acls = static_acls
        self.luns = luns
        self.target_iqn = target_iqn
        self.provisioning_state = None
        self.status = status
        self.endpoints = endpoints
        self.port = port
        self.sessions = None


class IscsiTargetCreate(ProxyResource):
    """Payload for iSCSI Target create or update requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar managed_by_extended: List of Azure resource ids that manage this resource.
    :vartype managed_by_extended: list[str]
    :ivar acl_mode: Mode for Target connectivity. Required. Known values are: "Dynamic" and
     "Static".
    :vartype acl_mode: str or ~azure.mgmt.storagepool.models.IscsiTargetAclMode
    :ivar target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
     "iqn.2005-03.org.iscsi:server".
    :vartype target_iqn: str
    :ivar static_acls: Access Control List (ACL) for an iSCSI Target; defines LUN masking policy.
    :vartype static_acls: list[~azure.mgmt.storagepool.models.Acl]
    :ivar luns: List of LUNs to be exposed through iSCSI Target.
    :vartype luns: list[~azure.mgmt.storagepool.models.IscsiLun]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "acl_mode": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "acl_mode": {"key": "properties.aclMode", "type": "str"},
        "target_iqn": {"key": "properties.targetIqn", "type": "str"},
        "static_acls": {"key": "properties.staticAcls", "type": "[Acl]"},
        "luns": {"key": "properties.luns", "type": "[IscsiLun]"},
    }

    def __init__(
        self,
        *,
        acl_mode: Union[str, "_models.IscsiTargetAclMode"],
        managed_by: Optional[str] = None,
        managed_by_extended: Optional[List[str]] = None,
        target_iqn: Optional[str] = None,
        static_acls: Optional[List["_models.Acl"]] = None,
        luns: Optional[List["_models.IscsiLun"]] = None,
        **kwargs
    ):
        """
        :keyword managed_by: Azure resource id. Indicates if this resource is managed by another Azure
         resource.
        :paramtype managed_by: str
        :keyword managed_by_extended: List of Azure resource ids that manage this resource.
        :paramtype managed_by_extended: list[str]
        :keyword acl_mode: Mode for Target connectivity. Required. Known values are: "Dynamic" and
         "Static".
        :paramtype acl_mode: str or ~azure.mgmt.storagepool.models.IscsiTargetAclMode
        :keyword target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
         "iqn.2005-03.org.iscsi:server".
        :paramtype target_iqn: str
        :keyword static_acls: Access Control List (ACL) for an iSCSI Target; defines LUN masking
         policy.
        :paramtype static_acls: list[~azure.mgmt.storagepool.models.Acl]
        :keyword luns: List of LUNs to be exposed through iSCSI Target.
        :paramtype luns: list[~azure.mgmt.storagepool.models.IscsiLun]
        """
        super().__init__(**kwargs)
        self.managed_by = managed_by
        self.managed_by_extended = managed_by_extended
        self.acl_mode = acl_mode
        self.target_iqn = target_iqn
        self.static_acls = static_acls
        self.luns = luns


class IscsiTargetList(_serialization.Model):
    """List of iSCSI Targets.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of iSCSI Targets in a Disk Pool. Required.
    :vartype value: list[~azure.mgmt.storagepool.models.IscsiTarget]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IscsiTarget]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IscsiTarget"], **kwargs):
        """
        :keyword value: An array of iSCSI Targets in a Disk Pool. Required.
        :paramtype value: list[~azure.mgmt.storagepool.models.IscsiTarget]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IscsiTargetUpdate(ProxyResource):
    """Payload for iSCSI Target update requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar managed_by_extended: List of Azure resource ids that manage this resource.
    :vartype managed_by_extended: list[str]
    :ivar static_acls: Access Control List (ACL) for an iSCSI Target; defines LUN masking policy.
    :vartype static_acls: list[~azure.mgmt.storagepool.models.Acl]
    :ivar luns: List of LUNs to be exposed through iSCSI Target.
    :vartype luns: list[~azure.mgmt.storagepool.models.IscsiLun]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "static_acls": {"key": "properties.staticAcls", "type": "[Acl]"},
        "luns": {"key": "properties.luns", "type": "[IscsiLun]"},
    }

    def __init__(
        self,
        *,
        managed_by: Optional[str] = None,
        managed_by_extended: Optional[List[str]] = None,
        static_acls: Optional[List["_models.Acl"]] = None,
        luns: Optional[List["_models.IscsiLun"]] = None,
        **kwargs
    ):
        """
        :keyword managed_by: Azure resource id. Indicates if this resource is managed by another Azure
         resource.
        :paramtype managed_by: str
        :keyword managed_by_extended: List of Azure resource ids that manage this resource.
        :paramtype managed_by_extended: list[str]
        :keyword static_acls: Access Control List (ACL) for an iSCSI Target; defines LUN masking
         policy.
        :paramtype static_acls: list[~azure.mgmt.storagepool.models.Acl]
        :keyword luns: List of LUNs to be exposed through iSCSI Target.
        :paramtype luns: list[~azure.mgmt.storagepool.models.IscsiLun]
        """
        super().__init__(**kwargs)
        self.managed_by = managed_by
        self.managed_by_extended = managed_by_extended
        self.static_acls = static_acls
        self.luns = luns


class OutboundEnvironmentEndpoint(_serialization.Model):
    """Endpoints accessed for a common purpose that the App Service Environment requires outbound network access to.

    :ivar category: The type of service accessed by the App Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :vartype category: str
    :ivar endpoints: The endpoints that the App Service Environment reaches the service at.
    :vartype endpoints: list[~azure.mgmt.storagepool.models.EndpointDependency]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
        **kwargs
    ):
        """
        :keyword category: The type of service accessed by the App Service Environment, e.g., Azure
         Storage, Azure SQL Database, and Azure Active Directory.
        :paramtype category: str
        :keyword endpoints: The endpoints that the App Service Environment reaches the service at.
        :paramtype endpoints: list[~azure.mgmt.storagepool.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointList(_serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.storagepool.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OutboundEnvironmentEndpoint"], **kwargs):
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.storagepool.models.OutboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceSkuCapability(_serialization.Model):
    """Capability a resource SKU has.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Capability name.
    :vartype name: str
    :ivar value: Capability value.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class ResourceSkuInfo(_serialization.Model):
    """Resource SKU Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar api_version: StoragePool RP API version.
    :vartype api_version: str
    :ivar resource_type: StoragePool resource type.
    :vartype resource_type: str
    :ivar capabilities: List of additional capabilities for StoragePool resource.
    :vartype capabilities: list[~azure.mgmt.storagepool.models.ResourceSkuCapability]
    :ivar location_info: Zones and zone capabilities in those locations where the SKU is available.
    :vartype location_info: ~azure.mgmt.storagepool.models.ResourceSkuLocationInfo
    :ivar name: Sku name.
    :vartype name: str
    :ivar tier: Sku tier.
    :vartype tier: str
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.storagepool.models.ResourceSkuRestrictions]
    """

    _validation = {
        "api_version": {"readonly": True},
        "resource_type": {"readonly": True},
        "capabilities": {"readonly": True},
        "location_info": {"readonly": True},
        "name": {"readonly": True},
        "tier": {"readonly": True},
        "restrictions": {"readonly": True},
    }

    _attribute_map = {
        "api_version": {"key": "apiVersion", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapability]"},
        "location_info": {"key": "locationInfo", "type": "ResourceSkuLocationInfo"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.api_version = None
        self.resource_type = None
        self.capabilities = None
        self.location_info = None
        self.name = None
        self.tier = None
        self.restrictions = None


class ResourceSkuListResult(_serialization.Model):
    """List Disk Pool skus operation response.

    :ivar value: The list of StoragePool resource skus.
    :vartype value: list[~azure.mgmt.storagepool.models.ResourceSkuInfo]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSkuInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ResourceSkuInfo"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of StoragePool resource skus.
        :paramtype value: list[~azure.mgmt.storagepool.models.ResourceSkuInfo]
        :keyword next_link: URI to fetch the next section of the paginated response.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSkuLocationInfo(_serialization.Model):
    """Zone and capability info for resource sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the SKU.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific zones.
    :vartype zone_details: list[~azure.mgmt.storagepool.models.ResourceSkuZoneDetails]
    """

    _validation = {
        "location": {"readonly": True},
        "zones": {"readonly": True},
        "zone_details": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "zone_details": {"key": "zoneDetails", "type": "[ResourceSkuZoneDetails]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.zones = None
        self.zone_details = None


class ResourceSkuRestrictionInfo(_serialization.Model):
    """Describes an available Compute SKU Restriction Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _validation = {
        "locations": {"readonly": True},
        "zones": {"readonly": True},
    }

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.locations = None
        self.zones = None


class ResourceSkuRestrictions(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. Known values are: "Location" and "Zone".
    :vartype type: str or ~azure.mgmt.storagepool.models.ResourceSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
    :vartype restriction_info: ~azure.mgmt.storagepool.models.ResourceSkuRestrictionInfo
    :ivar reason_code: The reason for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.storagepool.models.ResourceSkuRestrictionsReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
        "restriction_info": {"readonly": True},
        "reason_code": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "restriction_info": {"key": "restrictionInfo", "type": "ResourceSkuRestrictionInfo"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.values = None
        self.restriction_info = None
        self.reason_code = None


class ResourceSkuZoneDetails(_serialization.Model):
    """Describes The zonal capabilities of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The set of zones that the SKU is available in with the specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones.
    :vartype capabilities: list[~azure.mgmt.storagepool.models.ResourceSkuCapability]
    """

    _validation = {
        "name": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapability]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.capabilities = None


class Sku(_serialization.Model):
    """Sku for ARM resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Sku name. Required.
    :vartype name: str
    :ivar tier: Sku tier.
    :vartype tier: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: str, tier: Optional[str] = None, **kwargs):
        """
        :keyword name: Sku name. Required.
        :paramtype name: str
        :keyword tier: Sku tier.
        :paramtype tier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class StoragePoolOperationDisplay(_serialization.Model):
    """Metadata about an operation.

    All required parameters must be populated in order to send to Azure.

    :ivar provider: Localized friendly form of the resource provider name. Required.
    :vartype provider: str
    :ivar resource: Localized friendly form of the resource type related to this action/operation.
     Required.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation, as it should be shown to the user.
     Required.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation, as it should be shown to
     the user. Required.
    :vartype description: str
    """

    _validation = {
        "provider": {"required": True},
        "resource": {"required": True},
        "operation": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, provider: str, resource: str, operation: str, description: str, **kwargs):
        """
        :keyword provider: Localized friendly form of the resource provider name. Required.
        :paramtype provider: str
        :keyword resource: Localized friendly form of the resource type related to this
         action/operation. Required.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation, as it should be shown to the
         user. Required.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation, as it should be shown
         to the user. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class StoragePoolOperationListResult(_serialization.Model):
    """List of operations supported by the RP.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An array of operations supported by the StoragePool RP. Required.
    :vartype value: list[~azure.mgmt.storagepool.models.StoragePoolRPOperation]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StoragePoolRPOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.StoragePoolRPOperation"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: An array of operations supported by the StoragePool RP. Required.
        :paramtype value: list[~azure.mgmt.storagepool.models.StoragePoolRPOperation]
        :keyword next_link: URI to fetch the next section of the paginated response.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class StoragePoolRPOperation(_serialization.Model):
    """Description of a StoragePool RP Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the operation being performed on this particular object. Required.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation applies to data-plane. Required.
    :vartype is_data_action: bool
    :ivar action_type: Indicates the action type.
    :vartype action_type: str
    :ivar display: Additional metadata about RP operation. Required.
    :vartype display: ~azure.mgmt.storagepool.models.StoragePoolOperationDisplay
    :ivar origin: The intended executor of the operation; governs the display of the operation in
     the RBAC UX and the audit logs UX.
    :vartype origin: str
    """

    _validation = {
        "name": {"required": True},
        "is_data_action": {"required": True},
        "display": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "action_type": {"key": "actionType", "type": "str"},
        "display": {"key": "display", "type": "StoragePoolOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        is_data_action: bool,
        display: "_models.StoragePoolOperationDisplay",
        action_type: Optional[str] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the operation being performed on this particular object. Required.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation applies to data-plane. Required.
        :paramtype is_data_action: bool
        :keyword action_type: Indicates the action type.
        :paramtype action_type: str
        :keyword display: Additional metadata about RP operation. Required.
        :paramtype display: ~azure.mgmt.storagepool.models.StoragePoolOperationDisplay
        :keyword origin: The intended executor of the operation; governs the display of the operation
         in the RBAC UX and the audit logs UX.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.action_type = action_type
        self.display = display
        self.origin = origin


class SystemMetadata(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storagepool.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storagepool.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.storagepool.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.storagepool.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
