# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PromptFieldDescription(Model):
    """Field description for the implementation of PSHostUserInterface.Prompt.

    :param name: The name of the prompt.
    :type name: str
    :param label: The label text of the prompt.
    :type label: str
    :param help_message: The help message of the prompt.
    :type help_message: str
    :param prompt_field_type_is_list: When set to 'true' the prompt field type
     is a list of values.
    :type prompt_field_type_is_list: bool
    :param prompt_field_type: Possible values include: 'String',
     'SecureString', 'Credential'
    :type prompt_field_type: str or
     ~azure.mgmt.servermanager.models.PromptFieldType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'help_message': {'key': 'helpMessage', 'type': 'str'},
        'prompt_field_type_is_list': {'key': 'promptFieldTypeIsList', 'type': 'bool'},
        'prompt_field_type': {'key': 'promptFieldType', 'type': 'PromptFieldType'},
    }

    def __init__(self, **kwargs):
        super(PromptFieldDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.label = kwargs.get('label', None)
        self.help_message = kwargs.get('help_message', None)
        self.prompt_field_type_is_list = kwargs.get('prompt_field_type_is_list', None)
        self.prompt_field_type = kwargs.get('prompt_field_type', None)
