# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementWorkloadGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.workload_groups.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            workload_group_name="str",
            api_version="2020-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.workload_groups.begin_create_or_update(
                resource_group_name=resource_group.name,
                server_name="str",
                database_name="str",
                workload_group_name="str",
                parameters={
                    "id": "str",
                    "importance": "str",
                    "maxResourcePercent": 0,
                    "maxResourcePercentPerRequest": 0.0,
                    "minResourcePercent": 0,
                    "minResourcePercentPerRequest": 0.0,
                    "name": "str",
                    "queryExecutionTimeout": 0,
                    "type": "str",
                },
                api_version="2020-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.workload_groups.begin_delete(
                resource_group_name=resource_group.name,
                server_name="str",
                database_name="str",
                workload_group_name="str",
                api_version="2020-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_database(self, resource_group):
        response = self.client.workload_groups.list_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2020-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
