/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jbet.CPException;
import jbet.CPInterface;
import jbet.ClassFileException;
import jbet.CpClass;
import jbet.CpDouble;
import jbet.CpEntry;
import jbet.CpFieldRef;
import jbet.CpFloat;
import jbet.CpInteger;
import jbet.CpLong;
import jbet.CpMethodRef;
import jbet.CpNameAndType;
import jbet.CpString;
import jbet.CpUtf8;
import jbet.Descriptor;
import jbet.LineWriter;
import jbet.Type;

final class ConstantPool
extends CPInterface {
    private Vector cpVector;
    private Hashtable hashtable;

    ConstantPool() {
        this.hashtable = new Hashtable();
        this.cpVector = new Vector();
        this.cpVector.addElement(null);
    }

    ConstantPool(DataInputStream dataIn) throws IOException, ClassFileException {
        CpEntry cp;
        int size = dataIn.readUnsignedShort();
        this.cpVector = new Vector(size);
        this.cpVector.setSize(size);
        this.hashtable = new Hashtable();
        int i = 1;
        while (i < size) {
            byte tag = (byte)dataIn.readUnsignedByte();
            switch (tag) {
                case 7: {
                    cp = new CpClass(i, this);
                    ((CpClass)cp).nameIndex = dataIn.readUnsignedShort();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 9: {
                    cp = new CpFieldRef(i, this);
                    ((CpFieldRef)cp).classIndex = dataIn.readUnsignedShort();
                    ((CpFieldRef)cp).nameAndTypeIndex = dataIn.readUnsignedShort();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 10: {
                    cp = new CpMethodRef(i, this, false);
                    ((CpMethodRef)cp).classIndex = dataIn.readUnsignedShort();
                    ((CpMethodRef)cp).nameAndTypeIndex = dataIn.readUnsignedShort();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 11: {
                    cp = new CpMethodRef(i, this, true);
                    ((CpMethodRef)cp).classIndex = dataIn.readUnsignedShort();
                    ((CpMethodRef)cp).nameAndTypeIndex = dataIn.readUnsignedShort();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 8: {
                    cp = new CpString(i, this);
                    ((CpString)cp).stringIndex = dataIn.readUnsignedShort();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 3: {
                    cp = new CpInteger(i, this);
                    ((CpInteger)cp).value = dataIn.readInt();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 4: {
                    cp = new CpFloat(i, this);
                    ((CpFloat)cp).value = dataIn.readFloat();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 5: {
                    cp = new CpLong(i, this);
                    ((CpLong)cp).value = dataIn.readLong();
                    this.cpVector.setElementAt(cp, i);
                    ++i;
                    break;
                }
                case 6: {
                    cp = new CpDouble(i, this);
                    ((CpDouble)cp).value = dataIn.readDouble();
                    this.cpVector.setElementAt(cp, i);
                    ++i;
                    break;
                }
                case 12: {
                    cp = new CpNameAndType(i, this);
                    ((CpNameAndType)cp).nameIndex = dataIn.readUnsignedShort();
                    ((CpNameAndType)cp).typeIndex = dataIn.readUnsignedShort();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                case 1: {
                    cp = new CpUtf8(i, this);
                    ((CpUtf8)cp).string = dataIn.readUTF();
                    this.cpVector.setElementAt(cp, i);
                    break;
                }
                default: {
                    throw new RuntimeException("error reading constant pool");
                }
            }
            ++i;
        }
        int i2 = 1;
        while (i2 < this.cpVector.size()) {
            cp = (CpEntry)this.cpVector.elementAt(i2);
            cp.setup();
            this.hashtable.put(cp, cp);
            if (cp.tag == 5 || cp.tag == 6) {
                ++i2;
            }
            ++i2;
        }
    }

    void writeFile(DataOutputStream dataOutputStream) throws IOException {
        Vector vector;
        DataOutputStream dataOutputStream2;
        ConstantPool constantPool;
        ConstantPool constantPool2 = constantPool = this;
        ConstantPool constantPool3 = constantPool;
        DataOutputStream dataOutputStream3 = dataOutputStream2 = dataOutputStream;
        Vector vector2 = constantPool2.cpVector;
        int n = vector2.size();
        dataOutputStream2.writeShort(n);
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        int n5 = 1;
        while (n4 < (vector = constantPool.cpVector).size()) {
            CpEntry cpEntry;
            Vector vector3 = constantPool3.cpVector;
            CpEntry cpEntry2 = cpEntry = (CpEntry)vector3.elementAt(n5);
            cpEntry2.write(dataOutputStream3);
            if (cpEntry2.tag == 5 || cpEntry.tag == 6) {
                n3 = n2 + 1;
            }
            int n6 = n3;
            n3 = n2 = n6 + 1;
            n4 = n2;
            n5 = n2;
        }
    }

    void printout(LineWriter lineWriter) {
        ConstantPool constantPool;
        ConstantPool constantPool2 = constantPool = this;
        ConstantPool constantPool3 = constantPool;
        LineWriter lineWriter2 = lineWriter;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        while (n2 < constantPool3.poolCount()) {
            if (constantPool.elementAt(n) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = n4;
                StringBuffer stringBuffer2 = stringBuffer.append(n5);
                StringBuffer stringBuffer3 = stringBuffer2.append("\t");
                CpEntry cpEntry = constantPool2.elementAt(n5);
                String string = cpEntry.recString();
                StringBuffer stringBuffer4 = stringBuffer3.append(string);
                String string2 = stringBuffer4.toString();
                lineWriter2.println(string2);
            }
            int n6 = n3;
            n2 = n = n6 + 1;
            n3 = n;
            n4 = n;
        }
    }

    int tagAt(int n) {
        int n2;
        ConstantPool constantPool;
        ConstantPool constantPool2 = constantPool = this;
        int n3 = n;
        int n4 = n3;
        if (constantPool.elementAt(n4) == null) {
            n2 = 0;
        } else {
            CpEntry cpEntry = constantPool2.elementAt(n3);
            n2 = cpEntry.tag;
        }
        return n2;
    }

    CpEntry elementAt(int n) {
        ConstantPool constantPool = this;
        int n2 = n;
        Vector vector = constantPool.cpVector;
        return (CpEntry)vector.elementAt(n2);
    }

    int poolCount() {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        return vector.size();
    }

    int integerAt(int n) throws ClassFileException {
        int n2;
        ConstantPool constantPool = this;
        int n3 = n2 = n;
        Vector vector = constantPool.cpVector;
        Object e = vector.elementAt(n2);
        if (!(e instanceof CpInteger)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a integer ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n3);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return ((CpInteger)e).value;
    }

    float floatAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpFloat)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a float ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return ((CpFloat)e).value;
    }

    long longAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpLong)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a long ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return ((CpLong)e).value;
    }

    double doubleAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpDouble)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a double ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return ((CpDouble)e).value;
    }

    String utf8At(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpUtf8)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a utf8 ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return ((CpUtf8)e).string;
    }

    String stringAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpString)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a string ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return ((CpString)e).string();
    }

    CpNameAndType cpNameAndTypeAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (e instanceof CpNameAndType) {
            return (CpNameAndType)e;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("not a name_and_type ");
        StringBuffer stringBuffer3 = stringBuffer2.append(n2);
        String string = stringBuffer3.toString();
        throw new CPException(string);
    }

    CpInteger cpIntegerAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpInteger)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a integer ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpInteger)e;
    }

    CpFloat cpFloatAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpFloat)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a float ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpFloat)e;
    }

    CpLong cpLongAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpLong)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a long ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpLong)e;
    }

    CpDouble cpDoubleAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpDouble)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a double ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpDouble)e;
    }

    CpUtf8 cpUtf8At(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpUtf8)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a utf8 ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpUtf8)e;
    }

    CpClass cpClassAt(int n) throws ClassFileException {
        Object e;
        int n2;
        ConstantPool constantPool = this;
        int n3 = n2 = n;
        Vector vector = constantPool.cpVector;
        Object e2 = e = vector.elementAt(n3);
        if (!(e instanceof CpClass)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a class ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            StringBuffer stringBuffer4 = stringBuffer3.append(" ");
            int n4 = ((CpEntry)e2).tag;
            StringBuffer stringBuffer5 = stringBuffer4.append(n4);
            String string = stringBuffer5.toString();
            throw new CPException(string);
        }
        return (CpClass)e;
    }

    CpString cpStringAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpString)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a string ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpString)e;
    }

    CpMethodRef cpMethodRefAt(int n) throws ClassFileException {
        ConstantPool constantPool = this;
        Vector vector = constantPool.cpVector;
        int n2 = n;
        int n3 = n2;
        Object e = vector.elementAt(n3);
        if (!(e instanceof CpMethodRef)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a methodref ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n2);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpMethodRef)e;
    }

    CpFieldRef cpFieldRefAt(int n) throws ClassFileException {
        int n2;
        ConstantPool constantPool = this;
        int n3 = n2 = n;
        Vector vector = constantPool.cpVector;
        Object e = vector.elementAt(n2);
        if (!(e instanceof CpFieldRef)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("not a fieldref ");
            StringBuffer stringBuffer3 = stringBuffer2.append(n3);
            String string = stringBuffer3.toString();
            throw new CPException(string);
        }
        return (CpFieldRef)e;
    }

    int internUtf8(String string) {
        ConstantPool constantPool;
        Hashtable hashtable = constantPool.hashtable;
        ConstantPool constantPool2 = this;
        ConstantPool constantPool3 = constantPool2;
        constantPool = constantPool3;
        String string2 = string;
        CpUtf8 cpUtf8 = new CpUtf8(constantPool, string2);
        CpUtf8 cpUtf82 = cpUtf8;
        CpUtf8 cpUtf83 = (CpUtf8)hashtable.get(cpUtf82);
        if (cpUtf83 != null) {
            return cpUtf83.index;
        }
        CpUtf8 cpUtf84 = cpUtf8;
        constantPool2.appendRec(cpUtf84);
        return cpUtf84.index;
    }

    int internClass(String string) {
        ConstantPool constantPool;
        String string2;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        String string3 = string2 = string;
        String string4 = string2;
        if (string3 == null) {
            return 0;
        }
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool3;
        CpClass cpClass = new CpClass(constantPool, string4);
        CpClass cpClass2 = cpClass;
        CpClass cpClass3 = (CpClass)hashtable.get(cpClass2);
        if (cpClass3 != null) {
            return cpClass3.index;
        }
        ConstantPool constantPool4 = constantPool2;
        int n = constantPool4.internUtf8(string2);
        CpClass cpClass4 = cpClass;
        cpClass.nameIndex = n;
        constantPool4.appendRec(cpClass4);
        return cpClass4.index;
    }

    int internString(String string) {
        ConstantPool constantPool;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool2;
        String string2 = string;
        String string3 = string2;
        CpString cpString = new CpString(constantPool, string3);
        CpString cpString2 = cpString;
        CpString cpString3 = (CpString)hashtable.get(cpString2);
        if (cpString3 != null) {
            return cpString3.index;
        }
        ConstantPool constantPool4 = constantPool3;
        int n = constantPool4.internUtf8(string2);
        CpString cpString4 = cpString;
        cpString.stringIndex = n;
        constantPool4.appendRec(cpString4);
        return cpString4.index;
    }

    int internMethodRef(String string, String string2, Descriptor descriptor) {
        int n;
        ConstantPool constantPool;
        String string3;
        String string4;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        String string5 = string4 = string;
        String string6 = string3 = string2;
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool3;
        Descriptor descriptor2 = descriptor;
        Descriptor descriptor3 = descriptor2;
        CpMethodRef cpMethodRef = new CpMethodRef(constantPool, false, string4, string3, descriptor3);
        CpMethodRef cpMethodRef2 = cpMethodRef;
        CpMethodRef cpMethodRef3 = (CpMethodRef)hashtable.get(cpMethodRef2);
        if (cpMethodRef3 != null) {
            return cpMethodRef3.index;
        }
        ConstantPool constantPool4 = constantPool2;
        int n2 = constantPool4.internClass(string5);
        CpMethodRef cpMethodRef4 = cpMethodRef;
        cpMethodRef.classIndex = n2;
        cpMethodRef4.nameAndTypeIndex = n = constantPool4.internNameAndType(string6, descriptor2);
        constantPool4.appendRec(cpMethodRef4);
        return cpMethodRef4.index;
    }

    int internInterfaceMethodRef(String string, String string2, Descriptor descriptor) {
        int n;
        ConstantPool constantPool;
        String string3;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        String string4 = string3 = string;
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool2;
        String string5 = string2;
        String string6 = string5;
        Descriptor descriptor2 = descriptor;
        Descriptor descriptor3 = descriptor2;
        CpMethodRef cpMethodRef = new CpMethodRef(constantPool, true, string3, string6, descriptor3);
        CpMethodRef cpMethodRef2 = cpMethodRef;
        CpMethodRef cpMethodRef3 = (CpMethodRef)hashtable.get(cpMethodRef2);
        if (cpMethodRef3 != null) {
            return cpMethodRef3.index;
        }
        ConstantPool constantPool4 = constantPool3;
        int n2 = constantPool4.internClass(string4);
        CpMethodRef cpMethodRef4 = cpMethodRef;
        cpMethodRef.classIndex = n2;
        cpMethodRef4.nameAndTypeIndex = n = constantPool4.internNameAndType(string5, descriptor2);
        constantPool4.appendRec(cpMethodRef4);
        return cpMethodRef4.index;
    }

    int internFieldRef(String string, String string2, Type type) {
        int n;
        ConstantPool constantPool;
        Type type2;
        String string3;
        String string4;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        String string5 = string4 = string;
        String string6 = string3 = string2;
        Type type3 = type2 = type;
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool2;
        CpFieldRef cpFieldRef = new CpFieldRef(constantPool, string5, string3, type2);
        CpFieldRef cpFieldRef2 = cpFieldRef;
        CpFieldRef cpFieldRef3 = (CpFieldRef)hashtable.get(cpFieldRef2);
        if (cpFieldRef3 != null) {
            return cpFieldRef3.index;
        }
        ConstantPool constantPool4 = constantPool3;
        int n2 = constantPool4.internClass(string4);
        CpFieldRef cpFieldRef4 = cpFieldRef;
        cpFieldRef.classIndex = n2;
        cpFieldRef4.nameAndTypeIndex = n = constantPool4.internNameAndType(string6, type3);
        constantPool4.appendRec(cpFieldRef4);
        return cpFieldRef4.index;
    }

    int internNameAndType(String string, Object object) {
        int n;
        ConstantPool constantPool;
        Object object2;
        String string2;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        String string3 = string2 = string;
        Object object3 = object2 = object;
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool3;
        CpNameAndType cpNameAndType = new CpNameAndType(constantPool, string2, object2);
        CpNameAndType cpNameAndType2 = cpNameAndType;
        CpNameAndType cpNameAndType3 = (CpNameAndType)hashtable.get(cpNameAndType2);
        if (cpNameAndType3 != null) {
            return cpNameAndType3.index;
        }
        ConstantPool constantPool4 = constantPool2;
        int n2 = constantPool4.internUtf8(string3);
        CpNameAndType cpNameAndType4 = cpNameAndType;
        cpNameAndType.nameIndex = n2;
        String string4 = object3.toString();
        cpNameAndType4.typeIndex = n = constantPool4.internUtf8(string4);
        constantPool4.appendRec(cpNameAndType4);
        return cpNameAndType4.index;
    }

    int internInteger(int n) {
        ConstantPool constantPool;
        ConstantPool constantPool2;
        ConstantPool constantPool3 = constantPool2 = this;
        Hashtable hashtable = constantPool.hashtable;
        constantPool = constantPool2;
        int n2 = n;
        CpInteger cpInteger = new CpInteger(constantPool, n2);
        CpInteger cpInteger2 = cpInteger;
        CpInteger cpInteger3 = (CpInteger)hashtable.get(cpInteger2);
        if (cpInteger3 != null) {
            return cpInteger3.index;
        }
        CpInteger cpInteger4 = cpInteger;
        constantPool3.appendRec(cpInteger4);
        return cpInteger4.index;
    }

    int internFloat(float f) {
        ConstantPool constantPool;
        Hashtable hashtable = constantPool.hashtable;
        ConstantPool constantPool2 = this;
        ConstantPool constantPool3 = constantPool2;
        constantPool = constantPool3;
        float f2 = f;
        CpFloat cpFloat = new CpFloat(constantPool, f2);
        CpFloat cpFloat2 = cpFloat;
        CpFloat cpFloat3 = (CpFloat)hashtable.get(cpFloat2);
        if (cpFloat3 != null) {
            return cpFloat3.index;
        }
        CpFloat cpFloat4 = cpFloat;
        constantPool2.appendRec(cpFloat4);
        return cpFloat4.index;
    }

    int internLong(long l) {
        ConstantPool constantPool;
        Hashtable hashtable = constantPool.hashtable;
        ConstantPool constantPool2 = this;
        ConstantPool constantPool3 = constantPool2;
        constantPool = constantPool3;
        long l2 = l;
        CpLong cpLong = new CpLong(constantPool, l2);
        CpLong cpLong2 = cpLong;
        CpLong cpLong3 = (CpLong)hashtable.get(cpLong2);
        if (cpLong3 != null) {
            return cpLong3.index;
        }
        CpLong cpLong4 = cpLong;
        constantPool2.appendRec(cpLong4);
        return cpLong4.index;
    }

    int internDouble(double d) {
        ConstantPool constantPool;
        Hashtable hashtable = constantPool.hashtable;
        ConstantPool constantPool2 = this;
        ConstantPool constantPool3 = constantPool2;
        constantPool = constantPool3;
        double d2 = d;
        CpDouble cpDouble = new CpDouble(constantPool, d2);
        CpDouble cpDouble2 = cpDouble;
        CpDouble cpDouble3 = (CpDouble)hashtable.get(cpDouble2);
        if (cpDouble3 != null) {
            return cpDouble3.index;
        }
        CpDouble cpDouble4 = cpDouble;
        constantPool2.appendRec(cpDouble4);
        return cpDouble4.index;
    }

    private int appendRec(CpEntry cpEntry) {
        int n;
        CpEntry cpEntry2;
        CpEntry cpEntry3;
        ConstantPool constantPool;
        ConstantPool constantPool2 = constantPool = this;
        ConstantPool constantPool3 = constantPool;
        CpEntry cpEntry4 = cpEntry3 = cpEntry;
        CpEntry cpEntry5 = cpEntry2 = cpEntry3;
        boolean bl = cpEntry5 instanceof CpLong;
        ConstantPool constantPool4 = constantPool3;
        Vector vector = constantPool4.cpVector;
        vector.addElement(cpEntry5);
        Vector vector2 = constantPool4.cpVector;
        cpEntry5.index = n = vector2.size() - 1;
        if (bl || cpEntry4 instanceof CpDouble) {
            Vector vector3 = constantPool2.cpVector;
            vector3.addElement(null);
        }
        Hashtable hashtable = constantPool.hashtable;
        CpEntry cpEntry6 = cpEntry3;
        hashtable.put(cpEntry6, cpEntry6);
        return cpEntry6.index;
    }
}

