#ifndef REP_TIMEMODEL_REPLICA_H
#define REP_TIMEMODEL_REPLICA_H

// This is an autogenerated file.
// Do not edit this file, any changes made will be lost the next time it is generated.

#include <QtCore/qobject.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qvariant.h>
#include <QtCore/qmetatype.h>

#include <QtRemoteObjects/qremoteobjectnode.h>
#include <QtRemoteObjects/qremoteobjectpendingcall.h>
#include <QtRemoteObjects/qremoteobjectreplica.h>

#include <QtCore>

class PresetInfo
{
    Q_GADGET

    Q_PROPERTY(int presetNumber READ presetNumber WRITE setPresetNumber)
    Q_PROPERTY(float frequency READ frequency WRITE setFrequency)
    Q_PROPERTY(QString stationName READ stationName WRITE setStationName)
public:
    PresetInfo() : _presetNumber(), _frequency(), _stationName() {}
    explicit PresetInfo(int presetNumber, float frequency, QString stationName) : _presetNumber(presetNumber), _frequency(frequency), _stationName(stationName) {}
    int presetNumber() const { return _presetNumber; }
    void setPresetNumber(int presetNumber) { if (presetNumber != _presetNumber) { _presetNumber = presetNumber; } }
    float frequency() const { return _frequency; }
    void setFrequency(float frequency) { if (frequency != _frequency) { _frequency = frequency; } }
    QString stationName() const { return _stationName; }
    void setStationName(QString stationName) { if (stationName != _stationName) { _stationName = stationName; } }
private:
    int _presetNumber;
    float _frequency;
    QString _stationName;
};

inline bool operator==(const PresetInfo &left, const PresetInfo &right) Q_DECL_NOTHROW {
    return left.presetNumber() == right.presetNumber() && left.frequency() == right.frequency() && left.stationName() == right.stationName();
}
inline bool operator!=(const PresetInfo &left, const PresetInfo &right) Q_DECL_NOTHROW {
    return !(left == right);
}

inline QDataStream &operator<<(QDataStream &ds, const PresetInfo &obj) {
    QtRemoteObjects::copyStoredProperties(&obj, ds);
    return ds;
}

inline QDataStream &operator>>(QDataStream &ds, PresetInfo &obj) {
    QtRemoteObjects::copyStoredProperties(ds, &obj);
    return ds;
}


class MinuteTimerReplica : public QRemoteObjectReplica
{
    Q_OBJECT
    Q_CLASSINFO(QCLASSINFO_REMOTEOBJECT_TYPE, "MinuteTimer")
    Q_CLASSINFO(QCLASSINFO_REMOTEOBJECT_SIGNATURE, "32c23d5a3ecb323ef3a644e9e67f16560b756714")
    Q_PROPERTY(int hour READ hour NOTIFY hourChanged)
    Q_PROPERTY(int minute READ minute NOTIFY minuteChanged)

public:
    MinuteTimerReplica() : QRemoteObjectReplica() { initialize(); }
    static void registerMetatypes()
    {
        static bool initialized = false;
        if (initialized)
            return;
        initialized = true;
        qRegisterMetaType<PresetInfo>();
        qRegisterMetaTypeStreamOperators<PresetInfo>();

    }

private:
    MinuteTimerReplica(QRemoteObjectNode *node, const QString &name = QString())
        : QRemoteObjectReplica(ConstructWithNode)
        { initializeNode(node, name); }

    void initialize()
    {
        MinuteTimerReplica::registerMetatypes();
        QVariantList properties;
        properties.reserve(2);
        properties << QVariant::fromValue(int(1));
        properties << QVariant::fromValue(int(51));
        setProperties(properties);
    }

public:
    virtual ~MinuteTimerReplica() {}

    int hour() const
    {
        const QVariant variant = propAsVariant(0);
        if (!variant.canConvert<int>()) {
            qWarning() << "QtRO cannot convert the property hour to type int";
        }
        return variant.value<int >();
    }

    int minute() const
    {
        const QVariant variant = propAsVariant(1);
        if (!variant.canConvert<int>()) {
            qWarning() << "QtRO cannot convert the property minute to type int";
        }
        return variant.value<int >();
    }


Q_SIGNALS:
    void hourChanged(int);
    void minuteChanged(int);
    void timeChanged();
    void timeChanged2(QTime t);
    void sendCustom(PresetInfo info);

public Q_SLOTS:
    void pushHour(int hour)
    {
        static int __repc_index = MinuteTimerReplica::staticMetaObject.indexOfSlot("pushHour(int)");
        QVariantList __repc_args;
        __repc_args << QVariant::fromValue(hour);
        send(QMetaObject::InvokeMetaMethod, __repc_index, __repc_args);
    }
    void pushMinute(int minute)
    {
        static int __repc_index = MinuteTimerReplica::staticMetaObject.indexOfSlot("pushMinute(int)");
        QVariantList __repc_args;
        __repc_args << QVariant::fromValue(minute);
        send(QMetaObject::InvokeMetaMethod, __repc_index, __repc_args);
    }
    void SetTimeZone(int zn)
    {
        static int __repc_index = MinuteTimerReplica::staticMetaObject.indexOfSlot("SetTimeZone(int)");
        QVariantList __repc_args;
        __repc_args
            << QVariant::fromValue(zn)
        ;
        send(QMetaObject::InvokeMetaMethod, __repc_index, __repc_args);
    }

private:
    friend class QT_PREPEND_NAMESPACE(QRemoteObjectNode);
};

#if (QT_VERSION < QT_VERSION_CHECK(5, 5, 0))
#endif


QT_BEGIN_NAMESPACE
QT_END_NAMESPACE


#endif // REP_TIMEMODEL_REPLICA_H
