#include <stdio.h>
#include "hangul.h"

static int pushedKey = 0; /* о Ű  Ű ϴ  */

/* --------------------------------------------------------------------- 
	 ι ѱ  迭 ǥ 
   ѱԷ»¶ 빮ڿ شϴ ۼ踦   ϴ
   ѱ۱ۼ谡   ׳ ڵ带 ش. 
   0x20(ۼ)  ε Ѵ. 
--------------------------------------------------------------------- */
static byte hanKbdTable2[] = {
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,  /*  !"#$%&' */
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,  /* ()*+,-./ */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,  /* 01234567 */
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,  /* 89:;<=>? */
	0x40, 0x41, 0x42, 0x43, 0x44, 0x86, 0x46, 0x47,  /* @ABCDEFG */
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0xA6,  /* HIJKLMNO */
	0xAC, 0x8A, 0x83, 0x53, 0x8C, 0x55, 0x56, 0x8F,  /* PQRSTUVW */
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,  /* XYZ[\]^_ */
	0x60, 0x88, 0xBA, 0x90, 0x8D, 0x85, 0x87, 0x94,  /* `abcdefg */
	0xAD, 0xA5, 0xA7, 0xA3, 0xBD, 0xBB, 0xB4, 0xA4,  /* hijklmno */
	0xAA, 0x89, 0x82, 0x84, 0x8B, 0xAB, 0x93, 0x8E,  /* pqrstuvw */
	0x92, 0xB3, 0x91, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F   /* xyz{|}~  */
};
/* --------------------------------------------------------------------- 
	  ѱ  迭 ǥ 
	 ʼ,    ڵ带 . 
--------------------------------------------------------------------- */
static byte hanKbdTable3[] = {
	0x20, 0xD8, 0x22, 0x23, 0x24, 0x25, 0x26, 0x92,  /*  !"#$%&' */
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0xAD,  /* ()*+,-./ */
	0x91, 0xDD, 0xD6, 0xD3, 0xB3, 0xBA, 0xA5, 0xAC,  /* 01234567 */
	0xBC, 0xB4, 0x3A, 0x89, 0x32, 0x3D, 0x33, 0x3F,  /* 89:;<=>? */
	0x40, 0xC8, 0x21, 0xCB, 0xCA, 0xDA, 0xC3, 0x3B,  /* @ABCDEFG */
	0x27, 0x38, 0x34, 0x35, 0x36, 0x31, 0x30, 0x39,  /* HIJKLMNO */
	0x3E, 0xDC, 0xA6, 0xC7, 0x3A, 0x37, 0xD0, 0xDB,  /* PQRSTUVW */
	0xD4, 0x3C, 0xD9, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,  /* XYZ[\]^_ */
	0x60, 0xD7, 0xB4, 0xAA, 0xBD, 0xAB, 0xA3, 0xBB,  /* `abcdefg */
	0x84, 0x88, 0x8D, 0x82, 0x8E, 0x94, 0x8B, 0x90,  /* hijklmno */
	0x93, 0xD5, 0xA4, 0xC5, 0xA7, 0x85, 0xAD, 0xC9,  /* pqrstuvw */
	0xC2, 0x87, 0xD1, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F   /* xyz{|}~  */
};

/* ۿ Էµ Ű    ְ  0 ش. */
int hinkeybuf(void) {
	return pushedKey ? pushedKey : 0;
}

/* ߰  Ű оִ´. */
void hputkey(int key) {
	pushedKey = key;
}

/* Էµ  ѱ۰̳ Ÿ Ű ȯѴ. */
int hconvertkey(int key) {
	byte *hanKbdTable; /* ι Ǵ  ѱ  迭ǥ ų  */

	/* ѱԷ»° ƴϰų ƯŰ ȮŰ  ׳ ȯ */
	if (hanMode[HAN_ENG_MODE] == ENG_INPUT || key <= 32 || key > 127)
		return key;
	/* ι,  ̺ Ͽ شε ڵ带 ȯ */
	hanKbdTable = (hanMode[HAN_JAPAN] == DUBEL_TYPE) ? hanKbdTable2 : hanKbdTable3;
	return hanKbdTable[key-32];
}

/* Ű Է ޴´. */
int hgetkey() {
	int key;

	if (pushedKey) { /* ߰  Ű ִٸ */
		key = pushedKey; /*    0 Ѵ. */
		pushedKey = 0;
	} else {
		key = hgetch(); /*  Ű ٸ  Է ޴´. */
		/* ѱԷ ޴´ٸ Ű ׿ ° ȯϰ ƴϸ ׳ ȯѴ. */
		key = hconvertkey(key);
	}
	return key;
}
