#include <stdio.h>
#include <vga.h>
#include <vgagl.h>
#include "hangul.h"
#include "hgraphics.h"
#include "hetcs.h"

void HanFontView(char *str) {
   int i, j;
   void *image, *p;
     
   hinitgraph(G640x480x256, str,"/usr/local/lib/fonts/english.fnt", USER_FONT);
   
   /* first view */
   p= HanFont1;
   for(i= 0; i< 8; i++) {
      for(j= 0; j< 20; j++) {
         image= han_bit_image(p, H_WHITE, H_BLACK);
         han_image_view(j*23+60 ,i*20+70 , image);
         p+= 32;
      }
   }
   
   /* second view */
   p= HanFont2;
   for(i= 0; i< 4; i++) {
      for(j= 0; j< 22; j++) {
         image= han_bit_image(p, H_WHITE, H_BLACK);
         han_image_view(j*20+60, i*20+250, image);
         p+= 32;
      }
   }
   
   /* third view */
   p= HanFont3;
   for(i= 0; i< 4; i++) {
      for(j= 0; j< 28; j++) {
         image= han_bit_image(p, H_WHITE, H_BLACK);
         han_image_view(j*20+60, i*20+350, image);
         p+= 32;
      }
   }
   hrectangle(0, 0, hgetmaxx(), hgetmaxy(), H_CYAN);
   gl_line(0, 40, hgetmaxx(), 40, H_CYAN);
   hputsxy(100, 12, H_LIGHTGREEN, H_BLACK, "ͥa e");
   hputsxy(350, 12, H_LIGHTBLUE, H_BLACK, "e҅  aI : ddoch");
   hputsxy(200, 450, H_LIGHTMAGENTA, H_BLACK, "e e Ёa Ai aea.");
   
   getchar();                                                   
   return;
}
         
void EngFontView(char *str) {
   int i;
   void *image, *p;
   
   hinitgraph(G640x480x256, "/usr/local/lib/fonts/hangul.fnt", str, USER_FONT);
   
   p= EngFont;
   for(i= 0; i< 256; i++) {
      image= eng_bit_image(p, H_WHITE, H_BLACK);
      eng_image_view((i%21)*20+100, (i/21)*20+100, image);
      p+= 16;
   }
   hrectangle(0, 0, hgetmaxx(), hgetmaxy(), H_CYAN);
   gl_line(0, 40, hgetmaxx(), 40, H_CYAN);
   hputsxy(100, 12, H_LIGHTGREEN, H_BLACK, "FONT VIEW First Version");
   hputsxy(350, 12, H_LIGHTBLUE, H_BLACK, "Han-donghun   Hitel ID : ddoch");
   hputsxy(200, 450, H_LIGHTMAGENTA, H_BLACK, "We want to Really Hacker..");
   getchar();
   return;
}

void main(int argc, char *argv[]) {
   FILE *ff;
   long size;
   
   if(argc != 2) {
      fprintf(stderr, "Usage : %s fontfile\n", argv[0]);
      exit(1);
   }
   
   if((size= hfilesize(argv[1])) == -1) {
      fprintf(stderr, "file not found\n");
      exit(1);
   }
   if((ff= fopen(argv[1], "rb")) == NULL) {
      fprintf(stderr, "file not open\n");
      exit(1);
   }
   fclose(ff);
   switch(size) {
      case (11520) : HanFontView(argv[1]);
                  	break;
      case (4096)  : EngFontView(argv[1]);
                  	break;
      default      : fprintf(stderr, "file size is wrong..  only 11520, 4096..\n");
                  	exit(1);
   }
   
}
   
   
