/*
 * drivers/media/i2c/smiapp/smiapp-limits.h
 *
 * Generic driver for SMIA/SMIA++ compliant camera modules
 *
 * Copyright (C) 2011--2012 Nokia Corporation
 * Contact: Sakari Ailus <sakari.ailus@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#define SMIAPP_LIMIT_ANALOGUE_GAIN_CAPABILITY			0
#define SMIAPP_LIMIT_ANALOGUE_GAIN_CODE_MIN			1
#define SMIAPP_LIMIT_ANALOGUE_GAIN_CODE_MAX			2
#define SMIAPP_LIMIT_THS_ZERO_MIN				3
#define SMIAPP_LIMIT_TCLK_TRAIL_MIN				4
#define SMIAPP_LIMIT_INTEGRATION_TIME_CAPABILITY		5
#define SMIAPP_LIMIT_COARSE_INTEGRATION_TIME_MIN		6
#define SMIAPP_LIMIT_COARSE_INTEGRATION_TIME_MAX_MARGIN		7
#define SMIAPP_LIMIT_FINE_INTEGRATION_TIME_MIN			8
#define SMIAPP_LIMIT_FINE_INTEGRATION_TIME_MAX_MARGIN		9
#define SMIAPP_LIMIT_DIGITAL_GAIN_CAPABILITY			10
#define SMIAPP_LIMIT_DIGITAL_GAIN_MIN				11
#define SMIAPP_LIMIT_DIGITAL_GAIN_MAX				12
#define SMIAPP_LIMIT_MIN_EXT_CLK_FREQ_HZ			13
#define SMIAPP_LIMIT_MAX_EXT_CLK_FREQ_HZ			14
#define SMIAPP_LIMIT_MIN_PRE_PLL_CLK_DIV			15
#define SMIAPP_LIMIT_MAX_PRE_PLL_CLK_DIV			16
#define SMIAPP_LIMIT_MIN_PLL_IP_FREQ_HZ				17
#define SMIAPP_LIMIT_MAX_PLL_IP_FREQ_HZ				18
#define SMIAPP_LIMIT_MIN_PLL_MULTIPLIER				19
#define SMIAPP_LIMIT_MAX_PLL_MULTIPLIER				20
#define SMIAPP_LIMIT_MIN_PLL_OP_FREQ_HZ				21
#define SMIAPP_LIMIT_MAX_PLL_OP_FREQ_HZ				22
#define SMIAPP_LIMIT_MIN_VT_SYS_CLK_DIV				23
#define SMIAPP_LIMIT_MAX_VT_SYS_CLK_DIV				24
#define SMIAPP_LIMIT_MIN_VT_SYS_CLK_FREQ_HZ			25
#define SMIAPP_LIMIT_MAX_VT_SYS_CLK_FREQ_HZ			26
#define SMIAPP_LIMIT_MIN_VT_PIX_CLK_FREQ_HZ			27
#define SMIAPP_LIMIT_MAX_VT_PIX_CLK_FREQ_HZ			28
#define SMIAPP_LIMIT_MIN_VT_PIX_CLK_DIV				29
#define SMIAPP_LIMIT_MAX_VT_PIX_CLK_DIV				30
#define SMIAPP_LIMIT_MIN_FRAME_LENGTH_LINES			31
#define SMIAPP_LIMIT_MAX_FRAME_LENGTH_LINES			32
#define SMIAPP_LIMIT_MIN_LINE_LENGTH_PCK			33
#define SMIAPP_LIMIT_MAX_LINE_LENGTH_PCK			34
#define SMIAPP_LIMIT_MIN_LINE_BLANKING_PCK			35
#define SMIAPP_LIMIT_MIN_FRAME_BLANKING_LINES			36
#define SMIAPP_LIMIT_MIN_LINE_LENGTH_PCK_STEP_SIZE		37
#define SMIAPP_LIMIT_MIN_OP_SYS_CLK_DIV				38
#define SMIAPP_LIMIT_MAX_OP_SYS_CLK_DIV				39
#define SMIAPP_LIMIT_MIN_OP_SYS_CLK_FREQ_HZ			40
#define SMIAPP_LIMIT_MAX_OP_SYS_CLK_FREQ_HZ			41
#define SMIAPP_LIMIT_MIN_OP_PIX_CLK_DIV				42
#define SMIAPP_LIMIT_MAX_OP_PIX_CLK_DIV				43
#define SMIAPP_LIMIT_MIN_OP_PIX_CLK_FREQ_HZ			44
#define SMIAPP_LIMIT_MAX_OP_PIX_CLK_FREQ_HZ			45
#define SMIAPP_LIMIT_X_ADDR_MIN					46
#define SMIAPP_LIMIT_Y_ADDR_MIN					47
#define SMIAPP_LIMIT_X_ADDR_MAX					48
#define SMIAPP_LIMIT_Y_ADDR_MAX					49
#define SMIAPP_LIMIT_MIN_X_OUTPUT_SIZE				50
#define SMIAPP_LIMIT_MIN_Y_OUTPUT_SIZE				51
#define SMIAPP_LIMIT_MAX_X_OUTPUT_SIZE				52
#define SMIAPP_LIMIT_MAX_Y_OUTPUT_SIZE				53
#define SMIAPP_LIMIT_MIN_EVEN_INC				54
#define SMIAPP_LIMIT_MAX_EVEN_INC				55
#define SMIAPP_LIMIT_MIN_ODD_INC				56
#define SMIAPP_LIMIT_MAX_ODD_INC				57
#define SMIAPP_LIMIT_SCALING_CAPABILITY				58
#define SMIAPP_LIMIT_SCALER_M_MIN				59
#define SMIAPP_LIMIT_SCALER_M_MAX				60
#define SMIAPP_LIMIT_SCALER_N_MIN				61
#define SMIAPP_LIMIT_SCALER_N_MAX				62
#define SMIAPP_LIMIT_SPATIAL_SAMPLING_CAPABILITY		63
#define SMIAPP_LIMIT_DIGITAL_CROP_CAPABILITY			64
#define SMIAPP_LIMIT_COMPRESSION_CAPABILITY			65
#define SMIAPP_LIMIT_FIFO_SUPPORT_CAPABILITY			66
#define SMIAPP_LIMIT_DPHY_CTRL_CAPABILITY			67
#define SMIAPP_LIMIT_CSI_LANE_MODE_CAPABILITY			68
#define SMIAPP_LIMIT_CSI_SIGNALLING_MODE_CAPABILITY		69
#define SMIAPP_LIMIT_FAST_STANDBY_CAPABILITY			70
#define SMIAPP_LIMIT_CCI_ADDRESS_CONTROL_CAPABILITY		71
#define SMIAPP_LIMIT_MAX_PER_LANE_BITRATE_1_LANE_MODE_MBPS	72
#define SMIAPP_LIMIT_MAX_PER_LANE_BITRATE_2_LANE_MODE_MBPS	73
#define SMIAPP_LIMIT_MAX_PER_LANE_BITRATE_3_LANE_MODE_MBPS	74
#define SMIAPP_LIMIT_MAX_PER_LANE_BITRATE_4_LANE_MODE_MBPS	75
#define SMIAPP_LIMIT_TEMP_SENSOR_CAPABILITY			76
#define SMIAPP_LIMIT_MIN_FRAME_LENGTH_LINES_BIN			77
#define SMIAPP_LIMIT_MAX_FRAME_LENGTH_LINES_BIN			78
#define SMIAPP_LIMIT_MIN_LINE_LENGTH_PCK_BIN			79
#define SMIAPP_LIMIT_MAX_LINE_LENGTH_PCK_BIN			80
#define SMIAPP_LIMIT_MIN_LINE_BLANKING_PCK_BIN			81
#define SMIAPP_LIMIT_FINE_INTEGRATION_TIME_MIN_BIN		82
#define SMIAPP_LIMIT_FINE_INTEGRATION_TIME_MAX_MARGIN_BIN	83
#define SMIAPP_LIMIT_BINNING_CAPABILITY				84
#define SMIAPP_LIMIT_BINNING_WEIGHTING_CAPABILITY		85
#define SMIAPP_LIMIT_DATA_TRANSFER_IF_CAPABILITY		86
#define SMIAPP_LIMIT_SHADING_CORRECTION_CAPABILITY		87
#define SMIAPP_LIMIT_GREEN_IMBALANCE_CAPABILITY			88
#define SMIAPP_LIMIT_BLACK_LEVEL_CAPABILITY			89
#define SMIAPP_LIMIT_MODULE_SPECIFIC_CORRECTION_CAPABILITY	90
#define SMIAPP_LIMIT_DEFECT_CORRECTION_CAPABILITY		91
#define SMIAPP_LIMIT_DEFECT_CORRECTION_CAPABILITY_2		92
#define SMIAPP_LIMIT_EDOF_CAPABILITY				93
#define SMIAPP_LIMIT_COLOUR_FEEDBACK_CAPABILITY			94
#define SMIAPP_LIMIT_ESTIMATION_MODE_CAPABILITY			95
#define SMIAPP_LIMIT_ESTIMATION_ZONE_CAPABILITY			96
#define SMIAPP_LIMIT_CAPABILITY_TRDY_MIN			97
#define SMIAPP_LIMIT_FLASH_MODE_CAPABILITY			98
#define SMIAPP_LIMIT_ACTUATOR_CAPABILITY			99
#define SMIAPP_LIMIT_BRACKETING_LUT_CAPABILITY_1		100
#define SMIAPP_LIMIT_BRACKETING_LUT_CAPABILITY_2		101
#define SMIAPP_LIMIT_ANALOGUE_GAIN_CODE_STEP			102
#define SMIAPP_LIMIT_LAST					103
