#ifndef _PARISC_MSGBUF_H
#define _PARISC_MSGBUF_H

/* 
 * The msqid64_ds structure for parisc architecture, copied from sparc.
 * Note extra padding because this structure is passed back and forth
 * between kernel and user space.
 *
 * Pad space is left for:
 * - 64-bit time_t to solve y2038 problem
 * - 2 miscellaneous 32-bit values
 */

struct msqid64_ds {
	struct ipc64_perm msg_perm;
	unsigned int   __pad1;
	__kernel_time_t msg_stime;	/* last msgsnd time */
	unsigned int   __pad2;
	__kernel_time_t msg_rtime;	/* last msgrcv time */
	unsigned int   __pad3;
	__kernel_time_t msg_ctime;	/* last change time */
	unsigned int  msg_cbytes;	/* current number of bytes on queue */
	unsigned int  msg_qnum;	/* number of messages in queue */
	unsigned int  msg_qbytes;	/* max number of bytes on queue */
	__kernel_pid_t msg_lspid;	/* pid of last msgsnd */
	__kernel_pid_t msg_lrpid;	/* last receive pid */
	unsigned int  __unused1;
	unsigned int  __unused2;
};

#endif /* _PARISC_MSGBUF_H */
