/* $Id: head.S,v 1.39 1995/11/25 00:58:01 davem Exp $
 * head.S: The initial boot code for the Sparc port of Linux.
 *
 * Copyright (C) 1995 David S. Miller (davem@caip.rutgers.edu)
 * Copyright (C) 1995 Peter Zaitcev   (Zaitcev@ipmce.su)
 */

#include <linux/version.h>

#include <asm/cprefix.h>
#include <asm/head.h>
#include <asm/asi.h>
#include <asm/contregs.h>
#include <asm/ptrace.h>
#include <asm/psr.h>
#include <asm/page.h>
#include <asm/kdebug.h>
#include <asm/winmacro.h>

	.data
/* 
 * The following are used with the prom_vector node-ops to figure out
 * the cpu-type 
 */

	.align 4
        .globl  C_LABEL(cputyp)
C_LABEL(cputyp):
        .word   1

	.align 4
	.globl C_LABEL(cputypval)
C_LABEL(cputypval):
	.asciz "sun4c"
	.ascii "     "

C_LABEL(cputypvalend):
C_LABEL(cputypvallen) = C_LABEL(cputypvar) - C_LABEL(cputypval)

	.align 4
/*
 * Sun people can't spell worth damn. "compatability" indeed.
 * At least we *know* we can't spell, and use a spell-checker.
 */

/* Uh, actually Linus it is I who cannot spell. Too much murky
 * Sparc assembly will do this to ya.
 */
C_LABEL(cputypvar):
	.asciz "compatability"

/* Tested on SS-5, SS-10. Probably someone at Sun applied a spell-checker. --P3 */
	.align 4
C_LABEL(cputypvar_sun4m):
	.asciz "compatible"

	.align 4
sun4_notsup:
	.asciz  "Sparc-Linux sun4 support not implemented yet\n\n"
	.align 4

sun4d_notsup:
        .asciz  "Sparc-Linux sun4d support does not exist\n\n"
	.align 4

sun4e_notsup:
        .asciz  "Sparc-Linux sun4e support does not exist\n\n"
	.align 4

sun4u_notsup:
        .asciz  "Sparc-Linux sun4u support does not exist\n\n"
	.align 4

	/* The Sparc trap table, bootloader gives us control at _start. */
	.text
	.globl	start, _stext, _start, __stext
	.globl  C_LABEL(trapbase)
_start:   /* danger danger */
__stext:
_stext:
start:
C_LABEL(trapbase):
/* We get control passed to us here at t_zero. */
t_zero:	b gokernel; nop; nop; nop;
t_tflt:	TRAP_ENTRY(0x1, sparc_fault)        /* Inst. Access Exception        */
t_bins:	TRAP_ENTRY(0x2, bad_instruction)    /* Illegal Instruction           */
t_pins:	TRAP_ENTRY(0x3, priv_instruction)   /* Privileged Instruction        */
t_fpd:	TRAP_ENTRY(0x4, fpd_trap_handler)   /* Floating Point Disabled       */
t_wovf:	WINDOW_SPILL                        /* Window Overflow               */
t_wunf:	WINDOW_FILL                         /* Window Underflow              */
t_mna:	TRAP_ENTRY(0x7, mna_handler)        /* Memory Address Not Aligned    */
t_fpe:	TRAP_ENTRY(0x8, fpe_trap_handler)   /* Floating Point Exception      */
t_dflt:	TRAP_ENTRY(0x9, sparc_fault)        /* Data Miss Exception           */
t_tio:	TRAP_ENTRY(0xa, do_tag_overflow)    /* Tagged Instruction Ovrflw     */
t_wpt:	TRAP_ENTRY(0xb, do_watchpoint)      /* Watchpoint Detected           */
t_badc:	BAD_TRAP(0xc) BAD_TRAP(0xd) BAD_TRAP(0xe) BAD_TRAP(0xf) BAD_TRAP(0x10)
t_irq1:	TRAP_ENTRY_SOFTINT(1)               /* IRQ Software/SBUS Level 1     */
t_irq2:	TRAP_ENTRY_INTERRUPT(2)             /* IRQ SBUS Level 2              */
t_irq3:	TRAP_ENTRY_INTERRUPT(3)             /* IRQ SCSI/DMA/SBUS Level 3     */
t_irq4:	TRAP_ENTRY_SOFTINT(4)               /* IRQ Software Level 4          */
t_irq5:	TRAP_ENTRY_INTERRUPT(5)             /* IRQ SBUS/Ethernet Level 5     */
t_irq6:	TRAP_ENTRY_SOFTINT(6)               /* IRQ Software Level 6          */
t_irq7:	TRAP_ENTRY_INTERRUPT(7)             /* IRQ Video/SBUS Level 5        */
t_irq8:	TRAP_ENTRY_INTERRUPT(8)             /* IRQ SBUS Level 6              */
t_irq9:	TRAP_ENTRY_INTERRUPT(9)             /* IRQ SBUS Level 7              */
t_irq10:TRAP_ENTRY_INTERRUPT(10)            /* IRQ Timer #1 (one we use)     */
t_irq11:TRAP_ENTRY_INTERRUPT(11)            /* IRQ Floppy Intr.              */
t_irq12:TRAP_ENTRY_INTERRUPT(12)            /* IRQ Zilog serial chip         */
t_irq13:TRAP_ENTRY_INTERRUPT(13)            /* IRQ Audio Intr.               */
t_irq14:TRAP_ENTRY_INTERRUPT(14)            /* IRQ Timer #2                  */
t_nmi:	NMI_TRAP                            /* Level 15 (NMI)                */
t_racc:	TRAP_ENTRY(0x20, do_reg_access)     /* General Register Access Error */
t_iacce:TRAP_ENTRY(0x21, sparc_fault)       /* Instr Access Error    */
t_bad22:BAD_TRAP(0x22) BAD_TRAP(0x23)
t_cpdis:TRAP_ENTRY(0x24, do_cp_disabled)    /* Co-Processor Disabled         */
t_uflsh:TRAP_ENTRY(0x25, do_bad_flush)      /* Unimplemented FLUSH inst.     */
t_bad26:BAD_TRAP(0x26) BAD_TRAP(0x27)
t_cpexc:TRAP_ENTRY(0x28, do_cp_exception)   /* Co-Processor Exception        */
t_dacce:TRAP_ENTRY(0x29, sparc_fault)       /* Data Access Error     */
t_hwdz:	TRAP_ENTRY(0x2a, do_hw_divzero)     /* Division by zero, you lose... */
t_dserr:TRAP_ENTRY(0x2b, sparc_fault)       /* Data Store Error      */
t_daccm:TRAP_ENTRY(0x2c, sparc_fault)       /* Data Access MMU-Miss  */
t_bad2d:BAD_TRAP(0x2d) BAD_TRAP(0x2e) BAD_TRAP(0x2f) BAD_TRAP(0x30) BAD_TRAP(0x31)
t_bad32:BAD_TRAP(0x32) BAD_TRAP(0x33) BAD_TRAP(0x34) BAD_TRAP(0x35) BAD_TRAP(0x36)
t_bad37:BAD_TRAP(0x37) BAD_TRAP(0x38) BAD_TRAP(0x39) BAD_TRAP(0x3a) BAD_TRAP(0x3b)
t_iaccm:TRAP_ENTRY(0x3c, sparc_fault)       /* Instr Access MMU-Miss */
t_bad3d:BAD_TRAP(0x3d) BAD_TRAP(0x3e) BAD_TRAP(0x3f) BAD_TRAP(0x40) BAD_TRAP(0x41)
t_bad42:BAD_TRAP(0x42) BAD_TRAP(0x43) BAD_TRAP(0x44) BAD_TRAP(0x45) BAD_TRAP(0x46)
t_bad47:BAD_TRAP(0x47) BAD_TRAP(0x48) BAD_TRAP(0x49) BAD_TRAP(0x4a) BAD_TRAP(0x4b)
t_bad4c:BAD_TRAP(0x4c) BAD_TRAP(0x4d) BAD_TRAP(0x4e) BAD_TRAP(0x4f) BAD_TRAP(0x50)
t_bad51:BAD_TRAP(0x51) BAD_TRAP(0x52) BAD_TRAP(0x53) BAD_TRAP(0x54) BAD_TRAP(0x55)
t_bad56:BAD_TRAP(0x56) BAD_TRAP(0x57) BAD_TRAP(0x58) BAD_TRAP(0x59) BAD_TRAP(0x5a)
t_bad5b:BAD_TRAP(0x5b) BAD_TRAP(0x5c) BAD_TRAP(0x5d) BAD_TRAP(0x5e) BAD_TRAP(0x5f)
t_bad60:BAD_TRAP(0x60) BAD_TRAP(0x61) BAD_TRAP(0x62) BAD_TRAP(0x63) BAD_TRAP(0x64)
t_bad65:BAD_TRAP(0x65) BAD_TRAP(0x66) BAD_TRAP(0x67) BAD_TRAP(0x68) BAD_TRAP(0x69)
t_bad6a:BAD_TRAP(0x6a) BAD_TRAP(0x6b) BAD_TRAP(0x6c) BAD_TRAP(0x6d) BAD_TRAP(0x6e)
t_bad6f:BAD_TRAP(0x6f) BAD_TRAP(0x70) BAD_TRAP(0x71) BAD_TRAP(0x72) BAD_TRAP(0x73)
t_bad74:BAD_TRAP(0x74) BAD_TRAP(0x75) BAD_TRAP(0x76) BAD_TRAP(0x77) BAD_TRAP(0x78)
t_bad79:BAD_TRAP(0x79) BAD_TRAP(0x7a) BAD_TRAP(0x7b) BAD_TRAP(0x7c) BAD_TRAP(0x7d)
t_bad7e:BAD_TRAP(0x7e) BAD_TRAP(0x7f)
t_sunos:SUNOS_SYSCALL_TRAP                  /* SunOS System Call             */
t_sbkpt:BAD_TRAP(0x81)                      /* Software Breakpoint/KGDB      */
t_divz:	BAD_TRAP(0x82)                      /* Divide by zero trap           */
t_flwin:TRAP_ENTRY(0x83, do_flush_windows)  /* Flush Windows Trap            */
t_clwin:BAD_TRAP(0x84)                      /* Clean Windows Trap            */
t_rchk:	BAD_TRAP(0x85)                      /* Range Check                   */
t_funal:BAD_TRAP(0x86)                      /* Fix Unaligned Access Trap     */
t_iovf:	BAD_TRAP(0x87)                      /* Integer Overflow Trap         */
t_slowl:SOLARIS_SYSCALL_TRAP                /* Slowaris System Call          */
t_netbs:NETBSD_SYSCALL_TRAP                 /* Net-B.S. System Call          */
t_bad8a:BAD_TRAP(0x8a) BAD_TRAP(0x8b) BAD_TRAP(0x8c) BAD_TRAP(0x8d) BAD_TRAP(0x8e)
t_bad8f:BAD_TRAP(0x8f)
t_linux:LINUX_SYSCALL_TRAP                  /* Linux System Call             */
t_bad91:BAD_TRAP(0x91) BAD_TRAP(0x92) BAD_TRAP(0x93) BAD_TRAP(0x94) BAD_TRAP(0x95)
t_bad96:BAD_TRAP(0x96) BAD_TRAP(0x97) BAD_TRAP(0x98) BAD_TRAP(0x99) BAD_TRAP(0x9a)
t_bad9b:BAD_TRAP(0x9b) BAD_TRAP(0x9c) BAD_TRAP(0x9d) BAD_TRAP(0x9e) BAD_TRAP(0x9f)
t_getcc:GETCC_TRAP                          /* Get Condition Codes           */
t_setcc:SETCC_TRAP                          /* Set Condition Codes           */
t_bada2:BAD_TRAP(0xa2) BAD_TRAP(0xa3) BAD_TRAP(0xa4) BAD_TRAP(0xa5) BAD_TRAP(0xa6)
t_bada7:BAD_TRAP(0xa7) BAD_TRAP(0xa8) BAD_TRAP(0xa9) BAD_TRAP(0xaa) BAD_TRAP(0xab)
t_badac:BAD_TRAP(0xac) BAD_TRAP(0xad) BAD_TRAP(0xae) BAD_TRAP(0xaf) BAD_TRAP(0xb0)
t_badb1:BAD_TRAP(0xb1) BAD_TRAP(0xb2) BAD_TRAP(0xb3) BAD_TRAP(0xb4) BAD_TRAP(0xb5)
t_badb6:BAD_TRAP(0xb6) BAD_TRAP(0xb7) BAD_TRAP(0xb8) BAD_TRAP(0xb9) BAD_TRAP(0xba)
t_badbb:BAD_TRAP(0xbb) BAD_TRAP(0xbc) BAD_TRAP(0xbd) BAD_TRAP(0xbe) BAD_TRAP(0xbf)
t_badc0:BAD_TRAP(0xc0) BAD_TRAP(0xc1) BAD_TRAP(0xc2) BAD_TRAP(0xc3) BAD_TRAP(0xc4)
t_badc5:BAD_TRAP(0xc5) BAD_TRAP(0xc6) BAD_TRAP(0xc7) BAD_TRAP(0xc8) BAD_TRAP(0xc9)
t_badca:BAD_TRAP(0xca) BAD_TRAP(0xcb) BAD_TRAP(0xcc) BAD_TRAP(0xcd) BAD_TRAP(0xce)
t_badcf:BAD_TRAP(0xcf) BAD_TRAP(0xd0) BAD_TRAP(0xd1) BAD_TRAP(0xd2) BAD_TRAP(0xd3)
t_badd4:BAD_TRAP(0xd4) BAD_TRAP(0xd5) BAD_TRAP(0xd6) BAD_TRAP(0xd7) BAD_TRAP(0xd8)
t_badd9:BAD_TRAP(0xd9) BAD_TRAP(0xda) BAD_TRAP(0xdb) BAD_TRAP(0xdc) BAD_TRAP(0xdd)
t_badde:BAD_TRAP(0xde) BAD_TRAP(0xdf) BAD_TRAP(0xe0) BAD_TRAP(0xe1) BAD_TRAP(0xe2)
t_bade3:BAD_TRAP(0xe3) BAD_TRAP(0xe4) BAD_TRAP(0xe5) BAD_TRAP(0xe6) BAD_TRAP(0xe7)
t_bade8:BAD_TRAP(0xe8) BAD_TRAP(0xe9) BAD_TRAP(0xea) BAD_TRAP(0xeb) BAD_TRAP(0xec)
t_baded:BAD_TRAP(0xed) BAD_TRAP(0xee) BAD_TRAP(0xef) BAD_TRAP(0xf0) BAD_TRAP(0xf1)
t_badf2:BAD_TRAP(0xf2) BAD_TRAP(0xf3) BAD_TRAP(0xf4) BAD_TRAP(0xf5) BAD_TRAP(0xf6)
t_badf7:BAD_TRAP(0xf7) BAD_TRAP(0xf8) BAD_TRAP(0xf9) BAD_TRAP(0xfa) BAD_TRAP(0xfb)
t_badfc:BAD_TRAP(0xfc) BAD_TRAP(0xfd)
dbtrap:	BAD_TRAP(0xfe)                      /* Debugger/PROM breakpoint #1   */
dbtrap2:BAD_TRAP(0xff)                      /* Debugger/PROM breakpoint #2   */	

	.globl	C_LABEL(end_traptable)
C_LABEL(end_traptable):

	.skip 4096

/* This was the only reasonable way I could think of to properly align
 * these page-table data structures.
 */

	.globl C_LABEL(auxio_reg_addr)
C_LABEL(auxio_reg_addr):	.skip	(PAGE_SIZE)

	.globl C_LABEL(clock_reg_addr)
C_LABEL(clock_reg_addr):	.skip	(PAGE_SIZE*5)

	.globl C_LABEL(int_reg_addr)
C_LABEL(int_reg_addr):		.skip	(PAGE_SIZE*5)

	.globl C_LABEL(bootup_user_stack)
	.globl C_LABEL(bootup_kernel_stack)
	.globl C_LABEL(pg0)
	.globl C_LABEL(empty_bad_page)
	.globl C_LABEL(empty_bad_page_table)
	.globl C_LABEL(empty_zero_page)
	.globl C_LABEL(swapper_pg_dir)
C_LABEL(bootup_user_stack):		.skip 0x1000
C_LABEL(bootup_kernel_stack):		.skip 0x1000
C_LABEL(swapper_pg_dir):		.skip 0x1000
C_LABEL(pg0):				.skip 0x1000
C_LABEL(empty_bad_page):		.skip 0x1000
C_LABEL(empty_bad_page_table):		.skip 0x1000
C_LABEL(empty_zero_page):		.skip 0x1000


/* Cool, here we go. Pick up the romvec pointer in %o0 and stash it in
 * %g7 and at prom_vector_p. And also quickly check whether we are on
 * a v0, v2, or v3 prom.
 */
gokernel:
		/* Ok, it's nice to know, as early as possible, if we
		 * are already mapped where we expect to be in virtual
		 * memory.  The Solaris /boot elf format bootloader
		 * will peek into our elf header and load us where
		 * we want to be, otherwise we have to re-map.
		 *
		 * Some boot loaders don't place the jmp'rs address
		 * in %o7, so we do a pc-relative call to a local
		 * label, then see what %o7 has.
		 */

		/* XXX Sparc V9 detection goes here XXX */

		mov	%o7, %g4		! Save %o7

		/* Jump to it, and pray... */
current_pc:
		call	1f
		 nop

1:
		mov	%o7, %g3

got_pc:
		mov	%g4, %o7		/* Previous %o7. */
	
		mov	%o0, %l0		! stash away romvec
		mov	%o0, %g7		! put it here too
		mov	%o1, %l1		! stash away debug_vec too

		/* Ok, let's check out our run time program counter. */
		set	current_pc, %g5
		cmp	%g3, %g5
		be	already_mapped
		 nop 

		/* %l6 will hold the offset we have to subtract
		 * from absolute symbols in order to access areas
		 * in our own image.  If already mapped this is
		 * just plain zero, else it is PAGE_OFFSET which is
		 * also KERNBASE.
		 */
		set	PAGE_OFFSET, %l6
		b	copy_prom_lvl14
		 nop

already_mapped:
		mov	0, %l6

		/* Copy over the Prom's level 14 clock handler. */
copy_prom_lvl14:
		rd	%tbr, %g1
		andn	%g1, 0xfff, %g1		! proms trap table base
		or	%g0, (0x1e<<4), %g2	! offset to lvl14 intr
		or	%g1, %g2, %g2
		set	t_irq14, %g3
		sub	%g3, %l6, %g3
		ldd	[%g2], %g4
		std	%g4, [%g3]
		ldd	[%g2 + 0x8], %g4
		std	%g4, [%g3 + 0x8]	! Copy proms handler

		/* Copy over the Prom/debugger's trap entry points. */
copy_prom_bpoint:
		or	%g0, (0xfe<<4), %g2
		or	%g1, %g2, %g2
		set	dbtrap, %g3
		sub	%g3, %l6, %g3
		ldd	[%g2], %g4
		std	%g4, [%g3]
		ldd	[%g2 + 0x8], %g4
		std	%g4, [%g3 + 0x8]
		ldd	[%g2 + 0x10], %g4
		std	%g4, [%g3 + 0x10]
		ldd	[%g2 + 0x18], %g4
		std	%g4, [%g3 + 0x18]

/* Must determine whether we are on a sun4c MMU, SRMMU, or SUN4/400 MUTANT
 * MMU so we can remap ourselves properly.  DONT TOUCH %l0 thru %l5 in these
 * remapping routines, we need their values afterwards!
 *
 * XXX UGH, need to write some sun4u SpitFire remapping V9 code RSN... XXX
 */
		/* Now check whether we are already mapped, if we
		 * are we can skip all this garbage coming up.
		 */
copy_prom_done:
		cmp	%l6, 0
		be	go_to_highmem		! this will be a nop then
		 nop

		set	LOAD_ADDR, %g6
		cmp	%g7, %g6
		bne	remap_not_a_sun4	! This is not a Sun4
		 nop

		or	%g0, 0x1, %g1
		lduba	[%g1] ASI_CONTROL, %g1	! Only safe to try on Sun4.
		subcc	%g1, 0x24, %g0		! Is this a mutant Sun4/400???
		be	sun4_mutant_remap	! Ugh, it is...
		 nop

remap_not_a_sun4:
		lda	[%g0] ASI_M_MMUREGS, %g1 ! same as ASI_PTE on sun4c
		and	%g1, 0x1, %g1		! Test SRMMU Enable bit ;-)
		cmp	%g1, 0x0
		be	sun4c_remap		! A sun4c MMU or normal Sun4
		 nop
srmmu_remap:
		/* First, check for a viking (TI) module. */
		set	0x40000000, %g2
		rd	%psr, %g3
		and	%g2, %g3, %g3
		subcc	%g3, 0x0, %g0
		bz	srmmu_nviking
		 nop

		/* Figure out what kind of viking we are on.
		 * We need to know if we have to play with the
		 * AC bit and disable traps or not.
		 */

		/* I've only seen MicroSparc's on SparcClassics with this
		 * bit set.
		 */
		set	0x800, %g2
		lda	[%g0] ASI_M_MMUREGS, %g3	! peek in the control reg
		and	%g2, %g3, %g3
		subcc	%g3, 0x0, %g0
		bnz	srmmu_nviking			! is in mbus mode
		 nop
		
		rd	%psr, %g3			! DONT TOUCH %g3
		andn	%g3, PSR_ET, %g2
		wr	%g2, 0x0, %psr
		WRITE_PAUSE
		
		/* Get context table pointer, then convert to
		 * a physical address, which is 36 bits.
		 */
		set	AC_M_CTPR, %g4
		lda	[%g4] ASI_M_MMUREGS, %g4
		sll	%g4, 0x4, %g4			! We use this below
							! DONT TOUCH %g4

		/* Set the AC bit in the Viking's MMU control reg. */
		lda	[%g0] ASI_M_MMUREGS, %g5	! DONT TOUCH %g5
		set	0x8000, %g6			! AC bit mask
		or	%g5, %g6, %g6			! Or it in...
		sta	%g6, [%g0] ASI_M_MMUREGS	! Close your eyes...

		/* Grrr, why does it seem like every other load/store
		 * on the sun4m is in some ASI space...
		 * Fine with me, let's get the pointer to the level 1
		 * page table directory and fetch it's entry.
		 */
		lda	[%g4] ASI_M_BYPASS, %o1		! This is a level 1 ptr
		srl	%o1, 0x4, %o1			! Clear low 4 bits
		sll	%o1, 0x8, %o1			! Make physical
		
		/* Ok, pull in the PTD. */
		lda	[%o1] ASI_M_BYPASS, %o2		! This is the 0x0 16MB pgd

		/* Calculate to KERNBASE entry.
		 *
		 * XXX Should not use imperical constant, but Gas gets an  XXX
		 * XXX upset stomach with the bitshift I would have to use XXX
		 */
		add	%o1, 0x3c0, %o3		

		/* Poke the entry into the calculated address. */
		sta	%o2, [%o3] ASI_M_BYPASS

		/* I don't get it Sun, if you engineered all these
		 * boot loaders and the PROM (thank you for the debugging
		 * features btw) why did you not have them load kernel
		 * images up in high address space, since this is necessary
		 * for ABI compliance anyways?  Does this low-mapping provide
		 * enhanced interoperability?
		 *
		 * "The PROM is the computer."
		 */

		/* Ok, restore the MMU control register we saved in %g5 */
		sta	%g5, [%g0] ASI_M_MMUREGS	! POW... ouch

		/* Turn traps back on.  We saved it in %g3 earlier. */
		wr	%g3, 0x0, %psr			! tick tock, tick tock

		/* Now we burn precious CPU cycles due to bad engineering. */
		WRITE_PAUSE

		/* Wow, all that just to move a 32-bit value from one
		 * place to another...  Jump to high memory.
		 */
		b	go_to_highmem
		 nop

		/* This works on viking's in Mbus mode and all
		 * other MBUS modules.  It is virtually the same as
		 * the above madness sans turning traps off and flipping
		 * the AC bit.
		 */
srmmu_nviking:
		set	AC_M_CTPR, %g1
		lda	[%g1] ASI_M_MMUREGS, %g1	! get ctx table ptr
		sll	%g1, 0x4, %g1			! make physical addr
		lda	[%g1] ASI_M_BYPASS, %g1		! ptr to level 1 pg_table
		srl	%g1, 0x4, %g1
		sll	%g1, 0x8, %g1			! make phys addr for l1 tbl

		lda	[%g1] ASI_M_BYPASS, %g2		! get level1 entry for 0x0
		add	%g1, 0x3c0, %g3			! XXX AWAY WITH IMPERICALS
		sta	%g2, [%g3] ASI_M_BYPASS		! place at KERNBASE entry
		b	go_to_highmem
		 nop					! wheee....

		/* This remaps the kernel on Sun4/4xx machines
		 * that have the Sun Mutant Three Level MMU.
		 * It's like a platypus, Sun didn't have the
		 * SRMMU in conception so they kludged the three
		 * level logic in the regular Sun4 MMU probably.
		 *
		 * Basically, you take each entry in the top level
		 * directory that maps the low 3MB starting at
		 * address zero and put the mapping in the KERNBASE
		 * slots.  These top level pgd's are called regmaps.
		 */
sun4_mutant_remap:
		or	%g0, %g0, %g3		! source base
		sethi	%hi(KERNBASE), %g4	! destination base
		or	%g4, %lo(KERNBASE), %g4
		sethi	%hi(0x300000), %g5
		or	%g5, %lo(0x300000), %g5	! upper bound 3MB
		or	%g0, 0x1, %l6
		sll	%l6, 24, %l6		! Regmap mapping size
		add	%g3, 0x2, %g3		! Base magic
		add	%g4, 0x2, %g4		! Base magic

		/* Main remapping loop on Sun4-Mutant-MMU.
		 * "I am not an animal..." -Famous Mutant Person
		 */
sun4_mutant_loop:
		lduha	[%g3] ASI_REGMAP, %g2	! Get lower entry
		stha	%g2, [%g4] ASI_REGMAP	! Store in high entry
		add	%g4, %l6, %g4		! Move up high memory ptr
		subcc	%g3, %g5, %g0		! Reached our limit?
		blu	sun4_mutant_loop	! Nope, loop again
		 add	%g3, %l6, %g3		! delay, Move up low ptr
		b	go_to_highmem		! Jump to high memory.
		 nop

/* The following works for normal (ie. non Sun4/400) Sun4 MMU's */
sun4c_remap:
		mov	0, %g3			! source base
		set	KERNBASE, %g4		! destination base
		set	0x300000, %g5		! upper bound 3MB
		mov	1, %l6
		sll	%l6, 18, %l6		! sun4c mmu segmap size
sun4c_remap_loop:
		lda	[%g3] ASI_SEGMAP, %g6	! load phys_seg
		sta	%g6, [%g4] ASI_SEGMAP   ! store new virt mapping
		add	%g3, %l6, %g3		! Increment source ptr
		subcc	%g3, %g5, %g0		! Reached limit?
		bl	sun4c_remap_loop	! Nope, loop again
		 add	%g4, %l6, %g4		! delay, Increment dest ptr

/* Now do a non-relative jump so that PC is in high-memory */
go_to_highmem:
		set	execute_in_high_mem, %g1
		jmpl	%g1, %g0
		 nop

/* Acquire boot time privileged register values, this will help debugging.
 * I figure out and store nwindows and nwindowsm1 later on.
 */
execute_in_high_mem:
		mov	%l0, %o0		! put back romvec
		mov	%l1, %o1		! and debug_vec

		sethi	%hi( C_LABEL(prom_vector_p) ), %g1
		st	%o0, [%g1 + %lo( C_LABEL(prom_vector_p) )]

		sethi	%hi( C_LABEL(linux_dbvec) ), %g1
		st	%o1, [%g1 + %lo( C_LABEL(linux_dbvec) )]

		ld	[%o0 + 0x4], %o3
		and	%o3, 0x3, %o5			! get the version

		cmp	%o3, 0x2			! a v2 prom?
		be	found_version
		 nop

		/* paul@sfe.com.au */
		cmp	%o3, 0x3			! a v3 prom?
		be	found_version
		 nop

/* Old sun4's pass our load address into %o0 instead of the prom
 * pointer. On sun4's you have to hard code the romvec pointer into
 * your code. Sun probably still does that because they don't even
 * trust their own "OpenBoot" specifications.
 */

		set	LOAD_ADDR, %g6
		cmp	%o0, %g6		! an old sun4?
		be	no_sun4_here
		 nop

found_version:

/* Get the machine type via the mysterious romvec node operations. */

		or	%g0, %g7, %l1
		add	%l1, 0x1c, %l1		
		ld	[%l1], %l0
		ld	[%l0], %l0
		call 	%l0
		 or	%g0, %g0, %o0		! next_node(0) = first_node
		or	%o0, %g0, %g6

		sethi	%hi( C_LABEL(cputypvar) ), %o1	! First node has cpu-arch
		or	%o1, %lo( C_LABEL(cputypvar) ), %o1
		sethi	%hi( C_LABEL(cputypval) ), %o2	! information, the string
		or	%o2, %lo( C_LABEL(cputypval) ), %o2
		ld	[%l1], %l0		! 'compatibility' tells
		ld	[%l0 + 0xc], %l0	! that we want 'sun4x' where
		call	%l0			! x is one of '', 'c', 'm',
		 nop				! 'd' or 'e'. %o2 holds pointer
						! to a buf where above string
						! will get stored by the prom.

		subcc	%o0, %g0, %g0
		bpos	got_prop		! Got the property
		 nop

		or	%g6, %g0, %o0
		sethi	%hi( C_LABEL(cputypvar_sun4m) ), %o1
		or	%o1, %lo( C_LABEL(cputypvar_sun4m) ), %o1
		sethi	%hi( C_LABEL(cputypval) ), %o2
		or	%o2, %lo( C_LABEL(cputypval) ), %o2
		ld	[%l1], %l0
		ld	[%l0 + 0xc], %l0
		call	%l0
		 nop

got_prop:
		set	C_LABEL(cputypval), %o2
		ldub	[%o2 + 0x4], %l1

		cmp	%l1, 'c'		! We already know we are not
		be	1f			! on a plain sun4 because of
		 nop				! the check for 0x4000 in %o0

		cmp	%l1, 'm'		! at start
		be	1f
		 nop

		cmp	%l1, 'd'
		be	no_sun4d_here		! God bless the person who
		 nop				! tried to run this on sun4d.
	
		cmp	%l1, 'e'
		be	no_sun4e_here		! Could be a sun4e.
		 nop

		b	no_sun4u_here		! AIEEE, a V9 sun4u...
		 nop


1:
		set	C_LABEL(cputypval), %l1
		ldub	[%l1 + 0x4], %l1
		cmp	%l1, 'm'		! Test for sun4d, sun4e ?
		be	sun4m_init
		 nop

		/* Jump into mmu context zero. */
		set	AC_CONTEXT, %g1
		stba	%g0, [%g1] ASI_CONTROL

		b	sun4c_continue_boot
		 nop

sun4m_init:

/* Ok, the PROM could have done funny things and apple cider could still
 * be sitting in the fault status/address registers.  Read them all to
 * clear them so we don't get magic faults later on.
 */
/* This sucks, aparently this makes Vikings call prom panic, will fix later */

		rd	%psr, %o1
		srl	%o1, 28, %o1		! Get a type of the CPU

		subcc	%o1, 4, %g0		! TI: Viking or MicroSPARC
		be	sun4c_continue_boot
		 nop

		set	AC_M_SFSR, %o0
		lda	[%o0] ASI_M_MMUREGS, %g0
		set	AC_M_SFAR, %o0
		lda	[%o0] ASI_M_MMUREGS, %g0

		/* Fujitsu MicroSPARC-II has no asynchronous flavors of FARs */
		subcc	%o1, 0, %g0
		be	sun4c_continue_boot
		 nop

		set	AC_M_AFSR, %o0
		lda	[%o0] ASI_M_MMUREGS, %g0
		set	AC_M_AFAR, %o0
		lda	[%o0] ASI_M_MMUREGS, %g0
		 nop


sun4c_continue_boot:


/* Aieee, now set PC and nPC, enable traps, give ourselves a stack and it's
 * show-time!
 */

		sethi	%hi( C_LABEL(cputyp) ), %o0
		st	%g4, [%o0 + %lo( C_LABEL(cputyp) )]

		/* Turn on Supervisor, EnableFloating, and all the PIL bits.
		 * Also puts us in register window zero with traps off.
		 */
		set	(PSR_PS | PSR_S | PSR_PIL | PSR_EF), %g2
		wr	%g2, 0x0, %psr
		WRITE_PAUSE

		/* I want a kernel stack NOW! */
		set	C_LABEL(bootup_user_stack), %g1
		add	%g1, (PAGE_SIZE - STACKFRAME_SZ - TRACEREG_SZ), %sp
		mov	0, %fp			/* And for good luck */

		/* Zero out our BSS section. */
		set	C_LABEL(edata) , %o0	! First address of BSS
		set	C_LABEL(end) , %o1	! Last address of BSS
		add	%o0, 0x1, %o0
1:	
		stb	%g0, [%o0]
		subcc	%o0, %o1, %g0
		bl	1b
		 add	%o0, 0x1, %o0

		/* Initialize the umask value for init_task just in case.
		 * But first make current_set[0] point to something useful.
		 */
		set	C_LABEL(init_task), %g4
		set	C_LABEL(current_set), %g2
		st	%g4, [%g2]

		/* So now this should work. */
		LOAD_CURRENT(g2)
		set	C_LABEL(bootup_kernel_stack), %g4
		st	%g4, [%g2 + TASK_KSTACK_PG]
		st	%g0, [%g2 + THREAD_UMASK]

/* Compute NWINDOWS and stash it away. Now uses %wim trick explained
 * in the V8 manual. Ok, this method seems to work, Sparc is cool...
 * No, it doesn't work, have to play the save/readCWP/restore trick.
 */

		wr	%g0, 0x0, %wim			! so we dont get a trap
		WRITE_PAUSE

		save

		rd	%psr, %g3

		restore

		and	%g3, 0x1f, %g3
		add	%g3, 0x1, %g3

		mov	2, %g1
		wr	%g1, 0x0, %wim			! make window 1 invalid
		WRITE_PAUSE

		cmp	%g3, 0x7
		bne	2f
		 nop

		/* Adjust our window handling routines to
		 * do things correctly on 7 window Sparcs.
		 */

#define		PATCH_INSN(src, dest) \
		set	src, %g5; \
		set	dest, %g6; \
		ld	[%g5], %g4; \
		st	%g4, [%g6];
	
		/* Patch for window spills... */
		PATCH_INSN(spnwin_patch1_7win, spnwin_patch1)
		PATCH_INSN(spnwin_patch2_7win, spnwin_patch2)
		PATCH_INSN(spnwin_patch3_7win, spnwin_patch3)

		/* Patch for window fills... */
		PATCH_INSN(fnwin_patch1_7win, fnwin_patch1)
		PATCH_INSN(fnwin_patch2_7win, fnwin_patch2)

		/* Patch for trap entry setup... */
		PATCH_INSN(tsetup_7win_patch1, tsetup_patch1)
		PATCH_INSN(tsetup_7win_patch2, tsetup_patch2)
		PATCH_INSN(tsetup_7win_patch3, tsetup_patch3)
		PATCH_INSN(tsetup_7win_patch4, tsetup_patch4)
		PATCH_INSN(tsetup_7win_patch5, tsetup_patch5)
		PATCH_INSN(tsetup_7win_patch6, tsetup_patch6)

		/* Patch for returning from traps... */
		PATCH_INSN(rtrap_7win_patch1, rtrap_patch1)
		PATCH_INSN(rtrap_7win_patch2, rtrap_patch2)
		PATCH_INSN(rtrap_7win_patch3, rtrap_patch3)
		PATCH_INSN(rtrap_7win_patch4, rtrap_patch4)
		PATCH_INSN(rtrap_7win_patch5, rtrap_patch5)

2:		
		sethi	%hi( C_LABEL(nwindows) ), %g4
		st	%g3, [%g4 + %lo( C_LABEL(nwindows) )]	! store final value
		sub	%g3, 0x1, %g3
		sethi	%hi( C_LABEL(nwindowsm1) ), %g4
		st	%g3, [%g4 + %lo( C_LABEL(nwindowsm1) )]

		/* Here we go, start using Linux's trap table... */
		set	C_LABEL(trapbase), %g3
		wr	%g3, 0x0, %tbr
		WRITE_PAUSE

		/* Finally, turn on traps so that we can call c-code. */
		rd	%psr, %g3
		wr	%g3, 0x0, %psr
		wr	%g3, PSR_ET, %psr
		WRITE_PAUSE

		/* First we call prom_init() to set up PROMLIB, then
		 * off to start_kernel().
		 */

		sethi	%hi( C_LABEL(prom_vector_p) ), %g5
		ld	[%g5 + %lo( C_LABEL(prom_vector_p) )], %o0
		call	C_LABEL(prom_init)
		 nop

		call 	C_LABEL(start_kernel)
		 nop
	
		/* We should not get here. */
		call	halt_me
		 nop

/* There, happy now Adrian? */

		/* XXX Fix this... XXX */
no_sun4_here:
		sethi	%hi(SUN4_PROM_VECTOR+SUN4_PRINTF), %o1
		ld	[%o1 + %lo(SUN4_PROM_VECTOR+SUN4_PRINTF)], %o1
		set	sun4_notsup, %o0
		call	%o1
		 nop
1:
		ba	1b			! Cannot exit into KMON
		 nop

no_sun4d_here:
		ld	[%g7 + 0x68], %o1
		set	sun4d_notsup, %o0
		call	%o1
		 nop
		b	halt_me
		 nop

no_sun4e_here:
		ld	[%g7 + 0x68], %o1
		set	sun4e_notsup, %o0
		call	%o1
		 nop
		b	halt_me
		 nop

no_sun4u_here:
		ld	[%g7 + 0x68], %o1
		set	sun4u_notsup, %o0
		call	%o1
		 nop
		b	halt_me
		 nop

halt_me:
		ld	[%g7 + 0x74], %o0
		call	%o0			! Get us out of here...
		 nop				! Apparently Solaris is better.

	.data
	.align 4

/*
 * Fill up the prom vector, note in particular the kind first element,
 * no joke. I don't need all of them in here as the entire prom vector
 * gets initialized in c-code so all routines can use it.
 */

	.globl	C_LABEL(prom_vector_p)
C_LABEL(prom_vector_p):
		.word 0

/* We calculate the following at boot time, window fills/spills and trap entry
 * code uses these to keep track of the register windows.
 */

	.align 4
	.globl	C_LABEL(nwindows)
	.globl	C_LABEL(nwindowsm1)
C_LABEL(nwindows):
	.word	8
C_LABEL(nwindowsm1):
	.word	7

/* Boot time debugger vector value.  We need this later on. */

	.align 4
	.globl	C_LABEL(linux_dbvec)
C_LABEL(linux_dbvec):
	.word	0
	.word	0

	.align 4
