/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) STMicroelectronics SA 2014
 * Authors: Fabien Dessenne <fabien.dessenne@st.com> for STMicroelectronics.
 */

#ifndef _STI_HQVDP_LUT_H_
#define _STI_HQVDP_LUT_H_

#define NB_COEF                 128

#define SHIFT_LUT_A_LEGACY      8
#define SHIFT_LUT_B             8
#define SHIFT_LUT_C_Y_LEGACY    8
#define SHIFT_LUT_C_C_LEGACY    8
#define SHIFT_LUT_D_Y_LEGACY    8
#define SHIFT_LUT_D_C_LEGACY    8
#define SHIFT_LUT_E_Y_LEGACY    8
#define SHIFT_LUT_E_C_LEGACY    8
#define SHIFT_LUT_F_Y_LEGACY    8
#define SHIFT_LUT_F_C_LEGACY    8

static const u32 coef_lut_a_legacy[NB_COEF] = {
	0x0000ffff, 0x00010000, 0x000100ff, 0x00000000,
	0x00000000, 0x00050000, 0xfffc00ff, 0x00000000,
	0x00000000, 0x00090000, 0xfff900fe, 0x00000000,
	0x00000000, 0x0010ffff, 0xfff600fb, 0x00000000,
	0x00000000, 0x0017fffe, 0xfff400f7, 0x00000000,
	0x00000000, 0x001ffffd, 0xfff200f2, 0x00000000,
	0x00000000, 0x0027fffc, 0xfff100ec, 0x00000000,
	0x00000000, 0x0030fffb, 0xfff000e5, 0x00000000,
	0x00000000, 0x003afffa, 0xffee00de, 0x00000000,
	0x00000000, 0x0044fff9, 0xffed00d6, 0x00000000,
	0x00000000, 0x004efff8, 0xffed00cd, 0x00000000,
	0x00000000, 0x0059fff6, 0xffed00c4, 0x00000000,
	0x00000000, 0x0064fff5, 0xffed00ba, 0x00000000,
	0x00000000, 0x006ffff3, 0xffee00b0, 0x00000000,
	0x00000000, 0x007afff2, 0xffee00a6, 0x00000000,
	0x00000000, 0x0085fff1, 0xffef009b, 0x00000000,
	0x00000000, 0x0090fff0, 0xfff00090, 0x00000000,
	0x00000000, 0x009bffef, 0xfff10085, 0x00000000,
	0x00000000, 0x00a6ffee, 0xfff2007a, 0x00000000,
	0x00000000, 0x00b0ffee, 0xfff3006f, 0x00000000,
	0x00000000, 0x00baffed, 0xfff50064, 0x00000000,
	0x00000000, 0x00c4ffed, 0xfff60059, 0x00000000,
	0x00000000, 0x00cdffed, 0xfff8004e, 0x00000000,
	0x00000000, 0x00d6ffed, 0xfff90044, 0x00000000,
	0x00000000, 0x00deffee, 0xfffa003a, 0x00000000,
	0x00000000, 0x00e5fff0, 0xfffb0030, 0x00000000,
	0x00000000, 0x00ecfff1, 0xfffc0027, 0x00000000,
	0x00000000, 0x00f2fff2, 0xfffd001f, 0x00000000,
	0x00000000, 0x00f7fff4, 0xfffe0017, 0x00000000,
	0x00000000, 0x00fbfff6, 0xffff0010, 0x00000000,
	0x00000000, 0x00fefff9, 0x00000009, 0x00000000,
	0x00000000, 0x00fffffc, 0x00000005, 0x00000000
};

static const u32 coef_lut_b[NB_COEF] = {
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000100, 0x00000000
};

static const u32 coef_lut_c_y_legacy[NB_COEF] = {
	0x00060004, 0x0038ffe1, 0x003800be, 0x0006ffe1,
	0x00050005, 0x0042ffe1, 0x003800b3, 0x0007ffe1,
	0x00040006, 0x0046ffe1, 0x003300b2, 0x0008ffe2,
	0x00030007, 0x004cffe1, 0x002e00b1, 0x0008ffe2,
	0x00020006, 0x0051ffe2, 0x002900b0, 0x0009ffe3,
	0x00010008, 0x0056ffe2, 0x002400ae, 0x0009ffe4,
	0xffff0008, 0x005cffe3, 0x001f00ad, 0x000affe4,
	0xfffe0008, 0x0062ffe4, 0x001a00ab, 0x000affe5,
	0xfffd000a, 0x0066ffe5, 0x001500a8, 0x000bffe6,
	0xfffc0009, 0x006bffe7, 0x001100a5, 0x000bffe8,
	0xfffa000a, 0x0070ffe8, 0x000d00a3, 0x000bffe9,
	0xfff9000b, 0x0076ffea, 0x0008009f, 0x000bffea,
	0xfff7000b, 0x007affec, 0x0005009b, 0x000cffec,
	0xfff6000b, 0x007effef, 0x00010098, 0x000cffed,
	0xfff4000b, 0x0084fff1, 0xfffd0095, 0x000cffee,
	0xfff3000b, 0x0088fff4, 0xfffa0090, 0x000cfff0,
	0xfff1000b, 0x008dfff7, 0xfff7008d, 0x000bfff1,
	0xfff0000c, 0x0090fffa, 0xfff40088, 0x000bfff3,
	0xffee000c, 0x0095fffd, 0xfff10084, 0x000bfff4,
	0xffed000c, 0x00980001, 0xffef007e, 0x000bfff6,
	0xffec000c, 0x009b0005, 0xffec007a, 0x000bfff7,
	0xffea000b, 0x009f0008, 0xffea0076, 0x000bfff9,
	0xffe9000b, 0x00a3000d, 0xffe80070, 0x000afffa,
	0xffe8000b, 0x00a50011, 0xffe7006b, 0x0009fffc,
	0xffe6000b, 0x00a80015, 0xffe50066, 0x000afffd,
	0xffe5000a, 0x00ab001a, 0xffe40062, 0x0008fffe,
	0xffe4000a, 0x00ad001f, 0xffe3005c, 0x0008ffff,
	0xffe40009, 0x00ae0024, 0xffe20056, 0x00080001,
	0xffe30009, 0x00b00029, 0xffe20051, 0x00060002,
	0xffe20008, 0x00b1002e, 0xffe1004c, 0x00070003,
	0xffe20008, 0x00b20033, 0xffe10046, 0x00060004,
	0xffe10007, 0x00b30038, 0xffe10042, 0x00050005
};

static const u32 coef_lut_c_c_legacy[NB_COEF] = {
	0x0001fff3, 0x003afffb, 0x003a00a1, 0x0001fffb,
	0x0001fff5, 0x0041fffb, 0x0038009a, 0x0001fffb,
	0x0001fff5, 0x0046fffb, 0x00340099, 0x0001fffb,
	0x0001fff7, 0x0049fffb, 0x00300098, 0x0001fffb,
	0x0001fff9, 0x004cfffb, 0x002d0096, 0x0001fffb,
	0x0001fffa, 0x004ffffc, 0x00290095, 0x0001fffb,
	0x0001fff9, 0x0054fffd, 0x00250093, 0x0001fffc,
	0x0001fffa, 0x0058fffd, 0x00220092, 0x0000fffc,
	0x0001fffb, 0x005bfffe, 0x001f0090, 0x0000fffc,
	0x0001fffd, 0x005effff, 0x001c008c, 0x0000fffd,
	0x0001fffd, 0x00620000, 0x0019008a, 0x0000fffd,
	0x0001fffe, 0x00660001, 0x00160088, 0xfffffffd,
	0x0000fffe, 0x006a0003, 0x00130085, 0xfffffffe,
	0x0000fffe, 0x006e0004, 0x00100083, 0xfffffffe,
	0x0000fffe, 0x00710006, 0x000e007f, 0xffffffff,
	0x0000fffe, 0x00750008, 0x000c007c, 0xfffeffff,
	0xfffffffe, 0x0079000a, 0x000a0079, 0xfffeffff,
	0xfffffffe, 0x007c000c, 0x00080075, 0xfffe0000,
	0xffffffff, 0x007f000e, 0x00060071, 0xfffe0000,
	0xfffeffff, 0x00830010, 0x0004006e, 0xfffe0000,
	0xfffeffff, 0x00850013, 0x0003006a, 0xfffe0000,
	0xfffdffff, 0x00880016, 0x00010066, 0xfffe0001,
	0xfffd0000, 0x008a0019, 0x00000062, 0xfffd0001,
	0xfffd0000, 0x008c001c, 0xffff005e, 0xfffd0001,
	0xfffc0000, 0x0090001f, 0xfffe005b, 0xfffb0001,
	0xfffc0000, 0x00920022, 0xfffd0058, 0xfffa0001,
	0xfffc0001, 0x00930025, 0xfffd0054, 0xfff90001,
	0xfffb0001, 0x00950029, 0xfffc004f, 0xfffa0001,
	0xfffb0001, 0x0096002d, 0xfffb004c, 0xfff90001,
	0xfffb0001, 0x00980030, 0xfffb0049, 0xfff70001,
	0xfffb0001, 0x00990034, 0xfffb0046, 0xfff50001,
	0xfffb0001, 0x009a0038, 0xfffb0041, 0xfff50001
};

static const u32 coef_lut_d_y_legacy[NB_COEF] = {
	0xfff80009, 0x0046ffec, 0x004600a3, 0xfff8ffec,
	0xfff70009, 0x004effed, 0x0044009d, 0xfff9ffeb,
	0xfff6000a, 0x0052ffee, 0x003f009d, 0xfffaffea,
	0xfff50009, 0x0057ffef, 0x003b009d, 0xfffbffe9,
	0xfff50008, 0x005bfff0, 0x0037009c, 0xfffcffe9,
	0xfff40008, 0x005ffff2, 0x0033009b, 0xfffcffe9,
	0xfff30007, 0x0064fff3, 0x002f009b, 0xfffdffe8,
	0xfff20007, 0x0068fff5, 0x002b0099, 0xfffeffe8,
	0xfff10008, 0x006bfff7, 0x00270097, 0xffffffe8,
	0xfff00007, 0x006ffff9, 0x00230097, 0xffffffe8,
	0xffef0006, 0x0073fffb, 0x00200095, 0x0000ffe8,
	0xffee0005, 0x0077fffe, 0x001c0093, 0x0000ffe9,
	0xffee0005, 0x007a0000, 0x00180091, 0x0001ffe9,
	0xffed0005, 0x007d0003, 0x0015008e, 0x0002ffe9,
	0xffec0005, 0x00800006, 0x0012008b, 0x0002ffea,
	0xffeb0004, 0x00840008, 0x000e008a, 0x0003ffea,
	0xffeb0003, 0x0087000b, 0x000b0087, 0x0003ffeb,
	0xffea0003, 0x008a000e, 0x00080084, 0x0004ffeb,
	0xffea0002, 0x008b0012, 0x00060080, 0x0005ffec,
	0xffe90002, 0x008e0015, 0x0003007d, 0x0005ffed,
	0xffe90001, 0x00910018, 0x0000007a, 0x0005ffee,
	0xffe90000, 0x0093001c, 0xfffe0077, 0x0005ffee,
	0xffe80000, 0x00950020, 0xfffb0073, 0x0006ffef,
	0xffe8ffff, 0x00970023, 0xfff9006f, 0x0007fff0,
	0xffe8ffff, 0x00970027, 0xfff7006b, 0x0008fff1,
	0xffe8fffe, 0x0099002b, 0xfff50068, 0x0007fff2,
	0xffe8fffd, 0x009b002f, 0xfff30064, 0x0007fff3,
	0xffe9fffc, 0x009b0033, 0xfff2005f, 0x0008fff4,
	0xffe9fffc, 0x009c0037, 0xfff0005b, 0x0008fff5,
	0xffe9fffb, 0x009d003b, 0xffef0057, 0x0009fff5,
	0xffeafffa, 0x009d003f, 0xffee0052, 0x000afff6,
	0xffebfff9, 0x009d0044, 0xffed004e, 0x0009fff7
};

static const u32 coef_lut_d_c_legacy[NB_COEF] = {
	0xfffeffff, 0x003fffff, 0x003f0089, 0xfffeffff,
	0xfffe0000, 0x00460000, 0x0042007d, 0xfffffffe,
	0xfffe0000, 0x00490001, 0x003f007d, 0xfffffffd,
	0xfffd0001, 0x004b0002, 0x003c007d, 0x0000fffc,
	0xfffd0001, 0x004e0003, 0x0039007c, 0x0000fffc,
	0xfffc0001, 0x00510005, 0x0036007c, 0x0000fffb,
	0xfffc0001, 0x00540006, 0x0033007b, 0x0001fffa,
	0xfffc0003, 0x00550008, 0x00310078, 0x0001fffa,
	0xfffb0003, 0x00580009, 0x002e0078, 0x0001fffa,
	0xfffb0002, 0x005b000b, 0x002b0077, 0x0002fff9,
	0xfffa0003, 0x005e000d, 0x00280075, 0x0002fff9,
	0xfffa0002, 0x0060000f, 0x00260074, 0x0002fff9,
	0xfffa0004, 0x00610011, 0x00230072, 0x0002fff9,
	0xfffa0004, 0x00640013, 0x00200070, 0x0002fff9,
	0xfff90004, 0x00660015, 0x001e006e, 0x0003fff9,
	0xfff90004, 0x00680017, 0x001c006c, 0x0003fff9,
	0xfff90003, 0x006b0019, 0x0019006b, 0x0003fff9,
	0xfff90003, 0x006c001c, 0x00170068, 0x0004fff9,
	0xfff90003, 0x006e001e, 0x00150066, 0x0004fff9,
	0xfff90002, 0x00700020, 0x00130064, 0x0004fffa,
	0xfff90002, 0x00720023, 0x00110061, 0x0004fffa,
	0xfff90002, 0x00740026, 0x000f0060, 0x0002fffa,
	0xfff90002, 0x00750028, 0x000d005e, 0x0003fffa,
	0xfff90002, 0x0077002b, 0x000b005b, 0x0002fffb,
	0xfffa0001, 0x0078002e, 0x00090058, 0x0003fffb,
	0xfffa0001, 0x00780031, 0x00080055, 0x0003fffc,
	0xfffa0001, 0x007b0033, 0x00060054, 0x0001fffc,
	0xfffb0000, 0x007c0036, 0x00050051, 0x0001fffc,
	0xfffc0000, 0x007c0039, 0x0003004e, 0x0001fffd,
	0xfffc0000, 0x007d003c, 0x0002004b, 0x0001fffd,
	0xfffdffff, 0x007d003f, 0x00010049, 0x0000fffe,
	0xfffeffff, 0x007d0042, 0x00000046, 0x0000fffe
};

static const u32 coef_lut_e_y_legacy[NB_COEF] = {
	0xfff10001, 0x00490004, 0x00490083, 0xfff10004,
	0xfff10000, 0x00500006, 0x004b007b, 0xfff10002,
	0xfff10000, 0x00530007, 0x0048007b, 0xfff10001,
	0xfff10000, 0x00550009, 0x0046007a, 0xfff10000,
	0xfff1fffe, 0x0058000b, 0x0043007b, 0xfff2fffe,
	0xfff1ffff, 0x005a000d, 0x0040007a, 0xfff2fffd,
	0xfff1fffd, 0x005d000f, 0x003e007a, 0xfff2fffc,
	0xfff1fffd, 0x005f0011, 0x003b0079, 0xfff3fffb,
	0xfff1fffc, 0x00610013, 0x00390079, 0xfff3fffa,
	0xfff1fffb, 0x00640015, 0x00360079, 0xfff3fff9,
	0xfff1fffa, 0x00660017, 0x00340078, 0xfff4fff8,
	0xfff1fffb, 0x00680019, 0x00310077, 0xfff4fff7,
	0xfff2fff9, 0x006a001b, 0x002f0076, 0xfff5fff6,
	0xfff2fff9, 0x006c001e, 0x002c0075, 0xfff5fff5,
	0xfff2fff9, 0x006d0020, 0x002a0073, 0xfff6fff5,
	0xfff3fff7, 0x00700022, 0x00270073, 0xfff6fff4,
	0xfff3fff7, 0x00710025, 0x00250071, 0xfff7fff3,
	0xfff4fff6, 0x00730027, 0x00220070, 0xfff7fff3,
	0xfff5fff6, 0x0073002a, 0x0020006d, 0xfff9fff2,
	0xfff5fff5, 0x0075002c, 0x001e006c, 0xfff9fff2,
	0xfff6fff5, 0x0076002f, 0x001b006a, 0xfff9fff2,
	0xfff7fff4, 0x00770031, 0x00190068, 0xfffbfff1,
	0xfff8fff4, 0x00780034, 0x00170066, 0xfffafff1,
	0xfff9fff3, 0x00790036, 0x00150064, 0xfffbfff1,
	0xfffafff3, 0x00790039, 0x00130061, 0xfffcfff1,
	0xfffbfff3, 0x0079003b, 0x0011005f, 0xfffdfff1,
	0xfffcfff2, 0x007a003e, 0x000f005d, 0xfffdfff1,
	0xfffdfff2, 0x007a0040, 0x000d005a, 0xfffffff1,
	0xfffefff2, 0x007b0043, 0x000b0058, 0xfffefff1,
	0x0000fff1, 0x007a0046, 0x00090055, 0x0000fff1,
	0x0001fff1, 0x007b0048, 0x00070053, 0x0000fff1,
	0x0002fff1, 0x007b004b, 0x00060050, 0x0000fff1
};

static const u32 coef_lut_e_c_legacy[NB_COEF] = {
	0xfffa0001, 0x003f0010, 0x003f006d, 0xfffa0010,
	0xfffb0002, 0x00440011, 0x00440062, 0xfffa000e,
	0xfffb0001, 0x00460013, 0x00420062, 0xfffa000d,
	0xfffb0000, 0x00480014, 0x00410062, 0xfffa000c,
	0xfffb0001, 0x00490015, 0x003f0061, 0xfffb000b,
	0xfffb0000, 0x004b0017, 0x003d0061, 0xfffb000a,
	0xfffb0000, 0x004d0018, 0x003b0062, 0xfffb0008,
	0xfffcffff, 0x004f001a, 0x00390061, 0xfffb0007,
	0xfffc0000, 0x004f001c, 0x00380060, 0xfffb0006,
	0xfffcffff, 0x0052001d, 0x00360060, 0xfffb0005,
	0xfffdfffe, 0x0053001f, 0x00340060, 0xfffb0004,
	0xfffdfffe, 0x00540021, 0x0032005e, 0xfffc0004,
	0xfffeffff, 0x00550022, 0x0030005d, 0xfffc0003,
	0xfffeffff, 0x00560024, 0x002f005c, 0xfffc0002,
	0xfffffffd, 0x00580026, 0x002d005c, 0xfffc0001,
	0xfffffffd, 0x005a0027, 0x002b005c, 0xfffc0000,
	0x0000fffd, 0x005a0029, 0x0029005a, 0xfffd0000,
	0x0000fffc, 0x005c002b, 0x0027005a, 0xfffdffff,
	0x0001fffc, 0x005c002d, 0x00260058, 0xfffdffff,
	0x0002fffc, 0x005c002f, 0x00240056, 0xfffffffe,
	0x0003fffc, 0x005d0030, 0x00220055, 0xfffffffe,
	0x0004fffc, 0x005e0032, 0x00210054, 0xfffefffd,
	0x0004fffb, 0x00600034, 0x001f0053, 0xfffefffd,
	0x0005fffb, 0x00600036, 0x001d0052, 0xfffffffc,
	0x0006fffb, 0x00600038, 0x001c004f, 0x0000fffc,
	0x0007fffb, 0x00610039, 0x001a004f, 0xfffffffc,
	0x0008fffb, 0x0062003b, 0x0018004d, 0x0000fffb,
	0x000afffb, 0x0061003d, 0x0017004b, 0x0000fffb,
	0x000bfffb, 0x0061003f, 0x00150049, 0x0001fffb,
	0x000cfffa, 0x00620041, 0x00140048, 0x0000fffb,
	0x000dfffa, 0x00620042, 0x00130046, 0x0001fffb,
	0x000efffa, 0x00620044, 0x00110044, 0x0002fffb
};

static const u32 coef_lut_f_y_legacy[NB_COEF] = {
	0xfff6fff0, 0x00490012, 0x0049006e, 0xfff60012,
	0xfff7fff1, 0x004e0013, 0x00490068, 0xfff60010,
	0xfff7fff2, 0x004f0015, 0x00470067, 0xfff6000f,
	0xfff7fff5, 0x004f0017, 0x00450065, 0xfff6000e,
	0xfff8fff5, 0x00500018, 0x00440065, 0xfff6000c,
	0xfff8fff6, 0x0051001a, 0x00420064, 0xfff6000b,
	0xfff8fff6, 0x0052001c, 0x00400064, 0xfff6000a,
	0xfff9fff6, 0x0054001d, 0x003e0064, 0xfff60008,
	0xfff9fff8, 0x0054001f, 0x003c0063, 0xfff60007,
	0xfffafff8, 0x00550021, 0x003a0062, 0xfff60006,
	0xfffbfff7, 0x00560022, 0x00390062, 0xfff60005,
	0xfffbfff8, 0x00570024, 0x00370061, 0xfff60004,
	0xfffcfff8, 0x00580026, 0x00350060, 0xfff60003,
	0xfffdfff8, 0x00590028, 0x0033005f, 0xfff60002,
	0xfffdfff7, 0x005b002a, 0x0031005f, 0xfff60001,
	0xfffefff7, 0x005c002c, 0x002f005e, 0xfff60000,
	0xfffffff6, 0x005e002d, 0x002d005e, 0xfff6ffff,
	0x0000fff6, 0x005e002f, 0x002c005c, 0xfff7fffe,
	0x0001fff6, 0x005f0031, 0x002a005b, 0xfff7fffd,
	0x0002fff6, 0x005f0033, 0x00280059, 0xfff8fffd,
	0x0003fff6, 0x00600035, 0x00260058, 0xfff8fffc,
	0x0004fff6, 0x00610037, 0x00240057, 0xfff8fffb,
	0x0005fff6, 0x00620039, 0x00220056, 0xfff7fffb,
	0x0006fff6, 0x0062003a, 0x00210055, 0xfff8fffa,
	0x0007fff6, 0x0063003c, 0x001f0054, 0xfff8fff9,
	0x0008fff6, 0x0064003e, 0x001d0054, 0xfff6fff9,
	0x000afff6, 0x00640040, 0x001c0052, 0xfff6fff8,
	0x000bfff6, 0x00640042, 0x001a0051, 0xfff6fff8,
	0x000cfff6, 0x00650044, 0x00180050, 0xfff5fff8,
	0x000efff6, 0x00650045, 0x0017004f, 0xfff5fff7,
	0x000ffff6, 0x00670047, 0x0015004f, 0xfff2fff7,
	0x0010fff6, 0x00680049, 0x0013004e, 0xfff1fff7
};

static const u32 coef_lut_f_c_legacy[NB_COEF] = {
	0x0000fffb, 0x003a001a, 0x003a005d, 0x0000001a,
	0x0001fffb, 0x003f001b, 0x00400051, 0x00000019,
	0x0001fffc, 0x0040001c, 0x003f0051, 0x00000017,
	0x0002fffb, 0x0042001d, 0x003e0051, 0xffff0016,
	0x0002fffb, 0x0043001e, 0x003d0051, 0xffff0015,
	0x0003fffc, 0x00430020, 0x003b0050, 0xffff0014,
	0x0003fffb, 0x00450021, 0x003a0051, 0xfffe0013,
	0x0004fffc, 0x00450022, 0x00390050, 0xfffe0012,
	0x0005fffc, 0x00460023, 0x0038004f, 0xfffe0011,
	0x0005fffb, 0x00480025, 0x00360050, 0xfffd0010,
	0x0006fffc, 0x00480026, 0x0035004f, 0xfffd000f,
	0x0006fffc, 0x00490027, 0x0034004f, 0xfffd000e,
	0x0007fffd, 0x00490028, 0x0033004e, 0xfffd000d,
	0x0008fffc, 0x004a002a, 0x0031004d, 0xfffd000d,
	0x0009fffd, 0x004a002b, 0x0030004d, 0xfffc000c,
	0x0009fffc, 0x004c002c, 0x002f004d, 0xfffc000b,
	0x000afffc, 0x004c002e, 0x002e004c, 0xfffc000a,
	0x000bfffc, 0x004d002f, 0x002c004c, 0xfffc0009,
	0x000cfffc, 0x004d0030, 0x002b004a, 0xfffd0009,
	0x000dfffd, 0x004d0031, 0x002a004a, 0xfffc0008,
	0x000dfffd, 0x004e0033, 0x00280049, 0xfffd0007,
	0x000efffd, 0x004f0034, 0x00270049, 0xfffc0006,
	0x000ffffd, 0x004f0035, 0x00260048, 0xfffc0006,
	0x0010fffd, 0x00500036, 0x00250048, 0xfffb0005,
	0x0011fffe, 0x004f0038, 0x00230046, 0xfffc0005,
	0x0012fffe, 0x00500039, 0x00220045, 0xfffc0004,
	0x0013fffe, 0x0051003a, 0x00210045, 0xfffb0003,
	0x0014ffff, 0x0050003b, 0x00200043, 0xfffc0003,
	0x0015ffff, 0x0051003d, 0x001e0043, 0xfffb0002,
	0x0016ffff, 0x0051003e, 0x001d0042, 0xfffb0002,
	0x00170000, 0x0051003f, 0x001c0040, 0xfffc0001,
	0x00190000, 0x00510040, 0x001b003f, 0xfffb0001
};

#endif
