import { createContext, useContext } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies

import { rbdInvariant } from '../drag-drop-context/rbd-invariant';
var DroppableContext = /*#__PURE__*/createContext(null);
export var DroppableContextProvider = DroppableContext.Provider;

/**
 * Intended for use by `<Draggable>` instances.
 */
export function useDroppableContext() {
  var value = useContext(DroppableContext);
  rbdInvariant(value, 'Missing <Droppable /> parent');
  return value;
}

/**
 * Returns the `droppableId` of the parent droppable, if there is one.
 *
 * Intended for use only by `<Droppable>` instances.
 */
export function useParentDroppableId() {
  var parentDroppable = useContext(DroppableContext);
  if (!parentDroppable) {
    return null;
  }
  return parentDroppable.droppableId;
}