"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VirtualPlaceholder = VirtualPlaceholder;
var _react = _interopRequireWildcard(require("react"));
var _internalContext = require("../drag-drop-context/internal-context");
var _rbdInvariant = require("../drag-drop-context/rbd-invariant");
var _data = require("../draggable/data");
var _placeholder = require("../draggable/placeholder");
var _useDropTargetForDraggable = require("../hooks/use-drop-target-for-draggable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-extraneous-dependencies

/**
 * The virtual placeholder exists specifically for virtual lists,
 * to ensure that the injected placeholder is correctly positioned.
 *
 * Standard placeholders are rendered as siblings, and do not need explicit
 * positioning.
 *
 * Because virtual placeholders are injected through a portal, they need to be
 * absolutely positioned so that they cover the gap left by the dragging item.
 *
 * This placeholder is important because it acts as the drop target for the
 * dragging item.
 */
function VirtualPlaceholder(_ref) {
  var draggableId = _ref.draggableId,
    droppableId = _ref.droppableId,
    type = _ref.type,
    direction = _ref.direction,
    isDropDisabled = _ref.isDropDisabled;
  var ref = (0, _react.useRef)(null);
  var _useDragDropContext = (0, _internalContext.useDragDropContext)(),
    contextId = _useDragDropContext.contextId,
    getDragState = _useDragDropContext.getDragState;
  var dragState = getDragState();
  (0, _rbdInvariant.rbdInvariant)(dragState.isDragging, 'The virtual placeholder should only be rendered during a drag');
  var getIndex = (0, _react.useCallback)(function () {
    return dragState.sourceLocation.index;
  }, [dragState.sourceLocation.index]);
  var data = (0, _data.useDraggableData)({
    draggableId: draggableId,
    droppableId: droppableId,
    getIndex: getIndex,
    contextId: contextId,
    type: type
  });

  /**
   * This sets up the drop target for the dragging item.
   */
  (0, _useDropTargetForDraggable.useDropTargetForDraggable)({
    elementRef: ref,
    data: data,
    direction: direction,
    contextId: contextId,
    isDropDisabled: isDropDisabled,
    type: type
  });
  var style = (0, _react.useMemo)(function () {
    return {
      position: 'absolute',
      top: dragState.draggableInitialOffsetInSourceDroppable.top,
      left: dragState.draggableInitialOffsetInSourceDroppable.left,
      margin: 0
    };
  }, [dragState.draggableInitialOffsetInSourceDroppable.left, dragState.draggableInitialOffsetInSourceDroppable.top]);

  // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
  return /*#__PURE__*/_react.default.createElement(_placeholder.Placeholder, {
    ref: ref,
    style: style
  });
}