/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * gameloop.h contains declarations for the game loop.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/

#ifndef GAMELOOP_H
#define GAMELOOP_H

#include "SDL.h"
#include "SDL_gfxPrimitives.h"
#include "SDL_image.h"
#include <iostream>
#include <cstdlib>
#include <cmath>
#include <string>
#include <string.h>
using namespace std;

#include "sprite.h"
#include "miscellaneous.h"
#include "bounce.h"
#include "audioplayer.h"

// How many frames go by after the player dies.
#define DEAD_TIME 40
// How many non-player bubbles are there on the screen at any given time?
#define NUM_OF_BUBBLES 11

enum SIDES_OF_SCREEN {TOP,BOTTOM,RIGHT,LEFT};

extern string datadir;

extern SDL_Surface* endscreen;

extern int bubbleSound;
extern int missleSound;
extern int gameoverSound;
extern int bounceSound;

// The game loop. It returns the highest score the player achieves in the game.
double gameloop();

#endif
