/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jrm.ui.basic.JTristateCheckBox;
import jrm.ui.basic.NGTreeNode;

public class JCheckBoxTree
extends JTree {
    protected EventListenerList listenerList = new EventListenerList();

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(CheckChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.setEnabled(newModel.getChildCount(newModel.getRoot()) > 0);
    }

    public boolean isSelectedPartially(TreePath path) {
        NGTreeNode cn = (NGTreeNode)path.getLastPathComponent();
        return cn.isSelected() && cn.getChildCount() > 0 && !cn.allChildrenSelected();
    }

    public JCheckBoxTree(TreeModel model) {
        super(model);
        this.setToggleClickCount(0);
        this.setCellRenderer(new CheckBoxCellRenderer());
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (!JCheckBoxTree.this.isEnabled()) {
                        return;
                    }
                    TreePath tp = JCheckBoxTree.this.getPathForLocation(e.getX(), e.getY());
                    if (tp == null) {
                        return;
                    }
                    boolean checkMode = !((NGTreeNode)tp.getLastPathComponent()).isSelected();
                    JCheckBoxTree.this.checkSubTree(tp, checkMode);
                    JCheckBoxTree.this.updatePredecessorsWithCheckMode(tp);
                    JCheckBoxTree.this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
                    JCheckBoxTree.this.repaint();
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.setSelectionModel(dtsm);
    }

    public void setSelected(boolean selected, NGTreeNode ... nodes) {
        for (NGTreeNode node : nodes) {
            TreePath tp = new TreePath(node.getPath());
            this.checkSubTree(tp, selected);
            this.updatePredecessorsWithCheckMode(tp);
        }
        this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
        this.repaint();
    }

    public void select(NGTreeNode ... nodes) {
        this.setSelected(true, nodes);
    }

    public void unselect(NGTreeNode ... nodes) {
        this.setSelected(false, nodes);
    }

    public void selectAll() {
        this.select((NGTreeNode)this.getModel().getRoot());
    }

    public void selectNone() {
        this.unselect((NGTreeNode)this.getModel().getRoot());
    }

    protected void updatePredecessorsWithCheckMode(TreePath tp) {
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        NGTreeNode parentNode = (NGTreeNode)parentPath.getLastPathComponent();
        parentNode.setSelected(false);
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            if (!((NGTreeNode)parentNode.getChildAt(i)).isSelected()) continue;
            parentNode.setSelected(true);
        }
        this.updatePredecessorsWithCheckMode(parentPath);
    }

    protected void checkSubTree(TreePath tp, boolean check) {
        NGTreeNode node = (NGTreeNode)tp.getLastPathComponent();
        node.setSelected(check);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.checkSubTree(tp.pathByAddingChild(node.getChildAt(i)), check);
        }
    }

    private class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        JTristateCheckBox checkBox;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JTristateCheckBox();
            this.checkBox.setOpaque(false);
            this.checkBox.setFont(this.getFont());
            this.add((Component)this.checkBox, "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            NGTreeNode node = (NGTreeNode)value;
            if (node == null) {
                return this;
            }
            Object obj = node.getUserObject();
            this.checkBox.setEnabled(tree.isEnabled());
            this.checkBox.setSelected(node.isSelected());
            this.checkBox.setText(obj != null ? obj.toString() : null);
            this.checkBox.setHalfSelected(node.isSelected() && node.getChildCount() > 0 && !node.allChildrenSelected());
            this.setPreferredSize(new Dimension(Math.max(this.getPreferredSize().width, this.checkBox.getFontMetrics(this.getFont()).stringWidth(this.checkBox.getText()) + 100), 20));
            return this;
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        public CheckChangeEvent(Object source) {
            super(source);
        }
    }
}

