## TFSA-2022-039: Integer overflow in `OpLevelCostEstimator::CalculateOutputSize`

### CVE Number
CVE-2022-23576

### Impact
The [implementation of `OpLevelCostEstimator::CalculateOutputSize`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/costs/op_level_cost_estimator.cc#L1598-L1617) is vulnerable to an integer overflow if an attacker can create an operation which would involve tensors with large enough number of elements:

```cc
for (const auto& dim : output_shape.dim()) {
  output_size *= dim.size();
}
```

Here, we can have a large enough number of dimensions in `output_shape.dim()` or just a small number of dimensions being large enough to cause an overflow in the multiplication.

### Patches
We have patched the issue in GitHub commit [b9bd6cfd1c50e6807846af9a86f9b83cafc9c8ae](https://github.com/tensorflow/tensorflow/commit/b9bd6cfd1c50e6807846af9a86f9b83cafc9c8ae).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
