# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EndUserTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_users.create(friendly_name="friendly_name", type="type")

        values = {'FriendlyName': "friendly_name", 'Type': "type", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://trusthub.twilio.com/v1/EndUsers',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "date_updated": "2021-02-16T20:40:57Z",
                "sid": "ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "auth_rep_1",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://trusthub.twilio.com/v1/EndUsers/ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2021-02-16T20:40:57Z",
                "attributes": {
                    "phone_number": "+11234567890",
                    "job_position": "CEO",
                    "first_name": "rep1",
                    "last_name": "test",
                    "business_title": "ceo",
                    "email": "foobar@test.com"
                },
                "type": "authorized_representative_1"
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_users.create(friendly_name="friendly_name", type="type")

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_users.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/EndUsers',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "results": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/EndUsers?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/EndUsers?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "results"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_users.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "results": [
                    {
                        "date_updated": "2021-02-16T20:40:57Z",
                        "sid": "ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "friendly_name": "auth_rep_1",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "url": "https://trusthub.twilio.com/v1/EndUsers/ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2021-02-16T20:40:57Z",
                        "attributes": {
                            "phone_number": "+11234567890",
                            "job_position": "CEO",
                            "first_name": "rep1",
                            "last_name": "test",
                            "business_title": "ceo",
                            "email": "foobar@test.com"
                        },
                        "type": "authorized_representative_1"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/EndUsers?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/EndUsers?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "results"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_users.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_users("ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/EndUsers/ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "date_updated": "2021-02-16T20:40:57Z",
                "sid": "ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "auth_rep_1",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://trusthub.twilio.com/v1/EndUsers/ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2021-02-16T20:40:57Z",
                "attributes": {
                    "phone_number": "+11234567890",
                    "job_position": "CEO",
                    "first_name": "rep1",
                    "last_name": "test",
                    "business_title": "ceo",
                    "email": "foobar@test.com"
                },
                "type": "authorized_representative_1"
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_users("ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_users("ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://trusthub.twilio.com/v1/EndUsers/ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "date_updated": "2021-02-16T20:40:57Z",
                "sid": "ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "friendly_name",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://trusthub.twilio.com/v1/EndUsers/ITaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2021-02-16T20:40:57Z",
                "attributes": {
                    "phone_number": "+11234567890",
                    "job_position": "CEO",
                    "first_name": "rep1",
                    "last_name": "test",
                    "business_title": "ceo",
                    "email": "foobar@test.com"
                },
                "type": "authorized_representative_1"
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_users("ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_users("ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://trusthub.twilio.com/v1/EndUsers/ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.trusthub.v1.end_users("ITXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)
