/* SPDX-License-Identifier: GPL-2.0 OR Linux-OpenIB */
/* Copyright (c) 2024 NVIDIA Corporation & Affiliates */

#ifndef HWS_DEBUG_H_
#define HWS_DEBUG_H_

#define HWS_DEBUG_FORMAT_VERSION "1.0"

#define HWS_PTR_TO_ID(p) ((u64)(uintptr_t)(p) & 0xFFFFFFFFULL)

enum mlx5hws_debug_res_type {
	MLX5HWS_DEBUG_RES_TYPE_CONTEXT = 4000,
	MLX5HWS_DEBUG_RES_TYPE_CONTEXT_ATTR = 4001,
	MLX5HWS_DEBUG_RES_TYPE_CONTEXT_CAPS = 4002,
	MLX5HWS_DEBUG_RES_TYPE_CONTEXT_SEND_ENGINE = 4003,
	MLX5HWS_DEBUG_RES_TYPE_CONTEXT_SEND_RING = 4004,
	MLX5HWS_DEBUG_RES_TYPE_CONTEXT_STC = 4005,

	MLX5HWS_DEBUG_RES_TYPE_TABLE = 4100,

	MLX5HWS_DEBUG_RES_TYPE_MATCHER = 4200,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_ATTR = 4201,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_MATCH_TEMPLATE = 4202,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_TEMPLATE_MATCH_DEFINER = 4203,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_ACTION_TEMPLATE = 4204,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_TEMPLATE_HASH_DEFINER = 4205,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_TEMPLATE_RANGE_DEFINER = 4206,
	MLX5HWS_DEBUG_RES_TYPE_MATCHER_TEMPLATE_COMPARE_MATCH_DEFINER = 4207,

	MLX5HWS_DEBUG_RES_TYPE_ACTION_STE_TABLE = 4300,
};

static inline u64
mlx5hws_debug_icm_to_idx(u64 icm_addr)
{
	return (icm_addr >> 6) & 0xffffffff;
}

void mlx5hws_debug_init_dump(struct mlx5hws_context *ctx);
void mlx5hws_debug_uninit_dump(struct mlx5hws_context *ctx);

#endif /* HWS_DEBUG_H_ */
