# Налагодження (Debugging)

Ви можете під'єднати дебагер у Вашому редакторі коду, наприклад, у Visual Studio Code або PyCharm.

## Виклик `uvicorn`

У Вашому FastAPI-додатку імпортуйте та запустіть `uvicorn` безпосередньо:

{* ../../docs_src/debugging/tutorial001.py hl[1,15] *}

### Про `__name__ == "__main__"`

Головна мета використання `__name__ == "__main__"` — це забезпечення виконання певного коду тільки тоді, коли файл запускається безпосередньо:

<div class="termy">

```console
$ python myapp.py
```

</div>

але не виконується при його імпорті в інший файл, наприклад:

```Python
from myapp import app
```

#### Детальніше

Припустимо, Ваш файл називається `myapp.py`.

Якщо Ви запустите його так:

<div class="termy">

```console
$ python myapp.py
```

</div>

тоді внутрішня змінна `__name__`, яка створюється автоматично Python, матиме значення `"__main__"`.

Отже, цей блок коду:

```Python
    uvicorn.run(app, host="0.0.0.0", port=8000)
```

буде виконаний.

---

Це не станеться, якщо Ви імпортуєте цей модуль (файл).

Якщо у Вас є інший файл, наприклад `importer.py`, з наступним кодом:

```Python
from myapp import app

# Додатковий код
```

У цьому випадку автоматично створена змінна у файлі `myapp.py` не матиме значення змінної `__name__` як `"__main__"`.

Отже, рядок:

```Python
    uvicorn.run(app, host="0.0.0.0", port=8000)
```

не буде виконано.

/// info | Інформація

Більш детальну інформацію можна знайти в <a href="https://docs.python.org/3/library/__main__.html" class="external-link" target="_blank">офіційній документації Python</a>.

///

## Запуск коду з вашим дебагером

Оскільки Ви запускаєте сервер Uvicorn безпосередньо з Вашого коду, Ви можете запустити вашу Python програму (ваш FastAPI додаток) безпосередньо з дебагера.

---

Наприклад, у Visual Studio Code Ви можете:

* Перейдіть на вкладку "Debug".
* Натисніть "Add configuration...".
* Виберіть "Python"
* Запустіть дебагер з опцією "`Python: Current File (Integrated Terminal)`".

Це запустить сервер з Вашим **FastAPI** кодом, зупиниться на точках зупину тощо.

Ось як це може виглядати:

<img src="/img/tutorial/debugging/image01.png">

---
Якщо Ви використовуєте PyCharm, ви можете:

* Відкрити меню "Run".
* Вибрати опцію "Debug...".
* Потім з'явиться контекстне меню.
* Вибрати файл для налагодження (у цьому випадку, `main.py`).

Це запустить сервер з Вашим **FastAPI** кодом, зупиниться на точках зупину тощо.

Ось як це може виглядати:

<img src="/img/tutorial/debugging/image02.png">
