/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.AbstractHeaderGeneratingMessageHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.RelatesTo;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.slf4j.Logger;

public class AddRelatesToHandler
extends AbstractHeaderGeneratingMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddRelatesToHandler.class);
    @Nullable
    private ContextDataLookupFunction<MessageContext, String> relatesToURILookup;
    @Nullable
    private String relatesToURI;
    @Nullable
    private String relationshipType;

    @Nullable
    public ContextDataLookupFunction<MessageContext, String> getRelatesToURILookup() {
        return this.relatesToURILookup;
    }

    public void setRelatesToURILookup(@Nullable ContextDataLookupFunction<MessageContext, String> lookup) {
        this.checkSetterPreconditions();
        this.relatesToURILookup = lookup;
    }

    @Nullable
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(@Nullable String value) {
        this.checkSetterPreconditions();
        this.relationshipType = StringSupport.trimOrNull(value);
    }

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        WSAddressingContext addressing = messageContext.getSubcontext(WSAddressingContext.class);
        if (addressing != null) {
            this.relatesToURI = addressing.getRelatesToURI();
            if (this.relationshipType == null) {
                this.relationshipType = addressing.getRelatesToRelationshipType();
            }
        }
        if (this.relatesToURI == null && this.relatesToURILookup != null) {
            this.relatesToURI = (String)this.relatesToURILookup.apply((String)((Object)messageContext));
        }
        if (this.relatesToURI == null) {
            this.log.debug("No WS-Addressing RelatesTo value found in message context, skipping further processing");
            return false;
        }
        return true;
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("Issuing WS-Addressing RelatesTo header with URI '{}' and RelationshipType '{}'", (Object)this.relatesToURI, (Object)this.relationshipType);
        RelatesTo relatesTo = (RelatesTo)XMLObjectSupport.buildXMLObject(RelatesTo.ELEMENT_NAME);
        relatesTo.setURI(this.relatesToURI);
        relatesTo.setRelationshipType(this.relationshipType);
        this.decorateGeneratedHeader(messageContext, relatesTo);
        SOAPMessagingSupport.addHeaderBlock(messageContext, relatesTo);
    }
}

