/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.internal.Digest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class NullDigest
implements Digest {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    NullDigest() {
    }

    @Override
    public String getAlgorithmName() {
        return "NULL";
    }

    @Override
    public int getDigestSize() {
        return this.bOut.size();
    }

    @Override
    public void update(byte by) {
        this.bOut.write(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.bOut.write(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = this.bOut.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.reset();
        return byArray2.length;
    }

    @Override
    public void reset() {
        this.bOut.reset();
    }

    @Override
    public int getByteLength() {
        return -1;
    }
}

