/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.api.Convert;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private final Ruby runtime;
    private final IRubyObject io;
    private final InputStream in;
    private final IRubyObject numOne;
    private final CallSite readAdapter = MethodIndex.getFunctionalCallSite("read");
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOInputStream(IRubyObject io2) {
        this(io2, true);
    }

    public IOInputStream(IRubyObject io2, boolean verifyCanRead) {
        this.runtime = io2.getRuntime();
        this.io = io2;
        InputStream inputStream = this.in = io2 instanceof RubyIO && !((RubyIO)io2).isClosed() && ((RubyIO)io2).isBuiltin("read") ? ((RubyIO)io2).getInStream() : null;
        if (this.in == null && verifyCanRead && !io2.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + String.valueOf(io2) + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.numOne = RubyFixnum.one(this.runtime);
    }

    @Override
    public void close() throws IOException {
        InputStream in = this.in;
        if (in != null) {
            in.close();
        } else {
            IRubyObject io2 = this.io;
            if (io2.respondsTo("close")) {
                this.closeAdapter.call(this.runtime.getCurrentContext(), io2, io2);
            }
        }
    }

    @Override
    public int available() throws IOException {
        InputStream in = this.in;
        if (in != null) {
            return in.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        InputStream in = this.in;
        if (in != null) {
            return in.read();
        }
        IRubyObject io2 = this.io;
        IRubyObject readValue = this.readAdapter.call(this.runtime.getCurrentContext(), io2, io2, this.numOne);
        if (readValue.isNil()) {
            return -1;
        }
        return readValue.convertToString().getByteList().get(0) & 0xFF;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        InputStream in = this.in;
        if (in != null) {
            return in.read(b2, off, len);
        }
        IRubyObject io2 = this.io;
        ThreadContext context = this.runtime.getCurrentContext();
        IRubyObject readValue = this.readAdapter.call(context, io2, io2, (IRubyObject)Convert.asFixnum(context, len));
        if (readValue.isNil()) {
            return -1;
        }
        ByteList str = readValue.convertToString().getByteList();
        int readSize = str.realSize();
        if (readSize > len) {
            throw context.runtime.newIOError("read call of " + len + " bytes produced a String of length " + readSize);
        }
        System.arraycopy(str.getUnsafeBytes(), str.getBegin(), b2, off, readSize);
        return readSize;
    }
}

