/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Enhance pixels associated with a dark object (identified by a seed
pixel) where the dark object is surrounded by a brighter object.


GrayscaleConnectedClosingImageFilter is useful for enhancing dark objects that are surrounded by bright
borders. This filter makes it easier to threshold the image and
extract just the object of interest.

Geodesic morphology and the connected closing algorithm are described
in Chapter 6 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleConnectedClosing for the procedural interface

 itk::GrayscaleConnectedClosingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleConnectedClosingImageFilter.h
*/
public class GrayscaleConnectedClosingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleConnectedClosingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleConnectedClosingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleConnectedClosingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleConnectedClosingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleConnectedClosingImageFilter::~GrayscaleConnectedClosingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleConnectedClosingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleConnectedClosingImageFilter::GrayscaleConnectedClosingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleConnectedClosingImageFilter() {
    this(SimpleITKJNI.new_GrayscaleConnectedClosingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedClosingImageFilter::SetSeed(std::vector&lt; uint32_t &gt; Seed)

Set/Get the seed pixel for the segmentation

*/
public  void setSeed(VectorUInt32 Seed) {
    SimpleITKJNI.GrayscaleConnectedClosingImageFilter_setSeed(swigCPtr, this, VectorUInt32.getCPtr(Seed), Seed);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::GrayscaleConnectedClosingImageFilter::GetSeed() const

Set/Get the seed pixel for the segmentation

*/
public  VectorUInt32 getSeed() {
    return new VectorUInt32(SimpleITKJNI.GrayscaleConnectedClosingImageFilter_getSeed(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedClosingImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.GrayscaleConnectedClosingImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedClosingImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.GrayscaleConnectedClosingImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedClosingImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.GrayscaleConnectedClosingImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleConnectedClosingImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.GrayscaleConnectedClosingImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleConnectedClosingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleConnectedClosingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleConnectedClosingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleConnectedClosingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleConnectedClosingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GrayscaleConnectedClosingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
