/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.FileInputStream;
import java.util.zip.GZIPInputStream;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.SourceInfo;
import tim.prune.load.FileToBeLoaded;
import tim.prune.load.FileTypeLoader;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;

public class GzipFileLoader {
    private App _app = null;
    XmlFileLoader _xmlLoader = null;

    public GzipFileLoader(App app, XmlFileLoader xmlFileLoader) {
        this._app = app;
        this._xmlLoader = xmlFileLoader;
    }

    public void openFile(FileToBeLoaded fileToBeLoaded, boolean bl) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(fileToBeLoaded.getFile()));){
                this._xmlLoader.reset();
                this._xmlLoader.parseXmlStream(gZIPInputStream);
                XmlHandler xmlHandler = this._xmlLoader.getHandler();
                if (xmlHandler == null) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.noread");
                } else {
                    SourceInfo sourceInfo = new SourceInfo(fileToBeLoaded.getFile(), xmlHandler.getFileType(), xmlHandler.getFileVersion());
                    sourceInfo.setFileTitle(xmlHandler.getFileTitle());
                    sourceInfo.setFileDescription(xmlHandler.getFileDescription());
                    sourceInfo.setExtensionInfo(xmlHandler.getExtensionInfo());
                    new FileTypeLoader(this._app).loadData(xmlHandler, sourceInfo, bl, new MediaLinkInfo(fileToBeLoaded.getFile(), xmlHandler.getLinkArray()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.othererror")) + " " + exception.getClass().getName());
        }
    }
}

