/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class TypePattern
extends Pattern {
    public LocalDeclaration local;

    public TypePattern(LocalDeclaration local) {
        this.local = local;
    }

    protected TypePattern() {
    }

    @Override
    public TypeReference getType() {
        return this.local.type;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] localVariableBindingArray;
        if (this.local.binding == null) {
            localVariableBindingArray = NO_VARIABLES;
        } else {
            LocalVariableBinding[] localVariableBindingArray2 = new LocalVariableBinding[1];
            localVariableBindingArray = localVariableBindingArray2;
            localVariableBindingArray2[0] = this.local.binding;
        }
        return localVariableBindingArray;
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (!castType.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, castType, expressionType, match, isNarrowing);
        }
        return super.checkUnsafeCast(scope, castType, expressionType, match, isNarrowing);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.local.analyseCode(currentScope, flowContext, flowInfo);
        FlowInfo patternInfo = flowInfo.copy();
        patternInfo.markAsDefinitelyAssigned(this.local.binding);
        if (!this.isTotalTypeNode) {
            patternInfo.markAsDefinitelyNonNull(this.local.binding);
        } else if (flowContext.associatedNode instanceof SwitchStatement) {
            SwitchStatement swStmt = (SwitchStatement)flowContext.associatedNode;
            int nullStatus = swStmt.containsNull ? 4 : swStmt.expression.nullStatus(patternInfo, flowContext);
            patternInfo.markNullStatus(this.local.binding, nullStatus);
        }
        return patternInfo;
    }

    @Override
    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, BranchLabel trueLabel, BranchLabel falseLabel) {
        LocalVariableBinding localBinding = this.local.binding;
        if (!this.isTotalTypeNode) {
            codeStream.checkcast(localBinding.type);
        }
        this.local.generateCode(currentScope, codeStream);
        codeStream.store(localBinding, false);
        localBinding.recordInitializationStartPC(codeStream.position);
    }

    @Override
    public LocalDeclaration getPatternVariable() {
        return this.local;
    }

    @Override
    public boolean coversType(TypeBinding type) {
        if (type == null || this.resolvedType == null) {
            return false;
        }
        return type.isSubtypeOf(this.resolvedType, false);
    }

    @Override
    protected boolean isPatternTypeCompatible(TypeBinding other, BlockScope scope) {
        TypeBinding patternType = this.resolvedType;
        if (patternType == null) {
            return false;
        }
        if (patternType.isBaseType()) {
            if (!TypeBinding.equalsEquals(other, patternType)) {
                scope.problemReporter().incompatiblePatternType(this, other, patternType);
                return false;
            }
        } else if (!this.checkCastTypesCompatibility(scope, other, patternType, null, true)) {
            scope.problemReporter().incompatiblePatternType(this, other, patternType);
            return false;
        }
        return true;
    }

    @Override
    public boolean dominates(Pattern p) {
        if (p.resolvedType == null || this.resolvedType == null) {
            return false;
        }
        return p.resolvedType.erasure().isSubtypeOf(this.resolvedType.erasure(), false);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        RecordComponentBinding[] components;
        ReferenceBinding recType;
        Pattern enclosingPattern;
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.local.modifiers |= 0x10000000;
        if ((this.local.type == null || this.local.type.isTypeNameVar(scope)) && (enclosingPattern = this.getEnclosingPattern()) instanceof RecordPattern && (recType = (ReferenceBinding)enclosingPattern.resolvedType) != null && (components = recType.components()).length > this.index) {
            TypeBinding[] mentionedTypeVariables;
            RecordComponentBinding rcb = components[this.index];
            if (rcb.type != null && (rcb.tagBits & 0x80L) != 0L) {
                scope.problemReporter().invalidType(this, rcb.type);
            }
            if ((mentionedTypeVariables = this.findSyntheticTypeVariables(rcb.type)) != null && mentionedTypeVariables.length > 0) {
                this.local.type.resolvedType = recType.upwardsProjection(scope, mentionedTypeVariables);
            } else {
                if (this.local.type != null) {
                    this.local.type.resolvedType = rcb.type;
                }
                this.resolvedType = rcb.type;
            }
        }
        this.local.resolve(scope, true);
        if (this.local.binding != null) {
            this.local.binding.modifiers |= 0x10000000;
            this.local.binding.tagBits |= 0x4000L;
            if (this.local.type != null) {
                this.resolvedType = this.local.binding.type;
            }
        }
        return this.resolvedType;
    }

    private TypeVariableBinding[] findSyntheticTypeVariables(TypeBinding typeBinding) {
        final HashSet mentioned = new HashSet();
        TypeBindingVisitor.visit(new TypeBindingVisitor(){

            @Override
            public boolean visit(TypeVariableBinding typeVariable) {
                if (typeVariable.isCapture()) {
                    mentioned.add(typeVariable);
                }
                return super.visit(typeVariable);
            }
        }, typeBinding);
        if (mentioned.isEmpty()) {
            return null;
        }
        return mentioned.toArray(new TypeVariableBinding[mentioned.size()]);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.local.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        return this.local.printAsExpression(indent, output);
    }
}

