//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Election.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceStorm_Election_h__
#define __IceStorm_Election_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <IceStorm/SubscriberRecord.h>
#include <IceStorm/LLURecord.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceStormElection
{

class ReplicaObserver;
class ReplicaObserverPrx;
class TopicManagerSync;
class TopicManagerSyncPrx;
class Node;
class NodePrx;

}

namespace IceStormElection
{

/**
 * The contents of topic.
 */
struct TopicContent
{
    /**
     * The topic identity.
     */
    ::Ice::Identity id;
    /**
     * The topic subscribers.
     */
    ::IceStorm::SubscriberRecordSeq records;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::Ice::Identity&, const ::IceStorm::SubscriberRecordSeq&> ice_tuple() const
    {
        return std::tie(id, records);
    }
};

/**
 * A sequence of topic content.
 */
using TopicContentSeq = ::std::vector<TopicContent>;

/**
 * Thrown if an observer detects an inconsistency.
 */
class ObserverInconsistencyException : public ::Ice::UserExceptionHelper<ObserverInconsistencyException, ::Ice::UserException>
{
public:

    virtual ~ObserverInconsistencyException();

    ObserverInconsistencyException(const ObserverInconsistencyException&) = default;

    ObserverInconsistencyException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the inconsistency.
     */
    ObserverInconsistencyException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The reason for the inconsistency.
     */
    ::std::string reason;
};

/// \cond INTERNAL
static ObserverInconsistencyException _iceS_ObserverInconsistencyException_init;
/// \endcond

/**
 * The node state.
 */
enum class NodeState : unsigned char
{
    /**
     * The node is inactive and awaiting an election.
     */
    NodeStateInactive,
    /**
     * The node is electing a leader.
     */
    NodeStateElection,
    /**
     * The replica group is reorganizing.
     */
    NodeStateReorganization,
    /**
     * The replica group is active & replicating.
     */
    NodeStateNormal
};

/**
 * All nodes in the replication group.
 */
struct NodeInfo
{
    /**
     * The identity of the node.
     */
    int id;
    /**
     * The node proxy.
     */
    ::std::shared_ptr<::IceStormElection::NodePrx> n;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const int&, const ::std::shared_ptr<::IceStormElection::NodePrx>&> ice_tuple() const
    {
        return std::tie(id, n);
    }
};

/**
 * A sequence of node info.
 */
using NodeInfoSeq = ::std::vector<NodeInfo>;

/**
 * The group info.
 */
struct GroupInfo
{
    /**
     * The identity of the node.
     */
    int id;
    /**
     * The last known log update for this node.
     */
    ::IceStormElection::LogUpdate llu;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const int&, const ::IceStormElection::LogUpdate&> ice_tuple() const
    {
        return std::tie(id, llu);
    }
};

/**
 * A sequence of group info.
 */
using GroupInfoSeq = ::std::vector<GroupInfo>;

struct QueryInfo
{
    /**
     * The node id.
     */
    int id;
    /**
     * The nodes coordinator.
     */
    int coord;
    /**
     * The nodes group name.
     */
    ::std::string group;
    /**
     * The replica the node is managing.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> replica;
    /**
     * The node state.
     */
    ::IceStormElection::NodeState state;
    /**
     * The sequence of nodes in this nodes group.
     */
    ::IceStormElection::GroupInfoSeq up;
    /**
     * The highest priority node that this node has seen.
     */
    int max;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const int&, const int&, const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::IceStormElection::NodeState&, const ::IceStormElection::GroupInfoSeq&, const int&> ice_tuple() const
    {
        return std::tie(id, coord, group, replica, state, up, max);
    }
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceStormElection
{

/**
 * The replica observer.
 */
class ReplicaObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ReplicaObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void init(LogUpdate llu, TopicContentSeq content, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_init(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void createTopic(LogUpdate llu, ::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createTopic(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void destroyTopic(LogUpdate llu, ::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroyTopic(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void addSubscriber(LogUpdate llu, ::std::string topic, ::IceStorm::SubscriberRecord record, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addSubscriber(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void removeSubscriber(LogUpdate llu, ::std::string topic, ::Ice::IdentitySeq subscribers, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeSubscriber(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Interface used to sync topics.
 */
class TopicManagerSync : public virtual ::Ice::Object
{
public:

    using ProxyType = TopicManagerSyncPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to getContent.
     */
    struct GetContentResult
    {
        /** The last log update token. */
        LogUpdate llu;
        /** The topic content. */
        TopicContentSeq content;
    };

    /**
     * Retrieve the topic content.
     * @param llu The last log update token.
     * @param content The topic content.
     * @param current The Current object for the invocation.
     */
    virtual void getContent(LogUpdate& llu, TopicContentSeq& content, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getContent(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * A replica node.
 */
class Node : public virtual ::Ice::Object
{
public:

    using ProxyType = NodePrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param current The Current object for the invocation.
     */
    virtual void invitation(int j, ::std::string gn, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_invitation(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param current The Current object for the invocation.
     */
    virtual void ready(int j, ::std::string gn, ::std::shared_ptr<::Ice::ObjectPrx> coordinator, int max, long long int generation, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_ready(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param current The Current object for the invocation.
     */
    virtual void accept(int j, ::std::string gn, ::Ice::IntSeq forwardedInvites, ::std::shared_ptr<::Ice::ObjectPrx> observer, LogUpdate llu, int max, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_accept(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Determine if this node is a coordinator.
     * @param current The Current object for the invocation.
     * @return True if the node is a coordinator, false otherwise.
     */
    virtual bool areYouCoordinator(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_areYouCoordinator(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param current The Current object for the invocation.
     * @return True if the node is a member, false otherwise.
     */
    virtual bool areYouThere(::std::string gn, int j, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_areYouThere(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the sync object for the replica hosted by this node.
     * @param current The Current object for the invocation.
     * @return The sync object.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> sync(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_sync(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the replication group information.
     * @param current The Current object for the invocation.
     * @return The set of configured nodes and the associated
     * priority.
     */
    virtual NodeInfoSeq nodes(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_nodes(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the query information for the given node.
     * @param current The Current object for the invocation.
     * @return The query information.
     */
    virtual QueryInfo query(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_query(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceStormElection
{

/**
 * The replica observer.
 */
class ReplicaObserverPrx : public virtual ::Ice::Proxy<ReplicaObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void init(const LogUpdate& llu, const TopicContentSeq& content, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_init, llu, content, context).get();
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto initAsync(const LogUpdate& llu, const TopicContentSeq& content, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_init, llu, content, context);
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    initAsync(const LogUpdate& llu, const TopicContentSeq& content,
              ::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::ReplicaObserverPrx::_iceI_init, llu, content, context);
    }

    /// \cond INTERNAL
    void _iceI_init(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LogUpdate&, const TopicContentSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void createTopic(const LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_createTopic, llu, name, context).get();
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createTopicAsync(const LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_createTopic, llu, name, context);
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createTopicAsync(const LogUpdate& llu, const ::std::string& name,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::ReplicaObserverPrx::_iceI_createTopic, llu, name, context);
    }

    /// \cond INTERNAL
    void _iceI_createTopic(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LogUpdate&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void destroyTopic(const LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_destroyTopic, llu, name, context).get();
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyTopicAsync(const LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_destroyTopic, llu, name, context);
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyTopicAsync(const LogUpdate& llu, const ::std::string& name,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::ReplicaObserverPrx::_iceI_destroyTopic, llu, name, context);
    }

    /// \cond INTERNAL
    void _iceI_destroyTopic(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LogUpdate&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void addSubscriber(const LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_addSubscriber, llu, topic, record, context).get();
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addSubscriberAsync(const LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_addSubscriber, llu, topic, record, context);
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addSubscriberAsync(const LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::ReplicaObserverPrx::_iceI_addSubscriber, llu, topic, record, context);
    }

    /// \cond INTERNAL
    void _iceI_addSubscriber(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LogUpdate&, const ::std::string&, const ::IceStorm::SubscriberRecord&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void removeSubscriber(const LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_removeSubscriber, llu, topic, subscribers, context).get();
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeSubscriberAsync(const LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_removeSubscriber, llu, topic, subscribers, context);
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeSubscriberAsync(const LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::ReplicaObserverPrx::_iceI_removeSubscriber, llu, topic, subscribers, context);
    }

    /// \cond INTERNAL
    void _iceI_removeSubscriber(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LogUpdate&, const ::std::string&, const ::Ice::IdentitySeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ReplicaObserverPrx() = default;
    friend ::std::shared_ptr<ReplicaObserverPrx> IceInternal::createProxy<ReplicaObserverPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Interface used to sync topics.
 */
class TopicManagerSyncPrx : public virtual ::Ice::Proxy<TopicManagerSyncPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Retrieve the topic content.
     * @param llu The last log update token.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     */
    void getContent(LogUpdate& llu, TopicContentSeq& content, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<TopicManagerSync::GetContentResult>(true, this, &TopicManagerSyncPrx::_iceI_getContent, context).get();
        llu = ::std::move(_result.llu);
        content = ::std::move(_result.content);
    }

    /**
     * Retrieve the topic content.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getContentAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<TopicManagerSync::GetContentResult>>().get_future())
    {
        return _makePromiseOutgoing<TopicManagerSync::GetContentResult, P>(false, this, &TopicManagerSyncPrx::_iceI_getContent, context);
    }

    /**
     * Retrieve the topic content.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getContentAsync(::std::function<void(::IceStormElection::LogUpdate, ::IceStormElection::TopicContentSeq)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](TopicManagerSync::GetContentResult&& _result)
        {
            response(::std::move(_result.llu), ::std::move(_result.content));
        };
        return _makeLamdaOutgoing<TopicManagerSync::GetContentResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceStormElection::TopicManagerSyncPrx::_iceI_getContent, context);
    }

    /// \cond INTERNAL
    void _iceI_getContent(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<TopicManagerSync::GetContentResult>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    TopicManagerSyncPrx() = default;
    friend ::std::shared_ptr<TopicManagerSyncPrx> IceInternal::createProxy<TopicManagerSyncPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * A replica node.
 */
class NodePrx : public virtual ::Ice::Proxy<NodePrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param context The Context map to send with the invocation.
     */
    void invitation(int j, const ::std::string& gn, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_invitation, j, gn, context).get();
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto invitationAsync(int j, const ::std::string& gn, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_invitation, j, gn, context);
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    invitationAsync(int j, const ::std::string& gn,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_invitation, j, gn, context);
    }

    /// \cond INTERNAL
    void _iceI_invitation(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param context The Context map to send with the invocation.
     */
    void ready(int j, const ::std::string& gn, const ::std::shared_ptr<::Ice::ObjectPrx>& coordinator, int max, long long int generation, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_ready, j, gn, coordinator, max, generation, context).get();
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto readyAsync(int j, const ::std::string& gn, const ::std::shared_ptr<::Ice::ObjectPrx>& coordinator, int max, long long int generation, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_ready, j, gn, coordinator, max, generation, context);
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    readyAsync(int j, const ::std::string& gn, const ::std::shared_ptr<::Ice::ObjectPrx>& coordinator, int max, long long int generation,
               ::std::function<void()> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_ready, j, gn, coordinator, max, generation, context);
    }

    /// \cond INTERNAL
    void _iceI_ready(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, int, long long int, const ::Ice::Context&);
    /// \endcond

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param context The Context map to send with the invocation.
     */
    void accept(int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::std::shared_ptr<::Ice::ObjectPrx>& observer, const LogUpdate& llu, int max, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_accept, j, gn, forwardedInvites, observer, llu, max, context).get();
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto acceptAsync(int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::std::shared_ptr<::Ice::ObjectPrx>& observer, const LogUpdate& llu, int max, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_accept, j, gn, forwardedInvites, observer, llu, max, context);
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    acceptAsync(int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::std::shared_ptr<::Ice::ObjectPrx>& observer, const LogUpdate& llu, int max,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_accept, j, gn, forwardedInvites, observer, llu, max, context);
    }

    /// \cond INTERNAL
    void _iceI_accept(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::Ice::IntSeq&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const LogUpdate&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Determine if this node is a coordinator.
     * @param context The Context map to send with the invocation.
     * @return True if the node is a coordinator, false otherwise.
     */
    bool areYouCoordinator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &NodePrx::_iceI_areYouCoordinator, context).get();
    }

    /**
     * Determine if this node is a coordinator.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto areYouCoordinatorAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &NodePrx::_iceI_areYouCoordinator, context);
    }

    /**
     * Determine if this node is a coordinator.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    areYouCoordinatorAsync(::std::function<void(bool)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_areYouCoordinator, context);
    }

    /// \cond INTERNAL
    void _iceI_areYouCoordinator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param context The Context map to send with the invocation.
     * @return True if the node is a member, false otherwise.
     */
    bool areYouThere(const ::std::string& gn, int j, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &NodePrx::_iceI_areYouThere, gn, j, context).get();
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto areYouThereAsync(const ::std::string& gn, int j, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &NodePrx::_iceI_areYouThere, gn, j, context);
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    areYouThereAsync(const ::std::string& gn, int j,
                     ::std::function<void(bool)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_areYouThere, gn, j, context);
    }

    /// \cond INTERNAL
    void _iceI_areYouThere(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the sync object for the replica hosted by this node.
     * @param context The Context map to send with the invocation.
     * @return The sync object.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> sync(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &NodePrx::_iceI_sync, context).get();
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto syncAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &NodePrx::_iceI_sync, context);
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    syncAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_sync, context);
    }

    /// \cond INTERNAL
    void _iceI_sync(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the replication group information.
     * @param context The Context map to send with the invocation.
     * @return The set of configured nodes and the associated
     * priority.
     */
    NodeInfoSeq nodes(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceStormElection::NodeInfoSeq>(true, this, &NodePrx::_iceI_nodes, context).get();
    }

    /**
     * Get the replication group information.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto nodesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceStormElection::NodeInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceStormElection::NodeInfoSeq, P>(false, this, &NodePrx::_iceI_nodes, context);
    }

    /**
     * Get the replication group information.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    nodesAsync(::std::function<void(::IceStormElection::NodeInfoSeq)> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceStormElection::NodeInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_nodes, context);
    }

    /// \cond INTERNAL
    void _iceI_nodes(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStormElection::NodeInfoSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the query information for the given node.
     * @param context The Context map to send with the invocation.
     * @return The query information.
     */
    QueryInfo query(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceStormElection::QueryInfo>(true, this, &NodePrx::_iceI_query, context).get();
    }

    /**
     * Get the query information for the given node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto queryAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceStormElection::QueryInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceStormElection::QueryInfo, P>(false, this, &NodePrx::_iceI_query, context);
    }

    /**
     * Get the query information for the given node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    queryAsync(::std::function<void(::IceStormElection::QueryInfo)> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceStormElection::QueryInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceStormElection::NodePrx::_iceI_query, context);
    }

    /// \cond INTERNAL
    void _iceI_query(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStormElection::QueryInfo>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    NodePrx() = default;
    friend ::std::shared_ptr<NodePrx> IceInternal::createProxy<NodePrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::IceStormElection::TopicContent>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceStormElection::TopicContent, S>
{
    static void read(S* istr, ::IceStormElection::TopicContent& v)
    {
        istr->readAll(v.id, v.records);
    }
};

template<typename S>
struct StreamReader<::IceStormElection::ObserverInconsistencyException, S>
{
    static void read(S* istr, ::IceStormElection::ObserverInconsistencyException& v)
    {
        istr->readAll(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceStormElection::NodeState>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits<::IceStormElection::NodeInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceStormElection::NodeInfo, S>
{
    static void read(S* istr, ::IceStormElection::NodeInfo& v)
    {
        istr->readAll(v.id, v.n);
    }
};

template<>
struct StreamableTraits<::IceStormElection::GroupInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 20;
    static const bool fixedLength = true;
};

template<typename S>
struct StreamReader<::IceStormElection::GroupInfo, S>
{
    static void read(S* istr, ::IceStormElection::GroupInfo& v)
    {
        istr->readAll(v.id, v.llu);
    }
};

template<>
struct StreamableTraits<::IceStormElection::QueryInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 17;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceStormElection::QueryInfo, S>
{
    static void read(S* istr, ::IceStormElection::QueryInfo& v)
    {
        istr->readAll(v.id, v.coord, v.group, v.replica, v.state, v.up, v.max);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceStormElection
{

using ReplicaObserverPtr = ::std::shared_ptr<ReplicaObserver>;
using ReplicaObserverPrxPtr = ::std::shared_ptr<ReplicaObserverPrx>;

using TopicManagerSyncPtr = ::std::shared_ptr<TopicManagerSync>;
using TopicManagerSyncPrxPtr = ::std::shared_ptr<TopicManagerSyncPrx>;

using NodePtr = ::std::shared_ptr<Node>;
using NodePrxPtr = ::std::shared_ptr<NodePrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceStormElection
{

class ReplicaObserver;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ReplicaObserver>&);
::IceProxy::Ice::Object* upCast(ReplicaObserver*);
/// \endcond

class TopicManagerSync;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< TopicManagerSync>&);
::IceProxy::Ice::Object* upCast(TopicManagerSync*);
/// \endcond

class Node;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Node>&);
::IceProxy::Ice::Object* upCast(Node*);
/// \endcond

}

}

namespace IceStormElection
{

class ReplicaObserver;
/// \cond INTERNAL
::Ice::Object* upCast(ReplicaObserver*);
/// \endcond
typedef ::IceInternal::Handle< ReplicaObserver> ReplicaObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStormElection::ReplicaObserver> ReplicaObserverPrx;
typedef ReplicaObserverPrx ReplicaObserverPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ReplicaObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class TopicManagerSync;
/// \cond INTERNAL
::Ice::Object* upCast(TopicManagerSync*);
/// \endcond
typedef ::IceInternal::Handle< TopicManagerSync> TopicManagerSyncPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStormElection::TopicManagerSync> TopicManagerSyncPrx;
typedef TopicManagerSyncPrx TopicManagerSyncPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(TopicManagerSyncPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Node;
/// \cond INTERNAL
::Ice::Object* upCast(Node*);
/// \endcond
typedef ::IceInternal::Handle< Node> NodePtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStormElection::Node> NodePrx;
typedef NodePrx NodePrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(NodePtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceStormElection
{

/**
 * The contents of topic.
 */
struct TopicContent
{
    /**
     * The topic identity.
     */
    ::Ice::Identity id;
    /**
     * The topic subscribers.
     */
    ::IceStorm::SubscriberRecordSeq records;
};

/**
 * A sequence of topic content.
 */
typedef ::std::vector<TopicContent> TopicContentSeq;

/**
 * Thrown if an observer detects an inconsistency.
 */
class ObserverInconsistencyException : public ::Ice::UserException
{
public:

    ObserverInconsistencyException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the inconsistency.
     */
    explicit ObserverInconsistencyException(const ::std::string& reason);

#ifdef ICE_CPP11_COMPILER
    ObserverInconsistencyException(const ObserverInconsistencyException&) = default;
    virtual ~ObserverInconsistencyException();
#else
    virtual ~ObserverInconsistencyException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ObserverInconsistencyException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the inconsistency.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static ObserverInconsistencyException _iceS_ObserverInconsistencyException_init;
/// \endcond

/**
 * The node state.
 */
enum NodeState
{
    /**
     * The node is inactive and awaiting an election.
     */
    NodeStateInactive,
    /**
     * The node is electing a leader.
     */
    NodeStateElection,
    /**
     * The replica group is reorganizing.
     */
    NodeStateReorganization,
    /**
     * The replica group is active & replicating.
     */
    NodeStateNormal
};

/**
 * All nodes in the replication group.
 */
struct NodeInfo
{
    /**
     * The identity of the node.
     */
    ::Ice::Int id;
    /**
     * The node proxy.
     */
    ::IceStormElection::NodePrx n;
};

/**
 * A sequence of node info.
 */
typedef ::std::vector<NodeInfo> NodeInfoSeq;

/**
 * The group info.
 */
struct GroupInfo
{
    /**
     * The identity of the node.
     */
    ::Ice::Int id;
    /**
     * The last known log update for this node.
     */
    ::IceStormElection::LogUpdate llu;

    bool operator==(const GroupInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(llu != rhs_.llu)
        {
            return false;
        }
        return true;
    }

    bool operator<(const GroupInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(llu < rhs_.llu)
        {
            return true;
        }
        else if(rhs_.llu < llu)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const GroupInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const GroupInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const GroupInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const GroupInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of group info.
 */
typedef ::std::vector<GroupInfo> GroupInfoSeq;

struct QueryInfo
{
    /**
     * The node id.
     */
    ::Ice::Int id;
    /**
     * The nodes coordinator.
     */
    ::Ice::Int coord;
    /**
     * The nodes group name.
     */
    ::std::string group;
    /**
     * The replica the node is managing.
     */
    ::Ice::ObjectPrx replica;
    /**
     * The node state.
     */
    ::IceStormElection::NodeState state;
    /**
     * The sequence of nodes in this nodes group.
     */
    ::IceStormElection::GroupInfoSeq up;
    /**
     * The highest priority node that this node has seen.
     */
    ::Ice::Int max;
};

}

namespace IceStormElection
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_init.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_init.
 */
class Callback_ReplicaObserver_init_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_init_Base> Callback_ReplicaObserver_initPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_createTopic.
 */
class Callback_ReplicaObserver_createTopic_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_createTopic_Base> Callback_ReplicaObserver_createTopicPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_destroyTopic.
 */
class Callback_ReplicaObserver_destroyTopic_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_destroyTopic_Base> Callback_ReplicaObserver_destroyTopicPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_addSubscriber.
 */
class Callback_ReplicaObserver_addSubscriber_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_addSubscriber_Base> Callback_ReplicaObserver_addSubscriberPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_removeSubscriber.
 */
class Callback_ReplicaObserver_removeSubscriber_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_removeSubscriber_Base> Callback_ReplicaObserver_removeSubscriberPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_TopicManagerSync_getContent.
 */
class Callback_TopicManagerSync_getContent_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManagerSync_getContent_Base> Callback_TopicManagerSync_getContentPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_invitation.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_invitation.
 */
class Callback_Node_invitation_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_invitation_Base> Callback_Node_invitationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_ready.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_ready.
 */
class Callback_Node_ready_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_ready_Base> Callback_Node_readyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_accept.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_accept.
 */
class Callback_Node_accept_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_accept_Base> Callback_Node_acceptPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_areYouCoordinator.
 */
class Callback_Node_areYouCoordinator_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_areYouCoordinator_Base> Callback_Node_areYouCoordinatorPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_areYouThere.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_areYouThere.
 */
class Callback_Node_areYouThere_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_areYouThere_Base> Callback_Node_areYouTherePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_sync.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_sync.
 */
class Callback_Node_sync_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_sync_Base> Callback_Node_syncPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_nodes.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_nodes.
 */
class Callback_Node_nodes_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_nodes_Base> Callback_Node_nodesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStormElection::Node::begin_query.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_query.
 */
class Callback_Node_query_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_query_Base> Callback_Node_queryPtr;

}

namespace IceProxy
{

namespace IceStormElection
{

class ReplicaObserver : public virtual ::Ice::Proxy<ReplicaObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void init(const ::IceStormElection::LogUpdate& llu, const ::IceStormElection::TopicContentSeq& content, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_init(_iceI_begin_init(llu, content, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::IceStormElection::LogUpdate& llu, const ::IceStormElection::TopicContentSeq& content, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_init(llu, content, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::IceStormElection::LogUpdate& llu, const ::IceStormElection::TopicContentSeq& content, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(llu, content, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::IceStormElection::LogUpdate& llu, const ::IceStormElection::TopicContentSeq& content, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(llu, content, context, cb, cookie);
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::IceStormElection::LogUpdate& llu, const ::IceStormElection::TopicContentSeq& content, const ::IceStormElection::Callback_ReplicaObserver_initPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(llu, content, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::IceStormElection::LogUpdate& llu, const ::IceStormElection::TopicContentSeq& content, const ::Ice::Context& context, const ::IceStormElection::Callback_ReplicaObserver_initPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(llu, content, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_init.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void end_init(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_init(const ::IceStormElection::LogUpdate&, const ::IceStormElection::TopicContentSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void createTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_createTopic(_iceI_begin_createTopic(llu, name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createTopic(llu, name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createTopic(llu, name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createTopic(llu, name, context, cb, cookie);
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::IceStormElection::Callback_ReplicaObserver_createTopicPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createTopic(llu, name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context, const ::IceStormElection::Callback_ReplicaObserver_createTopicPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createTopic(llu, name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createTopic.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void end_createTopic(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_createTopic(const ::IceStormElection::LogUpdate&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void destroyTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroyTopic(_iceI_begin_destroyTopic(llu, name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroyTopic(llu, name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyTopic(llu, name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyTopic(llu, name, context, cb, cookie);
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::IceStormElection::Callback_ReplicaObserver_destroyTopicPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyTopic(llu, name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyTopic(const ::IceStormElection::LogUpdate& llu, const ::std::string& name, const ::Ice::Context& context, const ::IceStormElection::Callback_ReplicaObserver_destroyTopicPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyTopic(llu, name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroyTopic.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void end_destroyTopic(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_destroyTopic(const ::IceStormElection::LogUpdate&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void addSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addSubscriber(_iceI_begin_addSubscriber(llu, topic, record, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addSubscriber(llu, topic, record, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addSubscriber(llu, topic, record, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addSubscriber(llu, topic, record, context, cb, cookie);
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::IceStormElection::Callback_ReplicaObserver_addSubscriberPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addSubscriber(llu, topic, record, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Context& context, const ::IceStormElection::Callback_ReplicaObserver_addSubscriberPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addSubscriber(llu, topic, record, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addSubscriber.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void end_addSubscriber(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_addSubscriber(const ::IceStormElection::LogUpdate&, const ::std::string&, const ::IceStorm::SubscriberRecord&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param context The Context map to send with the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void removeSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeSubscriber(_iceI_begin_removeSubscriber(llu, topic, subscribers, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeSubscriber(llu, topic, subscribers, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeSubscriber(llu, topic, subscribers, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeSubscriber(llu, topic, subscribers, context, cb, cookie);
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::IceStormElection::Callback_ReplicaObserver_removeSubscriberPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeSubscriber(llu, topic, subscribers, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeSubscriber(const ::IceStormElection::LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Context& context, const ::IceStormElection::Callback_ReplicaObserver_removeSubscriberPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeSubscriber(llu, topic, subscribers, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_removeSubscriber.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    void end_removeSubscriber(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_removeSubscriber(const ::IceStormElection::LogUpdate&, const ::std::string&, const ::Ice::IdentitySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class TopicManagerSync : public virtual ::Ice::Proxy<TopicManagerSync, ::IceProxy::Ice::Object>
{
public:

    /**
     * Retrieve the topic content.
     * @param llu The last log update token.
     * @param content The topic content.
     * @param context The Context map to send with the invocation.
     */
    void getContent(::IceStormElection::LogUpdate& llu, ::IceStormElection::TopicContentSeq& content, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_getContent(llu, content, _iceI_begin_getContent(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve the topic content.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getContent(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getContent(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve the topic content.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getContent(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getContent(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve the topic content.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getContent(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getContent(context, cb, cookie);
    }

    /**
     * Retrieve the topic content.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getContent(const ::IceStormElection::Callback_TopicManagerSync_getContentPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getContent(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve the topic content.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getContent(const ::Ice::Context& context, const ::IceStormElection::Callback_TopicManagerSync_getContentPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getContent(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getContent.
     * @param llu The last log update token.
     * @param content The topic content.
     * @param result The asynchronous result object for the invocation.
     */
    void end_getContent(::IceStormElection::LogUpdate& llu, ::IceStormElection::TopicContentSeq& content, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getContent(::IceStormElection::LogUpdate& iceP_llu, ::IceStormElection::TopicContentSeq& iceP_content, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getContent(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Node : public virtual ::Ice::Proxy<Node, ::IceProxy::Ice::Object>
{
public:

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param context The Context map to send with the invocation.
     */
    void invitation(::Ice::Int j, const ::std::string& gn, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_invitation(_iceI_begin_invitation(j, gn, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_invitation(::Ice::Int j, const ::std::string& gn, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_invitation(j, gn, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_invitation(::Ice::Int j, const ::std::string& gn, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_invitation(j, gn, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_invitation(::Ice::Int j, const ::std::string& gn, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_invitation(j, gn, context, cb, cookie);
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_invitation(::Ice::Int j, const ::std::string& gn, const ::IceStormElection::Callback_Node_invitationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_invitation(j, gn, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_invitation(::Ice::Int j, const ::std::string& gn, const ::Ice::Context& context, const ::IceStormElection::Callback_Node_invitationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_invitation(j, gn, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_invitation.
     * @param result The asynchronous result object for the invocation.
     */
    void end_invitation(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_invitation(::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param context The Context map to send with the invocation.
     */
    void ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_ready(_iceI_begin_ready(j, gn, coordinator, max, generation, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_ready(j, gn, coordinator, max, generation, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_ready(j, gn, coordinator, max, generation, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_ready(j, gn, coordinator, max, generation, context, cb, cookie);
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::IceStormElection::Callback_Node_readyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_ready(j, gn, coordinator, max, generation, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::Ice::Context& context, const ::IceStormElection::Callback_Node_readyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_ready(j, gn, coordinator, max, generation, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_ready.
     * @param result The asynchronous result object for the invocation.
     */
    void end_ready(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_ready(::Ice::Int, const ::std::string&, const ::Ice::ObjectPrx&, ::Ice::Int, ::Ice::Long, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param context The Context map to send with the invocation.
     */
    void accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const ::IceStormElection::LogUpdate& llu, ::Ice::Int max, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_accept(_iceI_begin_accept(j, gn, forwardedInvites, observer, llu, max, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const ::IceStormElection::LogUpdate& llu, ::Ice::Int max, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_accept(j, gn, forwardedInvites, observer, llu, max, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const ::IceStormElection::LogUpdate& llu, ::Ice::Int max, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_accept(j, gn, forwardedInvites, observer, llu, max, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const ::IceStormElection::LogUpdate& llu, ::Ice::Int max, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_accept(j, gn, forwardedInvites, observer, llu, max, context, cb, cookie);
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const ::IceStormElection::LogUpdate& llu, ::Ice::Int max, const ::IceStormElection::Callback_Node_acceptPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_accept(j, gn, forwardedInvites, observer, llu, max, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const ::IceStormElection::LogUpdate& llu, ::Ice::Int max, const ::Ice::Context& context, const ::IceStormElection::Callback_Node_acceptPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_accept(j, gn, forwardedInvites, observer, llu, max, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_accept.
     * @param result The asynchronous result object for the invocation.
     */
    void end_accept(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_accept(::Ice::Int, const ::std::string&, const ::Ice::IntSeq&, const ::Ice::ObjectPrx&, const ::IceStormElection::LogUpdate&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Determine if this node is a coordinator.
     * @param context The Context map to send with the invocation.
     * @return True if the node is a coordinator, false otherwise.
     */
    bool areYouCoordinator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_areYouCoordinator(_iceI_begin_areYouCoordinator(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Determine if this node is a coordinator.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouCoordinator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_areYouCoordinator(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Determine if this node is a coordinator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouCoordinator(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouCoordinator(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Determine if this node is a coordinator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouCoordinator(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouCoordinator(context, cb, cookie);
    }

    /**
     * Determine if this node is a coordinator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouCoordinator(const ::IceStormElection::Callback_Node_areYouCoordinatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouCoordinator(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Determine if this node is a coordinator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouCoordinator(const ::Ice::Context& context, const ::IceStormElection::Callback_Node_areYouCoordinatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouCoordinator(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_areYouCoordinator.
     * @param result The asynchronous result object for the invocation.
     * @return True if the node is a coordinator, false otherwise.
     */
    bool end_areYouCoordinator(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_areYouCoordinator(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param context The Context map to send with the invocation.
     * @return True if the node is a member, false otherwise.
     */
    bool areYouThere(const ::std::string& gn, ::Ice::Int j, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_areYouThere(_iceI_begin_areYouThere(gn, j, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouThere(const ::std::string& gn, ::Ice::Int j, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_areYouThere(gn, j, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouThere(const ::std::string& gn, ::Ice::Int j, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouThere(gn, j, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouThere(const ::std::string& gn, ::Ice::Int j, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouThere(gn, j, context, cb, cookie);
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouThere(const ::std::string& gn, ::Ice::Int j, const ::IceStormElection::Callback_Node_areYouTherePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouThere(gn, j, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_areYouThere(const ::std::string& gn, ::Ice::Int j, const ::Ice::Context& context, const ::IceStormElection::Callback_Node_areYouTherePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_areYouThere(gn, j, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_areYouThere.
     * @param result The asynchronous result object for the invocation.
     * @return True if the node is a member, false otherwise.
     */
    bool end_areYouThere(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_areYouThere(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the sync object for the replica hosted by this node.
     * @param context The Context map to send with the invocation.
     * @return The sync object.
     */
    ::Ice::ObjectPrx sync(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_sync(_iceI_begin_sync(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sync(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sync(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sync(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sync(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sync(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sync(context, cb, cookie);
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sync(const ::IceStormElection::Callback_Node_syncPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sync(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the sync object for the replica hosted by this node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sync(const ::Ice::Context& context, const ::IceStormElection::Callback_Node_syncPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sync(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_sync.
     * @param result The asynchronous result object for the invocation.
     * @return The sync object.
     */
    ::Ice::ObjectPrx end_sync(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_sync(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the replication group information.
     * @param context The Context map to send with the invocation.
     * @return The set of configured nodes and the associated
     * priority.
     */
    ::IceStormElection::NodeInfoSeq nodes(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_nodes(_iceI_begin_nodes(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the replication group information.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodes(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodes(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the replication group information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodes(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodes(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the replication group information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodes(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodes(context, cb, cookie);
    }

    /**
     * Get the replication group information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodes(const ::IceStormElection::Callback_Node_nodesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodes(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the replication group information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodes(const ::Ice::Context& context, const ::IceStormElection::Callback_Node_nodesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodes(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_nodes.
     * @param result The asynchronous result object for the invocation.
     * @return The set of configured nodes and the associated
     * priority.
     */
    ::IceStormElection::NodeInfoSeq end_nodes(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_nodes(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the query information for the given node.
     * @param context The Context map to send with the invocation.
     * @return The query information.
     */
    ::IceStormElection::QueryInfo query(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_query(_iceI_begin_query(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the query information for the given node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_query(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_query(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the query information for the given node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_query(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_query(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the query information for the given node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_query(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_query(context, cb, cookie);
    }

    /**
     * Get the query information for the given node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_query(const ::IceStormElection::Callback_Node_queryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_query(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the query information for the given node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_query(const ::Ice::Context& context, const ::IceStormElection::Callback_Node_queryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_query(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_query.
     * @param result The asynchronous result object for the invocation.
     * @return The query information.
     */
    ::IceStormElection::QueryInfo end_query(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_query(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceStormElection
{

/**
 * The replica observer.
 */
class ReplicaObserver : public virtual ::Ice::Object
{
public:

    typedef ReplicaObserverPrx ProxyType;
    typedef ReplicaObserverPtr PointerType;

    virtual ~ReplicaObserver();

#ifdef ICE_CPP11_COMPILER
    ReplicaObserver() = default;
    ReplicaObserver(const ReplicaObserver&) = default;
    ReplicaObserver& operator=(const ReplicaObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Initialize the observer.
     * @param llu The last log update seen by the master.
     * @param content The topic content.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void init(const LogUpdate& llu, const TopicContentSeq& content, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_init(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void createTopic(const LogUpdate& llu, const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createTopic(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the topic with the given name.
     * @param llu The log update token.
     * @param name The topic name.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void destroyTopic(const LogUpdate& llu, const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroyTopic(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a subscriber to a topic.
     * @param llu The log update token.
     * @param topic The topic name to which to add the subscriber.
     * @param record The subscriber information.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void addSubscriber(const LogUpdate& llu, const ::std::string& topic, const ::IceStorm::SubscriberRecord& record, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addSubscriber(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a subscriber from a topic.
     * @param llu The log update token.
     * @param subscribers The identities of the subscribers to remove.
     * @param current The Current object for the invocation.
     * @throws IceStormElection::ObserverInconsistencyException Raised if an
     * inconsisency was detected.
     */
    virtual void removeSubscriber(const LogUpdate& llu, const ::std::string& topic, const ::Ice::IdentitySeq& subscribers, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeSubscriber(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ReplicaObserver& lhs, const ReplicaObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ReplicaObserver& lhs, const ReplicaObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Interface used to sync topics.
 */
class TopicManagerSync : public virtual ::Ice::Object
{
public:

    typedef TopicManagerSyncPrx ProxyType;
    typedef TopicManagerSyncPtr PointerType;

    virtual ~TopicManagerSync();

#ifdef ICE_CPP11_COMPILER
    TopicManagerSync() = default;
    TopicManagerSync(const TopicManagerSync&) = default;
    TopicManagerSync& operator=(const TopicManagerSync&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Retrieve the topic content.
     * @param llu The last log update token.
     * @param content The topic content.
     * @param current The Current object for the invocation.
     */
    virtual void getContent(LogUpdate& llu, TopicContentSeq& content, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getContent(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const TopicManagerSync& lhs, const TopicManagerSync& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicManagerSync& lhs, const TopicManagerSync& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * A replica node.
 */
class Node : public virtual ::Ice::Object
{
public:

    typedef NodePrx ProxyType;
    typedef NodePtr PointerType;

    virtual ~Node();

#ifdef ICE_CPP11_COMPILER
    Node() = default;
    Node(const Node&) = default;
    Node& operator=(const Node&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Invite the node into a group with the given coordinator and
     * group name.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param current The Current object for the invocation.
     */
    virtual void invitation(::Ice::Int j, const ::std::string& gn, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_invitation(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Call from the group coordinator to a node to inform the node
     * that the replica group is active.
     * @param j The group coordinator.
     * @param gn The group name.
     * @param coordinator The proxy to the coordinator.
     * @param max The highest priority node seen by this replica
     * group.
     * @param generation The current generation count.
     * @param current The Current object for the invocation.
     */
    virtual void ready(::Ice::Int j, const ::std::string& gn, const ::Ice::ObjectPrx& coordinator, ::Ice::Int max, ::Ice::Long generation, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_ready(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called to accept an invitation into
     * the given group.
     * @param j The id of the node accepting the invitation.
     * @param gn The group name.
     * @param forwardedInvites The ids of the nodes to which
     * invitations were forwarded.
     * @param observer The observer.
     * @param llu The last log update for the given node.
     * @param max The highest priority node seen by this replica
     * group.
     * @param current The Current object for the invocation.
     */
    virtual void accept(::Ice::Int j, const ::std::string& gn, const ::Ice::IntSeq& forwardedInvites, const ::Ice::ObjectPrx& observer, const LogUpdate& llu, ::Ice::Int max, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_accept(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Determine if this node is a coordinator.
     * @param current The Current object for the invocation.
     * @return True if the node is a coordinator, false otherwise.
     */
    virtual bool areYouCoordinator(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_areYouCoordinator(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Determine if the node is a member of the given group with the
     * given coordinator.
     * @param gn The group name.
     * @param j The group coordinator.
     * @param current The Current object for the invocation.
     * @return True if the node is a member, false otherwise.
     */
    virtual bool areYouThere(const ::std::string& gn, ::Ice::Int j, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_areYouThere(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the sync object for the replica hosted by this node.
     * @param current The Current object for the invocation.
     * @return The sync object.
     */
    virtual ::Ice::ObjectPrx sync(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_sync(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the replication group information.
     * @param current The Current object for the invocation.
     * @return The set of configured nodes and the associated
     * priority.
     */
    virtual NodeInfoSeq nodes(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_nodes(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the query information for the given node.
     * @param current The Current object for the invocation.
     * @return The query information.
     */
    virtual QueryInfo query(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_query(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Node& lhs, const Node& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Node& lhs, const Node& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceStormElection::TopicContent>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceStormElection::TopicContent, S>
{
    static void write(S* ostr, const ::IceStormElection::TopicContent& v)
    {
        ostr->write(v.id);
        ostr->write(v.records);
    }
};

template<typename S>
struct StreamReader< ::IceStormElection::TopicContent, S>
{
    static void read(S* istr, ::IceStormElection::TopicContent& v)
    {
        istr->read(v.id);
        istr->read(v.records);
    }
};

template<>
struct StreamableTraits< ::IceStormElection::ObserverInconsistencyException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStormElection::ObserverInconsistencyException, S>
{
    static void write(S* ostr, const ::IceStormElection::ObserverInconsistencyException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceStormElection::ObserverInconsistencyException, S>
{
    static void read(S* istr, ::IceStormElection::ObserverInconsistencyException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceStormElection::NodeState>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::IceStormElection::NodeInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceStormElection::NodeInfo, S>
{
    static void write(S* ostr, const ::IceStormElection::NodeInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.n);
    }
};

template<typename S>
struct StreamReader< ::IceStormElection::NodeInfo, S>
{
    static void read(S* istr, ::IceStormElection::NodeInfo& v)
    {
        istr->read(v.id);
        istr->read(v.n);
    }
};

template<>
struct StreamableTraits< ::IceStormElection::GroupInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 20;
    static const bool fixedLength = true;
};

template<typename S>
struct StreamWriter< ::IceStormElection::GroupInfo, S>
{
    static void write(S* ostr, const ::IceStormElection::GroupInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.llu);
    }
};

template<typename S>
struct StreamReader< ::IceStormElection::GroupInfo, S>
{
    static void read(S* istr, ::IceStormElection::GroupInfo& v)
    {
        istr->read(v.id);
        istr->read(v.llu);
    }
};

template<>
struct StreamableTraits< ::IceStormElection::QueryInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 17;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceStormElection::QueryInfo, S>
{
    static void write(S* ostr, const ::IceStormElection::QueryInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.coord);
        ostr->write(v.group);
        ostr->write(v.replica);
        ostr->write(v.state);
        ostr->write(v.up);
        ostr->write(v.max);
    }
};

template<typename S>
struct StreamReader< ::IceStormElection::QueryInfo, S>
{
    static void read(S* istr, ::IceStormElection::QueryInfo& v)
    {
        istr->read(v.id);
        istr->read(v.coord);
        istr->read(v.group);
        istr->read(v.replica);
        istr->read(v.state);
        istr->read(v.up);
        istr->read(v.max);
    }
};

}
/// \endcond

namespace IceStormElection
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_init.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_init.
 */
template<class T>
class CallbackNC_ReplicaObserver_init : public Callback_ReplicaObserver_init_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_init(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_init<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_init<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_init<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_init<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_init.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_init.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_init : public Callback_ReplicaObserver_init_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_init(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T, typename CT> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_init<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T, typename CT> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_init<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T, typename CT> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_init<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_init.
 */
template<class T, typename CT> Callback_ReplicaObserver_initPtr
newCallback_ReplicaObserver_init(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_init<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_createTopic.
 */
template<class T>
class CallbackNC_ReplicaObserver_createTopic : public Callback_ReplicaObserver_createTopic_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_createTopic(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_createTopic(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_createTopic<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_createTopic<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_createTopic<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_createTopic<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_createTopic.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_createTopic : public Callback_ReplicaObserver_createTopic_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_createTopic(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_createTopic(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_createTopic<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_createTopic<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_createTopic<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_createTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_createTopicPtr
newCallback_ReplicaObserver_createTopic(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_createTopic<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_destroyTopic.
 */
template<class T>
class CallbackNC_ReplicaObserver_destroyTopic : public Callback_ReplicaObserver_destroyTopic_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_destroyTopic(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroyTopic(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_destroyTopic<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_destroyTopic<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_destroyTopic<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_destroyTopic<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_destroyTopic.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_destroyTopic : public Callback_ReplicaObserver_destroyTopic_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_destroyTopic(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroyTopic(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_destroyTopic<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_destroyTopic<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_destroyTopic<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_destroyTopic.
 */
template<class T, typename CT> Callback_ReplicaObserver_destroyTopicPtr
newCallback_ReplicaObserver_destroyTopic(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_destroyTopic<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_addSubscriber.
 */
template<class T>
class CallbackNC_ReplicaObserver_addSubscriber : public Callback_ReplicaObserver_addSubscriber_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_addSubscriber(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addSubscriber(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_addSubscriber<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_addSubscriber<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_addSubscriber<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_addSubscriber<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_addSubscriber.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_addSubscriber : public Callback_ReplicaObserver_addSubscriber_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_addSubscriber(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addSubscriber(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_addSubscriber<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_addSubscriber<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_addSubscriber<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_addSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_addSubscriberPtr
newCallback_ReplicaObserver_addSubscriber(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_addSubscriber<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_removeSubscriber.
 */
template<class T>
class CallbackNC_ReplicaObserver_removeSubscriber : public Callback_ReplicaObserver_removeSubscriber_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_removeSubscriber(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeSubscriber(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_removeSubscriber<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_removeSubscriber<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_removeSubscriber<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_removeSubscriber<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_ReplicaObserver_removeSubscriber.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_removeSubscriber : public Callback_ReplicaObserver_removeSubscriber_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_removeSubscriber(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaObserverPrx proxy = ReplicaObserverPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeSubscriber(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_removeSubscriber<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_removeSubscriber<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_removeSubscriber<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::ReplicaObserver::begin_removeSubscriber.
 */
template<class T, typename CT> Callback_ReplicaObserver_removeSubscriberPtr
newCallback_ReplicaObserver_removeSubscriber(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_removeSubscriber<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_TopicManagerSync_getContent.
 */
template<class T>
class CallbackNC_TopicManagerSync_getContent : public Callback_TopicManagerSync_getContent_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LogUpdate&, const TopicContentSeq&);

    CallbackNC_TopicManagerSync_getContent(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerSyncPrx proxy = TopicManagerSyncPrx::uncheckedCast(result->getProxy());
        LogUpdate iceP_llu;
        TopicContentSeq iceP_content;
        try
        {
            proxy->end_getContent(iceP_llu, iceP_content, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(iceP_llu, iceP_content);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 */
template<class T> Callback_TopicManagerSync_getContentPtr
newCallback_TopicManagerSync_getContent(const IceUtil::Handle<T>& instance, void (T::*cb)(const LogUpdate&, const TopicContentSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManagerSync_getContent<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 */
template<class T> Callback_TopicManagerSync_getContentPtr
newCallback_TopicManagerSync_getContent(T* instance, void (T::*cb)(const LogUpdate&, const TopicContentSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManagerSync_getContent<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_TopicManagerSync_getContent.
 */
template<class T, typename CT>
class Callback_TopicManagerSync_getContent : public Callback_TopicManagerSync_getContent_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LogUpdate&, const TopicContentSeq&, const CT&);

    Callback_TopicManagerSync_getContent(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerSyncPrx proxy = TopicManagerSyncPrx::uncheckedCast(result->getProxy());
        LogUpdate iceP_llu;
        TopicContentSeq iceP_content;
        try
        {
            proxy->end_getContent(iceP_llu, iceP_content, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(iceP_llu, iceP_content, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 */
template<class T, typename CT> Callback_TopicManagerSync_getContentPtr
newCallback_TopicManagerSync_getContent(const IceUtil::Handle<T>& instance, void (T::*cb)(const LogUpdate&, const TopicContentSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManagerSync_getContent<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::TopicManagerSync::begin_getContent.
 */
template<class T, typename CT> Callback_TopicManagerSync_getContentPtr
newCallback_TopicManagerSync_getContent(T* instance, void (T::*cb)(const LogUpdate&, const TopicContentSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManagerSync_getContent<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_invitation.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_invitation.
 */
template<class T>
class CallbackNC_Node_invitation : public Callback_Node_invitation_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_invitation(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T> Callback_Node_invitationPtr
newCallback_Node_invitation(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_invitation<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T> Callback_Node_invitationPtr
newCallback_Node_invitation(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_invitation<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T> Callback_Node_invitationPtr
newCallback_Node_invitation(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_invitation<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T> Callback_Node_invitationPtr
newCallback_Node_invitation(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_invitation<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_invitation.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_invitation.
 */
template<class T, typename CT>
class Callback_Node_invitation : public Callback_Node_invitation_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_invitation(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T, typename CT> Callback_Node_invitationPtr
newCallback_Node_invitation(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_invitation<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T, typename CT> Callback_Node_invitationPtr
newCallback_Node_invitation(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_invitation<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T, typename CT> Callback_Node_invitationPtr
newCallback_Node_invitation(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_invitation<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_invitation.
 */
template<class T, typename CT> Callback_Node_invitationPtr
newCallback_Node_invitation(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_invitation<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_ready.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_ready.
 */
template<class T>
class CallbackNC_Node_ready : public Callback_Node_ready_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_ready(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T> Callback_Node_readyPtr
newCallback_Node_ready(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_ready<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T> Callback_Node_readyPtr
newCallback_Node_ready(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_ready<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T> Callback_Node_readyPtr
newCallback_Node_ready(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_ready<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T> Callback_Node_readyPtr
newCallback_Node_ready(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_ready<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_ready.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_ready.
 */
template<class T, typename CT>
class Callback_Node_ready : public Callback_Node_ready_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_ready(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T, typename CT> Callback_Node_readyPtr
newCallback_Node_ready(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_ready<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T, typename CT> Callback_Node_readyPtr
newCallback_Node_ready(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_ready<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T, typename CT> Callback_Node_readyPtr
newCallback_Node_ready(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_ready<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_ready.
 */
template<class T, typename CT> Callback_Node_readyPtr
newCallback_Node_ready(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_ready<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_accept.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_accept.
 */
template<class T>
class CallbackNC_Node_accept : public Callback_Node_accept_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_accept(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T> Callback_Node_acceptPtr
newCallback_Node_accept(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_accept<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T> Callback_Node_acceptPtr
newCallback_Node_accept(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_accept<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T> Callback_Node_acceptPtr
newCallback_Node_accept(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_accept<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T> Callback_Node_acceptPtr
newCallback_Node_accept(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_accept<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_accept.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_accept.
 */
template<class T, typename CT>
class Callback_Node_accept : public Callback_Node_accept_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_accept(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T, typename CT> Callback_Node_acceptPtr
newCallback_Node_accept(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_accept<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T, typename CT> Callback_Node_acceptPtr
newCallback_Node_accept(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_accept<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T, typename CT> Callback_Node_acceptPtr
newCallback_Node_accept(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_accept<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_accept.
 */
template<class T, typename CT> Callback_Node_acceptPtr
newCallback_Node_accept(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_accept<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_areYouCoordinator.
 */
template<class T>
class CallbackNC_Node_areYouCoordinator : public Callback_Node_areYouCoordinator_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Node_areYouCoordinator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_areYouCoordinator(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 */
template<class T> Callback_Node_areYouCoordinatorPtr
newCallback_Node_areYouCoordinator(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_areYouCoordinator<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 */
template<class T> Callback_Node_areYouCoordinatorPtr
newCallback_Node_areYouCoordinator(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_areYouCoordinator<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_areYouCoordinator.
 */
template<class T, typename CT>
class Callback_Node_areYouCoordinator : public Callback_Node_areYouCoordinator_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Node_areYouCoordinator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_areYouCoordinator(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 */
template<class T, typename CT> Callback_Node_areYouCoordinatorPtr
newCallback_Node_areYouCoordinator(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_areYouCoordinator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouCoordinator.
 */
template<class T, typename CT> Callback_Node_areYouCoordinatorPtr
newCallback_Node_areYouCoordinator(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_areYouCoordinator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_areYouThere.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_areYouThere.
 */
template<class T>
class CallbackNC_Node_areYouThere : public Callback_Node_areYouThere_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Node_areYouThere(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_areYouThere(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouThere.
 */
template<class T> Callback_Node_areYouTherePtr
newCallback_Node_areYouThere(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_areYouThere<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouThere.
 */
template<class T> Callback_Node_areYouTherePtr
newCallback_Node_areYouThere(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_areYouThere<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_areYouThere.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_areYouThere.
 */
template<class T, typename CT>
class Callback_Node_areYouThere : public Callback_Node_areYouThere_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Node_areYouThere(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_areYouThere(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouThere.
 */
template<class T, typename CT> Callback_Node_areYouTherePtr
newCallback_Node_areYouThere(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_areYouThere<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_areYouThere.
 */
template<class T, typename CT> Callback_Node_areYouTherePtr
newCallback_Node_areYouThere(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_areYouThere<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_sync.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_sync.
 */
template<class T>
class CallbackNC_Node_sync : public Callback_Node_sync_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Node_sync(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_sync(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_sync.
 */
template<class T> Callback_Node_syncPtr
newCallback_Node_sync(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_sync<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_sync.
 */
template<class T> Callback_Node_syncPtr
newCallback_Node_sync(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_sync<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_sync.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_sync.
 */
template<class T, typename CT>
class Callback_Node_sync : public Callback_Node_sync_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Node_sync(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_sync(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_sync.
 */
template<class T, typename CT> Callback_Node_syncPtr
newCallback_Node_sync(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_sync<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_sync.
 */
template<class T, typename CT> Callback_Node_syncPtr
newCallback_Node_sync(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_sync<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_nodes.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_nodes.
 */
template<class T>
class CallbackNC_Node_nodes : public Callback_Node_nodes_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const NodeInfoSeq&);

    CallbackNC_Node_nodes(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        NodeInfoSeq ret;
        try
        {
            ret = proxy->end_nodes(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_nodes.
 */
template<class T> Callback_Node_nodesPtr
newCallback_Node_nodes(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodeInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_nodes<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_nodes.
 */
template<class T> Callback_Node_nodesPtr
newCallback_Node_nodes(T* instance, void (T::*cb)(const NodeInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_nodes<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_nodes.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_nodes.
 */
template<class T, typename CT>
class Callback_Node_nodes : public Callback_Node_nodes_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const NodeInfoSeq&, const CT&);

    Callback_Node_nodes(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        NodeInfoSeq ret;
        try
        {
            ret = proxy->end_nodes(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_nodes.
 */
template<class T, typename CT> Callback_Node_nodesPtr
newCallback_Node_nodes(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodeInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_nodes<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_nodes.
 */
template<class T, typename CT> Callback_Node_nodesPtr
newCallback_Node_nodes(T* instance, void (T::*cb)(const NodeInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_nodes<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStormElection::Node::begin_query.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_query.
 */
template<class T>
class CallbackNC_Node_query : public Callback_Node_query_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const QueryInfo&);

    CallbackNC_Node_query(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        QueryInfo ret;
        try
        {
            ret = proxy->end_query(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_query.
 */
template<class T> Callback_Node_queryPtr
newCallback_Node_query(const IceUtil::Handle<T>& instance, void (T::*cb)(const QueryInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_query<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_query.
 */
template<class T> Callback_Node_queryPtr
newCallback_Node_query(T* instance, void (T::*cb)(const QueryInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_query<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStormElection::Node::begin_query.
 * Create a wrapper instance by calling ::IceStormElection::newCallback_Node_query.
 */
template<class T, typename CT>
class Callback_Node_query : public Callback_Node_query_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const QueryInfo&, const CT&);

    Callback_Node_query(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        QueryInfo ret;
        try
        {
            ret = proxy->end_query(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_query.
 */
template<class T, typename CT> Callback_Node_queryPtr
newCallback_Node_query(const IceUtil::Handle<T>& instance, void (T::*cb)(const QueryInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_query<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStormElection::Node::begin_query.
 */
template<class T, typename CT> Callback_Node_queryPtr
newCallback_Node_query(T* instance, void (T::*cb)(const QueryInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_query<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
