/* ext-storage-monitor.c generated by valac 0.56.17, the Vala compiler
 * generated from ext-storage-monitor.vala, do not modify */

/* ds-registry.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Stefano Candori <stefano.candori@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a Python implementation:
 *  Copyright © 2009 Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Copyright © 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-engine.h"
#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include "zeitgeist.h"

#define ZEITGEIST_NM_NETWORK_MONITOR_NM_BUS_NAME "org.freedesktop.NetworkManager"
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_IFACE "org.freedesktop.NetworkManager"
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_OBJECT_PATH "/org/freedesktop/NetworkManager"
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_PRE_09 3
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_POST_09 70
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_BUS_NAME "net.connman"
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_IFACE "net.connman.Manager"
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_OBJECT_PATH "/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR (zeitgeist_remote_storage_monitor_get_type ())
#define ZEITGEIST_REMOTE_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, ZeitgeistRemoteStorageMonitor))
#define ZEITGEIST_IS_REMOTE_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR))
#define ZEITGEIST_REMOTE_STORAGE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, ZeitgeistRemoteStorageMonitorIface))

typedef struct _ZeitgeistRemoteStorageMonitor ZeitgeistRemoteStorageMonitor;
typedef struct _ZeitgeistRemoteStorageMonitorIface ZeitgeistRemoteStorageMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR_PROXY (zeitgeist_remote_storage_monitor_proxy_get_type ())
enum  {
	ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_AVAILABLE_SIGNAL,
	ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_UNAVAILABLE_SIGNAL,
	ZEITGEIST_REMOTE_STORAGE_MONITOR_NUM_SIGNALS
};
static guint zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_NUM_SIGNALS] = {0};
typedef GDBusProxy ZeitgeistRemoteStorageMonitorProxy;
typedef GDBusProxyClass ZeitgeistRemoteStorageMonitorProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZEITGEIST_TYPE_NETWORK_MONITOR (zeitgeist_network_monitor_get_type ())
#define ZEITGEIST_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_NETWORK_MONITOR, ZeitgeistNetworkMonitor))
#define ZEITGEIST_IS_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_NETWORK_MONITOR))
#define ZEITGEIST_NETWORK_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_NETWORK_MONITOR, ZeitgeistNetworkMonitorIface))

typedef struct _ZeitgeistNetworkMonitor ZeitgeistNetworkMonitor;
typedef struct _ZeitgeistNetworkMonitorIface ZeitgeistNetworkMonitorIface;
enum  {
	ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL,
	ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL,
	ZEITGEIST_NETWORK_MONITOR_NUM_SIGNALS
};
static guint zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_NUM_SIGNALS] = {0};
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define ZEITGEIST_TYPE_STORAGE_MONITOR (zeitgeist_storage_monitor_get_type ())
#define ZEITGEIST_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor))
#define ZEITGEIST_STORAGE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorClass))
#define ZEITGEIST_IS_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR))
#define ZEITGEIST_IS_STORAGE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_STORAGE_MONITOR))
#define ZEITGEIST_STORAGE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorClass))

typedef struct _ZeitgeistStorageMonitor ZeitgeistStorageMonitor;
typedef struct _ZeitgeistStorageMonitorClass ZeitgeistStorageMonitorClass;
typedef struct _ZeitgeistStorageMonitorPrivate ZeitgeistStorageMonitorPrivate;
enum  {
	ZEITGEIST_STORAGE_MONITOR_0_PROPERTY,
	ZEITGEIST_STORAGE_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_storage_monitor_properties[ZEITGEIST_STORAGE_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR (zeitgeist_connman_network_monitor_get_type ())
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitor))
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitorClass))
#define ZEITGEIST_IS_CONNMAN_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR))
#define ZEITGEIST_IS_CONNMAN_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR))
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitorClass))

typedef struct _ZeitgeistConnmanNetworkMonitor ZeitgeistConnmanNetworkMonitor;
typedef struct _ZeitgeistConnmanNetworkMonitorClass ZeitgeistConnmanNetworkMonitorClass;

#define ZEITGEIST_TYPE_NM_NETWORK_MONITOR (zeitgeist_nm_network_monitor_get_type ())
#define ZEITGEIST_NM_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitor))
#define ZEITGEIST_NM_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitorClass))
#define ZEITGEIST_IS_NM_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_NM_NETWORK_MONITOR))
#define ZEITGEIST_IS_NM_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_NM_NETWORK_MONITOR))
#define ZEITGEIST_NM_NETWORK_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitorClass))

typedef struct _ZeitgeistNMNetworkMonitor ZeitgeistNMNetworkMonitor;
typedef struct _ZeitgeistNMNetworkMonitorClass ZeitgeistNMNetworkMonitorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistNMNetworkMonitorPrivate ZeitgeistNMNetworkMonitorPrivate;
enum  {
	ZEITGEIST_NM_NETWORK_MONITOR_0_PROPERTY,
	ZEITGEIST_NM_NETWORK_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_nm_network_monitor_properties[ZEITGEIST_NM_NETWORK_MONITOR_NUM_PROPERTIES];
typedef struct _ZeitgeistConnmanNetworkMonitorPrivate ZeitgeistConnmanNetworkMonitorPrivate;
enum  {
	ZEITGEIST_CONNMAN_NETWORK_MONITOR_0_PROPERTY,
	ZEITGEIST_CONNMAN_NETWORK_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_connman_network_monitor_properties[ZEITGEIST_CONNMAN_NETWORK_MONITOR_NUM_PROPERTIES];

struct _ZeitgeistRemoteStorageMonitorIface {
	GTypeInterface parent_iface;
	GVariant* (*get_storages) (ZeitgeistRemoteStorageMonitor* self, GError** error);
};

struct _ZeitgeistNetworkMonitorIface {
	GTypeInterface parent_iface;
	void (*setup) (ZeitgeistNetworkMonitor* self);
};

struct _ZeitgeistStorageMonitor {
	ZeitgeistExtension parent_instance;
	ZeitgeistStorageMonitorPrivate * priv;
};

struct _ZeitgeistStorageMonitorClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistStorageMonitorPrivate {
	ZeitgeistSQLiteDatabase* database;
	sqlite3* db;
	guint registration_id;
	sqlite3_stmt* get_storages_stmt;
	sqlite3_stmt* store_storage_medium_stmt;
	sqlite3_stmt* update_storage_medium_stmt;
	sqlite3_stmt* insert_unavailable_medium_stmt;
	sqlite3_stmt* update_medium_state_stmt;
	ZeitgeistNetworkMonitor* network;
	guint watch_connman;
	guint watch_nm;
};

struct _ZeitgeistNMNetworkMonitor {
	GObject parent_instance;
	ZeitgeistNMNetworkMonitorPrivate * priv;
};

struct _ZeitgeistNMNetworkMonitorClass {
	GObjectClass parent_class;
};

struct _ZeitgeistNMNetworkMonitorPrivate {
	ZeitgeistNetworkManagerDBus* proxy;
};

struct _ZeitgeistConnmanNetworkMonitor {
	GObject parent_instance;
	ZeitgeistConnmanNetworkMonitorPrivate * priv;
};

struct _ZeitgeistConnmanNetworkMonitorClass {
	GObjectClass parent_class;
};

struct _ZeitgeistConnmanNetworkMonitorPrivate {
	ZeitgeistConnmanManagerDBus* proxy;
};

static GType zeitgeist_remote_storage_monitor_type_id = 0;
static GType zeitgeist_network_monitor_type_id = 0;
static gint ZeitgeistStorageMonitor_private_offset;
static gpointer zeitgeist_storage_monitor_parent_class = NULL;
static ZeitgeistRemoteStorageMonitorIface * zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_parent_iface = NULL;
static GType zeitgeist_storage_monitor_type_id = 0;
static gint ZeitgeistNMNetworkMonitor_private_offset;
static gpointer zeitgeist_nm_network_monitor_parent_class = NULL;
static ZeitgeistNetworkMonitorIface * zeitgeist_nm_network_monitor_zeitgeist_network_monitor_parent_iface = NULL;
static GType zeitgeist_nm_network_monitor_type_id = 0;
static gint ZeitgeistConnmanNetworkMonitor_private_offset;
static gpointer zeitgeist_connman_network_monitor_parent_class = NULL;
static ZeitgeistNetworkMonitorIface * zeitgeist_connman_network_monitor_zeitgeist_network_monitor_parent_iface = NULL;
static GType zeitgeist_connman_network_monitor_type_id = 0;

VALA_EXTERN GType zeitgeist_remote_storage_monitor_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void zeitgeist_remote_storage_monitor_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint zeitgeist_remote_storage_monitor_register_object (void* object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error);
GType zeitgeist_remote_storage_monitor_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_remote_storage_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistRemoteStorageMonitor, g_object_unref)
VALA_EXTERN GVariant* zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self,
                                                         GError** error);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void zeitgeist_remote_storage_monitor_proxy_g_signal (GDBusProxy* proxy,
                                                      const gchar* sender_name,
                                                      const gchar* signal_name,
                                                      GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_available (ZeitgeistRemoteStorageMonitor* self,
                                                                      GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable (ZeitgeistRemoteStorageMonitor* self,
                                                                        GVariant* parameters);
static GVariant* zeitgeist_remote_storage_monitor_proxy_get_storages (ZeitgeistRemoteStorageMonitor* self,
                                                               GError** error);
static void zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface* iface);
static void _dbus_zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void zeitgeist_remote_storage_monitor_dbus_interface_method_call (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* method_name,
                                                                  GVariant* parameters,
                                                                  GDBusMethodInvocation* invocation,
                                                                  gpointer user_data);
static GVariant* zeitgeist_remote_storage_monitor_dbus_interface_get_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GError** error,
                                                                        gpointer user_data);
static gboolean zeitgeist_remote_storage_monitor_dbus_interface_set_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GVariant* value,
                                                                       GError** error,
                                                                       gpointer user_data);
static void _dbus_zeitgeist_remote_storage_monitor_storage_available (GObject* _sender,
                                                               const gchar* storage_id,
                                                               GVariant* storage_description,
                                                               gpointer* _data);
static void _dbus_zeitgeist_remote_storage_monitor_storage_unavailable (GObject* _sender,
                                                                 const gchar* storage_id,
                                                                 gpointer* _data);
static void _zeitgeist_remote_storage_monitor_unregister_object (gpointer user_data);
GType zeitgeist_network_monitor_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_network_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistNetworkMonitor, g_object_unref)
VALA_EXTERN void zeitgeist_network_monitor_setup (ZeitgeistNetworkMonitor* self);
VALA_EXTERN GVariant* zeitgeist_storage_media_to_variant (const gchar* medium_name,
                                              gboolean available,
                                              const gchar* icon,
                                              const gchar* display_name);
GType zeitgeist_storage_monitor_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_storage_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistStorageMonitor, g_object_unref)
static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_new (void);
static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_construct (GType object_type);
static void zeitgeist_storage_monitor_name_appeared_handler (ZeitgeistStorageMonitor* self,
                                                      GDBusConnection* connection,
                                                      const gchar* name,
                                                      const gchar* name_owner);
VALA_EXTERN ZeitgeistConnmanNetworkMonitor* zeitgeist_connman_network_monitor_new (void);
VALA_EXTERN ZeitgeistConnmanNetworkMonitor* zeitgeist_connman_network_monitor_construct (GType object_type);
GType zeitgeist_connman_network_monitor_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_connman_network_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistConnmanNetworkMonitor, g_object_unref)
VALA_EXTERN ZeitgeistNMNetworkMonitor* zeitgeist_nm_network_monitor_new (void);
VALA_EXTERN ZeitgeistNMNetworkMonitor* zeitgeist_nm_network_monitor_construct (GType object_type);
GType zeitgeist_nm_network_monitor_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_nm_network_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistNMNetworkMonitor, g_object_unref)
static void __lambda4_ (ZeitgeistStorageMonitor* self);
VALA_EXTERN void zeitgeist_storage_monitor_add_storage_medium (ZeitgeistStorageMonitor* self,
                                                   const gchar* medium_name,
                                                   const gchar* icon,
                                                   const gchar* display_name);
static void ___lambda4__zeitgeist_network_monitor_on_network_up (ZeitgeistNetworkMonitor* _sender,
                                                          gpointer self);
static void __lambda5_ (ZeitgeistStorageMonitor* self);
VALA_EXTERN void zeitgeist_storage_monitor_remove_storage_medium (ZeitgeistStorageMonitor* self,
                                                      const gchar* medium_name);
static void ___lambda5__zeitgeist_network_monitor_on_network_down (ZeitgeistNetworkMonitor* _sender,
                                                            gpointer self);
static void zeitgeist_storage_monitor_real_unload (ZeitgeistExtension* base);
static void zeitgeist_storage_monitor_prepare_queries (ZeitgeistStorageMonitor* self,
                                                GError** error);
static void zeitgeist_storage_monitor_real_pre_insert_events (ZeitgeistExtension* base,
                                                       GPtrArray* events,
                                                       const char* sender);
static gchar* zeitgeist_storage_monitor_find_storage_for_uri (ZeitgeistStorageMonitor* self,
                                                       const gchar* uri);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static GVariant* zeitgeist_storage_monitor_real_get_storages (ZeitgeistRemoteStorageMonitor* base,
                                                       GError** error);
static GObject * zeitgeist_storage_monitor_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                   const gchar* name,
                                                                                   const gchar* name_owner,
                                                                                   gpointer self);
static void zeitgeist_storage_monitor_finalize (GObject * obj);
static void zeitgeist_nm_network_monitor_real_setup (ZeitgeistNetworkMonitor* base);
static void zeitgeist_nm_network_monitor_on_state_changed (ZeitgeistNMNetworkMonitor* self,
                                                    guint32 state);
static void _zeitgeist_nm_network_monitor_on_state_changed_zeitgeist_network_manager_dbus_state_changed (ZeitgeistNetworkManagerDBus* _sender,
                                                                                                  guint32 state,
                                                                                                  gpointer self);
static void zeitgeist_nm_network_monitor_finalize (GObject * obj);
static void zeitgeist_connman_network_monitor_real_setup (ZeitgeistNetworkMonitor* base);
static void zeitgeist_connman_network_monitor_on_state_changed (ZeitgeistConnmanNetworkMonitor* self,
                                                         const gchar* state);
static void _zeitgeist_connman_network_monitor_on_state_changed_zeitgeist_connman_manager_dbus_state_changed (ZeitgeistConnmanManagerDBus* _sender,
                                                                                                       const gchar* state,
                                                                                                       gpointer self);
static void zeitgeist_connman_network_monitor_finalize (GObject * obj);
VALA_EXTERN GType zeitgeist_storage_monitor_init (GTypeModule* module);

static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_result = {-1, "result", "a(sa{sv})", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_in[] = {NULL};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_out[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_storage_monitor_dbus_method_info_get_storages = {-1, "GetStorages", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_in), (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_out), NULL};
static const GDBusMethodInfo * const _zeitgeist_remote_storage_monitor_dbus_method_info[] = {&_zeitgeist_remote_storage_monitor_dbus_method_info_get_storages, NULL};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_id = {-1, "storage_id", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_description = {-1, "storage_description", "a{sv}", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_id, &_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_description, NULL};
static const GDBusSignalInfo _zeitgeist_remote_storage_monitor_dbus_signal_info_storage_available = {-1, "StorageAvailable", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available), NULL};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable_storage_id = {-1, "storage_id", "s", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable_storage_id, NULL};
static const GDBusSignalInfo _zeitgeist_remote_storage_monitor_dbus_signal_info_storage_unavailable = {-1, "StorageUnavailable", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable), NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_storage_monitor_dbus_signal_info[] = {&_zeitgeist_remote_storage_monitor_dbus_signal_info_storage_available, &_zeitgeist_remote_storage_monitor_dbus_signal_info_storage_unavailable, NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_storage_monitor_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_storage_monitor_dbus_interface_info = {-1, "org.gnome.zeitgeist.StorageMonitor", (GDBusMethodInfo **) (&_zeitgeist_remote_storage_monitor_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_storage_monitor_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_storage_monitor_dbus_property_info), NULL};
static const GDBusInterfaceVTable _zeitgeist_remote_storage_monitor_dbus_interface_vtable = {zeitgeist_remote_storage_monitor_dbus_interface_method_call, zeitgeist_remote_storage_monitor_dbus_interface_get_property, zeitgeist_remote_storage_monitor_dbus_interface_set_property};
static const gchar* ZEITGEIST_STORAGE_MONITOR_network_uri_schemes[9] = {"dav", "davs", "ftp", "http", "https", "mailto", "sftp", "smb", "ssh"};

GVariant*
zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self,
                                               GError** error)
{
	ZeitgeistRemoteStorageMonitorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ZEITGEIST_REMOTE_STORAGE_MONITOR_GET_INTERFACE (self);
	if (_iface_->get_storages) {
		return _iface_->get_storages (self, error);
	}
	return NULL;
}

static void
g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}

static void
zeitgeist_remote_storage_monitor_default_init (ZeitgeistRemoteStorageMonitorIface * iface,
                                               gpointer iface_data)
{
	zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_AVAILABLE_SIGNAL] = g_signal_new ("storage-available", ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
	zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_UNAVAILABLE_SIGNAL] = g_signal_new ("storage-unavailable", ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

GType
zeitgeist_remote_storage_monitor_get_type (void)
{
	return zeitgeist_remote_storage_monitor_type_id;
}

GType
zeitgeist_remote_storage_monitor_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteStorageMonitorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_remote_storage_monitor_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_storage_monitor_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteStorageMonitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_storage_monitor_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_storage_monitor_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.StorageMonitor");
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_storage_monitor_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_storage_monitor_register_object);
	return zeitgeist_remote_storage_monitor_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (ZeitgeistRemoteStorageMonitorProxy, zeitgeist_remote_storage_monitor_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init) )
static void
zeitgeist_remote_storage_monitor_proxy_class_init (ZeitgeistRemoteStorageMonitorProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_storage_monitor_proxy_g_signal;
}

static void
_dbus_handle_zeitgeist_remote_storage_monitor_storage_available (ZeitgeistRemoteStorageMonitor* self,
                                                                 GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* storage_id = NULL;
	GVariant* _tmp0_;
	GVariant* storage_description = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	storage_id = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	storage_description = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "storage-available", storage_id, storage_description);
	_g_free0 (storage_id);
	_g_variant_unref0 (storage_description);
}

static void
_dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable (ZeitgeistRemoteStorageMonitor* self,
                                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* storage_id = NULL;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	storage_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "storage-unavailable", storage_id);
	_g_free0 (storage_id);
}

static void
zeitgeist_remote_storage_monitor_proxy_g_signal (GDBusProxy* proxy,
                                                 const gchar* sender_name,
                                                 const gchar* signal_name,
                                                 GVariant* parameters)
{
	if (strcmp (signal_name, "StorageAvailable") == 0) {
		_dbus_handle_zeitgeist_remote_storage_monitor_storage_available ((ZeitgeistRemoteStorageMonitor*) proxy, parameters);
	} else if (strcmp (signal_name, "StorageUnavailable") == 0) {
		_dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable ((ZeitgeistRemoteStorageMonitor*) proxy, parameters);
	}
}

static void
zeitgeist_remote_storage_monitor_proxy_class_finalize (ZeitgeistRemoteStorageMonitorProxyClass* klass)
{
}

void
zeitgeist_remote_storage_monitor_proxy_register_dynamic_type (GTypeModule* module)
{
	zeitgeist_remote_storage_monitor_proxy_register_type (module);
}

static void
zeitgeist_remote_storage_monitor_proxy_init (ZeitgeistRemoteStorageMonitorProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_zeitgeist_remote_storage_monitor_dbus_interface_info));
}

static GVariant*
zeitgeist_remote_storage_monitor_proxy_get_storages (ZeitgeistRemoteStorageMonitor* self,
                                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result = NULL;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.StorageMonitor", "GetStorages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result = g_variant_iter_next_value (&_reply_iter);
	g_object_unref (_reply_message);
	return _result;
}

static void
zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface* iface)
{
	iface->get_storages = zeitgeist_remote_storage_monitor_proxy_get_storages;
}

static void
_dbus_zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = zeitgeist_remote_storage_monitor_get_storages (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
zeitgeist_remote_storage_monitor_dbus_interface_method_call (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* method_name,
                                                             GVariant* parameters,
                                                             GDBusMethodInvocation* invocation,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetStorages") == 0) {
		_dbus_zeitgeist_remote_storage_monitor_get_storages (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
zeitgeist_remote_storage_monitor_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
zeitgeist_remote_storage_monitor_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_zeitgeist_remote_storage_monitor_storage_available (GObject* _sender,
                                                          const gchar* storage_id,
                                                          GVariant* storage_description,
                                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (storage_id));
	g_variant_builder_add_value (&_arguments_builder, storage_description);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.StorageMonitor", "StorageAvailable", _arguments, NULL);
}

static void
_dbus_zeitgeist_remote_storage_monitor_storage_unavailable (GObject* _sender,
                                                            const gchar* storage_id,
                                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (storage_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.StorageMonitor", "StorageUnavailable", _arguments, NULL);
}

guint
zeitgeist_remote_storage_monitor_register_object (gpointer object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_storage_monitor_dbus_interface_info), &_zeitgeist_remote_storage_monitor_dbus_interface_vtable, data, _zeitgeist_remote_storage_monitor_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "storage-available", (GCallback) _dbus_zeitgeist_remote_storage_monitor_storage_available, data);
	g_signal_connect (object, "storage-unavailable", (GCallback) _dbus_zeitgeist_remote_storage_monitor_storage_unavailable, data);
	return result;
}

static void
_zeitgeist_remote_storage_monitor_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_storage_monitor_storage_available, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_storage_monitor_storage_unavailable, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
zeitgeist_network_monitor_setup (ZeitgeistNetworkMonitor* self)
{
	ZeitgeistNetworkMonitorIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ZEITGEIST_NETWORK_MONITOR_GET_INTERFACE (self);
	if (_iface_->setup) {
		_iface_->setup (self);
	}
}

static void
zeitgeist_network_monitor_default_init (ZeitgeistNetworkMonitorIface * iface,
                                        gpointer iface_data)
{
	zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL] = g_signal_new ("on-network-up", ZEITGEIST_TYPE_NETWORK_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL] = g_signal_new ("on-network-down", ZEITGEIST_TYPE_NETWORK_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
zeitgeist_network_monitor_get_type (void)
{
	return zeitgeist_network_monitor_type_id;
}

GType
zeitgeist_network_monitor_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistNetworkMonitorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_network_monitor_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_network_monitor_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistNetworkMonitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_network_monitor_type_id, G_TYPE_OBJECT);
	return zeitgeist_network_monitor_type_id;
}

GVariant*
zeitgeist_storage_media_to_variant (const gchar* medium_name,
                                    gboolean available,
                                    const gchar* icon,
                                    const gchar* display_name)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariant* _tmp18_;
	GVariant* result;
	g_return_val_if_fail (medium_name != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	g_variant_builder_add (vb, "s", medium_name, NULL);
	_tmp4_ = g_variant_type_new ("a{sv}");
	_tmp5_ = _tmp4_;
	g_variant_builder_open (vb, _tmp5_);
	_g_variant_type_free0 (_tmp5_);
	{
		GVariantType* _tmp6_;
		GVariantType* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariantType* _tmp10_;
		GVariantType* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		GVariantType* _tmp14_;
		GVariantType* _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		_tmp6_ = g_variant_type_new ("{sv}");
		_tmp7_ = _tmp6_;
		g_variant_builder_open (vb, _tmp7_);
		_g_variant_type_free0 (_tmp7_);
		g_variant_builder_add (vb, "s", "available", NULL);
		_tmp8_ = g_variant_new ("b", available, NULL);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_variant_builder_add (vb, "v", _tmp9_, NULL);
		_g_variant_unref0 (_tmp9_);
		g_variant_builder_close (vb);
		_tmp10_ = g_variant_type_new ("{sv}");
		_tmp11_ = _tmp10_;
		g_variant_builder_open (vb, _tmp11_);
		_g_variant_type_free0 (_tmp11_);
		g_variant_builder_add (vb, "s", "icon", NULL);
		_tmp12_ = g_variant_new ("s", icon, NULL);
		g_variant_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		g_variant_builder_add (vb, "v", _tmp13_, NULL);
		_g_variant_unref0 (_tmp13_);
		g_variant_builder_close (vb);
		_tmp14_ = g_variant_type_new ("{sv}");
		_tmp15_ = _tmp14_;
		g_variant_builder_open (vb, _tmp15_);
		_g_variant_type_free0 (_tmp15_);
		g_variant_builder_add (vb, "s", "display-name", NULL);
		_tmp16_ = g_variant_new ("s", display_name, NULL);
		g_variant_ref_sink (_tmp16_);
		_tmp17_ = _tmp16_;
		g_variant_builder_add (vb, "v", _tmp17_, NULL);
		_g_variant_unref0 (_tmp17_);
		g_variant_builder_close (vb);
	}
	g_variant_builder_close (vb);
	_tmp18_ = g_variant_builder_end (vb);
	g_variant_ref_sink (_tmp18_);
	result = _tmp18_;
	_g_variant_builder_unref0 (vb);
	return result;
}

static inline gpointer
zeitgeist_storage_monitor_get_instance_private (ZeitgeistStorageMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistStorageMonitor_private_offset);
}

static ZeitgeistStorageMonitor*
zeitgeist_storage_monitor_construct (GType object_type)
{
	ZeitgeistStorageMonitor * self = NULL;
	self = (ZeitgeistStorageMonitor*) g_object_new (object_type, NULL);
	return self;
}

static ZeitgeistStorageMonitor*
zeitgeist_storage_monitor_new (void)
{
	return zeitgeist_storage_monitor_construct (ZEITGEIST_TYPE_STORAGE_MONITOR);
}

static void
__lambda4_ (ZeitgeistStorageMonitor* self)
{
	zeitgeist_storage_monitor_add_storage_medium (self, "net", "stock_internet", "Internet");
}

static void
___lambda4__zeitgeist_network_monitor_on_network_up (ZeitgeistNetworkMonitor* _sender,
                                                     gpointer self)
{
	__lambda4_ ((ZeitgeistStorageMonitor*) self);
}

static void
__lambda5_ (ZeitgeistStorageMonitor* self)
{
	zeitgeist_storage_monitor_remove_storage_medium (self, "net");
}

static void
___lambda5__zeitgeist_network_monitor_on_network_down (ZeitgeistNetworkMonitor* _sender,
                                                       gpointer self)
{
	__lambda5_ ((ZeitgeistStorageMonitor*) self);
}

static void
zeitgeist_storage_monitor_name_appeared_handler (ZeitgeistStorageMonitor* self,
                                                 GDBusConnection* connection,
                                                 const gchar* name,
                                                 const gchar* name_owner)
{
	ZeitgeistNetworkMonitor* _tmp0_;
	ZeitgeistNetworkMonitor* _tmp3_;
	ZeitgeistNetworkMonitor* _tmp4_;
	ZeitgeistNetworkMonitor* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	_tmp0_ = self->priv->network;
	if (_tmp0_ != NULL) {
		return;
	}
	if (g_strcmp0 (name, "net.connman") == 0) {
		ZeitgeistConnmanNetworkMonitor* _tmp1_;
		_tmp1_ = zeitgeist_connman_network_monitor_new ();
		_g_object_unref0 (self->priv->network);
		self->priv->network = (ZeitgeistNetworkMonitor*) _tmp1_;
	} else {
		if (g_strcmp0 (name, "org.freedesktop.NetworkManager") == 0) {
			ZeitgeistNMNetworkMonitor* _tmp2_;
			_tmp2_ = zeitgeist_nm_network_monitor_new ();
			_g_object_unref0 (self->priv->network);
			self->priv->network = (ZeitgeistNetworkMonitor*) _tmp2_;
		}
	}
	_tmp3_ = self->priv->network;
	g_signal_connect_object (_tmp3_, "on-network-up", (GCallback) ___lambda4__zeitgeist_network_monitor_on_network_up, self, 0);
	_tmp4_ = self->priv->network;
	g_signal_connect_object (_tmp4_, "on-network-down", (GCallback) ___lambda5__zeitgeist_network_monitor_on_network_down, self, 0);
	_tmp5_ = self->priv->network;
	zeitgeist_network_monitor_setup (_tmp5_);
	g_bus_unwatch_name (self->priv->watch_connman);
	g_bus_unwatch_name (self->priv->watch_nm);
}

static void
zeitgeist_storage_monitor_real_unload (ZeitgeistExtension* base)
{
	ZeitgeistStorageMonitor * self;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistStorageMonitor*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (self->priv->registration_id != ((guint) 0)) {
			g_dbus_connection_unregister_object (connection, self->priv->registration_id);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("ext-storage-monitor.vala:217: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("ext-storage-monitor.vala:220: %s, this.ref_count = %u", "Zeitgeist.StorageMonitor.unload", ((GObject*) self)->ref_count);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
zeitgeist_storage_monitor_prepare_queries (ZeitgeistStorageMonitor* self,
                                           GError** error)
{
	ZeitgeistEngine* _tmp0_;
	ZeitgeistEngine* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistSQLiteDatabase* _tmp5_;
	sqlite3* _tmp6_;
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp7_;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	ZeitgeistSQLiteDatabase* _tmp12_;
	gchar* _tmp13_;
	sqlite3* _tmp14_;
	const gchar* _tmp15_;
	sqlite3_stmt* _tmp16_ = NULL;
	gint _tmp17_;
	ZeitgeistSQLiteDatabase* _tmp18_;
	gchar* _tmp19_;
	sqlite3* _tmp20_;
	const gchar* _tmp21_;
	sqlite3_stmt* _tmp22_ = NULL;
	gint _tmp23_;
	ZeitgeistSQLiteDatabase* _tmp24_;
	gchar* _tmp25_;
	sqlite3* _tmp26_;
	const gchar* _tmp27_;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_;
	ZeitgeistSQLiteDatabase* _tmp30_;
	gchar* _tmp31_;
	sqlite3* _tmp32_;
	const gchar* _tmp33_;
	sqlite3_stmt* _tmp34_ = NULL;
	gint _tmp35_;
	ZeitgeistSQLiteDatabase* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = zeitgeist_extension_get_engine ((ZeitgeistExtension*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp4_;
	_tmp5_ = self->priv->database;
	_tmp6_ = _tmp5_->database;
	self->priv->db = _tmp6_;
	_tmp7_ = g_strdup ("\n" \
"                SELECT value, state, icon, display_name\n" \
"                FROM storage\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp7_;
	_tmp8_ = self->priv->db;
	_tmp9_ = sql;
	_tmp11_ = sqlite3_prepare_v2 (_tmp8_, _tmp9_, -1, &_tmp10_, NULL);
	_sqlite3_finalize0 (self->priv->get_storages_stmt);
	self->priv->get_storages_stmt = _tmp10_;
	rc = _tmp11_;
	_tmp12_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp12_, rc, "ext-storage-monitor.vala:237: Storage retrieval query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp13_ = g_strdup ("\n" \
"                INSERT INTO storage (\n" \
"                    value, state, icon, display_name\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp13_;
	_tmp14_ = self->priv->db;
	_tmp15_ = sql;
	_tmp17_ = sqlite3_prepare_v2 (_tmp14_, _tmp15_, -1, &_tmp16_, NULL);
	_sqlite3_finalize0 (self->priv->store_storage_medium_stmt);
	self->priv->store_storage_medium_stmt = _tmp16_;
	rc = _tmp17_;
	_tmp18_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp18_, rc, "ext-storage-monitor.vala:246: Storage insertion query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp19_ = g_strdup ("\n" \
"                UPDATE storage SET \n" \
"                state=?, icon=?, display_name=? \n" \
"                WHERE value=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp19_;
	_tmp20_ = self->priv->db;
	_tmp21_ = sql;
	_tmp23_ = sqlite3_prepare_v2 (_tmp20_, _tmp21_, -1, &_tmp22_, NULL);
	_sqlite3_finalize0 (self->priv->update_storage_medium_stmt);
	self->priv->update_storage_medium_stmt = _tmp22_;
	rc = _tmp23_;
	_tmp24_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp24_, rc, "ext-storage-monitor.vala:254: Storage update query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp25_ = g_strdup ("\n" \
"                INSERT INTO storage (\n" \
"                    state, value\n" \
"                ) VALUES (\n" \
"                    ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp25_;
	_tmp26_ = self->priv->db;
	_tmp27_ = sql;
	_tmp29_ = sqlite3_prepare_v2 (_tmp26_, _tmp27_, -1, &_tmp28_, NULL);
	_sqlite3_finalize0 (self->priv->insert_unavailable_medium_stmt);
	self->priv->insert_unavailable_medium_stmt = _tmp28_;
	rc = _tmp29_;
	_tmp30_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp30_, rc, "ext-storage-monitor.vala:263: insert_unavailable_medium_stmt error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp31_ = g_strdup ("\n" \
"                UPDATE storage\n" \
"                SET state=?\n" \
"                WHERE value=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp31_;
	_tmp32_ = self->priv->db;
	_tmp33_ = sql;
	_tmp35_ = sqlite3_prepare_v2 (_tmp32_, _tmp33_, -1, &_tmp34_, NULL);
	_sqlite3_finalize0 (self->priv->update_medium_state_stmt);
	self->priv->update_medium_state_stmt = _tmp34_;
	rc = _tmp35_;
	_tmp36_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp36_, rc, "ext-storage-monitor.vala:272: update_medium_state_stmt error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (sql);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
zeitgeist_storage_monitor_real_pre_insert_events (ZeitgeistExtension* base,
                                                  GPtrArray* events,
                                                  const char* sender)
{
	ZeitgeistStorageMonitor * self;
	self = (ZeitgeistStorageMonitor*) base;
	g_return_if_fail (events != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gconstpointer _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				_tmp2_ = vala_g_ptr_array_get_length (events);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (events, (guint) i);
				if (((ZeitgeistEvent*) _tmp4_) == NULL) {
					continue;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gconstpointer _tmp7_;
							GPtrArray* _tmp8_;
							GPtrArray* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							ZeitgeistSubject* subject = NULL;
							gconstpointer _tmp12_;
							GPtrArray* _tmp13_;
							GPtrArray* _tmp14_;
							gconstpointer _tmp15_;
							ZeitgeistSubject* _tmp16_;
							ZeitgeistSubject* _tmp17_;
							const gchar* _tmp18_;
							const gchar* _tmp19_;
							if (!_tmp5_) {
								gint _tmp6_;
								j = j + 1;
								_tmp6_ = j;
							}
							_tmp5_ = FALSE;
							_tmp7_ = g_ptr_array_index (events, (guint) i);
							_tmp8_ = zeitgeist_event_get_subjects ((ZeitgeistEvent*) _tmp7_);
							_tmp9_ = _tmp8_;
							_tmp10_ = vala_g_ptr_array_get_length (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(j < _tmp11_)) {
								break;
							}
							_tmp12_ = g_ptr_array_index (events, (guint) i);
							_tmp13_ = zeitgeist_event_get_subjects ((ZeitgeistEvent*) _tmp12_);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_ptr_array_index (_tmp14_, (guint) j);
							_tmp16_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp15_);
							subject = _tmp16_;
							_tmp17_ = subject;
							_tmp18_ = zeitgeist_subject_get_storage (_tmp17_);
							_tmp19_ = _tmp18_;
							if (zeitgeist_utils_is_empty_string (_tmp19_)) {
								ZeitgeistSubject* _tmp20_;
								ZeitgeistSubject* _tmp21_;
								const gchar* _tmp22_;
								const gchar* _tmp23_;
								gchar* _tmp24_;
								gchar* _tmp25_;
								_tmp20_ = subject;
								_tmp21_ = subject;
								_tmp22_ = zeitgeist_subject_get_uri (_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp24_ = zeitgeist_storage_monitor_find_storage_for_uri (self, _tmp23_);
								_tmp25_ = _tmp24_;
								zeitgeist_subject_set_storage (_tmp20_, _tmp25_);
								_g_free0 (_tmp25_);
							}
							_g_object_unref0 (subject);
						}
					}
				}
			}
		}
	}
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gchar*
zeitgeist_storage_monitor_find_storage_for_uri (ZeitgeistStorageMonitor* self,
                                                const gchar* uri)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* uri_scheme = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_get_uri_scheme (_tmp1_);
	uri_scheme = _tmp2_;
	_tmp3_ = uri_scheme;
	if (_vala_string_array_contains (ZEITGEIST_STORAGE_MONITOR_network_uri_schemes, G_N_ELEMENTS (ZEITGEIST_STORAGE_MONITOR_network_uri_schemes), _tmp3_)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("net");
		result = _tmp4_;
		_g_free0 (uri_scheme);
		_g_object_unref0 (file);
		return result;
	}
	_tmp5_ = g_strdup ("unknown");
	result = _tmp5_;
	_g_free0 (uri_scheme);
	_g_object_unref0 (file);
	return result;
}

void
zeitgeist_storage_monitor_add_storage_medium (ZeitgeistStorageMonitor* self,
                                              const gchar* medium_name,
                                              const gchar* icon,
                                              const gchar* display_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp7_;
	gchar* _tmp8_;
	GDestroyNotify _tmp9_;
	sqlite3_stmt* _tmp10_;
	gchar* _tmp11_;
	GDestroyNotify _tmp12_;
	sqlite3_stmt* _tmp13_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (medium_name != NULL);
	g_return_if_fail (icon != NULL);
	g_return_if_fail (display_name != NULL);
	_tmp0_ = g_strdup_printf ("VOLUME ADDED: %s", medium_name);
	_tmp1_ = _tmp0_;
	g_debug ("ext-storage-monitor.vala:370: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->store_storage_medium_stmt;
	sqlite3_reset (_tmp2_);
	_tmp3_ = self->priv->store_storage_medium_stmt;
	_tmp4_ = g_strdup (medium_name);
	_tmp5_ = g_free;
	sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_tmp6_ = self->priv->store_storage_medium_stmt;
	sqlite3_bind_int (_tmp6_, 2, 1);
	_tmp7_ = self->priv->store_storage_medium_stmt;
	_tmp8_ = g_strdup (icon);
	_tmp9_ = g_free;
	sqlite3_bind_text (_tmp7_, 3, _tmp8_, -1, _tmp9_);
	_tmp10_ = self->priv->store_storage_medium_stmt;
	_tmp11_ = g_strdup (display_name);
	_tmp12_ = g_free;
	sqlite3_bind_text (_tmp10_, 4, _tmp11_, -1, _tmp12_);
	_tmp13_ = self->priv->store_storage_medium_stmt;
	if (sqlite3_step (_tmp13_) != SQLITE_DONE) {
		sqlite3_stmt* _tmp14_;
		sqlite3_stmt* _tmp15_;
		sqlite3_stmt* _tmp16_;
		gchar* _tmp17_;
		GDestroyNotify _tmp18_;
		sqlite3_stmt* _tmp19_;
		gchar* _tmp20_;
		GDestroyNotify _tmp21_;
		sqlite3_stmt* _tmp22_;
		gchar* _tmp23_;
		GDestroyNotify _tmp24_;
		gint rc = 0;
		sqlite3_stmt* _tmp25_;
		_tmp14_ = self->priv->update_storage_medium_stmt;
		sqlite3_reset (_tmp14_);
		_tmp15_ = self->priv->update_storage_medium_stmt;
		sqlite3_bind_int (_tmp15_, 1, 1);
		_tmp16_ = self->priv->update_storage_medium_stmt;
		_tmp17_ = g_strdup (icon);
		_tmp18_ = g_free;
		sqlite3_bind_text (_tmp16_, 2, _tmp17_, -1, _tmp18_);
		_tmp19_ = self->priv->update_storage_medium_stmt;
		_tmp20_ = g_strdup (display_name);
		_tmp21_ = g_free;
		sqlite3_bind_text (_tmp19_, 3, _tmp20_, -1, _tmp21_);
		_tmp22_ = self->priv->update_storage_medium_stmt;
		_tmp23_ = g_strdup (medium_name);
		_tmp24_ = g_free;
		sqlite3_bind_text (_tmp22_, 4, _tmp23_, -1, _tmp24_);
		_tmp25_ = self->priv->update_storage_medium_stmt;
		rc = sqlite3_step (_tmp25_);
		{
			ZeitgeistSQLiteDatabase* _tmp26_;
			_tmp26_ = self->priv->database;
			zeitgeist_sq_lite_database_assert_query_success (_tmp26_, rc, "add_storage_medium", SQLITE_DONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch0_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_zeitgeist_engine_error:
		{
			GError* e = NULL;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			g_warning ("ext-storage-monitor.vala:390: Could not add storage medium: %s", _tmp28_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp29_ = zeitgeist_storage_media_to_variant (medium_name, TRUE, icon, display_name);
	_tmp30_ = _tmp29_;
	g_signal_emit ((ZeitgeistRemoteStorageMonitor*) self, zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_AVAILABLE_SIGNAL], 0, medium_name, _tmp30_);
	_g_variant_unref0 (_tmp30_);
}

void
zeitgeist_storage_monitor_remove_storage_medium (ZeitgeistStorageMonitor* self,
                                                 const gchar* medium_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (medium_name != NULL);
	_tmp0_ = g_strdup_printf ("VOLUME REMOVED: %s", medium_name);
	_tmp1_ = _tmp0_;
	g_debug ("ext-storage-monitor.vala:399: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->insert_unavailable_medium_stmt;
	sqlite3_reset (_tmp2_);
	_tmp3_ = self->priv->insert_unavailable_medium_stmt;
	sqlite3_bind_int (_tmp3_, 1, 0);
	_tmp4_ = self->priv->insert_unavailable_medium_stmt;
	_tmp5_ = g_strdup (medium_name);
	_tmp6_ = g_free;
	sqlite3_bind_text (_tmp4_, 2, _tmp5_, -1, _tmp6_);
	_tmp7_ = self->priv->insert_unavailable_medium_stmt;
	if (sqlite3_step (_tmp7_) != SQLITE_DONE) {
		sqlite3_stmt* _tmp8_;
		sqlite3_stmt* _tmp9_;
		sqlite3_stmt* _tmp10_;
		gchar* _tmp11_;
		GDestroyNotify _tmp12_;
		gint rc = 0;
		sqlite3_stmt* _tmp13_;
		_tmp8_ = self->priv->update_medium_state_stmt;
		sqlite3_reset (_tmp8_);
		_tmp9_ = self->priv->update_medium_state_stmt;
		sqlite3_bind_int (_tmp9_, 1, 0);
		_tmp10_ = self->priv->update_medium_state_stmt;
		_tmp11_ = g_strdup (medium_name);
		_tmp12_ = g_free;
		sqlite3_bind_text (_tmp10_, 2, _tmp11_, -1, _tmp12_);
		_tmp13_ = self->priv->update_medium_state_stmt;
		rc = sqlite3_step (_tmp13_);
		{
			ZeitgeistSQLiteDatabase* _tmp14_;
			_tmp14_ = self->priv->database;
			zeitgeist_sq_lite_database_assert_query_success (_tmp14_, rc, "remove_storage_medium", SQLITE_DONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch0_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_zeitgeist_engine_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("ext-storage-monitor.vala:416: Could not remove storage medium: %s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit ((ZeitgeistRemoteStorageMonitor*) self, zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_UNAVAILABLE_SIGNAL], 0, medium_name);
}

static GVariant*
zeitgeist_storage_monitor_real_get_storages (ZeitgeistRemoteStorageMonitor* base,
                                             GError** error)
{
	ZeitgeistStorageMonitor * self;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	gint rc = 0;
	sqlite3_stmt* _tmp4_;
	ZeitgeistSQLiteDatabase* _tmp18_;
	GVariantBuilder* _tmp19_;
	GVariant* _tmp20_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
	self = (ZeitgeistStorageMonitor*) base;
	_tmp0_ = g_variant_type_new ("a(sa{sv})");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = self->priv->get_storages_stmt;
	sqlite3_reset (_tmp4_);
	while (TRUE) {
		sqlite3_stmt* _tmp5_;
		const gchar* _tmp6_ = NULL;
		sqlite3_stmt* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		sqlite3_stmt* _tmp10_;
		const gchar* _tmp11_;
		GVariant* medium = NULL;
		sqlite3_stmt* _tmp12_;
		const gchar* _tmp13_;
		sqlite3_stmt* _tmp14_;
		GVariant* _tmp15_;
		GVariantBuilder* _tmp16_;
		GVariant* _tmp17_;
		_tmp5_ = self->priv->get_storages_stmt;
		rc = sqlite3_step (_tmp5_);
		if (!(rc == SQLITE_ROW)) {
			break;
		}
		_tmp7_ = self->priv->get_storages_stmt;
		_tmp8_ = (const gchar*) sqlite3_column_text (_tmp7_, 2);
		_tmp6_ = _tmp8_;
		if (_tmp6_ == NULL) {
			_tmp6_ = "";
		}
		_tmp10_ = self->priv->get_storages_stmt;
		_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 3);
		_tmp9_ = _tmp11_;
		if (_tmp9_ == NULL) {
			_tmp9_ = "";
		}
		_tmp12_ = self->priv->get_storages_stmt;
		_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 0);
		_tmp14_ = self->priv->get_storages_stmt;
		_tmp15_ = zeitgeist_storage_media_to_variant (_tmp13_, sqlite3_column_int (_tmp14_, 1) == 1, _tmp6_, _tmp9_);
		medium = _tmp15_;
		_tmp16_ = vb;
		_tmp17_ = medium;
		g_variant_builder_add_value (_tmp16_, _tmp17_);
		_g_variant_unref0 (medium);
	}
	_tmp18_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp18_, rc, "get_storages", SQLITE_DONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_variant_builder_unref0 (vb);
			return NULL;
		} else {
			_g_variant_builder_unref0 (vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp19_ = vb;
	_tmp20_ = g_variant_builder_end (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	result = _tmp20_;
	_g_variant_builder_unref0 (vb);
	return result;
}

static void
_zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                              const gchar* name,
                                                                              const gchar* name_owner,
                                                                              gpointer self)
{
	zeitgeist_storage_monitor_name_appeared_handler ((ZeitgeistStorageMonitor*) self, connection, name, name_owner);
}

static GObject *
zeitgeist_storage_monitor_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistStorageMonitor * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_storage_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor);
	{
		zeitgeist_storage_monitor_prepare_queries (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("ext-storage-monitor.vala:136: Storage Monitor couldn't communicate wit" \
"h DB - bye");
		return obj;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		guint _tmp1_ = 0U;
		GDBusConnection* _tmp2_;
		guint _tmp3_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp2_ = connection;
		_tmp3_ = zeitgeist_remote_storage_monitor_register_object ((ZeitgeistRemoteStorageMonitor*) self, _tmp2_, "/org/gnome/zeitgeist/storagemonitor", &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch1_g_error;
		}
		self->priv->registration_id = _tmp1_;
		_g_object_unref0 (connection);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("ext-storage-monitor.vala:149: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	self->priv->watch_connman = g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, "net.connman", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	self->priv->watch_nm = g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, "org.freedesktop.NetworkManager", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
zeitgeist_storage_monitor_class_init (ZeitgeistStorageMonitorClass * klass,
                                      gpointer klass_data)
{
	zeitgeist_storage_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistStorageMonitor_private_offset);
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension*)) zeitgeist_storage_monitor_real_unload;
	((ZeitgeistExtensionClass *) klass)->pre_insert_events = (void (*) (ZeitgeistExtension*, GPtrArray*, const char*)) zeitgeist_storage_monitor_real_pre_insert_events;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_storage_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_storage_monitor_finalize;
}

static void
zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface * iface,
                                                                           gpointer iface_data)
{
	zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_storages = (GVariant* (*) (ZeitgeistRemoteStorageMonitor*, GError**)) zeitgeist_storage_monitor_real_get_storages;
}

static void
zeitgeist_storage_monitor_instance_init (ZeitgeistStorageMonitor * self,
                                         gpointer klass)
{
	self->priv = zeitgeist_storage_monitor_get_instance_private (self);
}

static void
zeitgeist_storage_monitor_finalize (GObject * obj)
{
	ZeitgeistStorageMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor);
	_g_object_unref0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->get_storages_stmt);
	_sqlite3_finalize0 (self->priv->store_storage_medium_stmt);
	_sqlite3_finalize0 (self->priv->update_storage_medium_stmt);
	_sqlite3_finalize0 (self->priv->insert_unavailable_medium_stmt);
	_sqlite3_finalize0 (self->priv->update_medium_state_stmt);
	_g_object_unref0 (self->priv->network);
	G_OBJECT_CLASS (zeitgeist_storage_monitor_parent_class)->finalize (obj);
}

GType
zeitgeist_storage_monitor_get_type (void)
{
	return zeitgeist_storage_monitor_type_id;
}

GType
zeitgeist_storage_monitor_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistStorageMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_storage_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistStorageMonitor), 0, (GInstanceInitFunc) zeitgeist_storage_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_storage_monitor_info = { (GInterfaceInitFunc) zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_storage_monitor_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistStorageMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_storage_monitor_type_id, ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, &zeitgeist_remote_storage_monitor_info);
	ZeitgeistStorageMonitor_private_offset = sizeof (ZeitgeistStorageMonitorPrivate);
	return zeitgeist_storage_monitor_type_id;
}

static inline gpointer
zeitgeist_nm_network_monitor_get_instance_private (ZeitgeistNMNetworkMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistNMNetworkMonitor_private_offset);
}

ZeitgeistNMNetworkMonitor*
zeitgeist_nm_network_monitor_construct (GType object_type)
{
	ZeitgeistNMNetworkMonitor * self = NULL;
	self = (ZeitgeistNMNetworkMonitor*) g_object_new (object_type, NULL);
	return self;
}

ZeitgeistNMNetworkMonitor*
zeitgeist_nm_network_monitor_new (void)
{
	return zeitgeist_nm_network_monitor_construct (ZEITGEIST_TYPE_NM_NETWORK_MONITOR);
}

static void
_zeitgeist_nm_network_monitor_on_state_changed_zeitgeist_network_manager_dbus_state_changed (ZeitgeistNetworkManagerDBus* _sender,
                                                                                             guint32 state,
                                                                                             gpointer self)
{
	zeitgeist_nm_network_monitor_on_state_changed ((ZeitgeistNMNetworkMonitor*) self, state);
}

static void
zeitgeist_nm_network_monitor_real_setup (ZeitgeistNetworkMonitor* base)
{
	ZeitgeistNMNetworkMonitor * self;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistNMNetworkMonitor*) base;
	g_debug ("ext-storage-monitor.vala:469: Creating NetworkManager network monitor");
	{
		ZeitgeistNetworkManagerDBus* _tmp0_ = NULL;
		ZeitgeistNetworkManagerDBus* _tmp1_;
		ZeitgeistNetworkManagerDBus* _tmp2_;
		ZeitgeistNetworkManagerDBus* _tmp3_;
		guint32 state = 0U;
		ZeitgeistNetworkManagerDBus* _tmp4_;
		_tmp1_ = (ZeitgeistNetworkManagerDBus*) g_initable_new (ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", ZEITGEIST_NM_NETWORK_MONITOR_NM_BUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", ZEITGEIST_NM_NETWORK_MONITOR_NM_OBJECT_PATH, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
		_tmp0_ = (ZeitgeistNetworkManagerDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp2_;
		_tmp3_ = self->priv->proxy;
		g_signal_connect_object (_tmp3_, "state-changed", (GCallback) _zeitgeist_nm_network_monitor_on_state_changed_zeitgeist_network_manager_dbus_state_changed, self, 0);
		_tmp4_ = self->priv->proxy;
		state = zeitgeist_network_manager_dbus_state (_tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
		zeitgeist_nm_network_monitor_on_state_changed (self, state);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("ext-storage-monitor.vala:482: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
zeitgeist_nm_network_monitor_on_state_changed (ZeitgeistNMNetworkMonitor* self,
                                               guint32 state)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("ext-storage-monitor.vala:488: NetworkManager network state: %u", (guint) state);
	if (state == ((guint32) ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_PRE_09)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = state == ((guint32) ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_POST_09);
	}
	if (_tmp0_) {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL], 0);
	} else {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL], 0);
	}
}

static void
zeitgeist_nm_network_monitor_class_init (ZeitgeistNMNetworkMonitorClass * klass,
                                         gpointer klass_data)
{
	zeitgeist_nm_network_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistNMNetworkMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_nm_network_monitor_finalize;
}

static void
zeitgeist_nm_network_monitor_zeitgeist_network_monitor_interface_init (ZeitgeistNetworkMonitorIface * iface,
                                                                       gpointer iface_data)
{
	zeitgeist_nm_network_monitor_zeitgeist_network_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->setup = (void (*) (ZeitgeistNetworkMonitor*)) zeitgeist_nm_network_monitor_real_setup;
}

static void
zeitgeist_nm_network_monitor_instance_init (ZeitgeistNMNetworkMonitor * self,
                                            gpointer klass)
{
	self->priv = zeitgeist_nm_network_monitor_get_instance_private (self);
}

static void
zeitgeist_nm_network_monitor_finalize (GObject * obj)
{
	ZeitgeistNMNetworkMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitor);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (zeitgeist_nm_network_monitor_parent_class)->finalize (obj);
}

GType
zeitgeist_nm_network_monitor_get_type (void)
{
	return zeitgeist_nm_network_monitor_type_id;
}

GType
zeitgeist_nm_network_monitor_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistNMNetworkMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_nm_network_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistNMNetworkMonitor), 0, (GInstanceInitFunc) zeitgeist_nm_network_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_network_monitor_info = { (GInterfaceInitFunc) zeitgeist_nm_network_monitor_zeitgeist_network_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_nm_network_monitor_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ZeitgeistNMNetworkMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_nm_network_monitor_type_id, ZEITGEIST_TYPE_NETWORK_MONITOR, &zeitgeist_network_monitor_info);
	ZeitgeistNMNetworkMonitor_private_offset = sizeof (ZeitgeistNMNetworkMonitorPrivate);
	return zeitgeist_nm_network_monitor_type_id;
}

static inline gpointer
zeitgeist_connman_network_monitor_get_instance_private (ZeitgeistConnmanNetworkMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistConnmanNetworkMonitor_private_offset);
}

ZeitgeistConnmanNetworkMonitor*
zeitgeist_connman_network_monitor_construct (GType object_type)
{
	ZeitgeistConnmanNetworkMonitor * self = NULL;
	self = (ZeitgeistConnmanNetworkMonitor*) g_object_new (object_type, NULL);
	return self;
}

ZeitgeistConnmanNetworkMonitor*
zeitgeist_connman_network_monitor_new (void)
{
	return zeitgeist_connman_network_monitor_construct (ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR);
}

static void
_zeitgeist_connman_network_monitor_on_state_changed_zeitgeist_connman_manager_dbus_state_changed (ZeitgeistConnmanManagerDBus* _sender,
                                                                                                  const gchar* state,
                                                                                                  gpointer self)
{
	zeitgeist_connman_network_monitor_on_state_changed ((ZeitgeistConnmanNetworkMonitor*) self, state);
}

static void
zeitgeist_connman_network_monitor_real_setup (ZeitgeistNetworkMonitor* base)
{
	ZeitgeistConnmanNetworkMonitor * self;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistConnmanNetworkMonitor*) base;
	g_debug ("ext-storage-monitor.vala:512: Creating ConnmanNetworkManager network m" \
"onitor");
	{
		ZeitgeistConnmanManagerDBus* _tmp0_ = NULL;
		ZeitgeistConnmanManagerDBus* _tmp1_;
		ZeitgeistConnmanManagerDBus* _tmp2_;
		ZeitgeistConnmanManagerDBus* _tmp3_;
		gchar* state = NULL;
		ZeitgeistConnmanManagerDBus* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = (ZeitgeistConnmanManagerDBus*) g_initable_new (ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_BUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_OBJECT_PATH, "g-interface-name", "net.connman.Manager", NULL);
		_tmp0_ = (ZeitgeistConnmanManagerDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp2_;
		_tmp3_ = self->priv->proxy;
		g_signal_connect_object (_tmp3_, "state-changed", (GCallback) _zeitgeist_connman_network_monitor_on_state_changed_zeitgeist_connman_manager_dbus_state_changed, self, 0);
		_tmp4_ = self->priv->proxy;
		_tmp5_ = zeitgeist_connman_manager_dbus_get_state (_tmp4_, &_inner_error0_);
		state = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
		_tmp6_ = state;
		zeitgeist_connman_network_monitor_on_state_changed (self, _tmp6_);
		_g_free0 (state);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ext-storage-monitor.vala:530: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
zeitgeist_connman_network_monitor_on_state_changed (ZeitgeistConnmanNetworkMonitor* self,
                                                    const gchar* state)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_debug ("ext-storage-monitor.vala:536: ConnmanNetworkMonitor network state: %s", state);
	if (g_strcmp0 (state, "online") == 0) {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL], 0);
	} else {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL], 0);
	}
}

static void
zeitgeist_connman_network_monitor_class_init (ZeitgeistConnmanNetworkMonitorClass * klass,
                                              gpointer klass_data)
{
	zeitgeist_connman_network_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistConnmanNetworkMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_connman_network_monitor_finalize;
}

static void
zeitgeist_connman_network_monitor_zeitgeist_network_monitor_interface_init (ZeitgeistNetworkMonitorIface * iface,
                                                                            gpointer iface_data)
{
	zeitgeist_connman_network_monitor_zeitgeist_network_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->setup = (void (*) (ZeitgeistNetworkMonitor*)) zeitgeist_connman_network_monitor_real_setup;
}

static void
zeitgeist_connman_network_monitor_instance_init (ZeitgeistConnmanNetworkMonitor * self,
                                                 gpointer klass)
{
	self->priv = zeitgeist_connman_network_monitor_get_instance_private (self);
}

static void
zeitgeist_connman_network_monitor_finalize (GObject * obj)
{
	ZeitgeistConnmanNetworkMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitor);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (zeitgeist_connman_network_monitor_parent_class)->finalize (obj);
}

GType
zeitgeist_connman_network_monitor_get_type (void)
{
	return zeitgeist_connman_network_monitor_type_id;
}

GType
zeitgeist_connman_network_monitor_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistConnmanNetworkMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_connman_network_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistConnmanNetworkMonitor), 0, (GInstanceInitFunc) zeitgeist_connman_network_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_network_monitor_info = { (GInterfaceInitFunc) zeitgeist_connman_network_monitor_zeitgeist_network_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_connman_network_monitor_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ZeitgeistConnmanNetworkMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_connman_network_monitor_type_id, ZEITGEIST_TYPE_NETWORK_MONITOR, &zeitgeist_network_monitor_info);
	ZeitgeistConnmanNetworkMonitor_private_offset = sizeof (ZeitgeistConnmanNetworkMonitorPrivate);
	return zeitgeist_connman_network_monitor_type_id;
}

GType
zeitgeist_storage_monitor_init (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_storage_monitor_register_type (module);
	zeitgeist_remote_storage_monitor_proxy_register_dynamic_type (module);
	zeitgeist_storage_monitor_register_type (module);
	zeitgeist_network_monitor_register_type (module);
	zeitgeist_nm_network_monitor_register_type (module);
	zeitgeist_connman_network_monitor_register_type (module);
	result = ZEITGEIST_TYPE_STORAGE_MONITOR;
	return result;
}

