// Copyright IBM Corp. 2016, 2025
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: sdk/plugin/pb/backend.proto

package pb

import (
	logical "github.com/hashicorp/vault/sdk/logical"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Empty struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Empty) Reset() {
	*x = Empty{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{0}
}

type Header struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Header        []string               `protobuf:"bytes,1,rep,name=header,proto3" json:"header,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Header) Reset() {
	*x = Header{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{1}
}

func (x *Header) GetHeader() []string {
	if x != nil {
		return x.Header
	}
	return nil
}

type ProtoError struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Error type can be one of:
	// ErrTypeUnknown uint32 = iota
	// ErrTypeUserError
	// ErrTypeInternalError
	// ErrTypeCodedError
	// ErrTypeStatusBadRequest
	// ErrTypeUnsupportedOperation
	// ErrTypeUnsupportedPath
	// ErrTypeInvalidRequest
	// ErrTypePermissionDenied
	// ErrTypeMultiAuthzPending
	// ErrTypeUnrecoverable
	ErrType       uint32 `protobuf:"varint,1,opt,name=err_type,json=errType,proto3" json:"err_type,omitempty"`
	ErrMsg        string `protobuf:"bytes,2,opt,name=err_msg,json=errMsg,proto3" json:"err_msg,omitempty"`
	ErrCode       int64  `protobuf:"varint,3,opt,name=err_code,json=errCode,proto3" json:"err_code,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProtoError) Reset() {
	*x = ProtoError{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProtoError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProtoError) ProtoMessage() {}

func (x *ProtoError) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProtoError.ProtoReflect.Descriptor instead.
func (*ProtoError) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{2}
}

func (x *ProtoError) GetErrType() uint32 {
	if x != nil {
		return x.ErrType
	}
	return 0
}

func (x *ProtoError) GetErrMsg() string {
	if x != nil {
		return x.ErrMsg
	}
	return ""
}

func (x *ProtoError) GetErrCode() int64 {
	if x != nil {
		return x.ErrCode
	}
	return 0
}

// Paths is the structure of special paths that is used for SpecialPaths.
type Paths struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Root are the paths that require a root token to access
	Root []string `protobuf:"bytes,1,rep,name=root,proto3" json:"root,omitempty"`
	// Unauthenticated are the paths that can be accessed without any auth.
	Unauthenticated []string `protobuf:"bytes,2,rep,name=unauthenticated,proto3" json:"unauthenticated,omitempty"`
	// LocalStorage are paths (prefixes) that are local to this instance; this
	// indicates that these paths should not be replicated
	LocalStorage []string `protobuf:"bytes,3,rep,name=local_storage,json=localStorage,proto3" json:"local_storage,omitempty"`
	// SealWrapStorage are storage paths that, when using a capable seal,
	// should be seal wrapped with extra encryption. It is exact matching
	// unless it ends with '/' in which case it will be treated as a prefix.
	SealWrapStorage []string `protobuf:"bytes,4,rep,name=seal_wrap_storage,json=sealWrapStorage,proto3" json:"seal_wrap_storage,omitempty"`
	// WriteForwardedStorage are storage paths that, when running on a PR
	// Secondary cluster, cause a GRPC call up to the PR Primary cluster's
	// active node to handle storage.Put(...) and storage.Delete(...) events.
	//
	// See extended note in /sdk/logical/logical.go.
	WriteForwardedStorage []string `protobuf:"bytes,5,rep,name=write_forwarded_storage,json=writeForwardedStorage,proto3" json:"write_forwarded_storage,omitempty"`
	// Binary are paths whose request bodies are binary, not JSON
	//
	// See note in /sdk/logical/logical.go.
	Binary []string `protobuf:"bytes,6,rep,name=binary,proto3" json:"binary,omitempty"`
	// Limited paths are storage paths that require special-case request limiting.
	//
	// See note in /sdk/logical/logical.go.
	Limited []string `protobuf:"bytes,7,rep,name=limited,proto3" json:"limited,omitempty"`
	// AllowSnapshotRead paths are allowed to be read from a loaded snapshot
	//
	// See note in /sdk/logical/logical.go
	AllowSnapshotRead []string `protobuf:"bytes,8,rep,name=allow_snapshot_read,json=allowSnapshotRead,proto3" json:"allow_snapshot_read,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Paths) Reset() {
	*x = Paths{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Paths) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Paths) ProtoMessage() {}

func (x *Paths) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Paths.ProtoReflect.Descriptor instead.
func (*Paths) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{3}
}

func (x *Paths) GetRoot() []string {
	if x != nil {
		return x.Root
	}
	return nil
}

func (x *Paths) GetUnauthenticated() []string {
	if x != nil {
		return x.Unauthenticated
	}
	return nil
}

func (x *Paths) GetLocalStorage() []string {
	if x != nil {
		return x.LocalStorage
	}
	return nil
}

func (x *Paths) GetSealWrapStorage() []string {
	if x != nil {
		return x.SealWrapStorage
	}
	return nil
}

func (x *Paths) GetWriteForwardedStorage() []string {
	if x != nil {
		return x.WriteForwardedStorage
	}
	return nil
}

func (x *Paths) GetBinary() []string {
	if x != nil {
		return x.Binary
	}
	return nil
}

func (x *Paths) GetLimited() []string {
	if x != nil {
		return x.Limited
	}
	return nil
}

func (x *Paths) GetAllowSnapshotRead() []string {
	if x != nil {
		return x.AllowSnapshotRead
	}
	return nil
}

type Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID is the uuid associated with each request
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// If set, the name given to the replication secondary where this request
	// originated
	ReplicationCluster string `protobuf:"bytes,2,opt,name=ReplicationCluster,proto3" json:"ReplicationCluster,omitempty"`
	// Operation is the requested operation type
	Operation string `protobuf:"bytes,3,opt,name=operation,proto3" json:"operation,omitempty"`
	// Path is the part of the request path not consumed by the
	// routing. As an example, if the original request path is "prod/aws/foo"
	// and the AWS logical backend is mounted at "prod/aws/", then the
	// final path is "foo" since the mount prefix is trimmed.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// Request data is a JSON object that must have keys with string type.
	Data string `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// Secret will be non-nil only for Revoke and Renew operations
	// to represent the secret that was returned prior.
	Secret *Secret `protobuf:"bytes,6,opt,name=secret,proto3" json:"secret,omitempty"`
	// Auth will be non-nil only for Renew operations
	// to represent the auth that was returned prior.
	Auth *Auth `protobuf:"bytes,7,opt,name=auth,proto3" json:"auth,omitempty"`
	// Headers will contain the http headers from the request. This value will
	// be used in the audit broker to ensure we are auditing only the allowed
	// headers.
	Headers map[string]*Header `protobuf:"bytes,8,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ClientToken is provided to the core so that the identity
	// can be verified and ACLs applied. This value is passed
	// through to the logical backends but after being salted and
	// hashed.
	ClientToken string `protobuf:"bytes,9,opt,name=client_token,json=clientToken,proto3" json:"client_token,omitempty"`
	// ClientTokenAccessor is provided to the core so that the it can get
	// logged as part of request audit logging.
	ClientTokenAccessor string `protobuf:"bytes,10,opt,name=client_token_accessor,json=clientTokenAccessor,proto3" json:"client_token_accessor,omitempty"`
	// DisplayName is provided to the logical backend to help associate
	// dynamic secrets with the source entity. This is not a sensitive
	// name, but is useful for operators.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// MountPoint is provided so that a logical backend can generate
	// paths relative to itself. The `Path` is effectively the client
	// request path with the MountPoint trimmed off.
	MountPoint string `protobuf:"bytes,12,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
	// MountType is provided so that a logical backend can make decisions
	// based on the specific mount type (e.g., if a mount type has different
	// aliases, generating different defaults depending on the alias)
	MountType string `protobuf:"bytes,13,opt,name=mount_type,json=mountType,proto3" json:"mount_type,omitempty"`
	// MountAccessor is provided so that identities returned by the authentication
	// backends can be tied to the mount it belongs to.
	MountAccessor string `protobuf:"bytes,14,opt,name=mount_accessor,json=mountAccessor,proto3" json:"mount_accessor,omitempty"`
	// WrapInfo contains requested response wrapping parameters
	WrapInfo *RequestWrapInfo `protobuf:"bytes,15,opt,name=wrap_info,json=wrapInfo,proto3" json:"wrap_info,omitempty"`
	// ClientTokenRemainingUses represents the allowed number of uses left on the
	// token supplied
	ClientTokenRemainingUses int64 `protobuf:"varint,16,opt,name=client_token_remaining_uses,json=clientTokenRemainingUses,proto3" json:"client_token_remaining_uses,omitempty"`
	// EntityID is the identity of the caller extracted out of the token used
	// to make this request
	EntityID string `protobuf:"bytes,17,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// PolicyOverride indicates that the requestor wishes to override
	// soft-mandatory Sentinel policies
	PolicyOverride bool `protobuf:"varint,18,opt,name=policy_override,json=policyOverride,proto3" json:"policy_override,omitempty"`
	// Whether the request is unauthenticated, as in, had no client token
	// attached. Useful in some situations where the client token is not made
	// accessible.
	Unauthenticated bool `protobuf:"varint,19,opt,name=unauthenticated,proto3" json:"unauthenticated,omitempty"`
	// Connection will be non-nil only for credential providers to
	// inspect the connection information and potentially use it for
	// authentication/protection.
	Connection *Connection `protobuf:"bytes,20,opt,name=connection,proto3" json:"connection,omitempty"`
	// RequiresSnapshotID will be present when the request is a list, read, or
	// recover from snapshot operation
	RequiresSnapshotID string `protobuf:"bytes,21,opt,name=requires_snapshot_id,json=requiresSnapshotId,proto3" json:"requires_snapshot_id,omitempty"`
	// RecoverSourcePath is the path where a recover request should read the data
	// from. This can be empty if the request is not a recover request, or if the
	// request is a recover request where the source path is the same as the
	// destination path
	RecoverSourcePath string `protobuf:"bytes,22,opt,name=recover_source_path,json=recoverSourcePath,proto3" json:"recover_source_path,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Request) Reset() {
	*x = Request{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Request) ProtoMessage() {}

func (x *Request) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Request.ProtoReflect.Descriptor instead.
func (*Request) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{4}
}

func (x *Request) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *Request) GetReplicationCluster() string {
	if x != nil {
		return x.ReplicationCluster
	}
	return ""
}

func (x *Request) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *Request) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Request) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

func (x *Request) GetSecret() *Secret {
	if x != nil {
		return x.Secret
	}
	return nil
}

func (x *Request) GetAuth() *Auth {
	if x != nil {
		return x.Auth
	}
	return nil
}

func (x *Request) GetHeaders() map[string]*Header {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *Request) GetClientToken() string {
	if x != nil {
		return x.ClientToken
	}
	return ""
}

func (x *Request) GetClientTokenAccessor() string {
	if x != nil {
		return x.ClientTokenAccessor
	}
	return ""
}

func (x *Request) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Request) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

func (x *Request) GetMountType() string {
	if x != nil {
		return x.MountType
	}
	return ""
}

func (x *Request) GetMountAccessor() string {
	if x != nil {
		return x.MountAccessor
	}
	return ""
}

func (x *Request) GetWrapInfo() *RequestWrapInfo {
	if x != nil {
		return x.WrapInfo
	}
	return nil
}

func (x *Request) GetClientTokenRemainingUses() int64 {
	if x != nil {
		return x.ClientTokenRemainingUses
	}
	return 0
}

func (x *Request) GetEntityID() string {
	if x != nil {
		return x.EntityID
	}
	return ""
}

func (x *Request) GetPolicyOverride() bool {
	if x != nil {
		return x.PolicyOverride
	}
	return false
}

func (x *Request) GetUnauthenticated() bool {
	if x != nil {
		return x.Unauthenticated
	}
	return false
}

func (x *Request) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *Request) GetRequiresSnapshotID() string {
	if x != nil {
		return x.RequiresSnapshotID
	}
	return ""
}

func (x *Request) GetRecoverSourcePath() string {
	if x != nil {
		return x.RecoverSourcePath
	}
	return ""
}

type Auth struct {
	state        protoimpl.MessageState `protogen:"open.v1"`
	LeaseOptions *LeaseOptions          `protobuf:"bytes,1,opt,name=lease_options,json=leaseOptions,proto3" json:"lease_options,omitempty"`
	// InternalData is a JSON object that is stored with the auth struct.
	// This will be sent back during a Renew/Revoke for storing internal data
	// used for those operations.
	InternalData string `protobuf:"bytes,2,opt,name=internal_data,json=internalData,proto3" json:"internal_data,omitempty"`
	// DisplayName is a non-security sensitive identifier that is
	// applicable to this Auth. It is used for logging and prefixing
	// of dynamic secrets. For example, DisplayName may be "armon" for
	// the github credential backend. If the client token is used to
	// generate a SQL credential, the user may be "github-armon-uuid".
	// This is to help identify the source without using audit tables.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Policies is the list of policies that the authenticated user
	// is associated with.
	Policies []string `protobuf:"bytes,4,rep,name=policies,proto3" json:"policies,omitempty"`
	// Metadata is used to attach arbitrary string-type metadata to
	// an authenticated user. This metadata will be outputted into the
	// audit log.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ClientToken is the token that is generated for the authentication.
	// This will be filled in by Vault core when an auth structure is
	// returned. Setting this manually will have no effect.
	ClientToken string `protobuf:"bytes,6,opt,name=client_token,json=clientToken,proto3" json:"client_token,omitempty"`
	// Accessor is the identifier for the ClientToken. This can be used
	// to perform management functionalities (especially revocation) when
	// ClientToken in the audit logs are obfuscated. Accessor can be used
	// to revoke a ClientToken and to lookup the capabilities of the ClientToken,
	// both without actually knowing the ClientToken.
	Accessor string `protobuf:"bytes,7,opt,name=accessor,proto3" json:"accessor,omitempty"`
	// Period indicates that the token generated using this Auth object
	// should never expire. The token should be renewed within the duration
	// specified by this period.
	Period int64 `protobuf:"varint,8,opt,name=period,proto3" json:"period,omitempty"`
	// Number of allowed uses of the issued token
	NumUses int64 `protobuf:"varint,9,opt,name=num_uses,json=numUses,proto3" json:"num_uses,omitempty"`
	// EntityID is the identifier of the entity in identity store to which the
	// identity of the authenticating client belongs to.
	EntityID string `protobuf:"bytes,10,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Alias is the information about the authenticated client returned by
	// the auth backend
	Alias *logical.Alias `protobuf:"bytes,11,opt,name=alias,proto3" json:"alias,omitempty"`
	// GroupAliases are the informational mappings of external groups which an
	// authenticated user belongs to. This is used to check if there are
	// mappings groups for the group aliases in identity store. For all the
	// matching groups, the entity ID of the user will be added.
	GroupAliases []*logical.Alias `protobuf:"bytes,12,rep,name=group_aliases,json=groupAliases,proto3" json:"group_aliases,omitempty"`
	// If set, restricts usage of the certificates to client IPs falling within
	// the range of the specified CIDR(s).
	BoundCIDRs []string `protobuf:"bytes,13,rep,name=bound_cidrs,json=boundCidrs,proto3" json:"bound_cidrs,omitempty"`
	// TokenPolicies and IdentityPolicies break down the list in Policies to
	// help determine where a policy was sourced
	TokenPolicies    []string `protobuf:"bytes,14,rep,name=token_policies,json=tokenPolicies,proto3" json:"token_policies,omitempty"`
	IdentityPolicies []string `protobuf:"bytes,15,rep,name=identity_policies,json=identityPolicies,proto3" json:"identity_policies,omitempty"`
	// Explicit maximum lifetime for the token. Unlike normal TTLs, the maximum
	// TTL is a hard limit and cannot be exceeded, also counts for periodic tokens.
	ExplicitMaxTTL int64 `protobuf:"varint,16,opt,name=explicit_max_ttl,json=explicitMaxTtl,proto3" json:"explicit_max_ttl,omitempty"`
	// TokenType is the type of token being requested
	TokenType uint32 `protobuf:"varint,17,opt,name=token_type,json=tokenType,proto3" json:"token_type,omitempty"`
	// Whether the default policy should be added automatically by core
	NoDefaultPolicy bool `protobuf:"varint,18,opt,name=no_default_policy,json=noDefaultPolicy,proto3" json:"no_default_policy,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Auth) Reset() {
	*x = Auth{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Auth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Auth) ProtoMessage() {}

func (x *Auth) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Auth.ProtoReflect.Descriptor instead.
func (*Auth) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{5}
}

func (x *Auth) GetLeaseOptions() *LeaseOptions {
	if x != nil {
		return x.LeaseOptions
	}
	return nil
}

func (x *Auth) GetInternalData() string {
	if x != nil {
		return x.InternalData
	}
	return ""
}

func (x *Auth) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Auth) GetPolicies() []string {
	if x != nil {
		return x.Policies
	}
	return nil
}

func (x *Auth) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Auth) GetClientToken() string {
	if x != nil {
		return x.ClientToken
	}
	return ""
}

func (x *Auth) GetAccessor() string {
	if x != nil {
		return x.Accessor
	}
	return ""
}

func (x *Auth) GetPeriod() int64 {
	if x != nil {
		return x.Period
	}
	return 0
}

func (x *Auth) GetNumUses() int64 {
	if x != nil {
		return x.NumUses
	}
	return 0
}

func (x *Auth) GetEntityID() string {
	if x != nil {
		return x.EntityID
	}
	return ""
}

func (x *Auth) GetAlias() *logical.Alias {
	if x != nil {
		return x.Alias
	}
	return nil
}

func (x *Auth) GetGroupAliases() []*logical.Alias {
	if x != nil {
		return x.GroupAliases
	}
	return nil
}

func (x *Auth) GetBoundCIDRs() []string {
	if x != nil {
		return x.BoundCIDRs
	}
	return nil
}

func (x *Auth) GetTokenPolicies() []string {
	if x != nil {
		return x.TokenPolicies
	}
	return nil
}

func (x *Auth) GetIdentityPolicies() []string {
	if x != nil {
		return x.IdentityPolicies
	}
	return nil
}

func (x *Auth) GetExplicitMaxTTL() int64 {
	if x != nil {
		return x.ExplicitMaxTTL
	}
	return 0
}

func (x *Auth) GetTokenType() uint32 {
	if x != nil {
		return x.TokenType
	}
	return 0
}

func (x *Auth) GetNoDefaultPolicy() bool {
	if x != nil {
		return x.NoDefaultPolicy
	}
	return false
}

type TokenEntry struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	ID                 string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Accessor           string                 `protobuf:"bytes,2,opt,name=accessor,proto3" json:"accessor,omitempty"`
	Parent             string                 `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	Policies           []string               `protobuf:"bytes,4,rep,name=policies,proto3" json:"policies,omitempty"`
	Path               string                 `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	Meta               map[string]string      `protobuf:"bytes,6,rep,name=meta,proto3" json:"meta,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	DisplayName        string                 `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	NumUses            int64                  `protobuf:"varint,8,opt,name=num_uses,json=numUses,proto3" json:"num_uses,omitempty"`
	CreationTime       int64                  `protobuf:"varint,9,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	TTL                int64                  `protobuf:"varint,10,opt,name=ttl,proto3" json:"ttl,omitempty"`
	ExplicitMaxTTL     int64                  `protobuf:"varint,11,opt,name=explicit_max_ttl,json=explicitMaxTtl,proto3" json:"explicit_max_ttl,omitempty"`
	Role               string                 `protobuf:"bytes,12,opt,name=role,proto3" json:"role,omitempty"`
	Period             int64                  `protobuf:"varint,13,opt,name=period,proto3" json:"period,omitempty"`
	EntityID           string                 `protobuf:"bytes,14,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	BoundCIDRs         []string               `protobuf:"bytes,15,rep,name=bound_cidrs,json=boundCidrs,proto3" json:"bound_cidrs,omitempty"`
	NamespaceID        string                 `protobuf:"bytes,16,opt,name=namespace_id,json=namespaceID,proto3" json:"namespace_id,omitempty"`
	CubbyholeID        string                 `protobuf:"bytes,17,opt,name=cubbyhole_id,json=cubbyholeId,proto3" json:"cubbyhole_id,omitempty"`
	Type               uint32                 `protobuf:"varint,18,opt,name=type,proto3" json:"type,omitempty"`
	InternalMeta       map[string]string      `protobuf:"bytes,19,rep,name=internal_meta,json=internalMeta,proto3" json:"internal_meta,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	InlinePolicy       string                 `protobuf:"bytes,20,opt,name=inline_policy,json=inlinePolicy,proto3" json:"inline_policy,omitempty"`
	NoIdentityPolicies bool                   `protobuf:"varint,21,opt,name=no_identity_policies,json=noIdentityPolicies,proto3" json:"no_identity_policies,omitempty"`
	ExternalID         string                 `protobuf:"bytes,22,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *TokenEntry) Reset() {
	*x = TokenEntry{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TokenEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TokenEntry) ProtoMessage() {}

func (x *TokenEntry) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TokenEntry.ProtoReflect.Descriptor instead.
func (*TokenEntry) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{6}
}

func (x *TokenEntry) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *TokenEntry) GetAccessor() string {
	if x != nil {
		return x.Accessor
	}
	return ""
}

func (x *TokenEntry) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TokenEntry) GetPolicies() []string {
	if x != nil {
		return x.Policies
	}
	return nil
}

func (x *TokenEntry) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *TokenEntry) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *TokenEntry) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TokenEntry) GetNumUses() int64 {
	if x != nil {
		return x.NumUses
	}
	return 0
}

func (x *TokenEntry) GetCreationTime() int64 {
	if x != nil {
		return x.CreationTime
	}
	return 0
}

func (x *TokenEntry) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

func (x *TokenEntry) GetExplicitMaxTTL() int64 {
	if x != nil {
		return x.ExplicitMaxTTL
	}
	return 0
}

func (x *TokenEntry) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *TokenEntry) GetPeriod() int64 {
	if x != nil {
		return x.Period
	}
	return 0
}

func (x *TokenEntry) GetEntityID() string {
	if x != nil {
		return x.EntityID
	}
	return ""
}

func (x *TokenEntry) GetBoundCIDRs() []string {
	if x != nil {
		return x.BoundCIDRs
	}
	return nil
}

func (x *TokenEntry) GetNamespaceID() string {
	if x != nil {
		return x.NamespaceID
	}
	return ""
}

func (x *TokenEntry) GetCubbyholeID() string {
	if x != nil {
		return x.CubbyholeID
	}
	return ""
}

func (x *TokenEntry) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *TokenEntry) GetInternalMeta() map[string]string {
	if x != nil {
		return x.InternalMeta
	}
	return nil
}

func (x *TokenEntry) GetInlinePolicy() string {
	if x != nil {
		return x.InlinePolicy
	}
	return ""
}

func (x *TokenEntry) GetNoIdentityPolicies() bool {
	if x != nil {
		return x.NoIdentityPolicies
	}
	return false
}

func (x *TokenEntry) GetExternalID() string {
	if x != nil {
		return x.ExternalID
	}
	return ""
}

type LeaseOptions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TTL           int64                  `protobuf:"varint,1,opt,name=TTL,proto3" json:"TTL,omitempty"`
	Renewable     bool                   `protobuf:"varint,2,opt,name=renewable,proto3" json:"renewable,omitempty"`
	Increment     int64                  `protobuf:"varint,3,opt,name=increment,proto3" json:"increment,omitempty"`
	IssueTime     *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=issue_time,json=issueTime,proto3" json:"issue_time,omitempty"`
	MaxTTL        int64                  `protobuf:"varint,5,opt,name=MaxTTL,proto3" json:"MaxTTL,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LeaseOptions) Reset() {
	*x = LeaseOptions{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LeaseOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeaseOptions) ProtoMessage() {}

func (x *LeaseOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeaseOptions.ProtoReflect.Descriptor instead.
func (*LeaseOptions) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{7}
}

func (x *LeaseOptions) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

func (x *LeaseOptions) GetRenewable() bool {
	if x != nil {
		return x.Renewable
	}
	return false
}

func (x *LeaseOptions) GetIncrement() int64 {
	if x != nil {
		return x.Increment
	}
	return 0
}

func (x *LeaseOptions) GetIssueTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IssueTime
	}
	return nil
}

func (x *LeaseOptions) GetMaxTTL() int64 {
	if x != nil {
		return x.MaxTTL
	}
	return 0
}

type Secret struct {
	state        protoimpl.MessageState `protogen:"open.v1"`
	LeaseOptions *LeaseOptions          `protobuf:"bytes,1,opt,name=lease_options,json=leaseOptions,proto3" json:"lease_options,omitempty"`
	// InternalData is a JSON object that is stored with the secret.
	// This will be sent back during a Renew/Revoke for storing internal data
	// used for those operations.
	InternalData string `protobuf:"bytes,2,opt,name=internal_data,json=internalData,proto3" json:"internal_data,omitempty"`
	// LeaseID is the ID returned to the user to manage this secret.
	// This is generated by Vault core. Any set value will be ignored.
	// For requests, this will always be blank.
	LeaseID       string `protobuf:"bytes,3,opt,name=lease_id,json=leaseId,proto3" json:"lease_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Secret) Reset() {
	*x = Secret{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{8}
}

func (x *Secret) GetLeaseOptions() *LeaseOptions {
	if x != nil {
		return x.LeaseOptions
	}
	return nil
}

func (x *Secret) GetInternalData() string {
	if x != nil {
		return x.InternalData
	}
	return ""
}

func (x *Secret) GetLeaseID() string {
	if x != nil {
		return x.LeaseID
	}
	return ""
}

type Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Secret, if not nil, denotes that this response represents a secret.
	Secret *Secret `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	// Auth, if not nil, contains the authentication information for
	// this response. This is only checked and means something for
	// credential backends.
	Auth *Auth `protobuf:"bytes,2,opt,name=auth,proto3" json:"auth,omitempty"`
	// Response data is a JSON object that must have string keys. For
	// secrets, this data is sent down to the user as-is. To store internal
	// data that you don't want the user to see, store it in
	// Secret.InternalData.
	Data string `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// Redirect is an HTTP URL to redirect to for further authentication.
	// This is only valid for credential backends. This will be blanked
	// for any logical backend and ignored.
	Redirect string `protobuf:"bytes,4,opt,name=redirect,proto3" json:"redirect,omitempty"`
	// Warnings allow operations or backends to return warnings in response
	// to user actions without failing the action outright.
	Warnings []string `protobuf:"bytes,5,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Information for wrapping the response in a cubbyhole
	WrapInfo *ResponseWrapInfo `protobuf:"bytes,6,opt,name=wrap_info,json=wrapInfo,proto3" json:"wrap_info,omitempty"`
	// Headers will contain the http headers from the response. This value will
	// be used in the audit broker to ensure we are auditing only the allowed
	// headers.
	Headers map[string]*Header `protobuf:"bytes,7,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// MountType, if non-empty, provides some information about what kind
	// of mount this secret came from.
	MountType     string `protobuf:"bytes,8,opt,name=mount_type,json=mountType,proto3" json:"mount_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Response) Reset() {
	*x = Response{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Response) ProtoMessage() {}

func (x *Response) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Response.ProtoReflect.Descriptor instead.
func (*Response) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{9}
}

func (x *Response) GetSecret() *Secret {
	if x != nil {
		return x.Secret
	}
	return nil
}

func (x *Response) GetAuth() *Auth {
	if x != nil {
		return x.Auth
	}
	return nil
}

func (x *Response) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

func (x *Response) GetRedirect() string {
	if x != nil {
		return x.Redirect
	}
	return ""
}

func (x *Response) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *Response) GetWrapInfo() *ResponseWrapInfo {
	if x != nil {
		return x.WrapInfo
	}
	return nil
}

func (x *Response) GetHeaders() map[string]*Header {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *Response) GetMountType() string {
	if x != nil {
		return x.MountType
	}
	return ""
}

type ResponseWrapInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Setting to non-zero specifies that the response should be wrapped.
	// Specifies the desired TTL of the wrapping token.
	TTL int64 `protobuf:"varint,1,opt,name=TTL,proto3" json:"TTL,omitempty"`
	// The token containing the wrapped response
	Token string `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
	// The token accessor for the wrapped response token
	Accessor string `protobuf:"bytes,3,opt,name=accessor,proto3" json:"accessor,omitempty"`
	// The creation time. This can be used with the TTL to figure out an
	// expected expiration.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// If the contained response is the output of a token creation call, the
	// created token's accessor will be accessible here
	WrappedAccessor string `protobuf:"bytes,5,opt,name=wrapped_accessor,json=wrappedAccessor,proto3" json:"wrapped_accessor,omitempty"`
	// WrappedEntityID is the entity identifier of the caller who initiated the
	// wrapping request
	WrappedEntityID string `protobuf:"bytes,6,opt,name=wrapped_entity_id,json=wrappedEntityID,proto3" json:"wrapped_entity_id,omitempty"`
	// The format to use. This doesn't get returned, it's only internal.
	Format string `protobuf:"bytes,7,opt,name=format,proto3" json:"format,omitempty"`
	// CreationPath is the original request path that was used to create
	// the wrapped response.
	CreationPath string `protobuf:"bytes,8,opt,name=creation_path,json=creationPath,proto3" json:"creation_path,omitempty"`
	// Controls seal wrapping behavior downstream for specific use cases
	SealWrap      bool `protobuf:"varint,9,opt,name=seal_wrap,json=sealWrap,proto3" json:"seal_wrap,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResponseWrapInfo) Reset() {
	*x = ResponseWrapInfo{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseWrapInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseWrapInfo) ProtoMessage() {}

func (x *ResponseWrapInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseWrapInfo.ProtoReflect.Descriptor instead.
func (*ResponseWrapInfo) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{10}
}

func (x *ResponseWrapInfo) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

func (x *ResponseWrapInfo) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ResponseWrapInfo) GetAccessor() string {
	if x != nil {
		return x.Accessor
	}
	return ""
}

func (x *ResponseWrapInfo) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *ResponseWrapInfo) GetWrappedAccessor() string {
	if x != nil {
		return x.WrappedAccessor
	}
	return ""
}

func (x *ResponseWrapInfo) GetWrappedEntityID() string {
	if x != nil {
		return x.WrappedEntityID
	}
	return ""
}

func (x *ResponseWrapInfo) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *ResponseWrapInfo) GetCreationPath() string {
	if x != nil {
		return x.CreationPath
	}
	return ""
}

func (x *ResponseWrapInfo) GetSealWrap() bool {
	if x != nil {
		return x.SealWrap
	}
	return false
}

type RequestWrapInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Setting to non-zero specifies that the response should be wrapped.
	// Specifies the desired TTL of the wrapping token.
	TTL int64 `protobuf:"varint,1,opt,name=TTL,proto3" json:"TTL,omitempty"`
	// The format to use for the wrapped response; if not specified it's a bare
	// token
	Format string `protobuf:"bytes,2,opt,name=format,proto3" json:"format,omitempty"`
	// A flag to conforming backends that data for a given request should be
	// seal wrapped
	SealWrap      bool `protobuf:"varint,3,opt,name=seal_wrap,json=sealWrap,proto3" json:"seal_wrap,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RequestWrapInfo) Reset() {
	*x = RequestWrapInfo{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RequestWrapInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestWrapInfo) ProtoMessage() {}

func (x *RequestWrapInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestWrapInfo.ProtoReflect.Descriptor instead.
func (*RequestWrapInfo) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{11}
}

func (x *RequestWrapInfo) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

func (x *RequestWrapInfo) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *RequestWrapInfo) GetSealWrap() bool {
	if x != nil {
		return x.SealWrap
	}
	return false
}

// HandleRequestArgs is the args for HandleRequest method.
type HandleRequestArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StorageID     uint32                 `protobuf:"varint,1,opt,name=storage_id,json=storageId,proto3" json:"storage_id,omitempty"`
	Request       *Request               `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HandleRequestArgs) Reset() {
	*x = HandleRequestArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HandleRequestArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HandleRequestArgs) ProtoMessage() {}

func (x *HandleRequestArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HandleRequestArgs.ProtoReflect.Descriptor instead.
func (*HandleRequestArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{12}
}

func (x *HandleRequestArgs) GetStorageID() uint32 {
	if x != nil {
		return x.StorageID
	}
	return 0
}

func (x *HandleRequestArgs) GetRequest() *Request {
	if x != nil {
		return x.Request
	}
	return nil
}

// HandleRequestReply is the reply for HandleRequest method.
type HandleRequestReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Response      *Response              `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
	Err           *ProtoError            `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HandleRequestReply) Reset() {
	*x = HandleRequestReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HandleRequestReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HandleRequestReply) ProtoMessage() {}

func (x *HandleRequestReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HandleRequestReply.ProtoReflect.Descriptor instead.
func (*HandleRequestReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{13}
}

func (x *HandleRequestReply) GetResponse() *Response {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *HandleRequestReply) GetErr() *ProtoError {
	if x != nil {
		return x.Err
	}
	return nil
}

// InitializeArgs is the args for Initialize method.
type InitializeArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InitializeArgs) Reset() {
	*x = InitializeArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeArgs) ProtoMessage() {}

func (x *InitializeArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeArgs.ProtoReflect.Descriptor instead.
func (*InitializeArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{14}
}

// InitializeReply is the reply for Initialize method.
type InitializeReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Err           *ProtoError            `protobuf:"bytes,1,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InitializeReply) Reset() {
	*x = InitializeReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeReply) ProtoMessage() {}

func (x *InitializeReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeReply.ProtoReflect.Descriptor instead.
func (*InitializeReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{15}
}

func (x *InitializeReply) GetErr() *ProtoError {
	if x != nil {
		return x.Err
	}
	return nil
}

// SpecialPathsReply is the reply for SpecialPaths method.
type SpecialPathsReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Paths         *Paths                 `protobuf:"bytes,1,opt,name=paths,proto3" json:"paths,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SpecialPathsReply) Reset() {
	*x = SpecialPathsReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpecialPathsReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpecialPathsReply) ProtoMessage() {}

func (x *SpecialPathsReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpecialPathsReply.ProtoReflect.Descriptor instead.
func (*SpecialPathsReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{16}
}

func (x *SpecialPathsReply) GetPaths() *Paths {
	if x != nil {
		return x.Paths
	}
	return nil
}

// HandleExistenceCheckArgs is the args for HandleExistenceCheck method.
type HandleExistenceCheckArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StorageID     uint32                 `protobuf:"varint,1,opt,name=storage_id,json=storageId,proto3" json:"storage_id,omitempty"`
	Request       *Request               `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HandleExistenceCheckArgs) Reset() {
	*x = HandleExistenceCheckArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HandleExistenceCheckArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HandleExistenceCheckArgs) ProtoMessage() {}

func (x *HandleExistenceCheckArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HandleExistenceCheckArgs.ProtoReflect.Descriptor instead.
func (*HandleExistenceCheckArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{17}
}

func (x *HandleExistenceCheckArgs) GetStorageID() uint32 {
	if x != nil {
		return x.StorageID
	}
	return 0
}

func (x *HandleExistenceCheckArgs) GetRequest() *Request {
	if x != nil {
		return x.Request
	}
	return nil
}

// HandleExistenceCheckReply is the reply for HandleExistenceCheck method.
type HandleExistenceCheckReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	CheckFound    bool                   `protobuf:"varint,1,opt,name=check_found,json=checkFound,proto3" json:"check_found,omitempty"`
	Exists        bool                   `protobuf:"varint,2,opt,name=exists,proto3" json:"exists,omitempty"`
	Err           *ProtoError            `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HandleExistenceCheckReply) Reset() {
	*x = HandleExistenceCheckReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HandleExistenceCheckReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HandleExistenceCheckReply) ProtoMessage() {}

func (x *HandleExistenceCheckReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HandleExistenceCheckReply.ProtoReflect.Descriptor instead.
func (*HandleExistenceCheckReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{18}
}

func (x *HandleExistenceCheckReply) GetCheckFound() bool {
	if x != nil {
		return x.CheckFound
	}
	return false
}

func (x *HandleExistenceCheckReply) GetExists() bool {
	if x != nil {
		return x.Exists
	}
	return false
}

func (x *HandleExistenceCheckReply) GetErr() *ProtoError {
	if x != nil {
		return x.Err
	}
	return nil
}

// SetupArgs is the args for Setup method.
type SetupArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	BrokerID      uint32                 `protobuf:"varint,1,opt,name=broker_id,json=brokerId,proto3" json:"broker_id,omitempty"`
	Config        map[string]string      `protobuf:"bytes,2,rep,name=Config,proto3" json:"Config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	BackendUUID   string                 `protobuf:"bytes,3,opt,name=backendUUID,proto3" json:"backendUUID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetupArgs) Reset() {
	*x = SetupArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetupArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetupArgs) ProtoMessage() {}

func (x *SetupArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetupArgs.ProtoReflect.Descriptor instead.
func (*SetupArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{19}
}

func (x *SetupArgs) GetBrokerID() uint32 {
	if x != nil {
		return x.BrokerID
	}
	return 0
}

func (x *SetupArgs) GetConfig() map[string]string {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *SetupArgs) GetBackendUUID() string {
	if x != nil {
		return x.BackendUUID
	}
	return ""
}

// SetupReply is the reply for Setup method.
type SetupReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Err           string                 `protobuf:"bytes,1,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetupReply) Reset() {
	*x = SetupReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetupReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetupReply) ProtoMessage() {}

func (x *SetupReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetupReply.ProtoReflect.Descriptor instead.
func (*SetupReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{20}
}

func (x *SetupReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

// TypeReply is the reply for the Type method.
type TypeReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TypeReply) Reset() {
	*x = TypeReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TypeReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypeReply) ProtoMessage() {}

func (x *TypeReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypeReply.ProtoReflect.Descriptor instead.
func (*TypeReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{21}
}

func (x *TypeReply) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

type InvalidateKeyArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvalidateKeyArgs) Reset() {
	*x = InvalidateKeyArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvalidateKeyArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvalidateKeyArgs) ProtoMessage() {}

func (x *InvalidateKeyArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvalidateKeyArgs.ProtoReflect.Descriptor instead.
func (*InvalidateKeyArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{22}
}

func (x *InvalidateKeyArgs) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type StorageEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	SealWrap      bool                   `protobuf:"varint,3,opt,name=seal_wrap,json=sealWrap,proto3" json:"seal_wrap,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageEntry) Reset() {
	*x = StorageEntry{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageEntry) ProtoMessage() {}

func (x *StorageEntry) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageEntry.ProtoReflect.Descriptor instead.
func (*StorageEntry) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{23}
}

func (x *StorageEntry) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *StorageEntry) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *StorageEntry) GetSealWrap() bool {
	if x != nil {
		return x.SealWrap
	}
	return false
}

type StorageListArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Prefix        string                 `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageListArgs) Reset() {
	*x = StorageListArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageListArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageListArgs) ProtoMessage() {}

func (x *StorageListArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageListArgs.ProtoReflect.Descriptor instead.
func (*StorageListArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{24}
}

func (x *StorageListArgs) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

type StorageListReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Keys          []string               `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	Err           string                 `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageListReply) Reset() {
	*x = StorageListReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageListReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageListReply) ProtoMessage() {}

func (x *StorageListReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageListReply.ProtoReflect.Descriptor instead.
func (*StorageListReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{25}
}

func (x *StorageListReply) GetKeys() []string {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *StorageListReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type StorageGetArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageGetArgs) Reset() {
	*x = StorageGetArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageGetArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageGetArgs) ProtoMessage() {}

func (x *StorageGetArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageGetArgs.ProtoReflect.Descriptor instead.
func (*StorageGetArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{26}
}

func (x *StorageGetArgs) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type StorageGetReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entry         *StorageEntry          `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	Err           string                 `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageGetReply) Reset() {
	*x = StorageGetReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageGetReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageGetReply) ProtoMessage() {}

func (x *StorageGetReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageGetReply.ProtoReflect.Descriptor instead.
func (*StorageGetReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{27}
}

func (x *StorageGetReply) GetEntry() *StorageEntry {
	if x != nil {
		return x.Entry
	}
	return nil
}

func (x *StorageGetReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type StoragePutArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entry         *StorageEntry          `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StoragePutArgs) Reset() {
	*x = StoragePutArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoragePutArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoragePutArgs) ProtoMessage() {}

func (x *StoragePutArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoragePutArgs.ProtoReflect.Descriptor instead.
func (*StoragePutArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{28}
}

func (x *StoragePutArgs) GetEntry() *StorageEntry {
	if x != nil {
		return x.Entry
	}
	return nil
}

type StoragePutReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Err           string                 `protobuf:"bytes,1,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StoragePutReply) Reset() {
	*x = StoragePutReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoragePutReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoragePutReply) ProtoMessage() {}

func (x *StoragePutReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoragePutReply.ProtoReflect.Descriptor instead.
func (*StoragePutReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{29}
}

func (x *StoragePutReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type StorageDeleteArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageDeleteArgs) Reset() {
	*x = StorageDeleteArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageDeleteArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageDeleteArgs) ProtoMessage() {}

func (x *StorageDeleteArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageDeleteArgs.ProtoReflect.Descriptor instead.
func (*StorageDeleteArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{30}
}

func (x *StorageDeleteArgs) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type StorageDeleteReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Err           string                 `protobuf:"bytes,1,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StorageDeleteReply) Reset() {
	*x = StorageDeleteReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageDeleteReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageDeleteReply) ProtoMessage() {}

func (x *StorageDeleteReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageDeleteReply.ProtoReflect.Descriptor instead.
func (*StorageDeleteReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{31}
}

func (x *StorageDeleteReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type TTLReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TTL           int64                  `protobuf:"varint,1,opt,name=TTL,proto3" json:"TTL,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TTLReply) Reset() {
	*x = TTLReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TTLReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TTLReply) ProtoMessage() {}

func (x *TTLReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TTLReply.ProtoReflect.Descriptor instead.
func (*TTLReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{32}
}

func (x *TTLReply) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

type TaintedReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Tainted       bool                   `protobuf:"varint,1,opt,name=tainted,proto3" json:"tainted,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TaintedReply) Reset() {
	*x = TaintedReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TaintedReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaintedReply) ProtoMessage() {}

func (x *TaintedReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaintedReply.ProtoReflect.Descriptor instead.
func (*TaintedReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{33}
}

func (x *TaintedReply) GetTainted() bool {
	if x != nil {
		return x.Tainted
	}
	return false
}

type CachingDisabledReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Disabled      bool                   `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CachingDisabledReply) Reset() {
	*x = CachingDisabledReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CachingDisabledReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CachingDisabledReply) ProtoMessage() {}

func (x *CachingDisabledReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CachingDisabledReply.ProtoReflect.Descriptor instead.
func (*CachingDisabledReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{34}
}

func (x *CachingDisabledReply) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

type ReplicationStateReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	State         int32                  `protobuf:"varint,1,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationStateReply) Reset() {
	*x = ReplicationStateReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationStateReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationStateReply) ProtoMessage() {}

func (x *ReplicationStateReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationStateReply.ProtoReflect.Descriptor instead.
func (*ReplicationStateReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{35}
}

func (x *ReplicationStateReply) GetState() int32 {
	if x != nil {
		return x.State
	}
	return 0
}

type ResponseWrapDataArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Data          string                 `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	TTL           int64                  `protobuf:"varint,2,opt,name=TTL,proto3" json:"TTL,omitempty"`
	JWT           bool                   `protobuf:"varint,3,opt,name=JWT,proto3" json:"JWT,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResponseWrapDataArgs) Reset() {
	*x = ResponseWrapDataArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseWrapDataArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseWrapDataArgs) ProtoMessage() {}

func (x *ResponseWrapDataArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseWrapDataArgs.ProtoReflect.Descriptor instead.
func (*ResponseWrapDataArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{36}
}

func (x *ResponseWrapDataArgs) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

func (x *ResponseWrapDataArgs) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

func (x *ResponseWrapDataArgs) GetJWT() bool {
	if x != nil {
		return x.JWT
	}
	return false
}

type ResponseWrapDataReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	WrapInfo      *ResponseWrapInfo      `protobuf:"bytes,1,opt,name=wrap_info,json=wrapInfo,proto3" json:"wrap_info,omitempty"`
	Err           string                 `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResponseWrapDataReply) Reset() {
	*x = ResponseWrapDataReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseWrapDataReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseWrapDataReply) ProtoMessage() {}

func (x *ResponseWrapDataReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseWrapDataReply.ProtoReflect.Descriptor instead.
func (*ResponseWrapDataReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{37}
}

func (x *ResponseWrapDataReply) GetWrapInfo() *ResponseWrapInfo {
	if x != nil {
		return x.WrapInfo
	}
	return nil
}

func (x *ResponseWrapDataReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type MlockEnabledReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Enabled       bool                   `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MlockEnabledReply) Reset() {
	*x = MlockEnabledReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MlockEnabledReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MlockEnabledReply) ProtoMessage() {}

func (x *MlockEnabledReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MlockEnabledReply.ProtoReflect.Descriptor instead.
func (*MlockEnabledReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{38}
}

func (x *MlockEnabledReply) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type LocalMountReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Local         bool                   `protobuf:"varint,1,opt,name=local,proto3" json:"local,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LocalMountReply) Reset() {
	*x = LocalMountReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalMountReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalMountReply) ProtoMessage() {}

func (x *LocalMountReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalMountReply.ProtoReflect.Descriptor instead.
func (*LocalMountReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{39}
}

func (x *LocalMountReply) GetLocal() bool {
	if x != nil {
		return x.Local
	}
	return false
}

type EntityInfoArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	EntityID      string                 `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EntityInfoArgs) Reset() {
	*x = EntityInfoArgs{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityInfoArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityInfoArgs) ProtoMessage() {}

func (x *EntityInfoArgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityInfoArgs.ProtoReflect.Descriptor instead.
func (*EntityInfoArgs) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{40}
}

func (x *EntityInfoArgs) GetEntityID() string {
	if x != nil {
		return x.EntityID
	}
	return ""
}

type EntityInfoReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entity        *logical.Entity        `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	Err           string                 `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EntityInfoReply) Reset() {
	*x = EntityInfoReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityInfoReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityInfoReply) ProtoMessage() {}

func (x *EntityInfoReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityInfoReply.ProtoReflect.Descriptor instead.
func (*EntityInfoReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{41}
}

func (x *EntityInfoReply) GetEntity() *logical.Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *EntityInfoReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type GroupsForEntityReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Groups        []*logical.Group       `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	Err           string                 `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupsForEntityReply) Reset() {
	*x = GroupsForEntityReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupsForEntityReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupsForEntityReply) ProtoMessage() {}

func (x *GroupsForEntityReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupsForEntityReply.ProtoReflect.Descriptor instead.
func (*GroupsForEntityReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{42}
}

func (x *GroupsForEntityReply) GetGroups() []*logical.Group {
	if x != nil {
		return x.Groups
	}
	return nil
}

func (x *GroupsForEntityReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type PluginEnvReply struct {
	state             protoimpl.MessageState     `protogen:"open.v1"`
	PluginEnvironment *logical.PluginEnvironment `protobuf:"bytes,1,opt,name=plugin_environment,json=pluginEnvironment,proto3" json:"plugin_environment,omitempty"`
	Err               string                     `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PluginEnvReply) Reset() {
	*x = PluginEnvReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginEnvReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginEnvReply) ProtoMessage() {}

func (x *PluginEnvReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginEnvReply.ProtoReflect.Descriptor instead.
func (*PluginEnvReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{43}
}

func (x *PluginEnvReply) GetPluginEnvironment() *logical.PluginEnvironment {
	if x != nil {
		return x.PluginEnvironment
	}
	return nil
}

func (x *PluginEnvReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type GeneratePasswordFromPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PolicyName    string                 `protobuf:"bytes,1,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GeneratePasswordFromPolicyRequest) Reset() {
	*x = GeneratePasswordFromPolicyRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratePasswordFromPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratePasswordFromPolicyRequest) ProtoMessage() {}

func (x *GeneratePasswordFromPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratePasswordFromPolicyRequest.ProtoReflect.Descriptor instead.
func (*GeneratePasswordFromPolicyRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{44}
}

func (x *GeneratePasswordFromPolicyRequest) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

type GeneratePasswordFromPolicyReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Password      string                 `protobuf:"bytes,1,opt,name=password,proto3" json:"password,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GeneratePasswordFromPolicyReply) Reset() {
	*x = GeneratePasswordFromPolicyReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratePasswordFromPolicyReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratePasswordFromPolicyReply) ProtoMessage() {}

func (x *GeneratePasswordFromPolicyReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratePasswordFromPolicyReply.ProtoReflect.Descriptor instead.
func (*GeneratePasswordFromPolicyReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{45}
}

func (x *GeneratePasswordFromPolicyReply) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

type ClusterInfoReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ClusterName   string                 `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	ClusterID     string                 `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Err           string                 `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterInfoReply) Reset() {
	*x = ClusterInfoReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterInfoReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterInfoReply) ProtoMessage() {}

func (x *ClusterInfoReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterInfoReply.ProtoReflect.Descriptor instead.
func (*ClusterInfoReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{46}
}

func (x *ClusterInfoReply) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *ClusterInfoReply) GetClusterID() string {
	if x != nil {
		return x.ClusterID
	}
	return ""
}

func (x *ClusterInfoReply) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type GenerateIdentityTokenRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Audience      string                 `protobuf:"bytes,1,opt,name=audience,proto3" json:"audience,omitempty"`
	TTL           int64                  `protobuf:"varint,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateIdentityTokenRequest) Reset() {
	*x = GenerateIdentityTokenRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateIdentityTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateIdentityTokenRequest) ProtoMessage() {}

func (x *GenerateIdentityTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateIdentityTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateIdentityTokenRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{47}
}

func (x *GenerateIdentityTokenRequest) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

func (x *GenerateIdentityTokenRequest) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

type GenerateIdentityTokenResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Token         string                 `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	TTL           int64                  `protobuf:"varint,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateIdentityTokenResponse) Reset() {
	*x = GenerateIdentityTokenResponse{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateIdentityTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateIdentityTokenResponse) ProtoMessage() {}

func (x *GenerateIdentityTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateIdentityTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateIdentityTokenResponse) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{48}
}

func (x *GenerateIdentityTokenResponse) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *GenerateIdentityTokenResponse) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

type RotationInfoRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MountPath     string                 `protobuf:"bytes,1,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RotationInfoRequest) Reset() {
	*x = RotationInfoRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RotationInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotationInfoRequest) ProtoMessage() {}

func (x *RotationInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotationInfoRequest.ProtoReflect.Descriptor instead.
func (*RotationInfoRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{49}
}

func (x *RotationInfoRequest) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

type RotationInfoReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IssueTime     int64                  `protobuf:"varint,1,opt,name=issue_time,json=issueTime,proto3" json:"issue_time,omitempty"`
	ExpireTime    int64                  `protobuf:"varint,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	TTL           int64                  `protobuf:"varint,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RotationInfoReply) Reset() {
	*x = RotationInfoReply{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RotationInfoReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotationInfoReply) ProtoMessage() {}

func (x *RotationInfoReply) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotationInfoReply.ProtoReflect.Descriptor instead.
func (*RotationInfoReply) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{50}
}

func (x *RotationInfoReply) GetIssueTime() int64 {
	if x != nil {
		return x.IssueTime
	}
	return 0
}

func (x *RotationInfoReply) GetExpireTime() int64 {
	if x != nil {
		return x.ExpireTime
	}
	return 0
}

func (x *RotationInfoReply) GetTTL() int64 {
	if x != nil {
		return x.TTL
	}
	return 0
}

type RegisterRotationJobRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Job           *RotationJobInput      `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterRotationJobRequest) Reset() {
	*x = RegisterRotationJobRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterRotationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRotationJobRequest) ProtoMessage() {}

func (x *RegisterRotationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRotationJobRequest.ProtoReflect.Descriptor instead.
func (*RegisterRotationJobRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{51}
}

func (x *RegisterRotationJobRequest) GetJob() *RotationJobInput {
	if x != nil {
		return x.Job
	}
	return nil
}

type RegisterRotationJobResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RotationID    string                 `protobuf:"bytes,1,opt,name=rotation_id,json=rotationId,proto3" json:"rotation_id,omitempty"`
	Err           string                 `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterRotationJobResponse) Reset() {
	*x = RegisterRotationJobResponse{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterRotationJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRotationJobResponse) ProtoMessage() {}

func (x *RegisterRotationJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRotationJobResponse.ProtoReflect.Descriptor instead.
func (*RegisterRotationJobResponse) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{52}
}

func (x *RegisterRotationJobResponse) GetRotationID() string {
	if x != nil {
		return x.RotationID
	}
	return ""
}

func (x *RegisterRotationJobResponse) GetErr() string {
	if x != nil {
		return x.Err
	}
	return ""
}

type RotationJobInput struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Name             string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	MountPoint       string                 `protobuf:"bytes,2,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
	Path             string                 `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	RotationSchedule string                 `protobuf:"bytes,4,opt,name=rotation_schedule,json=rotationSchedule,proto3" json:"rotation_schedule,omitempty"`
	RotationWindow   int64                  `protobuf:"varint,5,opt,name=rotation_window,json=rotationWindow,proto3" json:"rotation_window,omitempty"`
	RotationPeriod   int64                  `protobuf:"varint,6,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *RotationJobInput) Reset() {
	*x = RotationJobInput{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RotationJobInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotationJobInput) ProtoMessage() {}

func (x *RotationJobInput) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotationJobInput.ProtoReflect.Descriptor instead.
func (*RotationJobInput) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{53}
}

func (x *RotationJobInput) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RotationJobInput) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

func (x *RotationJobInput) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *RotationJobInput) GetRotationSchedule() string {
	if x != nil {
		return x.RotationSchedule
	}
	return ""
}

func (x *RotationJobInput) GetRotationWindow() int64 {
	if x != nil {
		return x.RotationWindow
	}
	return 0
}

func (x *RotationJobInput) GetRotationPeriod() int64 {
	if x != nil {
		return x.RotationPeriod
	}
	return 0
}

type DeregisterRotationRequestInput struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MountPoint    string                 `protobuf:"bytes,1,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
	ReqPath       string                 `protobuf:"bytes,2,opt,name=req_path,json=reqPath,proto3" json:"req_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeregisterRotationRequestInput) Reset() {
	*x = DeregisterRotationRequestInput{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeregisterRotationRequestInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeregisterRotationRequestInput) ProtoMessage() {}

func (x *DeregisterRotationRequestInput) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeregisterRotationRequestInput.ProtoReflect.Descriptor instead.
func (*DeregisterRotationRequestInput) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{54}
}

func (x *DeregisterRotationRequestInput) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

func (x *DeregisterRotationRequestInput) GetReqPath() string {
	if x != nil {
		return x.ReqPath
	}
	return ""
}

type DeregisterRotationJobRequest struct {
	state         protoimpl.MessageState          `protogen:"open.v1"`
	Req           *DeregisterRotationRequestInput `protobuf:"bytes,1,opt,name=req,proto3" json:"req,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeregisterRotationJobRequest) Reset() {
	*x = DeregisterRotationJobRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeregisterRotationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeregisterRotationJobRequest) ProtoMessage() {}

func (x *DeregisterRotationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeregisterRotationJobRequest.ProtoReflect.Descriptor instead.
func (*DeregisterRotationJobRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{55}
}

func (x *DeregisterRotationJobRequest) GetReq() *DeregisterRotationRequestInput {
	if x != nil {
		return x.Req
	}
	return nil
}

type Connection struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// RemoteAddr is the network address that sent the request.
	RemoteAddr string `protobuf:"bytes,1,opt,name=remote_addr,json=remoteAddr,proto3" json:"remote_addr,omitempty"`
	// RemotePort is the network port that sent the request.
	RemotePort int32 `protobuf:"varint,3,opt,name=remote_port,json=remotePort,proto3" json:"remote_port,omitempty"`
	// ConnectionState is the marshalled tls.ConnectionState from the original
	// request
	ConnectionState *ConnectionState `protobuf:"bytes,2,opt,name=connection_state,json=connectionState,proto3" json:"connection_state,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Connection) Reset() {
	*x = Connection{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{56}
}

func (x *Connection) GetRemoteAddr() string {
	if x != nil {
		return x.RemoteAddr
	}
	return ""
}

func (x *Connection) GetRemotePort() int32 {
	if x != nil {
		return x.RemotePort
	}
	return 0
}

func (x *Connection) GetConnectionState() *ConnectionState {
	if x != nil {
		return x.ConnectionState
	}
	return nil
}

type ConnectionState struct {
	state                       protoimpl.MessageState `protogen:"open.v1"`
	Version                     uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	HandshakeComplete           bool                   `protobuf:"varint,2,opt,name=handshake_complete,json=handshakeComplete,proto3" json:"handshake_complete,omitempty"`
	DidResume                   bool                   `protobuf:"varint,3,opt,name=did_resume,json=didResume,proto3" json:"did_resume,omitempty"`
	CipherSuite                 uint32                 `protobuf:"varint,4,opt,name=cipher_suite,json=cipherSuite,proto3" json:"cipher_suite,omitempty"`
	NegotiatedProtocol          string                 `protobuf:"bytes,5,opt,name=negotiated_protocol,json=negotiatedProtocol,proto3" json:"negotiated_protocol,omitempty"`
	NegotiatedProtocolIsMutual  bool                   `protobuf:"varint,6,opt,name=negotiated_protocol_is_mutual,json=negotiatedProtocolIsMutual,proto3" json:"negotiated_protocol_is_mutual,omitempty"`
	ServerName                  string                 `protobuf:"bytes,7,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
	PeerCertificates            *CertificateChain      `protobuf:"bytes,8,opt,name=peer_certificates,json=peerCertificates,proto3" json:"peer_certificates,omitempty"`
	VerifiedChains              []*CertificateChain    `protobuf:"bytes,9,rep,name=verified_chains,json=verifiedChains,proto3" json:"verified_chains,omitempty"`
	SignedCertificateTimestamps [][]byte               `protobuf:"bytes,10,rep,name=signed_certificate_timestamps,json=signedCertificateTimestamps,proto3" json:"signed_certificate_timestamps,omitempty"`
	OcspResponse                []byte                 `protobuf:"bytes,11,opt,name=ocsp_response,json=ocspResponse,proto3" json:"ocsp_response,omitempty"`
	TlsUnique                   []byte                 `protobuf:"bytes,12,opt,name=tls_unique,json=tlsUnique,proto3" json:"tls_unique,omitempty"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *ConnectionState) Reset() {
	*x = ConnectionState{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionState) ProtoMessage() {}

func (x *ConnectionState) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionState.ProtoReflect.Descriptor instead.
func (*ConnectionState) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{57}
}

func (x *ConnectionState) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ConnectionState) GetHandshakeComplete() bool {
	if x != nil {
		return x.HandshakeComplete
	}
	return false
}

func (x *ConnectionState) GetDidResume() bool {
	if x != nil {
		return x.DidResume
	}
	return false
}

func (x *ConnectionState) GetCipherSuite() uint32 {
	if x != nil {
		return x.CipherSuite
	}
	return 0
}

func (x *ConnectionState) GetNegotiatedProtocol() string {
	if x != nil {
		return x.NegotiatedProtocol
	}
	return ""
}

func (x *ConnectionState) GetNegotiatedProtocolIsMutual() bool {
	if x != nil {
		return x.NegotiatedProtocolIsMutual
	}
	return false
}

func (x *ConnectionState) GetServerName() string {
	if x != nil {
		return x.ServerName
	}
	return ""
}

func (x *ConnectionState) GetPeerCertificates() *CertificateChain {
	if x != nil {
		return x.PeerCertificates
	}
	return nil
}

func (x *ConnectionState) GetVerifiedChains() []*CertificateChain {
	if x != nil {
		return x.VerifiedChains
	}
	return nil
}

func (x *ConnectionState) GetSignedCertificateTimestamps() [][]byte {
	if x != nil {
		return x.SignedCertificateTimestamps
	}
	return nil
}

func (x *ConnectionState) GetOcspResponse() []byte {
	if x != nil {
		return x.OcspResponse
	}
	return nil
}

func (x *ConnectionState) GetTlsUnique() []byte {
	if x != nil {
		return x.TlsUnique
	}
	return nil
}

type Certificate struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Asn1Data      []byte                 `protobuf:"bytes,1,opt,name=asn1_data,json=asn1Data,proto3" json:"asn1_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{58}
}

func (x *Certificate) GetAsn1Data() []byte {
	if x != nil {
		return x.Asn1Data
	}
	return nil
}

type CertificateChain struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Certificates  []*Certificate         `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateChain) Reset() {
	*x = CertificateChain{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateChain) ProtoMessage() {}

func (x *CertificateChain) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateChain.ProtoReflect.Descriptor instead.
func (*CertificateChain) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{59}
}

func (x *CertificateChain) GetCertificates() []*Certificate {
	if x != nil {
		return x.Certificates
	}
	return nil
}

type SendEventRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	EventType     string                 `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	Event         *logical.EventData     `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SendEventRequest) Reset() {
	*x = SendEventRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SendEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendEventRequest) ProtoMessage() {}

func (x *SendEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendEventRequest.ProtoReflect.Descriptor instead.
func (*SendEventRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{60}
}

func (x *SendEventRequest) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *SendEventRequest) GetEvent() *logical.EventData {
	if x != nil {
		return x.Event
	}
	return nil
}

type RecordObservationRequest struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	ObservationType string                 `protobuf:"bytes,1,opt,name=observation_type,json=observationType,proto3" json:"observation_type,omitempty"`
	Data            *structpb.Struct       `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *RecordObservationRequest) Reset() {
	*x = RecordObservationRequest{}
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecordObservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordObservationRequest) ProtoMessage() {}

func (x *RecordObservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdk_plugin_pb_backend_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordObservationRequest.ProtoReflect.Descriptor instead.
func (*RecordObservationRequest) Descriptor() ([]byte, []int) {
	return file_sdk_plugin_pb_backend_proto_rawDescGZIP(), []int{61}
}

func (x *RecordObservationRequest) GetObservationType() string {
	if x != nil {
		return x.ObservationType
	}
	return ""
}

func (x *RecordObservationRequest) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

var File_sdk_plugin_pb_backend_proto protoreflect.FileDescriptor

var file_sdk_plugin_pb_backend_proto_rawDesc = string([]byte{
	0x0a, 0x1b, 0x73, 0x64, 0x6b, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x70, 0x62, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x02, 0x70,
	0x62, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x73, 0x64, 0x6b, 0x2f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x73, 0x64, 0x6b, 0x2f, 0x6c,
	0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x73, 0x64, 0x6b, 0x2f, 0x6c, 0x6f, 0x67, 0x69, 0x63,
	0x61, 0x6c, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x07, 0x0a, 0x05, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x20, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x5b, 0x0a, 0x0a, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x72, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x65, 0x72, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x5f, 0x6d, 0x73, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x19, 0x0a, 0x08,
	0x65, 0x72, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xb0, 0x02, 0x0a, 0x05, 0x50, 0x61, 0x74, 0x68,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x04, 0x72, 0x6f, 0x6f, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x75, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x75, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x65, 0x61, 0x6c, 0x5f, 0x77, 0x72, 0x61,
	0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0f, 0x73, 0x65, 0x61, 0x6c, 0x57, 0x72, 0x61, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x12, 0x36, 0x0a, 0x17, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x15, 0x77, 0x72, 0x69, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x07, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x61,
	0x64, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x61, 0x64, 0x22, 0xa1, 0x07, 0x0a, 0x07, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2e, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x22, 0x0a, 0x06,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x70,
	0x62, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x12, 0x1c, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x08,
	0x2e, 0x70, 0x62, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x12, 0x32,
	0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x12, 0x30, 0x0a, 0x09, 0x77, 0x72, 0x61, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x57, 0x72, 0x61, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x77, 0x72, 0x61,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3d, 0x0a, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x75, 0x73, 0x65, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x55, 0x73, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49,
	0x64, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x75, 0x6e,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x75, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x62, 0x2e, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73,
	0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x1a, 0x46, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x20, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x70, 0x62, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe6,
	0x05, 0x0a, 0x04, 0x41, 0x75, 0x74, 0x68, 0x12, 0x35, 0x0a, 0x0d, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x70, 0x62, 0x2e, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0c, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x12, 0x32, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x62, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x6e, 0x75, 0x6d, 0x5f, 0x75, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x07, 0x6e, 0x75, 0x6d, 0x55, 0x73, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x41,
	0x6c, 0x69, 0x61, 0x73, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x33, 0x0a, 0x0d, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x52, 0x0c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x69, 0x64, 0x72,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x0f, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69,
	0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0e, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x4d, 0x61, 0x78, 0x54, 0x74, 0x6c, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x09, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a,
	0x0a, 0x11, 0x6e, 0x6f, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6e, 0x6f, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xca, 0x06, 0x0a, 0x0a, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x2c, 0x0a, 0x04, 0x6d, 0x65,
	0x74, 0x61, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x62, 0x2e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6e,
	0x75, 0x6d, 0x5f, 0x75, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6e,
	0x75, 0x6d, 0x55, 0x73, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74,
	0x74, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x28, 0x0a,
	0x10, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x74,
	0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69,
	0x74, 0x4d, 0x61, 0x78, 0x54, 0x74, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x73, 0x18,
	0x0f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x69, 0x64, 0x72,
	0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x75, 0x62, 0x62, 0x79, 0x68, 0x6f, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x75, 0x62, 0x62,
	0x79, 0x68, 0x6f, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x13, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x62, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4d, 0x65,
	0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x30, 0x0a, 0x14, 0x6e, 0x6f, 0x5f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x6e, 0x6f, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x3f, 0x0a, 0x11, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4d,
	0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xaf, 0x01, 0x0a, 0x0c, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x54, 0x54, 0x4c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x03, 0x54, 0x54, 0x4c, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x6e, 0x65, 0x77,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65, 0x6e, 0x65,
	0x77, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x69, 0x73, 0x73, 0x75, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x4d, 0x61, 0x78, 0x54, 0x54, 0x4c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06,
	0x4d, 0x61, 0x78, 0x54, 0x54, 0x4c, 0x22, 0x7f, 0x0a, 0x06, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x12, 0x35, 0x0a, 0x0d, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x62, 0x2e, 0x4c, 0x65, 0x61,
	0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x12, 0x19, 0x0a, 0x08,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0xe7, 0x02, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x08, 0x2e, 0x70, 0x62, 0x2e, 0x41, 0x75, 0x74, 0x68,
	0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x77, 0x72, 0x61, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x57, 0x72, 0x61, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x77, 0x72, 0x61,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x33, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x46, 0x0a, 0x0c, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x20, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x70, 0x62, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xc8, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72,
	0x61, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x54, 0x54, 0x4c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x03, 0x54, 0x54, 0x4c, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1a,
	0x0a, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x11, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x65, 0x61, 0x6c, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x61, 0x6c, 0x57, 0x72, 0x61, 0x70, 0x22, 0x58, 0x0a, 0x0f,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x57, 0x72, 0x61, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x10, 0x0a, 0x03, 0x54, 0x54, 0x4c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x54, 0x54,
	0x4c, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x61,
	0x6c, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65,
	0x61, 0x6c, 0x57, 0x72, 0x61, 0x70, 0x22, 0x59, 0x0a, 0x11, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x72, 0x67, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x07, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x60, 0x0a, 0x12, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x28, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x20, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e,
	0x2e, 0x70, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x03,
	0x65, 0x72, 0x72, 0x22, 0x10, 0x0a, 0x0e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x41, 0x72, 0x67, 0x73, 0x22, 0x33, 0x0a, 0x0f, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x20, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x34, 0x0a, 0x11, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12,
	0x1f, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x09,
	0x2e, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73,
	0x22, 0x60, 0x0a, 0x18, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x45, 0x78, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x72, 0x67, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x70,
	0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0x76, 0x0a, 0x19, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x45, 0x78, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x6f, 0x75, 0x6e, 0x64,
	0x12, 0x16, 0x0a, 0x06, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0xb8, 0x01, 0x0a, 0x09, 0x53,
	0x65, 0x74, 0x75, 0x70, 0x41, 0x72, 0x67, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x62, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x41, 0x72, 0x67, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x55, 0x55, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x55, 0x55, 0x49, 0x44, 0x1a, 0x39, 0x0a, 0x0b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x1e, 0x0a, 0x0a, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65,
	0x70, 0x6c, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x1f, 0x0a, 0x09, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x25, 0x0a, 0x11, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x41, 0x72, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x53, 0x0a,
	0x0c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x61, 0x6c, 0x5f, 0x77, 0x72,
	0x61, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x61, 0x6c, 0x57, 0x72,
	0x61, 0x70, 0x22, 0x29, 0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x72, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x38, 0x0a,
	0x10, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x22, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x47, 0x65, 0x74, 0x41, 0x72, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x4b, 0x0a, 0x0f, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x26,
	0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x38, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x75, 0x74, 0x41, 0x72, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x05, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x62, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x22, 0x23, 0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x75, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x25, 0x0a, 0x11, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x26,
	0x0a, 0x12, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x1c, 0x0a, 0x08, 0x54, 0x54, 0x4c, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x54, 0x54, 0x4c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x03, 0x54, 0x54, 0x4c, 0x22, 0x28, 0x0a, 0x0c, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x22, 0x32,
	0x0a, 0x14, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x22, 0x2d, 0x0a, 0x15, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x22, 0x4e, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72, 0x61,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x41, 0x72, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x10, 0x0a,
	0x03, 0x54, 0x54, 0x4c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x54, 0x54, 0x4c, 0x12,
	0x10, 0x0a, 0x03, 0x4a, 0x57, 0x54, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x4a, 0x57,
	0x54, 0x22, 0x5c, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72, 0x61,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x31, 0x0a, 0x09, 0x77, 0x72,
	0x61, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72, 0x61, 0x70, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x77, 0x72, 0x61, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a,
	0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22,
	0x2d, 0x0a, 0x11, 0x4d, 0x6c, 0x6f, 0x63, 0x6b, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x27,
	0x0a, 0x0f, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x22, 0x2d, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x49, 0x6e, 0x66, 0x6f, 0x41, 0x72, 0x67, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x22, 0x4c, 0x0a, 0x0f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x27, 0x0a, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x65, 0x72, 0x72, 0x22, 0x50, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x46, 0x6f,
	0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x26, 0x0a, 0x06,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6c,
	0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x6d, 0x0a, 0x0e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x45, 0x6e, 0x76, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x49, 0x0a, 0x12, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x11, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0x44, 0x0a, 0x21, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x3d, 0x0a, 0x1f, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x46,
	0x72, 0x6f, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x66, 0x0a, 0x10, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x10, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65,
	0x72, 0x72, 0x22, 0x4c, 0x0a, 0x1c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x74, 0x74, 0x6c,
	0x22, 0x47, 0x0a, 0x1d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x34, 0x0a, 0x13, 0x52, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22,
	0x65, 0x0a, 0x11, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x69, 0x73, 0x73, 0x75, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x44, 0x0a, 0x1a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x50, 0x0a, 0x1b,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03,
	0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x72, 0x72, 0x22, 0xda,
	0x01, 0x0a, 0x10, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x2b, 0x0a, 0x11,
	0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0e, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x72, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x5c, 0x0a, 0x1e, 0x44,
	0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x72, 0x65, 0x71, 0x50, 0x61, 0x74, 0x68, 0x22, 0x54, 0x0a, 0x1c, 0x44, 0x65, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x03, 0x72, 0x65, 0x71,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x03, 0x72, 0x65, 0x71, 0x22,
	0x8e, 0x01, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x6f, 0x72, 0x74,
	0x12, 0x3e, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x62, 0x2e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x22, 0xbb, 0x04, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d,
	0x0a, 0x12, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x68, 0x61, 0x6e, 0x64,
	0x73, 0x68, 0x61, 0x6b, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x64, 0x69, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x64, 0x69, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0b, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x12,
	0x2f, 0x0a, 0x13, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6e, 0x65,
	0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x12, 0x41, 0x0a, 0x1d, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x69, 0x73, 0x5f, 0x6d, 0x75, 0x74, 0x75, 0x61,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x49, 0x73, 0x4d, 0x75, 0x74,
	0x75, 0x61, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x11, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x70, 0x62, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x10, 0x70, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0f, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x70, 0x62, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x1d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x1b, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6f, 0x63,
	0x73, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0c, 0x6f, 0x63, 0x73, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x6c, 0x73, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x09, 0x74, 0x6c, 0x73, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x22, 0x2a,
	0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x61, 0x73, 0x6e, 0x31, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x08, 0x61, 0x73, 0x6e, 0x31, 0x44, 0x61, 0x74, 0x61, 0x22, 0x47, 0x0a, 0x10, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x33,
	0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x70, 0x62, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x73, 0x22, 0x5b, 0x0a, 0x10, 0x53, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x22, 0x72, 0x0a, 0x18, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x10,
	0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x32, 0xa5, 0x03, 0x0a, 0x07, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x12, 0x3e, 0x0a, 0x0d, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x15, 0x2e, 0x70, 0x62, 0x2e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x16, 0x2e, 0x70, 0x62, 0x2e, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x12, 0x30, 0x0a, 0x0c, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x73,
	0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x15, 0x2e, 0x70, 0x62,
	0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x53, 0x0a, 0x14, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x45, 0x78, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x1c, 0x2e, 0x70, 0x62, 0x2e,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x45, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x1d, 0x2e, 0x70, 0x62, 0x2e, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x45, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x1f, 0x0a, 0x07, 0x43, 0x6c, 0x65, 0x61, 0x6e,
	0x75, 0x70, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x09, 0x2e,
	0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x31, 0x0a, 0x0d, 0x49, 0x6e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x2e, 0x70, 0x62, 0x2e, 0x49,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x41, 0x72, 0x67, 0x73,
	0x1a, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x26, 0x0a, 0x05, 0x53,
	0x65, 0x74, 0x75, 0x70, 0x12, 0x0d, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x41,
	0x72, 0x67, 0x73, 0x1a, 0x0e, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65,
	0x70, 0x6c, 0x79, 0x12, 0x35, 0x0a, 0x0a, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x12, 0x12, 0x2e, 0x70, 0x62, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x20, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x0d, 0x2e,
	0x70, 0x62, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x32, 0xd5, 0x01, 0x0a,
	0x07, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x14, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x2e, 0x0a, 0x03, 0x47,
	0x65, 0x74, 0x12, 0x12, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x47,
	0x65, 0x74, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x2e, 0x0a, 0x03, 0x50,
	0x75, 0x74, 0x12, 0x12, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x75, 0x74, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x75, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x37, 0x0a, 0x06, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x15, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x16, 0x2e, 0x70,
	0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x32, 0xa7, 0x08, 0x0a, 0x0a, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x2a, 0x0a, 0x0f, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x54, 0x54, 0x4c, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x1a, 0x0c, 0x2e, 0x70, 0x62, 0x2e, 0x54, 0x54, 0x4c, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12,
	0x26, 0x0a, 0x0b, 0x4d, 0x61, 0x78, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x54, 0x54, 0x4c, 0x12, 0x09,
	0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x0c, 0x2e, 0x70, 0x62, 0x2e, 0x54,
	0x54, 0x4c, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x26, 0x0a, 0x07, 0x54, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x64, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x10, 0x2e,
	0x70, 0x62, 0x2e, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12,
	0x36, 0x0a, 0x0f, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x18, 0x2e,
	0x70, 0x62, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x38, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x09, 0x2e, 0x70, 0x62,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x19, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x12, 0x47, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72, 0x61,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x12, 0x18, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x57, 0x72, 0x61, 0x70, 0x44, 0x61, 0x74, 0x61, 0x41, 0x72, 0x67, 0x73, 0x1a,
	0x19, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72, 0x61,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x30, 0x0a, 0x0c, 0x4d, 0x6c,
	0x6f, 0x63, 0x6b, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x15, 0x2e, 0x70, 0x62, 0x2e, 0x4d, 0x6c, 0x6f, 0x63, 0x6b,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x2c, 0x0a, 0x0a,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x35, 0x0a, 0x0a, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x41, 0x72, 0x67, 0x73, 0x1a, 0x13, 0x2e, 0x70,
	0x62, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x12, 0x2a, 0x0a, 0x09, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x45, 0x6e, 0x76, 0x12, 0x09,
	0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x12, 0x2e, 0x70, 0x62, 0x2e, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x45, 0x6e, 0x76, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x3f, 0x0a,
	0x0f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x46, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x12, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f,
	0x41, 0x72, 0x67, 0x73, 0x1a, 0x18, 0x2e, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x46, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x68,
	0x0a, 0x1a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x2e, 0x70,
	0x62, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x2e, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x1a, 0x14, 0x2e, 0x70, 0x62, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x5c, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x2e, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x70, 0x62, 0x2e, 0x52,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x12, 0x56, 0x0a, 0x13, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x1e, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x15, 0x44, 0x65, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x20, 0x2e, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x32, 0x36,
	0x0a, 0x06, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x09, 0x53, 0x65, 0x6e, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x09, 0x2e, 0x70, 0x62,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x32, 0x4c, 0x0a, 0x0c, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x2e, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x42, 0x2a, 0x5a, 0x28, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x76, 0x61, 0x75,
	0x6c, 0x74, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_sdk_plugin_pb_backend_proto_rawDescOnce sync.Once
	file_sdk_plugin_pb_backend_proto_rawDescData []byte
)

func file_sdk_plugin_pb_backend_proto_rawDescGZIP() []byte {
	file_sdk_plugin_pb_backend_proto_rawDescOnce.Do(func() {
		file_sdk_plugin_pb_backend_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_sdk_plugin_pb_backend_proto_rawDesc), len(file_sdk_plugin_pb_backend_proto_rawDesc)))
	})
	return file_sdk_plugin_pb_backend_proto_rawDescData
}

var file_sdk_plugin_pb_backend_proto_msgTypes = make([]protoimpl.MessageInfo, 68)
var file_sdk_plugin_pb_backend_proto_goTypes = []any{
	(*Empty)(nil),                             // 0: pb.Empty
	(*Header)(nil),                            // 1: pb.Header
	(*ProtoError)(nil),                        // 2: pb.ProtoError
	(*Paths)(nil),                             // 3: pb.Paths
	(*Request)(nil),                           // 4: pb.Request
	(*Auth)(nil),                              // 5: pb.Auth
	(*TokenEntry)(nil),                        // 6: pb.TokenEntry
	(*LeaseOptions)(nil),                      // 7: pb.LeaseOptions
	(*Secret)(nil),                            // 8: pb.Secret
	(*Response)(nil),                          // 9: pb.Response
	(*ResponseWrapInfo)(nil),                  // 10: pb.ResponseWrapInfo
	(*RequestWrapInfo)(nil),                   // 11: pb.RequestWrapInfo
	(*HandleRequestArgs)(nil),                 // 12: pb.HandleRequestArgs
	(*HandleRequestReply)(nil),                // 13: pb.HandleRequestReply
	(*InitializeArgs)(nil),                    // 14: pb.InitializeArgs
	(*InitializeReply)(nil),                   // 15: pb.InitializeReply
	(*SpecialPathsReply)(nil),                 // 16: pb.SpecialPathsReply
	(*HandleExistenceCheckArgs)(nil),          // 17: pb.HandleExistenceCheckArgs
	(*HandleExistenceCheckReply)(nil),         // 18: pb.HandleExistenceCheckReply
	(*SetupArgs)(nil),                         // 19: pb.SetupArgs
	(*SetupReply)(nil),                        // 20: pb.SetupReply
	(*TypeReply)(nil),                         // 21: pb.TypeReply
	(*InvalidateKeyArgs)(nil),                 // 22: pb.InvalidateKeyArgs
	(*StorageEntry)(nil),                      // 23: pb.StorageEntry
	(*StorageListArgs)(nil),                   // 24: pb.StorageListArgs
	(*StorageListReply)(nil),                  // 25: pb.StorageListReply
	(*StorageGetArgs)(nil),                    // 26: pb.StorageGetArgs
	(*StorageGetReply)(nil),                   // 27: pb.StorageGetReply
	(*StoragePutArgs)(nil),                    // 28: pb.StoragePutArgs
	(*StoragePutReply)(nil),                   // 29: pb.StoragePutReply
	(*StorageDeleteArgs)(nil),                 // 30: pb.StorageDeleteArgs
	(*StorageDeleteReply)(nil),                // 31: pb.StorageDeleteReply
	(*TTLReply)(nil),                          // 32: pb.TTLReply
	(*TaintedReply)(nil),                      // 33: pb.TaintedReply
	(*CachingDisabledReply)(nil),              // 34: pb.CachingDisabledReply
	(*ReplicationStateReply)(nil),             // 35: pb.ReplicationStateReply
	(*ResponseWrapDataArgs)(nil),              // 36: pb.ResponseWrapDataArgs
	(*ResponseWrapDataReply)(nil),             // 37: pb.ResponseWrapDataReply
	(*MlockEnabledReply)(nil),                 // 38: pb.MlockEnabledReply
	(*LocalMountReply)(nil),                   // 39: pb.LocalMountReply
	(*EntityInfoArgs)(nil),                    // 40: pb.EntityInfoArgs
	(*EntityInfoReply)(nil),                   // 41: pb.EntityInfoReply
	(*GroupsForEntityReply)(nil),              // 42: pb.GroupsForEntityReply
	(*PluginEnvReply)(nil),                    // 43: pb.PluginEnvReply
	(*GeneratePasswordFromPolicyRequest)(nil), // 44: pb.GeneratePasswordFromPolicyRequest
	(*GeneratePasswordFromPolicyReply)(nil),   // 45: pb.GeneratePasswordFromPolicyReply
	(*ClusterInfoReply)(nil),                  // 46: pb.ClusterInfoReply
	(*GenerateIdentityTokenRequest)(nil),      // 47: pb.GenerateIdentityTokenRequest
	(*GenerateIdentityTokenResponse)(nil),     // 48: pb.GenerateIdentityTokenResponse
	(*RotationInfoRequest)(nil),               // 49: pb.RotationInfoRequest
	(*RotationInfoReply)(nil),                 // 50: pb.RotationInfoReply
	(*RegisterRotationJobRequest)(nil),        // 51: pb.RegisterRotationJobRequest
	(*RegisterRotationJobResponse)(nil),       // 52: pb.RegisterRotationJobResponse
	(*RotationJobInput)(nil),                  // 53: pb.RotationJobInput
	(*DeregisterRotationRequestInput)(nil),    // 54: pb.DeregisterRotationRequestInput
	(*DeregisterRotationJobRequest)(nil),      // 55: pb.DeregisterRotationJobRequest
	(*Connection)(nil),                        // 56: pb.Connection
	(*ConnectionState)(nil),                   // 57: pb.ConnectionState
	(*Certificate)(nil),                       // 58: pb.Certificate
	(*CertificateChain)(nil),                  // 59: pb.CertificateChain
	(*SendEventRequest)(nil),                  // 60: pb.SendEventRequest
	(*RecordObservationRequest)(nil),          // 61: pb.RecordObservationRequest
	nil,                                       // 62: pb.Request.HeadersEntry
	nil,                                       // 63: pb.Auth.MetadataEntry
	nil,                                       // 64: pb.TokenEntry.MetaEntry
	nil,                                       // 65: pb.TokenEntry.InternalMetaEntry
	nil,                                       // 66: pb.Response.HeadersEntry
	nil,                                       // 67: pb.SetupArgs.ConfigEntry
	(*logical.Alias)(nil),                     // 68: logical.Alias
	(*timestamppb.Timestamp)(nil),             // 69: google.protobuf.Timestamp
	(*logical.Entity)(nil),                    // 70: logical.Entity
	(*logical.Group)(nil),                     // 71: logical.Group
	(*logical.PluginEnvironment)(nil),         // 72: logical.PluginEnvironment
	(*logical.EventData)(nil),                 // 73: logical.EventData
	(*structpb.Struct)(nil),                   // 74: google.protobuf.Struct
}
var file_sdk_plugin_pb_backend_proto_depIDxs = []int32{
	8,  // 0: pb.Request.secret:type_name -> pb.Secret
	5,  // 1: pb.Request.auth:type_name -> pb.Auth
	62, // 2: pb.Request.headers:type_name -> pb.Request.HeadersEntry
	11, // 3: pb.Request.wrap_info:type_name -> pb.RequestWrapInfo
	56, // 4: pb.Request.connection:type_name -> pb.Connection
	7,  // 5: pb.Auth.lease_options:type_name -> pb.LeaseOptions
	63, // 6: pb.Auth.metadata:type_name -> pb.Auth.MetadataEntry
	68, // 7: pb.Auth.alias:type_name -> logical.Alias
	68, // 8: pb.Auth.group_aliases:type_name -> logical.Alias
	64, // 9: pb.TokenEntry.meta:type_name -> pb.TokenEntry.MetaEntry
	65, // 10: pb.TokenEntry.internal_meta:type_name -> pb.TokenEntry.InternalMetaEntry
	69, // 11: pb.LeaseOptions.issue_time:type_name -> google.protobuf.Timestamp
	7,  // 12: pb.Secret.lease_options:type_name -> pb.LeaseOptions
	8,  // 13: pb.Response.secret:type_name -> pb.Secret
	5,  // 14: pb.Response.auth:type_name -> pb.Auth
	10, // 15: pb.Response.wrap_info:type_name -> pb.ResponseWrapInfo
	66, // 16: pb.Response.headers:type_name -> pb.Response.HeadersEntry
	69, // 17: pb.ResponseWrapInfo.creation_time:type_name -> google.protobuf.Timestamp
	4,  // 18: pb.HandleRequestArgs.request:type_name -> pb.Request
	9,  // 19: pb.HandleRequestReply.response:type_name -> pb.Response
	2,  // 20: pb.HandleRequestReply.err:type_name -> pb.ProtoError
	2,  // 21: pb.InitializeReply.err:type_name -> pb.ProtoError
	3,  // 22: pb.SpecialPathsReply.paths:type_name -> pb.Paths
	4,  // 23: pb.HandleExistenceCheckArgs.request:type_name -> pb.Request
	2,  // 24: pb.HandleExistenceCheckReply.err:type_name -> pb.ProtoError
	67, // 25: pb.SetupArgs.Config:type_name -> pb.SetupArgs.ConfigEntry
	23, // 26: pb.StorageGetReply.entry:type_name -> pb.StorageEntry
	23, // 27: pb.StoragePutArgs.entry:type_name -> pb.StorageEntry
	10, // 28: pb.ResponseWrapDataReply.wrap_info:type_name -> pb.ResponseWrapInfo
	70, // 29: pb.EntityInfoReply.entity:type_name -> logical.Entity
	71, // 30: pb.GroupsForEntityReply.groups:type_name -> logical.Group
	72, // 31: pb.PluginEnvReply.plugin_environment:type_name -> logical.PluginEnvironment
	53, // 32: pb.RegisterRotationJobRequest.job:type_name -> pb.RotationJobInput
	54, // 33: pb.DeregisterRotationJobRequest.req:type_name -> pb.DeregisterRotationRequestInput
	57, // 34: pb.Connection.connection_state:type_name -> pb.ConnectionState
	59, // 35: pb.ConnectionState.peer_certificates:type_name -> pb.CertificateChain
	59, // 36: pb.ConnectionState.verified_chains:type_name -> pb.CertificateChain
	58, // 37: pb.CertificateChain.certificates:type_name -> pb.Certificate
	73, // 38: pb.SendEventRequest.event:type_name -> logical.EventData
	74, // 39: pb.RecordObservationRequest.data:type_name -> google.protobuf.Struct
	1,  // 40: pb.Request.HeadersEntry.value:type_name -> pb.Header
	1,  // 41: pb.Response.HeadersEntry.value:type_name -> pb.Header
	12, // 42: pb.Backend.HandleRequest:input_type -> pb.HandleRequestArgs
	0,  // 43: pb.Backend.SpecialPaths:input_type -> pb.Empty
	17, // 44: pb.Backend.HandleExistenceCheck:input_type -> pb.HandleExistenceCheckArgs
	0,  // 45: pb.Backend.Cleanup:input_type -> pb.Empty
	22, // 46: pb.Backend.InvalidateKey:input_type -> pb.InvalidateKeyArgs
	19, // 47: pb.Backend.Setup:input_type -> pb.SetupArgs
	14, // 48: pb.Backend.Initialize:input_type -> pb.InitializeArgs
	0,  // 49: pb.Backend.Type:input_type -> pb.Empty
	24, // 50: pb.Storage.List:input_type -> pb.StorageListArgs
	26, // 51: pb.Storage.Get:input_type -> pb.StorageGetArgs
	28, // 52: pb.Storage.Put:input_type -> pb.StoragePutArgs
	30, // 53: pb.Storage.Delete:input_type -> pb.StorageDeleteArgs
	0,  // 54: pb.SystemView.DefaultLeaseTTL:input_type -> pb.Empty
	0,  // 55: pb.SystemView.MaxLeaseTTL:input_type -> pb.Empty
	0,  // 56: pb.SystemView.Tainted:input_type -> pb.Empty
	0,  // 57: pb.SystemView.CachingDisabled:input_type -> pb.Empty
	0,  // 58: pb.SystemView.ReplicationState:input_type -> pb.Empty
	36, // 59: pb.SystemView.ResponseWrapData:input_type -> pb.ResponseWrapDataArgs
	0,  // 60: pb.SystemView.MlockEnabled:input_type -> pb.Empty
	0,  // 61: pb.SystemView.LocalMount:input_type -> pb.Empty
	40, // 62: pb.SystemView.EntityInfo:input_type -> pb.EntityInfoArgs
	0,  // 63: pb.SystemView.PluginEnv:input_type -> pb.Empty
	40, // 64: pb.SystemView.GroupsForEntity:input_type -> pb.EntityInfoArgs
	44, // 65: pb.SystemView.GeneratePasswordFromPolicy:input_type -> pb.GeneratePasswordFromPolicyRequest
	0,  // 66: pb.SystemView.ClusterInfo:input_type -> pb.Empty
	47, // 67: pb.SystemView.GenerateIdentityToken:input_type -> pb.GenerateIdentityTokenRequest
	49, // 68: pb.SystemView.GetRotationInformation:input_type -> pb.RotationInfoRequest
	51, // 69: pb.SystemView.RegisterRotationJob:input_type -> pb.RegisterRotationJobRequest
	55, // 70: pb.SystemView.DeregisterRotationJob:input_type -> pb.DeregisterRotationJobRequest
	60, // 71: pb.Events.SendEvent:input_type -> pb.SendEventRequest
	61, // 72: pb.Observations.RecordObservation:input_type -> pb.RecordObservationRequest
	13, // 73: pb.Backend.HandleRequest:output_type -> pb.HandleRequestReply
	16, // 74: pb.Backend.SpecialPaths:output_type -> pb.SpecialPathsReply
	18, // 75: pb.Backend.HandleExistenceCheck:output_type -> pb.HandleExistenceCheckReply
	0,  // 76: pb.Backend.Cleanup:output_type -> pb.Empty
	0,  // 77: pb.Backend.InvalidateKey:output_type -> pb.Empty
	20, // 78: pb.Backend.Setup:output_type -> pb.SetupReply
	15, // 79: pb.Backend.Initialize:output_type -> pb.InitializeReply
	21, // 80: pb.Backend.Type:output_type -> pb.TypeReply
	25, // 81: pb.Storage.List:output_type -> pb.StorageListReply
	27, // 82: pb.Storage.Get:output_type -> pb.StorageGetReply
	29, // 83: pb.Storage.Put:output_type -> pb.StoragePutReply
	31, // 84: pb.Storage.Delete:output_type -> pb.StorageDeleteReply
	32, // 85: pb.SystemView.DefaultLeaseTTL:output_type -> pb.TTLReply
	32, // 86: pb.SystemView.MaxLeaseTTL:output_type -> pb.TTLReply
	33, // 87: pb.SystemView.Tainted:output_type -> pb.TaintedReply
	34, // 88: pb.SystemView.CachingDisabled:output_type -> pb.CachingDisabledReply
	35, // 89: pb.SystemView.ReplicationState:output_type -> pb.ReplicationStateReply
	37, // 90: pb.SystemView.ResponseWrapData:output_type -> pb.ResponseWrapDataReply
	38, // 91: pb.SystemView.MlockEnabled:output_type -> pb.MlockEnabledReply
	39, // 92: pb.SystemView.LocalMount:output_type -> pb.LocalMountReply
	41, // 93: pb.SystemView.EntityInfo:output_type -> pb.EntityInfoReply
	43, // 94: pb.SystemView.PluginEnv:output_type -> pb.PluginEnvReply
	42, // 95: pb.SystemView.GroupsForEntity:output_type -> pb.GroupsForEntityReply
	45, // 96: pb.SystemView.GeneratePasswordFromPolicy:output_type -> pb.GeneratePasswordFromPolicyReply
	46, // 97: pb.SystemView.ClusterInfo:output_type -> pb.ClusterInfoReply
	48, // 98: pb.SystemView.GenerateIdentityToken:output_type -> pb.GenerateIdentityTokenResponse
	50, // 99: pb.SystemView.GetRotationInformation:output_type -> pb.RotationInfoReply
	52, // 100: pb.SystemView.RegisterRotationJob:output_type -> pb.RegisterRotationJobResponse
	0,  // 101: pb.SystemView.DeregisterRotationJob:output_type -> pb.Empty
	0,  // 102: pb.Events.SendEvent:output_type -> pb.Empty
	0,  // 103: pb.Observations.RecordObservation:output_type -> pb.Empty
	73, // [73:104] is the sub-list for method output_type
	42, // [42:73] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_sdk_plugin_pb_backend_proto_init() }
func file_sdk_plugin_pb_backend_proto_init() {
	if File_sdk_plugin_pb_backend_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_sdk_plugin_pb_backend_proto_rawDesc), len(file_sdk_plugin_pb_backend_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   68,
			NumExtensions: 0,
			NumServices:   5,
		},
		GoTypes:           file_sdk_plugin_pb_backend_proto_goTypes,
		DependencyIndexes: file_sdk_plugin_pb_backend_proto_depIDxs,
		MessageInfos:      file_sdk_plugin_pb_backend_proto_msgTypes,
	}.Build()
	File_sdk_plugin_pb_backend_proto = out.File
	file_sdk_plugin_pb_backend_proto_goTypes = nil
	file_sdk_plugin_pb_backend_proto_depIDxs = nil
}
