/* umockdev-utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from umockdev-utils.vala, do not modify */

#define _GNU_SOURCE

#include "umockdev-utils.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <signal.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/select.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN GPid umockdev_utils_process_under_test;
GPid umockdev_utils_process_under_test = 0;
VALA_EXTERN GChildWatchFunc umockdev_utils_process_under_test_watch_cb;
VALA_EXTERN gpointer umockdev_utils_process_under_test_watch_cb_target;
VALA_EXTERN GDestroyNotify umockdev_utils_process_under_test_watch_cb_target_destroy_notify;
GChildWatchFunc umockdev_utils_process_under_test_watch_cb = NULL;
gpointer umockdev_utils_process_under_test_watch_cb_target = NULL;
GDestroyNotify umockdev_utils_process_under_test_watch_cb_target_destroy_notify = NULL;

VALA_EXTERN void umockdev_utils_pud_sig_handler (gint sig);
VALA_EXTERN void umockdev_utils_pud_watch_cb (GPid pid,
                                  gint status);
static void _umockdev_utils_pud_sig_handler_sighandler_t (gint signal);
static void _umockdev_utils_pud_watch_cb_gchild_watch_func (GPid pid,
                                                     gint wait_status,
                                                     gpointer self);

void
umockdev_utils_checked_setenv (const gchar* variable,
                               const gchar* value)
{
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	if (!g_setenv (variable, value, TRUE)) {
		g_error ("umockdev-utils.vala:8: Failed to set env variable %s", variable);
	}
}

void
umockdev_utils_checked_remove (const gchar* path)
{
	g_return_if_fail (path != NULL);
	if (g_remove (path) < 0) {
		g_error ("umockdev-utils.vala:16: cannot remove %s: %m", path);
	}
}

void
umockdev_utils_remove_dir (const gchar* path,
                           gboolean remove_toplevel)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	if (g_file_test (path, G_FILE_TEST_IS_DIR)) {
		_tmp0_ = !g_file_test (path, G_FILE_TEST_IS_SYMLINK);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GDir* d = NULL;
		gchar* name = NULL;
		{
			GDir* _tmp1_ = NULL;
			GDir* _tmp2_;
			GDir* _tmp3_;
			_tmp2_ = g_dir_open (path, (guint) 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_dir_close0 (d);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_dir_close0 (d);
			d = _tmp3_;
			_g_dir_close0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("umockdev-utils.vala:28: cannot open: %s: %s", path, _tmp5_);
			_g_error_free0 (e);
			_g_dir_close0 (d);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		while (TRUE) {
			GDir* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp6_ = d;
			_tmp7_ = g_dir_read_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			_tmp9_ = name;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			_tmp10_ = name;
			_tmp11_ = g_build_filename (path, _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			umockdev_utils_remove_dir (_tmp12_, TRUE);
			_g_free0 (_tmp12_);
		}
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	if (remove_toplevel) {
		umockdev_utils_checked_remove (path);
	}
}

void
umockdev_utils_pud_sig_handler (gint sig)
{
	if (umockdev_utils_process_under_test == ((GPid) 0)) {
		return;
	}
	g_debug ("umockdev-utils.vala:50: umockdev: caught signal %i, propagating to chi" \
"ld\n", sig);
	if (kill ((pid_t) umockdev_utils_process_under_test, sig) != 0) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "umockdev: unable to propagate signal %i to child %i: %m\n", sig, (gint) umockdev_utils_process_under_test);
	}
}

void
umockdev_utils_pud_watch_cb (GPid pid,
                             gint status)
{
	GChildWatchFunc _tmp0_;
	gpointer _tmp0__target;
	_tmp0_ = umockdev_utils_process_under_test_watch_cb;
	_tmp0__target = umockdev_utils_process_under_test_watch_cb_target;
	if (_tmp0_ != NULL) {
		GChildWatchFunc _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = umockdev_utils_process_under_test_watch_cb;
		_tmp1__target = umockdev_utils_process_under_test_watch_cb_target;
		_tmp1_ (pid, status, _tmp1__target);
	}
	g_spawn_close_pid (umockdev_utils_process_under_test);
	umockdev_utils_process_under_test = (GPid) 0;
	(umockdev_utils_process_under_test_watch_cb_target_destroy_notify == NULL) ? NULL : (umockdev_utils_process_under_test_watch_cb_target_destroy_notify (umockdev_utils_process_under_test_watch_cb_target), NULL);
	umockdev_utils_process_under_test_watch_cb = NULL;
	umockdev_utils_process_under_test_watch_cb_target = NULL;
	umockdev_utils_process_under_test_watch_cb_target_destroy_notify = NULL;
	umockdev_utils_process_under_test_watch_cb = NULL;
	umockdev_utils_process_under_test_watch_cb_target = NULL;
	umockdev_utils_process_under_test_watch_cb_target_destroy_notify = NULL;
}

static void
_umockdev_utils_pud_sig_handler_sighandler_t (gint signal)
{
	umockdev_utils_pud_sig_handler (signal);
}

static void
_umockdev_utils_pud_watch_cb_gchild_watch_func (GPid pid,
                                                gint wait_status,
                                                gpointer self)
{
	umockdev_utils_pud_watch_cb (pid, wait_status);
}

GPid
umockdev_utils_spawn_process_under_test (gchar** argv,
                                         gint argv_length1,
                                         GChildWatchFunc watch_cb,
                                         gpointer watch_cb_target,
                                         GDestroyNotify watch_cb_target_destroy_notify,
                                         GError** error)
{
	GPid _tmp0_ = 0;
	struct sigaction act = {0};
	struct sigaction _tmp3_ = {0};
	sigset_t _tmp4_ = {0};
	struct sigaction _tmp5_;
	struct sigaction _tmp6_;
	struct sigaction _tmp7_;
	struct sigaction _tmp8_;
	struct sigaction _tmp9_;
	GChildWatchFunc _tmp10_;
	gpointer _tmp10__target;
	GDestroyNotify _tmp10__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	GPid result;
	_vala_assert (umockdev_utils_process_under_test == ((GPid) 0), "process_under_test == 0");
	g_spawn_async (NULL, argv, NULL, (G_SPAWN_SEARCH_PATH | G_SPAWN_CHILD_INHERITS_STDIN) | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp0_, &_inner_error0_);
	umockdev_utils_process_under_test = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_SPAWN_ERROR) {
			GPid _tmp1_ = 0;
			g_propagate_error (error, _inner_error0_);
			(watch_cb_target_destroy_notify == NULL) ? NULL : (watch_cb_target_destroy_notify (watch_cb_target), NULL);
			watch_cb = NULL;
			watch_cb_target = NULL;
			watch_cb_target_destroy_notify = NULL;
			return _tmp1_;
		} else {
			GPid _tmp2_ = 0;
			(watch_cb_target_destroy_notify == NULL) ? NULL : (watch_cb_target_destroy_notify (watch_cb_target), NULL);
			watch_cb = NULL;
			watch_cb_target = NULL;
			watch_cb_target_destroy_notify = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	memset (&_tmp3_, 0, sizeof (struct sigaction));
	_tmp3_.sa_handler = _umockdev_utils_pud_sig_handler_sighandler_t;
	_tmp3_.sa_flags = SA_RESETHAND;
	act = _tmp3_;
	sigemptyset (&_tmp4_);
	act.sa_mask = _tmp4_;
	_tmp5_ = act;
	_vala_assert (sigaction ((gint) SIGTERM, &_tmp5_, NULL) == 0, "Posix.sigaction (Posix.Signal.TERM, act, null) == 0");
	_tmp6_ = act;
	_vala_assert (sigaction ((gint) SIGHUP, &_tmp6_, NULL) == 0, "Posix.sigaction (Posix.Signal.HUP, act, null) == 0");
	_tmp7_ = act;
	_vala_assert (sigaction ((gint) SIGINT, &_tmp7_, NULL) == 0, "Posix.sigaction (Posix.Signal.INT, act, null) == 0");
	_tmp8_ = act;
	_vala_assert (sigaction ((gint) SIGQUIT, &_tmp8_, NULL) == 0, "Posix.sigaction (Posix.Signal.QUIT, act, null) == 0");
	_tmp9_ = act;
	_vala_assert (sigaction ((gint) SIGABRT, &_tmp9_, NULL) == 0, "Posix.sigaction (Posix.Signal.ABRT, act, null) == 0");
	_tmp10_ = watch_cb;
	_tmp10__target = watch_cb_target;
	_tmp10__target_destroy_notify = watch_cb_target_destroy_notify;
	watch_cb = NULL;
	watch_cb_target = NULL;
	watch_cb_target_destroy_notify = NULL;
	(umockdev_utils_process_under_test_watch_cb_target_destroy_notify == NULL) ? NULL : (umockdev_utils_process_under_test_watch_cb_target_destroy_notify (umockdev_utils_process_under_test_watch_cb_target), NULL);
	umockdev_utils_process_under_test_watch_cb = NULL;
	umockdev_utils_process_under_test_watch_cb_target = NULL;
	umockdev_utils_process_under_test_watch_cb_target_destroy_notify = NULL;
	umockdev_utils_process_under_test_watch_cb = _tmp10_;
	umockdev_utils_process_under_test_watch_cb_target = _tmp10__target;
	umockdev_utils_process_under_test_watch_cb_target_destroy_notify = _tmp10__target_destroy_notify;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, umockdev_utils_process_under_test, _umockdev_utils_pud_watch_cb_gchild_watch_func, NULL, NULL);
	result = umockdev_utils_process_under_test;
	(watch_cb_target_destroy_notify == NULL) ? NULL : (watch_cb_target_destroy_notify (watch_cb_target), NULL);
	watch_cb = NULL;
	watch_cb_target = NULL;
	watch_cb_target_destroy_notify = NULL;
	return result;
}

