/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_SERVER_PROTOCOL_H
#define TREELAND_SHORTCUT_MANAGER_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_shortcut_manager_v2 The treeland_shortcut_manager_v2 protocol
 * @section page_ifaces_treeland_shortcut_manager_v2 Interfaces
 * - @subpage page_iface_treeland_shortcut_manager_v2 - global shortcuts manager for treeland
 * @section page_copyright_treeland_shortcut_manager_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024-2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_shortcut_manager_v2;

#ifndef TREELAND_SHORTCUT_MANAGER_V2_INTERFACE
#define TREELAND_SHORTCUT_MANAGER_V2_INTERFACE
/**
 * @page page_iface_treeland_shortcut_manager_v2 treeland_shortcut_manager_v2
 * @section page_iface_treeland_shortcut_manager_v2_desc Description
 *
 * This interface allows privileged clients to register global shortcuts.
 *
 * In treeland, global shortcuts are managed in a per-user context.
 * Shortcuts for different users are isolated, and will not interfere with each other.
 * This allows multiple users to use their own set of global Shortcuts
 * on the same system without conflicts.
 * This behavior is transparent to the clients of this interface (i.e 
 * the user context used by this protocol is the same as that of the client.)
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_shortcut_manager_v2_api API
 * See @ref iface_treeland_shortcut_manager_v2.
 */
/**
 * @defgroup iface_treeland_shortcut_manager_v2 The treeland_shortcut_manager_v2 interface
 *
 * This interface allows privileged clients to register global shortcuts.
 *
 * In treeland, global shortcuts are managed in a per-user context.
 * Shortcuts for different users are isolated, and will not interfere with each other.
 * This allows multiple users to use their own set of global Shortcuts
 * on the same system without conflicts.
 * This behavior is transparent to the clients of this interface (i.e 
 * the user context used by this protocol is the same as that of the client.)
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_shortcut_manager_v2_interface;
#endif

#ifndef TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM
enum treeland_shortcut_manager_v2_direction {
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_DOWN = 1,
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_LEFT = 2,
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_UP = 3,
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_RIGHT = 4,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM_IS_VALID
#define TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Validate a treeland_shortcut_manager_v2 direction value.
 *
 * @return true on success, false on error.
 * @ref treeland_shortcut_manager_v2_direction
 */
static inline bool
treeland_shortcut_manager_v2_direction_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_DOWN:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_LEFT:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_UP:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_RIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM_IS_VALID */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * compositor actions
 *
 * Compositor actions that can be assigned to a shortcut.
 */
enum treeland_shortcut_manager_v2_action {
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_NOTIFY = 1,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_1 = 2,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_2 = 3,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_3 = 4,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_4 = 5,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_5 = 6,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_6 = 7,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_PREV_WORKSPACE = 8,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_NEXT_WORKSPACE = 9,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHOW_DESKTOP = 10,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_MAXIMIZE = 11,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_CANCEL_MAXIMIZE = 12,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_MOVE_WINDOW = 13,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_CLOSE_WINDOW = 14,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHOW_WINDOW_MENU = 15,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_OPEN_MULTITASK_VIEW = 16,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_CLOSE_MULTITASK_VIEW = 17,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TOGGLE_MULTITASK_VIEW = 18,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TOGGLE_FPS_DISPLAY = 19,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_LOCKSCREEN = 20,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHUTDOWN_MENU = 21,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_QUIT = 22,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_ENTER = 23,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_NEXT = 24,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_PREV = 25,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_SAMEAPP_NEXT = 26,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_SAMEAPP_PREV = 27,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM_IS_VALID
#define TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Validate a treeland_shortcut_manager_v2 action value.
 *
 * @return true on success, false on error.
 * @ref treeland_shortcut_manager_v2_action
 */
static inline bool
treeland_shortcut_manager_v2_action_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_NOTIFY:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_1:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_2:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_3:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_4:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_5:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_6:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_PREV_WORKSPACE:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_NEXT_WORKSPACE:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHOW_DESKTOP:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_MAXIMIZE:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_CANCEL_MAXIMIZE:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_MOVE_WINDOW:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_CLOSE_WINDOW:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHOW_WINDOW_MENU:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_OPEN_MULTITASK_VIEW:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_CLOSE_MULTITASK_VIEW:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TOGGLE_MULTITASK_VIEW:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TOGGLE_FPS_DISPLAY:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_LOCKSCREEN:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHUTDOWN_MENU:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_QUIT:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_ENTER:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_NEXT:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_PREV:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_SAMEAPP_NEXT:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_SAMEAPP_PREV:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM_IS_VALID */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_ENUM
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * keybinding modes
 *
 * Keybinding modes.
 */
enum treeland_shortcut_manager_v2_keybind_mode {
	TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_KEY_RELEASE = 1,
	TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_KEY_PRESS = 2,
	TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_KEY_PRESS_REPEAT = 3,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_ENUM_IS_VALID
#define TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Validate a treeland_shortcut_manager_v2 keybind_mode value.
 *
 * @return true on success, false on error.
 * @ref treeland_shortcut_manager_v2_keybind_mode
 */
static inline bool
treeland_shortcut_manager_v2_keybind_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_KEY_RELEASE:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_KEY_PRESS:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_KEY_PRESS_REPEAT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_MODE_ENUM_IS_VALID */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * binding error codes
 *
 * Error codes indicating the reason of a binding failure.
 */
enum treeland_shortcut_manager_v2_bind_error {
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_NAME_CONFLICT = 1,
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_DUPLICATE_BINDING = 2,
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_INVALID_ARGUMENT = 3,
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_INTERNAL_ERROR = 4,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM_IS_VALID
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Validate a treeland_shortcut_manager_v2 bind_error value.
 *
 * @return true on success, false on error.
 * @ref treeland_shortcut_manager_v2_bind_error
 */
static inline bool
treeland_shortcut_manager_v2_bind_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_NAME_CONFLICT:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_DUPLICATE_BINDING:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_INVALID_ARGUMENT:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_INTERNAL_ERROR:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM_IS_VALID */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM
enum treeland_shortcut_manager_v2_error {
	TREELAND_SHORTCUT_MANAGER_V2_ERROR_OCCUPIED = 1,
	TREELAND_SHORTCUT_MANAGER_V2_ERROR_NOT_ACQUIRED = 2,
	TREELAND_SHORTCUT_MANAGER_V2_ERROR_INVALID_COMMIT = 3,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM_IS_VALID
#define TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Validate a treeland_shortcut_manager_v2 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_shortcut_manager_v2_error
 */
static inline bool
treeland_shortcut_manager_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SHORTCUT_MANAGER_V2_ERROR_OCCUPIED:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ERROR_NOT_ACQUIRED:
		return version >= 1;
	case TREELAND_SHORTCUT_MANAGER_V2_ERROR_INVALID_COMMIT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * @struct treeland_shortcut_manager_v2_interface
 */
struct treeland_shortcut_manager_v2_interface {
	/**
	 * destroy the shortcut manager
	 *
	 * Destroy the shortcut manager. Existing shortcuts created
	 * through this interface remain valid.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * acquire the shortcut manager
	 *
	 * Acquire the shortcut manager for the current client.
	 *
	 * This request must be sent before any bind/unbind request can be
	 * performed.
	 *
	 * Only one client hold exclusive control of the shortcut manager
	 * at a time, for a given session. If the shortcut manager is
	 * already acquired by another client, an protocol error
	 */
	void (*acquire)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * bind a key sequence to a compositor action
	 *
	 * Bind a key sequence to a compositor action.
	 *
	 * The key sequence is specified in the string format used by
	 * QKeySequence, see
	 * https://doc.qt.io/qt-6/qkeysequence.html#toString for details.
	 *
	 * Sending this request without first acquiring the shortcut
	 * manager will result in a `not_acquired` protocol error.
	 *
	 * The name argument must be unique among all existing bindings. If
	 * a binding with the same name already exists, the bind_key
	 * request will fail.
	 *
	 * The action argument specifies the compositor action to be
	 * executed when the key sequence is activated.
	 *
	 * The protocol provides three keybinding modes: - key_release: the
	 * action is triggered when the key sequence is released. -
	 * key_press: the action is triggered when the key sequence is
	 * pressed. - key_press_repeat: the action is triggered when the
	 * key sequence is pressed, and repeatedly triggered if the key
	 * sequence is held down.
	 *
	 * If a binding with the same key sequence and action already
	 * exists, the bind_key request will fail.
	 *
	 * Note that the binding will not take effect until a commit
	 * request is sent.
	 * @param name unique name for the keybinding
	 * @param key key sequence for the keybinding
	 * @param mode mode for the keybinding
	 * @param action compositor action to be executed
	 */
	void (*bind_key)(struct wl_client *client,
			 struct wl_resource *resource,
			 const char *name,
			 const char *key,
			 uint32_t mode,
			 uint32_t action);
	/**
	 * bind a swipe gesture to a compositor action
	 *
	 * Bind a swipe gesture to a compositor action.
	 *
	 * Sending this request without first acquiring the shortcut
	 * manager will result in a `not_acquired` protocol error.
	 *
	 * The name argument must be unique among all existing bindings. If
	 * a binding with the same name already exists, the
	 * bind_swipe_gesture request will fail.
	 *
	 * The direction argument specifies the direction towards which the
	 * swipe gesture must be performed. If this argument is not one of
	 * the defined enum values, the bind_swipe_gesture request will
	 * fail.
	 *
	 * The action argument specifies the compositor action to be
	 * executed when the swipe gesture is activated. If a binding with
	 * the same gesture and action already exists, the
	 * bind_swipe_gesture request will fail.
	 *
	 * Note that the binding will not take effect until a commit
	 * request is sent.
	 * @param name unique name for the swipe gesture
	 * @param finger number of fingers required for the swipe gesture
	 * @param direction direction of the swipe gesture
	 * @param action compositor action to be executed
	 */
	void (*bind_swipe_gesture)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *name,
				   uint32_t finger,
				   uint32_t direction,
				   uint32_t action);
	/**
	 * bind a hold gesture to a compositor action
	 *
	 * Bind a hold gesture to a compositor action.
	 *
	 * Sending this request without first acquiring the shortcut
	 * manager will result in a `not_acquired` protocol error.
	 *
	 * The name argument must be unique among all existing bindings. If
	 * a binding with the same name already exists, the
	 * bind_hold_gesture request will fail.
	 *
	 * The action argument specifies the compositor action to be
	 * executed when the hold gesture is activated. If a binding with
	 * the same gesture and action already exists, the
	 * bind_hold_gesture request will fail.
	 *
	 * Note that the binding will not take effect until a commit
	 * request is sent.
	 * @param name unique name for the hold gesture
	 * @param finger number of fingers required for the hold gesture
	 * @param action compositor action to be executed
	 */
	void (*bind_hold_gesture)(struct wl_client *client,
				  struct wl_resource *resource,
				  const char *name,
				  uint32_t finger,
				  uint32_t action);
	/**
	 * commit the pending bindings
	 *
	 * Commit the pending bindings.
	 *
	 * This request applies all the bind_key, bind_swipe_gesture and
	 * bind_hold_gesture requests sent since the last commit.
	 *
	 * After processing this request, the compositor will emit a
	 * `commit_status` event if the commit was successful or
	 * `commit_failure` event if the commit failed.
	 *
	 * On a successful commit, all the pending bindings will take
	 * effect. On a failed commit, none of the pending bindings will
	 * take effect.
	 *
	 * Sending this request without first acquiring the shortcut
	 * manager will result in a `not_acquired` protocol error.
	 *
	 * Sending further commit requests before `commit_success` or
	 * `commit_failure` is sent is a protocol error.
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * remove an existing binding
	 *
	 * Remove an existing binding.
	 *
	 * The binding to be removed is identified by its unique name. If
	 * no binding with the specified name exists, the unbind request
	 * has no effect.
	 * @param name unique name of the binding to be removed
	 */
	void (*unbind)(struct wl_client *client,
		       struct wl_resource *resource,
		       const char *name);
};

#define TREELAND_SHORTCUT_MANAGER_V2_ACTIVATED 0
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_SUCCESS 1
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_FAILURE 2

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_ACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_SUCCESS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_FAILURE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_ACQUIRE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_SWIPE_GESTURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_HOLD_GESTURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_UNBIND_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Sends an activated event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name binding id of the activated shortcut
 * @param repeat indicates whether the shortcut activation is due to auto-repeat
 */
static inline void
treeland_shortcut_manager_v2_send_activated(struct wl_resource *resource_, const char *name, uint32_t repeat)
{
	wl_resource_post_event(resource_, TREELAND_SHORTCUT_MANAGER_V2_ACTIVATED, name, repeat);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Sends an commit_success event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_shortcut_manager_v2_send_commit_success(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_SHORTCUT_MANAGER_V2_COMMIT_SUCCESS);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * Sends an commit_failure event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name binding name that caused the failure
 * @param error error code indicating the reason of the failure
 */
static inline void
treeland_shortcut_manager_v2_send_commit_failure(struct wl_resource *resource_, const char *name, uint32_t error)
{
	wl_resource_post_event(resource_, TREELAND_SHORTCUT_MANAGER_V2_COMMIT_FAILURE, name, error);
}

#ifdef  __cplusplus
}
#endif

#endif
