/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// ServiceApplyConfiguration represents a declarative configuration of the Service type for use
// with apply.
type ServiceApplyConfiguration struct {
	LoadBalancerSpecApplyConfiguration `json:",inline"`
}

// ServiceApplyConfiguration constructs a declarative configuration of the Service type for use with
// apply.
func Service() *ServiceApplyConfiguration {
	return &ServiceApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithName(value string) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Name = &value
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithKind(value string) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Kind = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithNamespace(value string) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Namespace = &value
	return b
}

// WithSticky sets the Sticky field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Sticky field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithSticky(value dynamic.Sticky) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Sticky = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithPort(value intstr.IntOrString) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Port = &value
	return b
}

// WithScheme sets the Scheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scheme field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithScheme(value string) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Scheme = &value
	return b
}

// WithStrategy sets the Strategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Strategy field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithStrategy(value dynamic.BalancerStrategy) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Strategy = &value
	return b
}

// WithPassHostHeader sets the PassHostHeader field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PassHostHeader field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithPassHostHeader(value bool) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.PassHostHeader = &value
	return b
}

// WithResponseForwarding sets the ResponseForwarding field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResponseForwarding field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithResponseForwarding(value *ResponseForwardingApplyConfiguration) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.ResponseForwarding = value
	return b
}

// WithServersTransport sets the ServersTransport field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServersTransport field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithServersTransport(value string) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.ServersTransport = &value
	return b
}

// WithWeight sets the Weight field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Weight field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithWeight(value int) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.Weight = &value
	return b
}

// WithNativeLB sets the NativeLB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NativeLB field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithNativeLB(value bool) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.NativeLB = &value
	return b
}

// WithNodePortLB sets the NodePortLB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodePortLB field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithNodePortLB(value bool) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.NodePortLB = &value
	return b
}

// WithHealthCheck sets the HealthCheck field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HealthCheck field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithHealthCheck(value *ServerHealthCheckApplyConfiguration) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.HealthCheck = value
	return b
}

// WithPassiveHealthCheck sets the PassiveHealthCheck field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PassiveHealthCheck field is set to the value of the last call.
func (b *ServiceApplyConfiguration) WithPassiveHealthCheck(value *PassiveServerHealthCheckApplyConfiguration) *ServiceApplyConfiguration {
	b.LoadBalancerSpecApplyConfiguration.PassiveHealthCheck = value
	return b
}
