// python wrapper for ttkMergeTreePrincipalGeodesics
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreePrincipalGeodesics.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreePrincipalGeodesics(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreePrincipalGeodesics_ClassNew(); }


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalizedWasserstein(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetNormalizedWasserstein(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNormalizedWasserstein() :
      op->ttkMergeTreePrincipalGeodesics::GetNormalizedWasserstein());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetNumberOfGeodesics(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfGeodesics");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfGeodesics(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetNumberOfGeodesics(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetNumberOfGeodesics(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGeodesics");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfGeodesics() :
      op->ttkMergeTreePrincipalGeodesics::GetNumberOfGeodesics());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionIntervals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfProjectionIntervals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfProjectionIntervals(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetNumberOfProjectionIntervals(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetNumberOfProjectionIntervals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProjectionIntervals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfProjectionIntervals() :
      op->ttkMergeTreePrincipalGeodesics::GetNumberOfProjectionIntervals());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfProjectionSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfProjectionSteps(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetNumberOfProjectionSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetNumberOfProjectionSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProjectionSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfProjectionSteps() :
      op->ttkMergeTreePrincipalGeodesics::GetNumberOfProjectionSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetBarycenterSizeLimitPercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBarycenterSizeLimitPercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBarycenterSizeLimitPercent(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetBarycenterSizeLimitPercent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetBarycenterSizeLimitPercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBarycenterSizeLimitPercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBarycenterSizeLimitPercent() :
      op->ttkMergeTreePrincipalGeodesics::GetBarycenterSizeLimitPercent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeterministic(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetDeterministic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeterministic() :
      op->ttkMergeTreePrincipalGeodesics::GetDeterministic());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetJoinSplitMixtureCoefficient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetJoinSplitMixtureCoefficient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetJoinSplitMixtureCoefficient(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetJoinSplitMixtureCoefficient(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetJoinSplitMixtureCoefficient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetJoinSplitMixtureCoefficient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetJoinSplitMixtureCoefficient() :
      op->ttkMergeTreePrincipalGeodesics::GetJoinSplitMixtureCoefficient());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetKeepState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepState(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetKeepState(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetKeepState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetKeepState() :
      op->ttkMergeTreePrincipalGeodesics::GetKeepState());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon1UseFarthestSaddle(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetEpsilon1UseFarthestSaddle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEpsilon1UseFarthestSaddle() :
      op->ttkMergeTreePrincipalGeodesics::GetEpsilon1UseFarthestSaddle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetEpsilonTree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilonTree1(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetEpsilonTree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetEpsilonTree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilonTree1() :
      op->ttkMergeTreePrincipalGeodesics::GetEpsilonTree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon2Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetEpsilon2Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon2Tree1() :
      op->ttkMergeTreePrincipalGeodesics::GetEpsilon2Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon3Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetEpsilon3Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon3Tree1() :
      op->ttkMergeTreePrincipalGeodesics::GetEpsilon3Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPersistenceThreshold() :
      op->ttkMergeTreePrincipalGeodesics::GetPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeleteMultiPersPairs(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetDeleteMultiPersPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeleteMultiPersPairs() :
      op->ttkMergeTreePrincipalGeodesics::GetDeleteMultiPersPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SetComputeReconstructionError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeReconstructionError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeReconstructionError(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesics::SetComputeReconstructionError(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetComputeReconstructionError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeReconstructionError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeReconstructionError() :
      op->ttkMergeTreePrincipalGeodesics::GetComputeReconstructionError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreePrincipalGeodesics::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreePrincipalGeodesics::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreePrincipalGeodesics *tempr = ttkMergeTreePrincipalGeodesics::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreePrincipalGeodesics *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreePrincipalGeodesics::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreePrincipalGeodesics::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesics_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesics *op = static_cast<ttkMergeTreePrincipalGeodesics *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreePrincipalGeodesics::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreePrincipalGeodesics_Methods[] = {
  {"SetNormalizedWasserstein", PyttkMergeTreePrincipalGeodesics_SetNormalizedWasserstein, METH_VARARGS,
   "SetNormalizedWasserstein(self, nW:bool) -> None\nC++: void SetNormalizedWasserstein(bool nW)\n\nAutomatically generate getters and setters of filter parameters\nvia vtkMacros.\n"},
  {"GetNormalizedWasserstein", PyttkMergeTreePrincipalGeodesics_GetNormalizedWasserstein, METH_VARARGS,
   "GetNormalizedWasserstein(self) -> bool\nC++: bool GetNormalizedWasserstein()\n\n"},
  {"SetNumberOfGeodesics", PyttkMergeTreePrincipalGeodesics_SetNumberOfGeodesics, METH_VARARGS,
   "SetNumberOfGeodesics(self, numberOfGeodesics:int) -> None\nC++: void SetNumberOfGeodesics(unsigned int numberOfGeodesics)\n\n"},
  {"GetNumberOfGeodesics", PyttkMergeTreePrincipalGeodesics_GetNumberOfGeodesics, METH_VARARGS,
   "GetNumberOfGeodesics(self) -> int\nC++: unsigned int GetNumberOfGeodesics()\n\n"},
  {"SetNumberOfProjectionIntervals", PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionIntervals, METH_VARARGS,
   "SetNumberOfProjectionIntervals(self, intervals:int) -> None\nC++: void SetNumberOfProjectionIntervals(unsigned int intervals)\n\n"},
  {"GetNumberOfProjectionIntervals", PyttkMergeTreePrincipalGeodesics_GetNumberOfProjectionIntervals, METH_VARARGS,
   "GetNumberOfProjectionIntervals(self) -> int\nC++: unsigned int GetNumberOfProjectionIntervals()\n\n"},
  {"SetNumberOfProjectionSteps", PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionSteps, METH_VARARGS,
   "SetNumberOfProjectionSteps(self, steps:int) -> None\nC++: void SetNumberOfProjectionSteps(unsigned int steps)\n\n"},
  {"GetNumberOfProjectionSteps", PyttkMergeTreePrincipalGeodesics_GetNumberOfProjectionSteps, METH_VARARGS,
   "GetNumberOfProjectionSteps(self) -> int\nC++: unsigned int GetNumberOfProjectionSteps()\n\n"},
  {"SetBarycenterSizeLimitPercent", PyttkMergeTreePrincipalGeodesics_SetBarycenterSizeLimitPercent, METH_VARARGS,
   "SetBarycenterSizeLimitPercent(self, percent:float) -> None\nC++: void SetBarycenterSizeLimitPercent(double percent)\n\n"},
  {"GetBarycenterSizeLimitPercent", PyttkMergeTreePrincipalGeodesics_GetBarycenterSizeLimitPercent, METH_VARARGS,
   "GetBarycenterSizeLimitPercent(self) -> float\nC++: double GetBarycenterSizeLimitPercent()\n\n"},
  {"SetDeterministic", PyttkMergeTreePrincipalGeodesics_SetDeterministic, METH_VARARGS,
   "SetDeterministic(self, deterministic:bool) -> None\nC++: void SetDeterministic(bool deterministic)\n\n"},
  {"GetDeterministic", PyttkMergeTreePrincipalGeodesics_GetDeterministic, METH_VARARGS,
   "GetDeterministic(self) -> bool\nC++: bool GetDeterministic()\n\n"},
  {"SetJoinSplitMixtureCoefficient", PyttkMergeTreePrincipalGeodesics_SetJoinSplitMixtureCoefficient, METH_VARARGS,
   "SetJoinSplitMixtureCoefficient(self,\n    joinSplitMixtureCoefficient:float) -> None\nC++: void SetJoinSplitMixtureCoefficient(\n    double joinSplitMixtureCoefficient)\n\n"},
  {"GetJoinSplitMixtureCoefficient", PyttkMergeTreePrincipalGeodesics_GetJoinSplitMixtureCoefficient, METH_VARARGS,
   "GetJoinSplitMixtureCoefficient(self) -> float\nC++: double GetJoinSplitMixtureCoefficient()\n\n"},
  {"SetKeepState", PyttkMergeTreePrincipalGeodesics_SetKeepState, METH_VARARGS,
   "SetKeepState(self, keepState:bool) -> None\nC++: void SetKeepState(bool keepState)\n\n"},
  {"GetKeepState", PyttkMergeTreePrincipalGeodesics_GetKeepState, METH_VARARGS,
   "GetKeepState(self) -> bool\nC++: bool GetKeepState()\n\n"},
  {"SetEpsilon1UseFarthestSaddle", PyttkMergeTreePrincipalGeodesics_SetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "SetEpsilon1UseFarthestSaddle(self, epsilon1UseFarthestSaddle:bool)\n     -> None\nC++: void SetEpsilon1UseFarthestSaddle(\n    bool epsilon1UseFarthestSaddle)\n\n"},
  {"GetEpsilon1UseFarthestSaddle", PyttkMergeTreePrincipalGeodesics_GetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "GetEpsilon1UseFarthestSaddle(self) -> bool\nC++: bool GetEpsilon1UseFarthestSaddle()\n\n"},
  {"SetEpsilonTree1", PyttkMergeTreePrincipalGeodesics_SetEpsilonTree1, METH_VARARGS,
   "SetEpsilonTree1(self, epsilonTree1:float) -> None\nC++: void SetEpsilonTree1(double epsilonTree1)\n\n"},
  {"GetEpsilonTree1", PyttkMergeTreePrincipalGeodesics_GetEpsilonTree1, METH_VARARGS,
   "GetEpsilonTree1(self) -> float\nC++: double GetEpsilonTree1()\n\n"},
  {"SetEpsilon2Tree1", PyttkMergeTreePrincipalGeodesics_SetEpsilon2Tree1, METH_VARARGS,
   "SetEpsilon2Tree1(self, epsilon2Tree1:float) -> None\nC++: void SetEpsilon2Tree1(double epsilon2Tree1)\n\n"},
  {"GetEpsilon2Tree1", PyttkMergeTreePrincipalGeodesics_GetEpsilon2Tree1, METH_VARARGS,
   "GetEpsilon2Tree1(self) -> float\nC++: double GetEpsilon2Tree1()\n\n"},
  {"SetEpsilon3Tree1", PyttkMergeTreePrincipalGeodesics_SetEpsilon3Tree1, METH_VARARGS,
   "SetEpsilon3Tree1(self, epsilon3Tree1:float) -> None\nC++: void SetEpsilon3Tree1(double epsilon3Tree1)\n\n"},
  {"GetEpsilon3Tree1", PyttkMergeTreePrincipalGeodesics_GetEpsilon3Tree1, METH_VARARGS,
   "GetEpsilon3Tree1(self) -> float\nC++: double GetEpsilon3Tree1()\n\n"},
  {"SetPersistenceThreshold", PyttkMergeTreePrincipalGeodesics_SetPersistenceThreshold, METH_VARARGS,
   "SetPersistenceThreshold(self, persistenceThreshold:float) -> None\nC++: void SetPersistenceThreshold(double persistenceThreshold)\n\n"},
  {"GetPersistenceThreshold", PyttkMergeTreePrincipalGeodesics_GetPersistenceThreshold, METH_VARARGS,
   "GetPersistenceThreshold(self) -> float\nC++: double GetPersistenceThreshold()\n\n"},
  {"SetDeleteMultiPersPairs", PyttkMergeTreePrincipalGeodesics_SetDeleteMultiPersPairs, METH_VARARGS,
   "SetDeleteMultiPersPairs(self, delMultiPersPairs:bool) -> None\nC++: void SetDeleteMultiPersPairs(bool delMultiPersPairs)\n\n"},
  {"GetDeleteMultiPersPairs", PyttkMergeTreePrincipalGeodesics_GetDeleteMultiPersPairs, METH_VARARGS,
   "GetDeleteMultiPersPairs(self) -> bool\nC++: bool GetDeleteMultiPersPairs()\n\n"},
  {"SetComputeReconstructionError", PyttkMergeTreePrincipalGeodesics_SetComputeReconstructionError, METH_VARARGS,
   "SetComputeReconstructionError(self, b:bool) -> None\nC++: void SetComputeReconstructionError(bool b)\n\n"},
  {"GetComputeReconstructionError", PyttkMergeTreePrincipalGeodesics_GetComputeReconstructionError, METH_VARARGS,
   "GetComputeReconstructionError(self) -> bool\nC++: bool GetComputeReconstructionError()\n\n"},
  {"IsTypeOf", PyttkMergeTreePrincipalGeodesics_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreePrincipalGeodesics_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreePrincipalGeodesics_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMergeTreePrincipalGeodesics\nC++: static ttkMergeTreePrincipalGeodesics *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreePrincipalGeodesics_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreePrincipalGeodesics\nC++: ttkMergeTreePrincipalGeodesics *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreePrincipalGeodesics_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreePrincipalGeodesics_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreePrincipalGeodesics_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("normalized_wasserstein"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetNormalizedWasserstein(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetNormalizedWasserstein(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetNormalizedWasserstein(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNormalizedWasserstein/SetNormalizedWasserstein\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("barycenter_size_limit_percent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetBarycenterSizeLimitPercent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetBarycenterSizeLimitPercent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetBarycenterSizeLimitPercent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBarycenterSizeLimitPercent/SetBarycenterSizeLimitPercent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("deterministic"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetDeterministic(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetDeterministic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetDeterministic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeterministic/SetDeterministic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("join_split_mixture_coefficient"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetJoinSplitMixtureCoefficient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetJoinSplitMixtureCoefficient(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetJoinSplitMixtureCoefficient(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetJoinSplitMixtureCoefficient/SetJoinSplitMixtureCoefficient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_state"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetKeepState(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetKeepState(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetKeepState(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetKeepState/SetKeepState\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon1_use_farthest_saddle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetEpsilon1UseFarthestSaddle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilon1UseFarthestSaddle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilon1UseFarthestSaddle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon1UseFarthestSaddle/SetEpsilon1UseFarthestSaddle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetEpsilonTree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilonTree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilonTree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilonTree1/SetEpsilonTree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon2_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetEpsilon2Tree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilon2Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilon2Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon2Tree1/SetEpsilon2Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon3_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetEpsilon3Tree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilon3Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetEpsilon3Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon3Tree1/SetEpsilon3Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("persistence_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetPersistenceThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPersistenceThreshold/SetPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delete_multi_pers_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetDeleteMultiPersPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetDeleteMultiPersPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetDeleteMultiPersPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeleteMultiPersPairs/SetDeleteMultiPersPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_reconstruction_error"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetComputeReconstructionError(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetComputeReconstructionError(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetComputeReconstructionError(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeReconstructionError/SetComputeReconstructionError\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_geodesics"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetNumberOfGeodesics(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetNumberOfGeodesics(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetNumberOfGeodesics(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfGeodesics/SetNumberOfGeodesics\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_projection_intervals"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetNumberOfProjectionIntervals(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionIntervals(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionIntervals(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfProjectionIntervals/SetNumberOfProjectionIntervals\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_projection_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesics_GetNumberOfProjectionSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesics_SetNumberOfProjectionSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfProjectionSteps/SetNumberOfProjectionSteps\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreePrincipalGeodesics_Doc =
  "ttkMergeTreePrincipalGeodesics - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont <mathieu.pont@lip6.fr>\\date 2022.\n\n"
  "TTK VTK-filter that wraps the ttk::MergeTreePrincipalGeodesics\n"
  "module.\n\n"
  "This VTK filter uses the ttk::MergeTreePrincipalGeodesics module to\n"
  "compute Principal Geodesic Analysis on the space of merge trees or\n"
  "persistence diagrams, that is, a set of orthogonal geodesic axes\n"
  "defining a basis with the barycenter as origin.\n\n"
  "\\param Input vtkMultiBlockDataSet Input trees\n"
  "\\param Input (optional) vtkMultiBlockDataSet Input trees\n"
  "\\param Output vtkMultiBlockDataSet Barycenter\n"
  "\\param Output vtkTable Coefficients\n"
  "\\param Output vtkTable Geodesics Vectors\n"
  "\\param Output vtkTable Correlation Matrix\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "See the corresponding standalone program for a usage example:\n"
  "- standalone/MergeTreePrincipalGeodesics/main.cpp\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication:\n\n"
  "\"Principal Geodesic Analysis of Merge Trees (and Persistence\n"
  "Diagrams)\"\n\n"
  "Mathieu Pont, Jules Vidal, Julien Tierny.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2022\n\n"
  "\\sa ttk::MergeTreePrincipalGeodesics\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  >Persistence Diagram Principal Geodesic Analysis example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreePrincipalGeodesics_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreePrincipalGeodesics.ttkMergeTreePrincipalGeodesics", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreePrincipalGeodesics_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreePrincipalGeodesics_StaticNew()
{
  return ttkMergeTreePrincipalGeodesics::New();
}

PyObject *PyttkMergeTreePrincipalGeodesics_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreePrincipalGeodesics_Type, PyttkMergeTreePrincipalGeodesics_Methods,
    "ttkMergeTreePrincipalGeodesics",
 &PyttkMergeTreePrincipalGeodesics_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreePrincipalGeodesics_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreePrincipalGeodesics(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreePrincipalGeodesics_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreePrincipalGeodesics", o) != 0)
  {
    Py_DECREF(o);
  }

}

