/* IconManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IconManager.vala, do not modify */

/*
 * IconManager.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define ICON_MANAGER_SHIELD_ICON_SIZE 64
#define ICON_MANAGER_GENERIC_ICON_IMAGE "image-x-generic"
#define ICON_MANAGER_GENERIC_ICON_IMAGE_MISSING "image-missing"
#define ICON_MANAGER_GENERIC_ICON_VIDEO "video-x-generic"
#define ICON_MANAGER_GENERIC_ICON_FILE "text-x-preview"
#define ICON_MANAGER_GENERIC_ICON_ARCHIVE_FILE "package-x-generic"
#define ICON_MANAGER_GENERIC_ICON_DIRECTORY "folder"
#define ICON_MANAGER_GENERIC_ICON_ISO "media-cdrom"
#define ICON_MANAGER_GENERIC_ICON_PDF "application-pdf"
#define ICON_MANAGER_ICON_HARDDRIVE "drive-harddisk"
#define ICON_MANAGER_SHIELD_LIVE "media-optical"
#define ICON_MANAGER_SHIELD_LOW "timeshift-shield-low"
#define ICON_MANAGER_SHIELD_MED "timeshift-shield-med"
#define ICON_MANAGER_SHIELD_HIGH "timeshift-shield-high"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ICON_MANAGER (icon_manager_get_type ())
#define ICON_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_MANAGER, IconManager))
#define ICON_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_MANAGER, IconManagerClass))
#define IS_ICON_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_MANAGER))
#define IS_ICON_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_MANAGER))
#define ICON_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_MANAGER, IconManagerClass))

typedef struct _IconManager IconManager;
typedef struct _IconManagerClass IconManagerClass;
typedef struct _IconManagerPrivate IconManagerPrivate;
enum  {
	ICON_MANAGER_0_PROPERTY,
	ICON_MANAGER_NUM_PROPERTIES
};
static GParamSpec* icon_manager_properties[ICON_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _IconManager {
	GObject parent_instance;
	IconManagerPrivate * priv;
};

struct _IconManagerClass {
	GObjectClass parent_class;
};

static gpointer icon_manager_parent_class = NULL;
VALA_EXTERN GtkIconTheme* icon_manager_theme;
GtkIconTheme* icon_manager_theme = NULL;
VALA_EXTERN GeeArrayList* icon_manager_search_paths;
GeeArrayList* icon_manager_search_paths = NULL;
VALA_EXTERN gboolean GTK_INITIALIZED;

VALA_EXTERN GType icon_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IconManager, g_object_unref)
VALA_EXTERN void icon_manager_init (gchar** args,
                        gint args_length1,
                        const gchar* app_name);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN void icon_manager_refresh_icon_theme (void);
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN GdkPixbuf* icon_manager_load_pixbuf_from_file (const gchar* file_path,
                                               gint icon_size);
VALA_EXTERN GtkImage* icon_manager_lookup_image (const gchar* icon_name,
                                     gint icon_size,
                                     gboolean symbolic,
                                     gboolean use_hardcoded);
VALA_EXTERN cairo_surface_t* icon_manager_lookup_surface (const gchar* icon_name,
                                              gint icon_size,
                                              gint scale,
                                              gboolean symbolic,
                                              gboolean use_hardcoded);
VALA_EXTERN GdkPixbuf* icon_manager_lookup_gicon (GIcon* gicon,
                                      gint icon_size);
VALA_EXTERN GdkPixbuf* icon_manager_add_emblem (GdkPixbuf* pixbuf,
                                    const gchar* icon_name,
                                    gint emblem_size,
                                    gboolean emblem_symbolic,
                                    GtkCornerType corner_type);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN GdkPixbuf* icon_manager_add_overlay (GdkPixbuf* pixbuf_base,
                                     GdkPixbuf* pixbuf_overlay);
VALA_EXTERN GdkPixbuf* icon_manager_resize_icon (GdkPixbuf* pixbuf_image,
                                     gint icon_size);
VALA_EXTERN GdkPixbuf* icon_manager_add_transparency (GdkPixbuf* pixbuf,
                                          gint opacity);
VALA_EXTERN IconManager* icon_manager_new (void);
VALA_EXTERN IconManager* icon_manager_construct (GType object_type);
static void icon_manager_finalize (GObject * obj);
static GType icon_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
icon_manager_init (gchar** args,
                   gint args_length1,
                   const gchar* app_name)
{
	GeeArrayList* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (app_name != NULL);
	tee_jee_logging_log_debug ("IconManager: init()");
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (icon_manager_search_paths);
	icon_manager_search_paths = _tmp0_;
	_tmp1_ = g_strdup_printf ("/usr/share/%s/images", app_name);
	path = _tmp1_;
	_tmp2_ = path;
	if (tee_jee_file_system_dir_exists (_tmp2_)) {
		GeeArrayList* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = icon_manager_search_paths;
		_tmp4_ = path;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
		_tmp5_ = path;
		_tmp6_ = g_strdup_printf ("found images directory: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		tee_jee_logging_log_debug (_tmp7_);
		_g_free0 (_tmp7_);
	}
	icon_manager_refresh_icon_theme ();
	_g_free0 (path);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
icon_manager_refresh_icon_theme (void)
{
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	if (!GTK_INITIALIZED) {
		return;
	}
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (icon_manager_theme);
	icon_manager_theme = _tmp1_;
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp2_;
		gint _path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _path_index = 0;
		_tmp2_ = icon_manager_search_paths;
		_path_list = _tmp2_;
		_tmp3_ = _path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_path_size = _tmp5_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GtkIconTheme* _tmp10_;
			const gchar* _tmp11_;
			_path_index = _path_index + 1;
			_tmp6_ = _path_index;
			_tmp7_ = _path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _path_index);
			path = (gchar*) _tmp9_;
			_tmp10_ = icon_manager_theme;
			_tmp11_ = path;
			gtk_icon_theme_append_search_path (_tmp10_, _tmp11_);
			_g_free0 (path);
		}
	}
}

GdkPixbuf*
icon_manager_lookup (const gchar* icon_name,
                     gint icon_size,
                     gboolean symbolic,
                     gboolean use_hardcoded,
                     gint scale)
{
	GdkPixbuf* pixbuf = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (icon_name != NULL, NULL);
	pixbuf = NULL;
	_tmp0_ = strlen (icon_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		_g_object_unref0 (pixbuf);
		return result;
	}
	if (!use_hardcoded) {
		{
			GdkPixbuf* _tmp2_ = NULL;
			GtkIconTheme* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			_tmp3_ = icon_manager_theme;
			_tmp4_ = gtk_icon_theme_load_icon_for_scale (_tmp3_, icon_name, icon_size, scale, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp5_;
			_tmp6_ = pixbuf;
			if (_tmp6_ != NULL) {
				result = pixbuf;
				_g_object_unref0 (_tmp2_);
				return result;
			}
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			tee_jee_logging_log_debug (_tmp8_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GeeArrayList* _search_path_list = NULL;
		GeeArrayList* _tmp9_;
		gint _search_path_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _search_path_index = 0;
		_tmp9_ = icon_manager_search_paths;
		_search_path_list = _tmp9_;
		_tmp10_ = _search_path_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_search_path_size = _tmp12_;
		_search_path_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gchar* search_path = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar** _tmp21_;
			_search_path_index = _search_path_index + 1;
			_tmp13_ = _search_path_index;
			_tmp14_ = _search_path_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _search_path_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _search_path_index);
			search_path = (gchar*) _tmp16_;
			_tmp17_ = g_strdup (".svg");
			_tmp18_ = g_strdup (".png");
			_tmp19_ = g_strdup (".jpg");
			_tmp20_ = g_strdup (".gif");
			_tmp21_ = g_new0 (gchar*, 4 + 1);
			_tmp21_[0] = _tmp17_;
			_tmp21_[1] = _tmp18_;
			_tmp21_[2] = _tmp19_;
			_tmp21_[3] = _tmp20_;
			{
				gchar** ext_collection = NULL;
				gint ext_collection_length1 = 0;
				gint _ext_collection_size_ = 0;
				gint ext_it = 0;
				ext_collection = _tmp21_;
				ext_collection_length1 = 4;
				for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
					gchar* _tmp22_;
					gchar* ext = NULL;
					_tmp22_ = g_strdup (ext_collection[ext_it]);
					ext = _tmp22_;
					{
						gchar* img_file = NULL;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						const gchar* _tmp29_;
						_tmp23_ = search_path;
						_tmp24_ = ext;
						_tmp25_ = g_strconcat (icon_name, _tmp24_, NULL);
						_tmp26_ = _tmp25_;
						_tmp27_ = tee_jee_file_system_path_combine (_tmp23_, _tmp26_);
						_tmp28_ = _tmp27_;
						_g_free0 (_tmp26_);
						img_file = _tmp28_;
						_tmp29_ = img_file;
						if (tee_jee_file_system_file_exists (_tmp29_)) {
							const gchar* _tmp30_;
							GdkPixbuf* _tmp31_;
							GdkPixbuf* _tmp32_;
							_tmp30_ = img_file;
							_tmp31_ = icon_manager_load_pixbuf_from_file (_tmp30_, icon_size);
							_g_object_unref0 (pixbuf);
							pixbuf = _tmp31_;
							_tmp32_ = pixbuf;
							if (_tmp32_ != NULL) {
								result = pixbuf;
								_g_free0 (img_file);
								_g_free0 (ext);
								ext_collection = (_vala_array_free (ext_collection, ext_collection_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (search_path);
								return result;
							}
						}
						_g_free0 (img_file);
						_g_free0 (ext);
					}
				}
				ext_collection = (_vala_array_free (ext_collection, ext_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (search_path);
		}
	}
	result = pixbuf;
	return result;
}

GtkImage*
icon_manager_lookup_image (const gchar* icon_name,
                           gint icon_size,
                           gboolean symbolic,
                           gboolean use_hardcoded)
{
	gint _tmp0_;
	gint _tmp1_;
	GtkImage* image = NULL;
	GtkImage* _tmp2_;
	GdkPixbuf* pix = NULL;
	GtkImage* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	cairo_surface_t* surf = NULL;
	GdkPixbuf* _tmp12_;
	GtkImage* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_surface_t* _tmp16_;
	GtkImage* _tmp17_;
	cairo_surface_t* _tmp18_;
	GtkImage* result;
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = strlen (icon_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp2_);
	image = _tmp2_;
	_tmp3_ = image;
	_tmp4_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = icon_manager_lookup (icon_name, icon_size, symbolic, use_hardcoded, _tmp5_);
	pix = _tmp6_;
	_tmp7_ = pix;
	if (_tmp7_ == NULL) {
		GtkImage* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp8_ = image;
		_tmp9_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = icon_manager_lookup (ICON_MANAGER_GENERIC_ICON_IMAGE_MISSING, icon_size, symbolic, use_hardcoded, _tmp10_);
		_g_object_unref0 (pix);
		pix = _tmp11_;
	}
	_tmp12_ = pix;
	_tmp13_ = image;
	_tmp14_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gdk_cairo_surface_create_from_pixbuf (_tmp12_, _tmp15_, NULL);
	surf = _tmp16_;
	_tmp17_ = image;
	_tmp18_ = surf;
	gtk_image_set_from_surface (_tmp17_, _tmp18_);
	result = image;
	_cairo_surface_destroy0 (surf);
	_g_object_unref0 (pix);
	return result;
}

cairo_surface_t*
icon_manager_lookup_surface (const gchar* icon_name,
                             gint icon_size,
                             gint scale,
                             gboolean symbolic,
                             gboolean use_hardcoded)
{
	gint _tmp0_;
	gint _tmp1_;
	GdkPixbuf* pix = NULL;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* result;
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = strlen (icon_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = icon_manager_lookup (icon_name, icon_size, symbolic, use_hardcoded, scale);
	pix = _tmp2_;
	_tmp3_ = pix;
	if (_tmp3_ == NULL) {
		GdkPixbuf* _tmp4_;
		_tmp4_ = icon_manager_lookup (ICON_MANAGER_GENERIC_ICON_IMAGE_MISSING, icon_size, symbolic, use_hardcoded, scale);
		_g_object_unref0 (pix);
		pix = _tmp4_;
	}
	_tmp5_ = pix;
	_tmp6_ = gdk_cairo_surface_create_from_pixbuf (_tmp5_, scale, NULL);
	result = _tmp6_;
	_g_object_unref0 (pix);
	return result;
}

GdkPixbuf*
icon_manager_lookup_gicon (GIcon* gicon,
                           gint icon_size)
{
	GdkPixbuf* pixbuf = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	pixbuf = NULL;
	if (gicon == NULL) {
		result = NULL;
		_g_object_unref0 (pixbuf);
		return result;
	}
	{
		GtkIconInfo* icon_info = NULL;
		GtkIconTheme* _tmp0_;
		GtkIconInfo* _tmp1_;
		GtkIconInfo* _tmp2_;
		_tmp0_ = icon_manager_theme;
		_tmp1_ = gtk_icon_theme_lookup_by_gicon (_tmp0_, gicon, icon_size, GTK_ICON_LOOKUP_FORCE_SIZE);
		icon_info = _tmp1_;
		_tmp2_ = icon_info;
		if (_tmp2_ != NULL) {
			GdkPixbuf* _tmp3_ = NULL;
			GtkIconInfo* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			_tmp4_ = icon_info;
			_tmp5_ = gtk_icon_info_load_icon (_tmp4_, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (icon_info);
				goto __catch0_g_error;
			}
			_tmp6_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp6_;
			_g_object_unref0 (_tmp3_);
		}
		_g_object_unref0 (icon_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tee_jee_logging_log_debug (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = pixbuf;
	return result;
}

GdkPixbuf*
icon_manager_add_emblem (GdkPixbuf* pixbuf,
                         const gchar* icon_name,
                         gint emblem_size,
                         gboolean emblem_symbolic,
                         GtkCornerType corner_type)
{
	gint _tmp0_;
	gint _tmp1_;
	GdkPixbuf* emblem = NULL;
	GdkRGBA SMALL_EMBLEM_COLOR = {0};
	gint EMBLEM_PADDING = 0;
	GdkPixbuf* _tmp19_;
	gint offset_x = 0;
	gboolean _tmp21_ = FALSE;
	gint offset_y = 0;
	gboolean _tmp27_ = FALSE;
	GdkPixbuf* emblemed = NULL;
	GdkPixbuf* _tmp33_;
	GdkPixbuf* _tmp34_;
	GdkPixbuf* _tmp35_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = strlen (icon_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = _g_object_ref0 (pixbuf);
		result = _tmp2_;
		return result;
	}
	emblem = NULL;
	memset (&SMALL_EMBLEM_COLOR, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&SMALL_EMBLEM_COLOR, "#000000");
	SMALL_EMBLEM_COLOR.alpha = 1.0;
	EMBLEM_PADDING = 1;
	{
		GtkIconInfo* icon_info = NULL;
		GtkIconTheme* _tmp3_;
		GtkIconInfo* _tmp4_;
		_tmp3_ = icon_manager_theme;
		_tmp4_ = gtk_icon_theme_lookup_icon (_tmp3_, icon_name, emblem_size, GTK_ICON_LOOKUP_FORCE_SIZE);
		icon_info = _tmp4_;
		if (emblem_symbolic) {
			GdkPixbuf* _tmp5_ = NULL;
			GtkIconInfo* _tmp6_;
			GdkRGBA _tmp7_;
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp6_ = icon_info;
			_tmp7_ = SMALL_EMBLEM_COLOR;
			_tmp8_ = gtk_icon_info_load_symbolic (_tmp6_, &_tmp7_, NULL, NULL, NULL, NULL, &_inner_error0_);
			_tmp5_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (icon_info);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (emblem);
			emblem = _tmp9_;
			_g_object_unref0 (_tmp5_);
		} else {
			GdkPixbuf* _tmp10_ = NULL;
			GtkIconInfo* _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			_tmp11_ = icon_info;
			_tmp12_ = gtk_icon_info_load_icon (_tmp11_, &_inner_error0_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (icon_info);
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_object_unref0 (emblem);
			emblem = _tmp13_;
			_g_object_unref0 (_tmp10_);
		}
		_g_object_unref0 (icon_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GdkPixbuf* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = g_strdup_printf ("get_icon_emblemed(): %s", _tmp15_);
		_tmp17_ = _tmp16_;
		tee_jee_logging_log_error (_tmp17_, FALSE, FALSE);
		_g_free0 (_tmp17_);
		_tmp18_ = _g_object_ref0 (pixbuf);
		result = _tmp18_;
		_g_error_free0 (e);
		_g_object_unref0 (emblem);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (emblem);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp19_ = emblem;
	if (_tmp19_ == NULL) {
		GdkPixbuf* _tmp20_;
		_tmp20_ = _g_object_ref0 (pixbuf);
		result = _tmp20_;
		_g_object_unref0 (emblem);
		return result;
	}
	offset_x = EMBLEM_PADDING;
	if (corner_type == GTK_CORNER_BOTTOM_RIGHT) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = corner_type == GTK_CORNER_TOP_RIGHT;
	}
	if (_tmp21_) {
		gint _tmp22_;
		gint _tmp23_;
		GdkPixbuf* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp22_ = gdk_pixbuf_get_width (pixbuf);
		_tmp23_ = _tmp22_;
		_tmp24_ = emblem;
		_tmp25_ = gdk_pixbuf_get_width (_tmp24_);
		_tmp26_ = _tmp25_;
		offset_x = (_tmp23_ - _tmp26_) - EMBLEM_PADDING;
	}
	offset_y = EMBLEM_PADDING;
	if (corner_type == GTK_CORNER_BOTTOM_LEFT) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = corner_type == GTK_CORNER_BOTTOM_RIGHT;
	}
	if (_tmp27_) {
		gint _tmp28_;
		gint _tmp29_;
		GdkPixbuf* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp28_ = gdk_pixbuf_get_height (pixbuf);
		_tmp29_ = _tmp28_;
		_tmp30_ = emblem;
		_tmp31_ = gdk_pixbuf_get_height (_tmp30_);
		_tmp32_ = _tmp31_;
		offset_y = (_tmp29_ - _tmp32_) - EMBLEM_PADDING;
	}
	_tmp33_ = gdk_pixbuf_copy (pixbuf);
	emblemed = _tmp33_;
	_tmp34_ = emblem;
	_tmp35_ = emblemed;
	gdk_pixbuf_composite (_tmp34_, _tmp35_, offset_x, offset_y, emblem_size, emblem_size, (gdouble) offset_x, (gdouble) offset_y, 1.0, 1.0, GDK_INTERP_BILINEAR, 255);
	result = emblemed;
	_g_object_unref0 (emblem);
	return result;
}

GdkPixbuf*
icon_manager_add_overlay (GdkPixbuf* pixbuf_base,
                          GdkPixbuf* pixbuf_overlay)
{
	gint offset_x = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint offset_y = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GdkPixbuf* emblemed = NULL;
	GdkPixbuf* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GdkPixbuf* result;
	g_return_val_if_fail (pixbuf_base != NULL, NULL);
	g_return_val_if_fail (pixbuf_overlay != NULL, NULL);
	_tmp0_ = gdk_pixbuf_get_width (pixbuf_base);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_pixbuf_get_width (pixbuf_overlay);
	_tmp3_ = _tmp2_;
	offset_x = (_tmp1_ - _tmp3_) / 2;
	_tmp4_ = gdk_pixbuf_get_height (pixbuf_base);
	_tmp5_ = _tmp4_;
	_tmp6_ = gdk_pixbuf_get_height (pixbuf_overlay);
	_tmp7_ = _tmp6_;
	offset_y = (_tmp5_ - _tmp7_) / 2;
	_tmp8_ = gdk_pixbuf_copy (pixbuf_base);
	emblemed = _tmp8_;
	_tmp9_ = gdk_pixbuf_get_width (pixbuf_overlay);
	_tmp10_ = _tmp9_;
	_tmp11_ = gdk_pixbuf_get_height (pixbuf_overlay);
	_tmp12_ = _tmp11_;
	gdk_pixbuf_composite (pixbuf_overlay, emblemed, offset_x, offset_y, _tmp10_, _tmp12_, (gdouble) offset_x, (gdouble) offset_y, 1.0, 1.0, GDK_INTERP_BILINEAR, 255);
	result = emblemed;
	return result;
}

GdkPixbuf*
icon_manager_resize_icon (GdkPixbuf* pixbuf_image,
                          gint icon_size)
{
	GdkPixbuf* pixbuf_empty = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* pixbuf_resized = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (pixbuf_image != NULL, NULL);
	_tmp0_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, icon_size, icon_size);
	pixbuf_empty = _tmp0_;
	gdk_pixbuf_fill (pixbuf_empty, (guint32) 0x00000000);
	_tmp1_ = icon_manager_add_overlay (pixbuf_empty, pixbuf_image);
	pixbuf_resized = _tmp1_;
	result = pixbuf_resized;
	_g_object_unref0 (pixbuf_empty);
	return result;
}

GdkPixbuf*
icon_manager_add_transparency (GdkPixbuf* pixbuf,
                               gint opacity)
{
	GdkPixbuf* trans = NULL;
	GdkPixbuf* _tmp0_;
	gint width = 0;
	gint height = 0;
	GdkPixbuf* result;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = gdk_pixbuf_copy (pixbuf);
	trans = _tmp0_;
	gdk_pixbuf_fill (trans, (guint32) 0xFFFFFF00LL);
	width = gdk_pixbuf_get_width (pixbuf);
	height = gdk_pixbuf_get_height (pixbuf);
	gdk_pixbuf_composite (pixbuf, trans, 0, 0, width, height, (gdouble) 0, (gdouble) 0, 1.0, 1.0, GDK_INTERP_BILINEAR, opacity);
	result = trans;
	return result;
}

GdkPixbuf*
icon_manager_load_pixbuf_from_file (const gchar* file_path,
                                    gint icon_size)
{
	GdkPixbuf* pixbuf = NULL;
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	pixbuf = NULL;
	gdk_pixbuf_get_file_info (file_path, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	if (width <= icon_size) {
		_tmp2_ = height <= icon_size;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			GdkPixbuf* _tmp3_ = NULL;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp4_ = gdk_pixbuf_new_from_file (file_path, &_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp5_;
			_tmp6_ = pixbuf;
			_tmp7_ = icon_manager_resize_icon (_tmp6_, icon_size);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp7_;
			_tmp8_ = pixbuf;
			if (_tmp8_ != NULL) {
				result = pixbuf;
				_g_object_unref0 (_tmp3_);
				return result;
			}
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		{
			GdkPixbuf* _tmp9_ = NULL;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			GdkPixbuf* _tmp14_;
			_tmp10_ = gdk_pixbuf_new_from_file_at_scale (file_path, icon_size, icon_size, TRUE, &_inner_error0_);
			_tmp9_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp11_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp11_;
			_tmp12_ = pixbuf;
			_tmp13_ = icon_manager_resize_icon (_tmp12_, icon_size);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp13_;
			_tmp14_ = pixbuf;
			if (_tmp14_ != NULL) {
				result = pixbuf;
				_g_object_unref0 (_tmp9_);
				return result;
			}
			_g_object_unref0 (_tmp9_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	_g_object_unref0 (pixbuf);
	return result;
}

IconManager*
icon_manager_construct (GType object_type)
{
	IconManager * self = NULL;
	self = (IconManager*) g_object_new (object_type, NULL);
	return self;
}

IconManager*
icon_manager_new (void)
{
	return icon_manager_construct (TYPE_ICON_MANAGER);
}

static void
icon_manager_class_init (IconManagerClass * klass,
                         gpointer klass_data)
{
	GeeArrayList* _tmp0_;
	icon_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = icon_manager_finalize;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	icon_manager_search_paths = _tmp0_;
}

static void
icon_manager_instance_init (IconManager * self,
                            gpointer klass)
{
}

static void
icon_manager_finalize (GObject * obj)
{
	IconManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_MANAGER, IconManager);
	G_OBJECT_CLASS (icon_manager_parent_class)->finalize (obj);
}

static GType
icon_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconManager), 0, (GInstanceInitFunc) icon_manager_instance_init, NULL };
	GType icon_manager_type_id;
	icon_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "IconManager", &g_define_type_info, 0);
	return icon_manager_type_id;
}

GType
icon_manager_get_type (void)
{
	static volatile gsize icon_manager_type_id__once = 0;
	if (g_once_init_enter (&icon_manager_type_id__once)) {
		GType icon_manager_type_id;
		icon_manager_type_id = icon_manager_get_type_once ();
		g_once_init_leave (&icon_manager_type_id__once, icon_manager_type_id);
	}
	return icon_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

