/* InputSource.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from InputSource.vala, do not modify */

/*
* Copyright 2017-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "keyboard.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	KEYBOARD_INPUT_SOURCE_0_PROPERTY,
	KEYBOARD_INPUT_SOURCE_LAYOUT_TYPE_PROPERTY,
	KEYBOARD_INPUT_SOURCE_NAME_PROPERTY,
	KEYBOARD_INPUT_SOURCE_NUM_PROPERTIES
};
static GParamSpec* keyboard_input_source_properties[KEYBOARD_INPUT_SOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KeyboardInputSourcePrivate {
	KeyboardLayoutType _layout_type;
	gchar* _name;
};

static gint KeyboardInputSource_private_offset;
static gpointer keyboard_input_source_parent_class = NULL;

static KeyboardInputSource* keyboard_input_source_new (KeyboardLayoutType layout_type,
                                                const gchar* name);
static KeyboardInputSource* keyboard_input_source_construct (GType object_type,
                                                      KeyboardLayoutType layout_type,
                                                      const gchar* name);
static void keyboard_input_source_finalize (GObject * obj);
static GType keyboard_input_source_get_type_once (void);
static void _vala_keyboard_input_source_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_keyboard_input_source_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
     * Type of a keyboard-InputSource as described in the description of
     * "org.gnome.desktop.input-sources sources".
     */
static GType
keyboard_layout_type_get_type_once (void)
{
	static const GEnumValue values[] = {{KEYBOARD_LAYOUT_TYPE_IBUS, "KEYBOARD_LAYOUT_TYPE_IBUS", "ibus"}, {KEYBOARD_LAYOUT_TYPE_XKB, "KEYBOARD_LAYOUT_TYPE_XKB", "xkb"}, {0, NULL, NULL}};
	GType keyboard_layout_type_type_id;
	keyboard_layout_type_type_id = g_enum_register_static ("KeyboardLayoutType", values);
	return keyboard_layout_type_type_id;
}

GType
keyboard_layout_type_get_type (void)
{
	static volatile gsize keyboard_layout_type_type_id__once = 0;
	if (g_once_init_enter (&keyboard_layout_type_type_id__once)) {
		GType keyboard_layout_type_type_id;
		keyboard_layout_type_type_id = keyboard_layout_type_get_type_once ();
		g_once_init_leave (&keyboard_layout_type_type_id__once, keyboard_layout_type_type_id);
	}
	return keyboard_layout_type_type_id__once;
}

static inline gpointer
keyboard_input_source_get_instance_private (KeyboardInputSource* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardInputSource_private_offset);
}

KeyboardInputSource*
keyboard_input_source_new_xkb (const gchar* name,
                               const gchar* xkb_variant)
{
	gchar* full_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp6_;
	KeyboardInputSource* _tmp7_;
	KeyboardInputSource* result;
	g_return_val_if_fail (name != NULL, NULL);
	if (g_strcmp0 (name, "") == 0) {
		g_critical ("InputSource.vala:37: Ignoring attempt to create invalid Xkb InputSourc" \
"e name %s", name);
		result = NULL;
		return result;
	}
	_tmp0_ = g_strdup (name);
	full_name = _tmp0_;
	if (xkb_variant != NULL) {
		_tmp1_ = g_strcmp0 (xkb_variant, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = full_name;
		_tmp3_ = g_strconcat ("+", xkb_variant, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
		_g_free0 (full_name);
		full_name = _tmp5_;
		_g_free0 (_tmp4_);
	}
	_tmp6_ = full_name;
	_tmp7_ = keyboard_input_source_new (KEYBOARD_LAYOUT_TYPE_XKB, _tmp6_);
	result = _tmp7_;
	_g_free0 (full_name);
	return result;
}

KeyboardInputSource*
keyboard_input_source_new_ibus (const gchar* engine_name)
{
	KeyboardInputSource* _tmp0_;
	KeyboardInputSource* result;
	g_return_val_if_fail (engine_name != NULL, NULL);
	if (g_strcmp0 (engine_name, "") == 0) {
		g_critical ("InputSource.vala:51: Ignoring attempt to create invalid IBus InputSour" \
"ce name %s", engine_name);
		result = NULL;
		return result;
	}
	_tmp0_ = keyboard_input_source_new (KEYBOARD_LAYOUT_TYPE_IBUS, engine_name);
	result = _tmp0_;
	return result;
}

KeyboardInputSource*
keyboard_input_source_new_from_variant (GVariant* variant)
{
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	gboolean _tmp2_;
	KeyboardInputSource* result;
	_tmp0_ = g_variant_type_new ("(ss)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_is_of_type (variant, _tmp1_);
	_g_variant_type_free0 (_tmp1_);
	if (_tmp2_) {
		const gchar* type = NULL;
		const gchar* name = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		g_variant_get (variant, "(&s&s)", &_tmp3_, &_tmp4_, NULL);
		type = _tmp3_;
		name = _tmp4_;
		_tmp5_ = name;
		if (g_strcmp0 (_tmp5_, "") != 0) {
			const gchar* _tmp6_;
			_tmp6_ = type;
			if (g_strcmp0 (_tmp6_, "xkb") == 0) {
				const gchar* _tmp7_;
				KeyboardInputSource* _tmp8_;
				_tmp7_ = name;
				_tmp8_ = keyboard_input_source_new (KEYBOARD_LAYOUT_TYPE_XKB, _tmp7_);
				result = _tmp8_;
				return result;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = type;
				if (g_strcmp0 (_tmp9_, "ibus") == 0) {
					const gchar* _tmp10_;
					KeyboardInputSource* _tmp11_;
					_tmp10_ = name;
					_tmp11_ = keyboard_input_source_new (KEYBOARD_LAYOUT_TYPE_IBUS, _tmp10_);
					result = _tmp11_;
					return result;
				}
			}
		} else {
			const gchar* _tmp12_;
			_tmp12_ = name;
			g_critical ("InputSource.vala:72: Attempt to create invalid InputSource name %s", _tmp12_);
		}
	} else {
		g_critical ("InputSource.vala:76: Ignoring attempt to create InputSource from inval" \
"id VariantType");
	}
	result = NULL;
	return result;
}

static KeyboardInputSource*
keyboard_input_source_construct (GType object_type,
                                 KeyboardLayoutType layout_type,
                                 const gchar* name)
{
	KeyboardInputSource * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (KeyboardInputSource*) g_object_new (object_type, "layout-type", layout_type, "name", name, NULL);
	return self;
}

static KeyboardInputSource*
keyboard_input_source_new (KeyboardLayoutType layout_type,
                           const gchar* name)
{
	return keyboard_input_source_construct (KEYBOARD_TYPE_INPUT_SOURCE, layout_type, name);
}

gboolean
keyboard_input_source_equal (KeyboardInputSource* self,
                             KeyboardInputSource* other)
{
	gboolean _tmp0_ = FALSE;
	KeyboardLayoutType _tmp1_;
	KeyboardLayoutType _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp1_ = self->priv->_layout_type;
	_tmp2_ = other->priv->_layout_type;
	if (_tmp1_ == _tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_name;
		_tmp4_ = other->priv->_name;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
         * GSettings saves values in the form of GLib.Variant and this
         * function creates a Variant representing this object.
         */
static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

GVariant*
keyboard_input_source_to_variant (KeyboardInputSource* self)
{
	const gchar* _tmp0_;
	gchar* type_name = NULL;
	gchar* _tmp1_;
	KeyboardLayoutType _tmp2_;
	GVariant* first = NULL;
	const gchar* _tmp5_;
	GVariant* _tmp6_;
	GVariant* second = NULL;
	const gchar* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _result_ = NULL;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant** _tmp11_;
	GVariant** _tmp12_;
	gint _tmp12__length1;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_vala_return_val_if_fail (g_strcmp0 (_tmp0_, "") != 0, "name != \"\"", NULL);
	_tmp1_ = g_strdup ("");
	type_name = _tmp1_;
	_tmp2_ = self->priv->_layout_type;
	switch (_tmp2_) {
		case KEYBOARD_LAYOUT_TYPE_IBUS:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ibus");
			_g_free0 (type_name);
			type_name = _tmp3_;
			break;
		}
		case KEYBOARD_LAYOUT_TYPE_XKB:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("xkb");
			_g_free0 (type_name);
			type_name = _tmp4_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp5_ = type_name;
	_tmp6_ = g_variant_new_string (_tmp5_);
	g_variant_ref_sink (_tmp6_);
	first = _tmp6_;
	_tmp7_ = self->priv->_name;
	_tmp8_ = g_variant_new_string (_tmp7_);
	g_variant_ref_sink (_tmp8_);
	second = _tmp8_;
	_tmp9_ = _g_variant_ref0 (first);
	_tmp10_ = _g_variant_ref0 (second);
	_tmp11_ = g_new0 (GVariant*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	_tmp13_ = g_variant_new_tuple (_tmp12_, 2);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_variant_unref), NULL);
	_result_ = _tmp14_;
	result = _result_;
	_g_variant_unref0 (second);
	_g_variant_unref0 (first);
	_g_free0 (type_name);
	return result;
}

KeyboardLayoutType
keyboard_input_source_get_layout_type (KeyboardInputSource* self)
{
	KeyboardLayoutType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_layout_type;
	return result;
}

static void
keyboard_input_source_set_layout_type (KeyboardInputSource* self,
                                       KeyboardLayoutType value)
{
	KeyboardLayoutType old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_input_source_get_layout_type (self);
	if (old_value != value) {
		self->priv->_layout_type = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_input_source_properties[KEYBOARD_INPUT_SOURCE_LAYOUT_TYPE_PROPERTY]);
	}
}

const gchar*
keyboard_input_source_get_name (KeyboardInputSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
keyboard_input_source_set_name (KeyboardInputSource* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_input_source_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_input_source_properties[KEYBOARD_INPUT_SOURCE_NAME_PROPERTY]);
	}
}

static void
keyboard_input_source_class_init (KeyboardInputSourceClass * klass,
                                  gpointer klass_data)
{
	keyboard_input_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardInputSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_input_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_input_source_set_property;
	G_OBJECT_CLASS (klass)->finalize = keyboard_input_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_INPUT_SOURCE_LAYOUT_TYPE_PROPERTY, keyboard_input_source_properties[KEYBOARD_INPUT_SOURCE_LAYOUT_TYPE_PROPERTY] = g_param_spec_enum ("layout-type", "layout-type", "layout-type", KEYBOARD_TYPE_LAYOUT_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_INPUT_SOURCE_NAME_PROPERTY, keyboard_input_source_properties[KEYBOARD_INPUT_SOURCE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
keyboard_input_source_instance_init (KeyboardInputSource * self,
                                     gpointer klass)
{
	self->priv = keyboard_input_source_get_instance_private (self);
}

static void
keyboard_input_source_finalize (GObject * obj)
{
	KeyboardInputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_TYPE_INPUT_SOURCE, KeyboardInputSource);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (keyboard_input_source_parent_class)->finalize (obj);
}

/**
     * Immutable class that respresents a keyboard-InputSource according to
     * "org.gnome.desktop.input-sources sources".
     * This means that the enum parameter @layout_type equals the first string in the
     * tupel of strings, and the @name parameter equals the second string.
     */
static GType
keyboard_input_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardInputSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_input_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardInputSource), 0, (GInstanceInitFunc) keyboard_input_source_instance_init, NULL };
	GType keyboard_input_source_type_id;
	keyboard_input_source_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyboardInputSource", &g_define_type_info, 0);
	KeyboardInputSource_private_offset = g_type_add_instance_private (keyboard_input_source_type_id, sizeof (KeyboardInputSourcePrivate));
	return keyboard_input_source_type_id;
}

GType
keyboard_input_source_get_type (void)
{
	static volatile gsize keyboard_input_source_type_id__once = 0;
	if (g_once_init_enter (&keyboard_input_source_type_id__once)) {
		GType keyboard_input_source_type_id;
		keyboard_input_source_type_id = keyboard_input_source_get_type_once ();
		g_once_init_leave (&keyboard_input_source_type_id__once, keyboard_input_source_type_id);
	}
	return keyboard_input_source_type_id__once;
}

static void
_vala_keyboard_input_source_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	KeyboardInputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_TYPE_INPUT_SOURCE, KeyboardInputSource);
	switch (property_id) {
		case KEYBOARD_INPUT_SOURCE_LAYOUT_TYPE_PROPERTY:
		g_value_set_enum (value, keyboard_input_source_get_layout_type (self));
		break;
		case KEYBOARD_INPUT_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, keyboard_input_source_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_input_source_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	KeyboardInputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_TYPE_INPUT_SOURCE, KeyboardInputSource);
	switch (property_id) {
		case KEYBOARD_INPUT_SOURCE_LAYOUT_TYPE_PROPERTY:
		keyboard_input_source_set_layout_type (self, g_value_get_enum (value));
		break;
		case KEYBOARD_INPUT_SOURCE_NAME_PROPERTY:
		keyboard_input_source_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

