/* shotwell-video-thumbnailer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from shotwell-video-thumbnailer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * 
 * This is a Vala-rewrite of GStreamer snapshot example. Adapted from earlier 
 * work from Wim Taymans.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Shotwell Thumbnailer takes in a video file and returns a thumbnail to stdout.  This is*/
/* a replacement for totem-video-thumbnailer*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gst/gst.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>

#define SHOTWELL_THUMBNAILER_caps_string "video/x-raw,format=RGB,pixel-aspect-ratio=1/1"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SHOTWELL_THUMBNAILER (shotwell_thumbnailer_get_type ())
#define SHOTWELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailer))
#define SHOTWELL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailerClass))
#define IS_SHOTWELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_THUMBNAILER))
#define IS_SHOTWELL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_THUMBNAILER))
#define SHOTWELL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailerClass))

typedef struct _ShotwellThumbnailer ShotwellThumbnailer;
typedef struct _ShotwellThumbnailerClass ShotwellThumbnailerClass;
typedef struct _ShotwellThumbnailerPrivate ShotwellThumbnailerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
typedef struct _ParamSpecShotwellThumbnailer ParamSpecShotwellThumbnailer;

struct _ShotwellThumbnailer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ShotwellThumbnailerPrivate * priv;
};

struct _ShotwellThumbnailerClass {
	GTypeClass parent_class;
	void (*finalize) (ShotwellThumbnailer *self);
};

struct _ParamSpecShotwellThumbnailer {
	GParamSpec parent_instance;
};

static gpointer shotwell_thumbnailer_parent_class = NULL;

VALA_EXTERN gpointer shotwell_thumbnailer_ref (gpointer instance);
VALA_EXTERN void shotwell_thumbnailer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_shotwell_thumbnailer (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_shotwell_thumbnailer (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_shotwell_thumbnailer (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_shotwell_thumbnailer (const GValue* value);
VALA_EXTERN GType shotwell_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShotwellThumbnailer, shotwell_thumbnailer_unref)
static gint shotwell_thumbnailer_main (gchar** args,
                                gint args_length1);
static gboolean __lambda4_ (GstPluginFeature* f);
static gboolean ___lambda4__gst_plugin_feature_filter (GstPluginFeature* feature,
                                                gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN ShotwellThumbnailer* shotwell_thumbnailer_new (void);
VALA_EXTERN ShotwellThumbnailer* shotwell_thumbnailer_construct (GType object_type);
static void shotwell_thumbnailer_finalize (ShotwellThumbnailer * obj);
static GType shotwell_thumbnailer_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda4_ (GstPluginFeature* f)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (f, gst_plugin_feature_get_type ()), FALSE);
	_tmp0_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (f, gst_object_get_type (), GstObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, "vaapi");
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
___lambda4__gst_plugin_feature_filter (GstPluginFeature* feature,
                                       gpointer self)
{
	gboolean result;
	result = __lambda4_ (feature);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gint
shotwell_thumbnailer_main (gchar** args,
                           gint args_length1)
{
	GstElement* pipeline = NULL;
	GstElement* sink = NULL;
	gchar* descr = NULL;
	GdkPixbuf* pixbuf = NULL;
	guint8* pngdata = NULL;
	gint pngdata_length1 = 0;
	gint _pngdata_size_ = 0;
	gint64 duration = 0LL;
	gint64 position = 0LL;
	GstStateChangeReturn ret = 0;
	GOutputStream* out = NULL;
	GFile* out_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp12_;
	GstRegistry* _tmp13_;
	GList* features = NULL;
	GstRegistry* _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _inner_error0_ = NULL;
	gint result;
	if (args_length1 != 3) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = stdout;
		_tmp1_ = args[0];
		fprintf (_tmp0_, "usage: %s <filename> <output> \n Writes video thumbnail to output\n", _tmp1_);
		result = 1;
		_g_object_unref0 (out);
		pngdata = (g_free (pngdata), NULL);
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		return result;
	}
	_tmp2_ = args[2];
	_tmp3_ = g_file_new_for_commandline_arg (_tmp2_);
	out_file = _tmp3_;
	{
		GFileOutputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileOutputStream* _tmp6_;
		GFileOutputStream* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = out_file;
		_tmp6_ = g_file_append_to (_tmp5_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (out);
		out = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_output_stream_get_type (), GOutputStream);
		_tmp8_ = args[2];
		g_debug ("shotwell-video-thumbnailer.vala:32: Writing thumbnail to %s", _tmp8_);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("shotwell-video-thumbnailer.vala:34: Failed to append to image file %s", _tmp10_);
		result = 1;
		_g_error_free0 (err);
		_g_object_unref0 (out_file);
		_g_object_unref0 (out);
		pngdata = (g_free (pngdata), NULL);
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp11_ = -1;
		_g_object_unref0 (out_file);
		_g_object_unref0 (out);
		pngdata = (g_free (pngdata), NULL);
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	if (nice (19) < 0) {
		g_debug ("shotwell-video-thumbnailer.vala:39: Failed to reduce thumbnailer nice " \
"level. Continuing anyway");
	}
	gst_init ((gint*) (&args_length1), &args);
	_tmp12_ = gst_registry_get ();
	_tmp13_ = _g_object_ref0 (_tmp12_);
	registry = _tmp13_;
	_tmp14_ = registry;
	_tmp15_ = gst_registry_feature_filter (_tmp14_, ___lambda4__gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp15_;
	_tmp16_ = features;
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp16_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp17_;
			GstPluginFeature* feature = NULL;
			_tmp17_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp17_;
			{
				GstPluginFeature* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GstRegistry* _tmp21_;
				GstPluginFeature* _tmp22_;
				_tmp18_ = feature;
				_tmp19_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gst_object_get_type (), GstObject));
				_tmp20_ = _tmp19_;
				g_debug ("shotwell-video-thumbnailer.vala:50: Removing registry feature %s", _tmp20_);
				_g_free0 (_tmp20_);
				_tmp21_ = registry;
				_tmp22_ = feature;
				gst_registry_remove_feature (_tmp21_, _tmp22_);
				_g_object_unref0 (feature);
			}
		}
	}
	_tmp23_ = args[1];
	_tmp24_ = g_file_new_for_commandline_arg (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_file_get_uri (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("playbin uri=\"%s\" audio-sink=fakesink video-sink=\"gdkpixbufsink name" \
"=sink\"", _tmp27_);
	_g_free0 (descr);
	descr = _tmp28_;
	_g_free0 (_tmp27_);
	_g_object_unref0 (_tmp25_);
	{
		GstElement* _tmp29_ = NULL;
		const gchar* _tmp30_;
		GstElement* _tmp31_;
		GstElement* _tmp32_;
		GstElement* _tmp33_;
		GstElement* _tmp34_;
		GstElement* _tmp35_;
		GstElement* _tmp36_;
		GstElement* _tmp37_;
		GstElement* _tmp38_;
		gint64 _tmp39_ = 0LL;
		gboolean _tmp40_;
		GstElement* _tmp41_;
		GstElement* _tmp42_;
		GstElement* _tmp43_;
		GdkPixbuf* _tmp44_ = NULL;
		GstTagList* tags = NULL;
		GstElement* _tmp45_;
		GstTagList* _tmp46_ = NULL;
		GdkPixbufRotation direction = 0;
		GstTagList* _tmp47_;
		GdkPixbuf* _tmp56_;
		GstElement* _tmp64_;
		_tmp30_ = descr;
		_tmp31_ = gst_parse_launch_full (_tmp30_, NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp32_ = _tmp29_;
		_tmp29_ = NULL;
		if (_tmp32_ != NULL) {
			g_object_ref_sink (_tmp32_);
		}
		_g_object_unref0 (pipeline);
		pipeline = _tmp32_;
		_tmp33_ = pipeline;
		g_object_get (_tmp33_, "video-sink", &_tmp34_, NULL);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (sink);
		sink = _tmp35_;
		_tmp36_ = pipeline;
		ret = gst_element_set_state (_tmp36_, GST_STATE_PAUSED);
		if (ret == GST_STATE_CHANGE_FAILURE) {
			g_warning ("shotwell-video-thumbnailer.vala:67: Failed to play the file: couldn't " \
"set state\n");
			result = 3;
			_g_object_unref0 (_tmp29_);
			(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (out_file);
			_g_object_unref0 (out);
			pngdata = (g_free (pngdata), NULL);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		} else {
			if (ret == GST_STATE_CHANGE_NO_PREROLL) {
				g_warning ("shotwell-video-thumbnailer.vala:70: Live sources not supported yet.\n");
				result = 4;
				_g_object_unref0 (_tmp29_);
				(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
				_g_object_unref0 (registry);
				_g_object_unref0 (out_file);
				_g_object_unref0 (out);
				pngdata = (g_free (pngdata), NULL);
				_g_object_unref0 (pixbuf);
				_g_free0 (descr);
				_g_object_unref0 (sink);
				_g_object_unref0 (pipeline);
				return result;
			}
		}
		_tmp37_ = pipeline;
		ret = gst_element_get_state (_tmp37_, NULL, NULL, (GstClockTime) (5 * GST_SECOND));
		if (ret == GST_STATE_CHANGE_FAILURE) {
			g_warning ("shotwell-video-thumbnailer.vala:79: Failed to play the file: couldn't " \
"get state.\n");
			result = 3;
			_g_object_unref0 (_tmp29_);
			(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (out_file);
			_g_object_unref0 (out);
			pngdata = (g_free (pngdata), NULL);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		}
		_tmp38_ = pipeline;
		_tmp40_ = gst_element_query_duration (_tmp38_, GST_FORMAT_TIME, &_tmp39_);
		duration = _tmp39_;
		if (!_tmp40_) {
			g_warning ("shotwell-video-thumbnailer.vala:85: Failed to query file for duration\n");
			result = 3;
			_g_object_unref0 (_tmp29_);
			(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (out_file);
			_g_object_unref0 (out);
			pngdata = (g_free (pngdata), NULL);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		}
		position = (gint64) (1 * GST_SECOND);
		_tmp41_ = pipeline;
		gst_element_seek_simple (_tmp41_, GST_FORMAT_TIME, GST_SEEK_FLAG_KEY_UNIT | GST_SEEK_FLAG_FLUSH, position);
		_tmp42_ = pipeline;
		ret = gst_element_get_state (_tmp42_, NULL, NULL, (GstClockTime) (5 * GST_SECOND));
		if (ret == GST_STATE_CHANGE_FAILURE) {
			g_warning ("shotwell-video-thumbnailer.vala:99: Failed to play the file: couldn't " \
"get state.\n");
			result = 3;
			_g_object_unref0 (_tmp29_);
			(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (out_file);
			_g_object_unref0 (out);
			pngdata = (g_free (pngdata), NULL);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		}
		_tmp43_ = sink;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, G_TYPE_OBJECT, GObject), "last-pixbuf", &_tmp44_, NULL);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp44_;
		_tmp45_ = pipeline;
		g_signal_emit_by_name (_tmp45_, "get-video-tags", 0, &_tmp46_, NULL);
		_gst_tag_list_unref0 (tags);
		tags = _tmp46_;
		direction = GDK_PIXBUF_ROTATE_NONE;
		_tmp47_ = tags;
		if (_tmp47_ != NULL) {
			gchar* orientation = NULL;
			GstTagList* _tmp48_;
			gchar* _tmp49_ = NULL;
			gboolean _tmp50_;
			orientation = NULL;
			_tmp48_ = tags;
			_tmp50_ = gst_tag_list_get_string_index (_tmp48_, GST_TAG_IMAGE_ORIENTATION, (guint) 0, &_tmp49_);
			_g_free0 (orientation);
			orientation = _tmp49_;
			if (_tmp50_) {
				const gchar* _tmp51_;
				_tmp51_ = orientation;
				if (_tmp51_ != NULL) {
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					GQuark _tmp55_ = 0U;
					static GQuark _tmp54_label0 = 0;
					static GQuark _tmp54_label1 = 0;
					static GQuark _tmp54_label2 = 0;
					_tmp52_ = orientation;
					_tmp53_ = _tmp52_;
					_tmp55_ = (NULL == _tmp53_) ? 0 : g_quark_from_string (_tmp53_);
					if (_tmp55_ == ((0 != _tmp54_label0) ? _tmp54_label0 : (_tmp54_label0 = g_quark_from_static_string ("rotate-90")))) {
						switch (0) {
							default:
							{
								direction = GDK_PIXBUF_ROTATE_CLOCKWISE;
								break;
							}
						}
					} else if (_tmp55_ == ((0 != _tmp54_label1) ? _tmp54_label1 : (_tmp54_label1 = g_quark_from_static_string ("rotate-180")))) {
						switch (0) {
							default:
							{
								direction = GDK_PIXBUF_ROTATE_UPSIDEDOWN;
								break;
							}
						}
					} else if (_tmp55_ == ((0 != _tmp54_label2) ? _tmp54_label2 : (_tmp54_label2 = g_quark_from_static_string ("rotate-270")))) {
						switch (0) {
							default:
							{
								direction = GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE;
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								break;
							}
						}
					}
				}
			}
			_g_free0 (orientation);
		}
		_tmp56_ = pixbuf;
		if (_tmp56_ != NULL) {
			GdkPixbuf* _tmp59_;
			guint8* _tmp60_ = NULL;
			gsize _tmp61_ = 0;
			GOutputStream* _tmp62_;
			guint8* _tmp63_;
			gint _tmp63__length1;
			if (direction != GDK_PIXBUF_ROTATE_NONE) {
				GdkPixbuf* _tmp57_;
				GdkPixbuf* _tmp58_;
				_tmp57_ = pixbuf;
				_tmp58_ = gdk_pixbuf_rotate_simple (_tmp57_, direction);
				_g_object_unref0 (pixbuf);
				pixbuf = _tmp58_;
			}
			_tmp59_ = pixbuf;
			gdk_pixbuf_save_to_buffer (_tmp59_, &_tmp60_, &_tmp61_, "png", &_inner_error0_, NULL);
			pngdata = (g_free (pngdata), NULL);
			pngdata = _tmp60_;
			pngdata_length1 = _tmp61_;
			_pngdata_size_ = pngdata_length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_gst_tag_list_unref0 (tags);
				_g_object_unref0 (_tmp29_);
				goto __catch1_g_error;
			}
			_tmp62_ = out;
			_tmp63_ = pngdata;
			_tmp63__length1 = pngdata_length1;
			g_output_stream_write (_tmp62_, _tmp63_, (gsize) _tmp63__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_gst_tag_list_unref0 (tags);
				_g_object_unref0 (_tmp29_);
				goto __catch1_g_error;
			}
		}
		_tmp64_ = pipeline;
		gst_element_set_state (_tmp64_, GST_STATE_NULL);
		_gst_tag_list_unref0 (tags);
		_g_object_unref0 (_tmp29_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp65_;
		const gchar* _tmp66_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp65_ = e;
		_tmp66_ = _tmp65_->message;
		g_warning ("shotwell-video-thumbnailer.vala:142: %s", _tmp66_);
		result = 2;
		_g_error_free0 (e);
		(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
		_g_object_unref0 (registry);
		_g_object_unref0 (out_file);
		_g_object_unref0 (out);
		pngdata = (g_free (pngdata), NULL);
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp67_ = -1;
		(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
		_g_object_unref0 (registry);
		_g_object_unref0 (out_file);
		_g_object_unref0 (out);
		pngdata = (g_free (pngdata), NULL);
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp67_;
	}
	result = 0;
	(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
	_g_object_unref0 (registry);
	_g_object_unref0 (out_file);
	_g_object_unref0 (out);
	pngdata = (g_free (pngdata), NULL);
	_g_object_unref0 (pixbuf);
	_g_free0 (descr);
	_g_object_unref0 (sink);
	_g_object_unref0 (pipeline);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return shotwell_thumbnailer_main (argv, argc);
}

ShotwellThumbnailer*
shotwell_thumbnailer_construct (GType object_type)
{
	ShotwellThumbnailer* self = NULL;
	self = (ShotwellThumbnailer*) g_type_create_instance (object_type);
	return self;
}

ShotwellThumbnailer*
shotwell_thumbnailer_new (void)
{
	return shotwell_thumbnailer_construct (TYPE_SHOTWELL_THUMBNAILER);
}

static void
value_shotwell_thumbnailer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_shotwell_thumbnailer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		shotwell_thumbnailer_unref (value->data[0].v_pointer);
	}
}

static void
value_shotwell_thumbnailer_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = shotwell_thumbnailer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_shotwell_thumbnailer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_shotwell_thumbnailer_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ShotwellThumbnailer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = shotwell_thumbnailer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_shotwell_thumbnailer_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ShotwellThumbnailer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = shotwell_thumbnailer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_shotwell_thumbnailer (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ParamSpecShotwellThumbnailer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SHOTWELL_THUMBNAILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_shotwell_thumbnailer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_shotwell_thumbnailer (GValue* value,
                                gpointer v_object)
{
	ShotwellThumbnailer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHOTWELL_THUMBNAILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		shotwell_thumbnailer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		shotwell_thumbnailer_unref (old);
	}
}

void
value_take_shotwell_thumbnailer (GValue* value,
                                 gpointer v_object)
{
	ShotwellThumbnailer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHOTWELL_THUMBNAILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		shotwell_thumbnailer_unref (old);
	}
}

static void
shotwell_thumbnailer_class_init (ShotwellThumbnailerClass * klass,
                                 gpointer klass_data)
{
	shotwell_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	((ShotwellThumbnailerClass *) klass)->finalize = shotwell_thumbnailer_finalize;
}

static void
shotwell_thumbnailer_instance_init (ShotwellThumbnailer * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
shotwell_thumbnailer_finalize (ShotwellThumbnailer * obj)
{
	ShotwellThumbnailer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailer);
	g_signal_handlers_destroy (self);
}

static GType
shotwell_thumbnailer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_shotwell_thumbnailer_init, value_shotwell_thumbnailer_free_value, value_shotwell_thumbnailer_copy_value, value_shotwell_thumbnailer_peek_pointer, "p", value_shotwell_thumbnailer_collect_value, "p", value_shotwell_thumbnailer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ShotwellThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shotwell_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShotwellThumbnailer), 0, (GInstanceInitFunc) shotwell_thumbnailer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType shotwell_thumbnailer_type_id;
	shotwell_thumbnailer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ShotwellThumbnailer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return shotwell_thumbnailer_type_id;
}

GType
shotwell_thumbnailer_get_type (void)
{
	static volatile gsize shotwell_thumbnailer_type_id__once = 0;
	if (g_once_init_enter (&shotwell_thumbnailer_type_id__once)) {
		GType shotwell_thumbnailer_type_id;
		shotwell_thumbnailer_type_id = shotwell_thumbnailer_get_type_once ();
		g_once_init_leave (&shotwell_thumbnailer_type_id__once, shotwell_thumbnailer_type_id);
	}
	return shotwell_thumbnailer_type_id__once;
}

gpointer
shotwell_thumbnailer_ref (gpointer instance)
{
	ShotwellThumbnailer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
shotwell_thumbnailer_unref (gpointer instance)
{
	ShotwellThumbnailer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SHOTWELL_THUMBNAILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

