/* DirectoryMonitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DirectoryMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* DirectoryMonitor will monitor an entire directory for changes to all files and directories*/
/* within it.  It uses FileMonitor to monitor all directories it discovers at initialization*/
/* and reports changes to the files and directories just as FileMonitor reports them.  Subclasses*/
/* can override the notify_* methods to filter or monitor events before the signal is fired,*/
/* or can override the signals themselves to be notified afterwards.*/
/**/
/* start_discovery() must be called to initiate monitoring.  Directories and files will be reported*/
/* as they're discovered.  Directories will be monitored as they're discovered as well.  Discovery*/
/* can only be initiated once.*/
/**/
/* All signals are virtual and have a corresponding notify_* protected virtual function.*/
/* Subclasses can either override the notify or the signal to decide when they want to process*/
/* the event.*/
/**/
/* DirectoryMonitor also adds a level of intelligence to GLib's monitoring API.Because certain*/
/* file/directory events are decomposed by FileMonitor into more atomic events, it's difficult*/
/* to know when these "composed" events have occurred.  (For example, a file move is reported*/
/* as a DELETED event followed by a CREATED event, with no clue that the two are related.)  Later*/
/* versions added the MOVE event, but we can't rely on those being installed.  Also, documentation*/
/* suggests it's only available with certain back-ends.*/
/**/
/* DirectoryMonitor attempts to solve this by deducing when a set of events actually equals*/
/* a composite event.  It requires more memory in order to do this (i.e. it stores all files and*/
/* their information), but the trade-off is easier file/directory monitoring via familiar*/
/* semantics.*/
/**/
/* DirectoryMonitor also will synthesize events when normal monitor events don't produce expected*/
/* results.  For example, if a directory is moved out of DirectoryMonitor's root, it is reported*/
/* as a delete event, but none of its children are reported as deleted.  Similarly, a directory*/
/* rename can be captured as a move, but notifications for all its children are not fired and*/
/* are synthesized by DirectoryMonitor.  DirectoryMonitor will fire delete and move notifications*/
/* for all the directory's children in depth-first order.*/
/**/
/* In general, DirectoryMonitor attempts to preserve ordering of events, so that (for example) a*/
/* file-altered event doesn't fire before a file-created, and so on.*/
/**/
/* Because of these requirements, DirectoryMonitor maintains a FileInfo struct on all directories */
/* and files being monitored.  (It maintains the attributes gather during the discovery phase, i.e. */
/* SUPPLIED_ATTRIBUTES.)  This information can be retrieved via get_info(), get_file_id(), and*/
/* get_etag().  These calls can be made at any time; the information is stored before any signal*/
/* is fired.*/
/**/
/* Note that DirectoryMonitor currently only supports files and directories.  Other file types*/
/* (special, symbolic links, shortcuts, and mount points) are not supported.  It has been seen*/
/* when a temporary file is created for its file type to be reported as "unknown" and when it's*/
/* altered/deleted to be reported as a regular file.  This means it's possible for a file not to*/
/* be reported as discovered or created but to be reported as altered and/or deleted.*/
/**/
/* DirectoryMonitor can be configured to not recurse (in which case it only discovers/monitors*/
/* the root directory) and to not monitor (in which case only discovery occurs).*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define DIRECTORY_MONITOR_DEFAULT_PRIORITY G_PRIORITY_LOW
#define DIRECTORY_MONITOR_DIR_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_FILE_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_SUPPORT_DIR_SYMLINKS TRUE
#define DIRECTORY_MONITOR_SUPPORT_FILE_SYMLINKS FALSE
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
#define DIRECTORY_MONITOR_FILE_MONITOR_FLAGS G_FILE_MONITOR_SEND_MOVED
#define DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC ((guint) 500)
#define DIRECTORY_MONITOR_MAX_EXPLORATION_DIRS 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;
typedef struct _DirectoryMonitorPrivate DirectoryMonitorPrivate;

#define DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT (directory_monitor_query_info_queue_element_get_type ())
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElement))
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElementClass))
#define DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT))
#define DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT))
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElementClass))

typedef struct _DirectoryMonitorQueryInfoQueueElement DirectoryMonitorQueryInfoQueueElement;
typedef struct _DirectoryMonitorQueryInfoQueueElementClass DirectoryMonitorQueryInfoQueueElementClass;

#define DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP (directory_monitor_file_info_map_get_type ())
#define DIRECTORY_MONITOR_FILE_INFO_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMap))
#define DIRECTORY_MONITOR_FILE_INFO_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapClass))
#define DIRECTORY_MONITOR_IS_FILE_INFO_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP))
#define DIRECTORY_MONITOR_IS_FILE_INFO_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP))
#define DIRECTORY_MONITOR_FILE_INFO_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapClass))

typedef struct _DirectoryMonitorFileInfoMap DirectoryMonitorFileInfoMap;
typedef struct _DirectoryMonitorFileInfoMapClass DirectoryMonitorFileInfoMapClass;
enum  {
	DIRECTORY_MONITOR_0_PROPERTY,
	DIRECTORY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* directory_monitor_properties[DIRECTORY_MONITOR_NUM_PROPERTIES];
typedef enum  {
	DIRECTORY_MONITOR_FTYPE_FILE,
	DIRECTORY_MONITOR_FTYPE_DIRECTORY,
	DIRECTORY_MONITOR_FTYPE_UNSUPPORTED
} DirectoryMonitorFType;

#define DIRECTORY_MONITOR_TYPE_FTYPE (directory_monitor_ftype_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _directory_monitor_file_info_map_unref0(var) ((var == NULL) ? NULL : (var = (directory_monitor_file_info_map_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DirectoryMonitorAsyncInternalNotifyDirectoryMovedData DirectoryMonitorAsyncInternalNotifyDirectoryMovedData;
typedef struct _DirectoryMonitorAsyncNotifyDirectoryDeletedData DirectoryMonitorAsyncNotifyDirectoryDeletedData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DirectoryMonitorExploreAsyncData DirectoryMonitorExploreAsyncData;
typedef struct _DirectoryMonitorNotifyDirectoryFilesData DirectoryMonitorNotifyDirectoryFilesData;
typedef struct _DirectoryMonitorQueryInfoQueueElementPrivate DirectoryMonitorQueryInfoQueueElementPrivate;
#define _directory_monitor_query_info_queue_element_unref0(var) ((var == NULL) ? NULL : (var = (directory_monitor_query_info_queue_element_unref (var), NULL)))
typedef struct _DirectoryMonitorParamSpecQueryInfoQueueElement DirectoryMonitorParamSpecQueryInfoQueueElement;
typedef struct _DirectoryMonitorFileInfoMapPrivate DirectoryMonitorFileInfoMapPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _DirectoryMonitorParamSpecFileInfoMap DirectoryMonitorParamSpecFileInfoMap;
enum  {
	DIRECTORY_MONITOR_ROOT_MOVED_SIGNAL,
	DIRECTORY_MONITOR_ROOT_DELETED_SIGNAL,
	DIRECTORY_MONITOR_DISCOVERY_STARTED_SIGNAL,
	DIRECTORY_MONITOR_FILE_DISCOVERED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_DISCOVERED_SIGNAL,
	DIRECTORY_MONITOR_DISCOVERY_FAILED_SIGNAL,
	DIRECTORY_MONITOR_DISCOVERY_COMPLETED_SIGNAL,
	DIRECTORY_MONITOR_FILE_CREATED_SIGNAL,
	DIRECTORY_MONITOR_FILE_MOVED_SIGNAL,
	DIRECTORY_MONITOR_FILE_ALTERED_SIGNAL,
	DIRECTORY_MONITOR_FILE_ALTERATION_COMPLETED_SIGNAL,
	DIRECTORY_MONITOR_FILE_ATTRIBUTES_ALTERED_SIGNAL,
	DIRECTORY_MONITOR_FILE_DELETED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_CREATED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_MOVED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_ALTERED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_ALTERATION_COMPLETED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_ATTRIBUTES_ALTERED_SIGNAL,
	DIRECTORY_MONITOR_DIRECTORY_DELETED_SIGNAL,
	DIRECTORY_MONITOR_CLOSED_SIGNAL,
	DIRECTORY_MONITOR_NUM_SIGNALS
};
static guint directory_monitor_signals[DIRECTORY_MONITOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DirectoryMonitor {
	GObject parent_instance;
	DirectoryMonitorPrivate * priv;
};

struct _DirectoryMonitorClass {
	GObjectClass parent_class;
	void (*notify_root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*notify_root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*notify_discovery_started) (DirectoryMonitor* self);
	void (*internal_notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*internal_notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*notify_discovery_completed) (DirectoryMonitor* self);
	void (*notify_file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*notify_file_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*notify_directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*notify_directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*notify_closed) (DirectoryMonitor* self);
	void (*close) (DirectoryMonitor* self);
	void (*root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*discovery_started) (DirectoryMonitor* self);
	void (*file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*directory_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*discovery_completed) (DirectoryMonitor* self);
	void (*file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*file_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*closed) (DirectoryMonitor* self);
};

struct _DirectoryMonitorPrivate {
	GFile* root;
	gboolean recurse;
	gboolean monitoring;
	GeeHashMap* monitors;
	GeeQueue* query_info_queue;
	DirectoryMonitorFileInfoMap* files;
	DirectoryMonitorFileInfoMap* parent_moved;
	GCancellable* cancellable;
	gint outstanding_exploration_dirs;
	gboolean started;
	gboolean has_discovery_started;
	guint delete_timer_id;
};

struct _DirectoryMonitorAsyncInternalNotifyDirectoryMovedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DirectoryMonitor* self;
	GFile* old_dir;
	GFileInfo* old_dir_info;
	GFile* new_dir;
	GFileInfo* new_dir_info;
	GeeArrayList* file_children;
	GeeArrayList* _tmp0_;
	GeeArrayList* dir_children;
	GeeArrayList* _tmp1_;
	gint count;
	DirectoryMonitorFileInfoMap* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _dir_child_list;
	GeeArrayList* _tmp5_;
	gint _dir_child_size;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _dir_child_index;
	gint _tmp9_;
	gint _tmp10_;
	GFile* dir_child;
	GeeArrayList* _tmp11_;
	gpointer _tmp12_;
	GFileInfo* dir_info;
	DirectoryMonitorFileInfoMap* _tmp13_;
	GFile* _tmp14_;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GFile* _tmp20_;
	GFileInfo* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFileInfo* _tmp27_;
	GeeArrayList* _file_child_list;
	GeeArrayList* _tmp28_;
	gint _file_child_size;
	GeeArrayList* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _file_child_index;
	gint _tmp32_;
	gint _tmp33_;
	GFile* file_child;
	GeeArrayList* _tmp34_;
	gpointer _tmp35_;
	GFileInfo* file_info;
	DirectoryMonitorFileInfoMap* _tmp36_;
	GFile* _tmp37_;
	GFileInfo* _tmp38_;
	GFileInfo* _tmp39_;
	GFile* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	GFileInfo* _tmp49_;
	DirectoryMonitorFileInfoMap* _tmp50_;
	gboolean updated;
	DirectoryMonitorFileInfoMap* _tmp51_;
};

struct _DirectoryMonitorAsyncNotifyDirectoryDeletedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DirectoryMonitor* self;
	GFile* dir;
	gboolean already_removed;
	GeeArrayList* file_children;
	GeeArrayList* _tmp0_;
	GeeArrayList* dir_children;
	GeeArrayList* _tmp1_;
	gint count;
	DirectoryMonitorFileInfoMap* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _dir_child_list;
	GeeArrayList* _tmp5_;
	gint _dir_child_size;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _dir_child_index;
	gint _tmp9_;
	gint _tmp10_;
	GFile* dir_child;
	GeeArrayList* _tmp11_;
	gpointer _tmp12_;
	GFile* _tmp13_;
	GeeArrayList* _file_child_list;
	GeeArrayList* _tmp14_;
	gint _file_child_size;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _file_child_index;
	gint _tmp18_;
	gint _tmp19_;
	GFile* file_child;
	GeeArrayList* _tmp20_;
	gpointer _tmp21_;
	DirectoryMonitorFileInfoMap* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	DirectoryMonitorFileInfoMap* _tmp25_;
};

struct _DirectoryMonitorExploreAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DirectoryMonitor* self;
	GFile* dir;
	GFileInfo* dir_info;
	gboolean in_discovery;
	DirectoryMonitorFileInfoMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFileInfo* local_dir_info;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	GCancellable* _tmp6_;
	GFileInfo* _tmp7_;
	GFileInfo* _tmp8_;
	GError* err;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GFileInfo* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GFileInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	GFileInfo* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFileInfo* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFileInfo* _tmp26_;
	GEnumValue* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GeeHashMap* dir_map;
	GeeHashMap* file_map;
	GFileEnumerator* enumerator;
	GCancellable* _tmp30_;
	GFileEnumerator* _tmp31_;
	gboolean _tmp32_;
	GList* infos;
	GFileEnumerator* _tmp33_;
	GCancellable* _tmp34_;
	GList* _tmp35_;
	GList* _tmp36_;
	GList* _tmp37_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp38_;
	GFileInfo* info;
	GFileInfo* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	GFileInfo* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GFileInfo* _tmp46_;
	GFileInfo* _tmp47_;
	const gchar* _tmp48_;
	GFile* _tmp49_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GFileInfo* _tmp53_;
	GFileInfo* _tmp54_;
	GeeHashMap* _tmp55_;
	GeeHashMap* _tmp56_;
	GeeHashMap* _tmp57_;
	GFileInfo* _tmp58_;
	const gchar* _tmp59_;
	GFile* _tmp60_;
	GFile* _tmp61_;
	GFileInfo* _tmp62_;
	GeeHashMap* _tmp63_;
	GeeHashMap* _tmp64_;
	GeeHashMap* _tmp65_;
	GFileInfo* _tmp66_;
	const gchar* _tmp67_;
	GFile* _tmp68_;
	GFile* _tmp69_;
	GFileInfo* _tmp70_;
	GError* err2;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GError* _tmp73_;
	const gchar* _tmp74_;
	GFileInfo* _tmp75_;
	GFileInfo* _tmp76_;
	GFileInfo* _tmp77_;
	GeeHashMap* _tmp78_;
	GeeHashMap* _tmp79_;
	gboolean _tmp80_;
	GeeHashMap* _tmp81_;
	GeeIterator* _subdir_it;
	GeeHashMap* _tmp82_;
	GeeSet* _tmp83_;
	GeeSet* _tmp84_;
	GeeSet* _tmp85_;
	GeeIterator* _tmp86_;
	GeeIterator* _tmp87_;
	GeeIterator* _tmp88_;
	GFile* subdir;
	GeeIterator* _tmp89_;
	gpointer _tmp90_;
	gint _tmp91_;
	GFile* _tmp92_;
	GeeHashMap* _tmp93_;
	GFile* _tmp94_;
	gpointer _tmp95_;
	GFileInfo* _tmp96_;
	GFile* _tmp97_;
	GeeHashMap* _tmp98_;
	GFile* _tmp99_;
	gpointer _tmp100_;
	GFileInfo* _tmp101_;
	GError* _inner_error0_;
};

struct _DirectoryMonitorNotifyDirectoryFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DirectoryMonitor* self;
	GeeMap* map;
	gboolean in_discovery;
	GeeMapIterator* iter;
	GeeMapIterator* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeMapIterator* _tmp2_;
	gpointer _tmp3_;
	GFile* _tmp4_;
	GeeMapIterator* _tmp5_;
	gpointer _tmp6_;
	GFileInfo* _tmp7_;
	GeeMapIterator* _tmp8_;
	gpointer _tmp9_;
	GFile* _tmp10_;
	GeeMapIterator* _tmp11_;
	gpointer _tmp12_;
	GFileInfo* _tmp13_;
};

struct _DirectoryMonitorQueryInfoQueueElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DirectoryMonitorQueryInfoQueueElementPrivate * priv;
	DirectoryMonitor* owner;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event;
	guint position;
	gulong time_created_msec;
	GFileInfo* info;
	GError* err;
	gboolean completed;
};

struct _DirectoryMonitorQueryInfoQueueElementClass {
	GTypeClass parent_class;
	void (*finalize) (DirectoryMonitorQueryInfoQueueElement *self);
};

struct _DirectoryMonitorParamSpecQueryInfoQueueElement {
	GParamSpec parent_instance;
};

struct _DirectoryMonitorFileInfoMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DirectoryMonitorFileInfoMapPrivate * priv;
};

struct _DirectoryMonitorFileInfoMapClass {
	GTypeClass parent_class;
	void (*finalize) (DirectoryMonitorFileInfoMap *self);
};

struct _DirectoryMonitorFileInfoMapPrivate {
	GeeHashMap* map;
	GeeHashMap* id_map;
};

struct _DirectoryMonitorParamSpecFileInfoMap {
	GParamSpec parent_instance;
};

static gint DirectoryMonitor_private_offset;
static gpointer directory_monitor_parent_class = NULL;
static gpointer directory_monitor_query_info_queue_element_parent_class = NULL;
static guint directory_monitor_query_info_queue_element_current;
static guint directory_monitor_query_info_queue_element_current = (guint) 0;
static gint DirectoryMonitorFileInfoMap_private_offset;
static gpointer directory_monitor_file_info_map_parent_class = NULL;

VALA_EXTERN GType directory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectoryMonitor, g_object_unref)
static gpointer directory_monitor_query_info_queue_element_ref (gpointer instance);
static void directory_monitor_query_info_queue_element_unref (gpointer instance);
static GParamSpec* directory_monitor_param_spec_query_info_queue_element (const gchar* name,
                                                                   const gchar* nick,
                                                                   const gchar* blurb,
                                                                   GType object_type,
                                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void directory_monitor_value_set_query_info_queue_element (GValue* value,
                                                           gpointer v_object) G_GNUC_UNUSED ;
static void directory_monitor_value_take_query_info_queue_element (GValue* value,
                                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer directory_monitor_value_get_query_info_queue_element (const GValue* value) G_GNUC_UNUSED ;
static GType directory_monitor_query_info_queue_element_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectoryMonitorQueryInfoQueueElement, directory_monitor_query_info_queue_element_unref)
static gpointer directory_monitor_file_info_map_ref (gpointer instance);
static void directory_monitor_file_info_map_unref (gpointer instance);
static GParamSpec* directory_monitor_param_spec_file_info_map (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED ;
static void directory_monitor_value_set_file_info_map (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static void directory_monitor_value_take_file_info_map (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED ;
static gpointer directory_monitor_value_get_file_info_map (const GValue* value) G_GNUC_UNUSED ;
static GType directory_monitor_file_info_map_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DirectoryMonitorFileInfoMap, directory_monitor_file_info_map_unref)
VALA_EXTERN void directory_monitor_notify_root_deleted (DirectoryMonitor* self,
                                            GFile* root);
VALA_EXTERN void directory_monitor_notify_root_moved (DirectoryMonitor* self,
                                          GFile* old_root,
                                          GFile* new_root,
                                          GFileInfo* new_root_info);
VALA_EXTERN void directory_monitor_notify_discovery_started (DirectoryMonitor* self);
VALA_EXTERN void directory_monitor_internal_notify_file_discovered (DirectoryMonitor* self,
                                                        GFile* file,
                                                        GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_file_discovered (DirectoryMonitor* self,
                                               GFile* file,
                                               GFileInfo* info);
VALA_EXTERN void directory_monitor_internal_notify_directory_discovered (DirectoryMonitor* self,
                                                             GFile* dir,
                                                             GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_directory_discovered (DirectoryMonitor* self,
                                                    GFile* dir,
                                                    GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_discovery_failed (DirectoryMonitor* self,
                                                const gchar* reason);
VALA_EXTERN void directory_monitor_notify_discovery_completed (DirectoryMonitor* self);
VALA_EXTERN void directory_monitor_notify_file_created (DirectoryMonitor* self,
                                            GFile* file,
                                            GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_file_moved (DirectoryMonitor* self,
                                          GFile* old_file,
                                          GFile* new_file,
                                          GFileInfo* new_file_info);
VALA_EXTERN void directory_monitor_notify_file_altered (DirectoryMonitor* self,
                                            GFile* file);
VALA_EXTERN void directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self,
                                                         GFile* file,
                                                         GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self,
                                                       GFile* file);
VALA_EXTERN void directory_monitor_notify_file_deleted (DirectoryMonitor* self,
                                            GFile* file);
VALA_EXTERN void directory_monitor_notify_directory_created (DirectoryMonitor* self,
                                                 GFile* dir,
                                                 GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_directory_moved (DirectoryMonitor* self,
                                               GFile* old_dir,
                                               GFile* new_dir,
                                               GFileInfo* new_dir_info);
VALA_EXTERN void directory_monitor_notify_directory_altered (DirectoryMonitor* self,
                                                 GFile* dir);
VALA_EXTERN void directory_monitor_notify_directory_alteration_completed (DirectoryMonitor* self,
                                                              GFile* dir,
                                                              GFileInfo* info);
VALA_EXTERN void directory_monitor_notify_directory_attributes_altered (DirectoryMonitor* self,
                                                            GFile* dir);
VALA_EXTERN void directory_monitor_notify_directory_deleted (DirectoryMonitor* self,
                                                 GFile* dir);
VALA_EXTERN void directory_monitor_notify_closed (DirectoryMonitor* self);
VALA_EXTERN void directory_monitor_close (DirectoryMonitor* self);
static GType directory_monitor_ftype_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_new (void);
static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_construct (GType object_type);
VALA_EXTERN DirectoryMonitor* directory_monitor_new (GFile* root,
                                         gboolean recurse,
                                         gboolean monitoring);
VALA_EXTERN DirectoryMonitor* directory_monitor_construct (GType object_type,
                                               GFile* root,
                                               gboolean recurse,
                                               gboolean monitoring);
VALA_EXTERN void directory_monitor_mdbg (const gchar* msg);
VALA_EXTERN gboolean directory_monitor_is_recursive (DirectoryMonitor* self);
VALA_EXTERN gboolean directory_monitor_is_monitoring (DirectoryMonitor* self);
static void directory_monitor_real_notify_root_deleted (DirectoryMonitor* self,
                                                 GFile* root);
static void directory_monitor_internal_notify_root_moved (DirectoryMonitor* self,
                                                   GFile* old_root,
                                                   GFile* new_root,
                                                   GFileInfo* new_root_info);
static gboolean directory_monitor_file_info_map_remove (DirectoryMonitorFileInfoMap* self,
                                                 GFile* file,
                                                 GFileInfo* info);
static gboolean directory_monitor_file_info_map_update (DirectoryMonitorFileInfoMap* self,
                                                 GFile* file,
                                                 GFileInfo* info);
static void directory_monitor_real_notify_root_moved (DirectoryMonitor* self,
                                               GFile* old_root,
                                               GFile* new_root,
                                               GFileInfo* new_root_info);
static void directory_monitor_real_notify_discovery_started (DirectoryMonitor* self);
static void directory_monitor_real_internal_notify_file_discovered (DirectoryMonitor* self,
                                                             GFile* file,
                                                             GFileInfo* info);
static void directory_monitor_real_notify_file_discovered (DirectoryMonitor* self,
                                                    GFile* file,
                                                    GFileInfo* info);
static void directory_monitor_real_internal_notify_directory_discovered (DirectoryMonitor* self,
                                                                  GFile* dir,
                                                                  GFileInfo* info);
static void directory_monitor_real_notify_directory_discovered (DirectoryMonitor* self,
                                                         GFile* dir,
                                                         GFileInfo* info);
static void directory_monitor_real_notify_discovery_failed (DirectoryMonitor* self,
                                                     const gchar* reason);
static void directory_monitor_real_notify_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_internal_notify_file_created (DirectoryMonitor* self,
                                                     GFile* file,
                                                     GFileInfo* info);
static gboolean directory_monitor_is_file_create_move (DirectoryMonitor* self,
                                                GFile* file,
                                                GFileInfo* info,
                                                GFile** old_file,
                                                GFileInfo** old_file_info);
static void directory_monitor_internal_notify_file_moved (DirectoryMonitor* self,
                                                   GFile* old_file,
                                                   GFile* new_file,
                                                   GFileInfo* new_file_info);
static void directory_monitor_real_notify_file_created (DirectoryMonitor* self,
                                                 GFile* file,
                                                 GFileInfo* info);
static void directory_monitor_real_notify_file_moved (DirectoryMonitor* self,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* new_file_info);
static void directory_monitor_real_notify_file_altered (DirectoryMonitor* self,
                                                 GFile* file);
static void directory_monitor_internal_notify_file_alteration_completed (DirectoryMonitor* self,
                                                                  GFile* file,
                                                                  GFileInfo* info);
static void directory_monitor_real_notify_file_alteration_completed (DirectoryMonitor* self,
                                                              GFile* file,
                                                              GFileInfo* info);
static void directory_monitor_real_notify_file_attributes_altered (DirectoryMonitor* self,
                                                            GFile* file);
static void directory_monitor_internal_notify_file_deleted (DirectoryMonitor* self,
                                                     GFile* file);
static void directory_monitor_real_notify_file_deleted (DirectoryMonitor* self,
                                                 GFile* file);
static void directory_monitor_internal_notify_directory_created (DirectoryMonitor* self,
                                                          GFile* dir,
                                                          GFileInfo* info);
static void directory_monitor_file_info_map_remove_descendents (DirectoryMonitorFileInfoMap* self,
                                                         GFile* root,
                                                         DirectoryMonitorFileInfoMap* descendents);
static void directory_monitor_internal_notify_directory_moved (DirectoryMonitor* self,
                                                        GFile* old_dir,
                                                        GFileInfo* old_dir_info,
                                                        GFile* new_dir,
                                                        GFileInfo* new_dir_info);
static void directory_monitor_real_notify_directory_created (DirectoryMonitor* self,
                                                      GFile* dir,
                                                      GFileInfo* info);
static void directory_monitor_async_internal_notify_directory_moved (DirectoryMonitor* self,
                                                              GFile* old_dir,
                                                              GFileInfo* old_dir_info,
                                                              GFile* new_dir,
                                                              GFileInfo* new_dir_info,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void directory_monitor_async_internal_notify_directory_moved_finish (DirectoryMonitor* self,
                                                                     GAsyncResult* _res_);
static void directory_monitor_async_internal_notify_directory_moved_data_free (gpointer _data);
static gboolean directory_monitor_async_internal_notify_directory_moved_co (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_);
VALA_EXTERN gboolean file_equal (GFile* a,
                     GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gint directory_monitor_file_info_map_get_children (DirectoryMonitorFileInfoMap* self,
                                                   GFile* root,
                                                   GeeCollection* files,
                                                   GeeCollection* dirs);
static GFileInfo* directory_monitor_file_info_map_get_info (DirectoryMonitorFileInfoMap* self,
                                                     GFile* file);
static void directory_monitor_async_internal_notify_directory_moved_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static gboolean _directory_monitor_async_internal_notify_directory_moved_co_gsource_func (gpointer self);
static gboolean directory_monitor_remove_monitor (DirectoryMonitor* self,
                                           GFile* dir,
                                           GFileInfo* info);
static gboolean directory_monitor_add_monitor (DirectoryMonitor* self,
                                        GFile* dir,
                                        GFileInfo* info);
static void directory_monitor_real_notify_directory_moved (DirectoryMonitor* self,
                                                    GFile* old_dir,
                                                    GFile* new_dir,
                                                    GFileInfo* new_dir_info);
static void directory_monitor_real_notify_directory_altered (DirectoryMonitor* self,
                                                      GFile* dir);
static void directory_monitor_internal_notify_directory_alteration_completed (DirectoryMonitor* self,
                                                                       GFile* dir,
                                                                       GFileInfo* info);
static void directory_monitor_real_notify_directory_alteration_completed (DirectoryMonitor* self,
                                                                   GFile* dir,
                                                                   GFileInfo* info);
static void directory_monitor_real_notify_directory_attributes_altered (DirectoryMonitor* self,
                                                                 GFile* dir);
static void directory_monitor_internal_notify_directory_deleted (DirectoryMonitor* self,
                                                          GFile* dir);
static void directory_monitor_async_notify_directory_deleted (DirectoryMonitor* self,
                                                       GFile* dir,
                                                       gboolean already_removed,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void directory_monitor_async_notify_directory_deleted_finish (DirectoryMonitor* self,
                                                              GAsyncResult* _res_);
static void directory_monitor_async_notify_directory_deleted_data_free (gpointer _data);
static gboolean directory_monitor_async_notify_directory_deleted_co (DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_);
static void directory_monitor_async_notify_directory_deleted_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static gboolean _directory_monitor_async_notify_directory_deleted_co_gsource_func (gpointer self);
static void directory_monitor_real_notify_directory_deleted (DirectoryMonitor* self,
                                                      GFile* dir);
static void directory_monitor_real_notify_closed (DirectoryMonitor* self);
VALA_EXTERN GFile* directory_monitor_get_root (DirectoryMonitor* self);
VALA_EXTERN gboolean directory_monitor_is_in_root (DirectoryMonitor* self,
                                       GFile* file);
VALA_EXTERN gboolean directory_monitor_has_started (DirectoryMonitor* self);
VALA_EXTERN void directory_monitor_start_discovery (DirectoryMonitor* self);
static void directory_monitor_explore_async (DirectoryMonitor* self,
                                      GFile* dir,
                                      GFileInfo* dir_info,
                                      gboolean in_discovery,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void directory_monitor_explore_finish (DirectoryMonitor* self,
                                       GAsyncResult* _res_);
static void directory_monitor_real_close (DirectoryMonitor* self);
static void directory_monitor_cancel_monitor (DirectoryMonitor* self,
                                       GFileMonitor* monitor);
static DirectoryMonitorFType directory_monitor_get_ftype (GFileInfo* info);
static void directory_monitor_explore_async_data_free (gpointer _data);
static gboolean directory_monitor_explore_async_co (DirectoryMonitorExploreAsyncData* _data_);
static gboolean directory_monitor_file_info_map_contains (DirectoryMonitorFileInfoMap* self,
                                                   GFile* file,
                                                   GFileInfo* info);
static void directory_monitor_explore_directory_completed (DirectoryMonitor* self,
                                                    gboolean in_discovery);
static void directory_monitor_explore_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN gchar* get_file_info_id (GFileInfo* info);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN gboolean directory_monitor_is_file_symlink_supported (GFileInfo* info);
VALA_EXTERN guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
static void directory_monitor_notify_directory_files (DirectoryMonitor* self,
                                               GeeMap* map,
                                               gboolean in_discovery,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void directory_monitor_notify_directory_files_finish (DirectoryMonitor* self,
                                                      GAsyncResult* _res_);
static void directory_monitor_notify_directory_files_data_free (gpointer _data);
static gboolean directory_monitor_notify_directory_files_co (DirectoryMonitorNotifyDirectoryFilesData* _data_);
static gboolean _directory_monitor_notify_directory_files_co_gsource_func (gpointer self);
static gchar* directory_monitor_file_info_map_get_id (DirectoryMonitorFileInfoMap* self,
                                               GFile* file,
                                               GFileInfo* info);
static void directory_monitor_on_monitor_notification (DirectoryMonitor* self,
                                                GFile* file,
                                                GFile* other_file,
                                                GFileMonitorEvent event);
static void _directory_monitor_on_monitor_notification_g_file_monitor_changed (GFileMonitor* _sender,
                                                                        GFile* file,
                                                                        GFile* other_file,
                                                                        GFileMonitorEvent event_type,
                                                                        gpointer self);
static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_new (DirectoryMonitor* owner,
                                                                                       GFile* file,
                                                                                       GFile* other_file,
                                                                                       GFileMonitorEvent event);
static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_construct (GType object_type,
                                                                                             DirectoryMonitor* owner,
                                                                                             GFile* file,
                                                                                             GFile* other_file,
                                                                                             GFileMonitorEvent event);
static void directory_monitor_query_info_queue_element_on_completed (DirectoryMonitorQueryInfoQueueElement* self,
                                                              GObject* source,
                                                              GAsyncResult* aresult);
static void _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback (GObject* source_object,
                                                                                     GAsyncResult* res,
                                                                                     gpointer self);
static gboolean directory_monitor_check_for_expired_delete_events (DirectoryMonitor* self);
static gboolean _directory_monitor_check_for_expired_delete_events_gsource_func (gpointer self);
static void directory_monitor_process_query_queue (DirectoryMonitor* self,
                                            DirectoryMonitorQueryInfoQueueElement* query_info);
static GFile* directory_monitor_file_info_map_find_match (DirectoryMonitorFileInfoMap* self,
                                                   GFileInfo* match);
static void directory_monitor_on_monitor_notification_ready (DirectoryMonitor* self,
                                                      GFile* file,
                                                      GFile* other_file,
                                                      GFileInfo* info,
                                                      GFileMonitorEvent event);
VALA_EXTERN GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self,
                                            GFile* file);
VALA_EXTERN gulong now_ms (void);
VALA_EXTERN GeeCollection* directory_monitor_get_files (DirectoryMonitor* self);
static GeeCollection* directory_monitor_file_info_map_get_all (DirectoryMonitorFileInfoMap* self);
VALA_EXTERN GFileInfo* directory_monitor_query_file_info (DirectoryMonitor* self,
                                              GFile* file);
static GFileInfo* directory_monitor_file_info_map_query_info (DirectoryMonitorFileInfoMap* self,
                                                       GFile* file,
                                                       GCancellable* cancellable);
static void directory_monitor_real_root_moved (DirectoryMonitor* self,
                                        GFile* old_root,
                                        GFile* new_root,
                                        GFileInfo* new_root_info);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void directory_monitor_real_root_deleted (DirectoryMonitor* self,
                                          GFile* root);
static void directory_monitor_real_discovery_started (DirectoryMonitor* self);
static void directory_monitor_real_file_discovered (DirectoryMonitor* self,
                                             GFile* file,
                                             GFileInfo* info);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void directory_monitor_real_directory_discovered (DirectoryMonitor* self,
                                                  GFile* file,
                                                  GFileInfo* info);
static void directory_monitor_real_discovery_failed (DirectoryMonitor* self,
                                              const gchar* reason);
static void directory_monitor_real_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_real_file_created (DirectoryMonitor* self,
                                          GFile* file,
                                          GFileInfo* info);
static void directory_monitor_real_file_moved (DirectoryMonitor* self,
                                        GFile* old_file,
                                        GFile* new_file,
                                        GFileInfo* new_file_info);
static void directory_monitor_real_file_altered (DirectoryMonitor* self,
                                          GFile* file);
static void directory_monitor_real_file_alteration_completed (DirectoryMonitor* self,
                                                       GFile* file,
                                                       GFileInfo* info);
static void directory_monitor_real_file_attributes_altered (DirectoryMonitor* self,
                                                     GFile* file);
static void directory_monitor_real_file_deleted (DirectoryMonitor* self,
                                          GFile* file);
static void directory_monitor_real_directory_created (DirectoryMonitor* self,
                                               GFile* dir,
                                               GFileInfo* info);
static void directory_monitor_real_directory_moved (DirectoryMonitor* self,
                                             GFile* old_dir,
                                             GFile* new_dir,
                                             GFileInfo* new_dir_info);
static void directory_monitor_real_directory_altered (DirectoryMonitor* self,
                                               GFile* dir);
static void directory_monitor_real_directory_alteration_completed (DirectoryMonitor* self,
                                                            GFile* dir,
                                                            GFileInfo* info);
static void directory_monitor_real_directory_attributes_altered (DirectoryMonitor* self,
                                                          GFile* dir);
static void directory_monitor_real_directory_deleted (DirectoryMonitor* self,
                                               GFile* dir);
static void directory_monitor_real_closed (DirectoryMonitor* self);
static void directory_monitor_query_info_queue_element_finalize (DirectoryMonitorQueryInfoQueueElement * obj);
static GType directory_monitor_query_info_queue_element_get_type_once (void);
static gboolean directory_monitor_file_info_map_normalize_file (DirectoryMonitorFileInfoMap* self,
                                                         GFile* file,
                                                         GFileInfo* info,
                                                         GFile** normalized,
                                                         gchar** id);
static void directory_monitor_file_info_map_remove_all (DirectoryMonitorFileInfoMap* self,
                                                 GeeCollection* files);
static void directory_monitor_file_info_map_finalize (DirectoryMonitorFileInfoMap * obj);
static GType directory_monitor_file_info_map_get_type_once (void);
static void directory_monitor_finalize (GObject * obj);
static GType directory_monitor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
directory_monitor_get_instance_private (DirectoryMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, DirectoryMonitor_private_offset);
}

static GType
directory_monitor_ftype_get_type_once (void)
{
	static const GEnumValue values[] = {{DIRECTORY_MONITOR_FTYPE_FILE, "DIRECTORY_MONITOR_FTYPE_FILE", "file"}, {DIRECTORY_MONITOR_FTYPE_DIRECTORY, "DIRECTORY_MONITOR_FTYPE_DIRECTORY", "directory"}, {DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "DIRECTORY_MONITOR_FTYPE_UNSUPPORTED", "unsupported"}, {0, NULL, NULL}};
	GType directory_monitor_ftype_type_id;
	directory_monitor_ftype_type_id = g_enum_register_static ("DirectoryMonitorFType", values);
	return directory_monitor_ftype_type_id;
}

static GType
directory_monitor_ftype_get_type (void)
{
	static volatile gsize directory_monitor_ftype_type_id__once = 0;
	if (g_once_init_enter (&directory_monitor_ftype_type_id__once)) {
		GType directory_monitor_ftype_type_id;
		directory_monitor_ftype_type_id = directory_monitor_ftype_get_type_once ();
		g_once_init_leave (&directory_monitor_ftype_type_id__once, directory_monitor_ftype_type_id);
	}
	return directory_monitor_ftype_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DirectoryMonitor*
directory_monitor_construct (GType object_type,
                             GFile* root,
                             gboolean recurse,
                             gboolean monitoring)
{
	DirectoryMonitor * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_file_get_type ()), NULL);
	self = (DirectoryMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (root);
	_g_object_unref0 (self->priv->root);
	self->priv->root = _tmp0_;
	self->priv->recurse = recurse;
	self->priv->monitoring = monitoring;
	return self;
}

DirectoryMonitor*
directory_monitor_new (GFile* root,
                       gboolean recurse,
                       gboolean monitoring)
{
	return directory_monitor_construct (TYPE_DIRECTORY_MONITOR, root, recurse, monitoring);
}

void
directory_monitor_mdbg (const gchar* msg)
{
	g_return_if_fail (msg != NULL);
}

gboolean
directory_monitor_is_recursive (DirectoryMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	result = self->priv->recurse;
	return result;
}

gboolean
directory_monitor_is_monitoring (DirectoryMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	result = self->priv->monitoring;
	return result;
}

static void
directory_monitor_real_notify_root_deleted (DirectoryMonitor* self,
                                            GFile* root)
{
	GFile* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_file_get_type ()));
	_tmp0_ = self->priv->root;
	_vala_assert (g_file_equal (_tmp0_, root), "this.root.equal(root)");
	directory_monitor_mdbg ("root deleted");
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_ROOT_DELETED_SIGNAL], 0, root);
}

void
directory_monitor_notify_root_deleted (DirectoryMonitor* self,
                                       GFile* root)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_root_deleted) {
		_klass_->notify_root_deleted (self, root);
	}
}

static void
directory_monitor_internal_notify_root_moved (DirectoryMonitor* self,
                                              GFile* old_root,
                                              GFile* new_root,
                                              GFileInfo* new_root_info)
{
	gboolean removed = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_;
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_root, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_root, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_root_info, g_file_info_get_type ()));
	_tmp0_ = self->priv->files;
	removed = directory_monitor_file_info_map_remove (_tmp0_, old_root, NULL);
	_vala_assert (removed, "removed");
	_tmp1_ = self->priv->files;
	updated = directory_monitor_file_info_map_update (_tmp1_, new_root, new_root_info);
	_vala_assert (updated, "updated");
	_tmp2_ = _g_object_ref0 (new_root);
	_g_object_unref0 (self->priv->root);
	self->priv->root = _tmp2_;
	directory_monitor_notify_root_moved (self, old_root, new_root, new_root_info);
}

static void
directory_monitor_real_notify_root_moved (DirectoryMonitor* self,
                                          GFile* old_root,
                                          GFile* new_root,
                                          GFileInfo* new_root_info)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_root, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_root, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_root_info, g_file_info_get_type ()));
	_tmp0_ = self->priv->root;
	_vala_assert (g_file_equal (_tmp0_, old_root), "this.root.equal(old_root)");
	_tmp1_ = g_file_get_path (old_root);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_path (new_root);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("root moved: %s -> %s", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	directory_monitor_mdbg (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_ROOT_MOVED_SIGNAL], 0, old_root, new_root, new_root_info);
}

void
directory_monitor_notify_root_moved (DirectoryMonitor* self,
                                     GFile* old_root,
                                     GFile* new_root,
                                     GFileInfo* new_root_info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_root_moved) {
		_klass_->notify_root_moved (self, old_root, new_root, new_root_info);
	}
}

static void
directory_monitor_real_notify_discovery_started (DirectoryMonitor* self)
{
	directory_monitor_mdbg ("discovery started");
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DISCOVERY_STARTED_SIGNAL], 0);
}

void
directory_monitor_notify_discovery_started (DirectoryMonitor* self)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_discovery_started) {
		_klass_->notify_discovery_started (self);
	}
}

static void
directory_monitor_real_internal_notify_file_discovered (DirectoryMonitor* self,
                                                        GFile* file,
                                                        GFileInfo* info)
{
	DirectoryMonitorFileInfoMap* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = self->priv->files;
	if (!directory_monitor_file_info_map_update (_tmp0_, file, info)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (file);
		_tmp2_ = _tmp1_;
		g_debug ("DirectoryMonitor.vala:517: DirectoryMonitor.internal_notify_file_disco" \
"vered: %s discovered but not added to file map", _tmp2_);
		_g_free0 (_tmp2_);
		return;
	}
	directory_monitor_notify_file_discovered (self, file, info);
}

void
directory_monitor_internal_notify_file_discovered (DirectoryMonitor* self,
                                                   GFile* file,
                                                   GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->internal_notify_file_discovered) {
		_klass_->internal_notify_file_discovered (self, file, info);
	}
}

static void
directory_monitor_real_notify_file_discovered (DirectoryMonitor* self,
                                               GFile* file,
                                               GFileInfo* info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("file discovered: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_DISCOVERED_SIGNAL], 0, file, info);
}

void
directory_monitor_notify_file_discovered (DirectoryMonitor* self,
                                          GFile* file,
                                          GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_discovered) {
		_klass_->notify_file_discovered (self, file, info);
	}
}

static void
directory_monitor_real_internal_notify_directory_discovered (DirectoryMonitor* self,
                                                             GFile* dir,
                                                             GFileInfo* info)
{
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = self->priv->files;
	updated = directory_monitor_file_info_map_update (_tmp0_, dir, info);
	_vala_assert (updated, "updated");
	directory_monitor_notify_directory_discovered (self, dir, info);
}

void
directory_monitor_internal_notify_directory_discovered (DirectoryMonitor* self,
                                                        GFile* dir,
                                                        GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->internal_notify_directory_discovered) {
		_klass_->internal_notify_directory_discovered (self, dir, info);
	}
}

static void
directory_monitor_real_notify_directory_discovered (DirectoryMonitor* self,
                                                    GFile* dir,
                                                    GFileInfo* info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("directory discovered: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_DISCOVERED_SIGNAL], 0, dir, info);
}

void
directory_monitor_notify_directory_discovered (DirectoryMonitor* self,
                                               GFile* dir,
                                               GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_discovered) {
		_klass_->notify_directory_discovered (self, dir, info);
	}
}

static void
directory_monitor_real_notify_discovery_failed (DirectoryMonitor* self,
                                                const gchar* reason)
{
	g_return_if_fail (reason != NULL);
	g_warning ("DirectoryMonitor.vala:544: discovery failed: %s", reason);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DISCOVERY_FAILED_SIGNAL], 0, reason);
}

void
directory_monitor_notify_discovery_failed (DirectoryMonitor* self,
                                           const gchar* reason)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_discovery_failed) {
		_klass_->notify_discovery_failed (self, reason);
	}
}

static void
directory_monitor_real_notify_discovery_completed (DirectoryMonitor* self)
{
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DISCOVERY_COMPLETED_SIGNAL], 0);
}

void
directory_monitor_notify_discovery_completed (DirectoryMonitor* self)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_discovery_completed) {
		_klass_->notify_discovery_completed (self);
	}
}

static void
directory_monitor_internal_notify_file_created (DirectoryMonitor* self,
                                                GFile* file,
                                                GFileInfo* info)
{
	GFile* old_file = NULL;
	GFileInfo* old_file_info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp2_ = directory_monitor_is_file_create_move (self, file, info, &_tmp0_, &_tmp1_);
	_g_object_unref0 (old_file);
	old_file = _tmp0_;
	_g_object_unref0 (old_file_info);
	old_file_info = _tmp1_;
	if (_tmp2_) {
		GFile* _tmp3_;
		_tmp3_ = old_file;
		directory_monitor_internal_notify_file_moved (self, _tmp3_, file, info);
	} else {
		gboolean updated = FALSE;
		DirectoryMonitorFileInfoMap* _tmp4_;
		_tmp4_ = self->priv->files;
		updated = directory_monitor_file_info_map_update (_tmp4_, file, info);
		_vala_assert (updated, "updated");
		directory_monitor_notify_file_created (self, file, info);
	}
	_g_object_unref0 (old_file_info);
	_g_object_unref0 (old_file);
}

static void
directory_monitor_real_notify_file_created (DirectoryMonitor* self,
                                            GFile* file,
                                            GFileInfo* info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("file created: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_CREATED_SIGNAL], 0, file, info);
}

void
directory_monitor_notify_file_created (DirectoryMonitor* self,
                                       GFile* file,
                                       GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_created) {
		_klass_->notify_file_created (self, file, info);
	}
}

static void
directory_monitor_internal_notify_file_moved (DirectoryMonitor* self,
                                              GFile* old_file,
                                              GFile* new_file,
                                              GFileInfo* new_file_info)
{
	DirectoryMonitorFileInfoMap* _tmp0_;
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp1_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file_info, g_file_info_get_type ()));
	_tmp0_ = self->priv->files;
	directory_monitor_file_info_map_remove (_tmp0_, old_file, NULL);
	_tmp1_ = self->priv->files;
	updated = directory_monitor_file_info_map_update (_tmp1_, new_file, new_file_info);
	_vala_assert (updated, "updated");
	directory_monitor_notify_file_moved (self, old_file, new_file, new_file_info);
}

static void
directory_monitor_real_notify_file_moved (DirectoryMonitor* self,
                                          GFile* old_file,
                                          GFile* new_file,
                                          GFileInfo* new_file_info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file_info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (old_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (new_file);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("file moved: %s -> %s", _tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	directory_monitor_mdbg (_tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_MOVED_SIGNAL], 0, old_file, new_file, new_file_info);
}

void
directory_monitor_notify_file_moved (DirectoryMonitor* self,
                                     GFile* old_file,
                                     GFile* new_file,
                                     GFileInfo* new_file_info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_moved) {
		_klass_->notify_file_moved (self, old_file, new_file, new_file_info);
	}
}

static void
directory_monitor_real_notify_file_altered (DirectoryMonitor* self,
                                            GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("file altered: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_ALTERED_SIGNAL], 0, file);
}

void
directory_monitor_notify_file_altered (DirectoryMonitor* self,
                                       GFile* file)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_altered) {
		_klass_->notify_file_altered (self, file);
	}
}

static void
directory_monitor_internal_notify_file_alteration_completed (DirectoryMonitor* self,
                                                             GFile* file,
                                                             GFileInfo* info)
{
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = self->priv->files;
	updated = directory_monitor_file_info_map_update (_tmp0_, file, info);
	_vala_assert (updated, "updated");
	directory_monitor_notify_file_alteration_completed (self, file, info);
}

static void
directory_monitor_real_notify_file_alteration_completed (DirectoryMonitor* self,
                                                         GFile* file,
                                                         GFileInfo* info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("file alteration completed: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_ALTERATION_COMPLETED_SIGNAL], 0, file, info);
}

void
directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self,
                                                    GFile* file,
                                                    GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_alteration_completed) {
		_klass_->notify_file_alteration_completed (self, file, info);
	}
}

static void
directory_monitor_real_notify_file_attributes_altered (DirectoryMonitor* self,
                                                       GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("file attributes altered: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_ATTRIBUTES_ALTERED_SIGNAL], 0, file);
}

void
directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self,
                                                  GFile* file)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_attributes_altered) {
		_klass_->notify_file_attributes_altered (self, file);
	}
}

static void
directory_monitor_internal_notify_file_deleted (DirectoryMonitor* self,
                                                GFile* file)
{
	gboolean removed = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = self->priv->files;
	removed = directory_monitor_file_info_map_remove (_tmp0_, file, NULL);
	_vala_assert (removed, "removed");
	directory_monitor_notify_file_deleted (self, file);
}

static void
directory_monitor_real_notify_file_deleted (DirectoryMonitor* self,
                                            GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("file deleted: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_FILE_DELETED_SIGNAL], 0, file);
}

void
directory_monitor_notify_file_deleted (DirectoryMonitor* self,
                                       GFile* file)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_file_deleted) {
		_klass_->notify_file_deleted (self, file);
	}
}

static void
directory_monitor_internal_notify_directory_created (DirectoryMonitor* self,
                                                     GFile* dir,
                                                     GFileInfo* info)
{
	GFile* old_dir = NULL;
	GFileInfo* old_dir_info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp2_ = directory_monitor_is_file_create_move (self, dir, info, &_tmp0_, &_tmp1_);
	_g_object_unref0 (old_dir);
	old_dir = _tmp0_;
	_g_object_unref0 (old_dir_info);
	old_dir_info = _tmp1_;
	if (_tmp2_) {
		DirectoryMonitorFileInfoMap* _tmp3_;
		GFile* _tmp4_;
		DirectoryMonitorFileInfoMap* _tmp5_;
		GFile* _tmp6_;
		GFileInfo* _tmp7_;
		_tmp3_ = self->priv->files;
		_tmp4_ = old_dir;
		_tmp5_ = self->priv->parent_moved;
		directory_monitor_file_info_map_remove_descendents (_tmp3_, _tmp4_, _tmp5_);
		_tmp6_ = old_dir;
		_tmp7_ = old_dir_info;
		directory_monitor_internal_notify_directory_moved (self, _tmp6_, _tmp7_, dir, info);
	} else {
		gboolean updated = FALSE;
		DirectoryMonitorFileInfoMap* _tmp8_;
		_tmp8_ = self->priv->files;
		updated = directory_monitor_file_info_map_update (_tmp8_, dir, info);
		_vala_assert (updated, "updated");
		directory_monitor_notify_directory_created (self, dir, info);
	}
	_g_object_unref0 (old_dir_info);
	_g_object_unref0 (old_dir);
}

static void
directory_monitor_real_notify_directory_created (DirectoryMonitor* self,
                                                 GFile* dir,
                                                 GFileInfo* info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("directory created: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_CREATED_SIGNAL], 0, dir, info);
}

void
directory_monitor_notify_directory_created (DirectoryMonitor* self,
                                            GFile* dir,
                                            GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_created) {
		_klass_->notify_directory_created (self, dir, info);
	}
}

static void
directory_monitor_internal_notify_directory_moved (DirectoryMonitor* self,
                                                   GFile* old_dir,
                                                   GFileInfo* old_dir_info,
                                                   GFile* new_dir,
                                                   GFileInfo* new_dir_info)
{
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_dir_info, g_file_info_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir_info, g_file_info_get_type ()));
	directory_monitor_async_internal_notify_directory_moved (self, old_dir, old_dir_info, new_dir, new_dir_info, NULL, NULL);
}

static void
directory_monitor_async_internal_notify_directory_moved_data_free (gpointer _data)
{
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->old_dir);
	_g_object_unref0 (_data_->old_dir_info);
	_g_object_unref0 (_data_->new_dir);
	_g_object_unref0 (_data_->new_dir_info);
	_g_object_unref0 (_data_->self);
	g_slice_free (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData, _data_);
}

static void
directory_monitor_async_internal_notify_directory_moved (DirectoryMonitor* self,
                                                         GFile* old_dir,
                                                         GFileInfo* old_dir_info,
                                                         GFile* new_dir,
                                                         GFileInfo* new_dir_info,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	DirectoryMonitor* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	GFile* _tmp3_;
	GFileInfo* _tmp4_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_dir_info, g_file_info_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir_info, g_file_info_get_type ()));
	_data_ = g_slice_new0 (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, directory_monitor_async_internal_notify_directory_moved_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (old_dir);
	_g_object_unref0 (_data_->old_dir);
	_data_->old_dir = _tmp1_;
	_tmp2_ = _g_object_ref0 (old_dir_info);
	_g_object_unref0 (_data_->old_dir_info);
	_data_->old_dir_info = _tmp2_;
	_tmp3_ = _g_object_ref0 (new_dir);
	_g_object_unref0 (_data_->new_dir);
	_data_->new_dir = _tmp3_;
	_tmp4_ = _g_object_ref0 (new_dir_info);
	_g_object_unref0 (_data_->new_dir_info);
	_data_->new_dir_info = _tmp4_;
	directory_monitor_async_internal_notify_directory_moved_co (_data_);
}

static void
directory_monitor_async_internal_notify_directory_moved_finish (DirectoryMonitor* self,
                                                                GAsyncResult* _res_)
{
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static void
directory_monitor_async_internal_notify_directory_moved_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	directory_monitor_async_internal_notify_directory_moved_co (_data_);
}

static gboolean
_directory_monitor_async_internal_notify_directory_moved_co_gsource_func (gpointer self)
{
	gboolean result;
	result = directory_monitor_async_internal_notify_directory_moved_co (self);
	return result;
}

static gboolean
directory_monitor_async_internal_notify_directory_moved_co (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
	_data_->file_children = _data_->_tmp0_;
	_data_->_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
	_data_->dir_children = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->files;
	_data_->_tmp3_ = _data_->file_children;
	_data_->_tmp4_ = _data_->dir_children;
	_data_->count = directory_monitor_file_info_map_get_children (_data_->_tmp2_, _data_->old_dir, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	if (_data_->count > 0) {
		{
			_data_->_tmp5_ = _data_->dir_children;
			_data_->_dir_child_list = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->_dir_child_list;
			_data_->_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_dir_child_size = _data_->_tmp8_;
			_data_->_dir_child_index = -1;
			while (TRUE) {
				_data_->_dir_child_index = _data_->_dir_child_index + 1;
				_data_->_tmp9_ = _data_->_dir_child_index;
				_data_->_tmp10_ = _data_->_dir_child_size;
				if (!(_data_->_tmp9_ < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = _data_->_dir_child_list;
				_data_->_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_dir_child_index);
				_data_->dir_child = (GFile*) _data_->_tmp12_;
				_data_->_tmp13_ = _data_->self->priv->files;
				_data_->_tmp14_ = _data_->dir_child;
				_data_->_tmp15_ = directory_monitor_file_info_map_get_info (_data_->_tmp13_, _data_->_tmp14_);
				_data_->dir_info = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->dir_info;
				if (_data_->_tmp16_ == NULL) {
					_data_->_tmp17_ = _data_->dir_child;
					_data_->_tmp18_ = g_file_get_path (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					g_warning ("DirectoryMonitor.vala:662: Unable to retrieve directory-moved info for" \
" %s", _data_->_tmp19_);
					_g_free0 (_data_->_tmp19_);
					_g_object_unref0 (_data_->dir_info);
					_g_object_unref0 (_data_->dir_child);
					continue;
				}
				_data_->_tmp20_ = _data_->dir_child;
				_data_->_tmp21_ = _data_->dir_info;
				_data_->_tmp22_ = _data_->dir_child;
				_data_->_tmp23_ = g_file_get_basename (_data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = g_file_get_child (_data_->new_dir, _data_->_tmp24_);
				_data_->_tmp26_ = _data_->_tmp25_;
				_data_->_tmp27_ = _data_->dir_info;
				_data_->_state_ = 1;
				directory_monitor_async_internal_notify_directory_moved (_data_->self, _data_->_tmp20_, _data_->_tmp21_, _data_->_tmp26_, _data_->_tmp27_, directory_monitor_async_internal_notify_directory_moved_ready, _data_);
				return FALSE;
				_state_1:
				directory_monitor_async_internal_notify_directory_moved_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->_tmp26_);
				_g_free0 (_data_->_tmp24_);
				_g_object_unref0 (_data_->dir_info);
				_g_object_unref0 (_data_->dir_child);
			}
		}
		{
			_data_->_tmp28_ = _data_->file_children;
			_data_->_file_child_list = _data_->_tmp28_;
			_data_->_tmp29_ = _data_->_file_child_list;
			_data_->_tmp30_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_file_child_size = _data_->_tmp31_;
			_data_->_file_child_index = -1;
			while (TRUE) {
				_data_->_file_child_index = _data_->_file_child_index + 1;
				_data_->_tmp32_ = _data_->_file_child_index;
				_data_->_tmp33_ = _data_->_file_child_size;
				if (!(_data_->_tmp32_ < _data_->_tmp33_)) {
					break;
				}
				_data_->_tmp34_ = _data_->_file_child_list;
				_data_->_tmp35_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_file_child_index);
				_data_->file_child = (GFile*) _data_->_tmp35_;
				_data_->_tmp36_ = _data_->self->priv->files;
				_data_->_tmp37_ = _data_->file_child;
				_data_->_tmp38_ = directory_monitor_file_info_map_get_info (_data_->_tmp36_, _data_->_tmp37_);
				_data_->file_info = _data_->_tmp38_;
				_data_->_tmp39_ = _data_->file_info;
				if (_data_->_tmp39_ == NULL) {
					_data_->_tmp40_ = _data_->file_child;
					_data_->_tmp41_ = g_file_get_path (_data_->_tmp40_);
					_data_->_tmp42_ = _data_->_tmp41_;
					g_warning ("DirectoryMonitor.vala:675: Unable to retrieve directory-moved info for" \
" %s", _data_->_tmp42_);
					_g_free0 (_data_->_tmp42_);
					_g_object_unref0 (_data_->file_info);
					_g_object_unref0 (_data_->file_child);
					continue;
				}
				_data_->_tmp43_ = _data_->file_child;
				_data_->_tmp44_ = _data_->file_child;
				_data_->_tmp45_ = g_file_get_basename (_data_->_tmp44_);
				_data_->_tmp46_ = _data_->_tmp45_;
				_data_->_tmp47_ = g_file_get_child (_data_->new_dir, _data_->_tmp46_);
				_data_->_tmp48_ = _data_->_tmp47_;
				_data_->_tmp49_ = _data_->file_info;
				directory_monitor_internal_notify_file_moved (_data_->self, _data_->_tmp43_, _data_->_tmp48_, _data_->_tmp49_);
				_g_object_unref0 (_data_->_tmp48_);
				_g_free0 (_data_->_tmp46_);
				g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_async_internal_notify_directory_moved_co_gsource_func, _data_, NULL);
				_data_->_state_ = 2;
				return FALSE;
				_state_2:
				;
				_g_object_unref0 (_data_->file_info);
				_g_object_unref0 (_data_->file_child);
			}
		}
	}
	_data_->_tmp50_ = _data_->self->priv->files;
	directory_monitor_file_info_map_remove (_data_->_tmp50_, _data_->old_dir, NULL);
	_data_->_tmp51_ = _data_->self->priv->files;
	_data_->updated = directory_monitor_file_info_map_update (_data_->_tmp51_, _data_->new_dir, _data_->new_dir_info);
	_vala_assert (_data_->updated, "updated");
	directory_monitor_remove_monitor (_data_->self, _data_->old_dir, _data_->old_dir_info);
	directory_monitor_add_monitor (_data_->self, _data_->new_dir, _data_->new_dir_info);
	directory_monitor_notify_directory_moved (_data_->self, _data_->old_dir, _data_->new_dir, _data_->new_dir_info);
	_g_object_unref0 (_data_->dir_children);
	_g_object_unref0 (_data_->file_children);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
directory_monitor_real_notify_directory_moved (DirectoryMonitor* self,
                                               GFile* old_dir,
                                               GFile* new_dir,
                                               GFileInfo* new_dir_info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir_info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (old_dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (new_dir);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("directory moved: %s -> %s", _tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	directory_monitor_mdbg (_tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_MOVED_SIGNAL], 0, old_dir, new_dir, new_dir_info);
	_tmp6_ = self->priv->root;
	if (g_file_equal (old_dir, _tmp6_)) {
		directory_monitor_internal_notify_root_moved (self, old_dir, new_dir, new_dir_info);
	}
}

void
directory_monitor_notify_directory_moved (DirectoryMonitor* self,
                                          GFile* old_dir,
                                          GFile* new_dir,
                                          GFileInfo* new_dir_info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_moved) {
		_klass_->notify_directory_moved (self, old_dir, new_dir, new_dir_info);
	}
}

static void
directory_monitor_real_notify_directory_altered (DirectoryMonitor* self,
                                                 GFile* dir)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("directory altered: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_ALTERED_SIGNAL], 0, dir);
}

void
directory_monitor_notify_directory_altered (DirectoryMonitor* self,
                                            GFile* dir)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_altered) {
		_klass_->notify_directory_altered (self, dir);
	}
}

static void
directory_monitor_internal_notify_directory_alteration_completed (DirectoryMonitor* self,
                                                                  GFile* dir,
                                                                  GFileInfo* info)
{
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = self->priv->files;
	updated = directory_monitor_file_info_map_update (_tmp0_, dir, info);
	_vala_assert (updated, "updated");
	directory_monitor_notify_directory_alteration_completed (self, dir, info);
}

static void
directory_monitor_real_notify_directory_alteration_completed (DirectoryMonitor* self,
                                                              GFile* dir,
                                                              GFileInfo* info)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("directory alteration completed: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_ALTERATION_COMPLETED_SIGNAL], 0, dir, info);
}

void
directory_monitor_notify_directory_alteration_completed (DirectoryMonitor* self,
                                                         GFile* dir,
                                                         GFileInfo* info)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_alteration_completed) {
		_klass_->notify_directory_alteration_completed (self, dir, info);
	}
}

static void
directory_monitor_real_notify_directory_attributes_altered (DirectoryMonitor* self,
                                                            GFile* dir)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("directory attributes altered: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_ATTRIBUTES_ALTERED_SIGNAL], 0, dir);
}

void
directory_monitor_notify_directory_attributes_altered (DirectoryMonitor* self,
                                                       GFile* dir)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_attributes_altered) {
		_klass_->notify_directory_attributes_altered (self, dir);
	}
}

static void
directory_monitor_internal_notify_directory_deleted (DirectoryMonitor* self,
                                                     GFile* dir)
{
	GFileInfo* info = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_;
	GFileInfo* _tmp1_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	_tmp0_ = self->priv->files;
	_tmp1_ = directory_monitor_file_info_map_get_info (_tmp0_, dir);
	info = _tmp1_;
	_vala_assert (info != NULL, "info != null");
	directory_monitor_remove_monitor (self, dir, info);
	directory_monitor_async_notify_directory_deleted (self, dir, FALSE, NULL, NULL);
	_g_object_unref0 (info);
}

static void
directory_monitor_async_notify_directory_deleted_data_free (gpointer _data)
{
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->dir);
	_g_object_unref0 (_data_->self);
	g_slice_free (DirectoryMonitorAsyncNotifyDirectoryDeletedData, _data_);
}

static void
directory_monitor_async_notify_directory_deleted (DirectoryMonitor* self,
                                                  GFile* dir,
                                                  gboolean already_removed,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	DirectoryMonitor* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	_data_ = g_slice_new0 (DirectoryMonitorAsyncNotifyDirectoryDeletedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, directory_monitor_async_notify_directory_deleted_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (_data_->dir);
	_data_->dir = _tmp1_;
	_data_->already_removed = already_removed;
	directory_monitor_async_notify_directory_deleted_co (_data_);
}

static void
directory_monitor_async_notify_directory_deleted_finish (DirectoryMonitor* self,
                                                         GAsyncResult* _res_)
{
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
directory_monitor_async_notify_directory_deleted_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	directory_monitor_async_notify_directory_deleted_co (_data_);
}

static gboolean
_directory_monitor_async_notify_directory_deleted_co_gsource_func (gpointer self)
{
	gboolean result;
	result = directory_monitor_async_notify_directory_deleted_co (self);
	return result;
}

static gboolean
directory_monitor_async_notify_directory_deleted_co (DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
	_data_->file_children = _data_->_tmp0_;
	_data_->_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
	_data_->dir_children = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->files;
	_data_->_tmp3_ = _data_->file_children;
	_data_->_tmp4_ = _data_->dir_children;
	_data_->count = directory_monitor_file_info_map_get_children (_data_->_tmp2_, _data_->dir, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	if (_data_->count > 0) {
		{
			_data_->_tmp5_ = _data_->dir_children;
			_data_->_dir_child_list = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->_dir_child_list;
			_data_->_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_dir_child_size = _data_->_tmp8_;
			_data_->_dir_child_index = -1;
			while (TRUE) {
				_data_->_dir_child_index = _data_->_dir_child_index + 1;
				_data_->_tmp9_ = _data_->_dir_child_index;
				_data_->_tmp10_ = _data_->_dir_child_size;
				if (!(_data_->_tmp9_ < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = _data_->_dir_child_list;
				_data_->_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_dir_child_index);
				_data_->dir_child = (GFile*) _data_->_tmp12_;
				_data_->_tmp13_ = _data_->dir_child;
				_data_->_state_ = 1;
				directory_monitor_async_notify_directory_deleted (_data_->self, _data_->_tmp13_, FALSE, directory_monitor_async_notify_directory_deleted_ready, _data_);
				return FALSE;
				_state_1:
				directory_monitor_async_notify_directory_deleted_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->dir_child);
			}
		}
		{
			_data_->_tmp14_ = _data_->file_children;
			_data_->_file_child_list = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->_file_child_list;
			_data_->_tmp16_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_file_child_size = _data_->_tmp17_;
			_data_->_file_child_index = -1;
			while (TRUE) {
				_data_->_file_child_index = _data_->_file_child_index + 1;
				_data_->_tmp18_ = _data_->_file_child_index;
				_data_->_tmp19_ = _data_->_file_child_size;
				if (!(_data_->_tmp18_ < _data_->_tmp19_)) {
					break;
				}
				_data_->_tmp20_ = _data_->_file_child_list;
				_data_->_tmp21_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_file_child_index);
				_data_->file_child = (GFile*) _data_->_tmp21_;
				_data_->_tmp22_ = _data_->self->priv->files;
				_data_->_tmp23_ = _data_->file_child;
				directory_monitor_file_info_map_remove (_data_->_tmp22_, _data_->_tmp23_, NULL);
				_data_->_tmp24_ = _data_->file_child;
				directory_monitor_notify_file_deleted (_data_->self, _data_->_tmp24_);
				g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_async_notify_directory_deleted_co_gsource_func, _data_, NULL);
				_data_->_state_ = 2;
				return FALSE;
				_state_2:
				;
				_g_object_unref0 (_data_->file_child);
			}
		}
	}
	if (!_data_->already_removed) {
		_data_->_tmp25_ = _data_->self->priv->files;
		directory_monitor_file_info_map_remove (_data_->_tmp25_, _data_->dir, NULL);
	}
	directory_monitor_notify_directory_deleted (_data_->self, _data_->dir);
	_g_object_unref0 (_data_->dir_children);
	_g_object_unref0 (_data_->file_children);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
directory_monitor_real_notify_directory_deleted (DirectoryMonitor* self,
                                                 GFile* dir)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("directory deleted: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_DELETED_SIGNAL], 0, dir);
	_tmp4_ = self->priv->root;
	if (g_file_equal (dir, _tmp4_)) {
		directory_monitor_notify_root_deleted (self, dir);
	}
}

void
directory_monitor_notify_directory_deleted (DirectoryMonitor* self,
                                            GFile* dir)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_directory_deleted) {
		_klass_->notify_directory_deleted (self, dir);
	}
}

static void
directory_monitor_real_notify_closed (DirectoryMonitor* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->root;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("monitoring of %s closed", _tmp2_);
	_tmp4_ = _tmp3_;
	directory_monitor_mdbg (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_CLOSED_SIGNAL], 0);
}

void
directory_monitor_notify_closed (DirectoryMonitor* self)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->notify_closed) {
		_klass_->notify_closed (self);
	}
}

GFile*
directory_monitor_get_root (DirectoryMonitor* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
	_tmp0_ = self->priv->root;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
directory_monitor_is_in_root (DirectoryMonitor* self,
                              GFile* file)
{
	GFile* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = self->priv->root;
	result = g_file_has_prefix (file, _tmp0_);
	return result;
}

gboolean
directory_monitor_has_started (DirectoryMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	result = self->priv->started;
	return result;
}

void
directory_monitor_start_discovery (DirectoryMonitor* self)
{
	GFile* _tmp0_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_vala_assert (!self->priv->started, "!started");
	self->priv->has_discovery_started = TRUE;
	self->priv->started = TRUE;
	directory_monitor_notify_discovery_started (self);
	self->priv->outstanding_exploration_dirs = 1;
	_tmp0_ = self->priv->root;
	directory_monitor_explore_async (self, _tmp0_, NULL, TRUE, NULL, NULL);
}

static void
directory_monitor_real_close (DirectoryMonitor* self)
{
	GCancellable* _tmp0_;
	GeeHashMap* _tmp11_;
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	{
		GeeIterator* _monitor_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->monitors;
		_tmp2_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_monitor_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GFileMonitor* monitor = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GFileMonitor* _tmp10_;
			_tmp7_ = _monitor_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _monitor_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			monitor = (GFileMonitor*) _tmp9_;
			_tmp10_ = monitor;
			directory_monitor_cancel_monitor (self, _tmp10_);
			_g_object_unref0 (monitor);
		}
		_g_object_unref0 (_monitor_it);
	}
	_tmp11_ = self->priv->monitors;
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	directory_monitor_notify_closed (self);
}

void
directory_monitor_close (DirectoryMonitor* self)
{
	DirectoryMonitorClass* _klass_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_klass_ = DIRECTORY_MONITOR_GET_CLASS (self);
	if (_klass_->close) {
		_klass_->close (self);
	}
}

static DirectoryMonitorFType
directory_monitor_get_ftype (GFileInfo* info)
{
	GFileType file_type = 0;
	DirectoryMonitorFType result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), 0);
	file_type = g_file_info_get_file_type (info);
	switch (file_type) {
		case G_FILE_TYPE_REGULAR:
		{
			result = DIRECTORY_MONITOR_FTYPE_FILE;
			return result;
		}
		case G_FILE_TYPE_DIRECTORY:
		{
			result = DIRECTORY_MONITOR_FTYPE_DIRECTORY;
			return result;
		}
		default:
		{
			GEnumValue* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp0_ = g_enum_get_value (g_type_class_ref (g_file_type_get_type ()), file_type);
			_tmp1_ = g_strdup_printf ("query_ftype: Unknown file type %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
			_tmp2_ = _tmp1_;
			directory_monitor_mdbg (_tmp2_);
			_g_free0 (_tmp2_);
			result = DIRECTORY_MONITOR_FTYPE_UNSUPPORTED;
			return result;
		}
	}
}

static void
directory_monitor_explore_async_data_free (gpointer _data)
{
	DirectoryMonitorExploreAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->dir);
	_g_object_unref0 (_data_->dir_info);
	_g_object_unref0 (_data_->self);
	g_slice_free (DirectoryMonitorExploreAsyncData, _data_);
}

static void
directory_monitor_explore_async (DirectoryMonitor* self,
                                 GFile* dir,
                                 GFileInfo* dir_info,
                                 gboolean in_discovery,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	DirectoryMonitorExploreAsyncData* _data_;
	DirectoryMonitor* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail ((dir_info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (dir_info, g_file_info_get_type ()));
	_data_ = g_slice_new0 (DirectoryMonitorExploreAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, directory_monitor_explore_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (_data_->dir);
	_data_->dir = _tmp1_;
	_tmp2_ = _g_object_ref0 (dir_info);
	_g_object_unref0 (_data_->dir_info);
	_data_->dir_info = _tmp2_;
	_data_->in_discovery = in_discovery;
	directory_monitor_explore_async_co (_data_);
}

static void
directory_monitor_explore_finish (DirectoryMonitor* self,
                                  GAsyncResult* _res_)
{
	DirectoryMonitorExploreAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
directory_monitor_explore_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	DirectoryMonitorExploreAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	directory_monitor_explore_async_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
directory_monitor_explore_async_co (DirectoryMonitorExploreAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->files;
	if (directory_monitor_file_info_map_contains (_data_->_tmp0_, _data_->dir, _data_->dir_info)) {
		_data_->_tmp1_ = g_file_get_path (_data_->dir);
		_data_->_tmp2_ = _data_->_tmp1_;
		g_warning ("DirectoryMonitor.vala:852: Directory loop detected at %s, not explorin" \
"g", _data_->_tmp2_);
		_g_free0 (_data_->_tmp2_);
		directory_monitor_explore_directory_completed (_data_->self, _data_->in_discovery);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _g_object_ref0 (_data_->dir_info);
	_data_->local_dir_info = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->local_dir_info;
	if (_data_->_tmp4_ == NULL) {
		{
			_data_->_tmp6_ = _data_->self->priv->cancellable;
			_data_->_state_ = 1;
			g_file_query_info_async (_data_->dir, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_DIR_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp6_, directory_monitor_explore_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp7_ = g_file_query_info_finish (_data_->dir, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->local_dir_info);
			_data_->local_dir_info = _data_->_tmp8_;
			_g_object_unref0 (_data_->_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp9_ = g_file_get_path (_data_->dir);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->err;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			g_warning ("DirectoryMonitor.vala:866: Unable to retrieve info on %s: %s", _data_->_tmp10_, _data_->_tmp12_);
			_g_free0 (_data_->_tmp10_);
			directory_monitor_explore_directory_completed (_data_->self, _data_->in_discovery);
			_g_error_free0 (_data_->err);
			_g_object_unref0 (_data_->local_dir_info);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->local_dir_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp13_ = _data_->local_dir_info;
	if (g_file_info_get_is_hidden (_data_->_tmp13_)) {
		_data_->_tmp14_ = g_file_get_path (_data_->dir);
		_data_->_tmp15_ = _data_->_tmp14_;
		g_warning ("DirectoryMonitor.vala:875: Ignoring hidden directory %s", _data_->_tmp15_);
		_g_free0 (_data_->_tmp15_);
		directory_monitor_explore_directory_completed (_data_->self, _data_->in_discovery);
		_g_object_unref0 (_data_->local_dir_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->local_dir_info;
	_data_->_tmp17_ = get_file_info_id (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = _data_->_tmp18_ == NULL;
	_g_free0 (_data_->_tmp18_);
	if (_data_->_tmp19_) {
		_data_->_tmp20_ = _data_->local_dir_info;
		_data_->_tmp21_ = g_file_get_uri (_data_->dir);
		_data_->_tmp22_ = _data_->_tmp21_;
		g_file_info_set_attribute_string (_data_->_tmp20_, G_FILE_ATTRIBUTE_ID_FILE, _data_->_tmp22_);
		_g_free0 (_data_->_tmp22_);
	}
	_data_->_tmp23_ = _data_->local_dir_info;
	if (g_file_info_get_file_type (_data_->_tmp23_) != G_FILE_TYPE_DIRECTORY) {
		_data_->_tmp24_ = g_file_get_path (_data_->dir);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->local_dir_info;
		_data_->_tmp27_ = g_enum_get_value (g_type_class_ref (g_file_type_get_type ()), g_file_info_get_file_type (_data_->_tmp26_));
		_data_->_tmp28_ = g_strdup_printf (_ ("Unable to monitor %s: Not a directory (%s)"), _data_->_tmp25_, (_data_->_tmp27_ != NULL) ? _data_->_tmp27_->value_name : NULL);
		_data_->_tmp29_ = _data_->_tmp28_;
		directory_monitor_notify_discovery_failed (_data_->self, _data_->_tmp29_);
		_g_free0 (_data_->_tmp29_);
		_g_free0 (_data_->_tmp25_);
		directory_monitor_explore_directory_completed (_data_->self, _data_->in_discovery);
		_g_object_unref0 (_data_->local_dir_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->dir_map = NULL;
	_data_->file_map = NULL;
	{
		_data_->_tmp30_ = _data_->self->priv->cancellable;
		_data_->_state_ = 2;
		g_file_enumerate_children_async (_data_->dir, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp30_, directory_monitor_explore_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp31_ = g_file_enumerate_children_finish (_data_->dir, _data_->_res_, &_data_->_inner_error0_);
		_data_->enumerator = _data_->_tmp31_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		{
			_data_->_tmp32_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp32_) {
				}
				_data_->_tmp32_ = FALSE;
				_data_->_tmp33_ = _data_->enumerator;
				_data_->_tmp34_ = _data_->self->priv->cancellable;
				_data_->_state_ = 3;
				g_file_enumerator_next_files_async (_data_->_tmp33_, 10, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp34_, directory_monitor_explore_async_ready, _data_);
				return FALSE;
				_state_3:
				_data_->_tmp35_ = g_file_enumerator_next_files_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
				_data_->infos = _data_->_tmp35_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->enumerator);
					goto __catch1_g_error;
				}
				_data_->_tmp36_ = _data_->infos;
				if (_data_->_tmp36_ == NULL) {
					(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
					break;
				}
				_data_->_tmp37_ = _data_->infos;
				{
					_data_->info_collection = _data_->_tmp37_;
					for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
						_data_->_tmp38_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
						_data_->info = _data_->_tmp38_;
						{
							_data_->_tmp39_ = _data_->info;
							_data_->_tmp40_ = get_file_info_id (_data_->_tmp39_);
							_data_->_tmp41_ = _data_->_tmp40_;
							_data_->_tmp42_ = _data_->_tmp41_ == NULL;
							_g_free0 (_data_->_tmp41_);
							if (_data_->_tmp42_) {
								_data_->_tmp43_ = _data_->info;
								_data_->_tmp44_ = g_file_get_uri (_data_->dir);
								_data_->_tmp45_ = _data_->_tmp44_;
								g_file_info_set_attribute_string (_data_->_tmp43_, G_FILE_ATTRIBUTE_ID_FILE, _data_->_tmp45_);
								_g_free0 (_data_->_tmp45_);
							}
							_data_->_tmp46_ = _data_->info;
							if (g_file_info_get_is_hidden (_data_->_tmp46_)) {
								_data_->_tmp47_ = _data_->info;
								_data_->_tmp48_ = g_file_info_get_name (_data_->_tmp47_);
								_data_->_tmp49_ = g_file_get_child (_data_->dir, _data_->_tmp48_);
								_data_->_tmp50_ = _data_->_tmp49_;
								_data_->_tmp51_ = g_file_get_path (_data_->_tmp50_);
								_data_->_tmp52_ = _data_->_tmp51_;
								g_warning ("DirectoryMonitor.vala:922: Skipping hidden file/directory %s", _data_->_tmp52_);
								_g_free0 (_data_->_tmp52_);
								_g_object_unref0 (_data_->_tmp50_);
								_g_object_unref0 (_data_->info);
								continue;
							}
							_data_->_tmp53_ = _data_->info;
							if (!directory_monitor_is_file_symlink_supported (_data_->_tmp53_)) {
								_g_object_unref0 (_data_->info);
								continue;
							}
							_data_->_tmp54_ = _data_->info;
							switch (g_file_info_get_file_type (_data_->_tmp54_)) {
								case G_FILE_TYPE_REGULAR:
								{
									_data_->_tmp55_ = _data_->file_map;
									if (_data_->_tmp55_ == NULL) {
										_data_->_tmp56_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
										_g_object_unref0 (_data_->file_map);
										_data_->file_map = _data_->_tmp56_;
									}
									_data_->_tmp57_ = _data_->file_map;
									_data_->_tmp58_ = _data_->info;
									_data_->_tmp59_ = g_file_info_get_name (_data_->_tmp58_);
									_data_->_tmp60_ = g_file_get_child (_data_->dir, _data_->_tmp59_);
									_data_->_tmp61_ = _data_->_tmp60_;
									_data_->_tmp62_ = _data_->info;
									gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp57_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp61_, _data_->_tmp62_);
									_g_object_unref0 (_data_->_tmp61_);
									break;
								}
								case G_FILE_TYPE_DIRECTORY:
								{
									_data_->_tmp63_ = _data_->dir_map;
									if (_data_->_tmp63_ == NULL) {
										_data_->_tmp64_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
										_g_object_unref0 (_data_->dir_map);
										_data_->dir_map = _data_->_tmp64_;
									}
									_data_->_tmp65_ = _data_->dir_map;
									_data_->_tmp66_ = _data_->info;
									_data_->_tmp67_ = g_file_info_get_name (_data_->_tmp66_);
									_data_->_tmp68_ = g_file_get_child (_data_->dir, _data_->_tmp67_);
									_data_->_tmp69_ = _data_->_tmp68_;
									_data_->_tmp70_ = _data_->info;
									gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp65_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp69_, _data_->_tmp70_);
									_g_object_unref0 (_data_->_tmp69_);
									break;
								}
								default:
								{
									break;
								}
							}
							_g_object_unref0 (_data_->info);
						}
					}
				}
				(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
			}
		}
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err2 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp71_ = g_file_get_path (_data_->dir);
		_data_->_tmp72_ = _data_->_tmp71_;
		_data_->_tmp73_ = _data_->err2;
		_data_->_tmp74_ = _data_->_tmp73_->message;
		g_warning ("DirectoryMonitor.vala:954: Aborted directory traversal of %s: %s", _data_->_tmp72_, _data_->_tmp74_);
		_g_free0 (_data_->_tmp72_);
		directory_monitor_explore_directory_completed (_data_->self, _data_->in_discovery);
		_g_error_free0 (_data_->err2);
		_g_object_unref0 (_data_->file_map);
		_g_object_unref0 (_data_->dir_map);
		_g_object_unref0 (_data_->local_dir_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file_map);
		_g_object_unref0 (_data_->dir_map);
		_g_object_unref0 (_data_->local_dir_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->in_discovery) {
		_data_->_tmp75_ = _data_->local_dir_info;
		directory_monitor_internal_notify_directory_discovered (_data_->self, _data_->dir, _data_->_tmp75_);
	} else {
		_data_->_tmp76_ = _data_->local_dir_info;
		directory_monitor_internal_notify_directory_created (_data_->self, _data_->dir, _data_->_tmp76_);
	}
	_data_->_tmp77_ = _data_->local_dir_info;
	directory_monitor_add_monitor (_data_->self, _data_->dir, _data_->_tmp77_);
	_data_->_tmp78_ = _data_->file_map;
	if (_data_->_tmp78_ != NULL) {
		_data_->_tmp79_ = _data_->file_map;
		_data_->_state_ = 4;
		directory_monitor_notify_directory_files (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp79_, GEE_TYPE_MAP, GeeMap), _data_->in_discovery, directory_monitor_explore_async_ready, _data_);
		return FALSE;
		_state_4:
		directory_monitor_notify_directory_files_finish (_data_->self, _data_->_res_);
	}
	if (_data_->self->priv->recurse) {
		_data_->_tmp81_ = _data_->dir_map;
		_data_->_tmp80_ = _data_->_tmp81_ != NULL;
	} else {
		_data_->_tmp80_ = FALSE;
	}
	if (_data_->_tmp80_) {
		{
			_data_->_tmp82_ = _data_->dir_map;
			_data_->_tmp83_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp82_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
			_data_->_tmp84_ = _data_->_tmp83_;
			_data_->_tmp85_ = _data_->_tmp84_;
			_data_->_tmp86_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp85_, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_tmp87_ = _data_->_tmp86_;
			_g_object_unref0 (_data_->_tmp85_);
			_data_->_subdir_it = _data_->_tmp87_;
			while (TRUE) {
				_data_->_tmp88_ = _data_->_subdir_it;
				if (!gee_iterator_next (_data_->_tmp88_)) {
					break;
				}
				_data_->_tmp89_ = _data_->_subdir_it;
				_data_->_tmp90_ = gee_iterator_get (_data_->_tmp89_);
				_data_->subdir = (GFile*) _data_->_tmp90_;
				_data_->self->priv->outstanding_exploration_dirs = _data_->self->priv->outstanding_exploration_dirs + 1;
				_data_->_tmp91_ = _data_->self->priv->outstanding_exploration_dirs;
				if (_data_->_tmp91_ > DIRECTORY_MONITOR_MAX_EXPLORATION_DIRS) {
					_data_->_tmp92_ = _data_->subdir;
					_data_->_tmp93_ = _data_->dir_map;
					_data_->_tmp94_ = _data_->subdir;
					_data_->_tmp95_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp93_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp94_);
					_data_->_tmp96_ = (GFileInfo*) _data_->_tmp95_;
					_data_->_state_ = 5;
					directory_monitor_explore_async (_data_->self, _data_->_tmp92_, _data_->_tmp96_, _data_->in_discovery, directory_monitor_explore_async_ready, _data_);
					return FALSE;
					_state_5:
					directory_monitor_explore_finish (_data_->self, _data_->_res_);
					_g_object_unref0 (_data_->_tmp96_);
				} else {
					_data_->_tmp97_ = _data_->subdir;
					_data_->_tmp98_ = _data_->dir_map;
					_data_->_tmp99_ = _data_->subdir;
					_data_->_tmp100_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp98_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp99_);
					_data_->_tmp101_ = (GFileInfo*) _data_->_tmp100_;
					directory_monitor_explore_async (_data_->self, _data_->_tmp97_, _data_->_tmp101_, _data_->in_discovery, NULL, NULL);
					_g_object_unref0 (_data_->_tmp101_);
				}
				_g_object_unref0 (_data_->subdir);
			}
			_g_object_unref0 (_data_->_subdir_it);
		}
	}
	directory_monitor_explore_directory_completed (_data_->self, _data_->in_discovery);
	_g_object_unref0 (_data_->file_map);
	_g_object_unref0 (_data_->dir_map);
	_g_object_unref0 (_data_->local_dir_info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
directory_monitor_notify_directory_files_data_free (gpointer _data)
{
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->map);
	_g_object_unref0 (_data_->self);
	g_slice_free (DirectoryMonitorNotifyDirectoryFilesData, _data_);
}

static void
directory_monitor_notify_directory_files (DirectoryMonitor* self,
                                          GeeMap* map,
                                          gboolean in_discovery,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	DirectoryMonitor* _tmp0_;
	GeeMap* _tmp1_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	_data_ = g_slice_new0 (DirectoryMonitorNotifyDirectoryFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, directory_monitor_notify_directory_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (map);
	_g_object_unref0 (_data_->map);
	_data_->map = _tmp1_;
	_data_->in_discovery = in_discovery;
	directory_monitor_notify_directory_files_co (_data_);
}

static void
directory_monitor_notify_directory_files_finish (DirectoryMonitor* self,
                                                 GAsyncResult* _res_)
{
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_directory_monitor_notify_directory_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = directory_monitor_notify_directory_files_co (self);
	return result;
}

static gboolean
directory_monitor_notify_directory_files_co (DirectoryMonitorNotifyDirectoryFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_map_map_iterator (_data_->map);
	_data_->iter = _data_->_tmp0_;
	while (TRUE) {
		_data_->_tmp1_ = _data_->iter;
		if (!gee_map_iterator_next (_data_->_tmp1_)) {
			break;
		}
		if (_data_->in_discovery) {
			_data_->_tmp2_ = _data_->iter;
			_data_->_tmp3_ = gee_map_iterator_get_key (_data_->_tmp2_);
			_data_->_tmp4_ = (GFile*) _data_->_tmp3_;
			_data_->_tmp5_ = _data_->iter;
			_data_->_tmp6_ = gee_map_iterator_get_value (_data_->_tmp5_);
			_data_->_tmp7_ = (GFileInfo*) _data_->_tmp6_;
			directory_monitor_internal_notify_file_discovered (_data_->self, _data_->_tmp4_, _data_->_tmp7_);
			_g_object_unref0 (_data_->_tmp7_);
			_g_object_unref0 (_data_->_tmp4_);
		} else {
			_data_->_tmp8_ = _data_->iter;
			_data_->_tmp9_ = gee_map_iterator_get_key (_data_->_tmp8_);
			_data_->_tmp10_ = (GFile*) _data_->_tmp9_;
			_data_->_tmp11_ = _data_->iter;
			_data_->_tmp12_ = gee_map_iterator_get_value (_data_->_tmp11_);
			_data_->_tmp13_ = (GFileInfo*) _data_->_tmp12_;
			directory_monitor_internal_notify_file_created (_data_->self, _data_->_tmp10_, _data_->_tmp13_);
			_g_object_unref0 (_data_->_tmp13_);
			_g_object_unref0 (_data_->_tmp10_);
		}
		g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_notify_directory_files_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_g_object_unref0 (_data_->iter);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
directory_monitor_explore_directory_completed (DirectoryMonitor* self,
                                               gboolean in_discovery)
{
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	_vala_assert (self->priv->outstanding_exploration_dirs > 0, "outstanding_exploration_dirs > 0");
	_tmp0_ = self->priv->outstanding_exploration_dirs;
	self->priv->outstanding_exploration_dirs = _tmp0_ - 1;
	if (in_discovery) {
		_tmp1_ = self->priv->outstanding_exploration_dirs == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		directory_monitor_notify_discovery_completed (self);
	}
}

static void
_directory_monitor_on_monitor_notification_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self)
{
	directory_monitor_on_monitor_notification ((DirectoryMonitor*) self, file, other_file, event_type);
}

static gboolean
directory_monitor_add_monitor (DirectoryMonitor* self,
                               GFile* dir,
                               GFileInfo* info)
{
	gchar* id = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	GFileMonitor* monitor = NULL;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	GFileMonitor* _tmp15_;
	GFileMonitor* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	if (!self->priv->monitoring) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->files;
	_tmp1_ = directory_monitor_file_info_map_get_id (_tmp0_, dir, info);
	id = _tmp1_;
	_tmp2_ = id;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (id);
		return result;
	}
	_tmp3_ = self->priv->monitors;
	_tmp4_ = id;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_)) {
		result = FALSE;
		_g_free0 (id);
		return result;
	}
	monitor = NULL;
	{
		GFileMonitor* _tmp5_ = NULL;
		GFileMonitor* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp6_ = g_file_monitor_directory (dir, DIRECTORY_MONITOR_FILE_MONITOR_FLAGS, NULL, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (monitor);
		monitor = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = g_file_get_path (dir);
		_tmp9_ = _tmp8_;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_warning ("DirectoryMonitor.vala:1030: Unable to monitor %s: %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		result = FALSE;
		_g_error_free0 (err);
		_g_object_unref0 (monitor);
		_g_free0 (id);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		_g_object_unref0 (monitor);
		_g_free0 (id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	_tmp13_ = self->priv->monitors;
	_tmp14_ = id;
	_tmp15_ = monitor;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, _tmp15_);
	_tmp16_ = monitor;
	g_signal_connect_object (_tmp16_, "changed", (GCallback) _directory_monitor_on_monitor_notification_g_file_monitor_changed, self, 0);
	_tmp17_ = g_file_get_path (dir);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("Added monitor for %s", _tmp18_);
	_tmp20_ = _tmp19_;
	directory_monitor_mdbg (_tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	result = TRUE;
	_g_object_unref0 (monitor);
	_g_free0 (id);
	return result;
}

static gboolean
directory_monitor_remove_monitor (DirectoryMonitor* self,
                                  GFile* dir,
                                  GFileInfo* info)
{
	gchar* id = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFileMonitor* monitor = NULL;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_;
	GFileMonitor* _tmp6_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	GFileMonitor* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	if (!self->priv->monitoring) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->files;
	_tmp1_ = directory_monitor_file_info_map_get_id (_tmp0_, dir, info);
	id = _tmp1_;
	_tmp2_ = id;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (id);
		return result;
	}
	_tmp3_ = self->priv->monitors;
	_tmp4_ = id;
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
	monitor = (GFileMonitor*) _tmp5_;
	_tmp6_ = monitor;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (monitor);
		_g_free0 (id);
		return result;
	}
	_tmp7_ = self->priv->monitors;
	_tmp8_ = id;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, NULL);
	_vala_assert (removed, "removed");
	_tmp9_ = monitor;
	directory_monitor_cancel_monitor (self, _tmp9_);
	_tmp10_ = g_file_get_path (dir);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("Removed monitor for %s", _tmp11_);
	_tmp13_ = _tmp12_;
	directory_monitor_mdbg (_tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = TRUE;
	_g_object_unref0 (monitor);
	_g_free0 (id);
	return result;
}

static void
directory_monitor_cancel_monitor (DirectoryMonitor* self,
                                  GFileMonitor* monitor)
{
	guint _tmp0_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (monitor, g_file_monitor_get_type ()));
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _directory_monitor_on_monitor_notification_g_file_monitor_changed, self);
	g_file_monitor_cancel (monitor);
}

static void
_directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback (GObject* source_object,
                                                                                GAsyncResult* res,
                                                                                gpointer self)
{
	directory_monitor_query_info_queue_element_on_completed ((DirectoryMonitorQueryInfoQueueElement*) self, source_object, res);
	directory_monitor_query_info_queue_element_unref (self);
}

static gboolean
_directory_monitor_check_for_expired_delete_events_gsource_func (gpointer self)
{
	gboolean result;
	result = directory_monitor_check_for_expired_delete_events ((DirectoryMonitor*) self);
	return result;
}

static void
directory_monitor_on_monitor_notification (DirectoryMonitor* self,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event)
{
	gchar* _tmp0_ = NULL;
	GEnumValue* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	DirectoryMonitorQueryInfoQueueElement* query_info = NULL;
	DirectoryMonitorQueryInfoQueueElement* _tmp8_;
	GeeQueue* _tmp9_;
	DirectoryMonitorQueryInfoQueueElement* _tmp10_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((other_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (other_file, g_file_get_type ()));
	if (other_file != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_file_get_path (other_file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("(none)");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
	_tmp4_ = g_file_get_path (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("NOTIFY %s: file=%s other_file=%s", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL, _tmp5_, _tmp0_);
	_tmp7_ = _tmp6_;
	directory_monitor_mdbg (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = directory_monitor_query_info_queue_element_new (self, file, other_file, event);
	query_info = _tmp8_;
	_tmp9_ = self->priv->query_info_queue;
	_tmp10_ = query_info;
	gee_queue_offer (_tmp9_, _tmp10_);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CREATED:
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			GCancellable* _tmp11_;
			DirectoryMonitorQueryInfoQueueElement* _tmp12_;
			_tmp11_ = self->priv->cancellable;
			_tmp12_ = query_info;
			g_file_query_info_async (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _tmp11_, _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback, directory_monitor_query_info_queue_element_ref (_tmp12_));
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			if (self->priv->delete_timer_id == ((guint) 0)) {
				self->priv->delete_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC / 2, _directory_monitor_check_for_expired_delete_events_gsource_func, g_object_ref (self), g_object_unref);
			}
			break;
		}
		case G_FILE_MONITOR_EVENT_MOVED:
		{
			if (other_file != NULL) {
				GCancellable* _tmp13_;
				DirectoryMonitorQueryInfoQueueElement* _tmp14_;
				_tmp13_ = self->priv->cancellable;
				_tmp14_ = query_info;
				g_file_query_info_async (other_file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _tmp13_, _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback, directory_monitor_query_info_queue_element_ref (_tmp14_));
			} else {
				GeeQueue* _tmp15_;
				DirectoryMonitorQueryInfoQueueElement* _tmp16_;
				g_warning ("DirectoryMonitor.vala:1107: Unable to process MOVED event: no other_fi" \
"le");
				_tmp15_ = self->priv->query_info_queue;
				_tmp16_ = query_info;
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
			}
			break;
		}
		default:
		{
			DirectoryMonitorQueryInfoQueueElement* _tmp17_;
			DirectoryMonitorQueryInfoQueueElement* _tmp18_;
			_tmp17_ = query_info;
			_tmp17_->completed = TRUE;
			_tmp18_ = query_info;
			directory_monitor_process_query_queue (self, _tmp18_);
			break;
		}
	}
	_directory_monitor_query_info_queue_element_unref0 (query_info);
	_g_free0 (_tmp0_);
}

static void
directory_monitor_process_query_queue (DirectoryMonitor* self,
                                       DirectoryMonitorQueryInfoQueueElement* query_info)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail ((query_info == NULL) || DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT (query_info));
	if (query_info != NULL) {
		GFileInfo* _tmp2_;
		_tmp2_ = query_info->info;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = query_info->event == G_FILE_MONITOR_EVENT_CREATED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* match = NULL;
		DirectoryMonitorFileInfoMap* _tmp3_;
		GFileInfo* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = self->priv->files;
		_tmp4_ = query_info->info;
		_tmp5_ = directory_monitor_file_info_map_find_match (_tmp3_, _tmp4_);
		match = _tmp5_;
		_tmp6_ = match;
		if (_tmp6_ != NULL) {
			gboolean matched = FALSE;
			matched = FALSE;
			{
				GeeIterator* _enqueued_it = NULL;
				GeeQueue* _tmp7_;
				GeeIterator* _tmp8_;
				_tmp7_ = self->priv->query_info_queue;
				_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
				_enqueued_it = _tmp8_;
				while (TRUE) {
					GeeIterator* _tmp9_;
					DirectoryMonitorQueryInfoQueueElement* enqueued = NULL;
					GeeIterator* _tmp10_;
					gpointer _tmp11_;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					DirectoryMonitorQueryInfoQueueElement* _tmp14_;
					GFile* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					DirectoryMonitorQueryInfoQueueElement* _tmp22_;
					GFile* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					DirectoryMonitorQueryInfoQueueElement* _tmp28_;
					DirectoryMonitorQueryInfoQueueElement* _tmp29_;
					GFile* _tmp30_;
					GFile* _tmp31_;
					DirectoryMonitorQueryInfoQueueElement* _tmp32_;
					GFileInfo* _tmp33_;
					GFileInfo* _tmp34_;
					DirectoryMonitorQueryInfoQueueElement* _tmp35_;
					_tmp9_ = _enqueued_it;
					if (!gee_iterator_next (_tmp9_)) {
						break;
					}
					_tmp10_ = _enqueued_it;
					_tmp11_ = gee_iterator_get (_tmp10_);
					enqueued = (DirectoryMonitorQueryInfoQueueElement*) _tmp11_;
					_tmp14_ = enqueued;
					if (_tmp14_->event != G_FILE_MONITOR_EVENT_DELETED) {
						_tmp13_ = TRUE;
					} else {
						DirectoryMonitorQueryInfoQueueElement* _tmp15_;
						_tmp15_ = enqueued;
						_tmp13_ = _tmp15_->completed;
					}
					if (_tmp13_) {
						_tmp12_ = TRUE;
					} else {
						GFile* _tmp16_;
						DirectoryMonitorQueryInfoQueueElement* _tmp17_;
						GFile* _tmp18_;
						_tmp16_ = match;
						_tmp17_ = enqueued;
						_tmp18_ = _tmp17_->file;
						_tmp12_ = !g_file_equal (_tmp16_, _tmp18_);
					}
					if (_tmp12_) {
						_directory_monitor_query_info_queue_element_unref0 (enqueued);
						continue;
					}
					_tmp19_ = query_info->file;
					_tmp20_ = g_file_get_path (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = enqueued;
					_tmp23_ = _tmp22_->file;
					_tmp24_ = g_file_get_path (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_strdup_printf ("Matching CREATED %s to DELETED %s for MOVED", _tmp21_, _tmp25_);
					_tmp27_ = _tmp26_;
					directory_monitor_mdbg (_tmp27_);
					_g_free0 (_tmp27_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp21_);
					_tmp28_ = enqueued;
					_tmp28_->event = G_FILE_MONITOR_EVENT_MOVED;
					_tmp29_ = enqueued;
					_tmp30_ = query_info->file;
					_tmp31_ = _g_object_ref0 (_tmp30_);
					_g_object_unref0 (_tmp29_->other_file);
					_tmp29_->other_file = _tmp31_;
					_tmp32_ = enqueued;
					_tmp33_ = query_info->info;
					_tmp34_ = _g_object_ref0 (_tmp33_);
					_g_object_unref0 (_tmp32_->info);
					_tmp32_->info = _tmp34_;
					_tmp35_ = enqueued;
					_tmp35_->completed = TRUE;
					matched = TRUE;
					_directory_monitor_query_info_queue_element_unref0 (enqueued);
					break;
				}
				_g_object_unref0 (_enqueued_it);
			}
			if (matched) {
				GeeQueue* _tmp36_;
				_tmp36_ = self->priv->query_info_queue;
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), query_info);
			}
		}
		_g_object_unref0 (match);
	}
	{
		gboolean _tmp37_ = FALSE;
		_tmp37_ = TRUE;
		while (TRUE) {
			DirectoryMonitorQueryInfoQueueElement* next = NULL;
			GeeQueue* _tmp38_;
			gpointer _tmp39_;
			gboolean _tmp40_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp41_;
			DirectoryMonitorQueryInfoQueueElement* n = NULL;
			GeeQueue* _tmp43_;
			gpointer _tmp44_;
			DirectoryMonitorQueryInfoQueueElement* _tmp45_;
			DirectoryMonitorQueryInfoQueueElement* _tmp46_;
			DirectoryMonitorQueryInfoQueueElement* _tmp47_;
			DirectoryMonitorQueryInfoQueueElement* _tmp48_;
			GEnumValue* _tmp49_;
			DirectoryMonitorQueryInfoQueueElement* _tmp50_;
			GFile* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			DirectoryMonitorQueryInfoQueueElement* _tmp56_;
			GError* _tmp57_;
			gboolean _tmp69_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp70_;
			GFileInfo* _tmp71_;
			gboolean _tmp84_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp85_;
			GFileInfo* _tmp86_;
			DirectoryMonitorQueryInfoQueueElement* _tmp97_;
			GFile* _tmp98_;
			DirectoryMonitorQueryInfoQueueElement* _tmp99_;
			GFile* _tmp100_;
			DirectoryMonitorQueryInfoQueueElement* _tmp101_;
			GFileInfo* _tmp102_;
			DirectoryMonitorQueryInfoQueueElement* _tmp103_;
			if (!_tmp37_) {
			}
			_tmp37_ = FALSE;
			_tmp38_ = self->priv->query_info_queue;
			_tmp39_ = gee_queue_peek (_tmp38_);
			next = (DirectoryMonitorQueryInfoQueueElement*) _tmp39_;
			_tmp41_ = next;
			if (_tmp41_ == NULL) {
				_tmp40_ = TRUE;
			} else {
				DirectoryMonitorQueryInfoQueueElement* _tmp42_;
				_tmp42_ = next;
				_tmp40_ = !_tmp42_->completed;
			}
			if (_tmp40_) {
				_directory_monitor_query_info_queue_element_unref0 (next);
				break;
			}
			_tmp43_ = self->priv->query_info_queue;
			_tmp44_ = gee_queue_poll (_tmp43_);
			n = (DirectoryMonitorQueryInfoQueueElement*) _tmp44_;
			_tmp45_ = next;
			_tmp46_ = n;
			_vala_assert (_tmp45_ == _tmp46_, "next == n");
			_tmp47_ = next;
			_tmp48_ = next;
			_tmp49_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp48_->event);
			_tmp50_ = next;
			_tmp51_ = _tmp50_->file;
			_tmp52_ = g_file_get_path (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strdup_printf ("Completed info query %u for %s on %s", _tmp47_->position, (_tmp49_ != NULL) ? _tmp49_->value_name : NULL, _tmp53_);
			_tmp55_ = _tmp54_;
			directory_monitor_mdbg (_tmp55_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			_tmp56_ = next;
			_tmp57_ = _tmp56_->err;
			if (_tmp57_ != NULL) {
				DirectoryMonitorQueryInfoQueueElement* _tmp58_;
				GFile* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				DirectoryMonitorQueryInfoQueueElement* _tmp62_;
				GEnumValue* _tmp63_;
				DirectoryMonitorQueryInfoQueueElement* _tmp64_;
				GError* _tmp65_;
				const gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				_tmp58_ = next;
				_tmp59_ = _tmp58_->file;
				_tmp60_ = g_file_get_path (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = next;
				_tmp63_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp62_->event);
				_tmp64_ = next;
				_tmp65_ = _tmp64_->err;
				_tmp66_ = _tmp65_->message;
				_tmp67_ = g_strdup_printf ("Unable to retrieve file information for %s, dropping %s: %s", _tmp61_, (_tmp63_ != NULL) ? _tmp63_->value_name : NULL, _tmp66_);
				_tmp68_ = _tmp67_;
				directory_monitor_mdbg (_tmp68_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp61_);
				_directory_monitor_query_info_queue_element_unref0 (n);
				_directory_monitor_query_info_queue_element_unref0 (next);
				continue;
			}
			_tmp70_ = next;
			_tmp71_ = _tmp70_->info;
			if (_tmp71_ != NULL) {
				DirectoryMonitorQueryInfoQueueElement* _tmp72_;
				GFileInfo* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				_tmp72_ = next;
				_tmp73_ = _tmp72_->info;
				_tmp74_ = get_file_info_id (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp69_ = _tmp75_ == NULL;
				_g_free0 (_tmp75_);
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				DirectoryMonitorQueryInfoQueueElement* _tmp76_;
				GFile* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				DirectoryMonitorQueryInfoQueueElement* _tmp80_;
				GEnumValue* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				_tmp76_ = next;
				_tmp77_ = _tmp76_->file;
				_tmp78_ = g_file_get_path (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = next;
				_tmp81_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp80_->event);
				_tmp82_ = g_strdup_printf ("Unable to retrieve file ID for %s, dropping %s", _tmp79_, (_tmp81_ != NULL) ? _tmp81_->value_name : NULL);
				_tmp83_ = _tmp82_;
				directory_monitor_mdbg (_tmp83_);
				_g_free0 (_tmp83_);
				_g_free0 (_tmp79_);
				_directory_monitor_query_info_queue_element_unref0 (n);
				_directory_monitor_query_info_queue_element_unref0 (next);
				continue;
			}
			_tmp85_ = next;
			_tmp86_ = _tmp85_->info;
			if (_tmp86_ != NULL) {
				DirectoryMonitorQueryInfoQueueElement* _tmp87_;
				GFileInfo* _tmp88_;
				_tmp87_ = next;
				_tmp88_ = _tmp87_->info;
				_tmp84_ = !directory_monitor_is_file_symlink_supported (_tmp88_);
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				DirectoryMonitorQueryInfoQueueElement* _tmp89_;
				GFile* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				DirectoryMonitorQueryInfoQueueElement* _tmp93_;
				GEnumValue* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp89_ = next;
				_tmp90_ = _tmp89_->file;
				_tmp91_ = g_file_get_path (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = next;
				_tmp94_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp93_->event);
				_tmp95_ = g_strdup_printf ("No symlink support for %s, dropping %s", _tmp92_, (_tmp94_ != NULL) ? _tmp94_->value_name : NULL);
				_tmp96_ = _tmp95_;
				directory_monitor_mdbg (_tmp96_);
				_g_free0 (_tmp96_);
				_g_free0 (_tmp92_);
				_directory_monitor_query_info_queue_element_unref0 (n);
				_directory_monitor_query_info_queue_element_unref0 (next);
				continue;
			}
			_tmp97_ = next;
			_tmp98_ = _tmp97_->file;
			_tmp99_ = next;
			_tmp100_ = _tmp99_->other_file;
			_tmp101_ = next;
			_tmp102_ = _tmp101_->info;
			_tmp103_ = next;
			directory_monitor_on_monitor_notification_ready (self, _tmp98_, _tmp100_, _tmp102_, _tmp103_->event);
			_directory_monitor_query_info_queue_element_unref0 (n);
			_directory_monitor_query_info_queue_element_unref0 (next);
		}
	}
}

static void
directory_monitor_on_monitor_notification_ready (DirectoryMonitor* self,
                                                 GFile* file,
                                                 GFile* other_file,
                                                 GFileInfo* info,
                                                 GFileMonitorEvent event)
{
	gchar* _tmp0_ = NULL;
	GEnumValue* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((other_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (other_file, g_file_get_type ()));
	g_return_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	if (other_file != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_file_get_path (other_file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("(null)");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
	_tmp4_ = g_file_get_path (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("READY %s: file=%s other_file=%s", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL, _tmp5_, _tmp0_);
	_tmp7_ = _tmp6_;
	directory_monitor_mdbg (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			DirectoryMonitorFType ftype = 0;
			_vala_assert (info != NULL, "info != null");
			ftype = directory_monitor_get_ftype (info);
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					directory_monitor_internal_notify_file_created (self, file, info);
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					gint _tmp8_;
					_tmp8_ = self->priv->outstanding_exploration_dirs;
					self->priv->outstanding_exploration_dirs = _tmp8_ + 1;
					directory_monitor_explore_async (self, file, info, FALSE, NULL, NULL);
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			break;
		}
		case G_FILE_MONITOR_EVENT_CHANGED:
		{
			GFileInfo* local_info = NULL;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp15_;
			_vala_assert (info == NULL, "info == null");
			_tmp9_ = directory_monitor_get_file_info (self, file);
			local_info = _tmp9_;
			_tmp10_ = local_info;
			if (_tmp10_ == NULL) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp11_ = g_file_get_path (file);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("Changed event for unknown file %s", _tmp12_);
				_tmp14_ = _tmp13_;
				directory_monitor_mdbg (_tmp14_);
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_g_object_unref0 (local_info);
				break;
			}
			_tmp15_ = local_info;
			ftype = directory_monitor_get_ftype (_tmp15_);
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					directory_monitor_notify_file_altered (self, file);
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					directory_monitor_notify_directory_altered (self, file);
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			_g_object_unref0 (local_info);
			break;
		}
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			DirectoryMonitorFType ftype = 0;
			_vala_assert (info != NULL, "info != null");
			ftype = directory_monitor_get_ftype (info);
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					directory_monitor_internal_notify_file_alteration_completed (self, file, info);
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					directory_monitor_internal_notify_directory_alteration_completed (self, file, info);
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			break;
		}
		case G_FILE_MONITOR_EVENT_MOVED:
		{
			DirectoryMonitorFType ftype = 0;
			_vala_assert (info != NULL, "info != null");
			_vala_assert (other_file != NULL, "other_file != null");
			ftype = directory_monitor_get_ftype (info);
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					directory_monitor_internal_notify_file_moved (self, file, other_file, info);
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					GFileInfo* old_dir_info = NULL;
					DirectoryMonitorFileInfoMap* _tmp16_;
					GFileInfo* _tmp17_;
					GFileInfo* _tmp18_;
					GFileInfo* _tmp21_;
					_tmp16_ = self->priv->files;
					_tmp17_ = directory_monitor_file_info_map_get_info (_tmp16_, file);
					old_dir_info = _tmp17_;
					_tmp18_ = old_dir_info;
					if (_tmp18_ == NULL) {
						gchar* _tmp19_;
						gchar* _tmp20_;
						_tmp19_ = g_file_get_path (file);
						_tmp20_ = _tmp19_;
						g_warning ("DirectoryMonitor.vala:1289: Directory moved event for unknown file %s", _tmp20_);
						_g_free0 (_tmp20_);
						_g_object_unref0 (old_dir_info);
						break;
					}
					_tmp21_ = old_dir_info;
					directory_monitor_internal_notify_directory_moved (self, file, _tmp21_, other_file, info);
					_g_object_unref0 (old_dir_info);
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			GFileInfo* local_info = NULL;
			GFileInfo* _tmp22_;
			GFileInfo* _tmp23_;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp26_;
			_vala_assert (info == NULL, "info == null");
			_tmp22_ = directory_monitor_get_file_info (self, file);
			local_info = _tmp22_;
			_tmp23_ = local_info;
			if (_tmp23_ == NULL) {
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = g_file_get_path (file);
				_tmp25_ = _tmp24_;
				g_warning ("DirectoryMonitor.vala:1308: Deleted event for unknown file %s", _tmp25_);
				_g_free0 (_tmp25_);
				_g_object_unref0 (local_info);
				break;
			}
			_tmp26_ = local_info;
			ftype = directory_monitor_get_ftype (_tmp26_);
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					directory_monitor_internal_notify_file_deleted (self, file);
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					directory_monitor_internal_notify_directory_deleted (self, file);
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			_g_object_unref0 (local_info);
			break;
		}
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			GFileInfo* local_info = NULL;
			GFileInfo* _tmp27_;
			GFileInfo* _tmp28_;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp31_;
			_vala_assert (info == NULL, "info == null");
			_tmp27_ = directory_monitor_get_file_info (self, file);
			local_info = _tmp27_;
			_tmp28_ = local_info;
			if (_tmp28_ == NULL) {
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp29_ = g_file_get_path (file);
				_tmp30_ = _tmp29_;
				g_warning ("DirectoryMonitor.vala:1335: Attribute changed event for unknown file %" \
"s", _tmp30_);
				_g_free0 (_tmp30_);
				_g_object_unref0 (local_info);
				break;
			}
			_tmp31_ = local_info;
			ftype = directory_monitor_get_ftype (_tmp31_);
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					directory_monitor_notify_file_attributes_altered (self, file);
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					directory_monitor_notify_directory_attributes_altered (self, file);
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			_g_object_unref0 (local_info);
			break;
		}
		case G_FILE_MONITOR_EVENT_PRE_UNMOUNT:
		case G_FILE_MONITOR_EVENT_UNMOUNTED:
		{
			break;
		}
		default:
		{
			GEnumValue* _tmp32_;
			_tmp32_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
			g_warning ("DirectoryMonitor.vala:1362: Unknown directory monitor event %s", (_tmp32_ != NULL) ? _tmp32_->value_name : NULL);
			break;
		}
	}
	_g_free0 (_tmp0_);
}

static gboolean
directory_monitor_is_file_create_move (DirectoryMonitor* self,
                                       GFile* file,
                                       GFileInfo* info,
                                       GFile** old_file,
                                       GFileInfo** old_file_info)
{
	GFile* _vala_old_file = NULL;
	GFileInfo* _vala_old_file_info = NULL;
	GFile* match = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp0_ = self->priv->parent_moved;
	_tmp1_ = directory_monitor_file_info_map_find_match (_tmp0_, info);
	match = _tmp1_;
	_tmp2_ = match;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		DirectoryMonitorFileInfoMap* _tmp5_;
		GFile* _tmp6_;
		GFileInfo* _tmp7_;
		DirectoryMonitorFileInfoMap* _tmp8_;
		GFile* _tmp9_;
		_tmp3_ = match;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_vala_old_file);
		_vala_old_file = _tmp4_;
		_tmp5_ = self->priv->parent_moved;
		_tmp6_ = match;
		_tmp7_ = directory_monitor_file_info_map_get_info (_tmp5_, _tmp6_);
		_g_object_unref0 (_vala_old_file_info);
		_vala_old_file_info = _tmp7_;
		_tmp8_ = self->priv->parent_moved;
		_tmp9_ = match;
		directory_monitor_file_info_map_remove (_tmp8_, _tmp9_, info);
		result = TRUE;
		_g_object_unref0 (match);
		if (old_file) {
			*old_file = _vala_old_file;
		} else {
			_g_object_unref0 (_vala_old_file);
		}
		if (old_file_info) {
			*old_file_info = _vala_old_file_info;
		} else {
			_g_object_unref0 (_vala_old_file_info);
		}
		return result;
	}
	_g_object_unref0 (_vala_old_file);
	_vala_old_file = NULL;
	_g_object_unref0 (_vala_old_file_info);
	_vala_old_file_info = NULL;
	result = FALSE;
	_g_object_unref0 (match);
	if (old_file) {
		*old_file = _vala_old_file;
	} else {
		_g_object_unref0 (_vala_old_file);
	}
	if (old_file_info) {
		*old_file_info = _vala_old_file_info;
	} else {
		_g_object_unref0 (_vala_old_file_info);
	}
	return result;
}

static gboolean
directory_monitor_check_for_expired_delete_events (DirectoryMonitor* self)
{
	gulong expiration = 0UL;
	gboolean any_deleted = FALSE;
	gboolean any_expired = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
	expiration = now_ms () - DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC;
	any_deleted = FALSE;
	any_expired = FALSE;
	{
		GeeIterator* _element_it = NULL;
		GeeQueue* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->query_info_queue;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
		_element_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DirectoryMonitorQueryInfoQueueElement* element = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DirectoryMonitorQueryInfoQueueElement* _tmp5_;
			DirectoryMonitorQueryInfoQueueElement* _tmp6_;
			DirectoryMonitorQueryInfoQueueElement* _tmp7_;
			_tmp2_ = _element_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _element_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			element = (DirectoryMonitorQueryInfoQueueElement*) _tmp4_;
			_tmp5_ = element;
			if (_tmp5_->event != G_FILE_MONITOR_EVENT_DELETED) {
				_directory_monitor_query_info_queue_element_unref0 (element);
				continue;
			}
			any_deleted = TRUE;
			_tmp6_ = element;
			if (_tmp6_->time_created_msec > expiration) {
				_directory_monitor_query_info_queue_element_unref0 (element);
				continue;
			}
			_tmp7_ = element;
			_tmp7_->completed = TRUE;
			any_expired = TRUE;
			_directory_monitor_query_info_queue_element_unref0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	if (any_expired) {
		directory_monitor_process_query_queue (self, NULL);
	}
	if (!any_deleted) {
		self->priv->delete_timer_id = (guint) 0;
	}
	result = any_deleted;
	return result;
}

GFileInfo*
directory_monitor_get_file_info (DirectoryMonitor* self,
                                 GFile* file)
{
	DirectoryMonitorFileInfoMap* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = directory_monitor_file_info_map_get_info (_tmp0_, file);
	result = _tmp1_;
	return result;
}

GeeCollection*
directory_monitor_get_files (DirectoryMonitor* self)
{
	DirectoryMonitorFileInfoMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = directory_monitor_file_info_map_get_all (_tmp0_);
	result = _tmp1_;
	return result;
}

GFileInfo*
directory_monitor_query_file_info (DirectoryMonitor* self,
                                   GFile* file)
{
	DirectoryMonitorFileInfoMap* _tmp0_;
	GCancellable* _tmp1_;
	GFileInfo* _tmp2_;
	GFileInfo* result;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = self->priv->cancellable;
	_tmp2_ = directory_monitor_file_info_map_query_info (_tmp0_, file, _tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
directory_monitor_is_file_symlink_supported (GFileInfo* info)
{
	DirectoryMonitorFType ftype = 0;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	if (!g_file_info_get_is_symlink (info)) {
		result = TRUE;
		return result;
	}
	ftype = directory_monitor_get_ftype (info);
	switch (ftype) {
		case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
		{
			result = DIRECTORY_MONITOR_SUPPORT_DIR_SYMLINKS;
			return result;
		}
		case DIRECTORY_MONITOR_FTYPE_FILE:
		{
			result = DIRECTORY_MONITOR_SUPPORT_FILE_SYMLINKS;
			return result;
		}
		default:
		{
			_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
			result = FALSE;
			return result;
		}
	}
}

static void
directory_monitor_real_root_moved (DirectoryMonitor* self,
                                   GFile* old_root,
                                   GFile* new_root,
                                   GFileInfo* new_root_info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_root, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_root, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_root_info, g_file_info_get_type ()));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
}

static void
directory_monitor_real_root_deleted (DirectoryMonitor* self,
                                     GFile* root)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_file_get_type ()));
}

static void
directory_monitor_real_discovery_started (DirectoryMonitor* self)
{
}

static void
directory_monitor_real_file_discovered (DirectoryMonitor* self,
                                        GFile* file,
                                        GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
directory_monitor_real_directory_discovered (DirectoryMonitor* self,
                                             GFile* file,
                                             GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

static void
directory_monitor_real_discovery_failed (DirectoryMonitor* self,
                                         const gchar* reason)
{
	g_return_if_fail (reason != NULL);
}

static void
directory_monitor_real_discovery_completed (DirectoryMonitor* self)
{
	self->priv->has_discovery_started = FALSE;
	directory_monitor_mdbg ("discovery completed");
}

static void
directory_monitor_real_file_created (DirectoryMonitor* self,
                                     GFile* file,
                                     GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

static void
directory_monitor_real_file_moved (DirectoryMonitor* self,
                                   GFile* old_file,
                                   GFile* new_file,
                                   GFileInfo* new_file_info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file_info, g_file_info_get_type ()));
}

static void
directory_monitor_real_file_altered (DirectoryMonitor* self,
                                     GFile* file)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
}

static void
directory_monitor_real_file_alteration_completed (DirectoryMonitor* self,
                                                  GFile* file,
                                                  GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

static void
directory_monitor_real_file_attributes_altered (DirectoryMonitor* self,
                                                GFile* file)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
}

static void
directory_monitor_real_file_deleted (DirectoryMonitor* self,
                                     GFile* file)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
}

static void
directory_monitor_real_directory_created (DirectoryMonitor* self,
                                          GFile* dir,
                                          GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

static void
directory_monitor_real_directory_moved (DirectoryMonitor* self,
                                        GFile* old_dir,
                                        GFile* new_dir,
                                        GFileInfo* new_dir_info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_dir_info, g_file_info_get_type ()));
}

static void
directory_monitor_real_directory_altered (DirectoryMonitor* self,
                                          GFile* dir)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
}

static void
directory_monitor_real_directory_alteration_completed (DirectoryMonitor* self,
                                                       GFile* dir,
                                                       GFileInfo* info)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
}

static void
directory_monitor_real_directory_attributes_altered (DirectoryMonitor* self,
                                                     GFile* dir)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
}

static void
directory_monitor_real_directory_deleted (DirectoryMonitor* self,
                                          GFile* dir)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
}

static void
directory_monitor_real_closed (DirectoryMonitor* self)
{
}

static DirectoryMonitorQueryInfoQueueElement*
directory_monitor_query_info_queue_element_construct (GType object_type,
                                                      DirectoryMonitor* owner,
                                                      GFile* file,
                                                      GFile* other_file,
                                                      GFileMonitorEvent event)
{
	DirectoryMonitorQueryInfoQueueElement* self = NULL;
	DirectoryMonitor* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (owner), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail ((other_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (other_file, g_file_get_type ()), NULL);
	self = (DirectoryMonitorQueryInfoQueueElement*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->owner);
	self->owner = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (other_file);
	_g_object_unref0 (self->other_file);
	self->other_file = _tmp2_;
	self->event = event;
	_tmp3_ = directory_monitor_query_info_queue_element_current;
	directory_monitor_query_info_queue_element_current = _tmp3_ + 1;
	self->position = _tmp3_;
	self->time_created_msec = now_ms ();
	return self;
}

static DirectoryMonitorQueryInfoQueueElement*
directory_monitor_query_info_queue_element_new (DirectoryMonitor* owner,
                                                GFile* file,
                                                GFile* other_file,
                                                GFileMonitorEvent event)
{
	return directory_monitor_query_info_queue_element_construct (DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, owner, file, other_file, event);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
directory_monitor_query_info_queue_element_on_completed (DirectoryMonitorQueryInfoQueueElement* self,
                                                         GObject* source,
                                                         GAsyncResult* aresult)
{
	GFile* source_file = NULL;
	GFile* _tmp0_;
	DirectoryMonitor* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT (self));
	g_return_if_fail ((source == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (source, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (aresult, g_async_result_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, g_file_get_type (), GFile));
	source_file = _tmp0_;
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		GFileInfo* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = g_file_query_info_finish (source_file, aresult, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->info);
		self->info = _tmp3_;
		_tmp4_ = self->info;
		_tmp5_ = get_file_info_id (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_ == NULL;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			GFileInfo* _tmp8_;
			GFile* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = self->info;
			_tmp9_ = self->file;
			_tmp10_ = g_file_get_uri (_tmp9_);
			_tmp11_ = _tmp10_;
			g_file_info_set_attribute_string (_tmp8_, G_FILE_ATTRIBUTE_ID_FILE, _tmp11_);
			_g_free0 (_tmp11_);
		}
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _g_error_copy0 (_tmp12_);
		_g_error_free0 (self->err);
		self->err = _tmp13_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (source_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->completed = TRUE;
	_tmp14_ = self->owner;
	directory_monitor_process_query_queue (_tmp14_, self);
	_g_object_unref0 (source_file);
}

static void
directory_monitor_value_query_info_queue_element_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
directory_monitor_value_query_info_queue_element_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		directory_monitor_query_info_queue_element_unref (value->data[0].v_pointer);
	}
}

static void
directory_monitor_value_query_info_queue_element_copy_value (const GValue* src_value,
                                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = directory_monitor_query_info_queue_element_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
directory_monitor_value_query_info_queue_element_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
directory_monitor_value_query_info_queue_element_collect_value (GValue* value,
                                                                guint n_collect_values,
                                                                GTypeCValue* collect_values,
                                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DirectoryMonitorQueryInfoQueueElement * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = directory_monitor_query_info_queue_element_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
directory_monitor_value_query_info_queue_element_lcopy_value (const GValue* value,
                                                              guint n_collect_values,
                                                              GTypeCValue* collect_values,
                                                              guint collect_flags)
{
	DirectoryMonitorQueryInfoQueueElement ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = directory_monitor_query_info_queue_element_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
directory_monitor_param_spec_query_info_queue_element (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags)
{
	DirectoryMonitorParamSpecQueryInfoQueueElement* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
directory_monitor_value_get_query_info_queue_element (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT), NULL);
	return value->data[0].v_pointer;
}

static void
directory_monitor_value_set_query_info_queue_element (GValue* value,
                                                      gpointer v_object)
{
	DirectoryMonitorQueryInfoQueueElement * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		directory_monitor_query_info_queue_element_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		directory_monitor_query_info_queue_element_unref (old);
	}
}

static void
directory_monitor_value_take_query_info_queue_element (GValue* value,
                                                       gpointer v_object)
{
	DirectoryMonitorQueryInfoQueueElement * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		directory_monitor_query_info_queue_element_unref (old);
	}
}

static void
directory_monitor_query_info_queue_element_class_init (DirectoryMonitorQueryInfoQueueElementClass * klass,
                                                       gpointer klass_data)
{
	directory_monitor_query_info_queue_element_parent_class = g_type_class_peek_parent (klass);
	((DirectoryMonitorQueryInfoQueueElementClass *) klass)->finalize = directory_monitor_query_info_queue_element_finalize;
}

static void
directory_monitor_query_info_queue_element_instance_init (DirectoryMonitorQueryInfoQueueElement * self,
                                                          gpointer klass)
{
	self->info = NULL;
	self->err = NULL;
	self->completed = FALSE;
	self->ref_count = 1;
}

static void
directory_monitor_query_info_queue_element_finalize (DirectoryMonitorQueryInfoQueueElement * obj)
{
	DirectoryMonitorQueryInfoQueueElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElement);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->owner);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->other_file);
	_g_object_unref0 (self->info);
	_g_error_free0 (self->err);
}

static GType
directory_monitor_query_info_queue_element_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { directory_monitor_value_query_info_queue_element_init, directory_monitor_value_query_info_queue_element_free_value, directory_monitor_value_query_info_queue_element_copy_value, directory_monitor_value_query_info_queue_element_peek_pointer, "p", directory_monitor_value_query_info_queue_element_collect_value, "p", directory_monitor_value_query_info_queue_element_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorQueryInfoQueueElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_query_info_queue_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitorQueryInfoQueueElement), 0, (GInstanceInitFunc) directory_monitor_query_info_queue_element_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType directory_monitor_query_info_queue_element_type_id;
	directory_monitor_query_info_queue_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DirectoryMonitorQueryInfoQueueElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return directory_monitor_query_info_queue_element_type_id;
}

static GType
directory_monitor_query_info_queue_element_get_type (void)
{
	static volatile gsize directory_monitor_query_info_queue_element_type_id__once = 0;
	if (g_once_init_enter (&directory_monitor_query_info_queue_element_type_id__once)) {
		GType directory_monitor_query_info_queue_element_type_id;
		directory_monitor_query_info_queue_element_type_id = directory_monitor_query_info_queue_element_get_type_once ();
		g_once_init_leave (&directory_monitor_query_info_queue_element_type_id__once, directory_monitor_query_info_queue_element_type_id);
	}
	return directory_monitor_query_info_queue_element_type_id__once;
}

static gpointer
directory_monitor_query_info_queue_element_ref (gpointer instance)
{
	DirectoryMonitorQueryInfoQueueElement * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
directory_monitor_query_info_queue_element_unref (gpointer instance)
{
	DirectoryMonitorQueryInfoQueueElement * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
directory_monitor_file_info_map_get_instance_private (DirectoryMonitorFileInfoMap* self)
{
	return G_STRUCT_MEMBER_P (self, DirectoryMonitorFileInfoMap_private_offset);
}

static DirectoryMonitorFileInfoMap*
directory_monitor_file_info_map_construct (GType object_type)
{
	DirectoryMonitorFileInfoMap* self = NULL;
	self = (DirectoryMonitorFileInfoMap*) g_type_create_instance (object_type);
	return self;
}

static DirectoryMonitorFileInfoMap*
directory_monitor_file_info_map_new (void)
{
	return directory_monitor_file_info_map_construct (DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP);
}

static gboolean
directory_monitor_file_info_map_normalize_file (DirectoryMonitorFileInfoMap* self,
                                                GFile* file,
                                                GFileInfo* info,
                                                GFile** normalized,
                                                gchar** id)
{
	GFile* _vala_normalized = NULL;
	gchar* _vala_id = NULL;
	GFileInfo* local_info = NULL;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	gchar* file_id = NULL;
	GFileInfo* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GFile* known_file = NULL;
	GeeHashMap* _tmp8_;
	const gchar* _tmp9_;
	gpointer _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_;
	GFile* _tmp16_;
	gboolean result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp0_ = _g_object_ref0 (info);
	local_info = _tmp0_;
	_tmp1_ = local_info;
	if (_tmp1_ == NULL) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GFileInfo* _tmp4_;
		_tmp2_ = self->priv->map;
		_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
		_g_object_unref0 (local_info);
		local_info = (GFileInfo*) _tmp3_;
		_tmp4_ = local_info;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (_vala_normalized);
			_vala_normalized = NULL;
			_g_free0 (_vala_id);
			_vala_id = NULL;
			result = FALSE;
			_g_object_unref0 (local_info);
			if (normalized) {
				*normalized = _vala_normalized;
			} else {
				_g_object_unref0 (_vala_normalized);
			}
			if (id) {
				*id = _vala_id;
			} else {
				_g_free0 (_vala_id);
			}
			return result;
		}
	}
	_tmp5_ = local_info;
	_tmp6_ = get_file_info_id (_tmp5_);
	file_id = _tmp6_;
	_tmp7_ = file_id;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_vala_normalized);
		_vala_normalized = NULL;
		_g_free0 (_vala_id);
		_vala_id = NULL;
		result = FALSE;
		_g_free0 (file_id);
		_g_object_unref0 (local_info);
		if (normalized) {
			*normalized = _vala_normalized;
		} else {
			_g_object_unref0 (_vala_normalized);
		}
		if (id) {
			*id = _vala_id;
		} else {
			_g_free0 (_vala_id);
		}
		return result;
	}
	_tmp8_ = self->priv->id_map;
	_tmp9_ = file_id;
	_tmp10_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_);
	known_file = (GFile*) _tmp10_;
	_tmp11_ = file_id;
	_tmp12_ = g_strdup ((const gchar*) _tmp11_);
	_g_free0 (_vala_id);
	_vala_id = _tmp12_;
	_tmp14_ = known_file;
	if (_tmp14_ != NULL) {
		GFile* _tmp15_;
		_tmp15_ = known_file;
		_tmp13_ = _tmp15_;
	} else {
		_tmp13_ = file;
	}
	_tmp16_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (_vala_normalized);
	_vala_normalized = _tmp16_;
	result = TRUE;
	_g_object_unref0 (known_file);
	_g_free0 (file_id);
	_g_object_unref0 (local_info);
	if (normalized) {
		*normalized = _vala_normalized;
	} else {
		_g_object_unref0 (_vala_normalized);
	}
	if (id) {
		*id = _vala_id;
	} else {
		_g_free0 (_vala_id);
	}
	return result;
}

static gboolean
directory_monitor_file_info_map_update (DirectoryMonitorFileInfoMap* self,
                                        GFile* file,
                                        GFileInfo* info)
{
	GeeHashMap* _tmp0_;
	gchar* existing_id = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_;
	GeeHashMap* _tmp12_;
	GFile* _tmp13_;
	GeeHashMap* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gboolean result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp0_ = self->priv->map;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file)) {
		gboolean removed = FALSE;
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->map;
		removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file, NULL);
		_vala_assert (removed, "removed");
	}
	_tmp2_ = get_file_info_id (info);
	existing_id = _tmp2_;
	_tmp4_ = existing_id;
	if (_tmp4_ != NULL) {
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->id_map;
		_tmp6_ = existing_id;
		_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean removed = FALSE;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->id_map;
		_tmp8_ = existing_id;
		removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, NULL);
		_vala_assert (removed, "removed");
	}
	_tmp11_ = directory_monitor_file_info_map_normalize_file (self, file, info, &_tmp9_, &_tmp10_);
	_g_object_unref0 (normalized);
	normalized = _tmp9_;
	_g_free0 (id);
	id = _tmp10_;
	if (!_tmp11_) {
		result = FALSE;
		_g_object_unref0 (normalized);
		_g_free0 (id);
		_g_free0 (existing_id);
		return result;
	}
	_tmp12_ = self->priv->map;
	_tmp13_ = normalized;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, info);
	_tmp14_ = self->priv->id_map;
	_tmp15_ = id;
	_tmp16_ = normalized;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_, _tmp16_);
	result = TRUE;
	_g_object_unref0 (normalized);
	_g_free0 (id);
	_g_free0 (existing_id);
	return result;
}

static gboolean
directory_monitor_file_info_map_remove (DirectoryMonitorFileInfoMap* self,
                                        GFile* file,
                                        GFileInfo* info)
{
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	GeeHashMap* _tmp3_;
	GFile* _tmp4_;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp2_ = directory_monitor_file_info_map_normalize_file (self, file, info, &_tmp0_, &_tmp1_);
	_g_object_unref0 (normalized);
	normalized = _tmp0_;
	_g_free0 (id);
	id = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		_g_object_unref0 (normalized);
		_g_free0 (id);
		return result;
	}
	_tmp3_ = self->priv->map;
	_tmp4_ = normalized;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
	_tmp5_ = self->priv->id_map;
	_tmp6_ = id;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_, NULL);
	result = TRUE;
	_g_object_unref0 (normalized);
	_g_free0 (id);
	return result;
}

static void
directory_monitor_file_info_map_remove_all (DirectoryMonitorFileInfoMap* self,
                                            GeeCollection* files)
{
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (files, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _file_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (files, GEE_TYPE_ITERABLE, GeeIterable));
		_file_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GFile* file = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GFile* _tmp4_;
			_tmp1_ = _file_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _file_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			file = (GFile*) _tmp3_;
			_tmp4_ = file;
			directory_monitor_file_info_map_remove (self, _tmp4_, NULL);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
}

static gboolean
directory_monitor_file_info_map_contains (DirectoryMonitorFileInfoMap* self,
                                          GFile* file,
                                          GFileInfo* info)
{
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp2_ = directory_monitor_file_info_map_normalize_file (self, file, info, &_tmp0_, &_tmp1_);
	_g_object_unref0 (normalized);
	normalized = _tmp0_;
	_g_free0 (id);
	id = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		_g_object_unref0 (normalized);
		_g_free0 (id);
		return result;
	}
	_tmp3_ = self->priv->id_map;
	_tmp4_ = id;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
	_g_object_unref0 (normalized);
	_g_free0 (id);
	return result;
}

static gchar*
directory_monitor_file_info_map_get_id (DirectoryMonitorFileInfoMap* self,
                                        GFile* file,
                                        GFileInfo* info)
{
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gchar* result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail ((info == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), NULL);
	if (info != NULL) {
		gchar* _tmp0_;
		_tmp0_ = get_file_info_id (info);
		result = _tmp0_;
		return result;
	}
	_tmp3_ = directory_monitor_file_info_map_normalize_file (self, file, NULL, &_tmp1_, &_tmp2_);
	_g_object_unref0 (normalized);
	normalized = _tmp1_;
	_g_free0 (id);
	id = _tmp2_;
	if (!_tmp3_) {
		result = NULL;
		_g_object_unref0 (normalized);
		_g_free0 (id);
		return result;
	}
	result = id;
	_g_object_unref0 (normalized);
	return result;
}

static GeeCollection*
directory_monitor_file_info_map_get_all (DirectoryMonitorFileInfoMap* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

static GFileInfo*
directory_monitor_file_info_map_get_info (DirectoryMonitorFileInfoMap* self,
                                          GFile* file)
{
	GFileInfo* info = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GFileInfo* _tmp2_;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	GeeHashMap* _tmp6_;
	GFile* _tmp7_;
	gpointer _tmp8_;
	GFileInfo* result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	info = (GFileInfo*) _tmp1_;
	_tmp2_ = info;
	if (_tmp2_ != NULL) {
		result = info;
		return result;
	}
	_tmp5_ = directory_monitor_file_info_map_normalize_file (self, file, NULL, &_tmp3_, &_tmp4_);
	_g_object_unref0 (normalized);
	normalized = _tmp3_;
	_g_free0 (id);
	id = _tmp4_;
	if (!_tmp5_) {
		result = NULL;
		_g_object_unref0 (normalized);
		_g_free0 (id);
		_g_object_unref0 (info);
		return result;
	}
	_tmp6_ = self->priv->map;
	_tmp7_ = normalized;
	_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
	result = (GFileInfo*) _tmp8_;
	_g_object_unref0 (normalized);
	_g_free0 (id);
	_g_object_unref0 (info);
	return result;
}

static GFileInfo*
directory_monitor_file_info_map_query_info (DirectoryMonitorFileInfoMap* self,
                                            GFile* file,
                                            GCancellable* cancellable)
{
	GFileInfo* info = NULL;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp9_;
	gchar* id = NULL;
	GFileInfo* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GFile* normalized = NULL;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	gpointer _tmp19_;
	GFile* _tmp20_;
	GeeHashMap* _tmp21_;
	gpointer _tmp22_;
	GError* _inner_error0_ = NULL;
	GFileInfo* result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = directory_monitor_file_info_map_get_info (self, file);
	info = _tmp0_;
	_tmp1_ = info;
	if (_tmp1_ != NULL) {
		result = info;
		return result;
	}
	{
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_;
		GFileInfo* _tmp4_;
		_tmp3_ = g_file_query_info (file, G_FILE_ATTRIBUTE_ID_FILE, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, cancellable, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (info);
		info = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = g_file_get_path (file);
		_tmp6_ = _tmp5_;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("DirectoryMonitor.vala:265: Unable to query file ID of %s: %s", _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (info);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp9_ = info;
	if (!directory_monitor_is_file_symlink_supported (_tmp9_)) {
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp10_ = info;
	_tmp11_ = g_file_info_get_attribute_string (_tmp10_, G_FILE_ATTRIBUTE_ID_FILE);
	_tmp12_ = g_strdup (_tmp11_);
	id = _tmp12_;
	_tmp13_ = id;
	if (_tmp13_ == NULL) {
		GFileInfo* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = info;
		_tmp15_ = g_file_get_uri (file);
		_tmp16_ = _tmp15_;
		g_file_info_set_attribute_string (_tmp14_, G_FILE_ATTRIBUTE_ID_FILE, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = self->priv->id_map;
	_tmp18_ = id;
	_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
	normalized = (GFile*) _tmp19_;
	_tmp20_ = normalized;
	if (_tmp20_ == NULL) {
		result = NULL;
		_g_object_unref0 (normalized);
		_g_free0 (id);
		_g_object_unref0 (info);
		return result;
	}
	_tmp21_ = self->priv->map;
	_tmp22_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (GFileInfo*) _tmp22_;
	_g_object_unref0 (normalized);
	_g_free0 (id);
	_g_object_unref0 (info);
	return result;
}

static GFile*
directory_monitor_file_info_map_find_match (DirectoryMonitorFileInfoMap* self,
                                            GFileInfo* match)
{
	gchar* match_id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint64 match_size = 0LL;
	GDateTime* match_time = NULL;
	GDateTime* _tmp2_;
	GFile* result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (match, g_file_info_get_type ()), NULL);
	_tmp0_ = get_file_info_id (match);
	match_id = _tmp0_;
	_tmp1_ = match_id;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (match_id);
		return result;
	}
	match_size = g_file_info_get_size (match);
	_tmp2_ = g_file_info_get_modification_date_time (match);
	match_time = _tmp2_;
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp3_ = self->priv->map;
		_tmp4_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_file_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			GFile* file = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GFileInfo* info = NULL;
			GeeHashMap* _tmp12_;
			GFile* _tmp13_;
			gpointer _tmp14_;
			GFileInfo* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_;
			GFileInfo* _tmp20_;
			GDateTime* time = NULL;
			GFileInfo* _tmp21_;
			GDateTime* _tmp22_;
			GDateTime* _tmp23_;
			GDateTime* _tmp24_;
			_tmp9_ = _file_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _file_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			file = (GFile*) _tmp11_;
			_tmp12_ = self->priv->map;
			_tmp13_ = file;
			_tmp14_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_);
			info = (GFileInfo*) _tmp14_;
			_tmp15_ = info;
			_tmp16_ = get_file_info_id (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = match_id;
			_tmp19_ = g_strcmp0 (_tmp17_, _tmp18_) == 0;
			_g_free0 (_tmp17_);
			if (_tmp19_) {
				result = file;
				_g_object_unref0 (info);
				_g_object_unref0 (_file_it);
				_g_date_time_unref0 (match_time);
				_g_free0 (match_id);
				return result;
			}
			_tmp20_ = info;
			if (match_size != g_file_info_get_size (_tmp20_)) {
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			_tmp21_ = info;
			_tmp22_ = g_file_info_get_modification_date_time (_tmp21_);
			time = _tmp22_;
			_tmp23_ = time;
			_tmp24_ = match_time;
			if (!g_date_time_equal (_tmp23_, _tmp24_)) {
				_g_date_time_unref0 (time);
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			result = file;
			_g_date_time_unref0 (time);
			_g_object_unref0 (info);
			_g_object_unref0 (_file_it);
			_g_date_time_unref0 (match_time);
			_g_free0 (match_id);
			return result;
		}
		_g_object_unref0 (_file_it);
	}
	result = NULL;
	_g_date_time_unref0 (match_time);
	_g_free0 (match_id);
	return result;
}

static void
directory_monitor_file_info_map_remove_descendents (DirectoryMonitorFileInfoMap* self,
                                                    GFile* root,
                                                    DirectoryMonitorFileInfoMap* descendents)
{
	GeeArrayList* pruned = NULL;
	GeeArrayList* _tmp24_;
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_file_get_type ()));
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (descendents));
	pruned = NULL;
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_file_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GFile* file = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFile* parent = NULL;
			GFile* _tmp9_;
			GFile* _tmp10_;
			_tmp6_ = _file_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _file_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			file = (GFile*) _tmp8_;
			_tmp9_ = file;
			_tmp10_ = g_file_get_parent (_tmp9_);
			parent = _tmp10_;
			while (TRUE) {
				GFile* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp22_;
				GFile* _tmp23_;
				_tmp11_ = parent;
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = parent;
				if (g_file_equal (_tmp12_, root)) {
					GeeArrayList* _tmp13_;
					GeeArrayList* _tmp15_;
					GFile* _tmp16_;
					GFile* _tmp17_;
					GeeHashMap* _tmp18_;
					GFile* _tmp19_;
					gpointer _tmp20_;
					GFileInfo* _tmp21_;
					_tmp13_ = pruned;
					if (_tmp13_ == NULL) {
						GeeArrayList* _tmp14_;
						_tmp14_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (pruned);
						pruned = _tmp14_;
					}
					_tmp15_ = pruned;
					_tmp16_ = file;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
					_tmp17_ = file;
					_tmp18_ = self->priv->map;
					_tmp19_ = file;
					_tmp20_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp19_);
					_tmp21_ = (GFileInfo*) _tmp20_;
					directory_monitor_file_info_map_update (descendents, _tmp17_, _tmp21_);
					_g_object_unref0 (_tmp21_);
					break;
				}
				_tmp22_ = parent;
				_tmp23_ = g_file_get_parent (_tmp22_);
				_g_object_unref0 (parent);
				parent = _tmp23_;
			}
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp24_ = pruned;
	if (_tmp24_ != NULL) {
		GeeArrayList* _tmp25_;
		_tmp25_ = pruned;
		directory_monitor_file_info_map_remove_all (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_g_object_unref0 (pruned);
}

static gint
directory_monitor_file_info_map_get_children (DirectoryMonitorFileInfoMap* self,
                                              GFile* root,
                                              GeeCollection* files,
                                              GeeCollection* dirs)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_file_get_type ()), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (files, GEE_TYPE_COLLECTION), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dirs, GEE_TYPE_COLLECTION), 0);
	count = 0;
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_file_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GFile* file = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFile* parent = NULL;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GFile* _tmp12_;
			DirectoryMonitorFType ftype = 0;
			GeeHashMap* _tmp14_;
			GFile* _tmp15_;
			gpointer _tmp16_;
			GFileInfo* _tmp17_;
			DirectoryMonitorFType _tmp18_;
			_tmp6_ = _file_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _file_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			file = (GFile*) _tmp8_;
			_tmp9_ = file;
			_tmp10_ = g_file_get_parent (_tmp9_);
			parent = _tmp10_;
			_tmp12_ = parent;
			if (_tmp12_ == NULL) {
				_tmp11_ = TRUE;
			} else {
				GFile* _tmp13_;
				_tmp13_ = parent;
				_tmp11_ = !g_file_equal (_tmp13_, root);
			}
			if (_tmp11_) {
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				continue;
			}
			_tmp14_ = self->priv->map;
			_tmp15_ = file;
			_tmp16_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_);
			_tmp17_ = (GFileInfo*) _tmp16_;
			_tmp18_ = directory_monitor_get_ftype (_tmp17_);
			_g_object_unref0 (_tmp17_);
			ftype = _tmp18_;
			switch (ftype) {
				case DIRECTORY_MONITOR_FTYPE_FILE:
				{
					GFile* _tmp19_;
					gint _tmp20_;
					_tmp19_ = file;
					gee_collection_add (files, _tmp19_);
					_tmp20_ = count;
					count = _tmp20_ + 1;
					break;
				}
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
				{
					GFile* _tmp21_;
					gint _tmp22_;
					_tmp21_ = file;
					gee_collection_add (dirs, _tmp21_);
					_tmp22_ = count;
					count = _tmp22_ + 1;
					break;
				}
				default:
				{
					_vala_assert (ftype == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
					break;
				}
			}
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	result = count;
	return result;
}

static void
directory_monitor_value_file_info_map_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
directory_monitor_value_file_info_map_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		directory_monitor_file_info_map_unref (value->data[0].v_pointer);
	}
}

static void
directory_monitor_value_file_info_map_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = directory_monitor_file_info_map_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
directory_monitor_value_file_info_map_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
directory_monitor_value_file_info_map_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DirectoryMonitorFileInfoMap * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = directory_monitor_file_info_map_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
directory_monitor_value_file_info_map_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	DirectoryMonitorFileInfoMap ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = directory_monitor_file_info_map_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
directory_monitor_param_spec_file_info_map (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	DirectoryMonitorParamSpecFileInfoMap* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
directory_monitor_value_get_file_info_map (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP), NULL);
	return value->data[0].v_pointer;
}

static void
directory_monitor_value_set_file_info_map (GValue* value,
                                           gpointer v_object)
{
	DirectoryMonitorFileInfoMap * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		directory_monitor_file_info_map_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		directory_monitor_file_info_map_unref (old);
	}
}

static void
directory_monitor_value_take_file_info_map (GValue* value,
                                            gpointer v_object)
{
	DirectoryMonitorFileInfoMap * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		directory_monitor_file_info_map_unref (old);
	}
}

static void
directory_monitor_file_info_map_class_init (DirectoryMonitorFileInfoMapClass * klass,
                                            gpointer klass_data)
{
	directory_monitor_file_info_map_parent_class = g_type_class_peek_parent (klass);
	((DirectoryMonitorFileInfoMapClass *) klass)->finalize = directory_monitor_file_info_map_finalize;
	g_type_class_adjust_private_offset (klass, &DirectoryMonitorFileInfoMap_private_offset);
}

static void
directory_monitor_file_info_map_instance_init (DirectoryMonitorFileInfoMap * self,
                                               gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = directory_monitor_file_info_map_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->id_map = _tmp1_;
	self->ref_count = 1;
}

static void
directory_monitor_file_info_map_finalize (DirectoryMonitorFileInfoMap * obj)
{
	DirectoryMonitorFileInfoMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMap);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->map);
	_g_object_unref0 (self->priv->id_map);
}

static GType
directory_monitor_file_info_map_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { directory_monitor_value_file_info_map_init, directory_monitor_value_file_info_map_free_value, directory_monitor_value_file_info_map_copy_value, directory_monitor_value_file_info_map_peek_pointer, "p", directory_monitor_value_file_info_map_collect_value, "p", directory_monitor_value_file_info_map_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorFileInfoMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_file_info_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitorFileInfoMap), 0, (GInstanceInitFunc) directory_monitor_file_info_map_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType directory_monitor_file_info_map_type_id;
	directory_monitor_file_info_map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DirectoryMonitorFileInfoMap", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DirectoryMonitorFileInfoMap_private_offset = g_type_add_instance_private (directory_monitor_file_info_map_type_id, sizeof (DirectoryMonitorFileInfoMapPrivate));
	return directory_monitor_file_info_map_type_id;
}

static GType
directory_monitor_file_info_map_get_type (void)
{
	static volatile gsize directory_monitor_file_info_map_type_id__once = 0;
	if (g_once_init_enter (&directory_monitor_file_info_map_type_id__once)) {
		GType directory_monitor_file_info_map_type_id;
		directory_monitor_file_info_map_type_id = directory_monitor_file_info_map_get_type_once ();
		g_once_init_leave (&directory_monitor_file_info_map_type_id__once, directory_monitor_file_info_map_type_id);
	}
	return directory_monitor_file_info_map_type_id__once;
}

static gpointer
directory_monitor_file_info_map_ref (gpointer instance)
{
	DirectoryMonitorFileInfoMap * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
directory_monitor_file_info_map_unref (gpointer instance)
{
	DirectoryMonitorFileInfoMap * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DIRECTORY_MONITOR_FILE_INFO_MAP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
directory_monitor_class_init (DirectoryMonitorClass * klass,
                              gpointer klass_data)
{
	directory_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DirectoryMonitor_private_offset);
	((DirectoryMonitorClass *) klass)->notify_root_deleted = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_root_deleted;
	((DirectoryMonitorClass *) klass)->notify_root_moved = (void (*) (DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_root_moved;
	((DirectoryMonitorClass *) klass)->notify_discovery_started = (void (*) (DirectoryMonitor*)) directory_monitor_real_notify_discovery_started;
	((DirectoryMonitorClass *) klass)->internal_notify_file_discovered = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_internal_notify_file_discovered;
	((DirectoryMonitorClass *) klass)->notify_file_discovered = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_discovered;
	((DirectoryMonitorClass *) klass)->internal_notify_directory_discovered = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_internal_notify_directory_discovered;
	((DirectoryMonitorClass *) klass)->notify_directory_discovered = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_discovered;
	((DirectoryMonitorClass *) klass)->notify_discovery_failed = (void (*) (DirectoryMonitor*, const gchar*)) directory_monitor_real_notify_discovery_failed;
	((DirectoryMonitorClass *) klass)->notify_discovery_completed = (void (*) (DirectoryMonitor*)) directory_monitor_real_notify_discovery_completed;
	((DirectoryMonitorClass *) klass)->notify_file_created = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_created;
	((DirectoryMonitorClass *) klass)->notify_file_moved = (void (*) (DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_moved;
	((DirectoryMonitorClass *) klass)->notify_file_altered = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_altered;
	((DirectoryMonitorClass *) klass)->notify_file_alteration_completed = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_alteration_completed;
	((DirectoryMonitorClass *) klass)->notify_file_attributes_altered = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_attributes_altered;
	((DirectoryMonitorClass *) klass)->notify_file_deleted = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_deleted;
	((DirectoryMonitorClass *) klass)->notify_directory_created = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_created;
	((DirectoryMonitorClass *) klass)->notify_directory_moved = (void (*) (DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_moved;
	((DirectoryMonitorClass *) klass)->notify_directory_altered = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_altered;
	((DirectoryMonitorClass *) klass)->notify_directory_alteration_completed = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_alteration_completed;
	((DirectoryMonitorClass *) klass)->notify_directory_attributes_altered = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_attributes_altered;
	((DirectoryMonitorClass *) klass)->notify_directory_deleted = (void (*) (DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_deleted;
	((DirectoryMonitorClass *) klass)->notify_closed = (void (*) (DirectoryMonitor*)) directory_monitor_real_notify_closed;
	((DirectoryMonitorClass *) klass)->close = (void (*) (DirectoryMonitor*)) directory_monitor_real_close;
	((DirectoryMonitorClass *) klass)->root_moved = directory_monitor_real_root_moved;
	((DirectoryMonitorClass *) klass)->root_deleted = directory_monitor_real_root_deleted;
	((DirectoryMonitorClass *) klass)->discovery_started = directory_monitor_real_discovery_started;
	((DirectoryMonitorClass *) klass)->file_discovered = directory_monitor_real_file_discovered;
	((DirectoryMonitorClass *) klass)->directory_discovered = directory_monitor_real_directory_discovered;
	((DirectoryMonitorClass *) klass)->discovery_failed = directory_monitor_real_discovery_failed;
	((DirectoryMonitorClass *) klass)->discovery_completed = directory_monitor_real_discovery_completed;
	((DirectoryMonitorClass *) klass)->file_created = directory_monitor_real_file_created;
	((DirectoryMonitorClass *) klass)->file_moved = directory_monitor_real_file_moved;
	((DirectoryMonitorClass *) klass)->file_altered = directory_monitor_real_file_altered;
	((DirectoryMonitorClass *) klass)->file_alteration_completed = directory_monitor_real_file_alteration_completed;
	((DirectoryMonitorClass *) klass)->file_attributes_altered = directory_monitor_real_file_attributes_altered;
	((DirectoryMonitorClass *) klass)->file_deleted = directory_monitor_real_file_deleted;
	((DirectoryMonitorClass *) klass)->directory_created = directory_monitor_real_directory_created;
	((DirectoryMonitorClass *) klass)->directory_moved = directory_monitor_real_directory_moved;
	((DirectoryMonitorClass *) klass)->directory_altered = directory_monitor_real_directory_altered;
	((DirectoryMonitorClass *) klass)->directory_alteration_completed = directory_monitor_real_directory_alteration_completed;
	((DirectoryMonitorClass *) klass)->directory_attributes_altered = directory_monitor_real_directory_attributes_altered;
	((DirectoryMonitorClass *) klass)->directory_deleted = directory_monitor_real_directory_deleted;
	((DirectoryMonitorClass *) klass)->closed = directory_monitor_real_closed;
	G_OBJECT_CLASS (klass)->finalize = directory_monitor_finalize;
	directory_monitor_signals[DIRECTORY_MONITOR_ROOT_MOVED_SIGNAL] = g_signal_new ("root-moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, root_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_ROOT_DELETED_SIGNAL] = g_signal_new ("root-deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, root_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DISCOVERY_STARTED_SIGNAL] = g_signal_new ("discovery-started", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_started), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_DISCOVERED_SIGNAL] = g_signal_new ("file-discovered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_discovered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_DISCOVERED_SIGNAL] = g_signal_new ("directory-discovered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_discovered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DISCOVERY_FAILED_SIGNAL] = g_signal_new ("discovery-failed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_failed), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	directory_monitor_signals[DIRECTORY_MONITOR_DISCOVERY_COMPLETED_SIGNAL] = g_signal_new ("discovery-completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_completed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_CREATED_SIGNAL] = g_signal_new ("file-created", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_created), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_MOVED_SIGNAL] = g_signal_new ("file-moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_ALTERED_SIGNAL] = g_signal_new ("file-altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_ALTERATION_COMPLETED_SIGNAL] = g_signal_new ("file-alteration-completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_alteration_completed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_ATTRIBUTES_ALTERED_SIGNAL] = g_signal_new ("file-attributes-altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_attributes_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_FILE_DELETED_SIGNAL] = g_signal_new ("file-deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_CREATED_SIGNAL] = g_signal_new ("directory-created", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_created), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_MOVED_SIGNAL] = g_signal_new ("directory-moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_ALTERED_SIGNAL] = g_signal_new ("directory-altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_ALTERATION_COMPLETED_SIGNAL] = g_signal_new ("directory-alteration-completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_alteration_completed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_ATTRIBUTES_ALTERED_SIGNAL] = g_signal_new ("directory-attributes-altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_attributes_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_DIRECTORY_DELETED_SIGNAL] = g_signal_new ("directory-deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	directory_monitor_signals[DIRECTORY_MONITOR_CLOSED_SIGNAL] = g_signal_new ("closed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, closed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
directory_monitor_instance_init (DirectoryMonitor * self,
                                 gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeLinkedList* _tmp1_;
	DirectoryMonitorFileInfoMap* _tmp2_;
	DirectoryMonitorFileInfoMap* _tmp3_;
	GCancellable* _tmp4_;
	self->priv = directory_monitor_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->monitors = _tmp0_;
	_tmp1_ = gee_linked_list_new (DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, (GBoxedCopyFunc) directory_monitor_query_info_queue_element_ref, (GDestroyNotify) directory_monitor_query_info_queue_element_unref, NULL, NULL, NULL);
	self->priv->query_info_queue = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_QUEUE, GeeQueue);
	_tmp2_ = directory_monitor_file_info_map_new ();
	self->priv->files = _tmp2_;
	_tmp3_ = directory_monitor_file_info_map_new ();
	self->priv->parent_moved = _tmp3_;
	_tmp4_ = g_cancellable_new ();
	self->priv->cancellable = _tmp4_;
	self->priv->outstanding_exploration_dirs = 0;
	self->priv->started = FALSE;
	self->priv->has_discovery_started = FALSE;
	self->priv->delete_timer_id = (guint) 0;
}

static void
directory_monitor_finalize (GObject * obj)
{
	DirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECTORY_MONITOR, DirectoryMonitor);
	_g_object_unref0 (self->priv->root);
	_g_object_unref0 (self->priv->monitors);
	_g_object_unref0 (self->priv->query_info_queue);
	_directory_monitor_file_info_map_unref0 (self->priv->files);
	_directory_monitor_file_info_map_unref0 (self->priv->parent_moved);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (directory_monitor_parent_class)->finalize (obj);
}

static GType
directory_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitor), 0, (GInstanceInitFunc) directory_monitor_instance_init, NULL };
	GType directory_monitor_type_id;
	directory_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "DirectoryMonitor", &g_define_type_info, 0);
	DirectoryMonitor_private_offset = g_type_add_instance_private (directory_monitor_type_id, sizeof (DirectoryMonitorPrivate));
	return directory_monitor_type_id;
}

GType
directory_monitor_get_type (void)
{
	static volatile gsize directory_monitor_type_id__once = 0;
	if (g_once_init_enter (&directory_monitor_type_id__once)) {
		GType directory_monitor_type_id;
		directory_monitor_type_id = directory_monitor_get_type_once ();
		g_once_init_leave (&directory_monitor_type_id__once, directory_monitor_type_id);
	}
	return directory_monitor_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

