/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Mode : # Street modes    - `WALK`   - `BIKE`   - `RENTAL` Experimental. Expect unannounced breaking changes (without version bumps) for all parameters and returned structs.   - `CAR`   - `CAR_PARKING` Experimental. Expect unannounced breaking changes (without version bumps) for all parameters and returned structs.   - `CAR_DROPOFF` Experimental. Expect unannounced breaking changes (without version bumps) for all perameters and returned structs.   - `ODM` on-demand taxis from the Prima+ÖV Project   - `RIDE_SHARING` ride sharing from the Prima+ÖV Project   - `FLEX` flexible transports  # Transit modes    - `TRANSIT`: translates to `RAIL,TRAM,BUS,FERRY,AIRPLANE,COACH,CABLE_CAR,FUNICULAR,AREAL_LIFT,OTHER`   - `TRAM`: trams   - `SUBWAY`: subway trains (Paris Metro, London Underground, but also NYC Subway, Hamburger Hochbahn, and other non-underground services)   - `FERRY`: ferries   - `AIRPLANE`: airline flights   - `BUS`: short distance buses (does not include `COACH`)   - `COACH`: long distance buses (does not include `BUS`)   - `RAIL`: translates to `HIGHSPEED_RAIL,LONG_DISTANCE,NIGHT_RAIL,REGIONAL_RAIL,REGIONAL_FAST_RAIL,SUBURBAN,SUBWAY`   - `SUBURBAN`: suburban trains (e.g. S-Bahn, RER, Elizabeth Line, ...)   - `HIGHSPEED_RAIL`: long distance high speed trains (e.g. TGV)   - `LONG_DISTANCE`: long distance inter city trains   - `NIGHT_RAIL`: long distance night trains   - `REGIONAL_FAST_RAIL`: regional express routes that skip low traffic stops to be faster   - `REGIONAL_RAIL`: regional train   - `CABLE_CAR`: Cable tram. Used for street-level rail cars where the cable runs beneath the vehicle (e.g., cable car in San Francisco).   - `FUNICULAR`: Funicular. Any rail system designed for steep inclines.   - `AERIAL_LIFT`: Aerial lift, suspended cable car (e.g., gondola lift, aerial tramway). Cable transport where cabins, cars, gondolas or open chairs are suspended by means of one or more cables.   - `AREAL_LIFT`: deprecated   - `METRO`: deprecated 
/// # Street modes    - `WALK`   - `BIKE`   - `RENTAL` Experimental. Expect unannounced breaking changes (without version bumps) for all parameters and returned structs.   - `CAR`   - `CAR_PARKING` Experimental. Expect unannounced breaking changes (without version bumps) for all parameters and returned structs.   - `CAR_DROPOFF` Experimental. Expect unannounced breaking changes (without version bumps) for all perameters and returned structs.   - `ODM` on-demand taxis from the Prima+ÖV Project   - `RIDE_SHARING` ride sharing from the Prima+ÖV Project   - `FLEX` flexible transports  # Transit modes    - `TRANSIT`: translates to `RAIL,TRAM,BUS,FERRY,AIRPLANE,COACH,CABLE_CAR,FUNICULAR,AREAL_LIFT,OTHER`   - `TRAM`: trams   - `SUBWAY`: subway trains (Paris Metro, London Underground, but also NYC Subway, Hamburger Hochbahn, and other non-underground services)   - `FERRY`: ferries   - `AIRPLANE`: airline flights   - `BUS`: short distance buses (does not include `COACH`)   - `COACH`: long distance buses (does not include `BUS`)   - `RAIL`: translates to `HIGHSPEED_RAIL,LONG_DISTANCE,NIGHT_RAIL,REGIONAL_RAIL,REGIONAL_FAST_RAIL,SUBURBAN,SUBWAY`   - `SUBURBAN`: suburban trains (e.g. S-Bahn, RER, Elizabeth Line, ...)   - `HIGHSPEED_RAIL`: long distance high speed trains (e.g. TGV)   - `LONG_DISTANCE`: long distance inter city trains   - `NIGHT_RAIL`: long distance night trains   - `REGIONAL_FAST_RAIL`: regional express routes that skip low traffic stops to be faster   - `REGIONAL_RAIL`: regional train   - `CABLE_CAR`: Cable tram. Used for street-level rail cars where the cable runs beneath the vehicle (e.g., cable car in San Francisco).   - `FUNICULAR`: Funicular. Any rail system designed for steep inclines.   - `AERIAL_LIFT`: Aerial lift, suspended cable car (e.g., gondola lift, aerial tramway). Cable transport where cabins, cars, gondolas or open chairs are suspended by means of one or more cables.   - `AREAL_LIFT`: deprecated   - `METRO`: deprecated 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Mode {
    #[serde(rename = "WALK")]
    Walk,
    #[serde(rename = "BIKE")]
    Bike,
    #[serde(rename = "RENTAL")]
    Rental,
    #[serde(rename = "CAR")]
    Car,
    #[serde(rename = "CAR_PARKING")]
    CarParking,
    #[serde(rename = "CAR_DROPOFF")]
    CarDropoff,
    #[serde(rename = "ODM")]
    Odm,
    #[serde(rename = "RIDE_SHARING")]
    RideSharing,
    #[serde(rename = "FLEX")]
    Flex,
    #[serde(rename = "TRANSIT")]
    Transit,
    #[serde(rename = "TRAM")]
    Tram,
    #[serde(rename = "SUBWAY")]
    Subway,
    #[serde(rename = "FERRY")]
    Ferry,
    #[serde(rename = "AIRPLANE")]
    Airplane,
    #[serde(rename = "SUBURBAN")]
    Suburban,
    #[serde(rename = "BUS")]
    Bus,
    #[serde(rename = "COACH")]
    Coach,
    #[serde(rename = "RAIL")]
    Rail,
    #[serde(rename = "HIGHSPEED_RAIL")]
    HighspeedRail,
    #[serde(rename = "LONG_DISTANCE")]
    LongDistance,
    #[serde(rename = "NIGHT_RAIL")]
    NightRail,
    #[serde(rename = "REGIONAL_FAST_RAIL")]
    RegionalFastRail,
    #[serde(rename = "REGIONAL_RAIL")]
    RegionalRail,
    #[serde(rename = "CABLE_CAR")]
    CableCar,
    #[serde(rename = "FUNICULAR")]
    Funicular,
    #[serde(rename = "AERIAL_LIFT")]
    AerialLift,
    #[serde(rename = "OTHER")]
    Other,
    #[serde(rename = "AREAL_LIFT")]
    ArealLift,
    #[serde(rename = "METRO")]
    Metro,

}

impl std::fmt::Display for Mode {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::Walk => write!(f, "WALK"),
            Self::Bike => write!(f, "BIKE"),
            Self::Rental => write!(f, "RENTAL"),
            Self::Car => write!(f, "CAR"),
            Self::CarParking => write!(f, "CAR_PARKING"),
            Self::CarDropoff => write!(f, "CAR_DROPOFF"),
            Self::Odm => write!(f, "ODM"),
            Self::RideSharing => write!(f, "RIDE_SHARING"),
            Self::Flex => write!(f, "FLEX"),
            Self::Transit => write!(f, "TRANSIT"),
            Self::Tram => write!(f, "TRAM"),
            Self::Subway => write!(f, "SUBWAY"),
            Self::Ferry => write!(f, "FERRY"),
            Self::Airplane => write!(f, "AIRPLANE"),
            Self::Suburban => write!(f, "SUBURBAN"),
            Self::Bus => write!(f, "BUS"),
            Self::Coach => write!(f, "COACH"),
            Self::Rail => write!(f, "RAIL"),
            Self::HighspeedRail => write!(f, "HIGHSPEED_RAIL"),
            Self::LongDistance => write!(f, "LONG_DISTANCE"),
            Self::NightRail => write!(f, "NIGHT_RAIL"),
            Self::RegionalFastRail => write!(f, "REGIONAL_FAST_RAIL"),
            Self::RegionalRail => write!(f, "REGIONAL_RAIL"),
            Self::CableCar => write!(f, "CABLE_CAR"),
            Self::Funicular => write!(f, "FUNICULAR"),
            Self::AerialLift => write!(f, "AERIAL_LIFT"),
            Self::Other => write!(f, "OTHER"),
            Self::ArealLift => write!(f, "AREAL_LIFT"),
            Self::Metro => write!(f, "METRO"),
        }
    }
}

impl Default for Mode {
    fn default() -> Mode {
        Self::Walk
    }
}

