// third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_POLICY_VALUE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_POLICY_VALUE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink::mojom {
class PolicyValueDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PolicyValueDataView> {
  using Data = ::blink::mojom::internal::PolicyValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PolicyValueType : int32_t {
  
  kNull = 0,
  
  kBool = 1,
  
  kDecDouble = 2,
  
  kEnum = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PolicyValueType value);
inline bool IsKnownEnumValue(PolicyValueType value) {
  return internal::PolicyValueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PolicyValueDataView {
 public:
  using Tag = internal::PolicyValue_Data::PolicyValue_Tag;

  PolicyValueDataView() = default;

  PolicyValueDataView(
      internal::PolicyValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_null_value() const { return data_->tag == Tag::kNullValue; }
  bool null_value() const {
    CHECK(is_null_value());
    return data_->data.f_null_value;
  }
  bool is_bool_value() const { return data_->tag == Tag::kBoolValue; }
  bool bool_value() const {
    CHECK(is_bool_value());
    return data_->data.f_bool_value;
  }
  bool is_dec_double_value() const { return data_->tag == Tag::kDecDoubleValue; }
  double dec_double_value() const {
    CHECK(is_dec_double_value());
    return data_->data.f_dec_double_value;
  }
  bool is_enum_value() const { return data_->tag == Tag::kEnumValue; }
  int32_t enum_value() const {
    CHECK(is_enum_value());
    return data_->data.f_enum_value;
  }

 private:
  internal::PolicyValue_Data* data_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::PolicyValueType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PolicyValueType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyValueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PolicyValueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PolicyValueType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PolicyValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PolicyValue_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PolicyValueDataView::Tag::kNullValue: {
        decltype(Traits::null_value(input))
            in_null_value = Traits::null_value(input);
        fragment->data.f_null_value = in_null_value;
        break;
      }
      case ::blink::mojom::PolicyValueDataView::Tag::kBoolValue: {
        decltype(Traits::bool_value(input))
            in_bool_value = Traits::bool_value(input);
        fragment->data.f_bool_value = in_bool_value;
        break;
      }
      case ::blink::mojom::PolicyValueDataView::Tag::kDecDoubleValue: {
        decltype(Traits::dec_double_value(input))
            in_dec_double_value = Traits::dec_double_value(input);
        fragment->data.f_dec_double_value = in_dec_double_value;
        break;
      }
      case ::blink::mojom::PolicyValueDataView::Tag::kEnumValue: {
        decltype(Traits::enum_value(input))
            in_enum_value = Traits::enum_value(input);
        fragment->data.f_enum_value = in_enum_value;
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PolicyValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PolicyValueType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PolicyValueType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_POLICY_VALUE_MOJOM_SHARED_H_