// third_party/blink/public/mojom/context_menu/context_menu.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/forms/form_control_type.mojom-shared.h"
#include "ui/base/mojom/menu_source_type.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class AcceleratorDataView;

class FormRendererIdDataView;

class FieldRendererIdDataView;

class CustomContextMenuItemDataView;

class UntrustworthyContextMenuParamsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AcceleratorDataView> {
  using Data = ::blink::mojom::internal::Accelerator_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FormRendererIdDataView> {
  using Data = ::blink::mojom::internal::FormRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FieldRendererIdDataView> {
  using Data = ::blink::mojom::internal::FieldRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CustomContextMenuItemDataView> {
  using Data = ::blink::mojom::internal::CustomContextMenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::UntrustworthyContextMenuParamsDataView> {
  using Data = ::blink::mojom::internal::UntrustworthyContextMenuParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ContextMenuDataMediaType : int32_t {
  
  kNone = 0,
  
  kImage = 1,
  
  kVideo = 2,
  
  kAudio = 3,
  
  kCanvas = 4,
  
  kFile = 5,
  
  kPlugin = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ContextMenuDataMediaType value);
inline bool IsKnownEnumValue(ContextMenuDataMediaType value) {
  return internal::ContextMenuDataMediaType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CustomContextMenuItemType : int32_t {
  
  kOption = 0,
  
  kCheckableOption = 1,
  
  kGroup = 2,
  
  kSeparator = 3,
  
  kSubMenu = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CustomContextMenuItemType value);
inline bool IsKnownEnumValue(CustomContextMenuItemType value) {
  return internal::CustomContextMenuItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ContextMenuClientInterfaceBase {};

using ContextMenuClientPtrDataView =
    mojo::InterfacePtrDataView<ContextMenuClientInterfaceBase>;
using ContextMenuClientRequestDataView =
    mojo::InterfaceRequestDataView<ContextMenuClientInterfaceBase>;
using ContextMenuClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContextMenuClientInterfaceBase>;
using ContextMenuClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContextMenuClientInterfaceBase>;


class AcceleratorDataView {
 public:
  AcceleratorDataView() = default;

  AcceleratorDataView(
      internal::Accelerator_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t key_code() const {
    return data_->key_code;
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
 private:
  internal::Accelerator_Data* data_ = nullptr;
};


class FormRendererIdDataView {
 public:
  FormRendererIdDataView() = default;

  FormRendererIdDataView(
      internal::FormRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FormRendererId_Data* data_ = nullptr;
};


class FieldRendererIdDataView {
 public:
  FieldRendererIdDataView() = default;

  FieldRendererIdDataView(
      internal::FieldRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FieldRendererId_Data* data_ = nullptr;
};


class CustomContextMenuItemDataView {
 public:
  CustomContextMenuItemDataView() = default;

  CustomContextMenuItemDataView(
      internal::CustomContextMenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAcceleratorDataView(
      AcceleratorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccelerator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AcceleratorDataView, UserType>(),
    "Attempting to read the optional `accelerator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAccelerator` instead "
    "of `ReadAccelerator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->accelerator.Get();
    return mojo::internal::Deserialize<::blink::mojom::AcceleratorDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetToolTipDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToolTip(UserType* output) {
    
    auto* pointer = data_->tool_tip.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::CustomContextMenuItemType>(
        data_value, output);
  }
  CustomContextMenuItemType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CustomContextMenuItemType>(data_->type));
  }
  int32_t action() const {
    return data_->action;
  }
  bool is_experimental_feature() const {
    return data_->is_experimental_feature;
  }
  bool rtl() const {
    return data_->rtl;
  }
  bool has_directional_override() const {
    return data_->has_directional_override;
  }
  bool enabled() const {
    return data_->enabled;
  }
  bool checked() const {
    return data_->checked;
  }
  bool force_show_accelerator_for_item() const {
    return data_->force_show_accelerator_for_item;
  }
  inline void GetSubmenuDataView(
      mojo::ArrayDataView<CustomContextMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmenu(UserType* output) {
    
    auto* pointer = data_->submenu.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CustomContextMenuItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CustomContextMenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UntrustworthyContextMenuParamsDataView {
 public:
  UntrustworthyContextMenuParamsDataView() = default;

  UntrustworthyContextMenuParamsDataView(
      internal::UntrustworthyContextMenuParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMediaType(UserType* output) const {
    auto data_value = data_->media_type;
    return mojo::internal::Deserialize<::blink::mojom::ContextMenuDataMediaType>(
        data_value, output);
  }
  ContextMenuDataMediaType media_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ContextMenuDataMediaType>(data_->media_type));
  }
  int32_t x() const {
    return data_->x;
  }
  int32_t y() const {
    return data_->y;
  }
  inline void GetLinkUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkUrl(UserType* output) {
    
    auto* pointer = data_->link_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLinkTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkText(UserType* output) {
    
    auto* pointer = data_->link_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetUnfilteredLinkUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnfilteredLinkUrl(UserType* output) {
    
    auto* pointer = data_->unfiltered_link_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSrcUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcUrl(UserType* output) {
    
    auto* pointer = data_->src_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool has_image_contents() const {
    return data_->has_image_contents;
  }
  bool is_image_media_plugin_document() const {
    return data_->is_image_media_plugin_document;
  }
  int32_t media_flags() const {
    return data_->media_flags;
  }
  inline void GetSelectionTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionText(UserType* output) {
    
    auto* pointer = data_->selection_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTitleTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitleText(UserType* output) {
    
    auto* pointer = data_->title_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAltTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAltText(UserType* output) {
    
    auto* pointer = data_->alt_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSuggestedFilenameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestedFilename(UserType* output) {
    
    auto* pointer = data_->suggested_filename.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetMisspelledWordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMisspelledWord(UserType* output) {
    
    auto* pointer = data_->misspelled_word.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDictionarySuggestionsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDictionarySuggestions(UserType* output) {
    
    auto* pointer = data_->dictionary_suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  bool spellcheck_enabled() const {
    return data_->spellcheck_enabled;
  }
  bool is_editable() const {
    return data_->is_editable;
  }
  int32_t writing_direction_default() const {
    return data_->writing_direction_default;
  }
  int32_t writing_direction_left_to_right() const {
    return data_->writing_direction_left_to_right;
  }
  int32_t writing_direction_right_to_left() const {
    return data_->writing_direction_right_to_left;
  }
  int32_t edit_flags() const {
    return data_->edit_flags;
  }
  inline void GetFrameCharsetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameCharset(UserType* output) {
    
    auto* pointer = data_->frame_charset.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetLinkFollowedDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkFollowed(UserType* output) {
    
    auto* pointer = data_->link_followed.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCustomItemsDataView(
      mojo::ArrayDataView<CustomContextMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomItems(UserType* output) {
    
    auto* pointer = data_->custom_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CustomContextMenuItemDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceType(UserType* output) const {
    auto data_value = data_->source_type;
    return mojo::internal::Deserialize<::ui::mojom::MenuSourceType>(
        data_value, output);
  }
  ::ui::mojom::MenuSourceType source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::MenuSourceType>(data_->source_type));
  }
  inline void GetSelectionRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionRect(UserType* output) {
    
    auto* pointer = data_->selection_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  int32_t selection_start_offset() const {
    return data_->selection_start_offset;
  }
  bool opened_from_highlight() const {
    return data_->opened_from_highlight;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormControlType(UserType* output) const {
    if (!data_->form_control_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::FormControlType>(
        data_->form_control_type_$value, &output->emplace());
  }
  std::optional<::blink::mojom::FormControlType> form_control_type() const {
    if (!data_->form_control_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FormControlType>(data_->form_control_type_$value));
  }
  bool is_content_editable_for_autofill() const {
    return data_->is_content_editable_for_autofill;
  }
  inline void GetFieldRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldRendererId(UserType* output) {
    
    auto* pointer = data_->field_renderer_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetFormRendererIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormRendererId(UserType* output) {
    
    auto* pointer = data_->form_renderer_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::UntrustworthyContextMenuParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::ContextMenuDataMediaType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ContextMenuDataMediaType> {};

template <>
struct hash<::blink::mojom::CustomContextMenuItemType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CustomContextMenuItemType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContextMenuDataMediaType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ContextMenuDataMediaType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ContextMenuDataMediaType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CustomContextMenuItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CustomContextMenuItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CustomContextMenuItemType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AcceleratorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AcceleratorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::Accelerator_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->key_code = Traits::key_code(input);
    fragment->modifiers = Traits::modifiers(input);
  }

  static bool Deserialize(::blink::mojom::internal::Accelerator_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AcceleratorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FormRendererIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FormRendererIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FormRendererId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::blink::mojom::internal::FormRendererId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FormRendererIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FieldRendererIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FieldRendererIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FieldRendererId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::blink::mojom::internal::FieldRendererId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FieldRendererIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CustomContextMenuItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CustomContextMenuItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CustomContextMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in CustomContextMenuItem struct");
    decltype(Traits::accelerator(input)) in_accelerator = Traits::accelerator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accelerator)::BaseType> accelerator_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AcceleratorDataView>(
        in_accelerator, accelerator_fragment);
    fragment->accelerator.Set(
        accelerator_fragment.is_null() ? nullptr : accelerator_fragment.data());
    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_icon, icon_fragment);
    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icon.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon in CustomContextMenuItem struct");
    decltype(Traits::tool_tip(input)) in_tool_tip = Traits::tool_tip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tool_tip)::BaseType> tool_tip_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_tool_tip, tool_tip_fragment);
    fragment->tool_tip.Set(
        tool_tip_fragment.is_null() ? nullptr : tool_tip_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tool_tip.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tool_tip in CustomContextMenuItem struct");
    mojo::internal::Serialize<::blink::mojom::CustomContextMenuItemType>(
        Traits::type(input), &fragment->type);
    fragment->action = Traits::action(input);
    fragment->is_experimental_feature = Traits::is_experimental_feature(input);
    fragment->rtl = Traits::rtl(input);
    fragment->has_directional_override = Traits::has_directional_override(input);
    fragment->enabled = Traits::enabled(input);
    fragment->checked = Traits::checked(input);
    fragment->force_show_accelerator_for_item = Traits::force_show_accelerator_for_item(input);
    decltype(Traits::submenu(input)) in_submenu = Traits::submenu(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->submenu)::BaseType>
        submenu_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& submenu_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CustomContextMenuItemDataView>>(
        in_submenu, submenu_fragment, &submenu_validate_params);
    fragment->submenu.Set(
        submenu_fragment.is_null() ? nullptr : submenu_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->submenu.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null submenu in CustomContextMenuItem struct");
  }

  static bool Deserialize(::blink::mojom::internal::CustomContextMenuItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CustomContextMenuItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UntrustworthyContextMenuParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::UntrustworthyContextMenuParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::UntrustworthyContextMenuParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::ContextMenuDataMediaType>(
        Traits::media_type(input), &fragment->media_type);
    fragment->x = Traits::x(input);
    fragment->y = Traits::y(input);
    decltype(Traits::link_url(input)) in_link_url = Traits::link_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link_url)::BaseType> link_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_link_url, link_url_fragment);
    fragment->link_url.Set(
        link_url_fragment.is_null() ? nullptr : link_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->link_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null link_url in UntrustworthyContextMenuParams struct");
    decltype(Traits::link_text(input)) in_link_text = Traits::link_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link_text)::BaseType> link_text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_link_text, link_text_fragment);
    fragment->link_text.Set(
        link_text_fragment.is_null() ? nullptr : link_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->link_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null link_text in UntrustworthyContextMenuParams struct");
    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->impression)::BaseType> impression_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
        in_impression, impression_fragment);
    fragment->impression.Set(
        impression_fragment.is_null() ? nullptr : impression_fragment.data());
    decltype(Traits::unfiltered_link_url(input)) in_unfiltered_link_url = Traits::unfiltered_link_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unfiltered_link_url)::BaseType> unfiltered_link_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_unfiltered_link_url, unfiltered_link_url_fragment);
    fragment->unfiltered_link_url.Set(
        unfiltered_link_url_fragment.is_null() ? nullptr : unfiltered_link_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->unfiltered_link_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null unfiltered_link_url in UntrustworthyContextMenuParams struct");
    decltype(Traits::src_url(input)) in_src_url = Traits::src_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src_url)::BaseType> src_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_src_url, src_url_fragment);
    fragment->src_url.Set(
        src_url_fragment.is_null() ? nullptr : src_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->src_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null src_url in UntrustworthyContextMenuParams struct");
    fragment->has_image_contents = Traits::has_image_contents(input);
    fragment->is_image_media_plugin_document = Traits::is_image_media_plugin_document(input);
    fragment->media_flags = Traits::media_flags(input);
    decltype(Traits::selection_text(input)) in_selection_text = Traits::selection_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection_text)::BaseType> selection_text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_selection_text, selection_text_fragment);
    fragment->selection_text.Set(
        selection_text_fragment.is_null() ? nullptr : selection_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->selection_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection_text in UntrustworthyContextMenuParams struct");
    decltype(Traits::title_text(input)) in_title_text = Traits::title_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title_text)::BaseType> title_text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title_text, title_text_fragment);
    fragment->title_text.Set(
        title_text_fragment.is_null() ? nullptr : title_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title_text in UntrustworthyContextMenuParams struct");
    decltype(Traits::alt_text(input)) in_alt_text = Traits::alt_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alt_text)::BaseType> alt_text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_alt_text, alt_text_fragment);
    fragment->alt_text.Set(
        alt_text_fragment.is_null() ? nullptr : alt_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->alt_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alt_text in UntrustworthyContextMenuParams struct");
    decltype(Traits::suggested_filename(input)) in_suggested_filename = Traits::suggested_filename(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggested_filename)::BaseType> suggested_filename_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_suggested_filename, suggested_filename_fragment);
    fragment->suggested_filename.Set(
        suggested_filename_fragment.is_null() ? nullptr : suggested_filename_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->suggested_filename.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggested_filename in UntrustworthyContextMenuParams struct");
    decltype(Traits::misspelled_word(input)) in_misspelled_word = Traits::misspelled_word(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->misspelled_word)::BaseType> misspelled_word_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_misspelled_word, misspelled_word_fragment);
    fragment->misspelled_word.Set(
        misspelled_word_fragment.is_null() ? nullptr : misspelled_word_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->misspelled_word.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null misspelled_word in UntrustworthyContextMenuParams struct");
    decltype(Traits::dictionary_suggestions(input)) in_dictionary_suggestions = Traits::dictionary_suggestions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dictionary_suggestions)::BaseType>
        dictionary_suggestions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dictionary_suggestions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        in_dictionary_suggestions, dictionary_suggestions_fragment, &dictionary_suggestions_validate_params);
    fragment->dictionary_suggestions.Set(
        dictionary_suggestions_fragment.is_null() ? nullptr : dictionary_suggestions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->dictionary_suggestions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dictionary_suggestions in UntrustworthyContextMenuParams struct");
    fragment->spellcheck_enabled = Traits::spellcheck_enabled(input);
    fragment->is_editable = Traits::is_editable(input);
    fragment->writing_direction_default = Traits::writing_direction_default(input);
    fragment->writing_direction_left_to_right = Traits::writing_direction_left_to_right(input);
    fragment->writing_direction_right_to_left = Traits::writing_direction_right_to_left(input);
    fragment->edit_flags = Traits::edit_flags(input);
    decltype(Traits::frame_charset(input)) in_frame_charset = Traits::frame_charset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_charset)::BaseType> frame_charset_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_frame_charset, frame_charset_fragment);
    fragment->frame_charset.Set(
        frame_charset_fragment.is_null() ? nullptr : frame_charset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_charset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_charset in UntrustworthyContextMenuParams struct");
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input), &fragment->referrer_policy);
    decltype(Traits::link_followed(input)) in_link_followed = Traits::link_followed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link_followed)::BaseType> link_followed_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_link_followed, link_followed_fragment);
    fragment->link_followed.Set(
        link_followed_fragment.is_null() ? nullptr : link_followed_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->link_followed.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null link_followed in UntrustworthyContextMenuParams struct");
    decltype(Traits::custom_items(input)) in_custom_items = Traits::custom_items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->custom_items)::BaseType>
        custom_items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& custom_items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CustomContextMenuItemDataView>>(
        in_custom_items, custom_items_fragment, &custom_items_validate_params);
    fragment->custom_items.Set(
        custom_items_fragment.is_null() ? nullptr : custom_items_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->custom_items.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null custom_items in UntrustworthyContextMenuParams struct");
    mojo::internal::Serialize<::ui::mojom::MenuSourceType>(
        Traits::source_type(input), &fragment->source_type);
    decltype(Traits::selection_rect(input)) in_selection_rect = Traits::selection_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection_rect)::BaseType> selection_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_selection_rect, selection_rect_fragment);
    fragment->selection_rect.Set(
        selection_rect_fragment.is_null() ? nullptr : selection_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->selection_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection_rect in UntrustworthyContextMenuParams struct");
    fragment->selection_start_offset = Traits::selection_start_offset(input);
    fragment->opened_from_highlight = Traits::opened_from_highlight(input);
    fragment->form_control_type_$flag = Traits::form_control_type(input).has_value();
    if (Traits::form_control_type(input).has_value()) {
      mojo::internal::Serialize<::blink::mojom::FormControlType>(
          Traits::form_control_type(input).value(), &fragment->form_control_type_$value);
    } else {
      fragment->form_control_type_$value =
          static_cast<int32_t>(::blink::mojom::FormControlType::kMinValue);
    }
    fragment->is_content_editable_for_autofill = Traits::is_content_editable_for_autofill(input);
    decltype(Traits::field_renderer_id(input)) in_field_renderer_id = Traits::field_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->field_renderer_id)::BaseType> field_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FieldRendererIdDataView>(
        in_field_renderer_id, field_renderer_id_fragment);
    fragment->field_renderer_id.Set(
        field_renderer_id_fragment.is_null() ? nullptr : field_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->field_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_renderer_id in UntrustworthyContextMenuParams struct");
    decltype(Traits::form_renderer_id(input)) in_form_renderer_id = Traits::form_renderer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_renderer_id)::BaseType> form_renderer_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FormRendererIdDataView>(
        in_form_renderer_id, form_renderer_id_fragment);
    fragment->form_renderer_id.Set(
        form_renderer_id_fragment.is_null() ? nullptr : form_renderer_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->form_renderer_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_renderer_id in UntrustworthyContextMenuParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::UntrustworthyContextMenuParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UntrustworthyContextMenuParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {







inline void CustomContextMenuItemDataView::GetLabelDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->label.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void CustomContextMenuItemDataView::GetAcceleratorDataView(
    AcceleratorDataView* output) {
  auto pointer = data_->accelerator.Get();
  *output = AcceleratorDataView(pointer, message_);
}
inline void CustomContextMenuItemDataView::GetIconDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void CustomContextMenuItemDataView::GetToolTipDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->tool_tip.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void CustomContextMenuItemDataView::GetSubmenuDataView(
    mojo::ArrayDataView<CustomContextMenuItemDataView>* output) {
  auto pointer = data_->submenu.Get();
  *output = mojo::ArrayDataView<CustomContextMenuItemDataView>(pointer, message_);
}


inline void UntrustworthyContextMenuParamsDataView::GetLinkUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->link_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetLinkTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->link_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetImpressionDataView(
    ::blink::mojom::ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ::blink::mojom::ImpressionDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetUnfilteredLinkUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->unfiltered_link_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetSrcUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetSelectionTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->selection_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetTitleTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetAltTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->alt_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetSuggestedFilenameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->suggested_filename.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetMisspelledWordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->misspelled_word.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetDictionarySuggestionsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->dictionary_suggestions.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetFrameCharsetDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_charset.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetLinkFollowedDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->link_followed.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetCustomItemsDataView(
    mojo::ArrayDataView<CustomContextMenuItemDataView>* output) {
  auto pointer = data_->custom_items.Get();
  *output = mojo::ArrayDataView<CustomContextMenuItemDataView>(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetSelectionRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->selection_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetFieldRendererIdDataView(
    FieldRendererIdDataView* output) {
  auto pointer = data_->field_renderer_id.Get();
  *output = FieldRendererIdDataView(pointer, message_);
}
inline void UntrustworthyContextMenuParamsDataView::GetFormRendererIdDataView(
    FormRendererIdDataView* output) {
  auto pointer = data_->form_renderer_id.Get();
  *output = FormRendererIdDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ContextMenuDataMediaType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ContextMenuDataMediaType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CustomContextMenuItemType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CustomContextMenuItemType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_SHARED_H_