// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-test-utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"


namespace viz::mojom {
CompositorFrameMetadata::CompositorFrameMetadata()
    : device_scale_factor(),
      root_scroll_offset(),
      page_scale_factor(),
      scrollable_viewport_size(),
      visible_viewport_size(),
      content_color_usage(),
      may_contain_video(),
      may_throttle_if_undrawn_frames(),
      is_handling_interaction(),
      is_handling_animation(),
      root_background_color(),
      latency_info(),
      referenced_surfaces(),
      deadline(),
      activation_dependencies(),
      begin_frame_ack(),
      frame_token(),
      send_frame_token_to_embedder(),
      top_controls_visible_height_set(),
      top_controls_visible_height(),
      min_page_scale_factor(),
      display_transform_hint(),
      delegated_ink_metadata(),
      transition_directives(),
      capture_bounds(),
      has_shared_element_resources(),
      screenshot_destination(),
      is_software(),
      offset_tag_definitions(),
      offset_tag_values(),
      frame_interval_inputs() {}

CompositorFrameMetadata::CompositorFrameMetadata(
    float device_scale_factor_in,
    const ::gfx::PointF& root_scroll_offset_in,
    float page_scale_factor_in,
    const ::gfx::SizeF& scrollable_viewport_size_in,
    const ::gfx::Size& visible_viewport_size_in,
    ::gfx::ContentColorUsage content_color_usage_in,
    bool may_contain_video_in,
    bool may_throttle_if_undrawn_frames_in,
    bool is_handling_interaction_in,
    bool is_handling_animation_in,
    const ::SkColor4f& root_background_color_in,
    std::vector<::ui::LatencyInfo> latency_info_in,
    std::vector<::viz::SurfaceRange> referenced_surfaces_in,
    const ::viz::FrameDeadline& deadline_in,
    std::vector<::viz::SurfaceId> activation_dependencies_in,
    const ::viz::BeginFrameAck& begin_frame_ack_in,
    uint32_t frame_token_in,
    bool send_frame_token_to_embedder_in,
    bool top_controls_visible_height_set_in,
    float top_controls_visible_height_in,
    float min_page_scale_factor_in,
    ::gfx::OverlayTransform display_transform_hint_in,
    ::std::unique_ptr<::gfx::DelegatedInkMetadata> delegated_ink_metadata_in,
    std::vector<::viz::CompositorFrameTransitionDirective> transition_directives_in,
    const ::viz::RegionCaptureBounds& capture_bounds_in,
    bool has_shared_element_resources_in,
    const std::optional<::blink::SameDocNavigationScreenshotDestinationToken>& screenshot_destination_in,
    bool is_software_in,
    std::vector<::viz::mojom::OffsetTagDefinitionPtr> offset_tag_definitions_in,
    std::vector<::viz::OffsetTagValue> offset_tag_values_in,
    const ::viz::FrameIntervalInputs& frame_interval_inputs_in)
    : device_scale_factor(std::move(device_scale_factor_in)),
      root_scroll_offset(std::move(root_scroll_offset_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      scrollable_viewport_size(std::move(scrollable_viewport_size_in)),
      visible_viewport_size(std::move(visible_viewport_size_in)),
      content_color_usage(std::move(content_color_usage_in)),
      may_contain_video(std::move(may_contain_video_in)),
      may_throttle_if_undrawn_frames(std::move(may_throttle_if_undrawn_frames_in)),
      is_handling_interaction(std::move(is_handling_interaction_in)),
      is_handling_animation(std::move(is_handling_animation_in)),
      root_background_color(std::move(root_background_color_in)),
      latency_info(std::move(latency_info_in)),
      referenced_surfaces(std::move(referenced_surfaces_in)),
      deadline(std::move(deadline_in)),
      activation_dependencies(std::move(activation_dependencies_in)),
      begin_frame_ack(std::move(begin_frame_ack_in)),
      frame_token(std::move(frame_token_in)),
      send_frame_token_to_embedder(std::move(send_frame_token_to_embedder_in)),
      top_controls_visible_height_set(std::move(top_controls_visible_height_set_in)),
      top_controls_visible_height(std::move(top_controls_visible_height_in)),
      min_page_scale_factor(std::move(min_page_scale_factor_in)),
      display_transform_hint(std::move(display_transform_hint_in)),
      delegated_ink_metadata(std::move(delegated_ink_metadata_in)),
      transition_directives(std::move(transition_directives_in)),
      capture_bounds(std::move(capture_bounds_in)),
      has_shared_element_resources(std::move(has_shared_element_resources_in)),
      screenshot_destination(std::move(screenshot_destination_in)),
      is_software(std::move(is_software_in)),
      offset_tag_definitions(std::move(offset_tag_definitions_in)),
      offset_tag_values(std::move(offset_tag_values_in)),
      frame_interval_inputs(std::move(frame_interval_inputs_in)) {}

CompositorFrameMetadata::~CompositorFrameMetadata() = default;

void CompositorFrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset"), this->root_scroll_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollable_viewport_size"), this->scrollable_viewport_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::SizeF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_viewport_size"), this->visible_viewport_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_color_usage"), this->content_color_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ContentColorUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_contain_video"), this->may_contain_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_throttle_if_undrawn_frames"), this->may_throttle_if_undrawn_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_handling_interaction"), this->is_handling_interaction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_handling_animation"), this->is_handling_animation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_background_color"), this->root_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency_info"), this->latency_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::LatencyInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referenced_surfaces"), this->referenced_surfaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::viz::SurfaceRange>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deadline"), this->deadline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameDeadline&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_dependencies"), this->activation_dependencies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::viz::SurfaceId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_frame_ack"), this->begin_frame_ack,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::BeginFrameAck&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_token"), this->frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_frame_token_to_embedder"), this->send_frame_token_to_embedder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height_set"), this->top_controls_visible_height_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height"), this->top_controls_visible_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_page_scale_factor"), this->min_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_transform_hint"), this->display_transform_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::OverlayTransform>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegated_ink_metadata"), this->delegated_ink_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::gfx::DelegatedInkMetadata>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition_directives"), this->transition_directives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::viz::CompositorFrameTransitionDirective>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_bounds"), this->capture_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::RegionCaptureBounds&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_shared_element_resources"), this->has_shared_element_resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screenshot_destination"), this->screenshot_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::SameDocNavigationScreenshotDestinationToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_software"), this->is_software,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_tag_definitions"), this->offset_tag_definitions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::viz::mojom::OffsetTagDefinitionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_tag_values"), this->offset_tag_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::viz::OffsetTagValue>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_interval_inputs"), this->frame_interval_inputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameIntervalInputs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CompositorFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::CompositorFrameMetadata::DataView, ::viz::mojom::CompositorFrameMetadataPtr>::Read(
    ::viz::mojom::CompositorFrameMetadata::DataView input,
    ::viz::mojom::CompositorFrameMetadataPtr* output) {
  bool success = true;
  ::viz::mojom::CompositorFrameMetadataPtr result(::viz::mojom::CompositorFrameMetadata::New());
  
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadRootScrollOffset(&result->root_scroll_offset))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success && !input.ReadScrollableViewportSize(&result->scrollable_viewport_size))
        success = false;
      if (success && !input.ReadVisibleViewportSize(&result->visible_viewport_size))
        success = false;
      if (success && !input.ReadContentColorUsage(&result->content_color_usage))
        success = false;
      if (success)
        result->may_contain_video = input.may_contain_video();
      if (success)
        result->may_throttle_if_undrawn_frames = input.may_throttle_if_undrawn_frames();
      if (success)
        result->is_handling_interaction = input.is_handling_interaction();
      if (success)
        result->is_handling_animation = input.is_handling_animation();
      if (success && !input.ReadRootBackgroundColor(&result->root_background_color))
        success = false;
      if (success && !input.ReadLatencyInfo(&result->latency_info))
        success = false;
      if (success && !input.ReadReferencedSurfaces(&result->referenced_surfaces))
        success = false;
      if (success && !input.ReadDeadline(&result->deadline))
        success = false;
      if (success && !input.ReadActivationDependencies(&result->activation_dependencies))
        success = false;
      if (success && !input.ReadBeginFrameAck(&result->begin_frame_ack))
        success = false;
      if (success)
        result->frame_token = input.frame_token();
      if (success)
        result->send_frame_token_to_embedder = input.send_frame_token_to_embedder();
      if (success)
        result->top_controls_visible_height_set = input.top_controls_visible_height_set();
      if (success)
        result->top_controls_visible_height = input.top_controls_visible_height();
      if (success)
        result->min_page_scale_factor = input.min_page_scale_factor();
      if (success && !input.ReadDisplayTransformHint(&result->display_transform_hint))
        success = false;
      if (success && !input.ReadDelegatedInkMetadata(&result->delegated_ink_metadata))
        success = false;
      if (success && !input.ReadTransitionDirectives(&result->transition_directives))
        success = false;
      if (success && !input.ReadCaptureBounds(&result->capture_bounds))
        success = false;
      if (success)
        result->has_shared_element_resources = input.has_shared_element_resources();
      if (success && !input.ReadScreenshotDestination(&result->screenshot_destination))
        success = false;
      if (success)
        result->is_software = input.is_software();
      if (success && !input.ReadOffsetTagDefinitions(&result->offset_tag_definitions))
        success = false;
      if (success && !input.ReadOffsetTagValues(&result->offset_tag_values))
        success = false;
      if (success && !input.ReadFrameIntervalInputs(&result->frame_interval_inputs))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif