// services/service_manager/public/mojom/interface_provider_spec.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_INTERFACE_PROVIDER_SPEC_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_INTERFACE_PROVIDER_SPEC_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/interface_provider_spec.mojom-features.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/interface_provider_spec.mojom-shared.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/interface_provider_spec.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/service_manager/public/cpp/interface_provider_spec_mojom_traits.h"
#include "base/component_export.h"




namespace service_manager::mojom {










class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) InterfaceSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InterfaceSet, T>::value>;
  using DataView = InterfaceSetDataView;
  using Data_ = internal::InterfaceSet_Data;

  template <typename... Args>
  static InterfaceSetPtr New(Args&&... args) {
    return InterfaceSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InterfaceSetPtr From(const U& u) {
    return mojo::TypeConverter<InterfaceSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterfaceSet>::Convert(*this);
  }


  InterfaceSet();

  explicit InterfaceSet(
      std::vector<std::string> interfaces);


  ~InterfaceSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterfaceSetPtr>
  InterfaceSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InterfaceSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InterfaceSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InterfaceSet_UnserializedMessageContext<
            UserType, InterfaceSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InterfaceSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InterfaceSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InterfaceSet_UnserializedMessageContext<
            UserType, InterfaceSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InterfaceSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> interfaces;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InterfaceSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) CapabilitySet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CapabilitySet, T>::value>;
  using DataView = CapabilitySetDataView;
  using Data_ = internal::CapabilitySet_Data;

  template <typename... Args>
  static CapabilitySetPtr New(Args&&... args) {
    return CapabilitySetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CapabilitySetPtr From(const U& u) {
    return mojo::TypeConverter<CapabilitySetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CapabilitySet>::Convert(*this);
  }


  CapabilitySet();

  explicit CapabilitySet(
      std::vector<std::string> capabilities);


  ~CapabilitySet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CapabilitySetPtr>
  CapabilitySetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CapabilitySet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CapabilitySet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CapabilitySet_UnserializedMessageContext<
            UserType, CapabilitySet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CapabilitySet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CapabilitySet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CapabilitySet_UnserializedMessageContext<
            UserType, CapabilitySet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CapabilitySet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> capabilities;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CapabilitySet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) InterfaceProviderSpec {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InterfaceProviderSpec, T>::value>;
  using DataView = InterfaceProviderSpecDataView;
  using Data_ = internal::InterfaceProviderSpec_Data;

  template <typename... Args>
  static InterfaceProviderSpecPtr New(Args&&... args) {
    return InterfaceProviderSpecPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InterfaceProviderSpecPtr From(const U& u) {
    return mojo::TypeConverter<InterfaceProviderSpecPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterfaceProviderSpec>::Convert(*this);
  }


  InterfaceProviderSpec();

  InterfaceProviderSpec(
      const base::flat_map<std::string, ::service_manager::InterfaceSet>& provides,
      const base::flat_map<std::string, ::service_manager::CapabilitySet>& needs);


  ~InterfaceProviderSpec();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterfaceProviderSpecPtr>
  InterfaceProviderSpecPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InterfaceProviderSpec::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InterfaceProviderSpec::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InterfaceProviderSpec_UnserializedMessageContext<
            UserType, InterfaceProviderSpec::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InterfaceProviderSpec::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InterfaceProviderSpec::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InterfaceProviderSpec_UnserializedMessageContext<
            UserType, InterfaceProviderSpec::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InterfaceProviderSpec::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<std::string, ::service_manager::InterfaceSet> provides;
  
  base::flat_map<std::string, ::service_manager::CapabilitySet> needs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InterfaceProviderSpec::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
InterfaceSetPtr InterfaceSet::Clone() const {
  return New(
      mojo::Clone(interfaces)
  );
}

template <typename T, InterfaceSet::EnableIfSame<T>*>
bool InterfaceSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interfaces, other_struct.interfaces))
    return false;
  return true;
}

template <typename T, InterfaceSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interfaces < rhs.interfaces)
    return true;
  if (rhs.interfaces < lhs.interfaces)
    return false;
  return false;
}
template <typename StructPtrType>
CapabilitySetPtr CapabilitySet::Clone() const {
  return New(
      mojo::Clone(capabilities)
  );
}

template <typename T, CapabilitySet::EnableIfSame<T>*>
bool CapabilitySet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->capabilities, other_struct.capabilities))
    return false;
  return true;
}

template <typename T, CapabilitySet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.capabilities < rhs.capabilities)
    return true;
  if (rhs.capabilities < lhs.capabilities)
    return false;
  return false;
}
template <typename StructPtrType>
InterfaceProviderSpecPtr InterfaceProviderSpec::Clone() const {
  return New(
      mojo::Clone(provides),
      mojo::Clone(needs)
  );
}

template <typename T, InterfaceProviderSpec::EnableIfSame<T>*>
bool InterfaceProviderSpec::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provides, other_struct.provides))
    return false;
  if (!mojo::Equals(this->needs, other_struct.needs))
    return false;
  return true;
}

template <typename T, InterfaceProviderSpec::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provides < rhs.provides)
    return true;
  if (rhs.provides < lhs.provides)
    return false;
  if (lhs.needs < rhs.needs)
    return true;
  if (rhs.needs < lhs.needs)
    return false;
  return false;
}


}  // service_manager::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) StructTraits<::service_manager::mojom::InterfaceSet::DataView,
                                         ::service_manager::mojom::InterfaceSetPtr> {
  static bool IsNull(const ::service_manager::mojom::InterfaceSetPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::InterfaceSetPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::InterfaceSet::interfaces)& interfaces(
      const ::service_manager::mojom::InterfaceSetPtr& input) {
    return input->interfaces;
  }

  static bool Read(::service_manager::mojom::InterfaceSet::DataView input, ::service_manager::mojom::InterfaceSetPtr* output);
};


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) StructTraits<::service_manager::mojom::CapabilitySet::DataView,
                                         ::service_manager::mojom::CapabilitySetPtr> {
  static bool IsNull(const ::service_manager::mojom::CapabilitySetPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::CapabilitySetPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::CapabilitySet::capabilities)& capabilities(
      const ::service_manager::mojom::CapabilitySetPtr& input) {
    return input->capabilities;
  }

  static bool Read(::service_manager::mojom::CapabilitySet::DataView input, ::service_manager::mojom::CapabilitySetPtr* output);
};


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) StructTraits<::service_manager::mojom::InterfaceProviderSpec::DataView,
                                         ::service_manager::mojom::InterfaceProviderSpecPtr> {
  static bool IsNull(const ::service_manager::mojom::InterfaceProviderSpecPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::InterfaceProviderSpecPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::InterfaceProviderSpec::provides)& provides(
      const ::service_manager::mojom::InterfaceProviderSpecPtr& input) {
    return input->provides;
  }

  static const decltype(::service_manager::mojom::InterfaceProviderSpec::needs)& needs(
      const ::service_manager::mojom::InterfaceProviderSpecPtr& input) {
    return input->needs;
  }

  static bool Read(::service_manager::mojom::InterfaceProviderSpec::DataView input, ::service_manager::mojom::InterfaceProviderSpecPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_INTERFACE_PROVIDER_SPEC_MOJOM_H_