// components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-params-data.h"
namespace storage {
namespace mojom {

NOINLINE static const char* DisallowInactiveClientReasonToStringHelper(DisallowInactiveClientReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DisallowInactiveClientReason::kVersionChangeEvent:
      return "kVersionChangeEvent";
    case DisallowInactiveClientReason::kTransactionIsAcquiringLocks:
      return "kTransactionIsAcquiringLocks";
    case DisallowInactiveClientReason::kTransactionIsStartingWhileBlockingOthers:
      return "kTransactionIsStartingWhileBlockingOthers";
    case DisallowInactiveClientReason::kTransactionIsOngoingAndBlockingOthers:
      return "kTransactionIsOngoingAndBlockingOthers";
    default:
      return nullptr;
  }
}

std::string DisallowInactiveClientReasonToString(DisallowInactiveClientReason value) {
  const char *str = DisallowInactiveClientReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DisallowInactiveClientReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DisallowInactiveClientReason value) {
  return os << DisallowInactiveClientReasonToString(value);
}

namespace internal {


// static
bool IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data* object =
      static_cast<const IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data*>(data);


  if (!::storage::mojom::internal::DisallowInactiveClientReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->keep_active,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data::IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data* object =
      static_cast<const IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data*>(data);

  return true;
}

IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data::IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBClientStateChecker_MakeClone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IndexedDBClientStateChecker_MakeClone_Params_Data* object =
      static_cast<const IndexedDBClientStateChecker_MakeClone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IndexedDBClientStateChecker_MakeClone_Params_Data::IndexedDBClientStateChecker_MakeClone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::DisallowInactiveClientReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::DisallowInactiveClientReason value) {
  return std::move(context).WriteString(::storage::mojom::DisallowInactiveClientReasonToString(value));
}

} // namespace perfetto