// third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink::mojom {
class SafeUrlPatternDataView;

class FixedPatternDataView;

class WildcardPatternDataView;

class SafeUrlPatternPartDataView;

class SafeUrlPatternOptionsDataView;

class PatternTemplateDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SafeUrlPatternDataView> {
  using Data = ::blink::mojom::internal::SafeUrlPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FixedPatternDataView> {
  using Data = ::blink::mojom::internal::FixedPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WildcardPatternDataView> {
  using Data = ::blink::mojom::internal::WildcardPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SafeUrlPatternPartDataView> {
  using Data = ::blink::mojom::internal::SafeUrlPatternPart_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SafeUrlPatternOptionsDataView> {
  using Data = ::blink::mojom::internal::SafeUrlPatternOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PatternTemplateDataView> {
  using Data = ::blink::mojom::internal::PatternTemplate_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class Modifier : int32_t {
  
  kZeroOrMore = 0,
  
  kOptional = 1,
  
  kOneOrMore = 2,
  
  kNone = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Modifier value);
inline bool IsKnownEnumValue(Modifier value) {
  return internal::Modifier_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SafeUrlPatternDataView {
 public:
  SafeUrlPatternDataView() = default;

  SafeUrlPatternDataView(
      internal::SafeUrlPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetUsernameDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsername(UserType* output) {
    
    auto* pointer = data_->username.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetHostnameDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostname(UserType* output) {
    
    auto* pointer = data_->hostname.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetPortDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPort(UserType* output) {
    
    auto* pointer = data_->port.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetPathnameDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPathname(UserType* output) {
    
    auto* pointer = data_->pathname.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetSearchDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearch(UserType* output) {
    
    auto* pointer = data_->search.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetHashDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHash(UserType* output) {
    
    auto* pointer = data_->hash.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      SafeUrlPatternOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::SafeUrlPatternOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SafeUrlPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FixedPatternDataView {
 public:
  FixedPatternDataView() = default;

  FixedPatternDataView(
      internal::FixedPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FixedPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WildcardPatternDataView {
 public:
  WildcardPatternDataView() = default;

  WildcardPatternDataView(
      internal::WildcardPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPrefixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefix(UserType* output) {
    
    auto* pointer = data_->prefix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSuffixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuffix(UserType* output) {
    
    auto* pointer = data_->suffix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WildcardPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SafeUrlPatternPartDataView {
 public:
  SafeUrlPatternPartDataView() = default;

  SafeUrlPatternPartDataView(
      internal::SafeUrlPatternPart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPatternDataView(
      PatternTemplateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPattern(UserType* output) {
    
    auto* pointer = !data_->pattern.is_null() ? &data_->pattern : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PatternTemplateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadModifier(UserType* output) const {
    auto data_value = data_->modifier;
    return mojo::internal::Deserialize<::blink::mojom::Modifier>(
        data_value, output);
  }
  Modifier modifier() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Modifier>(data_->modifier));
  }
 private:
  internal::SafeUrlPatternPart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SafeUrlPatternOptionsDataView {
 public:
  SafeUrlPatternOptionsDataView() = default;

  SafeUrlPatternOptionsDataView(
      internal::SafeUrlPatternOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool ignore_case() const {
    return data_->ignore_case;
  }
 private:
  internal::SafeUrlPatternOptions_Data* data_ = nullptr;
};


class PatternTemplateDataView {
 public:
  using Tag = internal::PatternTemplate_Data::PatternTemplate_Tag;

  PatternTemplateDataView() = default;

  PatternTemplateDataView(
      internal::PatternTemplate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_fixed() const { return data_->tag == Tag::kFixed; }
  inline void GetFixedDataView(
      FixedPatternDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFixed(UserType* output) const {
    
    CHECK(is_fixed());
    return mojo::internal::Deserialize<::blink::mojom::FixedPatternDataView>(
        data_->data.f_fixed.Get(), output, message_);
  }
  bool is_full_wildcard() const { return data_->tag == Tag::kFullWildcard; }
  inline void GetFullWildcardDataView(
      WildcardPatternDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFullWildcard(UserType* output) const {
    
    CHECK(is_full_wildcard());
    return mojo::internal::Deserialize<::blink::mojom::WildcardPatternDataView>(
        data_->data.f_full_wildcard.Get(), output, message_);
  }
  bool is_segment_wildcard() const { return data_->tag == Tag::kSegmentWildcard; }
  inline void GetSegmentWildcardDataView(
      WildcardPatternDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentWildcard(UserType* output) const {
    
    CHECK(is_segment_wildcard());
    return mojo::internal::Deserialize<::blink::mojom::WildcardPatternDataView>(
        data_->data.f_segment_wildcard.Get(), output, message_);
  }

 private:
  internal::PatternTemplate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::Modifier>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Modifier> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Modifier, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Modifier, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Modifier>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SafeUrlPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SafeUrlPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SafeUrlPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol)::BaseType>
        protocol_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_protocol, protocol_fragment, &protocol_validate_params);
    fragment->protocol.Set(
        protocol_fragment.is_null() ? nullptr : protocol_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->protocol.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol in SafeUrlPattern struct");
    decltype(Traits::username(input)) in_username = Traits::username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username)::BaseType>
        username_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& username_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_username, username_fragment, &username_validate_params);
    fragment->username.Set(
        username_fragment.is_null() ? nullptr : username_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->username.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username in SafeUrlPattern struct");
    decltype(Traits::password(input)) in_password = Traits::password(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password)::BaseType>
        password_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_password, password_fragment, &password_validate_params);
    fragment->password.Set(
        password_fragment.is_null() ? nullptr : password_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->password.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password in SafeUrlPattern struct");
    decltype(Traits::hostname(input)) in_hostname = Traits::hostname(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hostname)::BaseType>
        hostname_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hostname_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_hostname, hostname_fragment, &hostname_validate_params);
    fragment->hostname.Set(
        hostname_fragment.is_null() ? nullptr : hostname_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hostname.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hostname in SafeUrlPattern struct");
    decltype(Traits::port(input)) in_port = Traits::port(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->port)::BaseType>
        port_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& port_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_port, port_fragment, &port_validate_params);
    fragment->port.Set(
        port_fragment.is_null() ? nullptr : port_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->port.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null port in SafeUrlPattern struct");
    decltype(Traits::pathname(input)) in_pathname = Traits::pathname(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pathname)::BaseType>
        pathname_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pathname_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_pathname, pathname_fragment, &pathname_validate_params);
    fragment->pathname.Set(
        pathname_fragment.is_null() ? nullptr : pathname_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pathname.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pathname in SafeUrlPattern struct");
    decltype(Traits::search(input)) in_search = Traits::search(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->search)::BaseType>
        search_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& search_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_search, search_fragment, &search_validate_params);
    fragment->search.Set(
        search_fragment.is_null() ? nullptr : search_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->search.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null search in SafeUrlPattern struct");
    decltype(Traits::hash(input)) in_hash = Traits::hash(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hash)::BaseType>
        hash_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hash_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        in_hash, hash_fragment, &hash_validate_params);
    fragment->hash.Set(
        hash_fragment.is_null() ? nullptr : hash_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hash.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hash in SafeUrlPattern struct");
    decltype(Traits::options(input)) in_options = Traits::options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->options)::BaseType> options_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::SafeUrlPatternOptionsDataView>(
        in_options, options_fragment);
    fragment->options.Set(
        options_fragment.is_null() ? nullptr : options_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in SafeUrlPattern struct");
  }

  static bool Deserialize(::blink::mojom::internal::SafeUrlPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SafeUrlPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FixedPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FixedPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FixedPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in FixedPattern struct");
  }

  static bool Deserialize(::blink::mojom::internal::FixedPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FixedPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WildcardPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WildcardPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WildcardPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in WildcardPattern struct");
    decltype(Traits::prefix(input)) in_prefix = Traits::prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prefix)::BaseType> prefix_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_prefix, prefix_fragment);
    fragment->prefix.Set(
        prefix_fragment.is_null() ? nullptr : prefix_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->prefix.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prefix in WildcardPattern struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in WildcardPattern struct");
    decltype(Traits::suffix(input)) in_suffix = Traits::suffix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suffix)::BaseType> suffix_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_suffix, suffix_fragment);
    fragment->suffix.Set(
        suffix_fragment.is_null() ? nullptr : suffix_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->suffix.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suffix in WildcardPattern struct");
  }

  static bool Deserialize(::blink::mojom::internal::WildcardPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WildcardPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SafeUrlPatternPartDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SafeUrlPatternPartDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SafeUrlPatternPart_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::pattern(input)) in_pattern = Traits::pattern(input);
    mojo::internal::MessageFragment<decltype(fragment->pattern)>
        pattern_fragment(fragment.message());
    pattern_fragment.Claim(&fragment->pattern);
    mojo::internal::Serialize<::blink::mojom::PatternTemplateDataView>(
        in_pattern, pattern_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pattern.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pattern in SafeUrlPatternPart struct");
    mojo::internal::Serialize<::blink::mojom::Modifier>(
        Traits::modifier(input), &fragment->modifier);
  }

  static bool Deserialize(::blink::mojom::internal::SafeUrlPatternPart_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SafeUrlPatternPartDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SafeUrlPatternOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SafeUrlPatternOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SafeUrlPatternOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->ignore_case = Traits::ignore_case(input);
  }

  static bool Deserialize(::blink::mojom::internal::SafeUrlPatternOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SafeUrlPatternOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PatternTemplateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PatternTemplateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PatternTemplate_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PatternTemplateDataView::Tag::kFixed: {
        decltype(Traits::fixed(input))
            in_fixed = Traits::fixed(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_fixed)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::FixedPatternDataView>(
            in_fixed, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null fixed in PatternTemplate union");
        fragment->data.f_fixed.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PatternTemplateDataView::Tag::kFullWildcard: {
        decltype(Traits::full_wildcard(input))
            in_full_wildcard = Traits::full_wildcard(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_full_wildcard)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::WildcardPatternDataView>(
            in_full_wildcard, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null full_wildcard in PatternTemplate union");
        fragment->data.f_full_wildcard.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PatternTemplateDataView::Tag::kSegmentWildcard: {
        decltype(Traits::segment_wildcard(input))
            in_segment_wildcard = Traits::segment_wildcard(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_segment_wildcard)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::WildcardPatternDataView>(
            in_segment_wildcard, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null segment_wildcard in PatternTemplate union");
        fragment->data.f_segment_wildcard.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PatternTemplate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PatternTemplateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SafeUrlPatternDataView::GetProtocolDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->protocol.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetUsernameDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->username.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetPasswordDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->password.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetHostnameDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->hostname.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetPortDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->port.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetPathnameDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->pathname.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetSearchDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->search.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetHashDataView(
    mojo::ArrayDataView<SafeUrlPatternPartDataView>* output) {
  auto pointer = data_->hash.Get();
  *output = mojo::ArrayDataView<SafeUrlPatternPartDataView>(pointer, message_);
}
inline void SafeUrlPatternDataView::GetOptionsDataView(
    SafeUrlPatternOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = SafeUrlPatternOptionsDataView(pointer, message_);
}


inline void FixedPatternDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WildcardPatternDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WildcardPatternDataView::GetPrefixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->prefix.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WildcardPatternDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WildcardPatternDataView::GetSuffixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suffix.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SafeUrlPatternPartDataView::GetPatternDataView(
    PatternTemplateDataView* output) {
  auto pointer = &data_->pattern;
  *output = PatternTemplateDataView(pointer, message_);
}




inline void PatternTemplateDataView::GetFixedDataView(
    FixedPatternDataView* output) const {
  CHECK(is_fixed());
  *output = FixedPatternDataView(data_->data.f_fixed.Get(), message_);
}
inline void PatternTemplateDataView::GetFullWildcardDataView(
    WildcardPatternDataView* output) const {
  CHECK(is_full_wildcard());
  *output = WildcardPatternDataView(data_->data.f_full_wildcard.Get(), message_);
}
inline void PatternTemplateDataView::GetSegmentWildcardDataView(
    WildcardPatternDataView* output) const {
  CHECK(is_segment_wildcard());
  *output = WildcardPatternDataView(data_->data.f_segment_wildcard.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Modifier> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Modifier value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_SHARED_H_