// third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LCP_CRITICAL_PATH_PREDICTOR_LCP_CRITICAL_PATH_PREDICTOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LCP_CRITICAL_PATH_PREDICTOR_LCP_CRITICAL_PATH_PREDICTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class LCPCriticalPathPredictorHostProxy;

template <typename ImplRefTraits>
class LCPCriticalPathPredictorHostStub;

class LCPCriticalPathPredictorHostRequestValidator;


class BLINK_COMMON_EXPORT LCPCriticalPathPredictorHost
    : public LCPCriticalPathPredictorHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LCPCriticalPathPredictorHostInterfaceBase;
  using Proxy_ = LCPCriticalPathPredictorHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LCPCriticalPathPredictorHostStub<ImplRefTraits>;

  using RequestValidator_ = LCPCriticalPathPredictorHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLcpUpdatedMinVersion = 0,
    kSetLcpInfluencerScriptUrlsMinVersion = 0,
    kSetPreconnectOriginsMinVersion = 0,
    kNotifyFetchedFontMinVersion = 0,
    kNotifyFetchedSubresourceMinVersion = 0,
    kSetUnusedPreloadsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLcpUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLcpInfluencerScriptUrls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreconnectOrigins_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyFetchedFont_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyFetchedSubresource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUnusedPreloads_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LCPCriticalPathPredictorHost() = default;

  
  virtual void OnLcpUpdated(const std::optional<std::string>& lcp_element_locator, bool is_image_element, std::optional<uint32_t> predicted_lcp_index) = 0;

  
  virtual void SetLcpInfluencerScriptUrls(const std::vector<::GURL>& lcp_influencer_scripts) = 0;

  
  virtual void SetPreconnectOrigins(const std::vector<::GURL>& origins) = 0;

  
  virtual void NotifyFetchedFont(const ::GURL& font_url, bool hit) = 0;

  
  virtual void NotifyFetchedSubresource(const ::GURL& subresource_url, ::base::TimeDelta subresource_load_start, ::network::mojom::RequestDestination request_destination) = 0;

  
  virtual void SetUnusedPreloads(const std::vector<::GURL>& unused_preloads) = 0;
};



class BLINK_COMMON_EXPORT LCPCriticalPathPredictorHostProxy
    : public LCPCriticalPathPredictorHost {
 public:
  using InterfaceType = LCPCriticalPathPredictorHost;

  explicit LCPCriticalPathPredictorHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLcpUpdated(const std::optional<std::string>& lcp_element_locator, bool is_image_element, std::optional<uint32_t> predicted_lcp_index) final;
  
  void SetLcpInfluencerScriptUrls(const std::vector<::GURL>& lcp_influencer_scripts) final;
  
  void SetPreconnectOrigins(const std::vector<::GURL>& origins) final;
  
  void NotifyFetchedFont(const ::GURL& font_url, bool hit) final;
  
  void NotifyFetchedSubresource(const ::GURL& subresource_url, ::base::TimeDelta subresource_load_start, ::network::mojom::RequestDestination request_destination) final;
  
  void SetUnusedPreloads(const std::vector<::GURL>& unused_preloads) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT LCPCriticalPathPredictorHostStubDispatch {
 public:
  static bool Accept(LCPCriticalPathPredictorHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LCPCriticalPathPredictorHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LCPCriticalPathPredictorHost>>
class LCPCriticalPathPredictorHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LCPCriticalPathPredictorHostStub() = default;
  ~LCPCriticalPathPredictorHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LCPCriticalPathPredictorHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LCPCriticalPathPredictorHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LCPCriticalPathPredictorHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT LCPCriticalPathPredictorNavigationTimeHint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LCPCriticalPathPredictorNavigationTimeHint, T>::value>;
  using DataView = LCPCriticalPathPredictorNavigationTimeHintDataView;
  using Data_ = internal::LCPCriticalPathPredictorNavigationTimeHint_Data;

  template <typename... Args>
  static LCPCriticalPathPredictorNavigationTimeHintPtr New(Args&&... args) {
    return LCPCriticalPathPredictorNavigationTimeHintPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LCPCriticalPathPredictorNavigationTimeHintPtr From(const U& u) {
    return mojo::TypeConverter<LCPCriticalPathPredictorNavigationTimeHintPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LCPCriticalPathPredictorNavigationTimeHint>::Convert(*this);
  }


  LCPCriticalPathPredictorNavigationTimeHint();

  LCPCriticalPathPredictorNavigationTimeHint(
      std::vector<std::string> lcp_element_locators,
      std::vector<::GURL> lcp_influencer_scripts,
      std::vector<::GURL> fetched_fonts,
      std::vector<::GURL> preconnect_origins,
      std::vector<::GURL> unused_preloads);


  ~LCPCriticalPathPredictorNavigationTimeHint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LCPCriticalPathPredictorNavigationTimeHintPtr>
  LCPCriticalPathPredictorNavigationTimeHintPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LCPCriticalPathPredictorNavigationTimeHint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LCPCriticalPathPredictorNavigationTimeHint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LCPCriticalPathPredictorNavigationTimeHint_UnserializedMessageContext<
            UserType, LCPCriticalPathPredictorNavigationTimeHint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LCPCriticalPathPredictorNavigationTimeHint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LCPCriticalPathPredictorNavigationTimeHint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LCPCriticalPathPredictorNavigationTimeHint_UnserializedMessageContext<
            UserType, LCPCriticalPathPredictorNavigationTimeHint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LCPCriticalPathPredictorNavigationTimeHint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> lcp_element_locators;
  
  std::vector<::GURL> lcp_influencer_scripts;
  
  std::vector<::GURL> fetched_fonts;
  
  std::vector<::GURL> preconnect_origins;
  
  std::vector<::GURL> unused_preloads;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LCPCriticalPathPredictorNavigationTimeHintPtr LCPCriticalPathPredictorNavigationTimeHint::Clone() const {
  return New(
      mojo::Clone(lcp_element_locators),
      mojo::Clone(lcp_influencer_scripts),
      mojo::Clone(fetched_fonts),
      mojo::Clone(preconnect_origins),
      mojo::Clone(unused_preloads)
  );
}

template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>*>
bool LCPCriticalPathPredictorNavigationTimeHint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lcp_element_locators, other_struct.lcp_element_locators))
    return false;
  if (!mojo::Equals(this->lcp_influencer_scripts, other_struct.lcp_influencer_scripts))
    return false;
  if (!mojo::Equals(this->fetched_fonts, other_struct.fetched_fonts))
    return false;
  if (!mojo::Equals(this->preconnect_origins, other_struct.preconnect_origins))
    return false;
  if (!mojo::Equals(this->unused_preloads, other_struct.unused_preloads))
    return false;
  return true;
}

template <typename T, LCPCriticalPathPredictorNavigationTimeHint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lcp_element_locators < rhs.lcp_element_locators)
    return true;
  if (rhs.lcp_element_locators < lhs.lcp_element_locators)
    return false;
  if (lhs.lcp_influencer_scripts < rhs.lcp_influencer_scripts)
    return true;
  if (rhs.lcp_influencer_scripts < lhs.lcp_influencer_scripts)
    return false;
  if (lhs.fetched_fonts < rhs.fetched_fonts)
    return true;
  if (rhs.fetched_fonts < lhs.fetched_fonts)
    return false;
  if (lhs.preconnect_origins < rhs.preconnect_origins)
    return true;
  if (rhs.preconnect_origins < lhs.preconnect_origins)
    return false;
  if (lhs.unused_preloads < rhs.unused_preloads)
    return true;
  if (rhs.unused_preloads < lhs.unused_preloads)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::DataView,
                                         ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr> {
  static bool IsNull(const ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::lcp_element_locators)& lcp_element_locators(
      const ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr& input) {
    return input->lcp_element_locators;
  }

  static const decltype(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::lcp_influencer_scripts)& lcp_influencer_scripts(
      const ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr& input) {
    return input->lcp_influencer_scripts;
  }

  static const decltype(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::fetched_fonts)& fetched_fonts(
      const ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr& input) {
    return input->fetched_fonts;
  }

  static const decltype(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::preconnect_origins)& preconnect_origins(
      const ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr& input) {
    return input->preconnect_origins;
  }

  static const decltype(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::unused_preloads)& unused_preloads(
      const ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr& input) {
    return input->unused_preloads;
  }

  static bool Read(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::DataView input, ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LCP_CRITICAL_PATH_PREDICTOR_LCP_CRITICAL_PATH_PREDICTOR_MOJOM_H_