// third_party/blink/public/mojom/interest_group/interest_group_types.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/int128.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "mojo/public/mojom/base/uuid.mojom-blink.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/interest_group/auction_config_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {






class PLATFORM_EXPORT SellerCapabilities {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SellerCapabilities, T>::value>;
  using DataView = SellerCapabilitiesDataView;
  using Data_ = internal::SellerCapabilities_Data;

  template <typename... Args>
  static SellerCapabilitiesPtr New(Args&&... args) {
    return SellerCapabilitiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SellerCapabilitiesPtr From(const U& u) {
    return mojo::TypeConverter<SellerCapabilitiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SellerCapabilities>::Convert(*this);
  }


  SellerCapabilities();

  SellerCapabilities(
      bool allows_interest_group_counts,
      bool allows_latency_stats);


  ~SellerCapabilities();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SellerCapabilitiesPtr>
  SellerCapabilitiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SellerCapabilities::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SellerCapabilities::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SellerCapabilities_UnserializedMessageContext<
            UserType, SellerCapabilities::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SellerCapabilities::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SellerCapabilities::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SellerCapabilities_UnserializedMessageContext<
            UserType, SellerCapabilities::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SellerCapabilities::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allows_interest_group_counts;
  
  bool allows_latency_stats;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SellerCapabilities::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AuctionServerRequestFlags {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionServerRequestFlags, T>::value>;
  using DataView = AuctionServerRequestFlagsDataView;
  using Data_ = internal::AuctionServerRequestFlags_Data;

  template <typename... Args>
  static AuctionServerRequestFlagsPtr New(Args&&... args) {
    return AuctionServerRequestFlagsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionServerRequestFlagsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionServerRequestFlagsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionServerRequestFlags>::Convert(*this);
  }


  AuctionServerRequestFlags();

  AuctionServerRequestFlags(
      bool omit_ads,
      bool include_full_ads,
      bool omit_user_bidding_signals);


  ~AuctionServerRequestFlags();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionServerRequestFlagsPtr>
  AuctionServerRequestFlagsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionServerRequestFlags::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionServerRequestFlags::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionServerRequestFlags_UnserializedMessageContext<
            UserType, AuctionServerRequestFlags::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionServerRequestFlags::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionServerRequestFlags::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionServerRequestFlags_UnserializedMessageContext<
            UserType, AuctionServerRequestFlags::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionServerRequestFlags::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool omit_ads;
  
  bool include_full_ads;
  
  bool omit_user_bidding_signals;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionServerRequestFlags::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AdKeywordReplacement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdKeywordReplacement, T>::value>;
  using DataView = AdKeywordReplacementDataView;
  using Data_ = internal::AdKeywordReplacement_Data;

  template <typename... Args>
  static AdKeywordReplacementPtr New(Args&&... args) {
    return AdKeywordReplacementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdKeywordReplacementPtr From(const U& u) {
    return mojo::TypeConverter<AdKeywordReplacementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdKeywordReplacement>::Convert(*this);
  }


  AdKeywordReplacement();

  AdKeywordReplacement(
      const WTF::String& match,
      const WTF::String& replacement);


  ~AdKeywordReplacement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdKeywordReplacementPtr>
  AdKeywordReplacementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdKeywordReplacement::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdKeywordReplacement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdKeywordReplacement_UnserializedMessageContext<
            UserType, AdKeywordReplacement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdKeywordReplacement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdKeywordReplacement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdKeywordReplacement_UnserializedMessageContext<
            UserType, AdKeywordReplacement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdKeywordReplacement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String match;
  
  WTF::String replacement;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdKeywordReplacement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class PLATFORM_EXPORT AdCurrency {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdCurrency, T>::value>;
  using DataView = AdCurrencyDataView;
  using Data_ = internal::AdCurrency_Data;

  template <typename... Args>
  static AdCurrencyPtr New(Args&&... args) {
    return AdCurrencyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdCurrencyPtr From(const U& u) {
    return mojo::TypeConverter<AdCurrencyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdCurrency>::Convert(*this);
  }


  AdCurrency();

  explicit AdCurrency(
      const WTF::String& currency_code);


  ~AdCurrency();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdCurrencyPtr>
  AdCurrencyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdCurrency::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdCurrency::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdCurrency_UnserializedMessageContext<
            UserType, AdCurrency::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdCurrency::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdCurrency::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdCurrency_UnserializedMessageContext<
            UserType, AdCurrency::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdCurrency::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String currency_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdCurrency::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT AuctionReportBuyerDebugModeConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionReportBuyerDebugModeConfig, T>::value>;
  using DataView = AuctionReportBuyerDebugModeConfigDataView;
  using Data_ = internal::AuctionReportBuyerDebugModeConfig_Data;

  template <typename... Args>
  static AuctionReportBuyerDebugModeConfigPtr New(Args&&... args) {
    return AuctionReportBuyerDebugModeConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionReportBuyerDebugModeConfigPtr From(const U& u) {
    return mojo::TypeConverter<AuctionReportBuyerDebugModeConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionReportBuyerDebugModeConfig>::Convert(*this);
  }


  AuctionReportBuyerDebugModeConfig();

  AuctionReportBuyerDebugModeConfig(
      bool is_enabled,
      std::optional<uint64_t> debug_key);


  ~AuctionReportBuyerDebugModeConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionReportBuyerDebugModeConfigPtr>
  AuctionReportBuyerDebugModeConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionReportBuyerDebugModeConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionReportBuyerDebugModeConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionReportBuyerDebugModeConfig_UnserializedMessageContext<
            UserType, AuctionReportBuyerDebugModeConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionReportBuyerDebugModeConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionReportBuyerDebugModeConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionReportBuyerDebugModeConfig_UnserializedMessageContext<
            UserType, AuctionReportBuyerDebugModeConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionReportBuyerDebugModeConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_enabled;
  
  std::optional<uint64_t> debug_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT AuctionDataBuyerConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionDataBuyerConfig, T>::value>;
  using DataView = AuctionDataBuyerConfigDataView;
  using Data_ = internal::AuctionDataBuyerConfig_Data;

  template <typename... Args>
  static AuctionDataBuyerConfigPtr New(Args&&... args) {
    return AuctionDataBuyerConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionDataBuyerConfigPtr From(const U& u) {
    return mojo::TypeConverter<AuctionDataBuyerConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionDataBuyerConfig>::Convert(*this);
  }


  AuctionDataBuyerConfig();

  explicit AuctionDataBuyerConfig(
      std::optional<uint32_t> target_size);


  ~AuctionDataBuyerConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionDataBuyerConfigPtr>
  AuctionDataBuyerConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionDataBuyerConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionDataBuyerConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionDataBuyerConfig_UnserializedMessageContext<
            UserType, AuctionDataBuyerConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionDataBuyerConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionDataBuyerConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionDataBuyerConfig_UnserializedMessageContext<
            UserType, AuctionDataBuyerConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionDataBuyerConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<uint32_t> target_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT AuctionAdConfigMaybePromiseJson {
 public:
  using DataView = AuctionAdConfigMaybePromiseJsonDataView;
  using Data_ = internal::AuctionAdConfigMaybePromiseJson_Data;
  using Tag = Data_::AuctionAdConfigMaybePromiseJson_Tag;

  template <typename... Args>
  static AuctionAdConfigMaybePromiseJsonPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |promise|.
  static AuctionAdConfigMaybePromiseJsonPtr
  NewPromise(
      uint32_t value) {
    auto result = AuctionAdConfigMaybePromiseJsonPtr(std::in_place);
    result->set_promise(std::move(value));
    return result;
  }
  // Construct an instance holding |value|.
  static AuctionAdConfigMaybePromiseJsonPtr
  NewValue(
      const WTF::String& value) {
    auto result = AuctionAdConfigMaybePromiseJsonPtr(std::in_place);
    result->set_value(std::move(value));
    return result;
  }

  template <typename U>
  static AuctionAdConfigMaybePromiseJsonPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigMaybePromiseJsonPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigMaybePromiseJson>::Convert(*this);
  }

  AuctionAdConfigMaybePromiseJson();
  ~AuctionAdConfigMaybePromiseJson();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AuctionAdConfigMaybePromiseJson(const AuctionAdConfigMaybePromiseJson& other) = delete;
  AuctionAdConfigMaybePromiseJson& operator=(const AuctionAdConfigMaybePromiseJson& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigMaybePromiseJsonPtr>
  AuctionAdConfigMaybePromiseJsonPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseJson>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseJson>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_promise() const { return tag_ == Tag::kPromise; }

  
  uint32_t get_promise() const {
    CHECK(tag_ == Tag::kPromise);
    return data_.promise;
  }

  
  void set_promise(
      uint32_t promise);
  
  bool is_value() const { return tag_ == Tag::kValue; }

  
  WTF::String& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return *(data_.value);
  }

  
  void set_value(
      const WTF::String& value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigMaybePromiseJson::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigMaybePromiseJson::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    uint32_t promise;
    WTF::String* value;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT AuctionAdConfigMaybePromisePerBuyerSignals {
 public:
  using DataView = AuctionAdConfigMaybePromisePerBuyerSignalsDataView;
  using Data_ = internal::AuctionAdConfigMaybePromisePerBuyerSignals_Data;
  using Tag = Data_::AuctionAdConfigMaybePromisePerBuyerSignals_Tag;

  template <typename... Args>
  static AuctionAdConfigMaybePromisePerBuyerSignalsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |promise|.
  static AuctionAdConfigMaybePromisePerBuyerSignalsPtr
  NewPromise(
      uint32_t value) {
    auto result = AuctionAdConfigMaybePromisePerBuyerSignalsPtr(std::in_place);
    result->set_promise(std::move(value));
    return result;
  }
  // Construct an instance holding |value|.
  static AuctionAdConfigMaybePromisePerBuyerSignalsPtr
  NewValue(
      const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>& value) {
    auto result = AuctionAdConfigMaybePromisePerBuyerSignalsPtr(std::in_place);
    result->set_value(std::move(value));
    return result;
  }

  template <typename U>
  static AuctionAdConfigMaybePromisePerBuyerSignalsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigMaybePromisePerBuyerSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigMaybePromisePerBuyerSignals>::Convert(*this);
  }

  AuctionAdConfigMaybePromisePerBuyerSignals();
  ~AuctionAdConfigMaybePromisePerBuyerSignals();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AuctionAdConfigMaybePromisePerBuyerSignals(const AuctionAdConfigMaybePromisePerBuyerSignals& other) = delete;
  AuctionAdConfigMaybePromisePerBuyerSignals& operator=(const AuctionAdConfigMaybePromisePerBuyerSignals& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigMaybePromisePerBuyerSignalsPtr>
  AuctionAdConfigMaybePromisePerBuyerSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromisePerBuyerSignals>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromisePerBuyerSignals>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_promise() const { return tag_ == Tag::kPromise; }

  
  uint32_t get_promise() const {
    CHECK(tag_ == Tag::kPromise);
    return data_.promise;
  }

  
  void set_promise(
      uint32_t promise);
  
  bool is_value() const { return tag_ == Tag::kValue; }

  
  std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return *(data_.value);
  }

  
  void set_value(
      const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>& value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigMaybePromisePerBuyerSignals::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigMaybePromisePerBuyerSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    uint32_t promise;
    std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>* value;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT AuctionAdConfigMaybePromiseBuyerTimeouts {
 public:
  using DataView = AuctionAdConfigMaybePromiseBuyerTimeoutsDataView;
  using Data_ = internal::AuctionAdConfigMaybePromiseBuyerTimeouts_Data;
  using Tag = Data_::AuctionAdConfigMaybePromiseBuyerTimeouts_Tag;

  template <typename... Args>
  static AuctionAdConfigMaybePromiseBuyerTimeoutsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |promise|.
  static AuctionAdConfigMaybePromiseBuyerTimeoutsPtr
  NewPromise(
      uint32_t value) {
    auto result = AuctionAdConfigMaybePromiseBuyerTimeoutsPtr(std::in_place);
    result->set_promise(std::move(value));
    return result;
  }
  // Construct an instance holding |value|.
  static AuctionAdConfigMaybePromiseBuyerTimeoutsPtr
  NewValue(
      AuctionAdConfigBuyerTimeoutsPtr value) {
    auto result = AuctionAdConfigMaybePromiseBuyerTimeoutsPtr(std::in_place);
    result->set_value(std::move(value));
    return result;
  }

  template <typename U>
  static AuctionAdConfigMaybePromiseBuyerTimeoutsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigMaybePromiseBuyerTimeoutsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigMaybePromiseBuyerTimeouts>::Convert(*this);
  }

  AuctionAdConfigMaybePromiseBuyerTimeouts();
  ~AuctionAdConfigMaybePromiseBuyerTimeouts();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AuctionAdConfigMaybePromiseBuyerTimeouts(const AuctionAdConfigMaybePromiseBuyerTimeouts& other) = delete;
  AuctionAdConfigMaybePromiseBuyerTimeouts& operator=(const AuctionAdConfigMaybePromiseBuyerTimeouts& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigMaybePromiseBuyerTimeoutsPtr>
  AuctionAdConfigMaybePromiseBuyerTimeoutsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseBuyerTimeouts>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseBuyerTimeouts>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_promise() const { return tag_ == Tag::kPromise; }

  
  uint32_t get_promise() const {
    CHECK(tag_ == Tag::kPromise);
    return data_.promise;
  }

  
  void set_promise(
      uint32_t promise);
  
  bool is_value() const { return tag_ == Tag::kValue; }

  
  AuctionAdConfigBuyerTimeoutsPtr& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return *(data_.value);
  }

  
  void set_value(
      AuctionAdConfigBuyerTimeoutsPtr value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigMaybePromiseBuyerTimeouts::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigMaybePromiseBuyerTimeouts::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    uint32_t promise;
    AuctionAdConfigBuyerTimeoutsPtr* value;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT AuctionAdConfigMaybePromiseBuyerCurrencies {
 public:
  using DataView = AuctionAdConfigMaybePromiseBuyerCurrenciesDataView;
  using Data_ = internal::AuctionAdConfigMaybePromiseBuyerCurrencies_Data;
  using Tag = Data_::AuctionAdConfigMaybePromiseBuyerCurrencies_Tag;

  template <typename... Args>
  static AuctionAdConfigMaybePromiseBuyerCurrenciesPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |promise|.
  static AuctionAdConfigMaybePromiseBuyerCurrenciesPtr
  NewPromise(
      uint32_t value) {
    auto result = AuctionAdConfigMaybePromiseBuyerCurrenciesPtr(std::in_place);
    result->set_promise(std::move(value));
    return result;
  }
  // Construct an instance holding |value|.
  static AuctionAdConfigMaybePromiseBuyerCurrenciesPtr
  NewValue(
      AuctionAdConfigBuyerCurrenciesPtr value) {
    auto result = AuctionAdConfigMaybePromiseBuyerCurrenciesPtr(std::in_place);
    result->set_value(std::move(value));
    return result;
  }

  template <typename U>
  static AuctionAdConfigMaybePromiseBuyerCurrenciesPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigMaybePromiseBuyerCurrenciesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigMaybePromiseBuyerCurrencies>::Convert(*this);
  }

  AuctionAdConfigMaybePromiseBuyerCurrencies();
  ~AuctionAdConfigMaybePromiseBuyerCurrencies();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AuctionAdConfigMaybePromiseBuyerCurrencies(const AuctionAdConfigMaybePromiseBuyerCurrencies& other) = delete;
  AuctionAdConfigMaybePromiseBuyerCurrencies& operator=(const AuctionAdConfigMaybePromiseBuyerCurrencies& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigMaybePromiseBuyerCurrenciesPtr>
  AuctionAdConfigMaybePromiseBuyerCurrenciesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseBuyerCurrencies>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseBuyerCurrencies>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_promise() const { return tag_ == Tag::kPromise; }

  
  uint32_t get_promise() const {
    CHECK(tag_ == Tag::kPromise);
    return data_.promise;
  }

  
  void set_promise(
      uint32_t promise);
  
  bool is_value() const { return tag_ == Tag::kValue; }

  
  AuctionAdConfigBuyerCurrenciesPtr& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return *(data_.value);
  }

  
  void set_value(
      AuctionAdConfigBuyerCurrenciesPtr value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigMaybePromiseBuyerCurrencies::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigMaybePromiseBuyerCurrencies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    uint32_t promise;
    AuctionAdConfigBuyerCurrenciesPtr* value;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT AuctionAdConfigMaybePromiseDirectFromSellerSignals {
 public:
  using DataView = AuctionAdConfigMaybePromiseDirectFromSellerSignalsDataView;
  using Data_ = internal::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data;
  using Tag = Data_::AuctionAdConfigMaybePromiseDirectFromSellerSignals_Tag;

  template <typename... Args>
  static AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |promise|.
  static AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr
  NewPromise(
      uint32_t value) {
    auto result = AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr(std::in_place);
    result->set_promise(std::move(value));
    return result;
  }
  // Construct an instance holding |value|.
  static AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr
  NewValue(
      DirectFromSellerSignalsPtr value) {
    auto result = AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr(std::in_place);
    result->set_value(std::move(value));
    return result;
  }

  template <typename U>
  static AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigMaybePromiseDirectFromSellerSignals>::Convert(*this);
  }

  AuctionAdConfigMaybePromiseDirectFromSellerSignals();
  ~AuctionAdConfigMaybePromiseDirectFromSellerSignals();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AuctionAdConfigMaybePromiseDirectFromSellerSignals(const AuctionAdConfigMaybePromiseDirectFromSellerSignals& other) = delete;
  AuctionAdConfigMaybePromiseDirectFromSellerSignals& operator=(const AuctionAdConfigMaybePromiseDirectFromSellerSignals& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr>
  AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseDirectFromSellerSignals>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseDirectFromSellerSignals>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_promise() const { return tag_ == Tag::kPromise; }

  
  uint32_t get_promise() const {
    CHECK(tag_ == Tag::kPromise);
    return data_.promise;
  }

  
  void set_promise(
      uint32_t promise);
  
  bool is_value() const { return tag_ == Tag::kValue; }

  
  DirectFromSellerSignalsPtr& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return *(data_.value);
  }

  
  void set_value(
      DirectFromSellerSignalsPtr value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigMaybePromiseDirectFromSellerSignals::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigMaybePromiseDirectFromSellerSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    uint32_t promise;
    DirectFromSellerSignalsPtr* value;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements {
 public:
  using DataView = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsDataView;
  using Data_ = internal::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data;
  using Tag = Data_::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Tag;

  template <typename... Args>
  static AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |promise|.
  static AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr
  NewPromise(
      uint32_t value) {
    auto result = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr(std::in_place);
    result->set_promise(std::move(value));
    return result;
  }
  // Construct an instance holding |value|.
  static AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr
  NewValue(
      WTF::Vector<AdKeywordReplacementPtr> value) {
    auto result = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr(std::in_place);
    result->set_value(std::move(value));
    return result;
  }

  template <typename U>
  static AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements>::Convert(*this);
  }

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements();
  ~AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements(const AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements& other) = delete;
  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements& operator=(const AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr>
  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_promise() const { return tag_ == Tag::kPromise; }

  
  uint32_t get_promise() const {
    CHECK(tag_ == Tag::kPromise);
    return data_.promise;
  }

  
  void set_promise(
      uint32_t promise);
  
  bool is_value() const { return tag_ == Tag::kValue; }

  
  WTF::Vector<AdKeywordReplacementPtr>& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return *(data_.value);
  }

  
  void set_value(
      WTF::Vector<AdKeywordReplacementPtr> value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    uint32_t promise;
    WTF::Vector<AdKeywordReplacementPtr>* value;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT AdAuctionRequestOrError {
 public:
  using DataView = AdAuctionRequestOrErrorDataView;
  using Data_ = internal::AdAuctionRequestOrError_Data;
  using Tag = Data_::AdAuctionRequestOrError_Tag;

  template <typename... Args>
  static AdAuctionRequestOrErrorPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |request|.
  static AdAuctionRequestOrErrorPtr
  NewRequest(
      ::mojo_base::BigBuffer value) {
    auto result = AdAuctionRequestOrErrorPtr(std::in_place);
    result->set_request(std::move(value));
    return result;
  }
  // Construct an instance holding |error|.
  static AdAuctionRequestOrErrorPtr
  NewError(
      const WTF::String& value) {
    auto result = AdAuctionRequestOrErrorPtr(std::in_place);
    result->set_error(std::move(value));
    return result;
  }

  template <typename U>
  static AdAuctionRequestOrErrorPtr From(const U& u) {
    return mojo::TypeConverter<AdAuctionRequestOrErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdAuctionRequestOrError>::Convert(*this);
  }

  AdAuctionRequestOrError();
  ~AdAuctionRequestOrError();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AdAuctionRequestOrError(const AdAuctionRequestOrError& other) = delete;
  AdAuctionRequestOrError& operator=(const AdAuctionRequestOrError& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AdAuctionRequestOrErrorPtr>
  AdAuctionRequestOrErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AdAuctionRequestOrError>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AdAuctionRequestOrError>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_request() const { return tag_ == Tag::kRequest; }

  
  ::mojo_base::BigBuffer& get_request() const {
    CHECK(tag_ == Tag::kRequest);
    return *(data_.request);
  }

  
  void set_request(
      ::mojo_base::BigBuffer request);
  
  bool is_error() const { return tag_ == Tag::kError; }

  
  WTF::String& get_error() const {
    CHECK(tag_ == Tag::kError);
    return *(data_.error);
  }

  
  void set_error(
      const WTF::String& error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdAuctionRequestOrError::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AdAuctionRequestOrError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    ::mojo_base::BigBuffer* request;
    WTF::String* error;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT InterestGroupAd {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InterestGroupAd, T>::value>;
  using DataView = InterestGroupAdDataView;
  using Data_ = internal::InterestGroupAd_Data;

  template <typename... Args>
  static InterestGroupAdPtr New(Args&&... args) {
    return InterestGroupAdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InterestGroupAdPtr From(const U& u) {
    return mojo::TypeConverter<InterestGroupAdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterestGroupAd>::Convert(*this);
  }


  InterestGroupAd();

  InterestGroupAd(
      const WTF::String& render_url,
      const WTF::String& size_group,
      const WTF::String& buyer_reporting_id,
      const WTF::String& buyer_and_seller_reporting_id,
      std::optional<WTF::Vector<WTF::String>> selectable_buyer_and_seller_reporting_ids,
      const WTF::String& metadata,
      const WTF::String& ad_render_id,
      std::optional<WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>> allowed_reporting_origins,
      const WTF::String& creative_scanning_metadata);


  ~InterestGroupAd();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterestGroupAdPtr>
  InterestGroupAdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InterestGroupAd::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InterestGroupAd::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InterestGroupAd_UnserializedMessageContext<
            UserType, InterestGroupAd::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InterestGroupAd::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InterestGroupAd::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InterestGroupAd_UnserializedMessageContext<
            UserType, InterestGroupAd::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InterestGroupAd::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String render_url;
  
  WTF::String size_group;
  
  WTF::String buyer_reporting_id;
  
  WTF::String buyer_and_seller_reporting_id;
  
  std::optional<WTF::Vector<WTF::String>> selectable_buyer_and_seller_reporting_ids;
  
  WTF::String metadata;
  
  WTF::String ad_render_id;
  
  std::optional<WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>> allowed_reporting_origins;
  
  WTF::String creative_scanning_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InterestGroupAd::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT InterestGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InterestGroup, T>::value>;
  using DataView = InterestGroupDataView;
  using Data_ = internal::InterestGroup_Data;
  using ExecutionMode = InterestGroup_ExecutionMode;
  using TrustedBiddingSignalsSlotSizeMode = InterestGroup_TrustedBiddingSignalsSlotSizeMode;

  template <typename... Args>
  static InterestGroupPtr New(Args&&... args) {
    return InterestGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InterestGroupPtr From(const U& u) {
    return mojo::TypeConverter<InterestGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterestGroup>::Convert(*this);
  }


  InterestGroup();

  InterestGroup(
      ::base::Time expiry,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& owner,
      const WTF::String& name,
      double priority,
      bool enable_bidding_signals_prioritization,
      const std::optional<WTF::HashMap<WTF::String, double>>& priority_vector,
      const std::optional<WTF::HashMap<WTF::String, double>>& priority_signals_overrides,
      std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, SellerCapabilitiesPtr>> seller_capabilities,
      SellerCapabilitiesPtr all_sellers_capabilities,
      InterestGroup::ExecutionMode execution_mode,
      InterestGroup::TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode,
      const std::optional<::blink::KURL>& bidding_url,
      const std::optional<::blink::KURL>& bidding_wasm_helper_url,
      const std::optional<::blink::KURL>& update_url,
      const std::optional<::blink::KURL>& trusted_bidding_signals_url,
      std::optional<WTF::Vector<WTF::String>> trusted_bidding_signals_keys,
      int32_t max_trusted_bidding_signals_url_length,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& trusted_bidding_signals_coordinator,
      const WTF::String& user_bidding_signals,
      std::optional<WTF::Vector<InterestGroupAdPtr>> ads,
      std::optional<WTF::Vector<InterestGroupAdPtr>> ad_components,
      std::optional<WTF::HashMap<WTF::String, ::blink::mojom::blink::AdSizePtr>> ad_sizes,
      const std::optional<WTF::HashMap<WTF::String, WTF::Vector<WTF::String>>>& size_groups,
      AuctionServerRequestFlagsPtr auction_server_request_flags,
      std::optional<WTF::Vector<uint8_t>> additional_bid_key,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& aggregation_coordinator_origin);

InterestGroup(const InterestGroup&) = delete;
InterestGroup& operator=(const InterestGroup&) = delete;

  ~InterestGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterestGroupPtr>
  InterestGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InterestGroup::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InterestGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InterestGroup_UnserializedMessageContext<
            UserType, InterestGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InterestGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InterestGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InterestGroup_UnserializedMessageContext<
            UserType, InterestGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InterestGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time expiry;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> owner;
  
  WTF::String name;
  
  double priority;
  
  bool enable_bidding_signals_prioritization;
  
  std::optional<WTF::HashMap<WTF::String, double>> priority_vector;
  
  std::optional<WTF::HashMap<WTF::String, double>> priority_signals_overrides;
  
  std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, SellerCapabilitiesPtr>> seller_capabilities;
  
  SellerCapabilitiesPtr all_sellers_capabilities;
  
  InterestGroup::ExecutionMode execution_mode;
  
  InterestGroup::TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode;
  
  std::optional<::blink::KURL> bidding_url;
  
  std::optional<::blink::KURL> bidding_wasm_helper_url;
  
  std::optional<::blink::KURL> update_url;
  
  std::optional<::blink::KURL> trusted_bidding_signals_url;
  
  std::optional<WTF::Vector<WTF::String>> trusted_bidding_signals_keys;
  
  int32_t max_trusted_bidding_signals_url_length;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> trusted_bidding_signals_coordinator;
  
  WTF::String user_bidding_signals;
  
  std::optional<WTF::Vector<InterestGroupAdPtr>> ads;
  
  std::optional<WTF::Vector<InterestGroupAdPtr>> ad_components;
  
  std::optional<WTF::HashMap<WTF::String, ::blink::mojom::blink::AdSizePtr>> ad_sizes;
  
  std::optional<WTF::HashMap<WTF::String, WTF::Vector<WTF::String>>> size_groups;
  
  AuctionServerRequestFlagsPtr auction_server_request_flags;
  
  std::optional<WTF::Vector<uint8_t>> additional_bid_key;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> aggregation_coordinator_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InterestGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PreviousWin {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PreviousWin, T>::value>;
  using DataView = PreviousWinDataView;
  using Data_ = internal::PreviousWin_Data;

  template <typename... Args>
  static PreviousWinPtr New(Args&&... args) {
    return PreviousWinPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PreviousWinPtr From(const U& u) {
    return mojo::TypeConverter<PreviousWinPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PreviousWin>::Convert(*this);
  }


  PreviousWin();

  PreviousWin(
      ::base::Time time,
      const WTF::String& ad_json);


  ~PreviousWin();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PreviousWinPtr>
  PreviousWinPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PreviousWin::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PreviousWin::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PreviousWin_UnserializedMessageContext<
            UserType, PreviousWin::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PreviousWin::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PreviousWin::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PreviousWin_UnserializedMessageContext<
            UserType, PreviousWin::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PreviousWin::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time time;
  
  WTF::String ad_json;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PreviousWin::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT BiddingBrowserSignals {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BiddingBrowserSignals, T>::value>;
  using DataView = BiddingBrowserSignalsDataView;
  using Data_ = internal::BiddingBrowserSignals_Data;

  template <typename... Args>
  static BiddingBrowserSignalsPtr New(Args&&... args) {
    return BiddingBrowserSignalsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BiddingBrowserSignalsPtr From(const U& u) {
    return mojo::TypeConverter<BiddingBrowserSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BiddingBrowserSignals>::Convert(*this);
  }


  BiddingBrowserSignals();

  BiddingBrowserSignals(
      int32_t join_count,
      int32_t bid_count,
      WTF::Vector<PreviousWinPtr> prev_wins,
      bool for_debugging_only_in_cooldown_or_lockout);

BiddingBrowserSignals(const BiddingBrowserSignals&) = delete;
BiddingBrowserSignals& operator=(const BiddingBrowserSignals&) = delete;

  ~BiddingBrowserSignals();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BiddingBrowserSignalsPtr>
  BiddingBrowserSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BiddingBrowserSignals::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BiddingBrowserSignals::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BiddingBrowserSignals_UnserializedMessageContext<
            UserType, BiddingBrowserSignals::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BiddingBrowserSignals::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BiddingBrowserSignals::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BiddingBrowserSignals_UnserializedMessageContext<
            UserType, BiddingBrowserSignals::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BiddingBrowserSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t join_count;
  
  int32_t bid_count;
  
  WTF::Vector<PreviousWinPtr> prev_wins;
  
  bool for_debugging_only_in_cooldown_or_lockout;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BiddingBrowserSignals::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT StorageInterestGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StorageInterestGroup, T>::value>;
  using DataView = StorageInterestGroupDataView;
  using Data_ = internal::StorageInterestGroup_Data;

  template <typename... Args>
  static StorageInterestGroupPtr New(Args&&... args) {
    return StorageInterestGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StorageInterestGroupPtr From(const U& u) {
    return mojo::TypeConverter<StorageInterestGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StorageInterestGroup>::Convert(*this);
  }


  StorageInterestGroup();

  StorageInterestGroup(
      InterestGroupPtr interest_group,
      BiddingBrowserSignalsPtr bidding_browser_signals,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& joining_origin,
      ::base::Time join_time,
      ::base::Time last_updated,
      ::base::Time next_update_after,
      uint64_t estimated_size);

StorageInterestGroup(const StorageInterestGroup&) = delete;
StorageInterestGroup& operator=(const StorageInterestGroup&) = delete;

  ~StorageInterestGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StorageInterestGroupPtr>
  StorageInterestGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StorageInterestGroup::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StorageInterestGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StorageInterestGroup_UnserializedMessageContext<
            UserType, StorageInterestGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StorageInterestGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StorageInterestGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StorageInterestGroup_UnserializedMessageContext<
            UserType, StorageInterestGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StorageInterestGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  InterestGroupPtr interest_group;
  
  BiddingBrowserSignalsPtr bidding_browser_signals;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> joining_origin;
  
  ::base::Time join_time;
  
  ::base::Time last_updated;
  
  ::base::Time next_update_after;
  
  uint64_t estimated_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StorageInterestGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DirectFromSellerSignalsSubresource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectFromSellerSignalsSubresource, T>::value>;
  using DataView = DirectFromSellerSignalsSubresourceDataView;
  using Data_ = internal::DirectFromSellerSignalsSubresource_Data;

  template <typename... Args>
  static DirectFromSellerSignalsSubresourcePtr New(Args&&... args) {
    return DirectFromSellerSignalsSubresourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectFromSellerSignalsSubresourcePtr From(const U& u) {
    return mojo::TypeConverter<DirectFromSellerSignalsSubresourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectFromSellerSignalsSubresource>::Convert(*this);
  }


  DirectFromSellerSignalsSubresource();

  DirectFromSellerSignalsSubresource(
      const ::blink::KURL& bundle_url,
      const ::base::UnguessableToken& token);


  ~DirectFromSellerSignalsSubresource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectFromSellerSignalsSubresourcePtr>
  DirectFromSellerSignalsSubresourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectFromSellerSignalsSubresource::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectFromSellerSignalsSubresource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectFromSellerSignalsSubresource_UnserializedMessageContext<
            UserType, DirectFromSellerSignalsSubresource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectFromSellerSignalsSubresource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectFromSellerSignalsSubresource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectFromSellerSignalsSubresource_UnserializedMessageContext<
            UserType, DirectFromSellerSignalsSubresource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectFromSellerSignalsSubresource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL bundle_url;
  
  ::base::UnguessableToken token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DirectFromSellerSignals {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectFromSellerSignals, T>::value>;
  using DataView = DirectFromSellerSignalsDataView;
  using Data_ = internal::DirectFromSellerSignals_Data;

  template <typename... Args>
  static DirectFromSellerSignalsPtr New(Args&&... args) {
    return DirectFromSellerSignalsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectFromSellerSignalsPtr From(const U& u) {
    return mojo::TypeConverter<DirectFromSellerSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectFromSellerSignals>::Convert(*this);
  }


  DirectFromSellerSignals();

  DirectFromSellerSignals(
      const ::blink::KURL& prefix,
      WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, DirectFromSellerSignalsSubresourcePtr> per_buyer_signals,
      DirectFromSellerSignalsSubresourcePtr seller_signals,
      DirectFromSellerSignalsSubresourcePtr auction_signals);

DirectFromSellerSignals(const DirectFromSellerSignals&) = delete;
DirectFromSellerSignals& operator=(const DirectFromSellerSignals&) = delete;

  ~DirectFromSellerSignals();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectFromSellerSignalsPtr>
  DirectFromSellerSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectFromSellerSignals::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectFromSellerSignals::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectFromSellerSignals_UnserializedMessageContext<
            UserType, DirectFromSellerSignals::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectFromSellerSignals::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectFromSellerSignals::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectFromSellerSignals_UnserializedMessageContext<
            UserType, DirectFromSellerSignals::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectFromSellerSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL prefix;
  
  WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, DirectFromSellerSignalsSubresourcePtr> per_buyer_signals;
  
  DirectFromSellerSignalsSubresourcePtr seller_signals;
  
  DirectFromSellerSignalsSubresourcePtr auction_signals;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectFromSellerSignals::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AuctionAdConfigBuyerTimeouts {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionAdConfigBuyerTimeouts, T>::value>;
  using DataView = AuctionAdConfigBuyerTimeoutsDataView;
  using Data_ = internal::AuctionAdConfigBuyerTimeouts_Data;

  template <typename... Args>
  static AuctionAdConfigBuyerTimeoutsPtr New(Args&&... args) {
    return AuctionAdConfigBuyerTimeoutsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionAdConfigBuyerTimeoutsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigBuyerTimeoutsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigBuyerTimeouts>::Convert(*this);
  }


  AuctionAdConfigBuyerTimeouts();

  AuctionAdConfigBuyerTimeouts(
      std::optional<::base::TimeDelta> all_buyers_timeout,
      const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::base::TimeDelta>>& per_buyer_timeouts);


  ~AuctionAdConfigBuyerTimeouts();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionAdConfigBuyerTimeoutsPtr>
  AuctionAdConfigBuyerTimeoutsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionAdConfigBuyerTimeouts::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigBuyerTimeouts::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionAdConfigBuyerTimeouts_UnserializedMessageContext<
            UserType, AuctionAdConfigBuyerTimeouts::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionAdConfigBuyerTimeouts::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionAdConfigBuyerTimeouts::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionAdConfigBuyerTimeouts_UnserializedMessageContext<
            UserType, AuctionAdConfigBuyerTimeouts::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionAdConfigBuyerTimeouts::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> all_buyers_timeout;
  
  std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::base::TimeDelta>> per_buyer_timeouts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AuctionAdConfigBuyerCurrencies {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionAdConfigBuyerCurrencies, T>::value>;
  using DataView = AuctionAdConfigBuyerCurrenciesDataView;
  using Data_ = internal::AuctionAdConfigBuyerCurrencies_Data;

  template <typename... Args>
  static AuctionAdConfigBuyerCurrenciesPtr New(Args&&... args) {
    return AuctionAdConfigBuyerCurrenciesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionAdConfigBuyerCurrenciesPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigBuyerCurrenciesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigBuyerCurrencies>::Convert(*this);
  }


  AuctionAdConfigBuyerCurrencies();

  AuctionAdConfigBuyerCurrencies(
      const std::optional<::blink::AdCurrency>& all_buyers_currency,
      const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::AdCurrency>>& per_buyer_currencies);


  ~AuctionAdConfigBuyerCurrencies();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionAdConfigBuyerCurrenciesPtr>
  AuctionAdConfigBuyerCurrenciesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionAdConfigBuyerCurrencies::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigBuyerCurrencies::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionAdConfigBuyerCurrencies_UnserializedMessageContext<
            UserType, AuctionAdConfigBuyerCurrencies::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionAdConfigBuyerCurrencies::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionAdConfigBuyerCurrencies::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionAdConfigBuyerCurrencies_UnserializedMessageContext<
            UserType, AuctionAdConfigBuyerCurrencies::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionAdConfigBuyerCurrencies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::AdCurrency> all_buyers_currency;
  
  std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::AdCurrency>> per_buyer_currencies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AuctionAdServerResponseConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionAdServerResponseConfig, T>::value>;
  using DataView = AuctionAdServerResponseConfigDataView;
  using Data_ = internal::AuctionAdServerResponseConfig_Data;

  template <typename... Args>
  static AuctionAdServerResponseConfigPtr New(Args&&... args) {
    return AuctionAdServerResponseConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionAdServerResponseConfigPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdServerResponseConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdServerResponseConfig>::Convert(*this);
  }


  AuctionAdServerResponseConfig();

  explicit AuctionAdServerResponseConfig(
      const ::base::Uuid& request_id);


  ~AuctionAdServerResponseConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionAdServerResponseConfigPtr>
  AuctionAdServerResponseConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionAdServerResponseConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdServerResponseConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionAdServerResponseConfig_UnserializedMessageContext<
            UserType, AuctionAdServerResponseConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionAdServerResponseConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionAdServerResponseConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionAdServerResponseConfig_UnserializedMessageContext<
            UserType, AuctionAdServerResponseConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionAdServerResponseConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Uuid request_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AuctionReportBuyersConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionReportBuyersConfig, T>::value>;
  using DataView = AuctionReportBuyersConfigDataView;
  using Data_ = internal::AuctionReportBuyersConfig_Data;

  template <typename... Args>
  static AuctionReportBuyersConfigPtr New(Args&&... args) {
    return AuctionReportBuyersConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionReportBuyersConfigPtr From(const U& u) {
    return mojo::TypeConverter<AuctionReportBuyersConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionReportBuyersConfig>::Convert(*this);
  }


  AuctionReportBuyersConfig();

  AuctionReportBuyersConfig(
      const ::absl::uint128& bucket,
      double scale);


  ~AuctionReportBuyersConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionReportBuyersConfigPtr>
  AuctionReportBuyersConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionReportBuyersConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionReportBuyersConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionReportBuyersConfig_UnserializedMessageContext<
            UserType, AuctionReportBuyersConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionReportBuyersConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionReportBuyersConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionReportBuyersConfig_UnserializedMessageContext<
            UserType, AuctionReportBuyersConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionReportBuyersConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::absl::uint128 bucket;
  
  double scale;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AuctionAdConfigNonSharedParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionAdConfigNonSharedParams, T>::value>;
  using DataView = AuctionAdConfigNonSharedParamsDataView;
  using Data_ = internal::AuctionAdConfigNonSharedParams_Data;
  using BuyerReportType = AuctionAdConfigNonSharedParams_BuyerReportType;
  using RealTimeReportingType = AuctionAdConfigNonSharedParams_RealTimeReportingType;

  template <typename... Args>
  static AuctionAdConfigNonSharedParamsPtr New(Args&&... args) {
    return AuctionAdConfigNonSharedParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionAdConfigNonSharedParamsPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigNonSharedParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigNonSharedParams>::Convert(*this);
  }


  AuctionAdConfigNonSharedParams();

  AuctionAdConfigNonSharedParams(
      std::optional<WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>> interest_group_buyers,
      AuctionAdConfigMaybePromiseJsonPtr auction_signals,
      AuctionAdConfigMaybePromiseJsonPtr seller_signals,
      std::optional<::base::TimeDelta> seller_timeout,
      AuctionAdConfigMaybePromisePerBuyerSignalsPtr per_buyer_signals,
      AuctionAdConfigMaybePromiseBuyerTimeoutsPtr buyer_timeouts,
      std::optional<::base::TimeDelta> reporting_timeout,
      const std::optional<::blink::AdCurrency>& seller_currency,
      AuctionAdConfigMaybePromiseBuyerCurrenciesPtr buyer_currencies,
      AuctionAdConfigMaybePromiseBuyerTimeoutsPtr buyer_cumulative_timeouts,
      const WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, uint16_t>& per_buyer_group_limits,
      const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::HashMap<WTF::String, double>>>& per_buyer_priority_signals,
      const std::optional<WTF::HashMap<WTF::String, double>>& all_buyers_priority_signals,
      uint16_t all_buyers_group_limit,
      std::optional<WTF::Vector<::absl::uint128>> auction_report_buyer_keys,
      std::optional<WTF::HashMap<AuctionAdConfigNonSharedParams::BuyerReportType, AuctionReportBuyersConfigPtr>> auction_report_buyers,
      AuctionReportBuyerDebugModeConfigPtr auction_report_buyer_debug_mode_config,
      SellerCapabilitiesPtr required_seller_capabilities,
      ::blink::mojom::blink::AdSizePtr requested_size,
      std::optional<WTF::Vector<::blink::mojom::blink::AdSizePtr>> all_slots_requested_sizes,
      const WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, uint16_t>& per_buyer_multi_bid_limits,
      uint16_t all_buyers_multi_bid_limit,
      const std::optional<::base::Uuid>& auction_nonce,
      std::optional<AuctionAdConfigNonSharedParams::RealTimeReportingType> seller_real_time_reporting_type,
      const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, AuctionAdConfigNonSharedParams::RealTimeReportingType>>& per_buyer_real_time_reporting_types,
      WTF::Vector<AuctionAdConfigPtr> component_auctions,
      AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr deprecated_render_url_replacements,
      int32_t max_trusted_scoring_signals_url_length,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& trusted_scoring_signals_coordinator);

AuctionAdConfigNonSharedParams(const AuctionAdConfigNonSharedParams&) = delete;
AuctionAdConfigNonSharedParams& operator=(const AuctionAdConfigNonSharedParams&) = delete;

  ~AuctionAdConfigNonSharedParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionAdConfigNonSharedParamsPtr>
  AuctionAdConfigNonSharedParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionAdConfigNonSharedParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigNonSharedParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionAdConfigNonSharedParams_UnserializedMessageContext<
            UserType, AuctionAdConfigNonSharedParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionAdConfigNonSharedParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionAdConfigNonSharedParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionAdConfigNonSharedParams_UnserializedMessageContext<
            UserType, AuctionAdConfigNonSharedParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionAdConfigNonSharedParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>> interest_group_buyers;
  
  AuctionAdConfigMaybePromiseJsonPtr auction_signals;
  
  AuctionAdConfigMaybePromiseJsonPtr seller_signals;
  
  std::optional<::base::TimeDelta> seller_timeout;
  
  AuctionAdConfigMaybePromisePerBuyerSignalsPtr per_buyer_signals;
  
  AuctionAdConfigMaybePromiseBuyerTimeoutsPtr buyer_timeouts;
  
  std::optional<::base::TimeDelta> reporting_timeout;
  
  std::optional<::blink::AdCurrency> seller_currency;
  
  AuctionAdConfigMaybePromiseBuyerCurrenciesPtr buyer_currencies;
  
  AuctionAdConfigMaybePromiseBuyerTimeoutsPtr buyer_cumulative_timeouts;
  
  WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, uint16_t> per_buyer_group_limits;
  
  std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::HashMap<WTF::String, double>>> per_buyer_priority_signals;
  
  std::optional<WTF::HashMap<WTF::String, double>> all_buyers_priority_signals;
  
  uint16_t all_buyers_group_limit;
  
  std::optional<WTF::Vector<::absl::uint128>> auction_report_buyer_keys;
  
  std::optional<WTF::HashMap<AuctionAdConfigNonSharedParams::BuyerReportType, AuctionReportBuyersConfigPtr>> auction_report_buyers;
  
  AuctionReportBuyerDebugModeConfigPtr auction_report_buyer_debug_mode_config;
  
  SellerCapabilitiesPtr required_seller_capabilities;
  
  ::blink::mojom::blink::AdSizePtr requested_size;
  
  std::optional<WTF::Vector<::blink::mojom::blink::AdSizePtr>> all_slots_requested_sizes;
  
  WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, uint16_t> per_buyer_multi_bid_limits;
  
  uint16_t all_buyers_multi_bid_limit;
  
  std::optional<::base::Uuid> auction_nonce;
  
  std::optional<AuctionAdConfigNonSharedParams::RealTimeReportingType> seller_real_time_reporting_type;
  
  std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, AuctionAdConfigNonSharedParams::RealTimeReportingType>> per_buyer_real_time_reporting_types;
  
  WTF::Vector<AuctionAdConfigPtr> component_auctions;
  
  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr deprecated_render_url_replacements;
  
  int32_t max_trusted_scoring_signals_url_length;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> trusted_scoring_signals_coordinator;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AuctionAdConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionAdConfig, T>::value>;
  using DataView = AuctionAdConfigDataView;
  using Data_ = internal::AuctionAdConfig_Data;

  template <typename... Args>
  static AuctionAdConfigPtr New(Args&&... args) {
    return AuctionAdConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionAdConfigPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfig>::Convert(*this);
  }


  AuctionAdConfig();

  AuctionAdConfig(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& seller,
      AuctionAdServerResponseConfigPtr server_response,
      const std::optional<::blink::KURL>& decision_logic_url,
      const std::optional<::blink::KURL>& trusted_scoring_signals_url,
      AuctionAdConfigNonSharedParamsPtr auction_ad_config_non_shared_params,
      AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr direct_from_seller_signals,
      bool expects_direct_from_seller_signals_header_ad_slot,
      std::optional<uint16_t> seller_experiment_group_id,
      std::optional<uint16_t> all_buyer_experiment_group_id,
      const WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, uint16_t>& per_buyer_experiment_group_ids,
      bool expects_additional_bids,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& aggregation_coordinator_origin,
      std::optional<bool> send_creative_scanning_metadata);

AuctionAdConfig(const AuctionAdConfig&) = delete;
AuctionAdConfig& operator=(const AuctionAdConfig&) = delete;

  ~AuctionAdConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionAdConfigPtr>
  AuctionAdConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionAdConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionAdConfig_UnserializedMessageContext<
            UserType, AuctionAdConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionAdConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionAdConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionAdConfig_UnserializedMessageContext<
            UserType, AuctionAdConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionAdConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> seller;
  
  AuctionAdServerResponseConfigPtr server_response;
  
  std::optional<::blink::KURL> decision_logic_url;
  
  std::optional<::blink::KURL> trusted_scoring_signals_url;
  
  AuctionAdConfigNonSharedParamsPtr auction_ad_config_non_shared_params;
  
  AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr direct_from_seller_signals;
  
  bool expects_direct_from_seller_signals_header_ad_slot;
  
  std::optional<uint16_t> seller_experiment_group_id;
  
  std::optional<uint16_t> all_buyer_experiment_group_id;
  
  WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, uint16_t> per_buyer_experiment_group_ids;
  
  bool expects_additional_bids;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> aggregation_coordinator_origin;
  
  std::optional<bool> send_creative_scanning_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionAdConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AuctionDataConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionDataConfig, T>::value>;
  using DataView = AuctionDataConfigDataView;
  using Data_ = internal::AuctionDataConfig_Data;

  template <typename... Args>
  static AuctionDataConfigPtr New(Args&&... args) {
    return AuctionDataConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionDataConfigPtr From(const U& u) {
    return mojo::TypeConverter<AuctionDataConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionDataConfig>::Convert(*this);
  }


  AuctionDataConfig();

  AuctionDataConfig(
      WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, AuctionDataBuyerConfigPtr> per_buyer_configs,
      std::optional<uint32_t> request_size);

AuctionDataConfig(const AuctionDataConfig&) = delete;
AuctionDataConfig& operator=(const AuctionDataConfig&) = delete;

  ~AuctionDataConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionDataConfigPtr>
  AuctionDataConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionDataConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionDataConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionDataConfig_UnserializedMessageContext<
            UserType, AuctionDataConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionDataConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionDataConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionDataConfig_UnserializedMessageContext<
            UserType, AuctionDataConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionDataConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, AuctionDataBuyerConfigPtr> per_buyer_configs;
  
  std::optional<uint32_t> request_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionDataConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AdAuctionPerSellerRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdAuctionPerSellerRequest, T>::value>;
  using DataView = AdAuctionPerSellerRequestDataView;
  using Data_ = internal::AdAuctionPerSellerRequest_Data;

  template <typename... Args>
  static AdAuctionPerSellerRequestPtr New(Args&&... args) {
    return AdAuctionPerSellerRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdAuctionPerSellerRequestPtr From(const U& u) {
    return mojo::TypeConverter<AdAuctionPerSellerRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdAuctionPerSellerRequest>::Convert(*this);
  }


  AdAuctionPerSellerRequest();

  AdAuctionPerSellerRequest(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& seller,
      AdAuctionRequestOrErrorPtr data);

AdAuctionPerSellerRequest(const AdAuctionPerSellerRequest&) = delete;
AdAuctionPerSellerRequest& operator=(const AdAuctionPerSellerRequest&) = delete;

  ~AdAuctionPerSellerRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdAuctionPerSellerRequestPtr>
  AdAuctionPerSellerRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdAuctionPerSellerRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdAuctionPerSellerRequest_UnserializedMessageContext<
            UserType, AdAuctionPerSellerRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdAuctionPerSellerRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdAuctionPerSellerRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdAuctionPerSellerRequest_UnserializedMessageContext<
            UserType, AdAuctionPerSellerRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdAuctionPerSellerRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> seller;
  
  AdAuctionRequestOrErrorPtr data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
AuctionAdConfigMaybePromiseJsonPtr AuctionAdConfigMaybePromiseJson::Clone() const {
  switch (tag_) {
    case Tag::kPromise:
      return NewPromise(
          mojo::Clone(data_.promise));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(*data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigMaybePromiseJson>::value>::type*>
bool AuctionAdConfigMaybePromiseJson::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPromise:
      return mojo::Equals(data_.promise, other.data_.promise);
    case Tag::kValue:
      return mojo::Equals(*(data_.value), *(other.data_.value));
  }

  return false;
}
template <typename UnionPtrType>
AuctionAdConfigMaybePromisePerBuyerSignalsPtr AuctionAdConfigMaybePromisePerBuyerSignals::Clone() const {
  switch (tag_) {
    case Tag::kPromise:
      return NewPromise(
          mojo::Clone(data_.promise));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(*data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigMaybePromisePerBuyerSignals>::value>::type*>
bool AuctionAdConfigMaybePromisePerBuyerSignals::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPromise:
      return mojo::Equals(data_.promise, other.data_.promise);
    case Tag::kValue:
      return mojo::Equals(*(data_.value), *(other.data_.value));
  }

  return false;
}
template <typename UnionPtrType>
AuctionAdConfigMaybePromiseBuyerTimeoutsPtr AuctionAdConfigMaybePromiseBuyerTimeouts::Clone() const {
  switch (tag_) {
    case Tag::kPromise:
      return NewPromise(
          mojo::Clone(data_.promise));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(*data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigMaybePromiseBuyerTimeouts>::value>::type*>
bool AuctionAdConfigMaybePromiseBuyerTimeouts::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPromise:
      return mojo::Equals(data_.promise, other.data_.promise);
    case Tag::kValue:
      return mojo::Equals(*(data_.value), *(other.data_.value));
  }

  return false;
}
template <typename UnionPtrType>
AuctionAdConfigMaybePromiseBuyerCurrenciesPtr AuctionAdConfigMaybePromiseBuyerCurrencies::Clone() const {
  switch (tag_) {
    case Tag::kPromise:
      return NewPromise(
          mojo::Clone(data_.promise));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(*data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigMaybePromiseBuyerCurrencies>::value>::type*>
bool AuctionAdConfigMaybePromiseBuyerCurrencies::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPromise:
      return mojo::Equals(data_.promise, other.data_.promise);
    case Tag::kValue:
      return mojo::Equals(*(data_.value), *(other.data_.value));
  }

  return false;
}
template <typename UnionPtrType>
AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr AuctionAdConfigMaybePromiseDirectFromSellerSignals::Clone() const {
  switch (tag_) {
    case Tag::kPromise:
      return NewPromise(
          mojo::Clone(data_.promise));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(*data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigMaybePromiseDirectFromSellerSignals>::value>::type*>
bool AuctionAdConfigMaybePromiseDirectFromSellerSignals::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPromise:
      return mojo::Equals(data_.promise, other.data_.promise);
    case Tag::kValue:
      return mojo::Equals(*(data_.value), *(other.data_.value));
  }

  return false;
}
template <typename UnionPtrType>
AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::Clone() const {
  switch (tag_) {
    case Tag::kPromise:
      return NewPromise(
          mojo::Clone(data_.promise));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(*data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements>::value>::type*>
bool AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPromise:
      return mojo::Equals(data_.promise, other.data_.promise);
    case Tag::kValue:
      return mojo::Equals(*(data_.value), *(other.data_.value));
  }

  return false;
}
template <typename UnionPtrType>
AdAuctionRequestOrErrorPtr AdAuctionRequestOrError::Clone() const {
  switch (tag_) {
    case Tag::kRequest:
      return NewRequest(
          mojo::Clone(*data_.request));
    case Tag::kError:
      return NewError(
          mojo::Clone(*data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AdAuctionRequestOrError>::value>::type*>
bool AdAuctionRequestOrError::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRequest:
      return mojo::Equals(*(data_.request), *(other.data_.request));
    case Tag::kError:
      return mojo::Equals(*(data_.error), *(other.data_.error));
  }

  return false;
}
template <typename StructPtrType>
InterestGroupAdPtr InterestGroupAd::Clone() const {
  return New(
      mojo::Clone(render_url),
      mojo::Clone(size_group),
      mojo::Clone(buyer_reporting_id),
      mojo::Clone(buyer_and_seller_reporting_id),
      mojo::Clone(selectable_buyer_and_seller_reporting_ids),
      mojo::Clone(metadata),
      mojo::Clone(ad_render_id),
      mojo::Clone(allowed_reporting_origins),
      mojo::Clone(creative_scanning_metadata)
  );
}

template <typename T, InterestGroupAd::EnableIfSame<T>*>
bool InterestGroupAd::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->render_url, other_struct.render_url))
    return false;
  if (!mojo::Equals(this->size_group, other_struct.size_group))
    return false;
  if (!mojo::Equals(this->buyer_reporting_id, other_struct.buyer_reporting_id))
    return false;
  if (!mojo::Equals(this->buyer_and_seller_reporting_id, other_struct.buyer_and_seller_reporting_id))
    return false;
  if (!mojo::Equals(this->selectable_buyer_and_seller_reporting_ids, other_struct.selectable_buyer_and_seller_reporting_ids))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->ad_render_id, other_struct.ad_render_id))
    return false;
  if (!mojo::Equals(this->allowed_reporting_origins, other_struct.allowed_reporting_origins))
    return false;
  if (!mojo::Equals(this->creative_scanning_metadata, other_struct.creative_scanning_metadata))
    return false;
  return true;
}

template <typename T, InterestGroupAd::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.render_url < rhs.render_url)
    return true;
  if (rhs.render_url < lhs.render_url)
    return false;
  if (lhs.size_group < rhs.size_group)
    return true;
  if (rhs.size_group < lhs.size_group)
    return false;
  if (lhs.buyer_reporting_id < rhs.buyer_reporting_id)
    return true;
  if (rhs.buyer_reporting_id < lhs.buyer_reporting_id)
    return false;
  if (lhs.buyer_and_seller_reporting_id < rhs.buyer_and_seller_reporting_id)
    return true;
  if (rhs.buyer_and_seller_reporting_id < lhs.buyer_and_seller_reporting_id)
    return false;
  if (lhs.selectable_buyer_and_seller_reporting_ids < rhs.selectable_buyer_and_seller_reporting_ids)
    return true;
  if (rhs.selectable_buyer_and_seller_reporting_ids < lhs.selectable_buyer_and_seller_reporting_ids)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.ad_render_id < rhs.ad_render_id)
    return true;
  if (rhs.ad_render_id < lhs.ad_render_id)
    return false;
  if (lhs.allowed_reporting_origins < rhs.allowed_reporting_origins)
    return true;
  if (rhs.allowed_reporting_origins < lhs.allowed_reporting_origins)
    return false;
  if (lhs.creative_scanning_metadata < rhs.creative_scanning_metadata)
    return true;
  if (rhs.creative_scanning_metadata < lhs.creative_scanning_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
SellerCapabilitiesPtr SellerCapabilities::Clone() const {
  return New(
      mojo::Clone(allows_interest_group_counts),
      mojo::Clone(allows_latency_stats)
  );
}

template <typename T, SellerCapabilities::EnableIfSame<T>*>
bool SellerCapabilities::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allows_interest_group_counts, other_struct.allows_interest_group_counts))
    return false;
  if (!mojo::Equals(this->allows_latency_stats, other_struct.allows_latency_stats))
    return false;
  return true;
}

template <typename T, SellerCapabilities::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allows_interest_group_counts < rhs.allows_interest_group_counts)
    return true;
  if (rhs.allows_interest_group_counts < lhs.allows_interest_group_counts)
    return false;
  if (lhs.allows_latency_stats < rhs.allows_latency_stats)
    return true;
  if (rhs.allows_latency_stats < lhs.allows_latency_stats)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionServerRequestFlagsPtr AuctionServerRequestFlags::Clone() const {
  return New(
      mojo::Clone(omit_ads),
      mojo::Clone(include_full_ads),
      mojo::Clone(omit_user_bidding_signals)
  );
}

template <typename T, AuctionServerRequestFlags::EnableIfSame<T>*>
bool AuctionServerRequestFlags::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->omit_ads, other_struct.omit_ads))
    return false;
  if (!mojo::Equals(this->include_full_ads, other_struct.include_full_ads))
    return false;
  if (!mojo::Equals(this->omit_user_bidding_signals, other_struct.omit_user_bidding_signals))
    return false;
  return true;
}

template <typename T, AuctionServerRequestFlags::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.omit_ads < rhs.omit_ads)
    return true;
  if (rhs.omit_ads < lhs.omit_ads)
    return false;
  if (lhs.include_full_ads < rhs.include_full_ads)
    return true;
  if (rhs.include_full_ads < lhs.include_full_ads)
    return false;
  if (lhs.omit_user_bidding_signals < rhs.omit_user_bidding_signals)
    return true;
  if (rhs.omit_user_bidding_signals < lhs.omit_user_bidding_signals)
    return false;
  return false;
}
template <typename StructPtrType>
AdKeywordReplacementPtr AdKeywordReplacement::Clone() const {
  return New(
      mojo::Clone(match),
      mojo::Clone(replacement)
  );
}

template <typename T, AdKeywordReplacement::EnableIfSame<T>*>
bool AdKeywordReplacement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->match, other_struct.match))
    return false;
  if (!mojo::Equals(this->replacement, other_struct.replacement))
    return false;
  return true;
}

template <typename T, AdKeywordReplacement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.match < rhs.match)
    return true;
  if (rhs.match < lhs.match)
    return false;
  if (lhs.replacement < rhs.replacement)
    return true;
  if (rhs.replacement < lhs.replacement)
    return false;
  return false;
}
template <typename StructPtrType>
InterestGroupPtr InterestGroup::Clone() const {
  return New(
      mojo::Clone(expiry),
      mojo::Clone(owner),
      mojo::Clone(name),
      mojo::Clone(priority),
      mojo::Clone(enable_bidding_signals_prioritization),
      mojo::Clone(priority_vector),
      mojo::Clone(priority_signals_overrides),
      mojo::Clone(seller_capabilities),
      mojo::Clone(all_sellers_capabilities),
      mojo::Clone(execution_mode),
      mojo::Clone(trusted_bidding_signals_slot_size_mode),
      mojo::Clone(bidding_url),
      mojo::Clone(bidding_wasm_helper_url),
      mojo::Clone(update_url),
      mojo::Clone(trusted_bidding_signals_url),
      mojo::Clone(trusted_bidding_signals_keys),
      mojo::Clone(max_trusted_bidding_signals_url_length),
      mojo::Clone(trusted_bidding_signals_coordinator),
      mojo::Clone(user_bidding_signals),
      mojo::Clone(ads),
      mojo::Clone(ad_components),
      mojo::Clone(ad_sizes),
      mojo::Clone(size_groups),
      mojo::Clone(auction_server_request_flags),
      mojo::Clone(additional_bid_key),
      mojo::Clone(aggregation_coordinator_origin)
  );
}

template <typename T, InterestGroup::EnableIfSame<T>*>
bool InterestGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->expiry, other_struct.expiry))
    return false;
  if (!mojo::Equals(this->owner, other_struct.owner))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->enable_bidding_signals_prioritization, other_struct.enable_bidding_signals_prioritization))
    return false;
  if (!mojo::Equals(this->priority_vector, other_struct.priority_vector))
    return false;
  if (!mojo::Equals(this->priority_signals_overrides, other_struct.priority_signals_overrides))
    return false;
  if (!mojo::Equals(this->seller_capabilities, other_struct.seller_capabilities))
    return false;
  if (!mojo::Equals(this->all_sellers_capabilities, other_struct.all_sellers_capabilities))
    return false;
  if (!mojo::Equals(this->execution_mode, other_struct.execution_mode))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_slot_size_mode, other_struct.trusted_bidding_signals_slot_size_mode))
    return false;
  if (!mojo::Equals(this->bidding_url, other_struct.bidding_url))
    return false;
  if (!mojo::Equals(this->bidding_wasm_helper_url, other_struct.bidding_wasm_helper_url))
    return false;
  if (!mojo::Equals(this->update_url, other_struct.update_url))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_url, other_struct.trusted_bidding_signals_url))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_keys, other_struct.trusted_bidding_signals_keys))
    return false;
  if (!mojo::Equals(this->max_trusted_bidding_signals_url_length, other_struct.max_trusted_bidding_signals_url_length))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_coordinator, other_struct.trusted_bidding_signals_coordinator))
    return false;
  if (!mojo::Equals(this->user_bidding_signals, other_struct.user_bidding_signals))
    return false;
  if (!mojo::Equals(this->ads, other_struct.ads))
    return false;
  if (!mojo::Equals(this->ad_components, other_struct.ad_components))
    return false;
  if (!mojo::Equals(this->ad_sizes, other_struct.ad_sizes))
    return false;
  if (!mojo::Equals(this->size_groups, other_struct.size_groups))
    return false;
  if (!mojo::Equals(this->auction_server_request_flags, other_struct.auction_server_request_flags))
    return false;
  if (!mojo::Equals(this->additional_bid_key, other_struct.additional_bid_key))
    return false;
  if (!mojo::Equals(this->aggregation_coordinator_origin, other_struct.aggregation_coordinator_origin))
    return false;
  return true;
}

template <typename T, InterestGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.expiry < rhs.expiry)
    return true;
  if (rhs.expiry < lhs.expiry)
    return false;
  if (lhs.owner < rhs.owner)
    return true;
  if (rhs.owner < lhs.owner)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.enable_bidding_signals_prioritization < rhs.enable_bidding_signals_prioritization)
    return true;
  if (rhs.enable_bidding_signals_prioritization < lhs.enable_bidding_signals_prioritization)
    return false;
  if (lhs.priority_vector < rhs.priority_vector)
    return true;
  if (rhs.priority_vector < lhs.priority_vector)
    return false;
  if (lhs.priority_signals_overrides < rhs.priority_signals_overrides)
    return true;
  if (rhs.priority_signals_overrides < lhs.priority_signals_overrides)
    return false;
  if (lhs.seller_capabilities < rhs.seller_capabilities)
    return true;
  if (rhs.seller_capabilities < lhs.seller_capabilities)
    return false;
  if (lhs.all_sellers_capabilities < rhs.all_sellers_capabilities)
    return true;
  if (rhs.all_sellers_capabilities < lhs.all_sellers_capabilities)
    return false;
  if (lhs.execution_mode < rhs.execution_mode)
    return true;
  if (rhs.execution_mode < lhs.execution_mode)
    return false;
  if (lhs.trusted_bidding_signals_slot_size_mode < rhs.trusted_bidding_signals_slot_size_mode)
    return true;
  if (rhs.trusted_bidding_signals_slot_size_mode < lhs.trusted_bidding_signals_slot_size_mode)
    return false;
  if (lhs.bidding_url < rhs.bidding_url)
    return true;
  if (rhs.bidding_url < lhs.bidding_url)
    return false;
  if (lhs.bidding_wasm_helper_url < rhs.bidding_wasm_helper_url)
    return true;
  if (rhs.bidding_wasm_helper_url < lhs.bidding_wasm_helper_url)
    return false;
  if (lhs.update_url < rhs.update_url)
    return true;
  if (rhs.update_url < lhs.update_url)
    return false;
  if (lhs.trusted_bidding_signals_url < rhs.trusted_bidding_signals_url)
    return true;
  if (rhs.trusted_bidding_signals_url < lhs.trusted_bidding_signals_url)
    return false;
  if (lhs.trusted_bidding_signals_keys < rhs.trusted_bidding_signals_keys)
    return true;
  if (rhs.trusted_bidding_signals_keys < lhs.trusted_bidding_signals_keys)
    return false;
  if (lhs.max_trusted_bidding_signals_url_length < rhs.max_trusted_bidding_signals_url_length)
    return true;
  if (rhs.max_trusted_bidding_signals_url_length < lhs.max_trusted_bidding_signals_url_length)
    return false;
  if (lhs.trusted_bidding_signals_coordinator < rhs.trusted_bidding_signals_coordinator)
    return true;
  if (rhs.trusted_bidding_signals_coordinator < lhs.trusted_bidding_signals_coordinator)
    return false;
  if (lhs.user_bidding_signals < rhs.user_bidding_signals)
    return true;
  if (rhs.user_bidding_signals < lhs.user_bidding_signals)
    return false;
  if (lhs.ads < rhs.ads)
    return true;
  if (rhs.ads < lhs.ads)
    return false;
  if (lhs.ad_components < rhs.ad_components)
    return true;
  if (rhs.ad_components < lhs.ad_components)
    return false;
  if (lhs.ad_sizes < rhs.ad_sizes)
    return true;
  if (rhs.ad_sizes < lhs.ad_sizes)
    return false;
  if (lhs.size_groups < rhs.size_groups)
    return true;
  if (rhs.size_groups < lhs.size_groups)
    return false;
  if (lhs.auction_server_request_flags < rhs.auction_server_request_flags)
    return true;
  if (rhs.auction_server_request_flags < lhs.auction_server_request_flags)
    return false;
  if (lhs.additional_bid_key < rhs.additional_bid_key)
    return true;
  if (rhs.additional_bid_key < lhs.additional_bid_key)
    return false;
  if (lhs.aggregation_coordinator_origin < rhs.aggregation_coordinator_origin)
    return true;
  if (rhs.aggregation_coordinator_origin < lhs.aggregation_coordinator_origin)
    return false;
  return false;
}
template <typename StructPtrType>
PreviousWinPtr PreviousWin::Clone() const {
  return New(
      mojo::Clone(time),
      mojo::Clone(ad_json)
  );
}

template <typename T, PreviousWin::EnableIfSame<T>*>
bool PreviousWin::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->ad_json, other_struct.ad_json))
    return false;
  return true;
}

template <typename T, PreviousWin::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.ad_json < rhs.ad_json)
    return true;
  if (rhs.ad_json < lhs.ad_json)
    return false;
  return false;
}
template <typename StructPtrType>
BiddingBrowserSignalsPtr BiddingBrowserSignals::Clone() const {
  return New(
      mojo::Clone(join_count),
      mojo::Clone(bid_count),
      mojo::Clone(prev_wins),
      mojo::Clone(for_debugging_only_in_cooldown_or_lockout)
  );
}

template <typename T, BiddingBrowserSignals::EnableIfSame<T>*>
bool BiddingBrowserSignals::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->join_count, other_struct.join_count))
    return false;
  if (!mojo::Equals(this->bid_count, other_struct.bid_count))
    return false;
  if (!mojo::Equals(this->prev_wins, other_struct.prev_wins))
    return false;
  if (!mojo::Equals(this->for_debugging_only_in_cooldown_or_lockout, other_struct.for_debugging_only_in_cooldown_or_lockout))
    return false;
  return true;
}

template <typename T, BiddingBrowserSignals::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.join_count < rhs.join_count)
    return true;
  if (rhs.join_count < lhs.join_count)
    return false;
  if (lhs.bid_count < rhs.bid_count)
    return true;
  if (rhs.bid_count < lhs.bid_count)
    return false;
  if (lhs.prev_wins < rhs.prev_wins)
    return true;
  if (rhs.prev_wins < lhs.prev_wins)
    return false;
  if (lhs.for_debugging_only_in_cooldown_or_lockout < rhs.for_debugging_only_in_cooldown_or_lockout)
    return true;
  if (rhs.for_debugging_only_in_cooldown_or_lockout < lhs.for_debugging_only_in_cooldown_or_lockout)
    return false;
  return false;
}
template <typename StructPtrType>
StorageInterestGroupPtr StorageInterestGroup::Clone() const {
  return New(
      mojo::Clone(interest_group),
      mojo::Clone(bidding_browser_signals),
      mojo::Clone(joining_origin),
      mojo::Clone(join_time),
      mojo::Clone(last_updated),
      mojo::Clone(next_update_after),
      mojo::Clone(estimated_size)
  );
}

template <typename T, StorageInterestGroup::EnableIfSame<T>*>
bool StorageInterestGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interest_group, other_struct.interest_group))
    return false;
  if (!mojo::Equals(this->bidding_browser_signals, other_struct.bidding_browser_signals))
    return false;
  if (!mojo::Equals(this->joining_origin, other_struct.joining_origin))
    return false;
  if (!mojo::Equals(this->join_time, other_struct.join_time))
    return false;
  if (!mojo::Equals(this->last_updated, other_struct.last_updated))
    return false;
  if (!mojo::Equals(this->next_update_after, other_struct.next_update_after))
    return false;
  if (!mojo::Equals(this->estimated_size, other_struct.estimated_size))
    return false;
  return true;
}

template <typename T, StorageInterestGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interest_group < rhs.interest_group)
    return true;
  if (rhs.interest_group < lhs.interest_group)
    return false;
  if (lhs.bidding_browser_signals < rhs.bidding_browser_signals)
    return true;
  if (rhs.bidding_browser_signals < lhs.bidding_browser_signals)
    return false;
  if (lhs.joining_origin < rhs.joining_origin)
    return true;
  if (rhs.joining_origin < lhs.joining_origin)
    return false;
  if (lhs.join_time < rhs.join_time)
    return true;
  if (rhs.join_time < lhs.join_time)
    return false;
  if (lhs.last_updated < rhs.last_updated)
    return true;
  if (rhs.last_updated < lhs.last_updated)
    return false;
  if (lhs.next_update_after < rhs.next_update_after)
    return true;
  if (rhs.next_update_after < lhs.next_update_after)
    return false;
  if (lhs.estimated_size < rhs.estimated_size)
    return true;
  if (rhs.estimated_size < lhs.estimated_size)
    return false;
  return false;
}
template <typename StructPtrType>
DirectFromSellerSignalsSubresourcePtr DirectFromSellerSignalsSubresource::Clone() const {
  return New(
      mojo::Clone(bundle_url),
      mojo::Clone(token)
  );
}

template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>*>
bool DirectFromSellerSignalsSubresource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bundle_url, other_struct.bundle_url))
    return false;
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  return true;
}

template <typename T, DirectFromSellerSignalsSubresource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bundle_url < rhs.bundle_url)
    return true;
  if (rhs.bundle_url < lhs.bundle_url)
    return false;
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  return false;
}
template <typename StructPtrType>
DirectFromSellerSignalsPtr DirectFromSellerSignals::Clone() const {
  return New(
      mojo::Clone(prefix),
      mojo::Clone(per_buyer_signals),
      mojo::Clone(seller_signals),
      mojo::Clone(auction_signals)
  );
}

template <typename T, DirectFromSellerSignals::EnableIfSame<T>*>
bool DirectFromSellerSignals::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->prefix, other_struct.prefix))
    return false;
  if (!mojo::Equals(this->per_buyer_signals, other_struct.per_buyer_signals))
    return false;
  if (!mojo::Equals(this->seller_signals, other_struct.seller_signals))
    return false;
  if (!mojo::Equals(this->auction_signals, other_struct.auction_signals))
    return false;
  return true;
}

template <typename T, DirectFromSellerSignals::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.prefix < rhs.prefix)
    return true;
  if (rhs.prefix < lhs.prefix)
    return false;
  if (lhs.per_buyer_signals < rhs.per_buyer_signals)
    return true;
  if (rhs.per_buyer_signals < lhs.per_buyer_signals)
    return false;
  if (lhs.seller_signals < rhs.seller_signals)
    return true;
  if (rhs.seller_signals < lhs.seller_signals)
    return false;
  if (lhs.auction_signals < rhs.auction_signals)
    return true;
  if (rhs.auction_signals < lhs.auction_signals)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionAdConfigBuyerTimeoutsPtr AuctionAdConfigBuyerTimeouts::Clone() const {
  return New(
      mojo::Clone(all_buyers_timeout),
      mojo::Clone(per_buyer_timeouts)
  );
}

template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>*>
bool AuctionAdConfigBuyerTimeouts::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_buyers_timeout, other_struct.all_buyers_timeout))
    return false;
  if (!mojo::Equals(this->per_buyer_timeouts, other_struct.per_buyer_timeouts))
    return false;
  return true;
}

template <typename T, AuctionAdConfigBuyerTimeouts::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_buyers_timeout < rhs.all_buyers_timeout)
    return true;
  if (rhs.all_buyers_timeout < lhs.all_buyers_timeout)
    return false;
  if (lhs.per_buyer_timeouts < rhs.per_buyer_timeouts)
    return true;
  if (rhs.per_buyer_timeouts < lhs.per_buyer_timeouts)
    return false;
  return false;
}
template <typename StructPtrType>
AdCurrencyPtr AdCurrency::Clone() const {
  return New(
      mojo::Clone(currency_code)
  );
}

template <typename T, AdCurrency::EnableIfSame<T>*>
bool AdCurrency::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->currency_code, other_struct.currency_code))
    return false;
  return true;
}

template <typename T, AdCurrency::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.currency_code < rhs.currency_code)
    return true;
  if (rhs.currency_code < lhs.currency_code)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionAdConfigBuyerCurrenciesPtr AuctionAdConfigBuyerCurrencies::Clone() const {
  return New(
      mojo::Clone(all_buyers_currency),
      mojo::Clone(per_buyer_currencies)
  );
}

template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>*>
bool AuctionAdConfigBuyerCurrencies::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_buyers_currency, other_struct.all_buyers_currency))
    return false;
  if (!mojo::Equals(this->per_buyer_currencies, other_struct.per_buyer_currencies))
    return false;
  return true;
}

template <typename T, AuctionAdConfigBuyerCurrencies::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_buyers_currency < rhs.all_buyers_currency)
    return true;
  if (rhs.all_buyers_currency < lhs.all_buyers_currency)
    return false;
  if (lhs.per_buyer_currencies < rhs.per_buyer_currencies)
    return true;
  if (rhs.per_buyer_currencies < lhs.per_buyer_currencies)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionAdServerResponseConfigPtr AuctionAdServerResponseConfig::Clone() const {
  return New(
      mojo::Clone(request_id)
  );
}

template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>*>
bool AuctionAdServerResponseConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  return true;
}

template <typename T, AuctionAdServerResponseConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionReportBuyerDebugModeConfigPtr AuctionReportBuyerDebugModeConfig::Clone() const {
  return New(
      mojo::Clone(is_enabled),
      mojo::Clone(debug_key)
  );
}

template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>*>
bool AuctionReportBuyerDebugModeConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->debug_key, other_struct.debug_key))
    return false;
  return true;
}

template <typename T, AuctionReportBuyerDebugModeConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.debug_key < rhs.debug_key)
    return true;
  if (rhs.debug_key < lhs.debug_key)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionReportBuyersConfigPtr AuctionReportBuyersConfig::Clone() const {
  return New(
      mojo::Clone(bucket),
      mojo::Clone(scale)
  );
}

template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>*>
bool AuctionReportBuyersConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bucket, other_struct.bucket))
    return false;
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  return true;
}

template <typename T, AuctionReportBuyersConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bucket < rhs.bucket)
    return true;
  if (rhs.bucket < lhs.bucket)
    return false;
  if (lhs.scale < rhs.scale)
    return true;
  if (rhs.scale < lhs.scale)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionAdConfigNonSharedParamsPtr AuctionAdConfigNonSharedParams::Clone() const {
  return New(
      mojo::Clone(interest_group_buyers),
      mojo::Clone(auction_signals),
      mojo::Clone(seller_signals),
      mojo::Clone(seller_timeout),
      mojo::Clone(per_buyer_signals),
      mojo::Clone(buyer_timeouts),
      mojo::Clone(reporting_timeout),
      mojo::Clone(seller_currency),
      mojo::Clone(buyer_currencies),
      mojo::Clone(buyer_cumulative_timeouts),
      mojo::Clone(per_buyer_group_limits),
      mojo::Clone(per_buyer_priority_signals),
      mojo::Clone(all_buyers_priority_signals),
      mojo::Clone(all_buyers_group_limit),
      mojo::Clone(auction_report_buyer_keys),
      mojo::Clone(auction_report_buyers),
      mojo::Clone(auction_report_buyer_debug_mode_config),
      mojo::Clone(required_seller_capabilities),
      mojo::Clone(requested_size),
      mojo::Clone(all_slots_requested_sizes),
      mojo::Clone(per_buyer_multi_bid_limits),
      mojo::Clone(all_buyers_multi_bid_limit),
      mojo::Clone(auction_nonce),
      mojo::Clone(seller_real_time_reporting_type),
      mojo::Clone(per_buyer_real_time_reporting_types),
      mojo::Clone(component_auctions),
      mojo::Clone(deprecated_render_url_replacements),
      mojo::Clone(max_trusted_scoring_signals_url_length),
      mojo::Clone(trusted_scoring_signals_coordinator)
  );
}

template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>*>
bool AuctionAdConfigNonSharedParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interest_group_buyers, other_struct.interest_group_buyers))
    return false;
  if (!mojo::Equals(this->auction_signals, other_struct.auction_signals))
    return false;
  if (!mojo::Equals(this->seller_signals, other_struct.seller_signals))
    return false;
  if (!mojo::Equals(this->seller_timeout, other_struct.seller_timeout))
    return false;
  if (!mojo::Equals(this->per_buyer_signals, other_struct.per_buyer_signals))
    return false;
  if (!mojo::Equals(this->buyer_timeouts, other_struct.buyer_timeouts))
    return false;
  if (!mojo::Equals(this->reporting_timeout, other_struct.reporting_timeout))
    return false;
  if (!mojo::Equals(this->seller_currency, other_struct.seller_currency))
    return false;
  if (!mojo::Equals(this->buyer_currencies, other_struct.buyer_currencies))
    return false;
  if (!mojo::Equals(this->buyer_cumulative_timeouts, other_struct.buyer_cumulative_timeouts))
    return false;
  if (!mojo::Equals(this->per_buyer_group_limits, other_struct.per_buyer_group_limits))
    return false;
  if (!mojo::Equals(this->per_buyer_priority_signals, other_struct.per_buyer_priority_signals))
    return false;
  if (!mojo::Equals(this->all_buyers_priority_signals, other_struct.all_buyers_priority_signals))
    return false;
  if (!mojo::Equals(this->all_buyers_group_limit, other_struct.all_buyers_group_limit))
    return false;
  if (!mojo::Equals(this->auction_report_buyer_keys, other_struct.auction_report_buyer_keys))
    return false;
  if (!mojo::Equals(this->auction_report_buyers, other_struct.auction_report_buyers))
    return false;
  if (!mojo::Equals(this->auction_report_buyer_debug_mode_config, other_struct.auction_report_buyer_debug_mode_config))
    return false;
  if (!mojo::Equals(this->required_seller_capabilities, other_struct.required_seller_capabilities))
    return false;
  if (!mojo::Equals(this->requested_size, other_struct.requested_size))
    return false;
  if (!mojo::Equals(this->all_slots_requested_sizes, other_struct.all_slots_requested_sizes))
    return false;
  if (!mojo::Equals(this->per_buyer_multi_bid_limits, other_struct.per_buyer_multi_bid_limits))
    return false;
  if (!mojo::Equals(this->all_buyers_multi_bid_limit, other_struct.all_buyers_multi_bid_limit))
    return false;
  if (!mojo::Equals(this->auction_nonce, other_struct.auction_nonce))
    return false;
  if (!mojo::Equals(this->seller_real_time_reporting_type, other_struct.seller_real_time_reporting_type))
    return false;
  if (!mojo::Equals(this->per_buyer_real_time_reporting_types, other_struct.per_buyer_real_time_reporting_types))
    return false;
  if (!mojo::Equals(this->component_auctions, other_struct.component_auctions))
    return false;
  if (!mojo::Equals(this->deprecated_render_url_replacements, other_struct.deprecated_render_url_replacements))
    return false;
  if (!mojo::Equals(this->max_trusted_scoring_signals_url_length, other_struct.max_trusted_scoring_signals_url_length))
    return false;
  if (!mojo::Equals(this->trusted_scoring_signals_coordinator, other_struct.trusted_scoring_signals_coordinator))
    return false;
  return true;
}

template <typename T, AuctionAdConfigNonSharedParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interest_group_buyers < rhs.interest_group_buyers)
    return true;
  if (rhs.interest_group_buyers < lhs.interest_group_buyers)
    return false;
  if (lhs.auction_signals < rhs.auction_signals)
    return true;
  if (rhs.auction_signals < lhs.auction_signals)
    return false;
  if (lhs.seller_signals < rhs.seller_signals)
    return true;
  if (rhs.seller_signals < lhs.seller_signals)
    return false;
  if (lhs.seller_timeout < rhs.seller_timeout)
    return true;
  if (rhs.seller_timeout < lhs.seller_timeout)
    return false;
  if (lhs.per_buyer_signals < rhs.per_buyer_signals)
    return true;
  if (rhs.per_buyer_signals < lhs.per_buyer_signals)
    return false;
  if (lhs.buyer_timeouts < rhs.buyer_timeouts)
    return true;
  if (rhs.buyer_timeouts < lhs.buyer_timeouts)
    return false;
  if (lhs.reporting_timeout < rhs.reporting_timeout)
    return true;
  if (rhs.reporting_timeout < lhs.reporting_timeout)
    return false;
  if (lhs.seller_currency < rhs.seller_currency)
    return true;
  if (rhs.seller_currency < lhs.seller_currency)
    return false;
  if (lhs.buyer_currencies < rhs.buyer_currencies)
    return true;
  if (rhs.buyer_currencies < lhs.buyer_currencies)
    return false;
  if (lhs.buyer_cumulative_timeouts < rhs.buyer_cumulative_timeouts)
    return true;
  if (rhs.buyer_cumulative_timeouts < lhs.buyer_cumulative_timeouts)
    return false;
  if (lhs.per_buyer_group_limits < rhs.per_buyer_group_limits)
    return true;
  if (rhs.per_buyer_group_limits < lhs.per_buyer_group_limits)
    return false;
  if (lhs.per_buyer_priority_signals < rhs.per_buyer_priority_signals)
    return true;
  if (rhs.per_buyer_priority_signals < lhs.per_buyer_priority_signals)
    return false;
  if (lhs.all_buyers_priority_signals < rhs.all_buyers_priority_signals)
    return true;
  if (rhs.all_buyers_priority_signals < lhs.all_buyers_priority_signals)
    return false;
  if (lhs.all_buyers_group_limit < rhs.all_buyers_group_limit)
    return true;
  if (rhs.all_buyers_group_limit < lhs.all_buyers_group_limit)
    return false;
  if (lhs.auction_report_buyer_keys < rhs.auction_report_buyer_keys)
    return true;
  if (rhs.auction_report_buyer_keys < lhs.auction_report_buyer_keys)
    return false;
  if (lhs.auction_report_buyers < rhs.auction_report_buyers)
    return true;
  if (rhs.auction_report_buyers < lhs.auction_report_buyers)
    return false;
  if (lhs.auction_report_buyer_debug_mode_config < rhs.auction_report_buyer_debug_mode_config)
    return true;
  if (rhs.auction_report_buyer_debug_mode_config < lhs.auction_report_buyer_debug_mode_config)
    return false;
  if (lhs.required_seller_capabilities < rhs.required_seller_capabilities)
    return true;
  if (rhs.required_seller_capabilities < lhs.required_seller_capabilities)
    return false;
  if (lhs.requested_size < rhs.requested_size)
    return true;
  if (rhs.requested_size < lhs.requested_size)
    return false;
  if (lhs.all_slots_requested_sizes < rhs.all_slots_requested_sizes)
    return true;
  if (rhs.all_slots_requested_sizes < lhs.all_slots_requested_sizes)
    return false;
  if (lhs.per_buyer_multi_bid_limits < rhs.per_buyer_multi_bid_limits)
    return true;
  if (rhs.per_buyer_multi_bid_limits < lhs.per_buyer_multi_bid_limits)
    return false;
  if (lhs.all_buyers_multi_bid_limit < rhs.all_buyers_multi_bid_limit)
    return true;
  if (rhs.all_buyers_multi_bid_limit < lhs.all_buyers_multi_bid_limit)
    return false;
  if (lhs.auction_nonce < rhs.auction_nonce)
    return true;
  if (rhs.auction_nonce < lhs.auction_nonce)
    return false;
  if (lhs.seller_real_time_reporting_type < rhs.seller_real_time_reporting_type)
    return true;
  if (rhs.seller_real_time_reporting_type < lhs.seller_real_time_reporting_type)
    return false;
  if (lhs.per_buyer_real_time_reporting_types < rhs.per_buyer_real_time_reporting_types)
    return true;
  if (rhs.per_buyer_real_time_reporting_types < lhs.per_buyer_real_time_reporting_types)
    return false;
  if (lhs.component_auctions < rhs.component_auctions)
    return true;
  if (rhs.component_auctions < lhs.component_auctions)
    return false;
  if (lhs.deprecated_render_url_replacements < rhs.deprecated_render_url_replacements)
    return true;
  if (rhs.deprecated_render_url_replacements < lhs.deprecated_render_url_replacements)
    return false;
  if (lhs.max_trusted_scoring_signals_url_length < rhs.max_trusted_scoring_signals_url_length)
    return true;
  if (rhs.max_trusted_scoring_signals_url_length < lhs.max_trusted_scoring_signals_url_length)
    return false;
  if (lhs.trusted_scoring_signals_coordinator < rhs.trusted_scoring_signals_coordinator)
    return true;
  if (rhs.trusted_scoring_signals_coordinator < lhs.trusted_scoring_signals_coordinator)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionAdConfigPtr AuctionAdConfig::Clone() const {
  return New(
      mojo::Clone(seller),
      mojo::Clone(server_response),
      mojo::Clone(decision_logic_url),
      mojo::Clone(trusted_scoring_signals_url),
      mojo::Clone(auction_ad_config_non_shared_params),
      mojo::Clone(direct_from_seller_signals),
      mojo::Clone(expects_direct_from_seller_signals_header_ad_slot),
      mojo::Clone(seller_experiment_group_id),
      mojo::Clone(all_buyer_experiment_group_id),
      mojo::Clone(per_buyer_experiment_group_ids),
      mojo::Clone(expects_additional_bids),
      mojo::Clone(aggregation_coordinator_origin),
      mojo::Clone(send_creative_scanning_metadata)
  );
}

template <typename T, AuctionAdConfig::EnableIfSame<T>*>
bool AuctionAdConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->seller, other_struct.seller))
    return false;
  if (!mojo::Equals(this->server_response, other_struct.server_response))
    return false;
  if (!mojo::Equals(this->decision_logic_url, other_struct.decision_logic_url))
    return false;
  if (!mojo::Equals(this->trusted_scoring_signals_url, other_struct.trusted_scoring_signals_url))
    return false;
  if (!mojo::Equals(this->auction_ad_config_non_shared_params, other_struct.auction_ad_config_non_shared_params))
    return false;
  if (!mojo::Equals(this->direct_from_seller_signals, other_struct.direct_from_seller_signals))
    return false;
  if (!mojo::Equals(this->expects_direct_from_seller_signals_header_ad_slot, other_struct.expects_direct_from_seller_signals_header_ad_slot))
    return false;
  if (!mojo::Equals(this->seller_experiment_group_id, other_struct.seller_experiment_group_id))
    return false;
  if (!mojo::Equals(this->all_buyer_experiment_group_id, other_struct.all_buyer_experiment_group_id))
    return false;
  if (!mojo::Equals(this->per_buyer_experiment_group_ids, other_struct.per_buyer_experiment_group_ids))
    return false;
  if (!mojo::Equals(this->expects_additional_bids, other_struct.expects_additional_bids))
    return false;
  if (!mojo::Equals(this->aggregation_coordinator_origin, other_struct.aggregation_coordinator_origin))
    return false;
  if (!mojo::Equals(this->send_creative_scanning_metadata, other_struct.send_creative_scanning_metadata))
    return false;
  return true;
}

template <typename T, AuctionAdConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.seller < rhs.seller)
    return true;
  if (rhs.seller < lhs.seller)
    return false;
  if (lhs.server_response < rhs.server_response)
    return true;
  if (rhs.server_response < lhs.server_response)
    return false;
  if (lhs.decision_logic_url < rhs.decision_logic_url)
    return true;
  if (rhs.decision_logic_url < lhs.decision_logic_url)
    return false;
  if (lhs.trusted_scoring_signals_url < rhs.trusted_scoring_signals_url)
    return true;
  if (rhs.trusted_scoring_signals_url < lhs.trusted_scoring_signals_url)
    return false;
  if (lhs.auction_ad_config_non_shared_params < rhs.auction_ad_config_non_shared_params)
    return true;
  if (rhs.auction_ad_config_non_shared_params < lhs.auction_ad_config_non_shared_params)
    return false;
  if (lhs.direct_from_seller_signals < rhs.direct_from_seller_signals)
    return true;
  if (rhs.direct_from_seller_signals < lhs.direct_from_seller_signals)
    return false;
  if (lhs.expects_direct_from_seller_signals_header_ad_slot < rhs.expects_direct_from_seller_signals_header_ad_slot)
    return true;
  if (rhs.expects_direct_from_seller_signals_header_ad_slot < lhs.expects_direct_from_seller_signals_header_ad_slot)
    return false;
  if (lhs.seller_experiment_group_id < rhs.seller_experiment_group_id)
    return true;
  if (rhs.seller_experiment_group_id < lhs.seller_experiment_group_id)
    return false;
  if (lhs.all_buyer_experiment_group_id < rhs.all_buyer_experiment_group_id)
    return true;
  if (rhs.all_buyer_experiment_group_id < lhs.all_buyer_experiment_group_id)
    return false;
  if (lhs.per_buyer_experiment_group_ids < rhs.per_buyer_experiment_group_ids)
    return true;
  if (rhs.per_buyer_experiment_group_ids < lhs.per_buyer_experiment_group_ids)
    return false;
  if (lhs.expects_additional_bids < rhs.expects_additional_bids)
    return true;
  if (rhs.expects_additional_bids < lhs.expects_additional_bids)
    return false;
  if (lhs.aggregation_coordinator_origin < rhs.aggregation_coordinator_origin)
    return true;
  if (rhs.aggregation_coordinator_origin < lhs.aggregation_coordinator_origin)
    return false;
  if (lhs.send_creative_scanning_metadata < rhs.send_creative_scanning_metadata)
    return true;
  if (rhs.send_creative_scanning_metadata < lhs.send_creative_scanning_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionDataBuyerConfigPtr AuctionDataBuyerConfig::Clone() const {
  return New(
      mojo::Clone(target_size)
  );
}

template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>*>
bool AuctionDataBuyerConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_size, other_struct.target_size))
    return false;
  return true;
}

template <typename T, AuctionDataBuyerConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.target_size < rhs.target_size)
    return true;
  if (rhs.target_size < lhs.target_size)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionDataConfigPtr AuctionDataConfig::Clone() const {
  return New(
      mojo::Clone(per_buyer_configs),
      mojo::Clone(request_size)
  );
}

template <typename T, AuctionDataConfig::EnableIfSame<T>*>
bool AuctionDataConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->per_buyer_configs, other_struct.per_buyer_configs))
    return false;
  if (!mojo::Equals(this->request_size, other_struct.request_size))
    return false;
  return true;
}

template <typename T, AuctionDataConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.per_buyer_configs < rhs.per_buyer_configs)
    return true;
  if (rhs.per_buyer_configs < lhs.per_buyer_configs)
    return false;
  if (lhs.request_size < rhs.request_size)
    return true;
  if (rhs.request_size < lhs.request_size)
    return false;
  return false;
}
template <typename StructPtrType>
AdAuctionPerSellerRequestPtr AdAuctionPerSellerRequest::Clone() const {
  return New(
      mojo::Clone(seller),
      mojo::Clone(data)
  );
}

template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>*>
bool AdAuctionPerSellerRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->seller, other_struct.seller))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AdAuctionPerSellerRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.seller < rhs.seller)
    return true;
  if (rhs.seller < lhs.seller)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::InterestGroupAd::DataView,
                                         ::blink::mojom::blink::InterestGroupAdPtr> {
  static bool IsNull(const ::blink::mojom::blink::InterestGroupAdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::InterestGroupAdPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::InterestGroupAd::render_url)& render_url(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->render_url;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::size_group)& size_group(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->size_group;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::buyer_reporting_id)& buyer_reporting_id(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->buyer_reporting_id;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::buyer_and_seller_reporting_id)& buyer_and_seller_reporting_id(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->buyer_and_seller_reporting_id;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::selectable_buyer_and_seller_reporting_ids)& selectable_buyer_and_seller_reporting_ids(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->selectable_buyer_and_seller_reporting_ids;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::metadata)& metadata(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->metadata;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::ad_render_id)& ad_render_id(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->ad_render_id;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::allowed_reporting_origins)& allowed_reporting_origins(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->allowed_reporting_origins;
  }

  static const decltype(::blink::mojom::blink::InterestGroupAd::creative_scanning_metadata)& creative_scanning_metadata(
      const ::blink::mojom::blink::InterestGroupAdPtr& input) {
    return input->creative_scanning_metadata;
  }

  static bool Read(::blink::mojom::blink::InterestGroupAd::DataView input, ::blink::mojom::blink::InterestGroupAdPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SellerCapabilities::DataView,
                                         ::blink::mojom::blink::SellerCapabilitiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::SellerCapabilitiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SellerCapabilitiesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::SellerCapabilities::allows_interest_group_counts) allows_interest_group_counts(
      const ::blink::mojom::blink::SellerCapabilitiesPtr& input) {
    return input->allows_interest_group_counts;
  }

  static decltype(::blink::mojom::blink::SellerCapabilities::allows_latency_stats) allows_latency_stats(
      const ::blink::mojom::blink::SellerCapabilitiesPtr& input) {
    return input->allows_latency_stats;
  }

  static bool Read(::blink::mojom::blink::SellerCapabilities::DataView input, ::blink::mojom::blink::SellerCapabilitiesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionServerRequestFlags::DataView,
                                         ::blink::mojom::blink::AuctionServerRequestFlagsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionServerRequestFlagsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionServerRequestFlagsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AuctionServerRequestFlags::omit_ads) omit_ads(
      const ::blink::mojom::blink::AuctionServerRequestFlagsPtr& input) {
    return input->omit_ads;
  }

  static decltype(::blink::mojom::blink::AuctionServerRequestFlags::include_full_ads) include_full_ads(
      const ::blink::mojom::blink::AuctionServerRequestFlagsPtr& input) {
    return input->include_full_ads;
  }

  static decltype(::blink::mojom::blink::AuctionServerRequestFlags::omit_user_bidding_signals) omit_user_bidding_signals(
      const ::blink::mojom::blink::AuctionServerRequestFlagsPtr& input) {
    return input->omit_user_bidding_signals;
  }

  static bool Read(::blink::mojom::blink::AuctionServerRequestFlags::DataView input, ::blink::mojom::blink::AuctionServerRequestFlagsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdKeywordReplacement::DataView,
                                         ::blink::mojom::blink::AdKeywordReplacementPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdKeywordReplacementPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdKeywordReplacementPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AdKeywordReplacement::match)& match(
      const ::blink::mojom::blink::AdKeywordReplacementPtr& input) {
    return input->match;
  }

  static const decltype(::blink::mojom::blink::AdKeywordReplacement::replacement)& replacement(
      const ::blink::mojom::blink::AdKeywordReplacementPtr& input) {
    return input->replacement;
  }

  static bool Read(::blink::mojom::blink::AdKeywordReplacement::DataView input, ::blink::mojom::blink::AdKeywordReplacementPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::InterestGroup::DataView,
                                         ::blink::mojom::blink::InterestGroupPtr> {
  static bool IsNull(const ::blink::mojom::blink::InterestGroupPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::InterestGroupPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::InterestGroup::expiry)& expiry(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->expiry;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::owner)& owner(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->owner;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::name)& name(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::blink::InterestGroup::priority) priority(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->priority;
  }

  static decltype(::blink::mojom::blink::InterestGroup::enable_bidding_signals_prioritization) enable_bidding_signals_prioritization(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->enable_bidding_signals_prioritization;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::priority_vector)& priority_vector(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->priority_vector;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::priority_signals_overrides)& priority_signals_overrides(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->priority_signals_overrides;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::seller_capabilities)& seller_capabilities(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->seller_capabilities;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::all_sellers_capabilities)& all_sellers_capabilities(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->all_sellers_capabilities;
  }

  static decltype(::blink::mojom::blink::InterestGroup::execution_mode) execution_mode(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->execution_mode;
  }

  static decltype(::blink::mojom::blink::InterestGroup::trusted_bidding_signals_slot_size_mode) trusted_bidding_signals_slot_size_mode(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->trusted_bidding_signals_slot_size_mode;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::bidding_url)& bidding_url(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->bidding_url;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::bidding_wasm_helper_url)& bidding_wasm_helper_url(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->bidding_wasm_helper_url;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::update_url)& update_url(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->update_url;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::trusted_bidding_signals_url)& trusted_bidding_signals_url(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->trusted_bidding_signals_url;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::trusted_bidding_signals_keys)& trusted_bidding_signals_keys(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->trusted_bidding_signals_keys;
  }

  static decltype(::blink::mojom::blink::InterestGroup::max_trusted_bidding_signals_url_length) max_trusted_bidding_signals_url_length(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->max_trusted_bidding_signals_url_length;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::trusted_bidding_signals_coordinator)& trusted_bidding_signals_coordinator(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->trusted_bidding_signals_coordinator;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::user_bidding_signals)& user_bidding_signals(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->user_bidding_signals;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::ads)& ads(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->ads;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::ad_components)& ad_components(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->ad_components;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::ad_sizes)& ad_sizes(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->ad_sizes;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::size_groups)& size_groups(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->size_groups;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::auction_server_request_flags)& auction_server_request_flags(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->auction_server_request_flags;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::additional_bid_key)& additional_bid_key(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->additional_bid_key;
  }

  static const decltype(::blink::mojom::blink::InterestGroup::aggregation_coordinator_origin)& aggregation_coordinator_origin(
      const ::blink::mojom::blink::InterestGroupPtr& input) {
    return input->aggregation_coordinator_origin;
  }

  static bool Read(::blink::mojom::blink::InterestGroup::DataView input, ::blink::mojom::blink::InterestGroupPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PreviousWin::DataView,
                                         ::blink::mojom::blink::PreviousWinPtr> {
  static bool IsNull(const ::blink::mojom::blink::PreviousWinPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PreviousWinPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PreviousWin::time)& time(
      const ::blink::mojom::blink::PreviousWinPtr& input) {
    return input->time;
  }

  static const decltype(::blink::mojom::blink::PreviousWin::ad_json)& ad_json(
      const ::blink::mojom::blink::PreviousWinPtr& input) {
    return input->ad_json;
  }

  static bool Read(::blink::mojom::blink::PreviousWin::DataView input, ::blink::mojom::blink::PreviousWinPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BiddingBrowserSignals::DataView,
                                         ::blink::mojom::blink::BiddingBrowserSignalsPtr> {
  static bool IsNull(const ::blink::mojom::blink::BiddingBrowserSignalsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BiddingBrowserSignalsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::BiddingBrowserSignals::join_count) join_count(
      const ::blink::mojom::blink::BiddingBrowserSignalsPtr& input) {
    return input->join_count;
  }

  static decltype(::blink::mojom::blink::BiddingBrowserSignals::bid_count) bid_count(
      const ::blink::mojom::blink::BiddingBrowserSignalsPtr& input) {
    return input->bid_count;
  }

  static const decltype(::blink::mojom::blink::BiddingBrowserSignals::prev_wins)& prev_wins(
      const ::blink::mojom::blink::BiddingBrowserSignalsPtr& input) {
    return input->prev_wins;
  }

  static decltype(::blink::mojom::blink::BiddingBrowserSignals::for_debugging_only_in_cooldown_or_lockout) for_debugging_only_in_cooldown_or_lockout(
      const ::blink::mojom::blink::BiddingBrowserSignalsPtr& input) {
    return input->for_debugging_only_in_cooldown_or_lockout;
  }

  static bool Read(::blink::mojom::blink::BiddingBrowserSignals::DataView input, ::blink::mojom::blink::BiddingBrowserSignalsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StorageInterestGroup::DataView,
                                         ::blink::mojom::blink::StorageInterestGroupPtr> {
  static bool IsNull(const ::blink::mojom::blink::StorageInterestGroupPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StorageInterestGroupPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::StorageInterestGroup::interest_group)& interest_group(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->interest_group;
  }

  static const decltype(::blink::mojom::blink::StorageInterestGroup::bidding_browser_signals)& bidding_browser_signals(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->bidding_browser_signals;
  }

  static const decltype(::blink::mojom::blink::StorageInterestGroup::joining_origin)& joining_origin(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->joining_origin;
  }

  static const decltype(::blink::mojom::blink::StorageInterestGroup::join_time)& join_time(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->join_time;
  }

  static const decltype(::blink::mojom::blink::StorageInterestGroup::last_updated)& last_updated(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->last_updated;
  }

  static const decltype(::blink::mojom::blink::StorageInterestGroup::next_update_after)& next_update_after(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->next_update_after;
  }

  static decltype(::blink::mojom::blink::StorageInterestGroup::estimated_size) estimated_size(
      const ::blink::mojom::blink::StorageInterestGroupPtr& input) {
    return input->estimated_size;
  }

  static bool Read(::blink::mojom::blink::StorageInterestGroup::DataView input, ::blink::mojom::blink::StorageInterestGroupPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DirectFromSellerSignalsSubresource::DataView,
                                         ::blink::mojom::blink::DirectFromSellerSignalsSubresourcePtr> {
  static bool IsNull(const ::blink::mojom::blink::DirectFromSellerSignalsSubresourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DirectFromSellerSignalsSubresourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DirectFromSellerSignalsSubresource::bundle_url)& bundle_url(
      const ::blink::mojom::blink::DirectFromSellerSignalsSubresourcePtr& input) {
    return input->bundle_url;
  }

  static const decltype(::blink::mojom::blink::DirectFromSellerSignalsSubresource::token)& token(
      const ::blink::mojom::blink::DirectFromSellerSignalsSubresourcePtr& input) {
    return input->token;
  }

  static bool Read(::blink::mojom::blink::DirectFromSellerSignalsSubresource::DataView input, ::blink::mojom::blink::DirectFromSellerSignalsSubresourcePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DirectFromSellerSignals::DataView,
                                         ::blink::mojom::blink::DirectFromSellerSignalsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DirectFromSellerSignalsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DirectFromSellerSignalsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DirectFromSellerSignals::prefix)& prefix(
      const ::blink::mojom::blink::DirectFromSellerSignalsPtr& input) {
    return input->prefix;
  }

  static const decltype(::blink::mojom::blink::DirectFromSellerSignals::per_buyer_signals)& per_buyer_signals(
      const ::blink::mojom::blink::DirectFromSellerSignalsPtr& input) {
    return input->per_buyer_signals;
  }

  static const decltype(::blink::mojom::blink::DirectFromSellerSignals::seller_signals)& seller_signals(
      const ::blink::mojom::blink::DirectFromSellerSignalsPtr& input) {
    return input->seller_signals;
  }

  static const decltype(::blink::mojom::blink::DirectFromSellerSignals::auction_signals)& auction_signals(
      const ::blink::mojom::blink::DirectFromSellerSignalsPtr& input) {
    return input->auction_signals;
  }

  static bool Read(::blink::mojom::blink::DirectFromSellerSignals::DataView input, ::blink::mojom::blink::DirectFromSellerSignalsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionAdConfigBuyerTimeouts::DataView,
                                         ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionAdConfigBuyerTimeouts::all_buyers_timeout)& all_buyers_timeout(
      const ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr& input) {
    return input->all_buyers_timeout;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigBuyerTimeouts::per_buyer_timeouts)& per_buyer_timeouts(
      const ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr& input) {
    return input->per_buyer_timeouts;
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigBuyerTimeouts::DataView input, ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdCurrency::DataView,
                                         ::blink::mojom::blink::AdCurrencyPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdCurrencyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdCurrencyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AdCurrency::currency_code)& currency_code(
      const ::blink::mojom::blink::AdCurrencyPtr& input) {
    return input->currency_code;
  }

  static bool Read(::blink::mojom::blink::AdCurrency::DataView input, ::blink::mojom::blink::AdCurrencyPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionAdConfigBuyerCurrencies::DataView,
                                         ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionAdConfigBuyerCurrencies::all_buyers_currency)& all_buyers_currency(
      const ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr& input) {
    return input->all_buyers_currency;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigBuyerCurrencies::per_buyer_currencies)& per_buyer_currencies(
      const ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr& input) {
    return input->per_buyer_currencies;
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigBuyerCurrencies::DataView input, ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionAdServerResponseConfig::DataView,
                                         ::blink::mojom::blink::AuctionAdServerResponseConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdServerResponseConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdServerResponseConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionAdServerResponseConfig::request_id)& request_id(
      const ::blink::mojom::blink::AuctionAdServerResponseConfigPtr& input) {
    return input->request_id;
  }

  static bool Read(::blink::mojom::blink::AuctionAdServerResponseConfig::DataView input, ::blink::mojom::blink::AuctionAdServerResponseConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionReportBuyerDebugModeConfig::DataView,
                                         ::blink::mojom::blink::AuctionReportBuyerDebugModeConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionReportBuyerDebugModeConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionReportBuyerDebugModeConfigPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AuctionReportBuyerDebugModeConfig::is_enabled) is_enabled(
      const ::blink::mojom::blink::AuctionReportBuyerDebugModeConfigPtr& input) {
    return input->is_enabled;
  }

  static decltype(::blink::mojom::blink::AuctionReportBuyerDebugModeConfig::debug_key) debug_key(
      const ::blink::mojom::blink::AuctionReportBuyerDebugModeConfigPtr& input) {
    return input->debug_key;
  }

  static bool Read(::blink::mojom::blink::AuctionReportBuyerDebugModeConfig::DataView input, ::blink::mojom::blink::AuctionReportBuyerDebugModeConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionReportBuyersConfig::DataView,
                                         ::blink::mojom::blink::AuctionReportBuyersConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionReportBuyersConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionReportBuyersConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionReportBuyersConfig::bucket)& bucket(
      const ::blink::mojom::blink::AuctionReportBuyersConfigPtr& input) {
    return input->bucket;
  }

  static decltype(::blink::mojom::blink::AuctionReportBuyersConfig::scale) scale(
      const ::blink::mojom::blink::AuctionReportBuyersConfigPtr& input) {
    return input->scale;
  }

  static bool Read(::blink::mojom::blink::AuctionReportBuyersConfig::DataView input, ::blink::mojom::blink::AuctionReportBuyersConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionAdConfigNonSharedParams::DataView,
                                         ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::interest_group_buyers)& interest_group_buyers(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->interest_group_buyers;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::auction_signals)& auction_signals(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->auction_signals;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::seller_signals)& seller_signals(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->seller_signals;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::seller_timeout)& seller_timeout(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->seller_timeout;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::per_buyer_signals)& per_buyer_signals(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->per_buyer_signals;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::buyer_timeouts)& buyer_timeouts(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->buyer_timeouts;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::reporting_timeout)& reporting_timeout(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->reporting_timeout;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::seller_currency)& seller_currency(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->seller_currency;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::buyer_currencies)& buyer_currencies(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->buyer_currencies;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::buyer_cumulative_timeouts)& buyer_cumulative_timeouts(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->buyer_cumulative_timeouts;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::per_buyer_group_limits)& per_buyer_group_limits(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->per_buyer_group_limits;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::per_buyer_priority_signals)& per_buyer_priority_signals(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->per_buyer_priority_signals;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::all_buyers_priority_signals)& all_buyers_priority_signals(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->all_buyers_priority_signals;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::all_buyers_group_limit) all_buyers_group_limit(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->all_buyers_group_limit;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::auction_report_buyer_keys)& auction_report_buyer_keys(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->auction_report_buyer_keys;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::auction_report_buyers)& auction_report_buyers(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->auction_report_buyers;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::auction_report_buyer_debug_mode_config)& auction_report_buyer_debug_mode_config(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->auction_report_buyer_debug_mode_config;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::required_seller_capabilities)& required_seller_capabilities(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->required_seller_capabilities;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::requested_size)& requested_size(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->requested_size;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::all_slots_requested_sizes)& all_slots_requested_sizes(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->all_slots_requested_sizes;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::per_buyer_multi_bid_limits)& per_buyer_multi_bid_limits(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->per_buyer_multi_bid_limits;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::all_buyers_multi_bid_limit) all_buyers_multi_bid_limit(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->all_buyers_multi_bid_limit;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::auction_nonce)& auction_nonce(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->auction_nonce;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::seller_real_time_reporting_type) seller_real_time_reporting_type(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->seller_real_time_reporting_type;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::per_buyer_real_time_reporting_types)& per_buyer_real_time_reporting_types(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->per_buyer_real_time_reporting_types;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::component_auctions)& component_auctions(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->component_auctions;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::deprecated_render_url_replacements)& deprecated_render_url_replacements(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->deprecated_render_url_replacements;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::max_trusted_scoring_signals_url_length) max_trusted_scoring_signals_url_length(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->max_trusted_scoring_signals_url_length;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfigNonSharedParams::trusted_scoring_signals_coordinator)& trusted_scoring_signals_coordinator(
      const ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr& input) {
    return input->trusted_scoring_signals_coordinator;
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigNonSharedParams::DataView input, ::blink::mojom::blink::AuctionAdConfigNonSharedParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionAdConfig::DataView,
                                         ::blink::mojom::blink::AuctionAdConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::seller)& seller(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->seller;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::server_response)& server_response(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->server_response;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::decision_logic_url)& decision_logic_url(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->decision_logic_url;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::trusted_scoring_signals_url)& trusted_scoring_signals_url(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->trusted_scoring_signals_url;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::auction_ad_config_non_shared_params)& auction_ad_config_non_shared_params(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->auction_ad_config_non_shared_params;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::direct_from_seller_signals)& direct_from_seller_signals(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->direct_from_seller_signals;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfig::expects_direct_from_seller_signals_header_ad_slot) expects_direct_from_seller_signals_header_ad_slot(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->expects_direct_from_seller_signals_header_ad_slot;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfig::seller_experiment_group_id) seller_experiment_group_id(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->seller_experiment_group_id;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfig::all_buyer_experiment_group_id) all_buyer_experiment_group_id(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->all_buyer_experiment_group_id;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::per_buyer_experiment_group_ids)& per_buyer_experiment_group_ids(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->per_buyer_experiment_group_ids;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfig::expects_additional_bids) expects_additional_bids(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->expects_additional_bids;
  }

  static const decltype(::blink::mojom::blink::AuctionAdConfig::aggregation_coordinator_origin)& aggregation_coordinator_origin(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->aggregation_coordinator_origin;
  }

  static decltype(::blink::mojom::blink::AuctionAdConfig::send_creative_scanning_metadata) send_creative_scanning_metadata(
      const ::blink::mojom::blink::AuctionAdConfigPtr& input) {
    return input->send_creative_scanning_metadata;
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfig::DataView input, ::blink::mojom::blink::AuctionAdConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionDataBuyerConfig::DataView,
                                         ::blink::mojom::blink::AuctionDataBuyerConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionDataBuyerConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionDataBuyerConfigPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AuctionDataBuyerConfig::target_size) target_size(
      const ::blink::mojom::blink::AuctionDataBuyerConfigPtr& input) {
    return input->target_size;
  }

  static bool Read(::blink::mojom::blink::AuctionDataBuyerConfig::DataView input, ::blink::mojom::blink::AuctionDataBuyerConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AuctionDataConfig::DataView,
                                         ::blink::mojom::blink::AuctionDataConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionDataConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionDataConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AuctionDataConfig::per_buyer_configs)& per_buyer_configs(
      const ::blink::mojom::blink::AuctionDataConfigPtr& input) {
    return input->per_buyer_configs;
  }

  static decltype(::blink::mojom::blink::AuctionDataConfig::request_size) request_size(
      const ::blink::mojom::blink::AuctionDataConfigPtr& input) {
    return input->request_size;
  }

  static bool Read(::blink::mojom::blink::AuctionDataConfig::DataView input, ::blink::mojom::blink::AuctionDataConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdAuctionPerSellerRequest::DataView,
                                         ::blink::mojom::blink::AdAuctionPerSellerRequestPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdAuctionPerSellerRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdAuctionPerSellerRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AdAuctionPerSellerRequest::seller)& seller(
      const ::blink::mojom::blink::AdAuctionPerSellerRequestPtr& input) {
    return input->seller;
  }

  static  decltype(::blink::mojom::blink::AdAuctionPerSellerRequest::data)& data(
       ::blink::mojom::blink::AdAuctionPerSellerRequestPtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::blink::AdAuctionPerSellerRequest::DataView input, ::blink::mojom::blink::AdAuctionPerSellerRequestPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigMaybePromiseJson::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigMaybePromiseJson::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr& input) {
    return input->which();
  }

  static  uint32_t promise(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr& input) {
    return input->get_promise();
  }

  static const WTF::String& value(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigMaybePromiseJson::DataView input, ::blink::mojom::blink::AuctionAdConfigMaybePromiseJsonPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignals::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignals::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr& input) {
    return input->which();
  }

  static  uint32_t promise(const ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr& input) {
    return input->get_promise();
  }

  static const std::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>& value(const ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignals::DataView input, ::blink::mojom::blink::AuctionAdConfigMaybePromisePerBuyerSignalsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeouts::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeouts::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr& input) {
    return input->which();
  }

  static  uint32_t promise(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr& input) {
    return input->get_promise();
  }

  static const ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr& value(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeouts::DataView input, ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrencies::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrencies::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr& input) {
    return input->which();
  }

  static  uint32_t promise(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr& input) {
    return input->get_promise();
  }

  static const ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr& value(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrencies::DataView input, ::blink::mojom::blink::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignals::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignals::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr& input) {
    return input->which();
  }

  static  uint32_t promise(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr& input) {
    return input->get_promise();
  }

  static const ::blink::mojom::blink::DirectFromSellerSignalsPtr& value(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignals::DataView input, ::blink::mojom::blink::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr& input) {
    return input->which();
  }

  static  uint32_t promise(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr& input) {
    return input->get_promise();
  }

  static const WTF::Vector<::blink::mojom::blink::AdKeywordReplacementPtr>& value(const ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DataView input, ::blink::mojom::blink::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AdAuctionRequestOrError::DataView,
                                        ::blink::mojom::blink::AdAuctionRequestOrErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdAuctionRequestOrErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdAuctionRequestOrErrorPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AdAuctionRequestOrError::Tag GetTag(const ::blink::mojom::blink::AdAuctionRequestOrErrorPtr& input) {
    return input->which();
  }

  static  ::mojo_base::BigBuffer& request( ::blink::mojom::blink::AdAuctionRequestOrErrorPtr& input) {
    return input->get_request();
  }

  static const WTF::String& error(const ::blink::mojom::blink::AdAuctionRequestOrErrorPtr& input) {
    return input->get_error();
  }

  static bool Read(::blink::mojom::blink::AdAuctionRequestOrError::DataView input, ::blink::mojom::blink::AdAuctionRequestOrErrorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_BLINK_H_