// third_party/blink/public/mojom/input/touch_event.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/touch_event.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink::mojom {
class TouchEventConsumersDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::TouchEventConsumersDataView> {
  using Data = ::blink::mojom::internal::TouchEventConsumers_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class TouchState : int32_t {
  
  kStateUndefined = 0,
  
  kStateReleased = 1,
  
  kStatePressed = 2,
  
  kStateMoved = 3,
  
  kStateStationary = 4,
  
  kStateCancelled = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, TouchState value);
inline bool IsKnownEnumValue(TouchState value) {
  return internal::TouchState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TouchEventConsumersDataView {
 public:
  TouchEventConsumersDataView() = default;

  TouchEventConsumersDataView(
      internal::TouchEventConsumers_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_touch_event_handlers() const {
    return data_->has_touch_event_handlers;
  }
  bool has_hit_testable_scrollbar() const {
    return data_->has_hit_testable_scrollbar;
  }
 private:
  internal::TouchEventConsumers_Data* data_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::TouchState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::TouchState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::TouchState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::TouchState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchEventConsumersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchEventConsumersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TouchEventConsumers_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->has_touch_event_handlers = Traits::has_touch_event_handlers(input);
    fragment->has_hit_testable_scrollbar = Traits::has_hit_testable_scrollbar(input);
  }

  static bool Deserialize(::blink::mojom::internal::TouchEventConsumers_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchEventConsumersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {




}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::TouchState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::TouchState value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_SHARED_H_